package com.bokesoft.yes.design.setting.util;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.io.TreeNode;
import com.bokesoft.yes.design.resolver.DesignSettingMetaResolver;
import com.bokesoft.yes.design.setting.impl.HandleSettingImpl;
import com.bokesoft.yes.design.xml.node.AbstractNode;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.meta.persist.dom.DomMetaConstants;
import com.bokesoft.yes.meta.persist.dom.enhance.MetaEnhanceLoad;
import com.bokesoft.yes.meta.persist.dom.enhance.MetaEnhanceSave;
import com.bokesoft.yes.meta.persist.dom.parameter.MetaParameterLoad;
import com.bokesoft.yes.meta.persist.dom.parameter.MetaParameterSave;
import com.bokesoft.yes.meta.persist.dom.paratable.MetaParaTableLoad;
import com.bokesoft.yes.struct.abstractdatatable.RowState;
import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.enhance.MetaEnhance;
import com.bokesoft.yigo.meta.factory.DefaultMetaResolverFactory;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.IMetaResolverFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.parameter.MetaParameter;
import com.bokesoft.yigo.meta.parameter.MetaParameterID;
import com.bokesoft.yigo.meta.paratable.MetaParaGroup;
import com.bokesoft.yigo.meta.paratable.MetaParaTable;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import org.apache.commons.lang3.StringUtils;

import java.util.Iterator;
import java.util.List;

public class ParameterOperUtil extends HandleSettingImpl {
    @Override
    public void reload(String filePath) throws Throwable {
        String projectKey = LoadFileTree.getProjectKey(filePath);
        TreeNode treeNode = LoadFileTree.getTreeNode(filePath);
        String solutionKey = treeNode.solutionKey;
//        boolean isVest = new File(filePath).getName().endsWith("Vest.xml");
//        if (isVest){
//            reloadParaTableVest(projectKey, solutionKey);
//        } else {
            reloadParameter(projectKey, solutionKey);
//        }
    }
    @Override
    public void saveXml(XmlTreeWithPath xmlTree, TagNode rootNode, Diff diff, JSONObject jsonObject) throws Throwable {
//        SettingCommonUtils.saveXml(diff.getXmlTree(), diff.getXmlTree().xmlTree.getRoot(), diff, jsonObject);
        String xml = genFinalXML(xmlTree, rootNode, diff, jsonObject);
        String filePath = diff.getFilePath();
        org.w3c.dom.Document document = DomHelper.createDocument(xml);
        MetaParameterLoad enhanceLoad = new MetaParameterLoad(AppRunType.App);
        enhanceLoad.load(document);
        MetaParameter enhance = (MetaParameter) enhanceLoad.getRootMetaObject();
        DesignSettingMetaResolver designSettingMetaResolver = new DesignSettingMetaResolver();
        (new MetaParameterSave(enhance)).save(designSettingMetaResolver, filePath);
    }

    @Override
    public void dealData(Document document, Diff diff, JSONObject jsonObject) throws Throwable {
        XmlTreeWithPath xmlTree = diff.getXmlTree();
        TagNode tagNode = xmlTree.xmlTree.getRoot();
        // 从当前表单的document中获取
        DataTable D_Parameter = document.get(ConstantUtil.ED_Parameter);
        tagNode.getChildren().clear();
        dealParameterList(D_Parameter, tagNode);

    }

    public void reloadParameter(String ProjectKey, String solutionKey ) throws Throwable {
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        String key = metaFactory.getSolution().getKey();
        if (ProjectKey.isEmpty() && !key.equals(solutionKey)){//跨solution
            MetaParameter parameter = metaFactory.getParameter();


            String solutionPath = LoadFileTree.getSolutionPath(solutionKey);
            IMetaResolverFactory metaResolverFactory = new DefaultMetaResolverFactory(solutionPath);
            IMetaResolver iMetaResolver = metaResolverFactory.newMetaResolver("");
            MetaParameterLoad metaParameterLoad = new MetaParameterLoad(AppRunType.App);
            metaParameterLoad.load(iMetaResolver, "Parameter.xml");
            MetaParameter metaParameterIDS = (MetaParameter) metaParameterLoad.getRootMetaObject();
            //添加参数ID
            for (MetaParameterID metaParameterID : metaParameterIDS) {
                metaParameterID.setSolution(solutionKey);
                String key1 = metaParameterID.getKey();
                if ( parameter.containsKey(key1) && !parameter.get(key1).getSolution().equals(solutionKey)){
                    throw new RuntimeException("参数ID重复定义" + metaParameterID.getKey()+" "+ metaParameterID.getDescription());
//                    throw new MetaException(MetaException.REPEAT_PARA_GROUP_DEFINED, SimpleStringFormat.format(StringTable.getString(null, "", StringTable.RepeatParaGroupDefined), key1));
                } else {
                    parameter.add(metaParameterID);
                }
            }
        } else {
            if (StringUtils.isEmpty(ProjectKey)) {
                String solutionPath = metaFactory.getSolutionPath();
                IMetaResolverFactory metaResolverFactory = new DefaultMetaResolverFactory(solutionPath);
                IMetaResolver iMetaResolver = metaResolverFactory.newMetaResolver("");
                MetaParameterLoad metaParameterLoad = new MetaParameterLoad(AppRunType.App);
                metaParameterLoad.load(iMetaResolver, "Parameter.xml");
                MetaParameter metaParameterIDS = (MetaParameter) metaParameterLoad.getRootMetaObject();
                MetaParameter parameter = metaFactory.getParameter();
                //添加参数ID
                for (MetaParameterID metaParameterID : metaParameterIDS) {
                    metaParameterID.setSolution(solutionKey);
                    String key1 = metaParameterID.getKey();
                    if ( parameter.containsKey(key1) && !parameter.get(key1).getSolution().equals(solutionKey)){
                        throw new RuntimeException("参数ID重复定义" + metaParameterID.getKey()+" "+ metaParameterID.getDescription());
//                    throw new MetaException(MetaException.REPEAT_PARA_GROUP_DEFINED, SimpleStringFormat.format(StringTable.getString(null, "", StringTable.RepeatParaGroupDefined), key1));
                    } else {
                        parameter.add(metaParameterID);
                    }
                }
            }  else {
                throw new Exception("暂不支持参数表存在于项目中");
            }
        }
    }
    public void reloadParaTableVest(String ProjectKey, String solutionKey ) throws Throwable {
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        String key = metaFactory.getSolution().getKey();
        if (ProjectKey.isEmpty() && !key.equals(solutionKey)){//跨solution
            MetaParaTable paraTable = metaFactory.getParaTable();
            String solutionPath = LoadFileTree.getSolutionPath(solutionKey);
            IMetaResolverFactory metaResolverFactory = new DefaultMetaResolverFactory(solutionPath);
            IMetaResolver iMetaResolver = metaResolverFactory.newMetaResolver("");
            MetaParaTableLoad metaParaTableLoad = new MetaParaTableLoad(AppRunType.App);
            metaParaTableLoad.load(iMetaResolver, DomMetaConstants.PARATABLE_FILE_VEST);
            MetaParaTable metaParaGroups = (MetaParaTable) metaParaTableLoad.getRootMetaObject();
            //添加扩展的参数表
            for (MetaParaGroup metaParaGroup : metaParaGroups) {
                metaParaGroup.setSolution(solutionKey);
                metaParaGroup.setExtend(true);
                String key1 = metaParaGroup.getKey();
                if (paraTable.containsKey(key1)  && paraTable.get(key1).isExtend() && !paraTable.get(key1).getSolution().equals(solutionKey)){
                    throw new MetaException(MetaException.REPEAT_PARA_GROUP_DEFINED, SimpleStringFormat.format(StringTable.getString(null, "", StringTable.RepeatParaGroupDefined), key1));
                }
                if (paraTable.containsKey(key1)){
                    metaParaGroup.merge(paraTable.get(key1));
                    paraTable.add(metaParaGroup);
                } else {
                    paraTable.add(metaParaGroup);
                }
            }
        } else {
            if (StringUtils.isEmpty(ProjectKey)) {
                String solutionPath = metaFactory.getSolutionPath();
                IMetaResolverFactory metaResolverFactory = new DefaultMetaResolverFactory(solutionPath);
                IMetaResolver iMetaResolver = metaResolverFactory.newMetaResolver("");
                MetaParaTableLoad metaParaTableLoad = new MetaParaTableLoad(AppRunType.App);
                metaParaTableLoad.load(iMetaResolver, DomMetaConstants.PARATABLE_FILE_VEST);
                MetaParaTable metaParaGroups = (MetaParaTable) metaParaTableLoad.getRootMetaObject();
                MetaParaTable paraTable = metaFactory.getParaTable();
                //添加扩展的参数表
                for (MetaParaGroup metaParaGroup : metaParaGroups) {
                    metaParaGroup.setSolution(solutionKey);
                    metaParaGroup.setExtend(true);
                    String key1 = metaParaGroup.getKey();
                    if (paraTable.containsKey(key1)  && paraTable.get(key1).isExtend() && !paraTable.get(key1).getSolution().equals(solutionKey)){
                        throw new MetaException(MetaException.REPEAT_PARA_GROUP_DEFINED, SimpleStringFormat.format(StringTable.getString(null, "", StringTable.RepeatParaGroupDefined), key1));
                    }
                    if (paraTable.containsKey(key1)){
                        metaParaGroup.merge(paraTable.get(key1));
                        paraTable.add(metaParaGroup);
                    } else {
                        paraTable.add(metaParaGroup);
                    }
                }
            }  else {
                throw new Exception("暂不支持参数表存在于项目中");
            }
        }
    }


    public void dealParameterList(DataTable d_paraTable, TagNode paraList) {
        for (int j = 0; j < d_paraTable.size(); j++) {
            String key = d_paraTable.getString(j, ConstantUtil.KEY);
            String description = d_paraTable.getString(j, ConstantUtil.DESCRIPTION);
            String refKey = d_paraTable.getString(j, ConstantUtil.REF_KEY);
            int state = d_paraTable.getState(j);
            if (state == RowState.NEW || state == RowState.MODIFIED || state == RowState.NORMAL) {
                TagNode paraGroup = new TagNode(MetaParameterID.TAG_NAME, null);
                paraGroup.setAttribute(ConstantUtil.KEY, key);
                paraGroup.setAttribute(ConstantUtil.DESCRIPTION, description);
                paraGroup.setAttribute(ConstantUtil.REF_KEY, refKey);
                paraList.addNode(paraGroup);
            } else if (state == RowState.DELETED) {
                List<AbstractNode> childrenDelete = paraList.getChildren();
                for (Iterator<AbstractNode> iterator = childrenDelete.iterator(); iterator.hasNext(); ) {
                    AbstractNode dren = iterator.next();
                    if (dren instanceof TagNode) {
                        String chridrenName = ((TagNode) dren).getTagName();
                        if (ConstantUtil.PARA_ITEM.equalsIgnoreCase(chridrenName)
                                && ((TagNode) dren).getAttributes().get(ConstantUtil.KEY).equalsIgnoreCase(key)) {
                            iterator.remove();
                        }
                    }
                }
            }
        }
    }
}
