package com.bokesoft.yes.design.setting.util;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.resolver.DesignSettingMetaResolver;
import com.bokesoft.yes.design.setting.impl.HandleSettingImpl;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.meta.persist.dom.DomMetaConstants;
import com.bokesoft.yes.meta.persist.dom.rights.MetaRightsDefinitionLoad;
import com.bokesoft.yes.meta.persist.dom.rights.MetaRightsDefinitionSave;
import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.factory.DefaultMetaResolverFactory;
import com.bokesoft.yigo.meta.factory.IMetaResolverFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.rights.MetaDictDefinition;
import com.bokesoft.yigo.meta.rights.MetaDictRightsCollection;
import com.bokesoft.yigo.meta.rights.MetaFormDefinition;
import com.bokesoft.yigo.meta.rights.MetaFormRightsCollection;
import com.bokesoft.yigo.meta.rights.MetaRightsDefinition;
import com.bokesoft.yigo.meta.solution.MetaSolution;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import org.apache.commons.lang3.StringUtils;

import java.io.File;
import java.util.Collection;
import java.util.Objects;

public class NoRightsOperJsonUtil extends HandleSettingImpl {
    /**
     * 处理数据对象XML
     */

    public void dealData(Document document, Diff diff, JSONObject jsonObject) throws Throwable {
        XmlTreeWithPath xmlTree = diff.getXmlTree();
        TagNode rootNode = xmlTree.xmlTree.getRoot();
        // 从当前表单的document中获取
        DataTable formRightsDataTable = document.get("ED_FormRights");
        DataTable dictRightsDataTable = document.get("ED_DictRights");
        if (formRightsDataTable.size() > 0) {
            formRightsDataTable.setShowDeleted(true);
        }
        if (dictRightsDataTable.size() > 0) {
            dictRightsDataTable.setShowDeleted(true);
        }
        if (formRightsDataTable.size() == 0) {
            rootNode.deleteChildByTagName(MetaFormRightsCollection.TAG_NAME);
        } else if (isTableChange(formRightsDataTable)) {
            formRightsDataTable.setShowDeleted(false);
            rootNode.deleteChildByTagName(MetaFormRightsCollection.TAG_NAME);
            TagNode formRightsCollection = new TagNode(MetaFormRightsCollection.TAG_NAME, null);
            for (int i = 0; i < formRightsDataTable.size(); i++) {
                TagNode formDefinition = new TagNode(MetaFormDefinition.TAG_NAME, null);
                String formKey = formRightsDataTable.getString(i, "FormKey");
                formDefinition.setAttribute("FormKey", formKey);
                formRightsCollection.addNode(formDefinition);
            }
            rootNode.addNode(formRightsCollection);
        }

        if (dictRightsDataTable.size() == 0) {
            rootNode.deleteChildByTagName(MetaDictRightsCollection.TAG_NAME);
        } else if (isTableChange(dictRightsDataTable)) {
            dictRightsDataTable.setShowDeleted(false);
            rootNode.deleteChildByTagName(MetaDictRightsCollection.TAG_NAME);
            TagNode dictRightsCollection = new TagNode(MetaDictRightsCollection.TAG_NAME, null);
            for (int i = 0; i < dictRightsDataTable.size(); i++) {
                TagNode dictDefinition = new TagNode(MetaDictDefinition.TAG_NAME, null);
                String dictKey = dictRightsDataTable.getString(i, "DictKey");
                dictDefinition.setAttribute("ItemKey", dictKey);
                dictRightsCollection.addNode(dictDefinition);
            }
            rootNode.addNode(dictRightsCollection);
        }
    }


    public void reload(String path) throws Exception {
        String solutionPath = StringUtils.substringBeforeLast(path, File.separator);
        MetaRightsDefinition metaRightsDefinition;
        String coreSolutionDir = "erp-solution-core";
        String coreSolutionPath = StringUtils.substringBeforeLast(solutionPath, File.separator) + File.separator + coreSolutionDir;
        // 主配置
        IMetaResolverFactory metaResolverFactory = new DefaultMetaResolverFactory(coreSolutionPath);
        metaRightsDefinition = loadNoRights(metaResolverFactory);

        // 非主配置
        Collection<MetaSolution> metaSolutions = MetaFactory.getGlobalInstance().getMetaSolutions();
        for (MetaSolution solution : metaSolutions) {
            IMetaResolverFactory resolverFactory = MetaFactory.getGlobalInstance().getMetaResolverFactoryBySolution(solution.getKey());
            if (Objects.isNull(resolverFactory)) {
                continue;
            }
            MetaRightsDefinition rightsDefinition = loadNoRights(resolverFactory);
            metaRightsDefinition = metaRightsDefinition.toMerge(rightsDefinition);
        }
        MetaFactory.getGlobalInstance().setRightsDefinition(metaRightsDefinition);
    }

    private MetaRightsDefinition loadNoRights(IMetaResolverFactory metaResolverFactory) throws Exception {
        IMetaResolver solutionResourceResolver = metaResolverFactory.newMetaResolver("");
        MetaRightsDefinitionLoad rightsDefinitionLoad = new MetaRightsDefinitionLoad(AppRunType.App);
        rightsDefinitionLoad.load(solutionResourceResolver, DomMetaConstants.RIGHTS_FILE);
        MetaRightsDefinition rightsDefinition = (MetaRightsDefinition) rightsDefinitionLoad.getRootMetaObject();
        if (rightsDefinition != null) {
            rightsDefinition.doPostProcess(0, null);
        }
        return rightsDefinition;
    }

    @Override
    public void saveXml(XmlTreeWithPath xmlTree, TagNode rootNode, Diff diff, JSONObject jsonObject) throws Throwable {
//        SettingCommonUtils.saveXml(diff.getXmlTree(), diff.getXmlTree().xmlTree.getRoot(), diff, jsonObject);
        String xml = genFinalXML(xmlTree, rootNode, diff, jsonObject);
        String filePath = diff.getFilePath();
        org.w3c.dom.Document document = DomHelper.createDocument(xml);
        MetaRightsDefinitionLoad rightsDefinitionLoad = new MetaRightsDefinitionLoad(AppRunType.App);
        rightsDefinitionLoad.load(document);
        MetaRightsDefinition rightsDefinition = (MetaRightsDefinition) rightsDefinitionLoad.getRootMetaObject();
        DesignSettingMetaResolver designSettingMetaResolver = new DesignSettingMetaResolver();
        (new MetaRightsDefinitionSave(rightsDefinition)).save(designSettingMetaResolver, filePath);
    }
}
