package com.bokesoft.yes.design.setting.util;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.setting.impl.HandleSettingImpl;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yigo.meta.iosetting.MetaIOObject;
import com.bokesoft.yigo.meta.iosetting.MetaPersist;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import org.apache.commons.lang3.StringUtils;

public class IOSettingOperUtil extends HandleSettingImpl {

    @Override
    public void reload(String filePath) throws Exception {

    }

    @Override
    public void saveXml(XmlTreeWithPath xmlTree, TagNode rootNode, Diff diff, JSONObject jsonObject) throws Throwable {
        SettingCommonUtils.saveXml(diff.getXmlTree(), diff.getXmlTree().xmlTree.getRoot(), diff, jsonObject);
    }

    public void dealData(Document document, Diff diff, JSONObject jsonObject) throws Throwable {
        XmlTreeWithPath xmlTree = diff.getXmlTree();
        TagNode rootNode = xmlTree.xmlTree.getRoot();
        // 从当前表单的document中获取表格数据
        DataTable ioSettingHeadDataTable = document.get("ED_IOSettingHead");
        DataTable ioSettingDetailDataTable = document.get("ED_IOSettingDetail");
        ioSettingDetailDataTable.setShowDeleted(true);
        if (isTableChange(ioSettingHeadDataTable)) {
            TagNode persistNode = rootNode.getOrCreateChildByTagName(MetaPersist.TAG_NAME);
            String defaultProvider = ioSettingHeadDataTable.getString(0, "DefaultProvider");
            if (StringUtils.isNotEmpty(defaultProvider)) {
                persistNode.setAttribute("DefaultProvider", defaultProvider);
            } else {
                persistNode.deleteAttribute("DefaultProvider");
            }
        }
        if (isTableChange(ioSettingDetailDataTable)) {
            ioSettingDetailDataTable.setShowDeleted(false);
            TagNode persistNode = rootNode.getOrCreateChildByTagName(MetaPersist.TAG_NAME);
            persistNode.deleteChildByTagName(MetaIOObject.TAG_NAME);
            String key;
            String provider;
            for (int i = 0; i < ioSettingDetailDataTable.size(); i++) {
                key = ioSettingDetailDataTable.getString(i, "ProviderKey");
                provider = ioSettingDetailDataTable.getString(i, "IOProvider");
                TagNode ioObjectNode = new TagNode(MetaIOObject.TAG_NAME, null);
                ioObjectNode.setAttribute("Key", key);
                ioObjectNode.setAttribute("ProviderKey", provider);
                persistNode.addNode(ioObjectNode);
            }
        }
    }

}
