package com.bokesoft.yes.design.setting.util;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.io.TreeNode;
import com.bokesoft.yes.design.resolver.DesignSettingMetaResolver;
import com.bokesoft.yes.design.setting.impl.HandleSettingImpl;
import com.bokesoft.yes.design.utils.DesignReloadMetaObject;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.erp.config.ERPDataElementInit;
import com.bokesoft.yes.erp.config.ERPDomainInit;
import com.bokesoft.yes.helper.DataObjectHelper;
import com.bokesoft.yes.meta.persist.dom.commondef.MetaDataElementDefLoad;
import com.bokesoft.yes.meta.persist.dom.commondef.MetaDataElementDefSave;
import com.bokesoft.yes.struct.abstractdatatable.RowState;
import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.common.def.SystemField;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.common.MetaFieldLabel;
import com.bokesoft.yigo.meta.common.MetaFieldLabelCollection;
import com.bokesoft.yigo.meta.dataelement.MetaDataElement;
import com.bokesoft.yigo.meta.dataelement.MetaDataElementCollection;
import com.bokesoft.yigo.meta.dataelement.MetaDataElementDef;
import com.bokesoft.yigo.meta.domain.MetaDomain;
import com.bokesoft.yigo.meta.domain.MetaDomainDef;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.IMetaResolverFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.meta.solution.MetaSolution;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import org.apache.commons.lang3.StringUtils;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public class DataElementDefOperJsonUtil extends HandleSettingImpl {


    @Override
    public void reload(String filePath) throws Throwable {
        String projectKey = LoadFileTree.getProjectKey(filePath);
        TreeNode treeNode = LoadFileTree.getTreeNode(filePath);
        if (StringUtils.isEmpty(projectKey)) {
            String solutionKey = treeNode.solutionKey;
            IMetaResolverFactory metaResolverFactoryBySolution = MetaFactory.getGlobalInstance().getMetaResolverFactoryBySolution(solutionKey);
            IMetaResolver iMetaResolver = metaResolverFactoryBySolution.newMetaResolver("");
            String solutionPath = LoadFileTree.getSolutionPath(solutionKey);
            String fileRelationPath = StringUtils.replace(filePath, solutionPath+ File.separator,"");
            MetaDataElementDef metaDataElementDef = MetaUtil.loadDataElementDef(MetaFactory.getGlobalInstance(), iMetaResolver, solutionKey, null, fileRelationPath);
            reloadMetaDataElement(solutionKey, metaDataElementDef);
        }
    }

    private static void reloadMetaDataElement(String solutionKey, MetaDataElementDef metaDataElementDef) throws Throwable {
        IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
        MetaDataElementDef metaDataElement = MetaUtil.loadDataElementDef(globalInstance, solutionKey);
        // 存储dataElementDef
        globalInstance.getSolutionDataElementDefMap().put(solutionKey, metaDataElement);

        //这里更新主
        globalInstance.reloadDataElementDef();
        MetaDataElementDef elementDef = globalInstance.getDataElementDef();
        ERPDataElementInit.initSystemDataElement(globalInstance,solutionKey,elementDef.getDataElementCollection());
        globalInstance.getSolutionDataElementDefMap().forEach((key,element)->{
            elementDef.toMerge(element);
        });

        LinkedHashSet<AbstractMetaObject> abstractMetaObjects = MetaUtil.reloadMetaDataElement(MetaFactory.getGlobalInstance(), metaDataElementDef);
        for (AbstractMetaObject abstractMetaObject : abstractMetaObjects) {
            if (abstractMetaObject instanceof MetaFormProfile) {
                MetaFormProfile metaObject = (MetaFormProfile) abstractMetaObject;
                MetaForm form = metaObject.getForm();
               try {
                   String refObjectKey = form.getDataSource().getRefObjectKey();
                   if (StringUtils.isNotEmpty(refObjectKey)){
                       String pathByDataObject = LoadFileTree.getPathByDataObject(refObjectKey);
                       DataObjectHelper.reload(null,refObjectKey, pathByDataObject, null);
                   }else {
                       DesignReloadMetaObject.reloadMetaFormRollbackError(null,metaObject.getKey());
                   }
               }catch (Throwable e){
                   System.out.println(metaObject.getKey() + "重新加载失败");

               }

            }
        }
    }

    @Override
    public void dealData(Document document, Diff diff, JSONObject jsonObject) throws Throwable {
        XmlTreeWithPath xmlTree = diff.getXmlTree();
        TagNode rootNode = xmlTree.xmlTree.getRoot();
        // 从当前表单的document中获取表格数据
        DataTable edFieldLabelCollection = document.get("ED_FieldLabelCollection");
        DataTable edDataElementDef = document.get("ED_DataElementDef");
        edDataElementDef.setShowDeleted(true);
        TagNode dataElementCollectionNode = rootNode.getOrCreateChildByTagName(MetaDataElementCollection.TAG_NAME);
        dataElementCollectionNode.deleteChildByTagName(MetaDataElement.TAG_NAME);
        List<String> dataElementKeyList = new ArrayList();
        for (int i = 0; i < edDataElementDef.size(); i++) {
            if(edDataElementDef.getState(i) == RowState.DELETED || edDataElementDef.getState(i) == RowState.MODIFIED ){
                TreeNode treeNode = LoadFileTree.getTreeNode(diff.filePath);
                String solutionKey = treeNode.solutionKey;
                MetaDataElementCollection domainCollection = MetaFactory.getGlobalInstance().getDataElementDef(solutionKey).getDataElementCollection();
                String domainKey = edDataElementDef.getString(i, ConstantUtil.KEY);
                if(domainCollection != null && domainCollection.containsKey(domainKey)){
                    domainCollection.remove(domainKey);
                }
                if(edDataElementDef.getState(i) == RowState.DELETED) {
                    continue;
                }
            }
            String key = edDataElementDef.getString(i, ConstantUtil.KEY);
            if(dataElementKeyList.contains(key)){
                throw new RuntimeException("存在重复的数据元素标识：" + key);
            }
            dataElementKeyList.add(key);
            String oid = String.valueOf(edDataElementDef.getLong(i, SystemField.OID_SYS_KEY));
            String caption = edDataElementDef.getString(i, "Caption");
            String domainKey = edDataElementDef.getString(i, "DomainKey");
            String dataType = edDataElementDef.getString(i, "DataType");
            Integer precision = edDataElementDef.getInt(i, "Precision");
            Integer scale = edDataElementDef.getInt(i, "Scale");
            Integer length = edDataElementDef.getInt(i, "Length");
            String paramID = edDataElementDef.getString(i, "ParamID");
            String defaultCaption = edDataElementDef.getString(i, "DefaultCaption");
            String dataDiffLog = StringUtils.defaultIfEmpty(edDataElementDef.getString(i, "DataDiffLog"), "false");
            String noHistory = StringUtils.defaultIfEmpty(edDataElementDef.getString(i, "NoHistory"), "false");
            TagNode dataElementNode = new TagNode(MetaDataElement.TAG_NAME, null);
            dataElementCollectionNode.addNode(dataElementNode);
            dataElementNode.setAttribute("Key", key);
            dataElementNode.setAttribute("Caption", caption);
            dataElementNode.setAttribute("DomainKey", domainKey);
            if (StringUtils.isNotEmpty(domainKey)){
                MetaDomain domain = MetaUtil.getDomain(MetaFactory.getGlobalInstance(), domainKey);
                if (domain == null) {
                    throw new RuntimeException(domainKey + " domain is not exist");
                }
            } else {
                dataElementNode.setAttribute("DataType", dataType);
                dataElementNode.setAttribute("Precision", precision.toString(), "0");
                dataElementNode.setAttribute("Scale", scale.toString(), "0");
                dataElementNode.setAttribute("Length", length.toString(), "0");
            }
            dataElementNode.setAttribute("ParamID", paramID);
            dataElementNode.setAttribute("DefaultCaption", defaultCaption);
            dataElementNode.setAttribute("DataDiffLog", dataDiffLog, "false");
            dataElementNode.setAttribute("NoHistory", noHistory, "false");
            TagNode fieldLabelCollection = dataElementNode.getChildByTagName(MetaFieldLabelCollection.TAG_NAME);
            if (fieldLabelCollection != null) {
                fieldLabelCollection.deleteChildByTagName(MetaFieldLabel.TAG_NAME);

            }
            for (int j = 0; j < edFieldLabelCollection.size(); j++) {
                String subOid = String.valueOf(edFieldLabelCollection.getLong(j, SystemField.POID_SYS_KEY));
                if (!oid.equalsIgnoreCase(subOid)) {
                    continue;
                }
                fieldLabelCollection = dataElementNode.getOrCreateChildByTagName(MetaFieldLabelCollection.TAG_NAME);
                String key1 = edFieldLabelCollection.getString(j, ConstantUtil.KEY);
                String length1 = edFieldLabelCollection.getString(j, "Length");
                String text = edFieldLabelCollection.getString(j, "Text");
                TagNode fieldLabel = new TagNode(MetaFieldLabel.TAG_NAME, null);
                fieldLabelCollection.addNode(fieldLabel);
                fieldLabel.setAttribute("Key", key1);
                fieldLabel.setAttribute("Length", length1, "0");
                fieldLabel.setAttribute("Text", text);
            }
        }
    }
    @Override
    public void saveXml(XmlTreeWithPath xmlTree, TagNode rootNode, Diff diff, JSONObject jsonObject) throws Throwable {
//        SettingCommonUtils.saveXml(diff.getXmlTree(), diff.getXmlTree().xmlTree.getRoot(), diff, jsonObject);
        String xml = genFinalXML(xmlTree, rootNode, diff, jsonObject);
        String filePath = diff.getFilePath();
        org.w3c.dom.Document document = DomHelper.createDocument(xml);
        MetaDataElementDefLoad dataElementDefLoad = new MetaDataElementDefLoad(AppRunType.App);
        dataElementDefLoad.load(document);
        MetaDataElementDef dataElementDef = (MetaDataElementDef) dataElementDefLoad.getRootMetaObject();
        DesignSettingMetaResolver designSettingMetaResolver = new DesignSettingMetaResolver();
        (new MetaDataElementDefSave(dataElementDef)).save(designSettingMetaResolver, filePath);
    }
}
