package com.bokesoft.yes.design.setting.impl;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.cmd.CheckXMLChanged;
import com.bokesoft.yes.design.cmd.CommitDiffCmd;
import com.bokesoft.yes.design.cmd.XmlDiffProcessor;
import com.bokesoft.yes.design.cmd.UICommand;
import com.bokesoft.yes.design.setting.util.SettingCommonUtils;
import com.bokesoft.yes.design.vo.ResponseResult;
import com.bokesoft.yes.design.vo.SettingVo;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.helper.DocumentHelper;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.struct.abstractdatatable.RowState;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import org.apache.commons.io.FileUtils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public abstract class HandleSettingImpl implements HandleSettingService {

    public boolean isTableChange(DataTable dataTable) {
        for (int i = 0; i < dataTable.size(); i++) {
            if (dataTable.getState(i) != RowState.NORMAL) {
                return true;
            }
        }
        return false;
    }
    /**
     * 处理数据对象XML
     */
    public ResponseResult<JSONObject> handleData(SettingVo settingVo) throws Throwable {
        ResponseResult<JSONObject> result = new ResponseResult<>();
        JSONObject jsonObject = new JSONObject();
        //处理document数据
        Document document = getDocument(settingVo);
        //处理diffs数据
        String diffJsonString = settingVo.getDiff();
        List<Diff> diffs = SettingCommonUtils.getDiffsByJson(diffJsonString);
        // 载入SettingXmlTree
        String type = settingVo.getType();
        CommitDiffCmd.loadXmlTrees(diffs, "", "D_" + type);
        for (Diff diff : diffs) {
            // 处理数据
            dealData(document, diff, jsonObject);
            // 保存文件
            String oldXml = SettingCommonUtils.saveXml(diff.getXmlTree(), diff.getXmlTree().xmlTree.getRoot(), diff, jsonObject);
            try {
            reload(diff.getFilePath());
            //重新用对象写入
            saveXml(diff.getXmlTree(), diff.getXmlTree().xmlTree.getRoot(), diff, jsonObject);
            } catch (Exception e) {
                //报错后还原之前的xml
                FileUtils.writeStringToFile(new File(diff.getFilePath()),oldXml, "UTF-8");
                reload(diff.getFilePath());
                throw new RuntimeException(e.getMessage());
        }
            List<UICommand> uiCommands = getUiCommands(diff);
            uiCommands.add(UICommand.showTip("操作成功"));
            jsonObject.put("UICommand",uiCommands);
        }

        result.setCode(0);
        result.setMsg("操作" + type + "成功");
        jsonObject.put("msg", "操作" + type + "成功");

        result.setData(jsonObject);
        return result;
    }
    public  List<UICommand> getUiCommands(Diff diff) {
        List<UICommand> result1 = new ArrayList<>();
        result1.add(UICommand.reloadXmlSource(diff.getFilePath()));
        return result1;
    }
    public String genFinalXML(XmlTreeWithPath xmlTree, TagNode rootNode, Diff diff, JSONObject jsonObject){
        String filePath = diff.getFilePath();
        XmlDiffProcessor.genXmlDiff(xmlTree, rootNode, diff, true);
        String xml = xmlTree.xmlTree.getOrgXml();
        String orgXmlFragment = diff.getOrgXmlFragment();
        String newXmlFragment = diff.getNewXmlFragment();
        boolean insertIndent = diff.isPropertyDiff() && !diff.isGridColumnDrag();
        xml = CheckXMLChanged.mergeXML(xml, diff.getStartLine(), orgXmlFragment, newXmlFragment, null, insertIndent);
        if (diff.getNewXmlFragment()!=null){
            jsonObject.put("newXml",  diff.getNewXmlFragment());
        }else {
            jsonObject.put("newXml", xmlTree.xmlTree.getOrgXml());
        }
        jsonObject.put("xmlPath", StringUtil.isBlankOrNull(filePath) ? filePath : FilePathHelper.toFrontFilePath(filePath));
        return xml;
    }
    protected static Document getDocument(SettingVo settingVo) throws Throwable {
        String docStr = settingVo.getDocument();
        Document document = DocumentHelper.parseDocumentFormJSON(docStr);
        return document;
    }

}
