package com.bokesoft.yes.design.search.text;

import java.io.File;

/**
 * 匹配的文件(由于设计器打开文件时需要一些参数)
 */
public class FileMatchResource {

	/** 应用路径 */
	private File sfile;
	
	/** 文件路径 */
	private File file;
	
	/** 文件类型 */
	private String fType;

	public FileMatchResource(File sfile, File file, String fileType) {
		this.sfile = sfile;
		this.file = file;
		this.fType = fileType;
	}
	
	public File getFile() {
		return file;
	}

	public void setFile(File file) {
		this.file = file;
	}
	
	public String getFileType() {
		return fType;
	}

	public String getFileSolutionPath() {
		return file.getAbsolutePath().replace(sfile.getAbsolutePath(), "");
	}

	@Override
	public boolean equals(Object obj) {
		return file.equals(obj);
	}

	@Override
	public int hashCode() {
		return file.hashCode();
	}
	
	
}
