package com.bokesoft.yes.design.search;

import java.util.regex.Pattern;

public abstract class TextSearchEngine {

	public static TextSearchEngine createDefault() {
		return new TextSearchEngine() {

			@Override
			public boolean search(TextSearchRequestor requestor, Pattern searchPattern) {
				return new TextSearchVisitor(requestor, searchPattern).search();
			}

		};
	}

	public abstract boolean search(TextSearchRequestor requestor, Pattern searchPattern);

}
