package com.bokesoft.yes.design.process;

import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.cmd.NewFormCmd;
import com.bokesoft.yes.design.cmd.XmlDiffProcessor;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.function.DesignActionUtil;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.design.utils.WebDesignerDataTableUtil;
import com.bokesoft.yes.design.xml.node.AbstractNode;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.struct.abstractdatatable.RowState;
import com.bokesoft.yes.struct.datatable.Row;
import com.bokesoft.yigo.common.def.*;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.MetaDict;
import com.bokesoft.yigo.meta.form.component.control.MetaDynamicDict;
import com.bokesoft.yigo.meta.form.component.control.dictview.MetaDictView;
import com.bokesoft.yigo.meta.form.component.control.properties.*;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 字典过滤条件处理
 * TODO 后续优化   这个方法可以在抽成类似平台的 XXXAction， 只有保存和加载的方法
 *
 * @author lansz
 */
public class MetaItemFilterProcess {

    /**
     * 加载字典过滤头表
     */
    public static void loadDictFilteringHead(DefaultContext context, Document doc, DataTable dataTable, MetaForm ownerMetaForm, String itemKey1, String dictType, MetaForm containerForm, MetaTableCollection tableCollection) throws Throwable {
        // 非表格中字典
        Result result = getResult(ownerMetaForm, itemKey1, dictType, containerForm);
        Result resultExt = new Result(null,null,null);
        boolean isExt = StringUtils.isNotEmpty(ownerMetaForm.getExtend());
        if (isExt){
            MetaForm ownerMetaFormExt = NewFormCmd.loadMetaForm(ownerMetaForm.getExtend());
            MetaForm containerFormExt = null;
            if (containerForm != null){
                containerFormExt = NewFormCmd.loadMetaForm(containerForm.getExtend());
            }
            resultExt = getResult(ownerMetaFormExt, itemKey1, dictType, containerFormExt);
        } else {
            MetaForm ownerMetaFormExt = NewFormCmd.loadMetaForm(ownerMetaForm.getKey());
            MetaForm containerFormExt = null;
            if (containerForm != null){
                containerFormExt = NewFormCmd.loadMetaForm(containerForm.getKey());
            }
            resultExt = getResult(ownerMetaFormExt, itemKey1, dictType, containerFormExt);
        }
        // 明细数据
        MetaTable metaTableDtl = tableCollection.get(ConstantUtil.ED_DICT_FILTER_VALUE);
        DataTable dataTableDtl = WebDesignerDataTableUtil.generateDataTable(metaTableDtl);
        MetaTable metaTableItem = tableCollection.get(ConstantUtil.ED_DICTITEM);
        DataTable dataTable1 = WebDesignerDataTableUtil.generateDataTable(metaTableItem);
        int append = dataTable1.append();
        if (!result.isDyn) {
            dataTable1.setString(append, "BindingItemKey", result.itemKey);
        } else {
            dataTable1.setString(append, "BindingItemKey", "Dynamic");
        }
        context.setPara("D_ItemKey", result.itemKey);
        dataTable1.batchUpdate();
        if (result.metaItemFilterCollection != null) {
            for (MetaItemFilter metaItemFilter : result.metaItemFilterCollection) {
                for (MetaFilter metaFilter : metaItemFilter) {
                    Long applyNewOID = context.applyNewOID();
                    int rowIndex = dataTable.append();
                    // 当Type不设置的时候为-1，使用老版设计器才可能出现
                    int type = metaFilter.getType();
                    if (type == -1) {
                        // 默认类型为自定义类型type=3 当Type不设置的时候为-1，使用老版设计器才可能出现
                        dataTable.setInt(rowIndex, ConstantUtil.TYPE, DictFilterType.Custom);
                    } else {
                        dataTable.setInt(rowIndex, ConstantUtil.TYPE, type);
                    }
                    // 对应数据集类型
                    dataTable.setLong(rowIndex, ConstantUtil.OID, applyNewOID);
                    dataTable.setInt(rowIndex, "OperatorSign", metaFilter.getOp());
                    dataTable.setString(rowIndex, "ImplClass", metaFilter.getImpl());
                    dataTable.setString(rowIndex, "Query", metaFilter.getQuery());
                    dataTable.setString(rowIndex, "ItemKey", metaItemFilter.getItemKey());
                    dataTable.setString(rowIndex, "FilterDependency", metaFilter.getFilterDependency());
                    dataTable.setString(rowIndex, "Condition", metaFilter.getCondition());
                    dataTable.setString(rowIndex, "FilterKey", metaFilter.getKey());
                    if (resultExt.metaItemFilterCollection!=null){
                        if (resultExt.metaItemFilterCollection.get(metaItemFilter.getKey()) !=null){
                            dataTable.setInt(rowIndex, "ExtendItemFilterFlag", isExt?1:0);
                            MetaItemFilter metaItemFilterExt = resultExt.metaItemFilterCollection.get(metaItemFilter.getKey());
                                boolean containsKey = metaItemFilterExt.containsKey(metaFilter.getKey());
                                if (containsKey) {
                                    dataTable.setInt(rowIndex, "ExtendFlag", isExt?1:0);
                                    MetaFilter metaFilterExt = resultExt.metaItemFilterCollection.get(metaItemFilter.getKey()).get(metaFilter.getKey());
                                    dealFilterValue(metaFilter, dataTableDtl, applyNewOID,metaFilterExt,isExt);
                                } else {
                                    dataTable.setInt(rowIndex, "ExtendFlag", isExt?0:1);
                                    dealFilterValue(metaFilter, dataTableDtl, applyNewOID,null,isExt);
                                }
                        } else {
                            dataTable.setInt(rowIndex, "ExtendFlag", isExt?0:1);
                            dataTable.setInt(rowIndex, "ExtendItemFilterFlag", isExt?0:1);
                            dealFilterValue(metaFilter, dataTableDtl, applyNewOID,null,isExt);
                        }

                    } else {
                        dataTable.setInt(rowIndex, "ExtendFlag", isExt?0:1);
                        dealFilterValue(metaFilter, dataTableDtl, applyNewOID,null,isExt);
                    }

                    dataTable.setState(RowState.NORMAL);
                    // 加载每个FilterValue

                }
                dataTable.batchUpdate();
            }
        }
        doc.add(ConstantUtil.ED_DICT_FILTER_VALUE, dataTableDtl);
        doc.add(ConstantUtil.ED_DICTITEM, dataTable1);
    }

    private static Result getResult(MetaForm ownerMetaForm, String itemKey1, String dictType, MetaForm containerForm) throws Throwable {
        MetaDictView metaDictView;
        MetaComponent metaField;
        MetaGridCell metaGridCell;
        String itemKey = "";
        MetaItemFilterCollection metaItemFilterCollection = null;
        Boolean isDyn = false;
        if ("D_FieldProperty".equalsIgnoreCase(dictType)) {
            metaField = (MetaComponent) DesignIOMetaUtil.getMetaComponent(ownerMetaForm, itemKey1);
            if (Objects.isNull(metaField) && containerForm != null) {
                metaField = (MetaComponent) DesignIOMetaUtil.getMetaComponent(containerForm, itemKey1);
            }
            metaItemFilterCollection = ((MetaDict) metaField).getProperties().getFilters();
            if (metaField instanceof MetaDynamicDict) {
                isDyn = true;
            }
            itemKey = ((MetaDict) metaField).getItemKey();
        }
        // 表格中字典
        if (ConstantUtil.D_GRID_FIELD_MODULE.equalsIgnoreCase(dictType)) {
            metaGridCell = (MetaGridCell) DesignIOMetaUtil.getMetaComponent(ownerMetaForm, itemKey1);
            if (Objects.isNull(metaGridCell) && containerForm != null) {
                metaGridCell = (MetaGridCell) DesignIOMetaUtil.getMetaComponent(containerForm, itemKey1);
            }
            MetaDictProperties metaproperties = (MetaDictProperties) metaGridCell.getProperties();
            if (metaGridCell.getCellType() == ControlType.DYNAMICDICT) {
                isDyn = true;
            }
            metaItemFilterCollection = metaproperties.getFilters();
            itemKey = metaproperties.getItemKey();
        }
        //字典视图
        if (ConstantUtil.D_DICT_VIEW.equalsIgnoreCase(dictType)) {
            metaDictView = (MetaDictView) DesignIOMetaUtil.getMetaComponent(ownerMetaForm, itemKey1);
            if (Objects.isNull(metaDictView) && containerForm != null) {
                metaDictView = (MetaDictView) DesignIOMetaUtil.getMetaComponent(containerForm, itemKey1);
            }
            metaItemFilterCollection = metaDictView.getFilters();
            itemKey = metaDictView.getFormulaItemKey();
        }
        Result result = new Result(metaItemFilterCollection, itemKey, isDyn);
        return result;
    }

    private static class Result {
        public final MetaItemFilterCollection metaItemFilterCollection;
        public final String itemKey;
        public final Boolean isDyn;

        public Result(MetaItemFilterCollection metaItemFilterCollection, String itemKey, Boolean isDyn) {
            this.metaItemFilterCollection = metaItemFilterCollection;
            this.itemKey = itemKey;
            this.isDyn = isDyn;
        }
    }

    /**
     * 字典过滤头表(MetaFilter)
     */
    public static void dealDictField(XmlTreeWithPath xmlTree, String controlerType, String primaryKey, DataTable headTable,
                                     DataTable detailTable, DataTable dictItem, Diff diff) throws Throwable {
        String ownerFormKey = diff.formKey;
//        String dictType = diff.getDictType();
//        String bindingItemKey = dictItem.getString(0, "BindingItemKey");
        MetaForm ownerMetaForm = StringUtils.isBlank(ownerFormKey) ? null : MetaFactory.getGlobalInstance().getMetaForm(ownerFormKey);
        String key = diff.getKey();
        AbstractMetaObject metaGridCell = DesignIOMetaUtil.getMetaComponent(ownerMetaForm, key);
        if (Objects.isNull(metaGridCell) && diff.getContainerKey() != null) {
            ownerMetaForm = MetaFactory.getGlobalInstance().getMetaForm(diff.getContainerKey());
            metaGridCell = DesignIOMetaUtil.getMetaComponent(ownerMetaForm, key);
        }
        String tagName = metaGridCell.getTagName();
        // 字段抓取node
        String xmlTreeKey = XmlDiffProcessor.getXmlTreeKey(diff, tagName, key);
        TagNode curNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
        if (headTable.size() <= 0) {//清空
            curNode.deleteChildByTagName(MetaItemFilter.TAG_NAME);
            // 将整个父节点替换掉
            XmlDiffProcessor.genXmlDiff(xmlTree, curNode, diff, true);
            return;
        }
        List<String> itemColl = new ArrayList<>();  //用于计算动态字典中使用多少字典标识
        curNode.deleteChildByTagName(MetaItemFilter.TAG_NAME);
        // 清除原来全部的节点，重新构建
        for (int i = 0, length = headTable.size(); i < length; i++) {
            String itemKey = headTable.getString(i, "ItemKey");
            if (StringUtils.isEmpty(itemKey)) {
                itemKey = "DictItemFilter";
            }
            if (!itemColl.contains(itemKey)) {
                itemColl.add(itemKey);
            }
        }
        headTable.setShowDeleted(true);
        for (String itemKey : itemColl) {
            TagNode itemFilterNode = new TagNode(MetaItemFilter.TAG_NAME, null);
            if (ControlType.STR_DYNAMICDICT.equalsIgnoreCase(curNode.getTagName())||
                    (ConstantUtil.GRID_CELL.equalsIgnoreCase(curNode.getTagName()) &&
                            ControlType.STR_DYNAMICDICT.equalsIgnoreCase(curNode.getAttributes().get(ConstantUtil.CELL_TYPE)))) {
                itemFilterNode.setAttribute(ConstantUtil.ITEM_KEY, itemKey);
            }
            curNode.addNode(itemFilterNode);
            for (int i = 0, length = headTable.size(); i < length; i++) {
                String itemKey1 = headTable.getString(i, "ItemKey");
                String filterKey = headTable.getString(i, "FilterKey");
                if (StringUtils.isEmpty(itemKey1)) {
                    itemKey1 = "DictItemFilter";
                }
                int state = headTable.getState(i);
                if (!itemKey.equalsIgnoreCase(itemKey1) || RowState.DELETED == state) {
                    continue;
                }
                Long OID = TypeConvertor.toLong(headTable.getObject(i, SystemField.OID_SYS_KEY));
                int type = headTable.getInt(i, ConstantUtil.TYPE);

                TagNode metaFilterNode = new TagNode(MetaFilter.TAG_NAME, null);
                String implClass = headTable.getString(i, "ImplClass");
                if (StringUtils.isNotEmpty(implClass)) {
                    metaFilterNode.setAttribute("Impl", implClass);
                }

                String value = DictFilterType.toString(type);
                if (StringUtils.isNotEmpty(value)) {
                    metaFilterNode.setAttribute(ConstantUtil.TYPE, value);

                }
                metaFilterNode.setAttribute(ConstantUtil.KEY, filterKey);
                String operatorSign = FilterOptSign.toString(headTable.getInt(i, "OperatorSign"));
                if (StringUtils.isNotEmpty(operatorSign)) {
                    metaFilterNode.setAttribute("OP", operatorSign);
                }
                String query = headTable.getString(i, "Query");
                if (StringUtils.isNotEmpty(query)) {
                    metaFilterNode.setAttribute("Query", query);
                }
                String filterDependency = headTable.getString(i, "FilterDependency");
                if (StringUtils.isNotEmpty(filterDependency)) {
                    metaFilterNode.setAttribute("FilterDependency", filterDependency);
                }
                String condition = headTable.getString(i, "Condition");
                if (StringUtils.isNotEmpty(condition)) {
                    metaFilterNode.setAttribute("Condition", condition);
                }
                // 加载当前节点的子节点
                dealDictDetail1(metaFilterNode, OID, detailTable);
                itemFilterNode.addNode(metaFilterNode);
            }
        }
        // 如果子节点没有filter ，则移除itemfilter
        List<TagNode> nodesByTagName = curNode.findNodesByTagName(MetaItemFilter.TAG_NAME);
        for (TagNode itemFilterNode : nodesByTagName) {
            List<AbstractNode> children = itemFilterNode.getChildren();
            for (AbstractNode child : children) {
                if (child instanceof TagNode) {
                    String tagName1 = ((TagNode) child).getTagName();
                    if (tagName1.equalsIgnoreCase(MetaFilter.TAG_NAME)) {
                        break;
                    }
                    nodesByTagName.remove(itemFilterNode);
                }
            }
        }
        // 将整个父节点替换掉
        XmlDiffProcessor.genXmlDiff(xmlTree, curNode, diff, true);
    }

    /**
     * 添加子节点(MetaFilterValue)
     */
    private static void dealDictDetail1(TagNode parentNode, Long parentOID, DataTable detailTable) {
        // 根据父节点过滤子节点，并添加
        for (int i = 0, length = detailTable.size(); i < length; i++) {
            Row row = detailTable.getRowByIndex(i);
            int state = row.getState();
            // 如果是删除状态，则不添加
            if (RowState.DELETED == state) {
                continue;
            }
            Long poid = TypeConvertor.toLong(row.getObject(ConstantUtil.POID));
            if (parentOID.compareTo(poid) != 0) {
                continue;
            }
            TagNode node = new TagNode(MetaFilterValue.TAG_NAME, null);
            String dataType = DataType.toString(TypeConvertor.toInteger(row.getObject("DataType")));

            String subType = FilterValueType.format(TypeConvertor.toInteger(row.getObject("SubType")));
            String fieldKey = row.getObject(ConstantUtil.FIELD_KEY).toString();

            if (StringUtils.isNotEmpty(subType) && !FilterValueType.STR_FORMULA.equalsIgnoreCase(subType)) {
                node.setAttribute(ConstantUtil.TYPE, subType);
            }
            if (StringUtils.isNotEmpty(dataType)) {
                node.setAttribute("DataType", dataType);
            }
            String paraValue = row.getObject("ParaValue").toString();
            String index = row.getObject("Index").toString();
            node.setAttribute("Index", index);
            if (StringUtils.isNotEmpty(paraValue)) {
                node.setAttribute("ParaValue", paraValue);
            }
            String value = DesignActionUtil.DataMap.get(fieldKey);
            if (StringUtils.isNotEmpty(value)) {
                node.setAttribute(ConstantUtil.FIELD_KEY, value);
            }
            String refValue = row.getObject("RefValue").toString();
            if (StringUtils.isNotEmpty(refValue)) {
                node.setAttribute("RefValue", refValue);
            }
            parentNode.addNode(node);
        }
    }


    /**
     * 处理子明细过滤
     */
    private static void dealFilterValue(MetaFilter metaFilter, DataTable dataTable, Long headOID,MetaFilter metaFilterExt,boolean isExt) {
        for (MetaFilterValue metaFilterValue : metaFilter) {
            int append = dataTable.append();
            int dataType = metaFilterValue.getDataType();
            String paraValue = metaFilterValue.getParaValue();
            int filterValueType = metaFilterValue.getType();
            String fieldKey = metaFilterValue.getFieldKey();
            String refValueKey = metaFilterValue.getRefValueKey();

            dataTable.setLong(append,SystemField.POID_SYS_KEY, headOID);
            dataTable.setInt(append,MetaConstants.COLUMN_DATATYPE, dataType);
            dataTable.setObject(append,MetaConstants.DICT_FILTERVALUE_PARAVALUE, paraValue);
            dataTable.setInt(append,"SubType", filterValueType);
            dataTable.setObject(append,MetaConstants.DICT_FILTERVALUE_FIELDKEY, fieldKey);
            dataTable.setObject(append,MetaConstants.DICT_FILTERVALUE_REFVALUE, refValueKey);
            dataTable.setObject(append,"Index", metaFilterValue.getKey());
            if (metaFilterExt!=null) {
                if (metaFilterExt.containsKey(metaFilterValue.getKey())){
                    dataTable.setInt(append, "ExtendFlag", isExt?1:0);
                }else {
                    dataTable.setInt(append, "ExtendFlag", isExt?0:1);
                }
            } else {
                dataTable.setInt(append, "ExtendFlag", isExt?0:1);
            }

            dataTable.setState(RowState.NORMAL);




        }
        dataTable.batchUpdate();
    }
}