package com.bokesoft.yes.design.metaobjecttype;

import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.MetaObjectType;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.io.IOMetaObject;
import com.bokesoft.yes.design.io.loader.IODataObjectLoadable;
import com.bokesoft.yes.design.utils.WebDesignerDataTableUtil;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.def.ParameterSourceType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaStatement;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaParameter;
import com.bokesoft.yigo.meta.dataobject.MetaParameterCollection;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.MetaCheckListBox;
import com.bokesoft.yigo.meta.form.component.control.MetaComboBox;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaQueryDef;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;

/**
 * 下拉框查询定义 配置对象
 */
public class MetaQueryDefType extends MetaObjectType implements IODataObjectLoadable {

    private static final String NAME = "QueryDef";

    // 下拉框查询定义表单 数据源表名
    private static final String D_ComboBoxQueryDefHead = "D_ComboBoxQueryDefHead";
    private static final String ED_ParameterCollection = "ED_ParameterCollection";
    private static final String ED_New_FieldTable = "ED_New_FieldTable";

    public MetaQueryDefType() {
        super(NAME);
    }

    @Override
    public void mergeDiff(MetaForm metaForm, Diff diff, Document document) throws Throwable {
        // TODO
        XmlTreeWithPath xmlTree = diff.getXmlTree();
        DataTable headTable = document.get(D_ComboBoxQueryDefHead);
        DataTable paraTable = document.get(ED_ParameterCollection);
        String componentKey = diff.getKey();
        MetaComponent metaComponent = IOMetaObject.getComponentByKey(metaForm, diff.getKey());
        String tagName = metaComponent.getTagName();
        String xmlTreeKey = getXmlTreeKey(diff, tagName, componentKey);
        // 父节点
        TagNode parentNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
        // 节点直接删除再重新添加
        parentNode.deleteChildByTagName(MetaQueryDef.TAG_NAME);

        TagNode queryDef = new TagNode(MetaQueryDef.TAG_NAME, null);
        if (headTable.size() > 0) {
            // 查询语句设置
            TagNode statement = new TagNode(MetaStatement.TAG_NAME, null);
            statement.setCDataValue(headTable.getString(0, ConstantUtil.STATEMENT));
            queryDef.addNode(statement);

            // 依赖字段设置 这个属性在父节点里
            String dependField = headTable.getString(0, "ItemsDependency");
            parentNode.setAttribute("ItemsDependency", dependField);

            // 参数列表设置
            TagNode parameterCollection = new TagNode(MetaParameterCollection.TAG_NAME, null);
            for (int i = 0; i < paraTable.size(); i++) {
                String dataType = paraTable.getString(i, ConstantUtil.DATA_TYPE);
                String sourceType = paraTable.getString(i, ConstantUtil.SOURCE_TYPE);
                String description = paraTable.getString(i, ConstantUtil.DESCRIPTION);
                String value = paraTable.getString(i, ConstantUtil.VALUE);
                TagNode parameter = new TagNode(MetaParameter.TAG_NAME, null);
                parameter.setAttribute(ConstantUtil.DATA_TYPE, dataType);
                // 公式是默认值，sourceType为空
                if (!"Formula".equals(sourceType)){
                    parameter.setAttribute(ConstantUtil.SOURCE_TYPE, sourceType);
                }
                parameter.setAttribute(ConstantUtil.DESCRIPTION, description);
                parameter.setAttribute(ConstantUtil.VALUE, value);
                parameterCollection.addNode(parameter);
            }
            queryDef.addNode(parameterCollection);
        }
        parentNode.addNode(queryDef); // 这样只要点击确定就会生成QueryDef节点
        // 直接替换整个父节点
        genXmlDiff(xmlTree, parentNode, diff, true);
    }

    /**
     * 配置对象表单 加载方法
     * @param document 表单
     * @param context 上下文
     * @param metaDataObject 数据对象
     * @return 加载后的表单
     */
    @Override
    public Document load(Document document, DefaultContext context, MetaDataObject metaDataObject) throws Throwable {
        String ownerFormKey = (String) context.getPara("OwnerFormKey");
        String fieldKey = (String) context.getPara(ConstantUtil.COMP_KEY);
        MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(ownerFormKey);
        MetaForm containerForm = getContainerForm(context);
        metaForm = IOMetaObject.isThisForm(metaForm, containerForm, fieldKey);
        AbstractMetaObject componentByKey = IOMetaObject.getComponentByKey(metaForm, fieldKey);

        loadD_ComboBoxQueryDefHead(document, metaDataObject, componentByKey);
        loadED_ParameterCollection(document, metaDataObject, componentByKey);
        document.add(ED_New_FieldTable, WebDesignerDataTableUtil.generateDataTable(metaDataObject.getTable(ED_New_FieldTable)));

        return document;
    }

    /**
     * 加载头表数据
     * @param document
     * @param metaDataObject
     * @param comboBox
     */
    private void loadD_ComboBoxQueryDefHead(Document document, MetaDataObject metaDataObject, AbstractMetaObject comboBox){
        MetaTable metaTable = metaDataObject.getTable(D_ComboBoxQueryDefHead);
        DataTable dataTable = WebDesignerDataTableUtil.generateDataTable(metaTable);

        dataTable.clear();
        dataTable.append();
        dataTable.setString(0, "ItemsDependency", getItemsDependency(comboBox));
        MetaQueryDef queryDef = getQueryDef(comboBox);
        if (queryDef != null) {
            dataTable.setString(0, ConstantUtil.STATEMENT, queryDef.getStatement().getContent());
        }

        document.add(D_ComboBoxQueryDefHead, dataTable);
    }

    private void loadED_ParameterCollection(Document document, MetaDataObject metaDataObject, AbstractMetaObject comboBox){
        MetaTable metaTable = metaDataObject.getTable(ED_ParameterCollection);
        DataTable dataTable = WebDesignerDataTableUtil.generateDataTable(metaTable);

        dataTable.clear();
        MetaQueryDef queryDef = getQueryDef(comboBox);
        if (queryDef != null && queryDef.getParameterCollection() != null) {
            MetaParameterCollection parameterCollection =queryDef.getParameterCollection();
            for (int i = 0; i < parameterCollection.size(); i++) {
                MetaParameter parameter = parameterCollection.get(i);
                int append = dataTable.append();
                dataTable.setString(append, ConstantUtil.DATA_TYPE, DataType.toString(parameter.getDataType()));
                dataTable.setString(append, ConstantUtil.SOURCE_TYPE, ParameterSourceType.format(parameter.getSourceType()));
                dataTable.setString(append, ConstantUtil.DESCRIPTION, parameter.getDescription());
                dataTable.setString(append, ConstantUtil.VALUE, parameter.getValue());
            }
        }

        document.add(ED_ParameterCollection, dataTable);
    }

    /**
     * 这个方法是否放到接口里面去
     * @param ctx
     * @return
     * @throws Throwable
     */
    private MetaForm getContainerForm(DefaultContext ctx) throws Throwable {
        String containerKey = (String) ctx.getPara("ContainerKey");
        if (containerKey != null && !containerKey.isEmpty()) {
            return MetaFactory.getGlobalInstance().getMetaForm(containerKey);
        }
        return null;
    }

    private String getItemsDependency(AbstractMetaObject component){
        if (component instanceof MetaComboBox) {
            return ((MetaComboBox) component).getItemsDependency();
        }
        if (component instanceof MetaCheckListBox) {
            return ((MetaCheckListBox)component).getItemsDependency();
        }
        return null;
    }

    private MetaQueryDef getQueryDef (AbstractMetaObject component) {
        if (component instanceof MetaComboBox) {
            return ((MetaComboBox) component).getQueryDef();
        }
        if (component instanceof MetaCheckListBox) {
            return ((MetaCheckListBox)component).getQueryDef();
        }
        return null;
    }

}
