package com.bokesoft.yes.design.mergesingle.util;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.cmd.UICommand;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.mergesingle.common.MergeSingleDiffUtil;
import com.bokesoft.yes.design.mergesingle.impl.SingleSettingImpl;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yigo.common.def.CondSign;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.def.FilterOptSign;
import com.bokesoft.yigo.common.def.FilterValueType;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GridFilterOperUtil extends SingleSettingImpl {
    @Override
    public void dealData(Document document, Diff diff, JSONObject jsonObject) throws Throwable {
// 保存表格过滤
        DataTable headTable = document.get(ConstantUtil.TBL_GRID_FILTER_HEAD);
        DataTable detailTable = document.get(ConstantUtil.TBL_GRID_FILTER_DETAIL);
        String xmlTreeKey = "Grid@" + diff.getKey();
        XmlTreeWithPath xmlTree = diff.getXmlTree();
        TagNode fieldNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
        dealGridFilter(fieldNode, headTable, detailTable);
        setTagNode(fieldNode);

    }
    private static void dealGridFilter( TagNode node, DataTable headTable, DataTable detailTable) {
        TagNode filter = null;
        if (headTable.size() > 0) {
            filter = node.getOrCreateChildByTagName(ConstantUtil.GRID_FILTER);
            filter.setAttribute("Op", FilterOptSign.toString(headTable.getInt(0, ConstantUtil.GRID_FILTER)));
            if (!StringUtils.isNotEmpty(Integer.toString(headTable.getInt(0, ConstantUtil.GRID_FILTER)))) {
                filter.getAttributes().remove("Op");
            }
            filter.setAttribute(ConstantUtil.FILTER_DEPENDENCY, headTable.getString(0, ConstantUtil.FILTER_DEPENDENCY));
            if (!StringUtils.isNotEmpty(headTable.getString(0, ConstantUtil.FILTER_DEPENDENCY))) {
                filter.getAttributes().remove(ConstantUtil.FILTER_DEPENDENCY);
            }
            filter.getChildren().clear();
        }
        for (int i = 0; i < detailTable.size(); i++) {
            String type = FilterValueType.format(Integer.parseInt(detailTable.getString(i, ConstantUtil.TYPE)));
            String fieldKey = detailTable.getString(i, "FieldKey");
            String index = detailTable.getString(i, "Index");
            String condSign = CondSign.toString(Integer.parseInt(detailTable.getString(i, ConstantUtil.COND_SIGN)));
            String refValue = detailTable.getString(i, "RefValue");
            String dataType = "";
            if (StringUtils.isNotEmpty(detailTable.getString(i, ConstantUtil.DATA_TYPE))) {
                dataType = DataType.toString(Integer.parseInt(detailTable.getString(i, ConstantUtil.DATA_TYPE)));
            }
            TagNode filterValue = new TagNode(ConstantUtil.FILTER_VALUE, null);
            filterValue.setAttribute("Index", index);

            if (StringUtils.isNotEmpty(type)) {
                filterValue.setAttribute(ConstantUtil.TYPE, type);
            }
            if (StringUtils.isNotEmpty(fieldKey)) {
                filterValue.setAttribute("FieldKey", fieldKey);
            }
            if (StringUtils.isNotEmpty(condSign)) {
                filterValue.setAttribute(ConstantUtil.COND_SIGN, condSign);
            }
            if (StringUtils.isNotEmpty(refValue)) {
                filterValue.setAttribute("RefValue", refValue);
            }
            if (StringUtils.isNotEmpty(dataType)) {
                filterValue.setAttribute(ConstantUtil.DATA_TYPE, dataType);
            }
            filter.addNode(filterValue);
        }
    }
}
