package com.bokesoft.yes.design.mergesingle.util;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.cmd.NewFormCmd;
import com.bokesoft.yes.design.cmd.UICommand;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.mergesingle.common.MergeSingleDiffUtil;
import com.bokesoft.yes.design.mergesingle.impl.SingleSettingImpl;
import com.bokesoft.yes.design.xml.node.AbstractNode;
import com.bokesoft.yes.design.xml.node.CDataNode;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.meta.persist.dom.form.MetaFormLoad;
import com.bokesoft.yes.struct.abstractdatatable.RowState;
import com.bokesoft.yes.util.ERPStringUtil;
import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.def.FormVerb;
import com.bokesoft.yigo.common.def.ScriptRange;
import com.bokesoft.yigo.meta.base.KeyPairCompositeObject;
import com.bokesoft.yigo.meta.common.*;
import com.bokesoft.yigo.meta.commondef.MetaOperation;
import com.bokesoft.yigo.meta.commondef.MetaOperationCollection;
import com.bokesoft.yigo.meta.dataobject.MetaParameterCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.util.*;

/**
 * 表单集合属性
 */
public class FormToolOperUtil extends SingleSettingImpl {

	private static final Logger log = LoggerFactory.getLogger(FormToolOperUtil.class);

	public void dealData(Document document, Diff diff, JSONObject jsonObject) throws Throwable {
		DataTable collecTable = document.get(ConstantUtil.TBL_OPERATION_TOOLBAR_DETAIL);
		DataTable fieldTable = document.get(ConstantUtil.TBL_OPERATIONS);
		DataTable macroDetail = document.get(ConstantUtil.TBL_MACRO_FORMULA);
		DataTable spcritList = document.get(ConstantUtil.TBL_SCRIPT_LIST);
		DataTable queryStatement = document.get(ConstantUtil.TBL_QueryStatement);
		DataTable parameterCollection = document.get(ConstantUtil.TBL_QUERY_PARAMETER_COLLECTION);
		DataTable queryCollection = document.get(ConstantUtil.TBL_QUERY_COLLECTION);
		XmlTreeWithPath xmlTree = diff.getXmlTree();
		dealOperationToobar(xmlTree, collecTable, fieldTable, macroDetail, spcritList, queryStatement, parameterCollection, queryCollection, diff);
		TagNode ptagNode = diff.getXmlTree().xmlTree.getRoot();
		setTagNode(ptagNode);
	}

	private static void processOperationRef(MetaForm metaForm, KeyPairCompositeObject metaItem) throws Throwable {
		if (metaForm == null || metaItem == null) {
			return;
		}
		int objectType = metaItem.getObjectType();
		if (objectType == MetaOperation.Operation) {
			MetaOperation metaOperation = (MetaOperation) metaItem;
			String refKey = metaOperation.getRefKey();
			if (refKey == null || refKey.isEmpty()) {
				return;
			}
			String oldEnable = metaOperation.getEnable();
			String caption = metaOperation.getCaption();
			MetaBaseScript action = metaOperation.getAction();
			String oldEnableDependency = metaOperation.getEnableDependency();
			String oldVisible = metaOperation.getVisible();
			String oldVisibleDependency = metaOperation.getVisibleDependency();
			// 合并操作
			MetaUtil.processOperationRefKey(MetaFactory.getGlobalInstance(), metaForm, metaOperation);
			// 还原可用性，以Form的可用性为准
			if (!ERPStringUtil.isBlankOrNull(oldEnable)) {
				metaOperation.setEnable(oldEnable);
			}
			// 还原Caption，以Form的可用性依赖为准
			if (!ERPStringUtil.isBlankOrNull(caption)) {
				metaOperation.setCaption(caption);
			}
			// 还原action，以Form的可用性依赖为准
			if (!ERPStringUtil.isBlankOrNull(action)) {
				metaOperation.setAction(action);
			}
			// 还原可用性依赖，以Form的可用性依赖为准
			if (!ERPStringUtil.isBlankOrNull(oldEnableDependency)) {
				metaOperation.setEnableDependency(oldEnableDependency);
			}
			// 还原可见性，以Form的可见性为准
			if (!ERPStringUtil.isBlankOrNull(oldVisible)) {
				metaOperation.setVisible(oldVisible);
			}
			// 还原可见性依赖，以Form的可见性依赖为准
			if (!ERPStringUtil.isBlankOrNull(oldVisibleDependency)) {
				metaOperation.setVisibleDependency(oldVisibleDependency);
			}
		} else if (objectType == MetaOperation.OperationCollection) {
			MetaOperationCollection metaOperationCollection = (MetaOperationCollection) metaItem;
			for (Iterator<KeyPairCompositeObject> it = metaOperationCollection.iterator(); it.hasNext(); ) {
				KeyPairCompositeObject subMetaItem = it.next();
				processOperationRef(metaForm, subMetaItem);
			}
		}
	}

	public static void dealOperationToobar(XmlTreeWithPath xmlTree, DataTable collecTable, DataTable fieldTable, DataTable marcoTable, DataTable scriptList, DataTable queryStatement, DataTable parameterCollection, DataTable queryCollection, Diff diff) throws Throwable {
		TagNode rootNode = xmlTree.xmlTree.getRoot();
		boolean vestFlag = false;
		boolean specVestFlag = false;
		MetaOperationCollection operationCollection = null;
		HashMap<String, KeyPairCompositeObject> operationCollectionMap = new HashMap<>();
		MetaOperationCollection operationCollectionSrc = null;
		HashMap<String, KeyPairCompositeObject> operationCollectionSrcMap = new HashMap<>();
		MetaMacroCollection macroCollection = null;
		MetaScriptCollection metaScriptCollection = null;
		MetaQueryCollection metaQueryCollection = null;
		Map<String, String> attributes = rootNode.getAttributes();
		String extend = attributes.get(ConstantUtil.EXTEND);
		String formKey = attributes.get(ConstantUtil.KEY);
		vestFlag = StringUtils.isNotBlank(extend);
		specVestFlag = StringUtils.equalsAnyIgnoreCase(attributes.get("MergeToSource"), "1", "true");
		IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
		MetaForm metaForm = null;
		if (formKey != null) {
			metaForm = NewFormCmd.loadMetaForm(formKey);
			operationCollection = metaForm.getOperationCollection();
			macroCollection = metaForm.getMacroCollection();
			metaScriptCollection = metaForm.getScriptCollection();
			metaQueryCollection = metaForm.getQueryCollection();
		}


		MetaScriptCollection metaScriptCollectionSrc = new MetaScriptCollection();
		MetaQueryCollection metaQueryCollectionSrc = new MetaQueryCollection();
		MetaMacroCollection macroCollectionSrc = new MetaMacroCollection();
		if (vestFlag) {//马甲
			MetaForm metaFormSrc = metaFactory.getMetaForm(extend);
			operationCollectionSrc = metaFormSrc.getOperationCollection();
			macroCollectionSrc = metaFormSrc.getMacroCollection();
			metaQueryCollectionSrc = metaFormSrc.getQueryCollection();
			metaScriptCollectionSrc = metaFormSrc.getScriptCollection();
			if (specVestFlag) {//功能
				String extendFilePath = StringUtils.isNotBlank(diff.getVestXmlTree().tmpFilePath) ? diff.getVestXmlTree().tmpFilePath : diff.getVestXmlTree().orgFilePath;
				MetaFormLoad extendFormLoad = new MetaFormLoad(AppRunType.Dev);
				extendFormLoad.load(FileUtils.openInputStream(new File(extendFilePath)));
				MetaForm extendMetaForm = (MetaForm) extendFormLoad.getRootMetaObject();
				extendMetaForm.setProject(metaFormSrc.getProject());
				//马甲操作处理
				processOperationRef(extendMetaForm, extendMetaForm.getOperationCollection());
				operationCollectionSrc = extendMetaForm.getOperationCollection();
				if (operationCollection != null) {
					operationCollection.merge(operationCollectionSrc);
					processOperationRef(metaForm, operationCollection);
				}

				//马甲公式处理

				macroCollectionSrc = extendMetaForm.getMacroCollection();
				if (macroCollection != null && macroCollectionSrc != null) {
					for (MetaMacro metaMacro : macroCollectionSrc) {
						if (macroCollection.containsKey(metaMacro.getKey())) {
							macroCollection.get(metaMacro.getKey()).merge(metaMacro);
						} else {
							macroCollection.add(metaMacro);
						}
					}
				}

				//公式处理
				metaScriptCollectionSrc = extendMetaForm.getScriptCollection();
				if (metaScriptCollection != null && metaScriptCollectionSrc != null) {
					for (MetaScript metaScript : metaScriptCollectionSrc) {
						if (metaScriptCollection.containsKey(metaScript.getKey())) {
							metaScriptCollection.get(metaScript.getKey()).merge(metaScript);
						} else {
							metaScriptCollection.add(metaScript);
						}
					}
				}
				//查询处理
				metaQueryCollectionSrc = extendMetaForm.getQueryCollection();
				if (metaQueryCollection != null && metaQueryCollectionSrc != null) {
					for (MetaQuery metaQuery : metaQueryCollectionSrc) {
						if (metaQueryCollection.containsKey(metaQuery.getKey())) {
							metaQueryCollection.get(metaQuery.getKey()).merge(metaQuery);
						} else {
							metaQueryCollection.add(metaQuery);
						}
					}
				}


			}
		}


		getOperation(operationCollectionSrc, operationCollectionSrcMap);
		getOperation(operationCollection, operationCollectionMap);
		dealOperationCollection(collecTable, fieldTable, rootNode, vestFlag, specVestFlag, operationCollectionMap, operationCollectionSrcMap);
		dealMacroCollection(marcoTable, rootNode, vestFlag, macroCollectionSrc);
		dealScriptNode(scriptList, rootNode, vestFlag, metaScriptCollectionSrc);
		dealParameterCollection(queryCollection, rootNode, queryStatement, parameterCollection, vestFlag, metaQueryCollectionSrc);
	}

	public static void dealParameterCollection(DataTable queryCollection, TagNode rootNode, DataTable statementDataTable, DataTable parameterDataTable, boolean vestFlag, MetaQueryCollection parentCollectionSrc) throws Throwable {
		if (queryCollection.size() < 1) {
			rootNode.deleteChildByTagName(ConstantUtil.QUERY_COLLECTION);
			return;
		}
		//处理查询列表
		TagNode queryNode = rootNode.findFirstTagNodeByTagName(ConstantUtil.QUERY_COLLECTION);
		//当macroCollection不存在先创建一个macroCollection
		if (Objects.isNull(queryNode)) {
			queryNode = new TagNode(ConstantUtil.QUERY_COLLECTION, null);
			rootNode.addNode(queryNode, 4);
		} else {
			queryNode.deleteChildByTagName("Query");
		}
		queryCollection.setShowDeleted(true);
		for (int j = 0; j < queryCollection.size(); j++) {
			String dataSourceType = queryCollection.getString(j, ConstantUtil.DataSourceType);
			//保证来源于其他的不写入xml
			if (!dataSourceType.isEmpty() && !dataSourceType.equalsIgnoreCase("xml")) {
				continue;
			}
			int state = queryCollection.getState(j);
			if (state == RowState.DELETED) {
				String keyDetail = queryCollection.getString(j, "Key");
				queryNode.deleteChildByTagKey(keyDetail);
				continue;
			}
			String keyDetail = queryCollection.getString(j, "Key");
			String queryDescription = queryCollection.getString(j, "Query");
			Long queryOid = queryCollection.getLong(j, ConstantUtil.OID);
			MetaQuery metaQuery = null;
			if (parentCollectionSrc != null) {
				metaQuery = parentCollectionSrc.get(keyDetail);
			}
			TagNode query = new TagNode("Query", null);
			queryNode.addNode(query);
			query.setAttribute(ConstantUtil.KEY, keyDetail);
			if (!statementDataTable.isEmpty()) {//Statement添加
				for (int i = 0; i < statementDataTable.size(); i++) {
					if (statementDataTable.getLong(i, ConstantUtil.POID).equals(queryOid)) {
						TagNode Statement = new TagNode(ConstantUtil.STATEMENT, null);
						Statement.setAttribute("DBType", StringUtils.trim(statementDataTable.getString(i, "DBType")));
						String contextText = StringUtils.trim(statementDataTable.getString(i, "Context"));
						if (StringUtils.isNotEmpty(contextText)) {
							CDataNode cNode = new CDataNode(contextText, null);
							Statement.addNode(cNode);
							query.addNode(Statement);
						}
					}
				}
			}
			if (!parameterDataTable.isEmpty()) {
				TagNode parameterCollection = new TagNode(MetaParameterCollection.TAG_NAME, null);
				for (int a = 0; a < parameterDataTable.size(); a++) {
					if (!parameterDataTable.getLong(a, ConstantUtil.POID).equals(queryOid)) {
						continue;
					}
					TagNode parameter = new TagNode(ConstantUtil.PARAMETER, null);
					if (StringUtils.isNotEmpty(parameterDataTable.getString(a, ConstantUtil.PARAMETER))) {
						String type = DataType.toString(Integer.parseInt(parameterDataTable.getString(a, ConstantUtil.PARAMETER)));
						parameter.setAttribute(ConstantUtil.DATA_TYPE, type);
						parameterCollection.addNode(parameter);
					}
				}
				query.addNode(parameterCollection);

			}
			if (!vestFlag || metaQuery == null) {//非马甲
				query.setAttribute(ConstantUtil.DESCRIPTION, queryDescription);
			} else {
				if (StringUtils.isNotEmpty(queryDescription)) {
					if (!StringUtils.equals(metaQuery.getDescription(), queryDescription)) {
						query.setAttribute(ConstantUtil.DESCRIPTION, queryDescription);
					}
				}
			}
		}
	}

	public static void dealScriptNode(DataTable scriptList, TagNode rootNode, boolean vestFlag, MetaScriptCollection parentCollectionSrc) throws Throwable {
		if (scriptList.size() < 1) {
			rootNode.deleteChildByTagName(ConstantUtil.SCRIPT_COLLECTION);
			return;
		}
		//处理脚本列表
		TagNode scriptNode = rootNode.findFirstTagNodeByTagName(ConstantUtil.SCRIPT_COLLECTION);
		//当macroCollection不存在先创建一个macroCollection
		if (Objects.isNull(scriptNode)) {
			scriptNode = new TagNode(ConstantUtil.SCRIPT_COLLECTION, null);
			rootNode.addNode(scriptNode, 4);
		} else {
			scriptNode.deleteChildByTagName(ConstantUtil.SCRIPT);
		}
		scriptList.setShowDeleted(true);
		for (int j = 0; j < scriptList.size(); j++) {
			String dataSourceType = scriptList.getString(j, ConstantUtil.DataSourceType);
			//保证来源于其他的不写入xml
			if (!dataSourceType.isEmpty() && !dataSourceType.equalsIgnoreCase("xml")) {
				continue;
			}
			int state = scriptList.getState(j);
			if (state == RowState.DELETED) {
				String keyDetail = scriptList.getString(j, "Key");
				scriptNode.deleteChildByTagKey(keyDetail);
				continue;
			}
			String keyDetail = scriptList.getString(j, "Key");
			String scriptCaption = scriptList.getString(j, "Caption");
			String scriptRange = scriptList.getString(j, "Range");
			String scriptVerb = scriptList.getString(j, "Verb");
			String spcritDetail = scriptList.getString(j, "ScriptDetail");
			String scriptDescription = scriptList.getString(j, "Description");
			MetaScript metaScript = null;
			if (parentCollectionSrc != null) {
				metaScript = parentCollectionSrc.get(keyDetail);
			}

			if (!vestFlag || metaScript == null) {//非马甲
				TagNode script = new TagNode(ConstantUtil.SCRIPT, null);
				script.setAttribute(ConstantUtil.KEY, keyDetail);
				if (StringUtils.isNotEmpty(scriptCaption)) {
					script.setAttribute(ConstantUtil.CAPTION, scriptCaption);
				}
				if (StringUtils.isNotEmpty(scriptRange)) {
					script.setAttribute(ConstantUtil.RANGE, scriptRange);
				}
				if (StringUtils.isNotEmpty(scriptVerb)) {
					script.setAttribute(ConstantUtil.VERB, scriptVerb);
				}
				if (StringUtils.isNotEmpty(scriptDescription)) {
					script.setAttribute(ConstantUtil.DESCRIPTION, scriptDescription);
				}
				if (StringUtils.isNotEmpty(spcritDetail)) {
					CDataNode cNode = new CDataNode(spcritDetail, null);
					script.addNode(cNode);
				}
				scriptNode.addNode(script);
				continue;
			}
			TagNode script = new TagNode(ConstantUtil.SCRIPT, null);
			scriptNode.addNode(script);
			script.setAttribute(ConstantUtil.KEY, keyDetail);
			if (StringUtils.isNotEmpty(scriptCaption)) {
				if (!StringUtils.equals(metaScript.getCaption(), scriptCaption)) {
					script.setAttribute(ConstantUtil.CAPTION, scriptCaption);
				}
			}
			if (StringUtils.isNotEmpty(spcritDetail)) {
				if (!StringUtils.equals(metaScript.getContent(), spcritDetail)) {
					CDataNode cNode = new CDataNode(spcritDetail, null);
					script.addNode(cNode);
				}
			}
			if (StringUtils.isNotEmpty(scriptRange)) {
				if (!StringUtils.equals(ScriptRange.toString(metaScript.getRange()), scriptRange)) {
					script.setAttribute(ConstantUtil.RANGE, scriptRange);
				}
			}
			if (StringUtils.isNotEmpty(scriptVerb)) {
				if (!StringUtils.equals(FormVerb.toString(metaScript.getVerb()), scriptVerb)) {
					script.setAttribute(ConstantUtil.VERB, scriptVerb);
				}
			}
			if (StringUtils.isNotEmpty(scriptDescription)) {
				if (!StringUtils.equals(metaScript.getDescription(), scriptDescription)) {
					script.setAttribute(ConstantUtil.DESCRIPTION, scriptDescription);
				}
			}

		}
	}

	public static void getOperation(MetaOperationCollection operationCollectionSrc, HashMap<String, KeyPairCompositeObject> operationCollectionMap) {

		if (operationCollectionSrc != null) {
			for (KeyPairCompositeObject keyPairCompositeObject : operationCollectionSrc) {
				operationCollectionMap.put(keyPairCompositeObject.getKey(), keyPairCompositeObject);
				if (keyPairCompositeObject instanceof MetaOperationCollection) {
					MetaOperationCollection keyPairC = (MetaOperationCollection) keyPairCompositeObject;
					getOperation(keyPairC, operationCollectionMap);
				}
			}
		}

	}

	public static void dealOperationCollection(DataTable collecTable,
											   DataTable fieldTable, TagNode rootNode, boolean vestFlag, boolean specVestFlag,
											   HashMap<String, KeyPairCompositeObject> operationCollectionMap, HashMap<String, KeyPairCompositeObject> operationCollectionSrcMap) throws Throwable {
		List<TagNode> operationCollectionNodeList = rootNode.findNodesByTagName(ConstantUtil.OPERATION_COLLECTION);
		TagNode parentNode;
		if (CollectionUtils.isNotEmpty(operationCollectionNodeList)) {
			parentNode = operationCollectionNodeList.get(0);
		} else {
			parentNode = new TagNode(ConstantUtil.OPERATION_COLLECTION, null);
			rootNode.addNode(parentNode, 2);
		}
		parentNode.getParent().deleteChildByTagName(ConstantUtil.OPERATION_COLLECTION); //删除所有操作节点重新添加
		TagNode operationCollectionNode = new TagNode(ConstantUtil.OPERATION_COLLECTION, null);
		rootNode.addNode(operationCollectionNode, 2);
		collecTable.setShowDeleted(true);
		fieldTable.setShowDeleted(true);
		for (int i = 0; i < collecTable.size(); i++) {
			int rowState = collecTable.getState(i);
			String dataSourceType = collecTable.getString(i, ConstantUtil.DataSourceType);
			//保证来源于其他的不写入xml
			if (!dataSourceType.isEmpty() && !dataSourceType.equalsIgnoreCase("xml")) {
				continue;
			}

			if (RowState.DELETED == rowState) {
				continue;
			}

			Long oid = collecTable.getLong(i, ConstantUtil.OID);
			fieldTable.setFilter("POID==" + oid);
			fieldTable.filter();

			String tableMark = collecTable.getString(i, "TableMark");
			if (vestFlag) {
				KeyPairCompositeObject compositeObjectSrc = operationCollectionSrcMap.get(tableMark);
				if (Objects.isNull(compositeObjectSrc) && !specVestFlag) {
					throw new RuntimeException("界面马甲不能添加界面操作！");
				}
				boolean extendFlag = !Objects.isNull(compositeObjectSrc);
				if (extendFlag) {//继承
					String tableType = collecTable.getString(i, "TableType");
					if (!StringUtils.equals(tableType, "1")) {
						MetaOperation metaOperationSrc = (MetaOperation) compositeObjectSrc;
						TagNode tagNode = toExtendOperationNode(collecTable, i, metaOperationSrc);
						operationCollectionNode.addNode(tagNode);
					} else {
						MetaOperationCollection metaOperationCollectionSrc = (MetaOperationCollection) compositeObjectSrc;
						TagNode tagNode = toExtendOperationNode(collecTable, i, metaOperationCollectionSrc);
						operationCollectionNode.addNode(tagNode);
						for (int j = 0; j < fieldTable.size(); j++) {
							if (fieldTable.getState(j) == RowState.DELETED) {
								continue;
							}
							String subTableMark = fieldTable.getString(j, "TableMark");
							KeyPairCompositeObject subCompositeObjectSrc = operationCollectionSrcMap.get(subTableMark);
							KeyPairCompositeObject subCompositeObject = operationCollectionMap.get(subTableMark);
							if (Objects.isNull(subCompositeObjectSrc) && !specVestFlag) {
								throw new RuntimeException("界面马甲不能添加界面操作！");
							}

							if (Objects.nonNull(subCompositeObject)) {
								MetaOperation subMetaOperation = (MetaOperation) subCompositeObject;
								MetaOperation metaOperationCollectionSrcSub = (MetaOperation) subCompositeObjectSrc;
								TagNode tagNode1 = toExtendOperationDetailNode(fieldTable, j, subMetaOperation, metaOperationCollectionSrcSub);
								tagNode.addNode(tagNode1);
							} else {
								TagNode tagNode1 = toOperationDetailNode(fieldTable, j,vestFlag);
								tagNode.addNode(tagNode1);
							}

						}
					}
				} else {
					String tableType = collecTable.getString(i, "TableType");
					if ("1".equals(tableType)) {
						TagNode tagNode = toOperationNode(collecTable, i,vestFlag);
						operationCollectionNode.addNode(tagNode);
						for (int j = 0; j < fieldTable.size(); j++) {
							if (RowState.DELETED != fieldTable.getState(j)) {
								TagNode tagNode1 = toOperationDetailNode(fieldTable, j,vestFlag);
								tagNode.addNode(tagNode1);
							}
						}
					} else {
						TagNode tagNode = toOperationNode(collecTable, i,vestFlag);
						String refKey = tagNode.getAttributes().get("RefKey");
						String Key = tagNode.getAttributes().get("Key");
						String Caption = tagNode.getAttributes().get("Caption");
						if (StringUtils.isNotEmpty(refKey)) {
							tagNode = new TagNode(tagNode.getTagName(), null);
							tagNode.setAttribute("Key", Key);
							tagNode.setAttribute("Caption", Caption);
							tagNode.setAttribute("RefKey", refKey);
							operationCollectionNode.addNode(tagNode);
						} else {
							operationCollectionNode.addNode(tagNode);
						}
					}
				}
			} else {
				String tableType = collecTable.getString(i, "TableType");
				if ("1".equals(tableType)) {
					TagNode tagNode = toOperationNode(collecTable, i,vestFlag);
					operationCollectionNode.addNode(tagNode);
					for (int j = 0; j < fieldTable.size(); j++) {
						if (RowState.DELETED != fieldTable.getState(j)) {
							TagNode tagNode1 = toOperationDetailNode(fieldTable, j,vestFlag);
							tagNode.addNode(tagNode1);
						}
					}
				} else {
					TagNode tagNode = toOperationNode(collecTable, i,vestFlag);
					String refKey = tagNode.getAttributes().get("RefKey");
					String Key = tagNode.getAttributes().get("Key");
					String Caption = tagNode.getAttributes().get("Caption");
					if (StringUtils.isNotEmpty(refKey)) {
						tagNode = new TagNode(tagNode.getTagName(), null);
						tagNode.setAttribute("Key", Key);
						tagNode.setAttribute("Caption", Caption);
						tagNode.setAttribute("RefKey", refKey);
						operationCollectionNode.addNode(tagNode);
					} else {
						operationCollectionNode.addNode(tagNode);
					}
				}
			}
		}
	}

	public static void dealMacroCollection(DataTable marcoTable, TagNode rootNode, boolean vestFlag, MetaMacroCollection parentMacroCollectionSrc) throws Throwable {

		if (marcoTable.isEmpty()) {
			rootNode.deleteChildByTagName(MetaMacroCollection.TAG_NAME);
			return;
		}
		TagNode macroCollection = rootNode.findFirstTagNodeByTagName(MetaMacroCollection.TAG_NAME);
		if (Objects.nonNull(macroCollection)) {
			macroCollection.deleteChildByTagName(ConstantUtil.MACRO);
		} else {
			macroCollection = new TagNode(MetaMacroCollection.TAG_NAME, null);
			rootNode.addNode(macroCollection);
		}
		marcoTable.setShowDeleted(true);
		for (int j = 0; j < marcoTable.size(); j++) {
			int state = marcoTable.getState(j);
			String dataSourceType = marcoTable.getString(j, ConstantUtil.DataSourceType);
			//保证来源于其他的不写入xml
			if (!dataSourceType.isEmpty() && !dataSourceType.equalsIgnoreCase("xml")) {
				continue;
			}

			if (state == RowState.DELETED) {
				String keyDetail = marcoTable.getString(j, "Key");
				macroCollection.deleteChildByTagKey(keyDetail);
				continue;
			}
			String keyDetail = marcoTable.getString(j, "Key");
			String argsDetail = marcoTable.getString(j, "Args");
			String formulaDetail = marcoTable.getString(j, "Formula");
			MetaMacro metaMacroSrc = null;
			if (parentMacroCollectionSrc != null) {
				metaMacroSrc = parentMacroCollectionSrc.get(keyDetail);
			}
			if (!vestFlag || metaMacroSrc == null) {//非马甲
				TagNode macro = new TagNode(ConstantUtil.MACRO, null);
				macroCollection.addNode(macro);
				macro.setAttribute(ConstantUtil.KEY, keyDetail);
				if (StringUtils.isNotEmpty(argsDetail)) {
					macro.setAttribute(ConstantUtil.ARGS, argsDetail);
				}

				if (StringUtils.isNotEmpty(formulaDetail)) {
					CDataNode cNode = new CDataNode(formulaDetail, null);
					macro.addNode(cNode);
				}
				continue;
			}
			TagNode macro = new TagNode(ConstantUtil.MACRO, null);
			macroCollection.addNode(macro);
			macro.setAttribute(ConstantUtil.KEY, keyDetail);
			if (StringUtils.isNotEmpty(argsDetail)) {
				if (!StringUtils.equals(metaMacroSrc.getArgs(), argsDetail)) {
					macro.setAttribute(ConstantUtil.ARGS, argsDetail);
				}
			}
			if (StringUtils.isNotEmpty(formulaDetail)) {
				if (!StringUtils.equals(metaMacroSrc.getContent(), formulaDetail)) {
					CDataNode cNode = new CDataNode(formulaDetail, null);
					macro.addNode(cNode);
				}
			}
		}
	}

	private static TagNode toOperationNode(DataTable collecTable, int i,boolean vestFlag) {
		String tableType = collecTable.getString(i, "TableType");
		String tagName = StringUtils.equals(tableType, "1") ? ConstantUtil.OPERATION_COLLECTION : ConstantUtil.OPERATION;
		TagNode tagNode = new TagNode(tagName, null);

		String tableMark = collecTable.getString(i, "TableMark");
		String tableCaption = collecTable.getString(i, "TableCaption");
		String tableEnable = collecTable.getString(i, "TableEnable");
		String tableVisible = collecTable.getString(i, "TableVisible");
		String tableRefKey = collecTable.getString(i, "TableRefKey");
		String EnableDependency = collecTable.getString(i, ConstantUtil.ENABLE_DEPENDENCY);
		String VisibleDependency = collecTable.getString(i, ConstantUtil.VISIBLE_DEPENDENCY);
		String tableTag = collecTable.getString(i, "TableTag");
		String tableAction = collecTable.getString(i, "TableAction");
		String shortCuts = collecTable.getString(i, "ShortCuts");
		String needAccessLog = collecTable.getString(i, "NeedAccessLog");
		String activity = collecTable.getString(i, "GetActivity");
		String tCode = collecTable.getString(i, "GetTCode");
		String expand = collecTable.getString(i, "Expand");
		String expandSource = collecTable.getString(i, "ExpandSource");
		String selfDisable = collecTable.getString(i, ConstantUtil.SELF_DISABLE);
		String isTransfer = collecTable.getString(i, "IsTransfer");

		tagNode.setAttribute(ConstantUtil.KEY, tableMark);
		if (!StringUtils.isEmpty(tableCaption)) {
			tagNode.setAttribute(ConstantUtil.CAPTION, tableCaption);
		}
		if (!StringUtils.isEmpty(shortCuts)) {
			tagNode.setAttribute("ShortCuts", shortCuts);
		}
		if (!StringUtils.isEmpty(tableEnable)) {
			tagNode.setAttribute(ConstantUtil.ENABLE, tableEnable);
		}
		if (!StringUtils.isEmpty(tableVisible)) {
			tagNode.setAttribute(ConstantUtil.VISIBLE, tableVisible);
		}
		if (!StringUtils.isEmpty(tableRefKey)) {
			tagNode.setAttribute(ConstantUtil.REF_KEY, tableRefKey);
		}
		if (!StringUtils.isEmpty(tableTag)) {
			tagNode.setAttribute(ConstantUtil.TAG, tableTag);
		}
		if (!StringUtils.isEmpty(EnableDependency)) {
			tagNode.setAttribute(ConstantUtil.ENABLE_DEPENDENCY, EnableDependency);
		}
		if (!StringUtils.isEmpty(VisibleDependency)) {
			tagNode.setAttribute(ConstantUtil.VISIBLE_DEPENDENCY, VisibleDependency);
		}
		if (!StringUtils.isEmpty(needAccessLog)) {
			tagNode.setAttribute("NeedAccessLog", needAccessLog);
		}
		if (!StringUtils.isEmpty(activity)) {
			tagNode.setAttribute("Activity", activity);
		}
		if (!StringUtils.isEmpty(tCode)) {
			tagNode.setAttribute("TCode", tCode);
		}
		if (!StringUtils.isEmpty(expandSource)) {
			tagNode.setAttribute("ExpandSource", expandSource);
		}
		if (!StringUtils.isEmpty(expand)) {
			tagNode.setAttribute("Expand", expand);
		}
		if (!StringUtils.isEmpty(selfDisable)) {
			tagNode.setAttribute(ConstantUtil.SELF_DISABLE, selfDisable);
		}

		if (!StringUtils.isEmpty(tableAction)) {
			TagNode action = new TagNode(ConstantUtil.ACTION, null);
			CDataNode cDataNode = new CDataNode(tableAction, null);
			action.addNode(cDataNode);
			tagNode.addNode(action);
		}
		tagNode.setAttribute("IsTransfer", isTransfer);

		if (vestFlag){
			Integer TC_IsFirst = collecTable.getInt(i, "TC_IsFirst");
			Integer TC_IsLast = collecTable.getInt(i, "TC_IsLast");
			boolean TC_IsFirstorTC_IsFirst = false;
			if (TC_IsFirst ==1){
				tagNode.setAttribute("First", String.valueOf(true));
				TC_IsFirstorTC_IsFirst = true;
			}
			if (TC_IsLast ==1){
				tagNode.setAttribute("Last", String.valueOf(true));
				TC_IsFirstorTC_IsFirst = true;
			}
			if (!TC_IsFirstorTC_IsFirst){
				if (i + 1 < collecTable.size()) {
					String key = collecTable.getString(i + 1, "TableMark");
					tagNode.setAttribute("SideKey", key);
					tagNode.setAttribute("InsertAfter", "false");
				} else if (i == collecTable.size() - 1) {
					String key = collecTable.getString(i - 1, "TableMark");
					tagNode.setAttribute("SideKey", key);
					tagNode.setAttribute("InsertAfter", "true");
				}

			}
		}
		return tagNode;
	}

	private static TagNode toExtendOperationNode(DataTable collecTable, int i, MetaOperation metaOperationSrc) {
		TagNode tagNode = new TagNode(ConstantUtil.OPERATION, null);

		String tableMark = collecTable.getString(i, "TableMark");
		tagNode.setAttribute(ConstantUtil.KEY, tableMark);

		String tableCaption = collecTable.getString(i, "TableCaption");
		if (!StringUtils.equals(tableCaption, metaOperationSrc.getCaption())) {
			tagNode.setAttribute(ConstantUtil.CAPTION, tableCaption);
		}

		String tableVisible = collecTable.getString(i, "TableVisible");
		if (!StringUtils.equals(metaOperationSrc.getVisible(), tableVisible)) {
			tagNode.setAttribute(ConstantUtil.VISIBLE, tableVisible);
			String visibleDependency = collecTable.getString(i, ConstantUtil.VISIBLE_DEPENDENCY);
			if (StringUtils.isNotEmpty(visibleDependency)) {
				tagNode.setAttribute(ConstantUtil.VISIBLE_DEPENDENCY, visibleDependency);
			}
		}

		String tableEnable = collecTable.getString(i, "TableEnable");
		if (!StringUtils.equals(metaOperationSrc.getEnable(), tableEnable)) {
			tagNode.setAttribute(ConstantUtil.ENABLE, tableEnable);

			String enableDependency = collecTable.getString(i, ConstantUtil.ENABLE_DEPENDENCY);
			if (StringUtils.isNotEmpty(enableDependency)) {
				tagNode.setAttribute(ConstantUtil.ENABLE_DEPENDENCY, enableDependency);
			}
		}
		String tableAction = collecTable.getString(i, "TableAction");
		MetaBaseScript actionSrc = metaOperationSrc.getAction();
		if (actionSrc == null) {
			actionSrc = new MetaBaseScript("");
		}
		if (!StringUtils.equals(actionSrc.getContent(), tableAction)) {
			TagNode actionTagNode = new TagNode(ConstantUtil.ACTION, null);
			actionTagNode.setCDataValue(tableAction);
			tagNode.addNode(actionTagNode);
		}
		Integer TC_IsFirst = collecTable.getInt(i, "TC_IsFirst");
		Integer TC_IsLast = collecTable.getInt(i, "TC_IsLast");
		boolean TC_IsFirstorTC_IsFirst = false;
		if (TC_IsFirst ==1){
			tagNode.setAttribute("First", String.valueOf(true));
			TC_IsFirstorTC_IsFirst = true;
		}
		if (TC_IsLast ==1){
			tagNode.setAttribute("Last", String.valueOf(true));
			TC_IsFirstorTC_IsFirst = true;
		}
		if (!TC_IsFirstorTC_IsFirst){
			if (i + 1 < collecTable.size()) {
				String key = collecTable.getString(i + 1, "TableMark");
				tagNode.setAttribute("SideKey", key);
				tagNode.setAttribute("InsertAfter", "false");
			} else if (i == collecTable.size() - 1) {
				String key = collecTable.getString(i - 1, "TableMark");
				tagNode.setAttribute("SideKey", key);
				tagNode.setAttribute("InsertAfter", "true");
			}

		}

		return tagNode;
	}

	private static TagNode toExtendOperationNode(DataTable collecTable, int i, MetaOperationCollection metaOperationSrc) {
		TagNode tagNode = new TagNode(ConstantUtil.OPERATION_COLLECTION, null);

		String tableMark = collecTable.getString(i, "TableMark");
		tagNode.setAttribute(ConstantUtil.KEY, tableMark);

		String tableCaption = collecTable.getString(i, "TableCaption");
		if (!StringUtils.equals(tableCaption, metaOperationSrc.getCaption())) {

			tagNode.setAttribute(ConstantUtil.CAPTION, tableCaption);
		}

		String tableVisible = collecTable.getString(i, "TableVisible");
		if (!StringUtils.equals(metaOperationSrc.getVisible(), tableVisible)) {
			tagNode.setAttribute(ConstantUtil.VISIBLE, tableVisible);

			String visibleDependency = collecTable.getString(i, ConstantUtil.VISIBLE_DEPENDENCY);
			if (StringUtils.isNotEmpty(visibleDependency)) {
				tagNode.setAttribute(ConstantUtil.VISIBLE_DEPENDENCY, visibleDependency);
			}
		}

		String tableEnable = collecTable.getString(i, "TableEnable");
		if (!StringUtils.equals(metaOperationSrc.getEnable(), tableEnable)) {
			tagNode.setAttribute(ConstantUtil.ENABLE, tableEnable);

			String enableDependency = collecTable.getString(i, ConstantUtil.ENABLE_DEPENDENCY);
			if (StringUtils.isNotEmpty(enableDependency)) {
				tagNode.setAttribute(ConstantUtil.ENABLE_DEPENDENCY, enableDependency);
			}
		}
		String tableAction = collecTable.getString(i, "TableAction");
		MetaBaseScript actionSrc = metaOperationSrc.getAction();
		if (actionSrc == null) {
			actionSrc = new MetaBaseScript("");
		}
		if (!StringUtils.equals(actionSrc.getContent(), tableAction)) {
			TagNode actionTagNode = new TagNode(ConstantUtil.ACTION, null);
			actionTagNode.setCDataValue(tableAction);
			tagNode.addNode(actionTagNode);
		}

		if (i + 1 < collecTable.size()) {
			String key = collecTable.getString(i + 1, "TableMark");
			tagNode.setAttribute("SideKey", key);
			tagNode.setAttribute("InsertAfter", "false");
		} else if (i == collecTable.size() - 1) {
			String key = collecTable.getString(i - 1, "TableMark");
			tagNode.setAttribute("SideKey", key);
			tagNode.setAttribute("InsertAfter", "true");
		}
		return tagNode;
	}

	private static TagNode toOperationDetailNode(DataTable fieldTable, int j,boolean vestFlag) {
		TagNode tagNode1 = new TagNode(ConstantUtil.OPERATION, null);
		String tableMark1 = fieldTable.getString(j, "TableMark");
		String tableCaption1 = fieldTable.getString(j, "TableCaption");
		String tableEnable1 = fieldTable.getString(j, "TableEnable");
		String tableVisible1 = fieldTable.getString(j, "TableVisible");
		String enableDependency = fieldTable.getString(j, "EnableDependency");
		String visibleDependency = fieldTable.getString(j, "VisibleDependency");
		String tableRefKey1 = fieldTable.getString(j, "TableRefKey");
		String tableTag1 = fieldTable.getString(j, "TableTag");
		String tableAction1 = fieldTable.getString(j, "TableAction");
		String subShortCuts = fieldTable.getString(j, "ShortCuts");
		String subNeedAccessLog = fieldTable.getString(j, "NeedAccessLog");
		String tCode = fieldTable.getString(j, "GetTCode");
		String activity = fieldTable.getString(j, "GetActivity");
		String subExpand = fieldTable.getString(j, "Expand");
		String subExpandSource = fieldTable.getString(j, "ExpandSource");
		String isTransfer = fieldTable.getString(j, "IsTransfer");
		tagNode1.setAttribute(ConstantUtil.KEY, tableMark1);
		if (!StringUtils.isEmpty(tableCaption1)) {
			tagNode1.setAttribute(ConstantUtil.CAPTION, tableCaption1);
		}
		if (!StringUtils.isEmpty(subShortCuts)) {
			tagNode1.setAttribute("ShortCuts", subShortCuts);
		}
		tagNode1.setAttribute("IsTransfer", isTransfer);
		if (!StringUtils.isEmpty(tableEnable1)) {
			tagNode1.setAttribute(ConstantUtil.ENABLE, tableEnable1);
		}
		if (!StringUtils.isEmpty(enableDependency)) {
			tagNode1.setAttribute(ConstantUtil.ENABLE_DEPENDENCY, enableDependency);
		}
		if (!StringUtils.isEmpty(visibleDependency)) {
			tagNode1.setAttribute(ConstantUtil.VISIBLE_DEPENDENCY, visibleDependency);
		}
		if (!StringUtils.isEmpty(tableVisible1)) {
			tagNode1.setAttribute(ConstantUtil.VISIBLE, tableVisible1);
		}
		if (!StringUtils.isEmpty(tableRefKey1)) {
			tagNode1.setAttribute(ConstantUtil.REF_KEY, tableRefKey1);
		}
		if (!StringUtils.isEmpty(tableTag1)) {
			tagNode1.setAttribute(ConstantUtil.TAG, tableTag1);
		}
		if (!StringUtils.isEmpty(subNeedAccessLog)) {
			tagNode1.setAttribute("NeedAccessLog", subNeedAccessLog);
		}
		if (!StringUtils.isEmpty(activity)) {
			tagNode1.setAttribute("Activity", activity);
		}
		if (!StringUtils.isEmpty(tCode)) {
			tagNode1.setAttribute("TCode", tCode);
		}
		if (!StringUtils.isEmpty(subExpand)) {
			tagNode1.setAttribute("Expand", subExpand);
		}
		if (!StringUtils.isEmpty(subExpandSource)) {
			tagNode1.setAttribute("ExpandSource", subExpandSource);
		}
		if (!StringUtils.isEmpty(tableAction1)) {
			TagNode subAction = new TagNode(ConstantUtil.ACTION, null);
			CDataNode cDataNode = new CDataNode(tableAction1, null);
			subAction.addNode(cDataNode);
			tagNode1.addNode(subAction);
		}

		if (vestFlag){
			if (j + 1 < fieldTable.size()) {
				String key = fieldTable.getString(j + 1, "TableMark");
				tagNode1.setAttribute("SideKey", key);
				tagNode1.setAttribute("InsertAfter", "false");
			} else if (j == fieldTable.size() - 1) {
				String key = fieldTable.getString(j - 1 <0?0:j - 1, "TableMark");
				if (!tableMark1.equalsIgnoreCase(key)){
					tagNode1.setAttribute("SideKey", key);
					tagNode1.setAttribute("InsertAfter", "true");
				}
			}
		}

		return tagNode1;
	}

	private static TagNode toExtendOperationDetailNode(DataTable fieldTable, int i, MetaOperation metaOperation, MetaOperation metaOperationSrc) {
		TagNode tagNode = new TagNode(ConstantUtil.OPERATION, null);

		String subTableMark = fieldTable.getString(i, "TableMark");
		tagNode.setAttribute(ConstantUtil.KEY, subTableMark);

		String subTableCaption = fieldTable.getString(i, "TableCaption");
		String caption = metaOperation.getCaption();
		if (!StringUtils.equals(subTableCaption, metaOperationSrc.getCaption())) {
			tagNode.setAttribute(ConstantUtil.CAPTION, subTableCaption);
		}

		String subTableVisible = fieldTable.getString(i, "TableVisible");
		String visible = metaOperation.getVisible();
		if (!StringUtils.equals(metaOperationSrc.getVisible(), subTableVisible)) {
			tagNode.setAttribute(ConstantUtil.VISIBLE, subTableVisible);
			String subTableVisibleDependency = fieldTable.getString(i, "VisibleDependency");
			if (StringUtils.isNotEmpty(subTableVisibleDependency)) {
				tagNode.setAttribute(ConstantUtil.VISIBLE_DEPENDENCY, subTableVisibleDependency);
			}
		}

		String subTableEnable = fieldTable.getString(i, "TableEnable");
		String enable = metaOperation.getEnable();
		if (!StringUtils.equals(metaOperationSrc.getEnable(), subTableEnable)) {
			tagNode.setAttribute(ConstantUtil.ENABLE, subTableEnable);

			String subTableEnableDependency = fieldTable.getString(i, "EnableDependency");
			if (StringUtils.isNotEmpty(subTableEnableDependency)) {
				tagNode.setAttribute(ConstantUtil.ENABLE_DEPENDENCY, subTableEnableDependency);
			}
		}
		String tableAction = fieldTable.getString(i, "TableAction");
		MetaBaseScript action1 = metaOperation.getAction();
		if (action1 == null) {
			action1 = new MetaBaseScript("");
		}
		String action = action1.getContent();
		MetaBaseScript actionSrc = metaOperationSrc.getAction();
		if (actionSrc == null) {
			actionSrc = new MetaBaseScript("");
		}
		if (!StringUtils.equals(actionSrc.getContent(), tableAction)) {
			TagNode actionTagNode = new TagNode(ConstantUtil.ACTION, null);
			actionTagNode.setCDataValue(tableAction);
			tagNode.addNode(actionTagNode);
		}
		return tagNode;
	}
}
