package com.bokesoft.yes.design.mergesingle.util;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.MetaObjectType;
import com.bokesoft.yes.design.cmd.UICommand;
import com.bokesoft.yes.design.mergesingle.common.MergeSingleDiffUtil;
import com.bokesoft.yes.design.mergesingle.impl.SingleSettingImpl;
import com.bokesoft.yes.design.xml.XmlParser;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.design.xml.node.XmlTree;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaExtraLayout;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaGridLayoutPanel;
import com.bokesoft.yigo.struct.document.Document;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;

public class ExtraLayoutOperUtil extends SingleSettingImpl {
    @Override
    public void dealData(Document document, Diff diff, JSONObject jsonObject) throws Throwable {
        TagNode tagNode = diff.getXmlTree().xmlTree.getTagNode(MetaGridLayoutPanel.TAG_NAME + "@" + diff.getKey());
        if (StringUtils.isNotEmpty(diff.getReserveOne())) {
            XmlTree parse = XmlParser.parse(diff.getReserveOne(), false, false);
            tagNode.deleteChildByTagName(MetaExtraLayout.TAG_NAME);
            if (parse.getRoot().getChildren().size() > 0) {
                tagNode.addNode(parse.getRoot(), tagNode.getChildren().size() - 6);
            }
        } else {
            tagNode.deleteChildByTagName(MetaObjectType.ExtraLayout.name);
        }
        setTagNode(tagNode);
    }
}
