package com.bokesoft.yes.design.mergesingle.impl;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.cmd.MetaFormDiffProcessor;
import com.bokesoft.yes.design.cmd.UICommand;
import com.bokesoft.yes.design.mergesingle.common.MergeSingleDiffUtil;
import com.bokesoft.yes.design.vo.ResponseResult;
import com.bokesoft.yes.design.vo.SettingVo;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.helper.DocumentHelper;
import com.bokesoft.yigo.struct.document.Document;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;


public abstract class SingleSettingImpl implements SingleSettingService {
    TagNode tagNode;

    public TagNode getTagNode() {
        return tagNode;
    }

    public void setTagNode(TagNode tagNode) {
        this.tagNode = tagNode;
    }

    public String reload(Map<String, String> tmpFiles) throws Throwable {
        return MetaFormDiffProcessor.instance.processDiffReloadForm(null,tmpFiles);
    }
    /**
     * 处理数据对象XML
     */

    public ResponseResult<JSONObject> handleData(SettingVo settingVo) throws Throwable {
        ResponseResult<JSONObject> result = new ResponseResult<>();
        JSONObject jsonObject = new JSONObject();
        //处理document数据
        Document document = getDocument(settingVo);
        String diffStr = settingVo.getDiff();
        Diff diff = MergeSingleDiffUtil.getDiffByJson(diffStr);
        String type = settingVo.getType();
        Diff.loadXmlTree(diff);
        dealData(document, diff, jsonObject);
        MergeSingleDiffUtil.genSingleXmlDiff(getTagNode(), diff);
        Map<String, String> stringMap = MergeSingleDiffUtil.processSingleXmlDiff(diff);
        String xmlError = reload(stringMap);
        List<UICommand> uiCommands = getUiCommands(diff);
        if (StringUtils.isNotEmpty(xmlError) && !"操作成功".equals(xmlError)) {
            uiCommands.add(UICommand.showError(xmlError));
        } else {
            uiCommands.add(UICommand.showTip("操作成功"));
        }
        result.setCode(0);
        result.setMsg("操作" + type + "成功");
        jsonObject.put("msg", "操作" + type + "成功");
        jsonObject.put("UICommand",uiCommands);
        result.setData(jsonObject);
        return result;
    }

    public  List<UICommand> getUiCommands(Diff diff) {
        List<UICommand> result1 = new ArrayList<>();
        result1.add(UICommand.reloadFormKey(diff.formKey));
        result1.add(UICommand.reloadXmlSource(diff.getFilePath()));
        return result1;
    }

    protected static Document getDocument(SettingVo settingVo) throws Throwable {
        String docStr = settingVo.getDocument();
        Document document = DocumentHelper.parseDocumentFormJSON(docStr);
        return document;
    }
}
