package com.bokesoft.yes.design.mergesingle.common;

import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.cmd.CheckXMLChanged;
import com.bokesoft.yes.design.cmd.ReplaceStringEntry;
import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;

import java.util.LinkedHashMap;
import java.util.Map;

public class MergeSingleDiffUtil {
    public static void genSingleXmlDiff(TagNode node, Diff diff) {
        if (node == null){
            throw new RuntimeException("TagNode未赋值");
        }
        XmlTreeWithPath xmlTree = diff.getXmlTree();
        int startLine = xmlTree.xmlTree.getLineByIndex(node.getElement().getBgIndex());
        String orgXmlFragment;
        orgXmlFragment = xmlTree.xmlTree.getNodeString(startLine);
        String newXmlFragment = DesignIOMetaUtil.getXml(node);
        diff.setXmlDiff(xmlTree, startLine, orgXmlFragment, newXmlFragment);
    }

    public static Diff getDiffByJson(String jsonDiff) throws Throwable {
        JSONArray array = new JSONArray(jsonDiff);
        Diff diff = Diff.fromJson(array.getJSONObject(0));
        return diff;
    }
    public static Map<String, String> processSingleXmlDiff(Diff diff) throws Throwable {
        Map<String, String> result = new LinkedHashMap<>();
        Map<String, String> orgXmls = new LinkedHashMap<>();
        XmlTreeWithPath xmlTree = diff.getXmlTree();
        if (xmlTree != null) {
            String xmlFilePath = xmlTree.orgFilePath;
            if (xmlFilePath != null && !orgXmls.containsKey(xmlFilePath)) {
                orgXmls.put(xmlFilePath, xmlTree.xmlTree.getOrgXml());
            }
        }
        String orgFilePath = diff.getXmlTree().orgFilePath;
        String orgXml = diff.getXmlTree().xmlTree.getOrgXml();
        orgXml = mergeSingleDiff(orgXml, diff);
        orgXmls.put(orgFilePath, orgXml);
        for (Map.Entry<String, String> entry : orgXmls.entrySet()) {
            String filePath = entry.getKey();
            String newContent = entry.getValue();
            boolean isPropertyDiff = true;
            String key, tmpFilePath;
            if (StringUtils.isNotBlank(filePath)) {
                key = LoadFileTree.getProjectKey(filePath);
            } else {
                key = MetaFactory.getGlobalInstance().getMetaFormList().get(diff.formKey).getProject().getKey();
            }
//            if (!isPropertyDiff) {
                tmpFilePath = XmlFileProcessor.instance.saveTempFile(filePath, newContent,key);
//            } else {
//                tmpFilePath = XmlFileProcessor.instance.saveSortedTempFile(diff, filePath, newContent, key);
//            }
            result.put(tmpFilePath, newContent);
        }
        return result;
    }

    public static String mergeSingleDiff(String xml, Diff diff) throws Throwable {
        String result = xml;
        ReplaceStringEntry entry = diff.isPropertyDiff() ? new ReplaceStringEntry() : null;
        int startLine = diff.getStartLine();
        String orgXmlFragment = diff.getOrgXmlFragment();
        String newXmlFragment = diff.getNewXmlFragment();
        boolean insertIndent = diff.isPropertyDiff() && !diff.isGridColumnDrag(); // 如果是根据属性差异生成的xml需要插入缩进
        result = CheckXMLChanged.mergeXML(result, startLine, orgXmlFragment, newXmlFragment, entry, insertIndent);
        int startLine2 = diff.getStartLine2();
        if (startLine2 != Diff.INT_InvalidLine) {
            ReplaceStringEntry entry2 = diff.isPropertyDiff() ? new ReplaceStringEntry() : null;
            result = CheckXMLChanged.mergeXML(result, startLine2, diff.getOrgXmlFragment2(), diff.getNewXmlFragment2(), entry2, insertIndent);
        }
        return result;
    }
}