package com.bokesoft.yes.design.io.loader;

import com.bokesoft.yes.design.metaobjecttype.MetaQueryDefType;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.document.Document;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class IODataObjectLoader {

    private static final Map<String, IODataObjectLoadable> LOADER_MAP = new HashMap<>();
    
    static {
        LOADER_MAP.put("D_ComboBoxQueryDef", new MetaQueryDefType());
        // 添加其他 MetaDataObject 类型的加载类
    }

    public Document load(Document document, MetaDataObject metaDataObject, DefaultContext context) throws Throwable {
        String key = metaDataObject.getKey();
        IODataObjectLoadable loader = LOADER_MAP.get(key);
        if (Objects.isNull(loader)) {
            throw new IllegalArgumentException("No loader for key " + key);
        }
        return loader.load(document, context, metaDataObject);
    }
}