package com.bokesoft.yes.design.io;

import com.google.common.collect.ImmutableMap;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TreeNode {
    private final Map<String, TreeNode> nodeMap = new HashMap<String, TreeNode>();
    /**
     * 根类型
     */
    public static final String TYPE_Root = "root";
    /**
     * 项目类型
     */
    public static final String TYPE_Project = "project";
    /**
     * solution类型
     */
    public static final String TYPE_SOLUTION = "solution";
    /**
     * 目录类型
     */
    public static final String TYPE_Fold = "fold";
    /**
     * 文件类型
     */
    public static final String TYPE_File = "file";

    /**
     * 文件路径
     */
    public String key;
    final public String type;
    public String parentKey = null;
    /**
     * 文件名，比如FI_Voucher.xml
     */
    public String name;
    public String description;
    /**
     * 记录Name的全路径
     */
    public String namePath;
    public String focusRowChangedFormula;
    public int allChildrenCount = 0;
    public String projectKey = null;
    public String solutionKey = null;
    public boolean isInJar;

    /**
     * 点击实际弹出表单的映射表
     */
    public static final Map<String, String> actionFileReflection = ImmutableMap.<String, String>builder()
            .put("CommonDef", "D_CommonDef")
            .put("Entry", "D_Entry")
            .build();

    public List<TreeNode> children;


    public TreeNode(String key) {
        this.key = key;
        this.type = TYPE_Root;
        this.namePath = null;
    }
    public TreeNode(String name, String type, String description, String key, String parentKey, String projectKey, String solutionKey) {
        this.key = key.replace("\\\\", File.separator).replace('\\', File.separatorChar).replace('/', File.separatorChar);
        this.type = type;
        this.parentKey = parentKey.replace("\\\\", File.separator).replace('\\', File.separatorChar).replace('/', File.separatorChar);
        this.name = name;
        this.description = description;
        this.projectKey = projectKey;
        this.solutionKey = solutionKey;
    }

    public void addChild(TreeNode node) {
        if (!node.isInJar) {
            node.isInJar = this.isInJar;
        }
        node.key = node.key.replace("\\\\", File.separator).replace('\\', File.separatorChar).replace('/', File.separatorChar);
        node.parentKey = node.parentKey.replace("\\\\", File.separator).replace('\\', File.separatorChar).replace('/', File.separatorChar);

        Tree.map.put(node.key, node);
        nodeMap.put(node.key, node);
        String parentKey = node.parentKey;
        TreeNode parent = Tree.map.get(parentKey);
        if (parent != null) {
            if (parent.namePath == null) {
                node.namePath = node.name;
            } else {
                node.namePath = parent.namePath + File.separator + node.name;
            }
        }
        Tree.setNodeFocusRowChangedFormula(node, parentKey);
        if (children == null) {
            children = new ArrayList<TreeNode>();
        }
        children.add(node);
        allChildrenCount++;
    }

    public TreeNode getChildNode(String key) {
        return nodeMap.get(key);
    }

    public void removeChild(TreeNode node) {
        children.remove(node);
        allChildrenCount--;
    }

    @Override
    public int hashCode() {
        return key.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof TreeNode)) {
            return false;
        }
        return key.equals(((TreeNode) other).key);
    }
}