package com.bokesoft.yes.design.io;

import com.bokesoft.yes.helper.FilePathHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Tree {
    public TreeNode root;
    public static Map<String, TreeNode> map = new HashMap<String, TreeNode>();

    /**
     * 新建树
     *
     * @param rootKey 为了支持森林（多个root），建议一个虚拟的Root
     */
    public Tree(String rootKey) {
        root = new TreeNode(rootKey);
        map.put(rootKey, root);
    }

    public void addTreeNode(TreeNode node) {
        node.key = FilePathHelper.toBackFilePath(node.key);
        node.parentKey = FilePathHelper.toBackFilePath(node.parentKey);
        if (map.containsKey(node.key)) {
            return;
        }
        map.put(node.key, node);
        TreeNode parent = map.get(node.parentKey);
        parent.children.add(node);
        parent.allChildrenCount++;
		/*String parentParentKey = parent.parentKey;
		while (parentParentKey != null) {
			TreeNode parentParent = map.get(parentParentKey);
			parentParent.allChildrenCount++;
			parentParentKey = parentParent.parentKey;
		}*/
    }

    public void addTreeNode(TreeNode node, boolean create) {
        node.key = FilePathHelper.toBackFilePath(node.key);
        node.parentKey = FilePathHelper.toBackFilePath(node.parentKey);
        map.put(node.key, node);
        String parentKey = node.parentKey;
        if (!map.containsKey(parentKey)) {
            throw new RuntimeException("建树不对，找不到" + parentKey + "的父节点。");
        }
        TreeNode parent = map.get(parentKey);
        if (create) {
            if (CollectionUtils.isEmpty(parent.children) || !parent.children.contains(node)) {
                parent.addChild(node);
            }
        }
        String parentParentKey = parent.parentKey;
        while (parentParentKey != null) {
            TreeNode parentParent = map.get(parentParentKey);
            parentParentKey = parentParent.parentKey;
        }
        if (StringUtils.isBlank(parent.namePath)) {
            node.namePath = node.name;
        } else {
            node.namePath = parent.namePath + File.separator + node.name;
        }
        setNodeFocusRowChangedFormula(node, parentKey);
    }

    static void setNodeFocusRowChangedFormula(TreeNode node, String parentKey) {
        if (Objects.equals(node.type, TreeNode.TYPE_File)) {
            String key = node.name.substring(0, node.name.length() - ".xml".length());
            node.focusRowChangedFormula = "showSource('" + node.key + "', '" +
                    node.namePath + "', '" + TreeNode.actionFileReflection.getOrDefault(key, key) +
                    "', '" + parentKey + "')";
        }
    }

    public void removeTreeNode(TreeNode node) {
        map.remove(node.key);
        String parentKey = node.parentKey;
        if (!map.containsKey(parentKey)) {
            throw new RuntimeException("建树不对，找不到" + parentKey + "的父节点。");
        }
        TreeNode parent = map.get(parentKey);
        parent.removeChild(node);
        String parentParentKey = parent.parentKey;
        while (parentParentKey != null) {
            TreeNode parentParent = map.get(parentParentKey);
            parentParentKey = parentParent.parentKey;
        }
    }

    public TreeNode getNode(String key) {
        return map.get(key);
    }
}