package com.bokesoft.yes.design.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.bokesoft.distro.tech.bootsupport.starter.deployment.SpringResourceMultiSolutionMetaResolverFactory;
import com.bokesoft.distro.tech.yigosupport.deployment.resource.ResourceMultiSolutionResolver;
import com.bokesoft.distro.tech.yigosupport.deployment.resource.utils.ResourcePaths;
import com.bokesoft.erp.WebDesignerConfiguration;
import com.bokesoft.erp.design.config.ERPWebDesignerMetaFactory;
import com.bokesoft.erp.register.ErpConfig;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.cmd.DeleteXmlFileCmd;
import com.bokesoft.yes.design.cmd.EntryProcessor;
import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.newproject.CreateEmptyProjectAction;
import com.bokesoft.yes.design.utils.IDLookup;
import com.bokesoft.yes.design.vo.RecycleForm;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.erpdatamap.ERPMetaMap;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.meta.persist.dom.DomMetaConstants;
import com.bokesoft.yes.meta.persist.dom.commondef.MetaCommonDefLoad;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.mobiledef.MetaMobileDefLoad;
import com.bokesoft.yes.meta.persist.dom.solution.MetaProjectLoad;
import com.bokesoft.yes.mid.hotdeploy.MidMetaFactoryManager;
import com.bokesoft.yes.mid.meta.MidMetaFactory;
import com.bokesoft.yes.struct.abstractdatatable.SortCriteria;
import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.def.FormType;
import com.bokesoft.yigo.common.util.FileUtil;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.base.KeyPairCompositeObject;
import com.bokesoft.yigo.meta.common.MetaMacroCollection;
import com.bokesoft.yigo.meta.commondef.MetaCommonDef;
import com.bokesoft.yigo.meta.commondef.MetaOperationCollection;
import com.bokesoft.yigo.meta.dataelement.MetaDataElementDef;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigration;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigrationList;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectList;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.dataobject.MetaProcess;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.domain.MetaDomainDef;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelWorkbook;
import com.bokesoft.yigo.meta.factory.DefaultMetaFactory;
import com.bokesoft.yigo.meta.factory.DefaultMetaResolverFactory;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.IMetaResolverFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.component.MetaEmbed;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.meta.mobiledef.MetaMobileDef;
import com.bokesoft.yigo.meta.path.MetaSecurityFilter;
import com.bokesoft.yigo.meta.path.MetaSecurityFilterLoad;
import com.bokesoft.yigo.meta.report.MetaReport;
import com.bokesoft.yigo.meta.report.MetaReportProfile;
import com.bokesoft.yigo.meta.report.MetaReportSubList;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.meta.solution.MetaProjectCollection;
import com.bokesoft.yigo.meta.solution.MetaProjectProfile;
import com.bokesoft.yigo.meta.solution.MetaSolution;
import com.bokesoft.yigo.meta.strings.MetaStringTable;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.datatable.ColumnInfo;
import com.bokesoft.yigo.struct.datatable.DataTable;

public class LoadFileTree {
    private static final Logger log = LoggerFactory.getLogger(LoadFileTree.class);
    /**
     * 文件树，缓冲的目的是为了计算儿子数量
     */
    public static Tree tree;
    /**
     * 记录多solution DefaultMetaFactory
     */
    public static final Map<String, DefaultMetaFactory> metaDesignerFactoryMap = new LinkedHashMap<>();
    /**
     * 记录多solution solutionPath
     */
    public static final Map<String, String> metaDesignerSolutionPathMap = new LinkedHashMap<>();
    /**
     * 记录表单Key和这个表单所对应的文件路径
     */
    private static Map<String, TreeNode> mapFormKeyToXmlPath;
    /**
     * 记录数据对象Key和这个数据对象所对应的文件路径
     */
    private static Map<String, TreeNode> mapDataObjectKeyToXmlPath;
    public static Map<String, TreeNode> mapDataElementKeyToXmlPath;
    public static Map<String, TreeNode> mapDomainKeyToXmlPath;
    public static HashSet<String> loadImportSolutions = new HashSet<>();
    /**
     * 记录excelKey和这个excel所对应的文件路径
     */
    private static Map<String, Map<String, TreeNode>> excelKeyToXmlPath;//按照工程
    /**
     * 记录printKey和这个print所对应的文件路径
     */
    private static Map<String, Map<String, TreeNode>> printKeyToXmlPath;//按照表单key
    /**
     * 记录数据对象Key和这个数据映射所对应的文件路径
     */
    private static Map<String, TreeNode> mapDataKeyToXmlPath;
    /**
     * 记录数据对象Key和这个数据迁移所对应的文件路径
     */
    private static Map<String, TreeNode> mapDataMigrationToXmlPath;
    /**
     * 记录数据对象Key和这个工作流所对应的文件路径
     */
    private static Map<String, TreeNode> mapBpmKeyToXmlPath;

    private static Map<String, String> designableSolutionKeyMap = new HashMap<>();
    private static Set<String> jarProjectKey = new HashSet<>();

    private static DefaultMetaFactory primaryResolverFactory = null;

    /**
     * 根据父节点取下一层数据
     *
     * @param context
     * @param dataTable
     * @param parentKey
     * @throws Throwable
     */
    public static void loadFileTree(DefaultContext context, DataTable dataTable, String parentKey) throws Throwable {
        ensureLoad();

        if (!dataTable.getMetaData().constains("ChildrenCount")) {
            dataTable.addColumn(new ColumnInfo("ChildrenCount", DataType.INT));
        }
        if (StringUtils.isBlank(parentKey)) {
            parentKey = tree.root.key;
        }
        parentKey = FilePathHelper.toBackFilePath(parentKey);
        List<TreeNode> children = tree.getNode(parentKey).children;
        if (children != null) {
            for (TreeNode node : children) {
                addOneRecord(dataTable, node, tree.getNode(parentKey));
            }
        }
        SortCriteria[] sortCriteria = new SortCriteria[2];
        sortCriteria[1] = new SortCriteria("Key", true);
        sortCriteria[0] = new SortCriteria("Type", true);
        dataTable.setSort(sortCriteria);
        dataTable.sort();
    }

    private static TreeNode getTreeNodeByFormKey4HR(String formKey) {
        if (mapFormKeyToXmlPath.containsKey(formKey)) {
            return mapFormKeyToXmlPath.get(formKey);
        } else {
            if (formKey != null && formKey.length() > 1 && formKey.substring(formKey.length() - 2, formKey.length() - 1).equals("N")) {
                String orgFormKey = formKey.substring(0, formKey.length() - 2);
                return mapFormKeyToXmlPath.get(orgFormKey);
            } else if (formKey != null && formKey.length() == 1) {
                return mapFormKeyToXmlPath.get(formKey);
            }
            return null;
        }
    }

    public static TreeNode getTreeNodeByDataObjectKey4HR(String DataObject) {
        if (mapDataObjectKeyToXmlPath.containsKey(DataObject.toLowerCase())) {
            return mapDataObjectKeyToXmlPath.get(DataObject.toLowerCase());
        }
        return null;
    }

    private static MetaForm getMetaForm4HR(IMetaFactory metaFactory, String formKey) throws Throwable {
        if (formKey.charAt(formKey.length() - 2) == 'N') {
            String orgFormKey = formKey.substring(0, formKey.length() - 2);
            if (metaFactory.getMetaFormList().containsKey(orgFormKey)) {
                return metaFactory.getMetaForm(orgFormKey);
            }
        }
        return null;
    }

    /**
     * 取表单所有相关的文件
     *
     * @param context
     * @param formKey
     * @param entryParas
     * @return
     * @throws Throwable
     */
    public static List<String[]> loadFilePathsByFormKey(DefaultContext context, String formKey, String entryParas,
                                                        String container) throws Throwable {
        ensureLoad();
        if (Objects.isNull(getTreeNodeByFormKey4HR(formKey))) {
            return Collections.emptyList();
        }
        List<String[]> result = new ArrayList<String[]>();
        List<String[]> dataObjectResult = new ArrayList<String[]>();
        IMetaFactory metaFactory = context.getVE().getMetaFactory();
        if (StringUtils.isNotBlank(container)) {
            final MetaFormList metaFormList = metaFactory.getMetaFormList();
            final MetaDataObjectList dataObjectList = metaFactory.getDataObjectList();
            if (Objects.isNull(metaFormList.get(container)) && dataObjectList.get(container) != null) {
                TreeNode nodeDataObject = mapDataObjectKeyToXmlPath.get(container.toLowerCase());
                container = null;
                dataObjectResult.add(new String[]{nodeDataObject.key, nodeDataObject.namePath});
            }
        }
        loadFilePathsByFormKey(metaFactory, result, dataObjectResult, formKey, container);
        result.addAll(dataObjectResult);
        if (entryParas != null && entryParas.length() > 0) {
            String entryFormKey = entryParas;
            List<String[]> tmp = loadFilePathsByFormKey(context, entryFormKey, null, container);
            result.addAll(tmp);
        }
        if (container != null && container.length() > 0) {
            String entryFormKey = container;
            List<String[]> tmp = loadFilePathsByFormKey(context, entryFormKey, null, null);
            result.addAll(tmp);
        }
        return result;
    }

    /**
     * 处理表单相关的嵌入模板及马甲源单，马甲源单需要递归调用
     *
     * @param metaFactory
     * @param result
     * @param dataObjectResult 数据源相关的文件，因为需要将数据源相关的文件放在最后，所以另开一个变量
     * @param formKey
     * @throws Throwable
     */
    private static void loadFilePathsByFormKey(IMetaFactory metaFactory, List<String[]> result,
                                               List<String[]> dataObjectResult, String formKey, String container) throws Throwable {
        TreeNode node = getTreeNodeByFormKey4HR(formKey);
        result.add(new String[]{node.key, node.namePath});
        MetaForm metaForm = metaFactory.getMetaForm(formKey);

        for (MetaEmbed metaEmbed : metaForm.getEmbeds()) {
            String embedKey = metaEmbed.getFormKey();
            TreeNode nodeEmbed = mapFormKeyToXmlPath.get(embedKey);
            if (nodeEmbed != null) {
                result.add(new String[]{nodeEmbed.key, nodeEmbed.namePath});
            }
        }

        MetaForm metaForm4HR = getMetaForm4HR(metaFactory, formKey);
        if (metaForm4HR != null) {
            for (MetaEmbed metaEmbed : metaForm4HR.getEmbeds()) {
                String embedKey = metaEmbed.getFormKey();
                TreeNode nodeEmbed = mapFormKeyToXmlPath.get(embedKey);
                result.add(new String[]{nodeEmbed.key, nodeEmbed.namePath});
            }
        }
        String templateKey = metaForm.getTemplateKey();
        if (templateKey != null && templateKey.length() > 0) {
            loadFilePathsByFormKey(metaFactory, result, dataObjectResult, templateKey, container);
        }
        MetaDataSource dataSource = metaForm.getDataSource();
        if (dataSource != null) {
            String dataObjectKey = dataSource.getRefObjectKey();
            if (dataObjectKey != null && dataObjectKey.length() > 0) {
                TreeNode nodeDataObject = mapDataObjectKeyToXmlPath.get(dataObjectKey.toLowerCase());
                dataObjectResult.add(new String[]{nodeDataObject.key, nodeDataObject.namePath});

                MetaDataObject dataObject = metaFactory.getDataObject(dataObjectKey);
                String otherKey = dataObject.getExtend();
                if (StringUtils.isBlank(otherKey)) {
                    otherKey = dataObject.getMergeToSourceMapKey();
                }
                if (StringUtils.isNotBlank(otherKey)) {
                    TreeNode otherNode = mapDataObjectKeyToXmlPath.get(otherKey.toLowerCase());
                    dataObjectResult.add(new String[]{otherNode.key, otherNode.namePath});
                }
            }
        }
        //马甲
        String extend = metaForm.getExtend();
        if (extend != null && !"".equals(extend)) {
            TreeNode nodeEmbed = mapFormKeyToXmlPath.get(extend);
            result.add(new String[]{nodeEmbed.key, nodeEmbed.namePath});
        }
    }


    /**
     * 清除数据
     */
    public static void clear() {
        tree = null;
        mapBpmKeyToXmlPath.clear();
        mapFormKeyToXmlPath.clear();
        mapDomainKeyToXmlPath.clear();
        mapDataElementKeyToXmlPath.clear();
        excelKeyToXmlPath.clear();
        printKeyToXmlPath.clear();
        mapDataKeyToXmlPath.clear();
        mapDataMigrationToXmlPath.clear();
        mapDataObjectKeyToXmlPath.clear();
        designableSolutionKeyMap.clear();
    }

    /**
     * 根据表单Key和字段Key取到文件路径
     *
     * @param formKey
     * @param fieldKey
     * @return
     * @throws
     */
    public static String loadFilePathByFormFieldKey(String formKey, String fieldKey, String parentKey, String entryParas, String type) throws Throwable {
        ensureLoad();
        if (formKey.equals(fieldKey) && com.bokesoft.yes.design.MetaObjectType.form.name.equals(type)) {
            return mapFormKeyToXmlPath.get(formKey).key;
        }
        if (formKey != null && !"".equals(formKey) && Objects.isNull(getTreeNodeByFormKey4HR(formKey))) {
            TreeNode node = getTreeNodeByDataObjectKey4HR(formKey);
            if (node != null) {
                String namePath = node.namePath;
                return namePath;
            }
            return null;
        }
        if (com.bokesoft.yes.design.MetaObjectType.DataObject.name.equals(type) && getTreeNodeByFormKey4HR(formKey) != null) {
            TreeNode node = getTreeNodeByFormKey4HR(formKey);
            if (node != null) {
                String namePath = node.namePath;
                return namePath;
            }
            return null;
        }
        if (Objects.isNull(getTreeNodeByFormKey4HR(formKey))) {
            return null;
        }
        MetaForm containerForm = null;
        String otherKey = null;
        if (entryParas != null) {
            int keylong = entryParas.length();
            if (keylong > 0) {
                if (!entryParas.equals("null")) {
                    otherKey = entryParas;
                    containerForm = StringUtils.isBlank(otherKey) ? null : MetaFactory.getGlobalInstance().getMetaForm(otherKey);
                }
            }
        }
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        MetaForm metaForm = metaFactory.getMetaForm(formKey);
        for (MetaEmbed metaEmbed : metaForm.getEmbeds()) {
            String embedKey = metaEmbed.getFormKey();
            if (IDLookup.getIDLookup(metaFactory.getMetaForm(embedKey)).containFieldKey(fieldKey)) {
                return mapFormKeyToXmlPath.get(embedKey).key;
            } else if (parentKey != null &&
                    IDLookup.getIDLookup(metaFactory.getMetaForm(embedKey)).getPanelKeyByFieldKey(parentKey) != null) {
                return mapFormKeyToXmlPath.get(embedKey).key;
            }
        }
        String templateKey = metaForm.getTemplateKey();
        if (templateKey != null && templateKey.length() > 0) {
            String result = loadFilePathByFormFieldKey(formKey, fieldKey, parentKey, entryParas, null);
            if (result != null) {
                return result;
            }
        }
        IDLookup idLoopup = null;
        IDLookup containerIdLoopup = null;
        if (metaForm != null) {
            idLoopup = IDLookup.getIDLookup(metaForm);
        }
        if (containerForm != null) {
            containerIdLoopup = IDLookup.getIDLookup(containerForm);//用来对比存在container组件的情况
        }
        String refObjectKey = null;
        String dataObjectKey = null;
        if (Objects.isNull(metaForm.getDataSource())) {
            if (containerForm != null) {
                if ((containerForm.getDataSource()) != null) {
                    refObjectKey = containerForm.getDataSource().getRefObjectKey();
                    dataObjectKey = containerForm.getDataSource().getDataObject().getKey(); //修改了数据源   新增数据对象
                }
            }
        } else {
            refObjectKey = metaForm.getDataSource().getRefObjectKey();
            dataObjectKey = metaForm.getDataSource().getDataObject().getKey(); //修改了数据源   新增数据对象
        }
        if (refObjectKey != null && refObjectKey.length() > 0 && refObjectKey.equals(fieldKey)) {  //数据源 来源数据对象
            return mapDataObjectKeyToXmlPath.get(refObjectKey.toLowerCase()).key;
        }
        if ("DataObjectCheckRule".equals(fieldKey)) {
            return getTreeNodeByFormKey4HR(formKey).key;
        }
        MetaMacroCollection macroCollection = metaForm.getMacroCollection();
        MetaGrid metaGridByGridKey = idLoopup.getMetaGridByGridKey(parentKey); //新增表格列
        if (Objects.isNull(metaGridByGridKey)) {
            if (containerIdLoopup != null) {
                metaGridByGridKey = containerIdLoopup.getMetaGridByGridKey(parentKey);
            }
        }
        MetaGrid metaGrid = idLoopup.getMetaGridByGridKey(fieldKey); //修改表格
        if (Objects.isNull(metaGridByGridKey)) {
            if (containerIdLoopup != null) {
                metaGridByGridKey = containerIdLoopup.getMetaGridByGridKey(fieldKey);
            }
        }
        boolean isHave = false;
        if (metaForm.getDataSource() != null) {
            MetaTableCollection tableCollection = metaForm.getDataSource().getDataObject().getTableCollection();
            for (int i = 0; i < tableCollection.size(); i++) {
                isHave = tableCollection.get(i).containsKey(fieldKey);
                if (isHave) {
                    break;
                }
            }
        }
        if (idLoopup.containFieldKey(fieldKey) || (idLoopup.containFieldKey(parentKey)
                && !ConstantUtil.TOOL_BAR.equals(idLoopup.getTagNameByKey(parentKey)))
                || isHave
                || metaGridByGridKey != null || metaGrid != null                           //字典传过来的fieldKey就是formkey
                || (dataObjectKey != null && dataObjectKey.equals(fieldKey))
                || (macroCollection != null && macroCollection.containsKey(fieldKey))
                || metaForm.getKey().equalsIgnoreCase(fieldKey) || "null".equalsIgnoreCase(fieldKey)) {
            return getTreeNodeByFormKey4HR(formKey).key;
        }
        if (containerIdLoopup != null) {
            if (containerIdLoopup.containFieldKey(fieldKey) || (containerIdLoopup.containFieldKey(parentKey)
                    && !ConstantUtil.TOOL_BAR.equals(containerIdLoopup.getTagNameByKey(parentKey)))
                    || metaGridByGridKey != null || metaGrid != null || dataObjectKey.equals(otherKey)) {
                return getTreeNodeByFormKey4HR(otherKey).key;
            }
        }
        MetaOperationCollection metaOperationCollection = metaFactory.getMetaForm(formKey).getOperationCollection();

//		if (metaOperationCollection != null && metaOperationCollection.contains(fieldKey)) {
        if (metaOperationCollection != null) {
            for (KeyPairCompositeObject keyPairCompositeObject : metaOperationCollection) {
                if (fieldKey != null && fieldKey.equals(keyPairCompositeObject.getKey())) {
                    return getTreeNodeByFormKey4HR(formKey).key;
                }
                if (keyPairCompositeObject instanceof MetaOperationCollection) {
                    for (KeyPairCompositeObject pairCompositeObject : ((MetaOperationCollection) keyPairCompositeObject)) {
                        if (fieldKey != null && fieldKey.equals(pairCompositeObject.getKey())) {
                            return getTreeNodeByFormKey4HR(formKey).key;
                        }
                    }
                }
            }
        }
        if (getTreeNodeByFormKey4HR(formKey) != null) {
            return getTreeNodeByFormKey4HR(formKey).key;
        } else {
            return null;
        }

    }

    public static String loadFilePathByDataObjectFieldKey(String refObjectKey) throws Throwable {
        if (mapDataObjectKeyToXmlPath.get(refObjectKey.toLowerCase()) != null) {
            return mapDataObjectKeyToXmlPath.get(refObjectKey.toLowerCase()).key;
        }
        return null;

    }

    public static String loadFilePathByVestFormFieldKey(boolean is, String formKey, String fieldKey, String parentKey,
                                                        String entryParas) throws Throwable {
        ensureLoad();
        if (Objects.isNull(getTreeNodeByFormKey4HR(formKey))) {
            return null;
        }
        MetaForm containerForm = null;
        String otherKey = null;
        if (entryParas != null && entryParas.contains(ConstantUtil.FORM_KEY)) {
            int keylong = entryParas.length();
            if (keylong > 0) {
                if (!entryParas.equals("null")) {
                    otherKey = entryParas;
                    containerForm = StringUtils.isBlank(otherKey) ? null : MetaFactory.getGlobalInstance().getMetaForm(otherKey);
                }
            }
        }
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        MetaForm metaForm = metaFactory.getMetaForm(formKey);
        for (MetaEmbed metaEmbed : metaForm.getEmbeds()) {
            String embedKey = metaEmbed.getFormKey();
            if (IDLookup.getIDLookup(metaFactory.getMetaForm(embedKey)).containFieldKey(fieldKey)) {
                return mapFormKeyToXmlPath.get(embedKey).key;
            } else if (parentKey != null &&
                    IDLookup.getIDLookup(metaFactory.getMetaForm(embedKey)).getPanelKeyByFieldKey(parentKey) != null) {
                return mapFormKeyToXmlPath.get(embedKey).key;
            }
        }
        String templateKey = metaForm.getTemplateKey();
        if (templateKey != null && templateKey.length() > 0) {
            String result = loadFilePathByFormFieldKey(formKey, fieldKey, parentKey, entryParas, null);
            if (result != null) {
                return result;
            }
        }
        IDLookup idLoopup = null;
        IDLookup containerIdLoopup = null;
        if (metaForm != null) {
            idLoopup = IDLookup.getIDLookup(metaForm);
        }
        if (containerForm != null) {
            containerIdLoopup = IDLookup.getIDLookup(containerForm);//用来对比存在container组件的情况
        }
        String refObjectKey = null;
        String dataObjectKey = null;
        if (Objects.isNull(metaForm.getDataSource())) {
            if (containerForm != null) {
                if ((containerForm.getDataSource()) != null) {
                    refObjectKey = containerForm.getDataSource().getRefObjectKey();
                    dataObjectKey = containerForm.getDataSource().getDataObject().getKey(); //修改了数据源   新增数据对象
                }
            }
        } else {
            refObjectKey = metaForm.getDataSource().getRefObjectKey();
            dataObjectKey = metaForm.getDataSource().getDataObject().getKey(); //修改了数据源   新增数据对象
        }
        if (refObjectKey != null && refObjectKey.length() > 0) {  //数据源 来源数据对象
            if (refObjectKey.equals(fieldKey)) {
                return mapDataObjectKeyToXmlPath.get(refObjectKey.toLowerCase()).key;
            }
        }
        if ("DataObjectCheckRule".equals(fieldKey)) {
            return getTreeNodeByFormKey4HR(formKey).key;
        }
        MetaMacroCollection macroCollection = metaForm.getMacroCollection();
        MetaGrid metaGridByGridKey = idLoopup.getMetaGridByGridKey(parentKey); //新增表格列
        if (Objects.isNull(metaGridByGridKey)) {
            if (containerIdLoopup != null) {
                metaGridByGridKey = containerIdLoopup.getMetaGridByGridKey(parentKey);
            }
        }
        MetaGrid metaGrid = idLoopup.getMetaGridByGridKey(fieldKey); //修改表格
        if (Objects.isNull(metaGridByGridKey)) {
            if (containerIdLoopup != null) {
                metaGridByGridKey = containerIdLoopup.getMetaGridByGridKey(fieldKey);
            }
        }
        boolean isHave = false;
        if (metaForm.getDataSource() != null) {
            MetaTableCollection tableCollection = metaForm.getDataSource().getDataObject().getTableCollection();
            for (int i = 0; i < tableCollection.size(); i++) {
                isHave = tableCollection.get(i).containsKey(fieldKey);
                if (isHave) {
                    break;
                }
            }
        }
        if (is || idLoopup.containFieldKey(fieldKey) || (idLoopup.containFieldKey(parentKey)
                && !ConstantUtil.TOOL_BAR.equals(idLoopup.getTagNameByKey(parentKey)))
                || isHave
                || metaGridByGridKey != null || metaGrid != null                           //字典传过来的fieldKey就是formkey
                || dataObjectKey.equals(fieldKey) || macroCollection.containsKey(fieldKey) || metaForm.getKey().equalsIgnoreCase(fieldKey) || "null".equalsIgnoreCase(fieldKey)) {
            return getTreeNodeByFormKey4HR(formKey).key;
        }
        if (containerIdLoopup != null) {
            if (containerIdLoopup.containFieldKey(fieldKey) || (containerIdLoopup.containFieldKey(parentKey)
                    && !ConstantUtil.TOOL_BAR.equals(containerIdLoopup.getTagNameByKey(parentKey)))
                    || metaGridByGridKey != null || metaGrid != null || dataObjectKey.equals(otherKey)) {
                return getTreeNodeByFormKey4HR(otherKey).key;
            }
        }
        MetaOperationCollection metaOperationCollection = metaFactory.getMetaForm(formKey).getOperationCollection();

//		if (metaOperationCollection != null && metaOperationCollection.contains(fieldKey)) {
        if (metaOperationCollection != null) {
            for (KeyPairCompositeObject keyPairCompositeObject : metaOperationCollection) {
                if (fieldKey.equals(keyPairCompositeObject.getKey())) {
                    return getTreeNodeByFormKey4HR(formKey).key;
                }
                if (keyPairCompositeObject instanceof MetaOperationCollection) {
                    for (KeyPairCompositeObject pairCompositeObject : ((MetaOperationCollection) keyPairCompositeObject)) {
                        if (fieldKey.equals(pairCompositeObject.getKey())) {
                            return getTreeNodeByFormKey4HR(formKey).key;
                        }
                    }
                }
            }
        }
        return null;
    }

    /**
     * 根据节点路径取所有的父节点
     *
     * @param context
     * @param path
     * @return
     * @throws Throwable
     */
    public static List<String> loadParentPathsByPath(DefaultContext context, String path) throws Throwable {
        ensureLoad();

        TreeNode node = tree.getNode(path);
        List<String> result = new ArrayList<String>();
        while (node != null && node != tree.root) {
            result.add(node.key);
            node = tree.getNode(node.parentKey);
        }
        Collections.reverse(result);
        return result;
    }

    public static Map<String, String> loadNodeAttrByPath(DefaultContext context, String path) throws Throwable {
        ensureLoad();
        Map<String, String> map = new HashMap<>();
        TreeNode node = tree.getNode(path);
        if (node == null){
            return map;
        }
        map.put(ConstantUtil.OID, String.valueOf(oidSeed++));
        map.put(ConstantUtil.KEY, FilePathHelper.toFrontFilePath(node.key));
        map.put(ConstantUtil.PARENT_KEY, FilePathHelper.toFrontFilePath(node.parentKey));
        map.put(ConstantUtil.DESCRIPTION, node.description);
        map.put(ConstantUtil.TYPE, node.type);
        map.put(ConstantUtil.IS_IN_JAR, Boolean.toString(node.isInJar));
        map.put(ConstantUtil.FOCUS_ROW_CHANGED_FORMULA, FilePathHelper.toFrontFilePath(node.focusRowChangedFormula));
        if (node.type.equalsIgnoreCase(TreeNode.TYPE_File)) {//文件
            XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(node.key, false);
            if (xmlTreeWithPath == null){
                return map;
            }
            TagNode root = xmlTreeWithPath.xmlTree.getRoot();
            String tagName = root.getTagName();
            if (tagName.equals("RightsDefinition")) {
                tagName = "NoRights";
            }
            map.put(ConstantUtil.TYPE, tagName);
        }
        return map;
    }

    /**
     * 根据表单Key取表单配置文件路径
     *
     * @param formKey
     * @return
     * @throws Throwable
     */
    public static String getPathByFormKey(String formKey) throws Throwable {
        ensureLoad();
        if (Objects.isNull(getTreeNodeByFormKey4HR(formKey))) {
            return null;
        }
        TreeNode node = getTreeNodeByFormKey4HR(formKey);
        return node.key;
    }

    /**
     * 根据表单DataObjectKey取对应的数据对象配置文件路径
     *
     * @return
     * @throws Throwable
     */
    public static String getPathByDataObject(String DataObjectKey) throws Throwable {
        ensureLoad();
        if (Objects.isNull(getTreeNodeByDataObjectKey4HR(DataObjectKey))) {
            return null;
        }
        TreeNode node = getTreeNodeByDataObjectKey4HR(DataObjectKey);
        return node.key;
    }

    /**
     * 保证加载文件树
     *
     * @throws Throwable
     */
    public static void ensureLoad() throws Throwable {
        if (Objects.isNull(tree)) {
            mapFormKeyToXmlPath = new HashMap<String, TreeNode>();
            mapDataObjectKeyToXmlPath = new HashMap<String, TreeNode>();
            mapDataElementKeyToXmlPath = new HashMap<String, TreeNode>();
            mapDomainKeyToXmlPath = new HashMap<String, TreeNode>();
            mapDataKeyToXmlPath = new HashMap<String, TreeNode>();
            mapDataMigrationToXmlPath = new HashMap<String, TreeNode>();
            mapBpmKeyToXmlPath = new HashMap<String, TreeNode>();
            excelKeyToXmlPath = new HashMap<String, Map<String, TreeNode>>();
            printKeyToXmlPath = new HashMap<String, Map<String, TreeNode>>();

            log.info("ensureLoad(): 开始加载文件树 - loadFileTree() ...");
            loadFileTree();
            log.info("ensureLoad(): 加载文件树 - loadFileTree() 完成 .");
        }else{
            log.info("ensureLoad(): 文件树已加载, 无实际操作 .");
        }
    }
    /**
     * 保证加载文件树工具用
     *
     * @throws Throwable
     */
    public static void ensureLoad( IMetaFactory metaFactory) throws Throwable {
        if (Objects.isNull(tree)) {
            mapFormKeyToXmlPath = new HashMap<String, TreeNode>();
            mapDataObjectKeyToXmlPath = new HashMap<String, TreeNode>();
            mapDataElementKeyToXmlPath = new HashMap<String, TreeNode>();
            mapDomainKeyToXmlPath = new HashMap<String, TreeNode>();
            mapDataKeyToXmlPath = new HashMap<String, TreeNode>();
            mapDataMigrationToXmlPath = new HashMap<String, TreeNode>();
            mapBpmKeyToXmlPath = new HashMap<String, TreeNode>();
            excelKeyToXmlPath = new HashMap<String, Map<String, TreeNode>>();
            printKeyToXmlPath = new HashMap<String, Map<String, TreeNode>>();

            loadFileTree(metaFactory);
        }
    }

    public static void ensureLoad(String solutionPath) throws Throwable {
        if (Objects.isNull(tree)) {
            mapFormKeyToXmlPath = new HashMap<String, TreeNode>();
            mapDataObjectKeyToXmlPath = new HashMap<String, TreeNode>();
            mapDataElementKeyToXmlPath = new HashMap<String, TreeNode>();
            mapDomainKeyToXmlPath = new HashMap<String, TreeNode>();
            mapDataKeyToXmlPath = new HashMap<String, TreeNode>();
            mapDataMigrationToXmlPath = new HashMap<String, TreeNode>();
            mapBpmKeyToXmlPath = new HashMap<String, TreeNode>();
            excelKeyToXmlPath = new HashMap<String, Map<String, TreeNode>>();
            printKeyToXmlPath = new HashMap<String, Map<String, TreeNode>>();

            loadFileTree(solutionPath);
        }
    }

    static int oidSeed = 0;

    private static void addOneRecord(DataTable dataTable, TreeNode node, TreeNode pNode) throws Throwable {
        int rowIndex = dataTable.append();
        dataTable.setObject(rowIndex, ConstantUtil.OID, oidSeed++);
        StringBuilder sb = new StringBuilder(256);
        sb.append(node.name);
        switch (node.name) {
            case "DataMap":
                sb.append(" ").append("数据映射");
                break;
            case "Custom":
                sb.append(" ").append("数据映射");
                break;
            case "BPM":
                sb.append(" ").append("工作流程");
                break;
            case "BPM.xml":
                sb.append(" ").append("工作流程单据关联设置");
                break;
            case "Entry.xml":
                sb.append(" ").append("菜单");
                break;
            case "Form":
                sb.append(" ").append("表单");
                break;
            case ConstantUtil.DATA_MIGRATION:
                sb.append(" ").append("数据迁移");
                break;
            case ConstantUtil.DATA_OBJECT:
                sb.append(" ").append("数据对象");
                break;
            case "DataElement":
                sb.append(" ").append("数据元素");
                break;
            case "Domain":
                sb.append(" ").append("域");
                break;
            default:
                if (sb.indexOf(".xml") != -1) {
                    int length = sb.length() - 4;
                    sb = new StringBuilder(sb.substring(0, length));
                }
                break;
        }
        if (node.description != null && node.description.length() > 0) {
            sb.append(" ").append(node.description);
        }
        checkChildFile(node);
        if (!node.type.equalsIgnoreCase(TreeNode.TYPE_File)) {
            //这里的统计有问题先注释
//            sb.append(" (").append(node.allChildrenCount).append(")");
        } else { // 这是一个文件
            boolean isFirstLevel = Objects.isNull(pNode) || pNode == tree.root;
            if (!isFirstLevel) {
                sb.append(" (");
            }
            sb.append(File.separator).append(pNode.namePath);
            if (!isFirstLevel) {
                sb.append(")");
            }

        }

        if (node.name.equals("BPM")) {//确保BPM节点在BPM.xml前面，工具不会点错 TODO:保持windows和Linux下的节点顺序一致
            for (int i = 0; i < dataTable.size() - 1; i++) {
                if (dataTable.getString(i, ConstantUtil.NAME).contains("BPM.xml")) {
                    int newRowIndex = 0;
                    if (i != 0) {
                        newRowIndex = i - 1;
                    }
                    dataTable.setObject(rowIndex, ConstantUtil.NAME, dataTable.getObject(newRowIndex, ConstantUtil.NAME));
                    dataTable.setObject(rowIndex, ConstantUtil.DESCRIPTION, dataTable.getObject(newRowIndex, ConstantUtil.DESCRIPTION));
                    dataTable.setObject(rowIndex, ConstantUtil.KEY, dataTable.getObject(newRowIndex, ConstantUtil.KEY));
                    dataTable.setObject(rowIndex, ConstantUtil.PARENT_KEY, dataTable.getObject(newRowIndex, ConstantUtil.PARENT_KEY));
                    dataTable.setString(rowIndex, ConstantUtil.FOCUS_ROW_CHANGED_FORMULA, dataTable.getString(newRowIndex, ConstantUtil.FOCUS_ROW_CHANGED_FORMULA));
                    dataTable.setObject(rowIndex, ConstantUtil.TYPE, dataTable.getObject(newRowIndex, ConstantUtil.TYPE));
                    dataTable.setObject(rowIndex, ConstantUtil.FILE_TYPE, dataTable.getObject(newRowIndex, ConstantUtil.FILE_TYPE));
                    dataTable.setObject(rowIndex, ConstantUtil.PROJECT_KEY, dataTable.getObject(newRowIndex, ConstantUtil.PROJECT_KEY));
                    if (node.type.equalsIgnoreCase(TreeNode.TYPE_Fold)) {
                        dataTable.setObject(rowIndex, "ChildrenCount", 1);
                    } else {
                        dataTable.setObject(rowIndex, "ChildrenCount", dataTable.getObject(newRowIndex, "ChildrenCount"));
                    }
//                    dataTable.setObject(rowIndex, "ChildrenCount", dataTable.getObject(newRowIndex, "ChildrenCount"));
                    rowIndex = newRowIndex;
                }
            }
        }

        dataTable.setObject(rowIndex, ConstantUtil.NAME, FilePathHelper.toFrontFilePath(sb.toString()));
        dataTable.setObject(rowIndex, ConstantUtil.DESCRIPTION, node.description);
        dataTable.setObject(rowIndex, ConstantUtil.KEY, FilePathHelper.toFrontFilePath(node.key));
        dataTable.setObject(rowIndex, ConstantUtil.PARENT_KEY, FilePathHelper.toFrontFilePath(node.parentKey));

        String focusRowChangedFormula = StringUtils.isBlank(node.focusRowChangedFormula) ? node.focusRowChangedFormula
                : FilePathHelper.toFrontFilePath(node.focusRowChangedFormula);
        dataTable.setString(rowIndex, ConstantUtil.FOCUS_ROW_CHANGED_FORMULA, focusRowChangedFormula);

        dataTable.setObject(rowIndex, ConstantUtil.TYPE, node.type);
        if (node.type.equalsIgnoreCase(TreeNode.TYPE_File)) {//文件
            String path = node.key;
            XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(path, false);
            TagNode root = xmlTreeWithPath.xmlTree.getRoot();
            String tagName = root.getTagName();
            if (tagName.equals("RightsDefinition")) {
                tagName = "NoRights";
            }
            dataTable.setObject(rowIndex, ConstantUtil.FILE_TYPE, tagName);
            //做个检查文件名与表单key是否一致,不一致直接报错
            String key = root.getAttributes().get("Key");
            if (key != null && key.length() > 0) {
                if (!key.equals(node.name.split(".xml")[0]) && !tagName.equals("Solution") && !tagName.equals("Entry") && !tagName.equals("Project")) {

                    //throw new Throwable("文件名与表单Key不一致,请检查,具体路径为:" + node.key);
                }

            }
        } else {
            dataTable.setObject(rowIndex, ConstantUtil.FILE_TYPE, "");
        }
        dataTable.setObject(rowIndex, ConstantUtil.PROJECT_KEY, node.projectKey);
        if (node.type.equalsIgnoreCase(TreeNode.TYPE_Fold)) {
            dataTable.setObject(rowIndex, "ChildrenCount", 1);
        } else {
            dataTable.setObject(rowIndex, "ChildrenCount", node.allChildrenCount);
        }
        dataTable.setBoolean(rowIndex, "IsInJar", node.isInJar);
    }

    private static void checkChildFile(TreeNode parentNode) throws Throwable {
        if (parentNode.allChildrenCount > 0) {
            for (int i = 0; i < parentNode.allChildrenCount; i++) {
                TreeNode node = parentNode.children.get(i);
                if (node.type.equalsIgnoreCase(TreeNode.TYPE_File)) {
                    String path = node.key;
                    XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(path, false);
                    if (Objects.isNull(xmlTreeWithPath)) {
                        parentNode.removeChild(node);
                    }
                }
            }
        }
    }

    /**
     * 根据一个 {@link IMetaResolverFactory} 是否 {@link SpringResourceMultiSolutionMetaResolverFactory},
     * 返回其 "rootResourcePath" 或者 null;
     * @param metaResolverFactory
     * @return
     * @throws ReflectiveOperationException
     */
    private static String getRootReourceClasspath(IMetaResolverFactory metaResolverFactory) throws ReflectiveOperationException{
        if (metaResolverFactory instanceof SpringResourceMultiSolutionMetaResolverFactory){
            String rootResourcePath = (String)
                    FieldUtils.readDeclaredField(metaResolverFactory, "rootResourcePath", true);
            return rootResourcePath;
        }else{
            return null;
        }
    }

    /**
     * 输出一个能够明确标识 {@link IMetaResolverFactory} 的字符串, 主要用于日志
     * @param metaResolverFactory
     * @return
     * @throws Exception
     */
    private static String metaResolverFactory2String(IMetaResolverFactory metaResolverFactory) throws Exception{
        if (null==metaResolverFactory){
            return null;
        }
        String clsName = metaResolverFactory.getClass().getSimpleName();
        String descr;
        if (metaResolverFactory instanceof SpringResourceMultiSolutionMetaResolverFactory){
            descr = getRootReourceClasspath(metaResolverFactory);
        }else{
            descr = metaResolverFactory.getSolutionPath();
        }
        return clsName+": "+descr;
    }

    public static void loadFileTree() throws Throwable {
        LoadFileTree.primaryResolverFactory = null;

        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        String workspacePath = FilePathHelper.getWorkspacePath();
        Collection<MetaSolution> metaSolutions = metaFactory.getMetaSolutions();
        //写入jar文件内容
        //生成主的
        IMetaResolverFactory primaryMetaResolverFactory = metaFactory.getMetaResolverFactory();
        log.info("loadFileTree() - 准备通过 '{}' 加载主 Solution ...",
                metaResolverFactory2String(primaryMetaResolverFactory));
        String primaryRootResourcePath = getRootReourceClasspath(primaryMetaResolverFactory);

        MidMetaFactory midMetaFactory = new MidMetaFactory(primaryMetaResolverFactory);
        MetaSolution midMetaFactorySolution = midMetaFactory.getSolution();
        File primarySolutionFile = FileUtils.getFile(metaFactory.getSolutionPath());
        File primarySolutionParentFile = primarySolutionFile.getParentFile();

        String primarySolutionPath = primarySolutionFile.getCanonicalPath();
        if (null!=primaryRootResourcePath){
            log.info("loadFileTree() - 加载主 Solution '{}', 路径为 '{}' .",
                    midMetaFactorySolution.getKey(), primaryRootResourcePath);
        }else{
            log.info("loadFileTree() - 加载主 Solution '{}', 路径为 '{}' .",
                    midMetaFactorySolution.getKey(), primarySolutionPath);
        }

        LoadFileTree.primaryResolverFactory = midMetaFactory;
        metaDesignerFactoryMap.put(primarySolutionPath,midMetaFactory);
        metaDesignerSolutionPathMap.put( metaFactory.getSolution().getKey(), primarySolutionPath);
        designableSolutionKeyMap.put(midMetaFactorySolution.getKey(), StringUtils.substringAfterLast(primarySolutionPath, File.separatorChar));

        for (MetaSolution metaSolution : metaSolutions) {
            String slnKey = metaSolution.getKey();
            IMetaResolverFactory resolverFactory = metaFactory.getMetaResolverFactoryBySolution(slnKey);
            if (Objects.isNull(resolverFactory)) {
                continue;
            }

            String solutionPath = FileUtils.getFile(resolverFactory.getSolutionPath()).getCanonicalPath();
            if (!StringUtils.contains(solutionPath, workspacePath)) {
                //为了加载多solution用的 - Solution 不在 workspacePath 中的情况

                log.info("loadFileTree()|资源处理 - 准备处理不在 Workspace Path '{}' 中的 Solution '{}'(目录为 '{}') ...",
                        workspacePath, slnKey, solutionPath);

                String rootResourcePath = getRootReourceClasspath(resolverFactory);
                if (null!=rootResourcePath){  //说明是从 classpath://、file:// 等资源加载的
                    if (rootResourcePath.startsWith("classpath:/")) {
                        log.info("loadFileTree()|资源处理 - 开始处理 Solution '{}', rootResourcePath='{}' ...",
                                slnKey, rootResourcePath);

                        String resourcePathName = rootResourcePath.substring("classpath:/".length());

                        if (StringUtils.equals(rootResourcePath, primaryRootResourcePath)){
                            //如果是主 Solution, 那么已经加载过了, 应该忽略 getSolution() 过程
                            log.info("loadFileTree()|资源处理 - 忽略 Solution '{}' 加载(主 Solution 已加载) .", slnKey);
                        }else{
                            DefaultMetaFactory metaFactory1 = new ERPWebDesignerMetaFactory(resolverFactory);
                            ((ERPWebDesignerMetaFactory)metaFactory1).setDesignerMetaFactory(midMetaFactory);
                            metaFactory1.getSolution();
                        }

                        IMetaResolver iMetaResolver = resolverFactory.newMetaResolver("");
                        saveUploadResource(resourcePathName);
                        saveUploadResource(resourcePathName, iMetaResolver);

                        log.info("loadFileTree()|资源处理 - 处理 Solution '{}' 完成, rootResourcePath='{}' .",
                                slnKey, rootResourcePath);
                    }else{
                        //FIXME 其他类型资源暂时不处理
                        log.warn("loadFileTree()|资源处理 - 暂不支持 Solution '{}' 的资源类型 '{}', 该 Solution 将被忽略 .",
                                slnKey, rootResourcePath);
                    }
                }else{
                    log.info("loadFileTree()|资源处理 - 忽略不是通过资源加载的 Solution '{}' .", slnKey);
                }
            }else{
                log.info("loadFileTree()|资源处理 - 存放在 Workspace Path '{}' 下的 Solution '{}'(目录为 '{}') 不需要额外处理 .",
                        workspacePath, slnKey, solutionPath);
            }

        }

        tree = new Tree(workspacePath);
        designableSolutionKeyMap.clear();

        if (StringUtils.isNotBlank(metaFactory.getSolutionPath())) {
            String primarySolutionPath1 = metaFactory.getSolutionPath();
            File primarySolutionFile1 = FileUtils.getFile(primarySolutionPath1);
            primarySolutionPath1 = primarySolutionFile1.getCanonicalPath();
            File slnXml = new File(primarySolutionFile1, "Solution.xml");

            //加载主 Solution 到 Tree - 排除主目录是 jar 包, 或者主目录不在源码范围(比如在 target/classes/ 下)等情况
            if (!slnXml.exists()){
                //FIXME MetaResolver 行为未统一 - 通过资源引用 jar 中的 Solution 时, Solution Path 是一个没有意义的临时目录
                log.info("loadFileTree()|TreeNode加载 - 主 Solution 目录 '{}' 中不存在 Solution.xml, 忽略加载 .",
                        primarySolutionFile1);
            } else if (!StringUtils.contains(primarySolutionPath1, workspacePath)){
                //FIXME MetaResolver 行为未统一 - 通过资源引用 Solution 时, file:/ 和 classpath:/ 的 Solution Path 有可能返回文件目录
                log.info("loadFileTree()|TreeNode加载 - 主 Solution 目录 '{}' 不在 Workspace Path '{}' 下 , 忽略加载 .",
                        primarySolutionFile1, workspacePath);
            }else{
                log.info("loadFileTree()|TreeNode加载 - 主 Solution 为有效目录 '{}', 将通过目录加载 ...",
                        primarySolutionFile1);
                String primarySolutionParentPath = primarySolutionParentFile.getCanonicalPath();
                LoadFileTree.getTreeNode(primarySolutionParentPath, primarySolutionPath, true);
            }
        }

        for (MetaSolution metaSolution : metaSolutions) {
            if (designableSolutionKeyMap.containsKey(metaSolution.getKey())) {
                continue;
            }
            IMetaResolverFactory resolverFactory = metaFactory.getMetaResolverFactoryBySolution(metaSolution.getKey());
            if (Objects.isNull(resolverFactory)) {
                continue;
            }
            String solutionPath = FileUtils.getFile(resolverFactory.getSolutionPath()).getCanonicalPath();
            if (!StringUtils.contains(solutionPath, workspacePath)) {///&& !metaSolution.getKey().equals("webdesignersolution")
                continue;
            }
            log.info("loadFileTree()|TreeNode加载 - 加载 Workspace Path '{}' 下的 Solution 目录 '{}' ...",
                    workspacePath, solutionPath);
            LoadFileTree.getTreeNode(workspacePath, solutionPath, true);

        }
        Set<String> loadedSolutionKeys = metaSolutions.stream().filter(Objects::nonNull).map(MetaSolution::getKey).collect(Collectors.toSet());
        String[] solutionDirs = FileUtils.getFile(workspacePath).list((dirFile, fileName) -> !designableSolutionKeyMap.containsValue(fileName));
        for (String solutionDir : solutionDirs) {
            String solutionPath = Paths.get(workspacePath, solutionDir).toString();
            if (!Files.exists(Paths.get(solutionPath, DomMetaConstants.SOLUTION_FILE))){
                continue;
            }
            IMetaResolverFactory metaResolverFactory = new DefaultMetaResolverFactory(solutionPath);
            DefaultMetaFactory factory = metaDesignerFactoryMap.get(solutionPath);
            if (factory == null) {
                factory = new MidMetaFactory(metaResolverFactory);
            }
            MetaSolution solution = factory.getSolution();
            String key = solution.getKey();
            if (loadedSolutionKeys.contains(key)) {
                doGetTreeNode(workspacePath, solutionPath, true, factory, false);
                log.info("loadFileTree()|TreeNode加载 - 加载 Workspace Path '{}' 下 Key='{}' 的关联 Solution 目录 '{}' ...",
                        workspacePath, key, solutionPath);

            }
        }
        //处理导入的solution
        String filePath = WebDesignerConfiguration.getDesignerImportSolutionsPath();
        log.info("loadFileTree()|TreeNode加载 - 开始加载 ImportSolution,  DesignerImportSolutionsPath = '{}' ...", filePath);
        TreeNode solutionNode = new TreeNode("ImportSolution", "importsolution", "导入的solution", workspacePath + "Import", workspacePath, "","");
        tree.root.children.add(solutionNode);
        tree.addTreeNode(solutionNode, true);
        File file = new File(filePath);
        if (!file.exists()) {
            try {
                FileUtils.writeStringToFile(file, "<ImportSolutions/>\n", "UTF-8");
            } catch (IOException e) {
                e.printStackTrace();
            }
        } else {//读取内容
            SAXReader reader = new SAXReader();
            org.dom4j.Document doc = reader.read(new File(filePath));
            Element root = doc.getRootElement();
            List<Element> importSolution = root.elements("ImportSolution");
            for (Element element : importSolution) {
                String solutionPath = element.attributeValue("SolutionPath");
                log.info("loadFileTree()|TreeNode加载 - 加载 ImportSolution '{}' ...", solutionPath);
                IMetaResolverFactory metaResolverFactory = new DefaultMetaResolverFactory(solutionPath);
                DefaultMetaFactory factory = new MidMetaFactory(metaResolverFactory);
                loadImportSolution(metaFactory, workspacePath, solutionPath, metaResolverFactory, factory);
            }
        }
        ErpConfig.initExtendConfig();
        String designerSolutionDataPath = WebDesignerConfiguration.getDesignerSolutionDataPath();

        //String[] list = FileUtils.getFile(designerSolutionDataPath).list();
        File fDesignerSolutionDataPath = FileUtils.getFile(designerSolutionDataPath).getCanonicalFile();
        Collection<File> slnXmls = FileUtils.listFiles(
                fDesignerSolutionDataPath,
                new NameFileFilter("Solution.xml"),
                TrueFileFilter.INSTANCE
        );
        String[] list = slnXmls.stream()
                .map( slnXml -> fDesignerSolutionDataPath.toPath().relativize(slnXml.getParentFile().toPath()) )
                .map( slnRelativePath -> slnRelativePath.toString() )
                .distinct() // 确保目录不重复
                .toArray(String[]::new);

        log.info("loadFileTree()|TreeNode加载 - 开始加载 Jar 包中的 Solution, 共包括 {} 个: '{}' ...", list.length, list);

        TreeNode solution1 = new TreeNode("JarSolution", "jarsolution", "Jar包中的solution", designerSolutionDataPath, workspacePath, "","");
        solution1.isInJar = true;
        if (list.length > 0) {
            tree.root.children.add(solution1);
            tree.addTreeNode(solution1, true);
        }
        for (String path : list) {
            String dir = designerSolutionDataPath + File.separator + path;
            log.info("loadFileTree()|TreeNode加载 - 加载 Jar 包中的 Solution '{}' ...", dir);
            IMetaResolverFactory metaResolverFactory = new DefaultMetaResolverFactory(dir);
            //为了加载多solution用的,
            DefaultMetaFactory factory = metaDesignerFactoryMap.get(dir);
            if (factory == null) {
                factory = new MidMetaFactory(metaResolverFactory);
            }
            doGetTreeNode(solution1.key, dir, true, factory, true);
        }
    }
    public static void loadFileTree( IMetaFactory metaFactory) throws Throwable {
        Collection<MetaSolution> metaSolutions = metaFactory.getMetaSolutions();
        File primarySolutionFile = FileUtils.getFile(metaFactory.getSolutionPath());
        File primarySolutionParentFile = primarySolutionFile.getParentFile();
        String primarySolutionParentPath = primarySolutionParentFile.getCanonicalPath();
        tree = new Tree(primarySolutionParentPath);

        designableSolutionKeyMap.clear();
        if (StringUtils.isNotBlank(metaFactory.getSolutionPath())) {

            String primarySolutionPath = primarySolutionFile.getCanonicalPath();
            DefaultMetaFactory factory = metaDesignerFactoryMap.get(primarySolutionPath);
            if (factory == null) {
                IMetaResolverFactory metaResolverFactory = new DefaultMetaResolverFactory(primarySolutionPath);
                factory = new MidMetaFactory(metaResolverFactory);
            }
            LoadFileTree.primaryResolverFactory = factory;
            LoadFileTree.getTreeNode(primarySolutionParentPath, primarySolutionPath, true,factory);
        }
        for (MetaSolution metaSolution : metaSolutions) {
            if (designableSolutionKeyMap.containsKey(metaSolution.getKey())) {
                continue;
            }
            IMetaResolverFactory resolverFactory = metaFactory.getMetaResolverFactoryBySolution(metaSolution.getKey());
            if (Objects.isNull(resolverFactory)) {
                continue;
            }
            String solutionPath = FileUtils.getFile(resolverFactory.getSolutionPath()).getCanonicalPath();
            if (!StringUtils.contains(solutionPath, primarySolutionParentPath)) {///&& !metaSolution.getKey().equals("webdesignersolution")
                continue;
            }
            LoadFileTree.getTreeNode(primarySolutionParentPath, solutionPath, true);
        }
    }

    public static void loadImportSolution(IMetaFactory metaFactory, String workspacePath, String solutionPath,
                                          IMetaResolverFactory metaResolverFactory, DefaultMetaFactory factory) throws Throwable {
        String key = workspacePath + "Import";
        TreeNode solutionNode = tree.getNode(key);
        doGetTreeNode(solutionNode.key, solutionPath, true, factory, false);
        if (!LoadFileTree.loadImportSolutions.contains(solutionPath)) {
            metaFactory.load(metaResolverFactory, true, false, false);
            LoadFileTree.loadImportSolutions.add(solutionPath);
        }
    }

    private static void saveUploadResource(String parent, IMetaResolver iMetaResolver) throws Exception {
        ResourceMultiSolutionResolver resourceMultiSolutionResolver = (ResourceMultiSolutionResolver) iMetaResolver;
        Field resources1 = resourceMultiSolutionResolver.getClass().getDeclaredField("resources");
        resources1.setAccessible(true);
        ResourcePaths resourcePaths = (ResourcePaths) resources1.get(iMetaResolver);
        Field pathField = resourcePaths.getClass().getDeclaredField("paths");
        pathField.setAccessible(true);
        List<String> paths = (List<String>) pathField.get(resourcePaths);
        for (int i = 0; i < paths.size(); i++) {
            saveUploadResource(parent + paths.get(i));
        }
    }

    public static void saveUploadResource(String fileName) throws IOException {
        //返回读取指定资源的输入流
        InputStream is = MidMetaFactoryManager.class.getResourceAsStream("/" + fileName);
        if (is == null) {
            return;
        }
        //若文件已存在，则返回的filePath中含有"EXIST"，则不需再重写文件
        String filePath = createFile(fileName);

        //文件不存在，则创建流输入默认数据到新文件
        if (fileName.endsWith(".xml")) {
            if (!filePath.contains("EXIST")) {
                File file = new File(filePath);
                inputStreamToFile(is, file);
            }
        }
    }

    public static String createFile(String filename) {
        String dirPath = WebDesignerConfiguration.getDesignerSolutionDataPath();
        File dir = new File(dirPath);
        dir.mkdirs();
        String filePath = dirPath + File.separator + filename;
        File file = new File(filePath);
        if (!file.exists()) {
            try {
                if (filename.endsWith(".xml")) {
                    FileUtils.writeStringToFile(file, "", "UTF-8");
                } else {
                    file.mkdirs();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
            return filePath;
        }
        return "EXIST" + filePath;
    }

    public static void loadFileTree(String solutionPath) throws Throwable {
        String parent = new File(solutionPath).getParent();
        tree = new Tree(parent);
        designableSolutionKeyMap.clear();
        getTreeNode(parent, solutionPath, true);
    }

    private static String safeGetSolutionKey(DefaultMetaFactory metaFactory) throws Exception{
        /* LoadFileTree 过程中使用的只包含一个 Solution 的 MetaFactory 往往不能独立完成 getSolution() 调用(通常
           也不需要完整执行 getSolution() 所需要的 loadSolution 过程), 因此需要一个不依赖 loadSolution 的获取
           Solution Key 的方法
         */
        IMetaResolverFactory resolverFactory = metaFactory.getMetaResolverFactory();
        IMetaResolver resolver = resolverFactory.newMetaResolver("");
        JSONObject slnXmlData = resolver.readProfile(DomMetaConstants.SOLUTION_FILE, 0);
        return slnXmlData.getString(MetaConstants.COMMON_KEY);
    }

    private static String getTreeNode(String parent, String dir, boolean create) throws Throwable {
        DefaultMetaFactory factory = metaDesignerFactoryMap.get(dir);
        if (factory == null) {
            IMetaResolverFactory metaResolverFactory = new DefaultMetaResolverFactory(dir);
            factory = new MidMetaFactory(metaResolverFactory);
        }
        return doGetTreeNode(parent, dir, create, factory, false);
    }
    private static String getTreeNode(String parent, String dir, boolean create,DefaultMetaFactory factory) throws Throwable {
        return doGetTreeNode(parent, dir, create, factory, false);
    }
    private static String doGetTreeNode(String parent, String dir,
                                        boolean create, DefaultMetaFactory targetSolutionMetaFactory, boolean isJarSolution) throws Throwable {
        if (LoadFileTree.primaryResolverFactory == null){
            throw new IllegalStateException(LoadFileTree.class.getName()+": Global primaryResolverFactory uninitialized");
        }

        DefaultMetaFactory metaFactory;
        String targetSlnKey = safeGetSolutionKey(targetSolutionMetaFactory);
        String primarySlnKey = safeGetSolutionKey(LoadFileTree.primaryResolverFactory);
        String primarySlnPath = LoadFileTree.primaryResolverFactory.getSolutionPath();
        if (LoadFileTree.primaryResolverFactory != targetSolutionMetaFactory){
            if (isJarSolution
                    && StringUtils.equals(targetSlnKey, primarySlnKey) ){
                /* 在确定 LoadFileTree.primaryResolverFactory 阶段还没有进行 jar 中 Solution 的展开部署(将 jar 内容
                   展开到 Solution Data 目录), 所以当主 Solution 在 jar 中时, 其 getTreeNode 过程将在处理 jar 中 Solution
                   阶段才进行, 且无法通过 metaDesignerFactoryMap.get(dir) 获得 loadFileTree() 开始阶段已经明确的
                   "LoadFileTree.primaryResolverFactory", 此时需要通过 Solution Key 进行判断.
                */
                log.info("doGetTreeNode()|处理 jar 包中的 [主 Solution] - key='{}', dir='{}' (JAR={}) (path='{}') ...",
                        targetSlnKey, dir, isJarSolution, primarySlnPath);
                metaFactory = targetSolutionMetaFactory;
            }else{
                log.info("doGetTreeNode()|处理 Solution - key='{}', dir='{}' (JAR={}) ...",
                        targetSlnKey, dir, isJarSolution);
                metaFactory = new ERPWebDesignerMetaFactory(targetSolutionMetaFactory.getMetaResolverFactory());
                ((ERPWebDesignerMetaFactory)metaFactory).setDesignerMetaFactory(LoadFileTree.primaryResolverFactory);
            }
        }else{
            log.info("doGetTreeNode()|处理 [主 Solution] - key='{}', dir='{}' (JAR={}) ...",
                    targetSlnKey, dir, isJarSolution);
            metaFactory = targetSolutionMetaFactory;
        }
        //为了加载多solution用的,
        metaFactory.getSolution();
        MetaFormList metaFormList = metaFactory.getMetaFormList();
        MetaDataObjectList dataObjectList = metaFactory.getDataObjectList();
        MetaDataMigrationList dataMigrationList = metaFactory.getDataMigrationList();
        MetaSolution solution = metaFactory.getSolution();
        MetaProjectCollection projectCollection = solution.getProjectCollection();
			/*int i = dir.lastIndexOf((File.separator));
			String substring = dir.substring(i);*/
        dir = FilePathHelper.toBackFilePath(dir);
        File solutionFile = new File(dir);
        TreeNode solution1 = new TreeNode(solution.getKey(), TreeNode.TYPE_SOLUTION, solution.getCaption(), solutionFile.getAbsolutePath(), parent, "",solution.getKey());
        solution1.isInJar = isJarSolution;
        //solution1.namePath = solution1.name;
        for (MetaProjectProfile metaProjectProfile : projectCollection) {
            String projectKey = metaProjectProfile.getKey();
            if (isJarSolution) {
                jarProjectKey.add(projectKey);
            }
            MetaProject project = metaFactory.getMetaProject(projectKey);
            String projectKey1 = project.getKey();
            File projectFile = new File(solutionFile, project.getKey());
            TreeNode node = new TreeNode(projectKey, TreeNode.TYPE_Project, project.getCaption(),
                    projectFile.getAbsolutePath(), dir, projectKey1,solution.getKey());
            node.namePath = node.name;
            solution1.addChild(node);
            loadProjectFileTree(node, projectFile, metaFormList, dataObjectList, metaFactory,
                    dataMigrationList, projectKey1);
            //break; // 先减少文件数，提升应用的性能
        }
        //addOneRecord(dataTable, "源码", "", path, "");
        String finalDir = dir;
        solutionFile.listFiles((file) -> {
            String pathName = file.getAbsolutePath();
            String name = FilenameUtils.getName(pathName);
            String extension = FilenameUtils.getExtension(pathName);
            if (extension.equalsIgnoreCase("xml")) {
                TreeNode node = new TreeNode(name, TreeNode.TYPE_File, "", pathName, finalDir, "",solution1.solutionKey);
                solution1.addChild(node);
            }else {
                if (file.isDirectory() && (name.equalsIgnoreCase("DataElement")|| name.equalsIgnoreCase("Domain"))) {
                    TreeNode node = new TreeNode(name, TreeNode.TYPE_Fold, name, pathName, finalDir, "",solution1.solutionKey);
                    node.namePath = node.name;
                    solution1.addChild(node);
                    loadDomainElementFileTree(node, file, "");
                }
            }
            return false;
        });

        metaDesignerFactoryMap.put(dir, metaFactory);
        metaDesignerSolutionPathMap.put( metaFactory.getSolution().getKey(), dir);
        if (CollectionUtils.isNotEmpty(tree.root.children)) {
            List<TreeNode> oldNodeList = tree.root.children.stream().filter(item -> Objects.equals(item.key, solution1.key)).collect(Collectors.toList());
            tree.root.children.removeAll(oldNodeList);
            if (!create) {
                tree.root.children.add(solution1);
            }
        }
        tree.addTreeNode(solution1, create);
        designableSolutionKeyMap.put(solution.getKey(), StringUtils.substringAfterLast(dir, File.separatorChar));
        return solution.getKey();
    }

    public static void inputStreamToFile(InputStream ins, File file) {
        OutputStream os = null;

        try {
            os = new FileOutputStream(file);

            int bytesRead = 0;

            byte[] buffer = new byte[1024];

            while ((bytesRead = ins.read(buffer, 0, 1024)) != -1) {
                os.write(buffer, 0, bytesRead);

            }

            os.close();

            ins.close();

        } catch (FileNotFoundException e) {
            e.printStackTrace();

        } catch (IOException e) {
            e.printStackTrace();

        }

    }


    private static void loadDomainElementFileTree(TreeNode PNode, File parentFile, String projectKey) {
        String parentPath = parentFile.getAbsolutePath();
        String type = parentFile.getName();
        parentFile.listFiles((file) -> {
            String pathName = file.getAbsolutePath();
            String name = FilenameUtils.getName(pathName);
            if (file.isDirectory()) {
                TreeNode node = new TreeNode(name, TreeNode.TYPE_Fold, "", pathName, parentPath, projectKey,PNode.solutionKey);
                PNode.addChild(node);
                loadDomainElementFileTree(node, file, projectKey);
            } else {
                String baseName = FilenameUtils.getBaseName(pathName);
                String extension = FilenameUtils.getExtension(pathName);
                if (extension.equalsIgnoreCase("xml")) {
                    String caption = "";
                    TreeNode node = new TreeNode(name, TreeNode.TYPE_File, caption, pathName, parentPath, projectKey,PNode.solutionKey);
                    if (type.equalsIgnoreCase("DataElement")) {//DataElement
                        caption = baseName;
                        node = new TreeNode(name, TreeNode.TYPE_File, caption, pathName, parentPath, projectKey,PNode.solutionKey);
                        mapDataElementKeyToXmlPath.put(baseName.toLowerCase(), node);
                    } else if (type.equalsIgnoreCase("Domain")) {//Domain
                        caption = baseName;
                        node = new TreeNode(name, TreeNode.TYPE_File, caption, pathName, parentPath, projectKey,PNode.solutionKey);
                        mapDomainKeyToXmlPath.put(baseName.toLowerCase(), node);
                    } else {
                        // 不处理
                    }
                    PNode.addChild(node);
                }
            }
            return false;
        });
    }

    private static void loadProjectFileTree(TreeNode solution1, File parentFile, MetaFormList metaFormList,
                                            MetaDataObjectList dataObjectList, IMetaFactory metaFactory,
                                            MetaDataMigrationList dataMigrationList, String projectKey) {
        String parentPath = parentFile.getAbsolutePath();
        AtomicReference<String> parentBaseName = new AtomicReference<>(FilenameUtils.getBaseName(parentPath));
        parentFile.listFiles((file) -> {
            String pathName = file.getAbsolutePath();
            String name = FilenameUtils.getName(pathName);
            if (file.isDirectory()) {
                TreeNode node = new TreeNode(name, TreeNode.TYPE_Fold, "", pathName, parentPath, projectKey,solution1.solutionKey);
                solution1.addChild(node);
                loadProjectFileTree(node, file, metaFormList, dataObjectList, metaFactory, dataMigrationList,
                        projectKey);
            } else {
                String baseName = FilenameUtils.getBaseName(pathName);
                String extension = FilenameUtils.getExtension(pathName);
                if (extension.equalsIgnoreCase("xml")) {
                    String secondLine = null;
                    try {
                        String xml = FileUtil.File2String(file, "UTF-8");
                        secondLine = DesignIOMetaUtil.getSecondLine(xml);
                        String subString = DesignIOMetaUtil.getSubString(secondLine, "<([A-Za-z_]\\w*)\\s");
                        parentBaseName.set(subString);
                    } catch (Throwable e) {

                    }
                    String caption = "";
                    TreeNode node = new TreeNode(name, TreeNode.TYPE_File, caption, pathName, parentPath, projectKey,
                            solution1.solutionKey);

                    if (parentBaseName.get().equalsIgnoreCase(ConstantUtil.DATA_OBJECT)) {//数据对象
                        caption = Objects.isNull(dataObjectList.get(baseName)) ? "" : dataObjectList.get(baseName).getCaption();
                        node = new TreeNode(name, TreeNode.TYPE_File, caption, pathName, parentPath, projectKey,solution1.solutionKey);
                        mapDataObjectKeyToXmlPath.put(baseName.toLowerCase(), node);
                    } else if (parentBaseName.get().equalsIgnoreCase("Map")) {//数据映射
                        caption = Objects.isNull(metaFactory.getMetaCustomObject(ERPMetaMap.class, baseName)) ? "" : metaFactory.getMetaCustomObject(ERPMetaMap.class, baseName).getCaption();
                        node = new TreeNode(name, TreeNode.TYPE_File, caption, pathName, parentPath, projectKey,solution1.solutionKey);
                        mapDataKeyToXmlPath.put(baseName, node);
                    } else if (parentBaseName.get().equalsIgnoreCase(ConstantUtil.DATA_MIGRATION)) {//数据迁移
                        caption = Objects.isNull(dataMigrationList.get(baseName)) ? "" : dataMigrationList.get(baseName).getCaption();
                        node = new TreeNode(name, TreeNode.TYPE_File, caption, pathName, parentPath, projectKey,solution1.solutionKey);
                        mapDataMigrationToXmlPath.put(baseName, node);
                    } else if (parentBaseName.get().equalsIgnoreCase("Process")) {//工作流

                        node = new TreeNode(name, TreeNode.TYPE_File, caption, pathName, parentPath, projectKey,solution1.solutionKey);
                        mapBpmKeyToXmlPath.put(baseName, node);
                    } else if (parentBaseName.get().equalsIgnoreCase("Workbook")) {//Excel
                        try {
                            caption = Objects.isNull(metaFactory.getExcelTemplate(projectKey, baseName)) ? "" :
                                    metaFactory.getExcelTemplate(projectKey, baseName).getCaption();
                        } catch (Throwable e) {
                        }
                        node = new TreeNode(name, TreeNode.TYPE_File, caption, pathName, parentPath, projectKey,solution1.solutionKey);

                        if (!excelKeyToXmlPath.containsKey(projectKey)) {
                            Map<String, TreeNode> stringTreeNodeMap = new HashMap<>();
                            excelKeyToXmlPath.put(projectKey, stringTreeNodeMap);
                        }
                        excelKeyToXmlPath.get(projectKey).put(baseName, node);

                    } else if (parentBaseName.get().equalsIgnoreCase("Report")) {//print
                        if (secondLine != null) {
                            String formKey = DesignIOMetaUtil.getSubString(secondLine, "FormKey=\"([A-Za-z_]\\w*)\"");
                            try {
                                MetaReportSubList reportSubList = metaFactory.getReportSubList(formKey);
                                MetaReportProfile metaReportProfile = reportSubList.get(baseName);
                                caption = metaReportProfile.getCaption();
                            } catch (Throwable e) {

                            }
                            node = new TreeNode(name, TreeNode.TYPE_File, caption, pathName, parentPath, projectKey,solution1.solutionKey);
                            if (!printKeyToXmlPath.containsKey(formKey)) {
                                HashMap<String, TreeNode> objectObjectHashMap = new HashMap<>();
                                printKeyToXmlPath.put(formKey, objectObjectHashMap);
                            }
                            printKeyToXmlPath.get(formKey).put(baseName, node);
                        }
                    } else if (parentBaseName.get().equalsIgnoreCase("Form")) {//form
                        caption = Objects.isNull(metaFormList.get(baseName)) ? "" :
                                StringUtils.isEmpty(metaFormList.get(baseName).getCaption()) ? "表单" :
                                        metaFormList.get(baseName).getCaption();
                        node = new TreeNode(name, TreeNode.TYPE_File, caption, pathName, parentPath, projectKey,solution1.solutionKey);
                        mapFormKeyToXmlPath.put(baseName, node);
                    } else {
                        // 不处理
                    }
                    solution1.addChild(node);
                }
            }
            return false;
        });
    }

    /**
     * 根据关键字搜索节点
     *
     * @param context
     * @param search  关键字，可使用空格分隔
     * @return
     * @throws Throwable
     */
    public static List<String[]> searchNodes(DefaultContext context, String search, int maxCount) throws Throwable {
        ensureLoad();
        List<String[]> result = new ArrayList<String[]>();
        String[] searchStrs = search.split("[ 　]+"); // 这个分隔能处理半角和全角空格
        if (searchStrs.length > 0) {
            searchNodes(tree.root, searchStrs, result, maxCount);
        }
        return result;
    }

    public static void main(String[] args) {
        String a = "  我是一个半角空格 我是一个全角空格　我是多个空格    看看能否分隔开来";
        String[] searchStrs = a.split("[ 　]+");
        //System.out.println(searchStrs);
        String b = "    "; //全是空格
        String[] bs = b.split("[ 　]+");
        //System.out.println(bs);
    }

    private static void searchNodes(TreeNode node, String[] searchStrs, List<String[]> result, int maxCount) {
        if (result.size() >= maxCount) {
            return;
        }
        StringBuilder sbFound = new StringBuilder(256).append(node.name).append(" ").append(node.description);
        if (node.type == TreeNode.TYPE_File) {
            sbFound.append(" ").append(node.key);
        }
        boolean exist = existStrs(sbFound.toString(), searchStrs);
        if (exist) {
            StringBuilder sb = new StringBuilder(256);

            if (node.description != null && node.description.length() > 0) {
                sb.append(node.description).append(" ");
            }
            sb.append(node.name);
            if (node.type == TreeNode.TYPE_File) {
                String[] split = StringUtils.split(node.key, File.separatorChar);
                for (int i = split.length - 2; i > 0; i--) {
                    sb.append(File.separatorChar).append((split[i]));
                }
            }
            String[] found = new String[]{sb.toString(), node.key, node.description};
            result.add(found);
        }
        if (node.children != null) {
            for (TreeNode childNode : node.children) {
                searchNodes(childNode, searchStrs, result, maxCount);
            }
        }
    }

    private static boolean existStrs(String s, String[] searchStrs) {
        if (StringUtils.isBlank(s)) {
            return false;
        }
        boolean result = true;
        for (String searchStr : searchStrs) {
            if (!StringUtils.containsIgnoreCase(s, searchStr)) {
                result = false;
                break;
            }
        }
        return result;
    }

    public static TreeNode getProjectNode(String projectKey) throws Throwable {
        ensureLoad();
        for (Map.Entry<String, TreeNode> stringTreeNodeEntry : Tree.map.entrySet()) {
            TreeNode node = stringTreeNodeEntry.getValue();
            if (node.type == TreeNode.TYPE_Project && node.name.equals(projectKey)) {
                return node;
            }
        }
        return null;
    }

    public  static String getProjectKey(String filePath) throws Throwable {
        ensureLoad();
        return Tree.map.get(filePath).projectKey;
    }
    public  static TreeNode getTreeNode(String filePath) throws Throwable {
        ensureLoad();
        TreeNode treeNode = Tree.map.get(filePath);
        return treeNode;
    }


    public static TreeNode deleteProjectNode(String projectKey) throws Throwable {
        ensureLoad();
        for (Map.Entry<String, TreeNode> stringTreeNodeEntry : Tree.map.entrySet()) {
            TreeNode node = stringTreeNodeEntry.getValue();
            if (node.type == TreeNode.TYPE_Project && node.name.equals(projectKey)) {
                Tree.map.get(node.parentKey).removeChild(node);
                return node;
            }
        }
        return null;
    }

    public static void deleteProjectNodeByProjectKey(String projectKey) throws Throwable {
        TreeNode treeNode = LoadFileTree.deleteProjectNode(projectKey);
        if (Objects.nonNull(treeNode)) {
            removeChild(treeNode);
            Tree.map.remove(treeNode.key);
        }
    }

    private static void removeChild(TreeNode treeNode) {
        if (Objects.nonNull(treeNode) && treeNode.children != null && treeNode.children.size() > 0) {
            for (TreeNode child : treeNode.children) {
                removeChild(child);
                Tree.map.remove(child.key);
            }
        }

    }

    /**
     * 取项目的路径
     *
     * @param projectKey
     * @return
     * @throws Throwable
     */
    public static String getProjectFilePath(String projectKey) throws Throwable {
        TreeNode node = getProjectNode(projectKey);
        return Objects.isNull(node) ? null : node.key;
    }
    public static TreeNode getChildFoldNode(TreeNode parentNode, String foldName,
                                            String projectKey,String solutionKey) {
        if (parentNode == null) {
            return new TreeNode(foldName, TreeNode.TYPE_Fold, "", projectKey, projectKey, projectKey,solutionKey);
        }
        if (parentNode.children != null) {
            for (TreeNode node : parentNode.children) {
                if (node.type == TreeNode.TYPE_Fold && node.name.equals(foldName)) {
                    return node;
                }
            }
        }
        String pathName = Paths.get(parentNode.key, foldName).toString();
        TreeNode node = new TreeNode(foldName, TreeNode.TYPE_Fold, "", pathName, parentNode.key, projectKey,solutionKey);
        tree.getNode(node.parentKey).addChild(node);
        return node;
    }

    /**
     * 新增文件，返回新增节点的Key
     *
     * @param projectKey
     * @param formType
     * @param fileName
     * @param key
     * @param caption
     * @return
     * @throws Throwable
     */
    public static String newFile(String projectKey, int formType, String fileName, String key,
                                 String caption,
                                 String directory, String isdirectory) throws Throwable {
        TreeNode projectNode = getProjectNode(projectKey);
        TreeNode formFold = getChildFoldNode(projectNode, "Form", projectKey,projectNode.solutionKey);
        String sFormType = FormType.toString(formType);
        String formTypeFoldName = (sFormType.equals(FormType.STR_Entity)) ? "Bill" : sFormType;
        TreeNode node;
        String pathName;
        TreeNode formTypeFold = null;
        if ("1".equals(isdirectory)) {//指定目录
            if (directory.isEmpty()) {
                directory = "Bill";
                formTypeFold = getChildFoldNode(formFold, directory, projectKey,projectNode.solutionKey);
            } else {
                if (directory.contains("/")&&!directory.contains("//")&&!directory.contains("\\")){
                    String[] split = directory.split("/");
                    for (int i = 0; i < split.length; i++) {
                        formFold = getChildFoldNode(formFold, split[i], projectKey,projectNode.solutionKey);
                    }
                    formTypeFold = formFold;
                } else {
                    formTypeFold = getChildFoldNode(formFold, directory, projectKey,projectNode.solutionKey);
                }
            }

        } else {
            formTypeFold = getChildFoldNode(formFold, formTypeFoldName, projectKey,projectNode.solutionKey);
        }

        pathName = Paths.get(formTypeFold.key, fileName).toString();
        node = new TreeNode(key + ".xml", TreeNode.TYPE_File, caption, pathName, formTypeFold.key, projectKey,
                projectNode.solutionKey);

        mapFormKeyToXmlPath.put(key, node);
        tree.getNode(node.parentKey).addChild(node);
        return pathName;
    }

    public static String getSolutionPath(String solutionKey){
        return metaDesignerSolutionPathMap.get(solutionKey);
    }
    public static String newProjectFile(String key, String caption, String SolutionKey) throws Throwable {
        String pathName = null;
        SolutionKey = FilePathHelper.toBackFilePath(SolutionKey);
        DefaultMetaFactory defaultMetaFactory = metaDesignerFactoryMap.get(SolutionKey);
        MetaSolution solution = defaultMetaFactory.getSolution();
        if (Objects.isNull(getProjectNode(key)) || Objects.isNull(solution.getProject(key))) {
            pathName = SolutionKey + File.separator + key;
            CreateEmptyProjectAction createEmptyProjectAction = new CreateEmptyProjectAction(SolutionKey, key, caption);
            createEmptyProjectAction.doAction();
            MetaProjectProfile metaProjectProfile = new MetaProjectProfile();
            metaProjectProfile.setCaption(caption);
            metaProjectProfile.setKey(key);
            MetaProjectLoad metaProjectLoad = new MetaProjectLoad(AppRunType.App);
            IMetaResolverFactory metaResolverFactory = new DefaultMetaResolverFactory(SolutionKey);
            IMetaResolver projectMetaResolver = metaResolverFactory.newMetaResolver(metaResolverFactory.getSeparator() + metaProjectProfile.getKey());
            metaProjectLoad.load(projectMetaResolver, DomMetaConstants.PROJECT_FILE);
            MetaProject metaProject2 = (MetaProject) metaProjectLoad.getRootMetaObject();
            metaProjectProfile.setProject(metaProject2);
            metaProject2.setSolution(solution);
            MetaStringTable strings = new MetaStringTable();
            metaProject2.setStrings(strings);

            //commondef
            MetaCommonDefLoad commonDefLoad = new MetaCommonDefLoad(AppRunType.App);
            commonDefLoad.load(projectMetaResolver, DomMetaConstants.COMMON_DEF_FILE);
            MetaCommonDef commonDef = (MetaCommonDef) commonDefLoad.getRootMetaObject();
            if (commonDef != null) {
                commonDef.doPostProcess(0, null);
            }
            metaProject2.setCommonDef(commonDef);
            //mobileDef
            MetaMobileDefLoad mobildDefLoad = new MetaMobileDefLoad(AppRunType.App);
            mobildDefLoad.load(projectMetaResolver, DomMetaConstants.MOBILE_DEF_FILE);
            MetaMobileDef metaMobileDef = (MetaMobileDef) mobildDefLoad.getRootMetaObject();
            if (metaMobileDef != null) {
                metaMobileDef.doPostProcess(0, null);
            }
            metaProject2.setMobileDef(metaMobileDef);

            //securityFilter
            MetaSecurityFilterLoad securityFilterLoad = new MetaSecurityFilterLoad(AppRunType.App);
            securityFilterLoad.load(projectMetaResolver, DomMetaConstants.RELATION_FILE);
            MetaSecurityFilter securityFilter = (MetaSecurityFilter) securityFilterLoad.getRootMetaObject();
            if (securityFilter != null) {
                securityFilter.doPostProcess(0, null);
            }
            metaProject2.setSecurityFilter(securityFilter);


            //项目中添加新建的工程
            IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
            MetaProjectCollection projectCollection = globalInstance.getSolution().getProjectCollection();
            projectCollection.add(metaProjectProfile);
            Map<String, IMetaResolver> projectResolverMap = globalInstance.getProjectResolverMap();
            projectResolverMap.put(key, projectMetaResolver);

            //添加新建的工程
            MetaProjectCollection defaultProjectCollection = defaultMetaFactory.getSolution().getProjectCollection();
            defaultProjectCollection.add(metaProjectProfile);
            HashMap<String, IMetaResolver> defaultProjectResolverMap = defaultMetaFactory.getProjectResolverMap();
            defaultProjectResolverMap.put(key, projectMetaResolver);


            EntryProcessor.writeSolution(key, caption, SolutionKey);
            String workspacePath = FilePathHelper.getWorkspacePath();
            if (LoadFileTree.loadImportSolutions.contains(SolutionKey)) {
                DefaultMetaFactory factory = LoadFileTree.metaDesignerFactoryMap.get(SolutionKey);
                String SolutionKey1 = factory.getSolution().getKey();
                LoadFileTree.loadImportSolutions.remove(SolutionKey);
                LoadFileTree.removeFilePath(SolutionKey);
                Collection<MetaSolution> metaSolutions = MetaFactory.getGlobalInstance().getMetaSolutions();
                for (MetaSolution metaSolution : metaSolutions) {
                    if (metaSolution.getKey().equals(SolutionKey1)) {
                        metaSolutions.remove(metaSolution);
                        break;
                    }
                }
                LoadFileTree.clear();
            } else {
                getTreeNode(workspacePath, SolutionKey, false);
            }
            ErpConfig.initExtendConfig();
        }
        return pathName;
    }

    /***
     * 校验key是否存在
     * @param key 标识
     * @return true：存在；false：不存在
     */
    public static boolean isExistKey(String key) {
        if (null != mapBpmKeyToXmlPath && mapBpmKeyToXmlPath.containsKey(key)) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * 新增工作流文件，返回新增节点的Key
     *
     * @param projectKey 项目key
     * @param fileName   文件名
     * @param key        xml key
     * @param caption    xml Caption
     * @return 新增后的全路径文件名
     * @throws Throwable 抛异常
     */
    public static String newBpmFile(String projectKey, String fileName, String key,
                                    String caption) throws Throwable {
        if (null == mapBpmKeyToXmlPath || mapBpmKeyToXmlPath.containsKey(key)) {
            throw new Exception("该key'" + key + "'已存在");
        }
        TreeNode projectNode = getProjectNode(projectKey);
        TreeNode formFold = getChildFoldNode(projectNode, "BPM", projectKey,projectNode.solutionKey);
        String pathName = Paths.get(formFold.key, fileName).toString();
        TreeNode node = new TreeNode(key + ".xml", TreeNode.TYPE_File, caption, pathName, formFold.key, projectKey,
                projectNode.solutionKey);
        mapBpmKeyToXmlPath.put(key, node);
        tree.getNode(node.parentKey).addChild(node);
        return pathName;
    }
    /**
     * 新增域文件，返回新增节点的Key
     *
     * @param projectKey 项目key
     * @param fileName   文件名
     * @param key        xml key
     * @param caption    xml Caption
     * @return 新增后的全路径文件名
     * @throws Throwable 抛异常
     */
    public static String newDomainFile(String projectKey, String fileName, String key,
                                       String caption,String solutionPath) throws Throwable {
        if (null == mapDomainKeyToXmlPath || mapDomainKeyToXmlPath.containsKey(key)) {
            throw new Exception("该key'" + key + "'已存在");
        }
        if (projectKey.isEmpty()){
            TreeNode treeNode = Tree.map.get(solutionPath);
            TreeNode formFold = getChildFoldNode(treeNode, "Domain", projectKey,treeNode.solutionKey);
            String pathName = Paths.get(formFold.key, fileName).toString();
            TreeNode node = new TreeNode(key + ".xml", TreeNode.TYPE_File, caption, pathName, formFold.key,
                    projectKey,treeNode.solutionKey);
            mapDomainKeyToXmlPath.put(key, node);
            tree.getNode(node.parentKey).addChild(node);
            return pathName;
        }else {
            TreeNode projectNode = getProjectNode(projectKey);
            TreeNode formFold = getChildFoldNode(projectNode, "Domain", projectKey,projectNode.solutionKey);
            String pathName = Paths.get(formFold.key, fileName).toString();
            TreeNode node = new TreeNode(key + ".xml", TreeNode.TYPE_File, caption, pathName, formFold.key,
                    projectKey,projectNode.solutionKey);
            mapDomainKeyToXmlPath.put(key, node);
            tree.getNode(node.parentKey).addChild(node);
            return pathName;
        }

    }
    /**
     * 新增数据元素文件，返回新增节点的Key
     *
     * @param projectKey 项目key
     * @param fileName   文件名
     * @param key        xml key
     * @param caption    xml Caption
     * @return 新增后的全路径文件名
     * @throws Throwable 抛异常
     */
    public static String newDataElementFile(String projectKey, String fileName, String key,
                                            String caption,String solutionPath) throws Throwable {
        if (null == mapDataElementKeyToXmlPath || mapDataElementKeyToXmlPath.containsKey(key)) {
            throw new Exception("该key'" + key + "'已存在");
        }
        if (projectKey.isEmpty()){
            TreeNode treeNode = Tree.map.get(solutionPath);
            TreeNode formFold = getChildFoldNode(treeNode, "DataElement", projectKey,treeNode.solutionKey);
            String pathName = Paths.get(formFold.key, fileName).toString();
            TreeNode node = new TreeNode(key + ".xml", TreeNode.TYPE_File, caption, pathName, formFold.key,
                    projectKey,treeNode.solutionKey);
            mapDataElementKeyToXmlPath.put(key.toLowerCase(), node);
            tree.getNode(node.parentKey).addChild(node);
            return pathName;
        }else {
            TreeNode projectNode = getProjectNode(projectKey);
            TreeNode formFold = getChildFoldNode(projectNode, "DataElement", projectKey,projectNode.solutionKey);
            String pathName = Paths.get(formFold.key, fileName).toString();
            TreeNode node = new TreeNode(key + ".xml", TreeNode.TYPE_File, caption, pathName, formFold.key,
                    projectKey,projectNode.solutionKey);
            mapDataElementKeyToXmlPath.put(key, node);
            tree.getNode(node.parentKey).addChild(node);
            return pathName;
        }

    }

    /**
     * 根据文件路径，取得配置读取对象所需要的resource
     *
     * @param filePath
     * @return
     */
    public static String getResource(String filePath,String projectKey) throws Throwable {
        String designerSolutionPathPath = WebDesignerConfiguration.getDesignerSolutionPathPath(projectKey);
        String replace = StringUtils.replace(filePath, designerSolutionPathPath, "..");
        return replace;
    }

    /**
     * 当前resource是否是临时resource，即临时文件
     *
     * @param resource
     * @return
     */
    public static boolean isTmpResource(String resource) {
        return StringUtils.contains(resource, ".." + File.separator + ".." + File.separator + "Data" + File.separator + "designer" + File.separator + XmlFileProcessor.STR_TmpPath);
    }

    /**
     * 取临时文件路径
     *
     * @param resource
     * @return
     */
    public static String getTmpFilePath(String resource) {
        String path = new File(WebDesignerConfiguration.getDesignerDataPath()).getAbsolutePath();
        String filePath = new StringBuilder().append(path).append(File.separator).append(XmlFileProcessor.STR_TmpPath)
                .append(StringUtils.substringAfter(resource, (".." + File.separator + ".." + File.separator + "Data" + File.separator + "designer" + File.separator + "tmp"))).toString();
        return filePath;
    }

    /**
     * 根据文件路径，取得配置读取对象所需要的ProjectKey
     *
     * @param filePath
     * @return
     */
    public static String getProjectKeyByFilePath(String filePath) throws IOException {
        if (StringUtils.contains(filePath, "tmp") && !StringUtils.endsWithIgnoreCase(filePath, "xml")) {
            String tempFileFullName = StringUtils.substringAfterLast(filePath, File.separator);
            return tempFileFullName.split("__")[1];
        }
        if (StringUtils.contains(filePath, "..")) {
            filePath = StringUtils.substringAfterLast(filePath, "..");
            return StringUtils.split(filePath, File.separatorChar)[3];
        }
        // 非主solution时这里获取的会出现问题
        String solutionPath = FilePathHelper.getCoreSolutionPath() + File.separator;
        String relativePath = filePath.replace(solutionPath, "");
        return relativePath.substring(0, relativePath.indexOf(File.separator));
    }

    /**
     * 根据文件路径，取得配置读取对象所需要的Key
     *
     * @param filePath
     * @return
     */
    public static String getKeyByFilePath(String filePath) {
        int beginIndex = filePath.lastIndexOf(File.separator) + 1;
        String substring = filePath.substring(beginIndex);
        return substring.split(".xml")[0];
    }

    public static String getDataMapPathByKey(String Key) {
        if (StringUtils.isEmpty(Key)) {
            return "";
        }
        return Optional.ofNullable(mapDataKeyToXmlPath.get(Key)).map(node -> node.key).orElse("");
    }

    public static String getDataMigrationPathByKey(String Key) {
        if (StringUtils.isEmpty(Key)) {
            return "";
        }
        return Optional.ofNullable(mapDataMigrationToXmlPath.get(Key)).map(node -> node.key).orElse("");
    }

    public static String getBPMPathByKey(String Key) {
        if (StringUtils.isEmpty(Key)) {
            return "";
        }
        return Optional.ofNullable(mapBpmKeyToXmlPath.get(Key)).map(node -> node.key).orElse("");
    }

    /**
     * 新增数据映射创建一个新的路径并且写到tree中
     *
     * @param projectKey 工程名
     * @param fileName   文件名
     * @param key        映射标识
     * @param caption    映射说明
     * @return
     * @throws Throwable
     */
    public static String newDataMap(String projectKey, String fileName, String key,
                                    String caption) throws Throwable {
        if (mapDataKeyToXmlPath.containsKey(key)) {
            throw new Throwable("该key" + key + "已存在");
        }
        TreeNode projectNode = getProjectNode(projectKey);
        TreeNode formFold = getChildFoldNode(projectNode, "Custom", projectKey,projectNode.solutionKey);
        String pathName = Paths.get(formFold.key, "DataMap", fileName).toString();
        TreeNode node = new TreeNode(key + ".xml", TreeNode.TYPE_File, caption, pathName, Paths.get(formFold.key,
                "DataMap").toString(), projectKey,projectNode.solutionKey);
        File file = new File(formFold.key);
        if (!file.exists()) {
            formFold = getChildFoldNode(formFold, "DataMap", projectKey,projectNode.solutionKey);
            pathName = Paths.get(formFold.key, fileName).toString();
            node = new TreeNode(key + ".xml", TreeNode.TYPE_File, caption, pathName,
                    Paths.get(formFold.key, "").toString(), projectKey,projectNode.solutionKey);
        }
        mapDataKeyToXmlPath.put(key, node);
        tree.getNode(node.parentKey).addChild(node);
        return pathName;
    }

    /**
     * 新增数据对象创建一个新的路径并且写到tree中
     *
     * @param projectKey 工程名
     * @param key        标识
     * @param caption    说明
     * @return
     * @throws Throwable
     */
    public static String NewDataObjectFilePath(String projectKey, String key, String caption) throws Throwable {
        if (mapDataObjectKeyToXmlPath.containsKey(key.toLowerCase())
                && MetaFactory.getGlobalInstance().getDataObjectList().get(key) != null) {
            throw new Exception("该key" + key + "已存在");
        }
        TreeNode projectNode = getProjectNode(projectKey);
        TreeNode formFold = getChildFoldNode(projectNode, ConstantUtil.DATA_OBJECT, projectKey,projectNode.solutionKey);
        String pathName = Paths.get(formFold.key, "", key + ".xml").toString();
        TreeNode node = new TreeNode(key + ".xml", TreeNode.TYPE_File, caption, pathName,
                Paths.get(formFold.key, "").toString(), projectKey,projectNode.solutionKey);
        mapDataObjectKeyToXmlPath.put(key.toLowerCase(), node);
        tree.getNode(node.parentKey).addChild(node);
        return pathName;
    }

    /**
     * 新增Excel创建一个新的路径并且写到tree中
     *
     * @param projectKey 工程名
     * @param fileName   文件名
     * @param key        标识
     * @param caption    说明
     * @return
     * @throws Throwable
     */
    public static String NewExcelfilePath(Map<String, String> result, String projectKey,
                                          String fileName,
                                          String key,
                                          String caption) throws Throwable {

        if (MetaFactory.getGlobalInstance().getMetaExcelTemplateList().get(projectKey) != null &&
                MetaFactory.getGlobalInstance().getExcelTemplate(projectKey, key) != null) {
            result.put("result", "false");
            throw new Exception("该key" + key + "已存在");
        }
        result.put("result", "true");
        TreeNode projectNode = getProjectNode(projectKey);
        TreeNode formFold = getChildFoldNode(projectNode, "ExcelTemplate", projectKey,projectNode.solutionKey);
        String pathName = Paths.get(formFold.key, "", fileName).toString();
        TreeNode node = new TreeNode(key + ".xml", TreeNode.TYPE_File, caption, pathName,
                Paths.get(formFold.key, "").toString(), projectKey,projectNode.solutionKey);

        if (!excelKeyToXmlPath.containsKey(projectKey)) {
            Map<String, TreeNode> stringTreeNodeMap = new HashMap<>();
            excelKeyToXmlPath.put(projectKey, stringTreeNodeMap);
        }
        excelKeyToXmlPath.get(projectKey).put(key.toLowerCase(), node);
        tree.getNode(node.parentKey).addChild(node);
        return pathName;
    }

    /**
     * 新增Print创建一个新的路径并且写到tree中
     *
     * @param projectKey 工程名
     * @param fileName   文件名
     * @param key        标识
     * @param caption    说明
     * @return
     * @throws Throwable
     */
    public static String NewPrintfilePath(Map<String, String> result, String projectKey,
                                          String fileName,
                                          String key,
                                          String caption, String associationForm) throws Throwable {
        IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
        if (globalInstance.getReportSubList(associationForm) != null && globalInstance.getReportSubList(associationForm).get(key) != null) {
            result.put("result", "false");
            throw new Exception("该key" + key + "已存在");
        }
        result.put("result", "true");
        TreeNode projectNode = getProjectNode(projectKey);
        TreeNode formFold = getChildFoldNode(projectNode, "Report", projectKey,projectNode.solutionKey);
        String pathName = Paths.get(formFold.key, "", fileName).toString();
        TreeNode node = new TreeNode(key + ".xml", TreeNode.TYPE_File, caption, pathName,
                Paths.get(formFold.key, "").toString(), projectKey,projectNode.solutionKey);
        if (!printKeyToXmlPath.containsKey(associationForm)) {
            HashMap<String, TreeNode> objectObjectHashMap = new HashMap<>();
            printKeyToXmlPath.put(associationForm, objectObjectHashMap);
        }
        printKeyToXmlPath.get(associationForm).put(key.toLowerCase(), node);
        tree.getNode(node.parentKey).addChild(node);
        return pathName;
    }

    /**
     * 新增数据迁移创建一个新的路径并且写到tree中
     *
     * @param projectKey 工程名
     * @param fileName   文件名
     * @param key        映射标识
     * @param caption    映射说明
     * @return
     * @throws Throwable
     */
    public static String newDataMigration(String projectKey, String fileName, String key,
                                          String caption) throws Throwable {
        if (mapDataMigrationToXmlPath.containsKey(key)) {
            throw new Exception("该key" + key + "已存在");
        }
        TreeNode projectNode = getProjectNode(projectKey);
        TreeNode formFold = getChildFoldNode(projectNode, ConstantUtil.DATA_MIGRATION, projectKey,projectNode.solutionKey);
        String pathName = Paths.get(formFold.key, "", fileName).toString();
        TreeNode node = new TreeNode(key + ".xml", TreeNode.TYPE_File, caption, pathName,
                Paths.get(formFold.key, "").toString(), projectKey,projectNode.solutionKey);
        mapDataMigrationToXmlPath.put(key, node);
        tree.getNode(node.parentKey).addChild(node);
        return pathName;
    }

    /**
     * 取下一个兄弟，若取不到，取上一个兄弟，最后取父亲
     *
     * @param filePath
     * @return
     * @throws Throwable
     */
    public static String getNextFilePath(String filePath) throws Throwable {
        ensureLoad();
        TreeNode node = tree.getNode(filePath);
        TreeNode parentNode = tree.getNode(node.parentKey);
        List<TreeNode> brothers = parentNode.children;
        int pos = brothers.indexOf(node);
        String result;
        if (pos < brothers.size() - 1) {
            result = brothers.get(pos + 1).key;
        } else if (pos > 0) {
            result = brothers.get(pos - 1).key;
        } else {
            result = node.parentKey;
        }
        return result;
    }

    public static void removeFilePath(String filePath) throws Throwable {
        removeFilePath(filePath, null);

    }

    public static void addFilePath(String filePath, Object node, String objectType) throws Throwable {
        TreeNode treeNode = (TreeNode) node;
        tree.addTreeNode(treeNode);
        String key = FilenameUtils.getBaseName(filePath);
        switch (objectType) {
            case MetaForm.TAG_NAME:
                mapFormKeyToXmlPath.put(key, treeNode);
                break;
            case MetaProcess.TAG_NAME:
                mapBpmKeyToXmlPath.put(key, treeNode);
                break;
            case ERPMetaMap.TAG_NAME:
                mapDataKeyToXmlPath.put(key, treeNode);
                break;
            case MetaDataObject.TAG_NAME:
                mapDataObjectKeyToXmlPath.put(key, treeNode);
                break;
            case MetaDataMigration.TAG_NAME:
                mapDataMigrationToXmlPath.put(key, treeNode);
                break;
            default:

        }

    }

    public static void addFilePath(String filePath, Object node, String projectKey, String formKey, String objectType) throws Throwable {
        TreeNode treeNode = (TreeNode) node;
        tree.addTreeNode(treeNode);
        String key = FilenameUtils.getBaseName(filePath);
        switch (objectType) {
            case MetaExcelWorkbook.TAG_NAME:
                if (excelKeyToXmlPath.containsKey(projectKey)) {
                    HashMap<String, TreeNode> objectObjectHashMap = new HashMap<>();
                    excelKeyToXmlPath.put(projectKey, objectObjectHashMap);
                }
                excelKeyToXmlPath.get(projectKey).put(key, treeNode);
                break;
            case MetaReport.TAG_NAME:
                if (!printKeyToXmlPath.containsKey(formKey)) {
                    HashMap<String, TreeNode> objectObjectHashMap = new HashMap<>();
                    printKeyToXmlPath.put(formKey, objectObjectHashMap);
                }
                printKeyToXmlPath.get(formKey).put(key, treeNode);
                break;

            default:

        }

    }

    public static void removeFilePath(String filePath, RecycleForm recycleForm) throws Throwable {
        ensureLoad();
        TreeNode node = tree.getNode(filePath);
        tree.removeTreeNode(node);
        String key = FilenameUtils.getBaseName(filePath);
        if (recycleForm != null) {
            recycleForm.setTreeNode(node);
        }
        String objectType = DeleteXmlFileCmd.objectType;
        switch (objectType) {
            case MetaForm.TAG_NAME:
                mapFormKeyToXmlPath.remove(key);
                break;
            case MetaProcess.TAG_NAME:
                mapBpmKeyToXmlPath.remove(key);
                break;
            case ERPMetaMap.TAG_NAME:
                mapDataKeyToXmlPath.remove(key);
                break;
            case MetaDataObject.TAG_NAME:
                mapDataObjectKeyToXmlPath.remove(key);
                break;
            case MetaDataElementDef.TAG_NAME:
                mapDataElementKeyToXmlPath.remove(key);
                break;
            case MetaDomainDef.TAG_NAME:
                mapDomainKeyToXmlPath.remove(key);
                break;
            case MetaExcelWorkbook.TAG_NAME:
                if (excelKeyToXmlPath.containsKey(recycleForm.getProjectKey())) {
                    excelKeyToXmlPath.get(recycleForm.getProjectKey()).remove(key);
                }
                break;
            case MetaReport.TAG_NAME:
                XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePathNotLoadTmp(filePath, false);
                String formKey = xmlTreeWithPath.xmlTree.getRoot().getAttributes().get("FormKey");
                if (printKeyToXmlPath.containsKey(formKey)) {
                    printKeyToXmlPath.get(formKey).remove(key);
                }
                break;
            case MetaDataMigration.TAG_NAME:
                mapDataMigrationToXmlPath.remove(key);
                break;
            default:

        }

    }

    public static boolean isDesignableSolution(String solutionKey) {
        return designableSolutionKeyMap.containsKey(solutionKey);
    }

    public static boolean isJarProjectKey(String projectKey) {
        return jarProjectKey.contains(projectKey);
    }

    /**
     * 获取所有应用的路径
     *
     * @return
     */
    public static List<String> getAllSolutionsPath() {
        List<String> result = new ArrayList<String>();
        List<TreeNode> children = tree.root.children;
        if (children != null) {
            for (TreeNode node : children) {
                if (TreeNode.TYPE_SOLUTION.equalsIgnoreCase(node.type)) {
                    result.add(node.key);
                } else if ("importsolution".equalsIgnoreCase(node.type)) {
                    if (node.children != null) {
                        for (TreeNode importNode: node.children) {
                            if (TreeNode.TYPE_SOLUTION.equalsIgnoreCase(importNode.type)) {
                                result.add(importNode.key);
                            }
                        }
                    }

                } else if ("jarsolution".equalsIgnoreCase(node.type)) {
                    if (node.children != null) {
                        for (TreeNode jarNode: node.children) {
                            if (TreeNode.TYPE_SOLUTION.equalsIgnoreCase(jarNode.type)) {
                                result.add(jarNode.key);
                            }
                        }
                    }
                }
            }
        }

        return result;
    }
}
