package com.bokesoft.yes.design.function;

import com.alibaba.druid.sql.parser.InsertColumnsCache;
import com.bokesoft.erp.WebDesignerConfiguration;
import com.bokesoft.erp.dataelement.Constant;
import com.bokesoft.erp.entity.util.EntityDesigerContextAction;
import com.bokesoft.erp.webdesigner.language.common.Constants;
import com.bokesoft.erp.webdesigner.language.infrastructure.debugger.*;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.cmd.ExpAutoCompleteCmd;
import com.bokesoft.yes.design.cmd.NewFormCmd;
import com.bokesoft.yes.design.cmd.XmlDiffProcessor;
import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.io.IOMetaObject;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.design.io.TreeNode;
import com.bokesoft.yes.design.sql.CalcColumnItemKey;
import com.bokesoft.yes.design.sql.TransmitConditions;
import com.bokesoft.yes.design.utils.*;
import com.bokesoft.yes.design.xml.node.*;
import com.bokesoft.yes.erpdatamap.ERPMetaMap;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.mid.cmd.richdocument.strut.ComboxStringBuilder;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocument;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yes.mid.mysqls.sql.SelectSqlInfo;
import com.bokesoft.yes.mid.mysqls.sql.SqlInfos;
import com.bokesoft.yes.struct.abstractdatatable.RowState;
import com.bokesoft.yes.xml.XmlParser;
import com.bokesoft.yigo.cache.CacheFactory;
import com.bokesoft.yigo.cache.ICache;
import com.bokesoft.yigo.common.def.*;
import com.bokesoft.yigo.meta.base.AbstractCompositeObject;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.common.MetaFieldLabel;
import com.bokesoft.yigo.meta.common.MetaFieldLabelCollection;
import com.bokesoft.yigo.meta.common.MetaMacro;
import com.bokesoft.yigo.meta.common.MetaMacroCollection;
import com.bokesoft.yigo.meta.commondef.MetaCommonDef;
import com.bokesoft.yigo.meta.parameter.MetaParameter;
import com.bokesoft.yigo.meta.parameter.MetaParameterID;
import com.bokesoft.yigo.meta.paratable.MetaParaGroup;
import com.bokesoft.yigo.meta.paratable.MetaParaItem;
import com.bokesoft.yigo.meta.paratable.MetaParaTable;
import com.bokesoft.yigo.meta.dataelement.MetaDataElement;
import com.bokesoft.yigo.meta.dataelement.MetaDataElementCollection;
import com.bokesoft.yigo.meta.dataelement.MetaDataElementDef;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigrationList;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigrationProfile;
import com.bokesoft.yigo.meta.dataobject.*;
import com.bokesoft.yigo.meta.domain.MetaDomain;
import com.bokesoft.yigo.meta.domain.MetaDomainDef;
import com.bokesoft.yigo.meta.entry.MetaEntry;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.MetaEmbed;
import com.bokesoft.yigo.meta.form.component.container.MetaSubDetail;
import com.bokesoft.yigo.meta.form.component.control.MetaDefaultItem;
import com.bokesoft.yigo.meta.form.component.control.MetaLabel;
import com.bokesoft.yigo.meta.form.component.control.MetaRadioButton;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaListBoxItemCollection;
import com.bokesoft.yigo.meta.form.component.control.tableview.MetaTableRow;
import com.bokesoft.yigo.meta.form.component.grid.*;
import com.bokesoft.yigo.meta.form.component.panel.MetaPanel;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaGridLayoutPanel;
import com.bokesoft.yigo.meta.intf.IMetaProject;
import com.bokesoft.yigo.meta.intf.IMetaSolution;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.meta.solution.MetaProjectCollection;
import com.bokesoft.yigo.meta.solution.MetaProjectProfile;
import com.bokesoft.yigo.meta.solution.MetaSolution;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.web.util.DefaultExtensionProvider;
import com.bokesoft.yigo.mid.web.util.ExtensionUtil;
import com.bokesoft.yigo.parser.IEvalContext;
import com.bokesoft.yigo.struct.datatable.ColumnInfo;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.datatable.DataTableMetaData;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.tools.document.DataTableUtil;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.statement.select.PlainSelect;
import net.boke.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.json.JSONArray;
import org.json.JSONObject;

import java.io.File;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.*;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

/**
 * 设计器所用到的所有宏公二开类
 */
public class DesignActionUtil extends EntityDesigerContextAction {
    /**
     * 存储下拉框中是字段
     */
    public static Map<String, String> DataMap = new HashMap<>();

    public static Map<Integer, String> associatedTableMap = new HashMap<>();

    public static Map<Integer, String> bindingGridKeyMap = new HashMap<>();
    private static final Logger logger = Logger.getLogger(ExpAutoCompleteCmd.class.getName());

    /***cache*/
    private static ICache<Object> cache;
    /**
     * 正则表达式预编译
     */
    private static final Pattern PATTERN = Pattern.compile("[a-zA-Z0-9_.,\\-/;\\[\\]‘\\\\${}^|~\\n\\r\\t ]{1,35}");
    private static final Pattern azAZ = Pattern.compile("[a-zA-Z]*$");


    public DesignActionUtil(RichDocumentContext _context) {
        super(_context);
    }

    public String getAllProjects() throws Throwable {
        final IMetaFactory metaFactory = getMidContext().getMetaFactory();
        StringBuilder sb = new StringBuilder(256);
        MetaProjectCollection projectCollection = metaFactory.getSolution().getProjectCollection();
        for (MetaProjectProfile metaProjectProfile : projectCollection) {
            final MetaProject metaProject = metaProjectProfile.getProject();
            if (Objects.isNull(metaProject)) {
                continue;
            }
            final IMetaSolution solution = metaProject.getSolution();
            final boolean flag = solution instanceof MetaSolution;
            if (!flag) {
                continue;
            }
            MetaSolution metaSolution = (MetaSolution) solution;
            if (!LoadFileTree.isDesignableSolution(metaSolution.getKey())) {
                continue;
            }

            String key = metaProjectProfile.getKey();
            String caption = metaProjectProfile.getCaption();
            caption = RegExUtils.replaceAll(caption, ",", "，");
            caption = RegExUtils.replaceAll(caption, "\\s*", "");

            if (sb.length() > 0) {
                sb.append(";");
            }
            sb.append(key).append(",").append(key).append(" ").append(caption);
        }
        return sb.toString();
    }

    public String getChildDirToForm(String projectKey) throws Throwable {
        if (StringUtils.isEmpty(projectKey)) return "";

        List<String> projectKeys = getMidContext().getMetaFactory().getProjectKeys();
        if (!projectKeys.contains(projectKey)) return "";

        StringBuilder sb = new StringBuilder(256);
        TreeNode projectNode = LoadFileTree.getProjectNode(projectKey);
        TreeNode formFold = LoadFileTree.getChildFoldNode(projectNode, "Form", projectKey,projectNode.solutionKey);
        List<TreeNode> children = formFold.children;
        String x = geFiletNameString("",sb, children);
        if (x != null) return x;
        return sb.toString().length() > 0 ?  sb.toString().substring(0, sb.toString().length() - 1) : sb.toString();
    }

    private static String geFiletNameString(String pName,StringBuilder sb, List<TreeNode> children) {
        if (children == null) return "";
        for (int i = 0; i < children.size(); i++) {
            TreeNode treeNode = children.get(i);

            //如果不是是纯英文的，则不处理
            if(!azAZ.matcher(treeNode.name).matches()) continue;
            if(treeNode.type == TreeNode.TYPE_File) continue;
            String treeNodeName = treeNode.name;
            if (!pName.isEmpty()){
                treeNodeName = pName+"/"+treeNode.name;
            }
            sb.append(treeNodeName).append(",").append(treeNodeName).append(";");
            geFiletNameString(treeNodeName,sb,treeNode.children);

        }
        return null;
    }

    /**
     * 判断是否是马甲自身的字段
     *
     * @param columnKey
     * @return
     * @throws Throwable
     */
    public boolean checkExtend(String columnKey) throws Throwable {
        RichDocumentContext midContext = getMidContext();
        String para = (String) midContext.getDefaultContext().getPara("OwnerFormKey");
        if (StringUtils.isBlank(para)) {
            return true;
        }
        MetaForm metaForm = getMidContext().getMetaFactory().getMetaForm(para);
        String extend = metaForm.getExtend();
        if (StringUtils.isEmpty(extend)) {
            return true;
        }
        MetaForm metaForm1 = NewFormCmd.loadMetaForm(extend);
        return !metaForm1.getAllUIComponents().containsKey(columnKey);
    }

    /**
     * 检查表格是否有子明细决定Key是否可以修改
     *
     * @param key
     * @return
     * @throws Throwable
     */
    public boolean checkGridKeyEnable(String key) throws Throwable {
        RichDocumentContext midContext = getMidContext();
        String para = (String) midContext.getDefaultContext().getPara("OwnerFormKey");
        String pathByFormKey = LoadFileTree.getPathByFormKey(para);
        HashMap<String, AbstractNode> mapNodes = new HashMap<>();
        XmlTreeWithPath xmlTree = XmlTreeWithPath.parseFilePath(pathByFormKey);
        if (Objects.nonNull(xmlTree) && Objects.isNull(xmlTree.xmlTree)) {
            mapNodes = xmlTree.xmlTree.getMapNodes();
        }
        // 子明细表关联表格标识
        List<TagNode> collect = mapNodes.values().stream()
                .filter(m -> m.getElement().getTagName().equals("SubDetail"))
                .map(m -> (TagNode) m)
                .filter(c -> c.getAttributes().get("BindingGridKey").equals(key))
                .collect(Collectors.toList());
        return collect.size() == 0;
    }

    public String getStatusCollectionKey() throws Throwable {
        RichDocument doc = getMidContext().getRichDocument();
        DataTable statusCollection = doc.getDataTable(ConstantUtil.TBL_STATUS_COLLECTION);
        List<String> statusKeys = new ArrayList<>();
        for (int i = 0; i < statusCollection.size(); i++) {
            String statusKey = statusCollection.getString(i, "Key");
            statusKeys.add(statusKey + "," + statusKey);
        }
        return StringUtils.join(statusKeys, ";");
    }

    /**
     * 取所有的表单
     *
     * @return
     * @throws Throwable
     */
    public String getAllForms() throws Throwable {
        IMetaFactory metaFactory = getMidContext().getMetaFactory();
        List<String> itemList = new ArrayList<>();
        for (MetaFormProfile metaFormProfile : metaFactory.getMetaFormList()) {
            final MetaForm metaForm = metaFormProfile.getForm();
            if (Objects.isNull(metaForm)) {
                continue;
            }
            String caption = metaForm.getCaption();
            caption = RegExUtils.replaceAll(caption, ",", "，");
            caption = RegExUtils.replaceAll(caption, "\\s*", "");
            String key = metaForm.getKey();
            String item = key + "," + key + " " + caption;
            itemList.add(item);
        }
        return StringUtils.join(itemList, ";");
    }

    public String getAllFormsByProjectKey(String projectKey) throws Throwable {
        IMetaFactory metaFactory = getMidContext().getMetaFactory();
        MetaFormList metaFormList = metaFactory.getMetaFormList();
        List<String> itemList = new ArrayList<>();
        if (StringUtils.isEmpty(projectKey)) {
            for (MetaFormProfile metaFormProfile : metaFormList) {
                if (StringUtils.isNotBlank(metaFormProfile.getExtend())) {
                    continue;
                }
                String caption = metaFormProfile.getCaption();
                caption = RegExUtils.replaceAll(caption, ",", "，");
                caption = RegExUtils.replaceAll(caption, "\\s*", "");
                String item = metaFormProfile.getKey() + "," + metaFormProfile.getKey() + " " + caption;
                itemList.add(item);
            }
        } else {
            String selectSolution = ((MetaSolution) metaFactory.getMetaProject(projectKey).getSolution()).getKey();
            String mainSolution = metaFactory.getSolution().getKey();
            boolean flag = StringUtils.equals(selectSolution, mainSolution);
            for (MetaFormProfile metaFormProfile : metaFormList) {
                if (StringUtils.isNotBlank(metaFormProfile.getExtend())) {
                    continue;
                }
                if (flag && !StringUtils.equals(metaFormProfile.getProject().getKey(), projectKey)) {
                    continue;
                }
                String caption = metaFormProfile.getCaption();
                caption = RegExUtils.replaceAll(caption, ",", "，");
                caption = RegExUtils.replaceAll(caption, "\\s*", "");
                String item = metaFormProfile.getKey() + "," + metaFormProfile.getKey() + " " + caption;
                itemList.add(item);
            }
        }
        return StringUtils.join(itemList, ";");
    }

    /**
     * 去过滤表单通过type
     *
     * @param type
     * @return
     * @throws Throwable
     */
    public String getAllFormsByFormType(int type) throws Throwable {
        if (type != 3 && type != 253 ) {
            return this.getAllForms();
        } else {
            List<String> itemList = new ArrayList<>();

            IMetaFactory metaFactory = getMidContext().getMetaFactory();
            if (type == 253) {
                for (MetaFormProfile metaFormProfile : metaFactory.getMetaFormList()) {
                    if (metaFormProfile.getProject().getKey().equalsIgnoreCase("webconfig")) {
                        continue;
                    }
                    if (metaFormProfile.getFormType() != FormType.Template) {//这些表单类型不能创建视图
                        if (StringUtils.isNotEmpty(metaFormProfile.getExtend())) {
                            int formType = metaFactory.getMetaFormList().get(metaFormProfile.getExtend()).getFormType();
                            if (formType != FormType.Template) {
                                continue;
                            }
                        } else {
                            continue;
                        }
                    }
                    String caption = metaFormProfile.getForm().getCaption();
                    caption = RegExUtils.replaceAll(caption, ",", "，");
                    caption = RegExUtils.replaceAll(caption, "\\s*", "");
                    String key = metaFormProfile.getForm().getKey();

                    String item = key + "," + key + " " + caption;
                    itemList.add(item);
                    // if (itemList.size() >= 20) break;
                }
            } else {
                for (MetaFormProfile metaFormProfile : metaFactory.getMetaFormList()) {
                    if (metaFormProfile.getFormType() == FormType.ChainDict
                            || metaFormProfile.getFormType() == FormType.Dict
                            || metaFormProfile.getFormType() == FormType.CompDict
                            || metaFormProfile.getFormType() == FormType.View) {//这些表单类型不能创建视图
                        continue;
                    }
                    String caption = metaFormProfile.getForm().getCaption();
                    caption = RegExUtils.replaceAll(caption, ",", "，");
                    caption = RegExUtils.replaceAll(caption, "\\s*", "");
                    String key = metaFormProfile.getForm().getKey();

                    String item = key + "," + key + " " + caption;
                    itemList.add(item);
                    // if (itemList.size() >= 20) break;
                }
            }
            return StringUtils.join(itemList, ";");
        }
    }

    /**
     * 取所有的头组件
     *
     * @return
     * @throws Throwable
     */
    public String getAllComponent(String formKey, String dataObjectKey) throws Throwable {
        StringBuilder str = new StringBuilder(256);
        StringBuilder rowStr;

        if (!formKey.isEmpty() && "新建数据对象".equals(dataObjectKey)) {
            try {
                MetaForm metaForm = getMidContext().getMetaFactory().getMetaForm(formKey);
                List<MetaComponent> allComponents = metaForm.getAllComponents();
                for (MetaComponent allComponent : allComponents) {
                    String key = allComponent.getKey();
                    if (StringUtils.isEmpty(key) || "ResetPattern".equals(key) || "SequenceValue".equals(key)
                            || Objects.isNull(allComponent.getDataBinding()) || allComponent instanceof MetaLabel ||
                            allComponent.getDataBinding().getTableKey().isEmpty()) {
                        continue;
                    }
                    String tableKey = allComponent.getDataBinding().getTableKey();
                    String mainTableKey = metaForm.getDataSource().getDataObject().getMainTableKey();
                    if (tableKey.equals(mainTableKey) && allComponent.getParentGridKey().isEmpty()) {
                        int controlType = allComponent.getControlType();
                        if (controlType == ControlType.UTCDATEPICKER || controlType == ControlType.DATEPICKER
                                || controlType == ControlType.NUMBEREDITOR
                                || controlType == ControlType.DICT || controlType == ControlType.CHECKLISTBOX
                                || controlType == ControlType.COMBOBOX ||
                                controlType == ControlType.TEXTEDITOR) {

                            String caption = allComponent.getCaption();
                            caption = RegExUtils.replaceAll(caption, ",", "，");
                            caption = RegExUtils.replaceAll(caption, "\\s*", "");
                            rowStr = new StringBuilder().append(key).append(",").append(key).append(" ").append(caption).append(";");
                            str = str.append(rowStr);
                        }

                    }
                }
            } catch (Exception e) {

            }
        } else if (!"新建数据对象".equals(dataObjectKey) && StringUtils.isNotEmpty(dataObjectKey)) {
            MetaDataObject dataObject = getMidContext().getMetaFactory().getDataObject(dataObjectKey);
            MetaTable mainTable = dataObject.getMainTable();
            if (mainTable != null) {
                for (MetaColumn metaColumn : mainTable) {
                    String key = metaColumn.getKey();
                    if (key.equals(ConstantUtil.OID) || ConstantUtil.SOID.equals(key) || ConstantUtil.POID.equals(key) || ConstantUtil.VERID.equals(key) || ConstantUtil.DVERID.equals(key)) {
                        continue;
                    }
                    String caption = metaColumn.getCaption();
                    caption = RegExUtils.replaceAll(caption, ",", "，");
                    caption = RegExUtils.replaceAll(caption, "\\s*", "");
                    rowStr = new StringBuilder().append(key).append(",").append(key).append(" ").append(caption).append(";");
                    str = str.append(rowStr);
                }
            }

        }
        if (StringUtils.isEmpty(str.toString())) {
            return str.toString();

        } else {
            return str.substring(0, str.toString().length() - 1);

        }


    }

    /**
     * 取指定表格的单元格
     *
     * @return
     * @throws Throwable
     */
    public String getAllGridCellByGridKey(String formKey, String gridKey) throws Throwable {
        StringBuilder str = new StringBuilder(256);
        StringBuilder rowStr;

        MetaForm metaForm = getMidContext().getMetaFactory().getMetaForm(formKey);
        IDLookup idLookup = IDLookup.getIDLookup(metaForm);
        MetaGrid metaGrid = (MetaGrid) metaForm.componentByKey(gridKey);

        List<MetaGridCell> metaGridCells = idLookup.getGridCellsByTableKey(metaGrid.getTableKey());
        for (MetaGridCell metaGridCell : metaGridCells) {
            String key = metaGridCell.getKey();
            String caption = metaGridCell.getCaption();
            caption = RegExUtils.replaceAll(caption, ",", "，");
            caption = RegExUtils.replaceAll(caption, "\\s*", "");
            rowStr = new StringBuilder().append(key).append(",").append(key).append(" ").append(caption).append(";");
            str = str.append(rowStr);
        }
        if (StringUtils.isEmpty(str.toString())) {
            return str.toString();
        } else {
            return str.substring(0, str.toString().length() - 1);

        }


    }

    /**
     * 取所有网格布局面板
     *
     * @return
     * @throws Throwable
     */
    public String getAllGridLayoutPanelByFormKey(String formKey) throws Throwable {
        StringBuilder str = new StringBuilder(256);
        StringBuilder rowStr;
        MetaForm metaForm = getMidContext().getMetaFactory().getMetaForm(formKey);
        IDLookup idLookup = IDLookup.getIDLookup(metaForm);
        String pathByFormKey = LoadFileTree.getPathByFormKey(formKey);
        XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePathNotLoadTmp(pathByFormKey);
        HashMap<String, AbstractNode> mapNodes = xmlTreeWithPath.xmlTree.getMapNodes();
        List<MetaGridLayoutPanel> gridLayoutPanels = idLookup.getGridLayoutPanels();
        for (MetaGridLayoutPanel gridLayoutPanel : gridLayoutPanels) {
            String key = gridLayoutPanel.getKey();
            if (!mapNodes.containsKey("GridLayoutPanel@" + key)) {
                continue;
            }
            String caption = gridLayoutPanel.getCaption();
            caption = RegExUtils.replaceAll(caption, ",", "，");
            caption = RegExUtils.replaceAll(caption, "\\s*", "");
            rowStr = new StringBuilder().append(key).append(",").append(key).append(" ").append(caption).append(";");
            str = str.append(rowStr);
        }
        if (StringUtils.isEmpty(str.toString())) {
            return str.toString();
        } else {
            return str.substring(0, str.toString().length() - 1);

        }


    }

    /**
     * 取所有的数据对象
     *
     * @return
     * @throws Throwable
     */
    public String getAllDataObjects(int formType) throws Throwable {
        int dataObjectSecondaryType = 0;
        StringBuilder sb = new StringBuilder(256);
        sb.append("新建数据对象").append(",").append("新建数据对象").append(" ");
        if (formType == FormType.Dict) {
            dataObjectSecondaryType = DataObjectSecondaryType.DICT;
            getAllDataObject(dataObjectSecondaryType, sb);
        } else if (formType == FormType.Entity) {
            dataObjectSecondaryType = DataObjectSecondaryType.NORMAL;
            getAllDataObject(dataObjectSecondaryType, sb);
        } else if (formType == FormType.ChainDict) {
            dataObjectSecondaryType = DataObjectSecondaryType.CHAINDICT;
            getAllDataObject(dataObjectSecondaryType, sb);
        } else if (formType == 10) {//自定义获取特殊结果集
            sb = new StringBuilder(256);
            MetaDataObjectList projectCollection = getMidContext().getMetaFactory().getDataObjectList();
            for (MetaDataObjectProfile metaDataObjectProfile : projectCollection) {
                MetaDataObject dataObject = metaDataObjectProfile.getDataObject();
                if (StringUtils.isNotEmpty(metaDataObjectProfile.getResource()) ) {
                    if (dataObject == null){
                        dataObject = MetaFactory.getGlobalInstance().getDataObject(metaDataObjectProfile.getKey());
                    }
                    if (dataObject.getSecondaryType() != DataObjectSecondaryType.MIGRATION){
                        String key = metaDataObjectProfile.getKey();
                        String caption = metaDataObjectProfile.getCaption();
                        caption = RegExUtils.replaceAll(caption, ",", "，");
                        caption = RegExUtils.replaceAll(caption, "\\s*", "");
                        if (sb.length() > 0) {
                            sb.append(";");
                        }
                        sb.append(key).append(",").append(key).append(" ").append(caption);
                    }

                }
            }
        } else {
            setDataObjectList(sb);

        }
        return sb.toString();
    }

    private void setDataObjectList(StringBuilder sb) throws Throwable {
        MetaDataObjectList projectCollection = getMidContext().getMetaFactory().getDataObjectList();
        for (MetaDataObjectProfile metaDataObjectProfile : projectCollection) {
            if (metaDataObjectProfile.getResource() != null) {
                String key = metaDataObjectProfile.getKey();
                String caption = metaDataObjectProfile.getCaption();
                caption = RegExUtils.replaceAll(caption, ",", "，");
                caption = RegExUtils.replaceAll(caption, "\\s*", "");
                if (sb.length() > 0) {
                    sb.append(";");
                }
                sb.append(key).append(",").append(key).append(" ").append(caption);
            }
        }
    }

    private void getAllDataObject(int dataObjectSecondaryType, StringBuilder sb) throws Throwable {
        MetaDataObjectList projectCollection = getMidContext().getMetaFactory().getDataObjectList();
        for (MetaDataObjectProfile metaDataObjectProfile : projectCollection) {
            if (Objects.isNull(metaDataObjectProfile.getDataObject())) {
                continue;
            }
            if (metaDataObjectProfile.getResource() != null
                    && metaDataObjectProfile.getDataObject().getSecondaryType() == dataObjectSecondaryType) {
                String key = metaDataObjectProfile.getKey();
                String caption = metaDataObjectProfile.getCaption();
                caption = RegExUtils.replaceAll(caption, ",", "，");
                caption = RegExUtils.replaceAll(caption, "\\s*", "");
                if (sb.length() > 0) {
                    sb.append(";");
                }
                sb.append(key).append(",").append(key).append(" ").append(caption);
            }
        }
    }

    public String getAllDataObjects() throws Throwable {
        StringBuilder sb = new StringBuilder(256);
        MetaDataObjectList projectCollection = getMidContext().getMetaFactory().getDataObjectList();
        for (MetaDataObjectProfile metaDataObjectProfile : projectCollection) {
            if (Objects.isNull(metaDataObjectProfile.getDataObject())) {
                continue;
            }
            if (metaDataObjectProfile.getResource() != null
                    && metaDataObjectProfile.getResource().contains(ConstantUtil.DATA_OBJECT)) {
                String key = metaDataObjectProfile.getKey();
                String caption = metaDataObjectProfile.getCaption();
                caption = RegExUtils.replaceAll(caption, ",", "，");
                caption = RegExUtils.replaceAll(caption, "\\s*", "");
                if (sb.length() > 0) {
                    sb.append(";");
                }
                sb.append(key).append(",").append(key).append(" ").append(caption);
            }
        }
        return sb.toString();
    }

    public String getNoVestDataObject() throws Throwable {
        Function<MetaDataObjectProfile, String> function = profile -> {
            final String extend = profile.getExtend();
            if (StringUtils.isNotBlank(extend)) {
                return null;
            }

            final MetaDataObject dataObject = profile.getDataObject();
            if (Objects.isNull(dataObject)) {
                return null;
            }

            final String resource = profile.getResource();
            if (StringUtils.isEmpty(resource)) {
                return null;
            }

            final String vestKey = dataObject.getMergeToSourceMapKey();
            if (StringUtils.isNotBlank(vestKey)) {
                return null; // 马甲只能创建一次
            }

            String key = profile.getKey();
            String caption = profile.getCaption();
            caption = RegExUtils.replaceAll(caption, ",", "，");
            caption = RegExUtils.replaceAll(caption, "\\s*", "");
            return StringUtils.join(key, ",", key, " ", caption);
        };

        List<String> dataObjectStrList = new ArrayList<>();
        final IMetaFactory metaFactory = getMidContext().getMetaFactory();
        MetaDataObjectList dataObjectList = metaFactory.getDataObjectList();
        for (MetaDataObjectProfile profile : dataObjectList) {
            final String dataObjectStr = function.apply(profile);
            if (StringUtils.isBlank(dataObjectStr)) {
                continue;
            }
            dataObjectStrList.add(dataObjectStr);
        }
        return StringUtils.join(dataObjectStrList, ";");
    }

    public String getAllDataObjectTables(String objectKey) throws Throwable {
        if (StringUtils.isEmpty(objectKey)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(256);
        MetaDataObject dataObject = getMidContext().getMetaFactory().getDataObject(objectKey);
        MetaTableCollection tableCollection = dataObject.getTableCollection();
        if (tableCollection != null && tableCollection.size() > 0) {
            for (MetaTable metaTable : tableCollection) {
                String key = metaTable.getKey();
                String caption = metaTable.getCaption();
                caption = RegExUtils.replaceAll(caption, ",", "，");
                caption = RegExUtils.replaceAll(caption, "\\s*", "");
                if (sb.length() > 0) {
                    sb.append(";");
                }
                sb.append(key).append(",").append(key).append(" ").append(caption);
            }
        }
        return sb.toString();
    }

    private boolean isSetKeyAndCaption() {
        File file = new File(WebDesignerConfiguration.getDesignerDataPath()  + File.separator + "DesignerData.xml");
        boolean value = true;
        if(!file.exists()){return true;}
        try {
            String s = FileUtils.readFileToString(file);
            com.bokesoft.yes.xml.node.XmlTree parse = XmlParser.parse(s);
            com.bokesoft.yes.xml.node.TagNode node = parse.getRoot().findFirstTagNodeByTagName("IsSetKeyAndCaption");
            if(node != null){
                value = Boolean.parseBoolean(node.getAttributes().get("Value"));
            }
        } catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return value;
    }

    public void setDefaultKeyAndCaption(int type) throws Throwable {
        //目前就子明细和表格列
        boolean isSetKeyAndCaption = isSetKeyAndCaption();
        String controlType = ControlType.toString(type);
        RichDocumentContext midContext = getMidContext();
        RichDocument document = midContext.getRichDocument();
        String para = (String) midContext.getDefaultContext().getPara("OwnerFormKey");
        for (int i = 1; i < 20; i++) {
            MetaForm metaForm = getMidContext().getMetaFactory().getMetaForm(para);
            if ("SubDetail".equalsIgnoreCase(controlType)) { //子明细
                IDLookup idLoopup = IDLookup.getIDLookup(metaForm);
                DataTable dataTable = document.getDataTable(ConstantUtil.D_NEW_SUB_DETAIL_HEAD);
                if (!idLoopup.containFieldKey(controlType + i)) {
                    if (isSetKeyAndCaption) {
                        dataTable.setString(ConstantUtil.KEY, controlType + i);
                        dataTable.setString(ConstantUtil.CAPTION, controlType + i);
                    }
                    document.addDirtyTableFlag(ConstantUtil.D_NEW_SUB_DETAIL_HEAD);
                    return;
                } else if (isSetKeyAndCaption){
                    dataTable.setString(ConstantUtil.KEY, controlType + i + 1);
                    dataTable.setString(ConstantUtil.CAPTION, controlType + i + 1);
                }
                document.addDirtyTableFlag(ConstantUtil.D_NEW_SUB_DETAIL_HEAD);
            } else if ("Grid".equalsIgnoreCase(controlType)) {
                IDLookup idLoopup = IDLookup.getIDLookup(metaForm);
                DataTable dataTable = document.getDataTable(ConstantUtil.D_NEW_GRID_HEAD);
                if (!idLoopup.containFieldKey(controlType + i)) {
                    if (isSetKeyAndCaption) {
                        dataTable.setString(ConstantUtil.KEY, controlType + i);
                        dataTable.setString(ConstantUtil.CAPTION, controlType + i);
                    }
                    document.addDirtyTableFlag(ConstantUtil.D_NEW_GRID_HEAD);
                    return;
                } else if (isSetKeyAndCaption) {
                    dataTable.setString(ConstantUtil.KEY, controlType + i + 1);
                    dataTable.setString(ConstantUtil.CAPTION, controlType + i + 1);
                }
                document.addDirtyTableFlag(ConstantUtil.D_NEW_GRID_HEAD);
            } else { //表格列
                List<MetaGridCell> allGridCells = metaForm.getAllGridCells();
                IDLookup loopUp = IDLookup.getIDLookup(metaForm);
                DataTable dataTable = document.getDataTable(ConstantUtil.TBL_NEW_COMP_MODAL);
                if (dataTable != null) {
                    String gridKey = loopUp.getGridKeyByFieldKey(controlType + i);
                    Map<Integer, String> map = new HashMap<Integer, String>();
                    int b = 0;
                    StringHashMap<MetaGridColumn> allFieldKey2MetaGridColumnInfo_oldKey = loopUp.getAllFieldKey2MetaGridColumnInfo_oldKey();
                    List<String> keylist = new ArrayList<>();
                    for (Map.Entry<String, MetaGridColumn> entries : allFieldKey2MetaGridColumnInfo_oldKey.entrySet()) {
                        keylist.add(entries.getKey());
                    }
                    for (String key : keylist) {
                        if (key.indexOf("Detail" + controlType) != -1) {
                            i++;
                        }
                        b++;
                        map.put(b, key);
                    }
                    if (StringUtils.isBlank(gridKey)) {
                        if (map.containsValue("Detail" + controlType + i)) {
                            if (isSetKeyAndCaption) {
                                dataTable.setString(ConstantUtil.KEY, "Detail" + controlType + (i + 1));
                                dataTable.setString(ConstantUtil.CAPTION, "Detail" + controlType + (i + 1));
                                dataTable.setString(ConstantUtil.COLUMN_KEY, "Detail" + controlType + i);
                            }
                        } else if (isSetKeyAndCaption) {
                            dataTable.setString(ConstantUtil.KEY, "Detail" + controlType + i);
                            dataTable.setString(ConstantUtil.CAPTION, "Detail" + controlType + i);
                            dataTable.setString(ConstantUtil.COLUMN_KEY, "Detail" + controlType + i);
                        }
                        document.addDirtyTableFlag(ConstantUtil.TBL_NEW_COMP_MODAL);
                        return;
                    } else if (isSetKeyAndCaption) {
                        dataTable.setString(ConstantUtil.KEY, "Detail" + controlType + i + 1);
                        dataTable.setString(ConstantUtil.CAPTION, "Detail" + controlType + i + 1);
                    }
                    document.addDirtyTableFlag(ConstantUtil.TBL_NEW_COMP_MODAL);
                } else if (document.getDataTable(ConstantUtil.TBL_NEW_SON_COMP) != null) {
                    dataTable = document.getDataTable(ConstantUtil.TBL_NEW_SON_COMP);
                    String gridKey = loopUp.getGridKeyByFieldKey(controlType + i);
                    Map<Integer, String> map = new HashMap<Integer, String>();
                    int b = 0;
                    IDLookup idLoopup = IDLookup.getIDLookup(metaForm);
                    StringHashMap<MetaGridColumn> allFieldKey2MetaGridColumnInfo_oldKey = idLoopup.getAllFieldKey2MetaGridColumnInfo_oldKey();
                    List<String> keylist = new ArrayList<>();
                    for (Map.Entry<String, MetaGridColumn> entries : allFieldKey2MetaGridColumnInfo_oldKey.entrySet()) {
                        keylist.add(entries.getKey());
                    }
                    for (String key : keylist) {
                        if (key.indexOf("Detail" + controlType) != -1) {
                            i++;
                        }
                        b++;
                        map.put(b, key);
                    }
                    if (StringUtils.isBlank(gridKey)) {
                        if (map.containsValue("Detail" + controlType + i)) {
                            if (isSetKeyAndCaption) {
                                dataTable.setString(ConstantUtil.KEY, "Detail" + controlType + (i + 1));
                                dataTable.setString(ConstantUtil.CAPTION, "Detail" + controlType + (i + 1));
                                dataTable.setString(ConstantUtil.COLUMN_KEY, "Detail" + controlType + i);
                            }
                        } else if (isSetKeyAndCaption) {
                            dataTable.setString(ConstantUtil.KEY, "Detail" + controlType + i);
                            dataTable.setString(ConstantUtil.CAPTION, "Detail" + controlType + i);
                            dataTable.setString(ConstantUtil.COLUMN_KEY, "Detail" + controlType + i);
                        }
                        document.addDirtyTableFlag(ConstantUtil.TBL_NEW_SON_COMP);
                        return;
                    } else if (isSetKeyAndCaption) {
                        dataTable.setString(ConstantUtil.KEY, "Detail" + controlType + i + 1);
                        dataTable.setString(ConstantUtil.CAPTION, "Detail" + controlType + i + 1);
                        dataTable.setString(ConstantUtil.COLUMN_KEY, "Detail" + controlType + i);
                    }
                    document.addDirtyTableFlag(ConstantUtil.TBL_NEW_SON_COMP);
                } else if (document.getDataTable(ConstantUtil.TBL_NEW_ROW) != null) {

                } else {
                    dataTable = document.getDataTable(ConstantUtil.D_NEW_COLUMN);
                    controlType = ColumnType.toString(type);
                    String gridKey = loopUp.getGridKeyByFieldKey(controlType + i);
                    Map<Integer, String> map = new HashMap<Integer, String>();
                    int b = 0;
                    for (MetaGridCell all : allGridCells) {
                        String key = all.getKey();
                        if (key.indexOf("Detail" + controlType) != -1) {
                            i++;
                        }
                        b++;
                        map.put(b, key);
                    }
                    if (StringUtils.isBlank(gridKey)) {
                        if (map.containsValue("Detail" + controlType + i)) {
                            if (isSetKeyAndCaption) {
                                dataTable.setString(ConstantUtil.KEY, controlType + (i + 1));
                            }
                        } else {
                            if (isSetKeyAndCaption) {
                                dataTable.setString(ConstantUtil.KEY, controlType + i);
                            }
                            document.addDirtyTableFlag(ConstantUtil.D_NEW_COLUMN);
                            return;
                        }
                    } else if (isSetKeyAndCaption) {
                        dataTable.setString(ConstantUtil.KEY, controlType + i + 1);
                    }
                    document.addDirtyTableFlag(ConstantUtil.D_NEW_COLUMN);
                }
            }
        }
    }

    /**
     * 设置默认的Key和Caption
     *
     * @throws Throwable
     */
    public void setDefaultKeyAndCaption() throws Throwable {
        boolean isSetKeyAndCaption = isSetKeyAndCaption();
        RichDocumentContext midContext = getMidContext();
        RichDocument document = midContext.getRichDocument();
        DataTable dataTable = document.getDataTable(ConstantUtil.ED_NEW_FORM);
        int formType = dataTable.getInt("FormType");
        if (formType == 9) {
            formType = FormType.Normal;
        }
        if (formType != 10) {


            String sFormType = FormType.toString(formType);
            MetaFormList metaFormList = midContext.getMetaFactory().getMetaFormList();
            Integer i = 0;
            while (true) {
                String tmp = sFormType.concat(i.toString());
                if (!metaFormList.containsKey(tmp)) {
                    if (isSetKeyAndCaption) {
                        //	String oldValue = (String) dataTable.getOriginalObject(ConstantUtil.KEY);
                        //if (StringUtils.isBlank(oldValue)) {
                        dataTable.setString(ConstantUtil.KEY, tmp);
                        //}
                        //oldValue = (String) dataTable.getOriginalObject(ConstantUtil.CAPTION);
                        //	if (StringUtils.isBlank(oldValue)) {
                        dataTable.setString(ConstantUtil.CAPTION, tmp);
                        //}
                    }
                    dataTable.setString("InDataObject", "新建数据对象");
                    document.addDirtyTableFlag(ConstantUtil.ED_NEW_FORM);
                    return;
                }
                i++;
            }
        }
    }

    /**
     * 给马甲和视图设置默认的Key和Caption
     *
     * @throws Throwable
     */
    public void setExpandDefaultKeyAndCaption(int type) throws Throwable {
        boolean isSetKeyAndCaption = isSetKeyAndCaption();
        RichDocumentContext midContext = getMidContext();
        RichDocument document = midContext.getRichDocument();
        DataTable dataTable = document.getDataTable(ConstantUtil.ED_NEW_FORM);
        String associationForm = dataTable.getString("AssociationForm");
        if (StringUtils.isEmpty(associationForm)) {
            return;
        }
        IMetaFactory iMetaFactory = getMidContext().getMetaFactory();
        MetaForm metaForm = iMetaFactory.getMetaForm(associationForm);
        String associationCaption = metaForm.getCaption() + "马甲";
        String sFormType = associationForm + "_Vest";
        if (type == 3) {
            associationCaption = metaForm.getCaption() + "视图";
            sFormType = associationForm + "_View";
        }
        MetaFormList metaFormList = midContext.getMetaFactory().getMetaFormList();
        Integer i = 0;
        while (true) {
            String tmp = sFormType.concat(i.toString());
            String Caption = associationCaption.concat(i.toString());
            if (!metaFormList.containsKey(tmp)) {
                if (isSetKeyAndCaption) {
                    dataTable.setString(ConstantUtil.KEY, tmp);
                    dataTable.setString(ConstantUtil.CAPTION, Caption);
                }
                document.addDirtyTableFlag(ConstantUtil.ED_NEW_FORM);
                return;
            }
            i++;
        }
    }

    private void addDetailCompToList(MetaComponent component, List<MetaComponent> allDetailComps){
        if(!allDetailComps.contains(component)){
            allDetailComps.add(component);
        }
        if(component.getComponentCount()>0){
            for (int i = 0; i < component.getComponentCount(); i++) {
                MetaComponent subComp = component.getComponent(i);
                addDetailCompToList(subComp, allDetailComps);
            }
        }
    }

    public void setMoudelPanel(int panel, String panelKey) throws Throwable {//面板界面
        boolean isSetKeyAndCaption = isSetKeyAndCaption();
        if (String.valueOf(panel).length() == 4) {
            panel = Integer.parseInt(String.valueOf(panel).substring(0, 3));
        }
        String controlType = ControlType.toString(panel);
        RichDocumentContext midContext = getMidContext();
        RichDocument document = midContext.getRichDocument();
        String para = (String) midContext.getDefaultContext().getPara("OwnerFormKey");
        for (int i = 1; i < 20; i++) {
            MetaForm form = getMidContext().getMetaFactory().getMetaForm(para);
            form.doPostProcess(-1, null);
            List<MetaComponent> allComponents = form.getAllComponents();
            List<MetaComponent> allDetailComps = new ArrayList<>();
            for(int j=0;j<form.getAllDetailComponents().size();j++){
                MetaComponent component = form.getAllDetailComponents().get(j);
                addDetailCompToList(component, allDetailComps);
            }
            allComponents.addAll(allDetailComps);
            DataTable dataTable = document.getDataTable(panelKey);
            Map<Integer, String> map = new HashMap<Integer, String>();
            int b = 1;
            for (MetaComponent all : allComponents) {
                String key = all.getKey();
                if (key.equalsIgnoreCase("Head" + controlType + i)) {
                    i++;
                }
                b++;
                map.put(b, key);
            }
            if (!map.containsValue("Head" + controlType + i)) {
                if (isSetKeyAndCaption) {
                    dataTable.setString(ConstantUtil.KEY, "Head" + controlType + i);
                    dataTable.setString(ConstantUtil.CAPTION, "Head" + controlType + i);
                }
                document.addDirtyTableFlag(panelKey);
                return;
            } else if (isSetKeyAndCaption) {
                dataTable.setString(ConstantUtil.KEY, "Head" + controlType + i + 1);
                dataTable.setString(ConstantUtil.CAPTION, "Head" + controlType + i + 1);
            }
        }
        document.addDirtyTableFlag(panelKey);
    }

    public boolean isMergeToSource() throws Throwable {
        RichDocumentContext midContext = getMidContext();
        RichDocument document = midContext.getRichDocument();
        DataTable dataTable = document.getDataTable(ConstantUtil.ED_NEW_FORM);
        String associationForm = dataTable.getString("AssociationForm");
        MetaFormList metaFormList = midContext.getMetaFactory().getMetaFormList();
        for (MetaFormProfile metaFormProfile : metaFormList) {
            if (metaFormProfile.getMergeToSource()) {
                if (associationForm.equalsIgnoreCase(metaFormProfile.getExtend())) {
                    return false;
                }
            }
        }
        return true;
    }

    /**
     * /**
     * 取所有目录节点
     */
    public String getAllItems() throws Throwable {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<>();
        linkedHashMap.put("请选择创建路径", "请选择创建路径");

        MetaEntry metaEntry = getMidContext().getMetaFactory().getEntryList("");

        String pEntryKey = "";
        String pEntryCaption = "";
        //linkedHashMap.put(pEntryKey, pEntryCaption);
        getEntryItems(linkedHashMap, metaEntry, pEntryKey, pEntryCaption);
        return linkedHashMap.toString().replaceAll(",", ";").replaceAll("=", ",").replaceAll(" ", "").replaceAll("\\{",
                "").replaceAll("\\}", "").replaceAll("\\+", "=");


    }

    public static void getEntryItems(LinkedHashMap<String, String> linkedHashMap, MetaEntry metaEntry, String pEntryKey,
                                     String pEntryCaption) throws Throwable {
        for (int i = 0; i < metaEntry.size(); i++) {
            AbstractCompositeObject abstractCompositeObject = metaEntry.get(i);
            if (abstractCompositeObject instanceof MetaEntry) {
                findItems(linkedHashMap, (MetaEntry) abstractCompositeObject, pEntryCaption, pEntryKey);
            }
        }
    }

    /**
     * /**
     * 取所有目录节点
     */
    public String getSideKeys(String parentKey, String filePath) throws Throwable {
        if (StringUtils.isBlank(parentKey) || StringUtils.isBlank(filePath)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(256);
        sb.append("last").append(",").append("last").append(" ").append("末尾追加").append(";");
        sb.append("first").append(",").append("first").append(" ").append("起首追加");
        XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePathNotLoadTmp(filePath);
        TagNode tagNode = xmlTreeWithPath.xmlTree.getTagNode("Entry" + "@" + parentKey);
        for (AbstractNode child : tagNode.getChildren()) {
            if (child instanceof TagNode) {
                TagNode child1 = (TagNode) child;
                String key = child1.getAttributes().get(ConstantUtil.KEY);
                if (StringUtils.isEmpty(key)) {
                    continue;
                }
                String caption = child1.getAttributes().get(ConstantUtil.CAPTION);

                if (sb.length() > 0) {
                    sb.append(";");
                }
                sb.append(key).append(",").append(key).append(" ").append(caption + "的后面");
            }
        }
        return sb.toString();
    }

    public static void findItems(LinkedHashMap<String, String> linkedHashMap, MetaEntry metaEntry, String pEntryCaption,
                                 String pEntryKey) throws Throwable {

        String pEntryKeys = pEntryKey + "/Entry[@Key+'" + metaEntry.getKey() + "']";
        String pEntryCaptions = pEntryCaption + "/" + metaEntry.getCaption();
        linkedHashMap.put(pEntryKeys, pEntryCaptions);

        if (metaEntry.size() != 0) {
            for (int j = 0; j < metaEntry.size(); j++) {
                if (metaEntry.get(j) instanceof MetaEntry) {
                    findItems(linkedHashMap, (MetaEntry) metaEntry.get(j), pEntryCaptions, pEntryKeys);
                }
            }
        }
    }

    /**
     * 表标识下拉框
     *
     * @return
     * @throws Throwable
     */
    public String getAllTableKey() throws Throwable {
        StringBuilder str = new StringBuilder(256).append("无数据表,无数据表");
        StringBuilder rowStr;
        RichDocumentContext midContext = getMidContext();
        String para = (String) midContext.getDefaultContext().getPara("OwnerFormKey");
        String containerKey = (String) midContext.getDefaultContext().getPara("ContainerKey");
        MetaForm metaForm = getMidContext().getMetaFactory().getMetaForm(para);
        MetaDataSource dataSource = metaForm.getDataSource();
        MetaTableCollection tableCollection = null;
        if (dataSource != null) {
            tableCollection = dataSource.getDataObject().getTableCollection();
        } else if (containerKey != null && !containerKey.isEmpty()) {
            String OtherKey = containerKey;
            metaForm = getMidContext().getMetaFactory().getMetaForm(OtherKey);
            tableCollection = metaForm.getDataSource().getDataObject().getTableCollection();
        }
        if (tableCollection != null) {
            for (MetaTable metaTable : tableCollection) {
                String tableKey = metaTable.getKey();
                if (hasEmbedTable(metaForm, metaTable, "")) {
                    continue;
                }
                String caption = metaTable.getCaption();
                caption = RegExUtils.replaceAll(caption, ",", "，");
                caption = RegExUtils.replaceAll(caption, "\\s*", "");
                rowStr = new StringBuilder().append(";").append(tableKey).append(",").append(tableKey).append(" ").append(caption);
                str = str.append(rowStr);
            }
            return str.toString();
        } else {
            return str.toString();
        }
    }

    /**
     * 父表标识下拉框
     *
     * @return
     * @throws Throwable
     */
    public String getTableKey() throws Throwable {
        StringBuilder str = new StringBuilder(256);
        StringBuilder rowStr;
        RichDocumentContext midContext = getMidContext();
        String para = (String) midContext.getDefaultContext().getPara("OwnerFormKey");
        String containerKey = (String) midContext.getDefaultContext().getPara("ContainerKey");
        MetaForm metaForm = getMidContext().getMetaFactory().getMetaForm(para);
        MetaDataSource dataSource = metaForm.getDataSource();
        MetaTableCollection tableCollection = null;
        if (dataSource != null) {
            tableCollection = metaForm.getDataSource().getDataObject().getTableCollection();
        } else if (containerKey != null && !containerKey.isEmpty()) {
            String OtherKey = containerKey;
            metaForm = getMidContext().getMetaFactory().getMetaForm(OtherKey);
            tableCollection = metaForm.getDataSource().getDataObject().getTableCollection();
        }
        if (tableCollection != null) {
            for (MetaTable metaTable : tableCollection) {
                String tableKey = metaTable.getKey();
                if (hasEmbedTable(metaForm, metaTable, "")) {
                    continue;
                }
                String caption = metaTable.getCaption();
                caption = RegExUtils.replaceAll(caption, ",", "，");
                caption = RegExUtils.replaceAll(caption, "\\s*", "");
                rowStr = new StringBuilder().append(";").append(tableKey).append(",").append(tableKey).append(" ").append(caption);
                str = str.append(rowStr);
            }
            return str.toString();
        } else {
            return str.toString();
        }
    }

    /**
     * 父表标识下拉框
     *
     * @return
     * @throws Throwable
     */
    public String getTableKey(String parentCompKey) throws Throwable {
        StringBuilder str = new StringBuilder(256);
        StringBuilder rowStr;
        RichDocumentContext midContext = getMidContext();
        String para = (String) midContext.getPara("OwnerFormKey");
        String containerKey = (String) midContext.getPara("ContainerKey");
        MetaForm metaForm = getMidContext().getMetaFactory().getMetaForm(para);
        MetaDataSource dataSource = metaForm.getDataSource();
        MetaTableCollection tableCollection = null;
        if (dataSource != null) {
            tableCollection = metaForm.getDataSource().getDataObject().getTableCollection();
        } else if (containerKey != null && !containerKey.isEmpty()) {
            String OtherKey = containerKey;
            metaForm = getMidContext().getMetaFactory().getMetaForm(OtherKey);
            tableCollection = metaForm.getDataSource().getDataObject().getTableCollection();
        }
        if (tableCollection != null) {
            for (MetaTable metaTable : tableCollection) {
                if (metaTable.getKey().endsWith("_NODB")){
                    continue;
                }
                String tableKey = metaTable.getKey();
                if (hasEmbedTable(metaForm, metaTable, parentCompKey)) {
                    continue;
                }
                String caption = metaTable.getCaption();
                caption = RegExUtils.replaceAll(caption, ",", "，");
                caption = RegExUtils.replaceAll(caption, "\\s*", "");
                rowStr = new StringBuilder().append(";").append(tableKey).append(",").append(tableKey).append(" ").append(caption);
                str = str.append(rowStr);
            }
            return str.toString();
        } else {
            return str.toString();
        }
    }

    public static boolean hasEmbedTable(MetaForm metaForm, MetaTable metaTable, String parentCompKey) throws Throwable {
        return false;
    }

    /**
     * 根组件标识下拉框
     *
     * @return
     * @throws Throwable
     */
    public String getRootKey(String formKey) throws Throwable {
        StringBuilder str = new StringBuilder(256);
        if (StringUtils.isEmpty(formKey) || "continue".equalsIgnoreCase(formKey)) {
            return str.toString();
        }
        StringBuilder rowStr;
        MetaForm metaForm = getMidContext().getMetaFactory().getMetaForm(formKey);
        IDLookup idLookup = IDLookup.reloadIDLookup(metaForm);
        StringHashMap<String> panelKeys = idLookup.getPanelKeys();
        for (Map.Entry<String, String> stringStringEntry : panelKeys.entrySet()) {
            String key = stringStringEntry.getKey();
            String caption = stringStringEntry.getValue();
            if (StringUtils.isEmpty(caption)) {
                caption = key;
            }
            rowStr = new StringBuilder().append(";").append(key).append(",").append(key).append("   ").append(caption);
            str.append(rowStr);
        }
        return str.toString();
    }

    /**
     * 展示是否新增数据源
     *
     * @return
     */
    public boolean showNewColumnButton() throws Throwable {
        RichDocumentContext midContext = getMidContext();
        String ownerFormKey = (String) midContext.getPara("OwnerFormKey");
        String gridKey = (String) midContext.getPara("GridKey");
        MetaForm metaForm = getMidContext().getMetaFactory().getMetaForm(ownerFormKey);
        MetaGrid metaGrid = (MetaGrid) metaForm.getAllUIComponents().get(gridKey);
        return !metaGrid.getTableKey().contains(ConstantUtil.NODB);
    }

    /**
     * 列标识
     *
     * @return
     * @throws Throwable
     */
    public String getAllColumnKey(String tableKey, boolean isDataObject) throws Throwable {
        StringBuilder str = new StringBuilder(256).append("无字段,无字段");
        if (StringUtils.isBlank(tableKey)) {
            return str.toString();
        }
        StringBuilder columnStr;
        String formKey = getMidContext().getFormKey();
        if (formKey.equals("D_DataObject")){
            DataTable dataTable = getMidContext().getRichDocument().get("ED_TableFields");
            DataTable ed_tableCollection = getMidContext().getRichDocument().get("ED_TableCollection");
            Long OID = 0L;
            for (int i = 0; i < ed_tableCollection.size(); i++) {
                String tableMark = ed_tableCollection.getString(i, "TableMark");
                if (tableMark.equalsIgnoreCase(tableKey)){
                    OID = ed_tableCollection.getLong(i, "OID");
                    break;
                }
            }
            for (int i = 0; i < dataTable.size(); i++) {
                String columnKey = dataTable.getString(i,"ColumnKey");
                Long poid = dataTable.getLong(i,"POID");
                if (!Objects.equals(poid, OID)){
                    continue;
                }
                //要通过POid过滤
                if ("MapCount".equals(columnKey) || "SelectField".equals(columnKey)) {
                    continue;
                }
                String caption = dataTable.getString(i,"ColumnName");
                caption = RegExUtils.replaceAll(caption, ",", "，");
                caption = RegExUtils.replaceAll(caption, "\\s*", "");
                columnStr = new StringBuilder().append(";").append(columnKey).append(",").append(columnKey).append(" ").append(caption);
                str = str.append(columnStr);
            }
        } else {
            RichDocumentContext midContext = getMidContext();
            String para = (String) midContext.getDefaultContext().getPara("OwnerFormKey");
            String containerKey = (String) midContext.getDefaultContext().getPara("ContainerKey");
            MetaTable table = null;
            if (isDataObject){
                table = getMidContext().getMetaFactory().getDataObject(para).getMetaTable(tableKey);
            }else {
                MetaForm metaForm = getMidContext().getMetaFactory().getMetaForm(para);
                MetaDataSource dataSourse = metaForm.getDataSource();
                if (dataSourse != null) {
                    table = dataSourse.getDataObject().getTable(tableKey);
                } else if (containerKey != null && !containerKey.isEmpty()) {
                    String OtherKey = containerKey;
                    metaForm = getMidContext().getMetaFactory().getMetaForm(OtherKey);
                    table = metaForm.getDataSource().getDataObject().getTable(tableKey);
                }
            }
            if (Objects.isNull(table)) {
                return str.toString();
            }
            DataTable dataTable = WebDesignerDataTableUtil.generateDataTable(table);
            DataTableMetaData dataTableMetaData = dataTable.getMetaData();
            for (int i = 0, len = dataTableMetaData.getColumnCount(); i < len; i++) {
                ColumnInfo columnInfo = dataTableMetaData.getColumnInfo(i);
                String columnKey = columnInfo.getColumnKey();
                if ("MapCount".equals(columnKey) || "SelectField".equals(columnKey)) {
                    continue;
                }
                MetaColumn metaColumn = table.get(columnKey);
                if (metaColumn != null) {
                    String caption = metaColumn.getCaption();
                    caption = RegExUtils.replaceAll(caption, ",", "，");
                    caption = RegExUtils.replaceAll(caption, "\\s*", "");
                    columnStr = new StringBuilder().append(";").append(columnKey).append(",").append(columnKey).append(" ").append(caption);
                    str = str.append(columnStr);
                }
            }
        }
        return str.toString();
    }

    public String getAllColumnKey(String tableKey) throws Throwable {
        return getAllColumnKey(tableKey, false);
    }

    /**
     * 获取表格所有列标识
     *
     * @return
     * @throws Throwable
     */
    public String getExpandAllColumnKey() throws Throwable {
        StringBuilder result = new StringBuilder(256).append("无字段,无字段");
        RichDocumentContext midContext = getMidContext();
        String para = (String) midContext.getDefaultContext().getPara("OwnerFormKey");
        String containerKey = (String) midContext.getDefaultContext().getPara("ContainerKey");
        String OtherKey = null;
        if (containerKey != null && containerKey.length() > 0 && !"null".equals(containerKey)) {
            OtherKey = containerKey;
        }

        MetaForm metaForm = getMidContext().getMetaFactory().getMetaForm(para);
        MetaForm containerForm = null;
        if (OtherKey != null) {
            containerForm = getMidContext().getMetaFactory().getMetaForm(OtherKey);
        }

        String gridTableKey = IOMetaObject.getGridTableKey();
        //可能存在表格绑定的为无数据表（_NODB结尾）
        if (!StringUtils.isBlank(gridTableKey) && !gridTableKey.endsWith("_NODB")) {
            MetaTable metaTable = null;
            if (Objects.isNull(metaForm.getDataSource()) || containerForm != null) {
                metaTable = containerForm.getDataSource().getDataObject().getTable(gridTableKey);
            } else if (Objects.isNull(metaTable)) {
                metaTable = metaForm.getDataSource().getDataObject().getTable(gridTableKey);
            }
            for (MetaColumn metaColumn : metaTable) {
                String caption = metaColumn.getCaption();
                caption = RegExUtils.replaceAll(caption, ",", "，");
                caption = RegExUtils.replaceAll(caption, "\\s*", "");
                String columnKey = metaColumn.getKey();
                if ("MapCount".equals(columnKey) || "SelectField".equals(columnKey) || columnKey.endsWith("_NODB")) {
                    continue;
                }
                result.append(";").append(columnKey).append(",").append(columnKey).append(" ").append(caption);
            }
        }
        return result.toString();
    }

    /**
     * 字典过滤界面获取字段下拉框字段
     *
     * @param ItemKey
     * @return
     * @throws Throwable
     */
    public String getDropField(String ItemKey) throws Throwable {
        if (StringUtils.isEmpty(ItemKey)) {
            return "";
        }
// 用来设置要筛出去的下拉框字段值
        Map<String, String> siftout = new HashMap<>(64);
        siftout.put(ConstantUtil.SOID, ConstantUtil.SOID);
        siftout.put(ConstantUtil.POID, ConstantUtil.POID);
        siftout.put(ConstantUtil.VERID, ConstantUtil.VERID);
        siftout.put(ConstantUtil.DVERID, ConstantUtil.DVERID);
        siftout.put("ERPMapCount", "ERPMapCount");
        siftout.put("MapCount", "MapCount");
        StringBuilder dropData = new StringBuilder(512);
        MetaDataObject metaForm = getMidContext().getMetaFactory().getDataObject(ItemKey);
        if (Objects.isNull(metaForm)) {
            return "";
        }
        MetaTableCollection metatablecollection = metaForm.getTableCollection();
        MetaTable metatable = metatablecollection.get(0);
        Iterator<Map.Entry<String, MetaColumn>> iterator = metatable.entryIterator();

        DataMap.clear();
        for (int x = 0; x < metatable.size(); x++) {
            if (iterator.hasNext()) {
                Map.Entry<String, MetaColumn> entry = iterator.next();
                String key = entry.getKey();
                if (!siftout.containsKey(key)) {
                    String caption = entry.getValue().getCaption();
                    caption = RegExUtils.replaceAll(caption, ",", "，");
                    caption = RegExUtils.replaceAll(caption, "\\s*", "");
                    dropData.append(key).append(",").append(key).append(" ").append(caption).append(";");
                    DataMap.put(key, key);
                }
            }
        }
        return dropData.toString();
    }

    public String getGridFiled(String gridKey) throws Throwable {
        StringBuilder str = new StringBuilder(256).append(", ");
        RichDocumentContext midContext = getMidContext();
        String para = (String) midContext.getDefaultContext().getPara("OwnerFormKey");//获得表单key
        String compKey = (String) midContext.getDefaultContext().getPara("compKey");//获得表单key
        MetaForm metaForm = getMidContext().getMetaFactory().getMetaForm(para);
        MetaGrid metaGrid = (MetaGrid) metaForm.getAllUIComponents().get(compKey);
        MetaTable metaColumns = metaForm.getDataSource().getDataObject().getTable(metaGrid.getTableKey());
        StringBuilder columnStr;
        for (MetaColumn metaColumn : metaColumns) {
            String caption = metaColumn.getCaption();
            caption = RegExUtils.replaceAll(caption, ",", "，");
            caption = RegExUtils.replaceAll(caption, "\\s*", "");
            columnStr = new StringBuilder().append(";").append(metaColumn.getKey()).append(",").append(metaColumn.getKey()).append(" ").append(caption);
            str = str.append(columnStr);
        }
        return str.toString();
    }

    //字典标识获取方法
    public String getItemKey() throws Throwable {
        return this.getItemKey(false);
    }

    // 字典标识获取方法
    public String getItemKey(boolean excludeBillItemKey) throws Throwable {
        //       优化查询字典标识时英文也支持
        MetaFormList metaForm = getMidContext().getMetaFactory().getMetaFormList();
        StringBuilder str = new StringBuilder(256);
        StringBuilder rowStr;
        for (MetaFormProfile meta : metaForm) {
            if (meta.getFormType() == 2 || meta.getFormType() == 6 || meta.getFormType() == 7) {
                if(meta.getForm() == null){
                    getMidContext().getMetaFactory().getMetaForm(meta.getKey());
                }
                MetaDataSource metadatasource = meta.getForm().getDataSource();
                String caption = meta.getCaption();
                caption = RegExUtils.replaceAll(caption, ",", "，");
                caption = RegExUtils.replaceAll(caption, "\\s*", "");
                if (metadatasource != null) {
                    String refobjectkey = metadatasource.getRefObjectKey();
                    if (refobjectkey == "") {
                        rowStr = new StringBuilder().append(";")
                                .append(metadatasource.getDataObject().getKey()).append(",")
                                .append(metadatasource.getDataObject().getKey()).append(" ")
                                .append(caption);
                        str = str.append(rowStr);
                    } else {
                        rowStr = new StringBuilder()
                                .append(";").append(refobjectkey)
                                .append(",").append(refobjectkey)
                                .append(" ").append(caption);
                        str = str.append(rowStr);
                    }
                } else {
                    rowStr = new StringBuilder().append(";")
                            .append(meta.getKey()).append(",")
                            .append(meta.getKey()).append(" ")
                            .append(caption);
                    str = str.append(rowStr);
                }
            }
        }
        MetaDataObjectList metaDataObjectProfiles = getMidContext().getMetaFactory().getDataObjectList();
        for (MetaDataObjectProfile metaDataObjectProfile : metaDataObjectProfiles) {
            if (metaDataObjectProfile.getSecondaryType() == 5 || metaDataObjectProfile.getSecondaryType() == 3) {
                if (excludeBillItemKey) {
                    if (metaDataObjectProfile.getSecondaryType() == DataObjectSecondaryType.CHAINDICT
                            && !metaForm.containsKey(metaDataObjectProfile.getKey())) {
                        continue;
                    }
                }
                String caption = metaDataObjectProfile.getCaption();
                caption = RegExUtils.replaceAll(caption, ",", "，");
                caption = RegExUtils.replaceAll(caption, "\\s*", "");
                rowStr = new StringBuilder()
                        .append(";").append(metaDataObjectProfile.getKey())
                        .append(",").append(metaDataObjectProfile.getKey())
                        .append(" ").append(caption);
                if (str.indexOf(rowStr.toString()) == -1) {
                    str = str.append(rowStr);
                }
            }
        }
        return str.toString();


    }

    //根节点点标识获取方法
    public String getParentItemKey() throws Throwable {
        String key = "";
        if (this.getDocument().getDataTable(ConstantUtil.TBL_COMPONENT) != null && this.getDocument().getDataTable(ConstantUtil.TBL_COMPONENT).size() != 0) {
            key = this.getDocument().getDataTable(ConstantUtil.TBL_COMPONENT).getString(0, "getKey");
        }
        StringBuilder str = new StringBuilder(256).append(", ");
        RichDocumentContext midContext = getMidContext();
        String para = (String) midContext.getDefaultContext().getPara("OwnerFormKey");//获得表单key
        MetaForm metaForm = getMidContext().getMetaFactory().getMetaForm(para);
        IDLookup idLookup = IDLookup.getIDLookup(metaForm);
        Collection<String> fieldKeys = idLookup.getFieldKeys();//所有字段key
        for (String fieldKey : fieldKeys) {
            if (fieldKey.isEmpty()) {
                continue;
            }
            MetaGridCell cell = null;
            MetaComponent component = idLookup.getComponentByKey(fieldKey);
            if (Objects.isNull(component)) {
                cell = idLookup.getGridCellByKey(fieldKey);
            } else {
                int fieldControlType = component.getControlType();//字段类型
                if (ControlType.DICT == fieldControlType && !fieldKey.equals(key)) {
                    String columnKeyByFieldKey = idLookup.getFieldCaption(fieldKey);
                    str.append(";").append(fieldKey).append(",").append(fieldKey).append(" ").append(columnKeyByFieldKey);
                }
            }
            if (Objects.isNull(cell)) {
                continue;
            } else {
                int fieldControlType = cell.getCellType();//字段类型
                if (ControlType.DICT == fieldControlType && !fieldKey.equals(key)) {
                    String columnKeyByFieldKey = idLookup.getFieldCaption(fieldKey);
                    str.append(";").append(fieldKey).append(",").append(fieldKey).append(" ").append(columnKeyByFieldKey);
                }
            }
        }
        return str.toString();
    }

    //获取表单中字典标识
    public String getDictItem(String Key) throws Throwable {
        StringBuilder str = new StringBuilder(256);
        RichDocumentContext midContext = getMidContext();
        String para = (String) midContext.getDefaultContext().getPara("OwnerFormKey");//获得表单key
        MetaForm metaForm = getMidContext().getMetaFactory().getMetaForm(para);
        IDLookup idLookup = IDLookup.getIDLookup(metaForm);
        String gridKey = idLookup.getGridKeyByFieldKey(Key);
        if (StringUtils.isNotEmpty(gridKey)) {
            MetaGrid metaGrid = idLookup.getMetaGridByGridKey(gridKey);
            MetaGridRowCollection rowCollection = metaGrid.getRowCollection();
            for (MetaGridRow metaGridRow : rowCollection) {
                for (MetaGridCell metaGridCell : metaGridRow) {
                    if (ControlType.DICT == metaGridCell.getCellType() || ControlType.DYNAMICDICT == metaGridCell.getCellType()) {
                        String caption = metaGridCell.getCaption();
                        caption = RegExUtils.replaceAll(caption, ",", "，");
                        caption = RegExUtils.replaceAll(caption, "\\s*", "");
                        str.append(metaGridCell.getKey()).append(",").append(caption).append(";");
                    }
                }
            }
        }
        return StringUtils.isBlank(str) ? str.toString() : str.substring(0, str.length() - 1);
    }

    public String getRadioGourpKey() throws Throwable {
        StringBuilder str = new StringBuilder(256);
        StringBuilder columnStr;
        RichDocumentContext midContext = getMidContext();
        String para = (String) midContext.getDefaultContext().getPara("OwnerFormKey");//获得表单key
        MetaForm metaForm = getMidContext().getMetaFactory().getMetaForm(para);
        IDLookup idLookup = IDLookup.getIDLookup(metaForm);
        List<MetaComponent> allComponent = idLookup.getAllComponent();
        for (MetaComponent metaComponent : allComponent) {
            if (metaComponent instanceof MetaRadioButton) {
                if (((MetaRadioButton) metaComponent).isGroupHead()) {
                    String key = ((MetaRadioButton) metaComponent).getGroupKey();
                    columnStr = new StringBuilder().append(";").append(key).append(",").append(key);
                    str = str.append(columnStr);
                }
            }
        }
        return str.toString();
    }

    public String getAllGridCellKey() throws Throwable {
        StringBuilder str = new StringBuilder(256).append(",");
        StringBuilder columnStr;
        RichDocumentContext midContext = getMidContext();
        String para = (String) midContext.getDefaultContext().getPara("OwnerFormKey");//获得表单key
        MetaForm metaForm = getMidContext().getMetaFactory().getMetaForm(para);
        List<MetaGridCell> metaGridCells = metaForm.getAllGridCells();
        for (MetaGridCell metaGridCell : metaGridCells) {
            if (!"删除".equals(metaGridCell.getCaption()) && !"选择".equals(metaGridCell.getCaption())) {
                String key = metaGridCell.getKey();
                columnStr = new StringBuilder().append(";").append(key).append(",").append(key);
                str = str.append(columnStr);
            }
        }
        return str.toString();
    }

    public String getRowGroupGridCellKey() throws Throwable {
        StringBuilder str = new StringBuilder(256).append(",");
        StringBuilder columnStr;
        RichDocumentContext midContext = getMidContext();
        String para = (String) midContext.getDefaultContext().getPara("OwnerFormKey");//获得表单key
        MetaForm metaForm = getMidContext().getMetaFactory().getMetaForm(para);
        List<MetaGridCell> metaGridCells = metaForm.getAllGridCells();
        for (MetaGridCell metaGridCell : metaGridCells) {
            if (!"删除".equals(metaGridCell.getCaption()) && !"选择".equals(metaGridCell.getCaption()) && metaGridCell.getCellGroupType() == GroupType.RowGroup) {
                String key = metaGridCell.getKey();
                columnStr = new StringBuilder().append(";").append(key).append(",").append(key);
                str = str.append(columnStr);
            }
        }
        return str.toString();
    }

    public String getTreeGridCell() throws Throwable {
        StringBuilder str = new StringBuilder(256).append(",");
        StringBuilder columnStr;
        RichDocumentContext midContext = getMidContext();
        String para = (String) midContext.getDefaultContext().getPara("OwnerFormKey");//获得表单key
        String selectComKey = (String) midContext.getDefaultContext().getPara("parentKey");//获得表单key
        String rowKey = (String) midContext.getDefaultContext().getPara("compKey");//获得表单key
        MetaForm metaForm = getMidContext().getMetaFactory().getMetaForm(para);
        MetaGrid metaGrid = (MetaGrid) metaForm.componentByKey(selectComKey);
        MetaGridRow metaGridRow = null;
        for (MetaGridRow metaGridCells : metaGrid.getRowCollection()) {
            if (metaGridCells.getKey().equalsIgnoreCase(rowKey)){
                    metaGridRow = metaGridCells;
                    break;
                }
            }
        for (MetaGridCell metaGridCell : metaGridRow) {
            if (!"删除".equals(metaGridCell.getCaption())) {
                String key = metaGridCell.getKey();
                columnStr = new StringBuilder().append(";").append(key).append(",").append(key);
                str = str.append(columnStr);
            }
        }
        return str.toString();
    }

    public String getColumns() throws Throwable {
        StringBuilder str = new StringBuilder(256).append("无,无");
        StringBuilder columnStr;
        RichDocumentContext midContext = getMidContext();
        String para = (String) midContext.getDefaultContext().getPara("OwnerFormKey");//获得表单key
        String selectComKey = (String) midContext.getDefaultContext().getPara("parentKey");//获得表单key
        String rowKey = (String) midContext.getDefaultContext().getPara("compKey");//获得表单key

        MetaForm metaForm = getMidContext().getMetaFactory().getMetaForm(para);
        MetaGrid metaGrid = (MetaGrid) metaForm.componentByKey(selectComKey);
        MetaGridRow metaGridRow = null;
        for (MetaGridRow metaGridCells : metaGrid.getRowCollection()) {
            if (metaGridCells.getKey().equalsIgnoreCase(rowKey)){
                metaGridRow = metaGridCells;
                break;
            }
        }
        String tableKey = metaGridRow.getTableKey();
        if (StringUtils.isBlank(tableKey)) {
            return str.toString();
        } else {
            MetaTable table = metaForm.getDataSource().getDataObject().getTable(tableKey);
            if (Objects.isNull(table)) {
                return str.toString();
            }
            DataTable dataTable = WebDesignerDataTableUtil.generateDataTable(table);
            DataTableMetaData dataTableMetaData = dataTable.getMetaData();
            for (int i = 0, len = dataTableMetaData.getColumnCount(); i < len; i++) {
                ColumnInfo columnInfo = dataTableMetaData.getColumnInfo(i);
                String columnKey = columnInfo.getColumnKey();
                if ("MapCount".equals(columnKey) || "SelectField".equals(columnKey)) {
                    continue;
                }
                MetaColumn metaColumn = table.get(columnKey);
                if (metaColumn != null) {
                    String caption = metaColumn.getCaption();
                    caption = RegExUtils.replaceAll(caption, ",", "，");
                    caption = RegExUtils.replaceAll(caption, "\\s*", "");
                    columnStr = new StringBuilder().append(";").append(columnKey).append(",").append(columnKey).append(" ").append(caption);
                    str = str.append(columnStr);
                }
            }
            return str.toString();
        }
    }

    /**
     * 动态字典头表标识获取方法
     */
    public String getDynamicDictItemKey(String key) throws Throwable {
        StringBuilder str = new StringBuilder(256).append(", ");
        StringBuilder columnStr;
        RichDocumentContext midContext = getMidContext();
        String para = (String) midContext.getDefaultContext().getPara("OwnerFormKey");//获得表单key

        MetaForm metaForm = getMidContext().getMetaFactory().getMetaForm(para);
        IDLookup idLookup = IDLookup.getIDLookup(metaForm);
        Collection<String> fieldKeys = idLookup.getFieldKeys();//所有字段key
        MetaGridRow gridCells = null;
        if (StringUtils.isNotEmpty(key)) {
            for (MetaGrid metaGrid : idLookup.getMetaGrids()) {
                MetaGridCell gridCellByKey = idLookup.getGridCellByKey(key);
                for (int i = 0; i < metaGrid.getRowCollection().size(); i++) {
                    if (metaGrid.getRowCollection().get(i).indexOf(gridCellByKey) != -1) {
                        gridCells = metaGrid.getRowCollection().get(i);
                        break;
                    }
                }
            }
        }

        if (gridCells != null) {
            for (MetaGridCell gridCell : gridCells) {
                String caption = gridCell.getCaption();
                if ((StringUtils.isNotEmpty(gridCell.getColumnKey()) && gridCell.getColumnKey().endsWith("ItemKey")) || gridCell.getKey().endsWith("ItemKey")){
                    caption = RegExUtils.replaceAll(caption, ",", "，");
                    caption = RegExUtils.replaceAll(caption, "\\s*", "");
                    columnStr = new StringBuilder().append(";").append(gridCell.getKey()).append(",").append(gridCell.getKey()).append(" ").append(caption);
                    str = str.append(columnStr);
                }
            }
        }


        Object gridKey = midContext.getDefaultContext().getPara("GridKey");
        Object parentCompKey = midContext.getDefaultContext().getPara("ParentCompKey");
        if (StringUtils.isNotEmpty((CharSequence) gridKey)  && StringUtils.isEmpty((CharSequence) parentCompKey)){
            MetaGrid metaGrid = (MetaGrid) metaForm.componentByKey((String) gridKey);
            for (int i = 0; i < metaGrid.getRowCollection().size(); i++) {
                MetaGridRow metaGridRow = metaGrid.getRowCollection().get(i);
                if (metaGridRow.getRowType() == RowType.Detail){
                    for (MetaGridCell metaGridCell : metaGridRow) {
                        String caption = metaGridCell.getCaption();
                        if ((StringUtils.isNotEmpty(metaGridCell.getColumnKey()) && metaGridCell.getColumnKey().endsWith("ItemKey")) || metaGridCell.getKey().endsWith("ItemKey")){
                            caption = RegExUtils.replaceAll(caption, ",", "，");
                            caption = RegExUtils.replaceAll(caption, "\\s*", "");
                            columnStr = new StringBuilder().append(";").append(metaGridCell.getKey()).append(",").append(metaGridCell.getKey()).append(" ").append(caption);
                            str = str.append(columnStr);
                        }
                    }
                }
            }
        }
        for (String fieldKey : fieldKeys) {
            MetaComponent componentByKey = idLookup.getComponentByKey(fieldKey);
            if (Objects.isNull(componentByKey)) {
                continue;
            }
            if ((StringUtils.isNotEmpty(componentByKey.getColumnKey()) && componentByKey.getColumnKey().endsWith("ItemKey")) || componentByKey.getKey().endsWith("ItemKey")){
                if (componentByKey.getControlType() == ControlType.DICT
                        || componentByKey.getControlType() == ControlType.COMBOBOX
                        || componentByKey.getControlType() == ControlType.CHECKBOX
                        || componentByKey.getControlType() == ControlType.RADIOBUTTON
                        || componentByKey.getControlType() == ControlType.TEXTEDITOR) {
                    String columnKeyByFieldKey = idLookup.getFieldCaption(fieldKey);
                    columnStr = new StringBuilder().append(";").append(fieldKey).append(",").append(fieldKey).append(" ").append(columnKeyByFieldKey);
                    str = str.append(columnStr);
                }
            }
            //	}
        }
        return str.toString();

    }


    public Boolean setEnable(String compKey, String cellType) throws Throwable {
        String para = (String) getMidContext().getDefaultContext().getPara("OwnerFormKey");
        IMetaFactory globalInstance = getMidContext().getMetaFactory();
        MetaFormProfile metaFormProfile = globalInstance.getMetaFormList().get(para);
        MetaForm metaForm = globalInstance.getMetaForm(para);
        Boolean isMerge = metaFormProfile.getMergeToSource();
        if (StringUtils.isNotEmpty(metaForm.getExtend())) {
            if (isMerge) {
                MetaForm extendMetaForm = globalInstance.getMetaForm(metaForm.getExtend());
                String filePath = LoadFileTree.getPathByFormKey(extendMetaForm.getKey());
                XmlTreeWithPath xmlTree = XmlTreeWithPath.parseFilePath(filePath);
                TagNode tagNode = xmlTree.xmlTree.getTagNode(cellType + "@" + compKey);
                if (tagNode != null) {
                    return false;
                } else {
                    return true;
                }
            } else {
                return false;
            }
        }
        return true;
    }


    //面板布局设置行数改变同步改变明细行条数
    public void returnRowGap() throws Throwable {
        RichDocument doc = getMidContext().getRichDocument();
        DataTable table = doc.getDataTable(ConstantUtil.ED_ROW_HEAD);
        DataTable Dtable = doc.getDataTable(ConstantUtil.ED_ROW_DETAIL);
        int Num = table.getInt(0, "RowNum");
        int size = Dtable.size();
        if (Num < Dtable.size()) {
            for (int i = 0; i < (size - Num); i++) {
                Dtable.delete(size - i - 1);
                doc.addDirtyTableFlag(ConstantUtil.ED_ROW_DETAIL);

            }
        } else {
            for (int i = 0; i < Num; i++) {
                if (i >= Dtable.size()) {//如填入行数大于已有行数则新增缺少的行数
                    int newRowIndex = Dtable.insert(i);
                    Dtable.setString(newRowIndex, "RowDefHeight", "30");
                    Dtable.setString(newRowIndex, "Type", "0");
                    Dtable.setNumeric(newRowIndex, "RowNum", BigDecimal.valueOf(1));
                    Dtable.setNumeric(newRowIndex, "SumNum", BigDecimal.valueOf(i + 1));
                    doc.addDirtyTableFlag(ConstantUtil.ED_ROW_DETAIL);
                }
            }
        }
    }


    //面板布局设置列数改变同步改变明细行条数
    public void returnColumnGap() throws Throwable {
        RichDocument doc = getMidContext().getRichDocument();
        DataTable table = doc.getDataTable(ConstantUtil.ED_COLUMN_HEAD);
        DataTable Dtable = doc.getDataTable(ConstantUtil.ED_COLUMN_DETAIL);
        int Num = table.getInt(0, "ColumnNum");
        int size = Dtable.size();
        if (Num < Dtable.size()) {
            for (int i = 0; i < (size - Num); i++) {//如填入行数小于已有行数则删除多余行数
                Dtable.delete(size - i - 1);
                doc.addDirtyTableFlag(ConstantUtil.ED_COLUMN_DETAIL);
            }
        } else {
            for (int i = 0; i < Num; i++) {
                if (i >= Dtable.size()) {//如填入行数大于已有行数则新增缺少的行数
                    int newRowIndex = Dtable.insert(i);
                    Dtable.setString(newRowIndex, "Width", "80");
                    Dtable.setString(newRowIndex, "Type", "0");
                    Dtable.setNumeric(newRowIndex, "RowNum", BigDecimal.valueOf(1));
                    Dtable.setNumeric(newRowIndex, "SumNum", BigDecimal.valueOf(i + 1));
                    doc.addDirtyTableFlag(ConstantUtil.ED_COLUMN_DETAIL);
                }
            }
        }
    }

    /**
     * create time: 2020/10/29 9:01
     * Affect :用于动态获取镜像字段的关联单元格标识
     *
     * @return
     * @Param: null
     */
    public String setBindingCellKey() throws Throwable {
        String fieldKey = (String) getMidContext().getDefaultContext().getPara(ConstantUtil.COMP_KEY);
        return setBindingCellKey(fieldKey);
    }

    public String setBindingCellKey(String fieldKey) throws Throwable {
        StringBuilder str = new StringBuilder(256).append(",").append("无关联表");
        StringBuilder columnStr;
        String currentFormKey = IOMetaObject.currentFormKey;
        String para = (String) getMidContext().getDefaultContext().getPara("OwnerFormKey");
        String containerKey = (String) getMidContext().getDefaultContext().getPara("ContainerKey");
        MetaForm metaForm = getMidContext().getMetaFactory().getMetaForm(para);
        IDLookup idLoopup = IDLookup.getIDLookup(metaForm);
        MetaComponent metaComponent = null;
        if (idLoopup.containFieldKey(fieldKey)) {
            metaComponent = idLoopup.getComponentByKey(fieldKey);
        } else if (Objects.isNull(metaComponent)) {
            if (containerKey != null) {
                String OtherKey = containerKey;
                metaForm = getMidContext().getMetaFactory().getMetaForm(OtherKey);
                idLoopup = IDLookup.getIDLookup(metaForm);
                metaComponent = idLoopup.getComponentByKey(fieldKey);
            }
        }
        String parentGridKeyLU = IOMetaObject.FindSubDetail(metaForm, metaComponent);
        MetaGrid metaGrid = idLoopup.getMetaGridByGridKey(parentGridKeyLU);
        if (StringUtils.isNotEmpty(currentFormKey) && !currentFormKey.equalsIgnoreCase(para)) { //嵌入表单中组件
            MetaForm parenMetaForm = getMidContext().getMetaFactory().getMetaForm(currentFormKey);
            IDLookup parenLookup = IDLookup.getIDLookup(parenMetaForm);
            MetaGrid metaGridByGridKey = parenLookup.getMetaGridByGridKey(parentGridKeyLU);
            if (Objects.isNull(metaGridByGridKey)) {
                List<MetaEmbed> embeds = parenMetaForm.getEmbeds();
                for (MetaEmbed embed : embeds) {
                    String formKey = embed.getFormKey();
                    MetaForm metaForm1 = getMidContext().getMetaFactory().getMetaForm(formKey);
                    IDLookup embedLookup = IDLookup.getIDLookup(metaForm1);
                    MetaGrid metaGridByGridKey1 = embedLookup.getMetaGridByGridKey(parentGridKeyLU);
                    if (metaGridByGridKey1 != null) {
                        metaGrid = metaGridByGridKey1;
                        break;
                    }
                }
            } else {
                metaGrid = metaGridByGridKey;
            }
        }
        //防止表单中没有Grid出现错误（字典。。。。等）
        if (metaGrid != null) {
            MetaGridColumnCollection columnCollection = metaGrid.getColumnCollection();
            for (int j = 0; j < columnCollection.size(); j++) {
                String key1 = columnCollection.get(j).getKey();
                String caption = columnCollection.get(j).getCaption();
                caption = RegExUtils.replaceAll(caption, ",", "，");
                caption = RegExUtils.replaceAll(caption, "\\s*", "");
                columnStr = new StringBuilder().append(";").append(key1).append(",").append(key1).append(" ").append(caption);
                str.append(columnStr);
            }
        }
        MetaTableRow metaTableRow = idLoopup.getMetaTableDetailRowByRowKey(parentGridKeyLU);
        if (metaTableRow != null) {
            ArrayList<MetaComponent> compListInRow = new ArrayList<>();
            addCompToList(metaTableRow.getRoot(), compListInRow);
            for(MetaComponent comp : compListInRow) {
                if(!comp.isPanel()){
                    String key1 = comp.getKey();
                    String caption = comp.getCaption();
                    caption = RegExUtils.replaceAll(caption, ",", "，");
                    caption = RegExUtils.replaceAll(caption, "\\s*", "");
                    columnStr = new StringBuilder().append(";").append(key1).append(",").append(key1).append(" ").append(caption);
                    str.append(columnStr);
                }
            }
        }
        return str.toString();
    }

    private void addCompToList(MetaComponent metaComponent, ArrayList<MetaComponent> list) {
        list.add(metaComponent);
        if(metaComponent.isPanel() && metaComponent.getComponentCount() > 0){
            for (int i = 0; i < metaComponent.getComponentCount(); i++) {
                MetaComponent subComp = metaComponent.getComponent(i);
                addCompToList(subComp, list);
            }
        }
    }

    /**
     * create by: dilireba
     * description: TODO
     * create time: 2020/10/16 11:28
     * Affect :宏公式新增添加默认值
     *
     * @return
     * @Param: null
     */
    public void setMacro() throws Throwable {
        int b = 0;
        RichDocument document = getMidContext().getRichDocument();
        DataTable dataTable = document.getDataTable(ConstantUtil.TBL_MACRO_FORMULA);
        dataTable.append();
        for (int i = 0; i < dataTable.size(); i++) {
            String keyDetail = dataTable.getString(i, "Key");
            if (null != keyDetail && keyDetail.indexOf("MacroKey") != -1) {
                b++;
                dataTable.setString("Key", "MacroKey" + b);
            } else if (null == keyDetail) {
                dataTable.setString("Key", "MacroKey" + (b + 1));
            } else {
                dataTable.setString("Key", "MacroKey" + b);
            }
        }
        document.addDirtyTableFlag(ConstantUtil.ED_NEW_MACRO_DETAIL);
    }

    public Boolean isHaveDataSource() throws Throwable {
        RichDocumentContext midContext = getMidContext();
        String para = (String) midContext.getDefaultContext().getPara("OwnerFormKey");
        String gridKey = (String) midContext.getDefaultContext().getPara("GridKey");
        MetaForm form = getMidContext().getMetaFactory().getMetaForm(para);
        IDLookup idLookup = IDLookup.getIDLookup(form);
        MetaGrid parentGrid = idLookup.getMetaGridByGridKey(gridKey);
        if (StringUtils.isNotEmpty(parentGrid.getTableKey()) && !parentGrid.getTableKey().contains("_NODB")) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * create time: 2020/10/26 15:57
     * Affect :固定值默认值方法
     *
     * @return
     * @Param: null
     */
    public void setSelect() throws Throwable {
        int b = 0;
        RichDocument document = getMidContext().getRichDocument();
        DataTable dataTable = document.getDataTable(ConstantUtil.ED_COMBO_BOX_DETAIL);
        dataTable.append();
        for (int i = 0; i < dataTable.size(); i++) {
            String key = dataTable.getString(i, ConstantUtil.KEY);
            if (null != key && key.indexOf("Line") != -1) {
                b++;
                dataTable.setString(ConstantUtil.KEY, "Line" + b);
            } else if (null == key) {
                dataTable.setString(ConstantUtil.KEY, "Line" + (b + 1));
            } else {
                dataTable.setString(ConstantUtil.KEY, "Line" + b);
            }
        }
        document.addDirtyTableFlag(ConstantUtil.ED_COMBO_BOX_DETAIL);
    }

    public void setDictViewColumn() throws Throwable {
        int b = 0;
        RichDocument document = getMidContext().getRichDocument();
        DataTable dataTable = document.getDataTable(ConstantUtil.TBL_DICT_VIEW_COLUMN);
        dataTable.append();
        for (int i = 0; i < dataTable.size(); i++) {
            String key = dataTable.getString(i, ConstantUtil.KEY);
            if (null != key && key.indexOf("Line") != -1) {
                b++;
                dataTable.setString(ConstantUtil.KEY, "Line" + b);
            } else if (null == key) {
                dataTable.setString(ConstantUtil.KEY, "Line" + (b + 1));
            } else {
                dataTable.setString(ConstantUtil.KEY, "Line" + b);
            }
        }
        document.addDirtyTableFlag(ConstantUtil.TBL_DICT_VIEW_COLUMN);
    }


    /**
     * 设定行默认值
     */
    public void setRow(String rowType) throws Throwable {
        String controlType = RowType.toString(Integer.parseInt(rowType));
        RichDocumentContext midContext = getMidContext();
        RichDocument document = midContext.getRichDocument();
        String para = (String) midContext.getDefaultContext().getPara("OwnerFormKey");
        MetaForm metaForm = getMidContext().getMetaFactory().getMetaForm(para);
//        List<MetaGridCell> allGridCells = metaForm.getAllGridCells();
        IDLookup loopUp = IDLookup.getIDLookup(metaForm);
        DataTable dataTable = document.getDataTable(ConstantUtil.TBL_NEW_ROW);

        List<MetaGrid> metaGridList = loopUp.getMetaGrids();
        Map<Integer, String> map = new HashMap<Integer, String>();
        int b = 0;
        for (int i = 0; i < dataTable.size(); i++) {
            for (MetaGrid grid : metaGridList) {
                MetaGridRowCollection metaGridRows = grid.getRowCollection();
                for (MetaGridRow metaGridRow : metaGridRows) {
                    String key = metaGridRow.getKey();
                    if (key.indexOf(controlType) != -1) {
                        i++;
                    }
                    b++;
                    map.put(b, key);
                }
            }
            if (map.containsValue(controlType + i)) {
                dataTable.setString(ConstantUtil.KEY, controlType + (i + 1));
                dataTable.setString(ConstantUtil.CAPTION, controlType + (i + 1));
            } else {
                dataTable.setString(ConstantUtil.KEY, controlType + i);
                dataTable.setString(ConstantUtil.CAPTION, controlType + i);
                document.addDirtyTableFlag(ConstantUtil.TBL_NEW_ROW);
            }
        }
    }

    /**
     * create time: 2020/10/28 14:21
     * Affect :用于控制属性的可见性，因为头部和subdetail共用同一组件，防止冲突
     *
     * @return
     * @Param: null
     */
    public Boolean setEnable() throws Throwable {
        String para = (String) getMidContext().getDefaultContext().getPara("OwnerFormKey");
        String containerKey = (String) getMidContext().getDefaultContext().getPara("ContainerKey");
        MetaForm metaForm = getMidContext().getMetaFactory().getMetaForm(para);
        IDLookup idLoopup = IDLookup.getIDLookup(metaForm);
        String fieldKey = (String) getMidContext().getDefaultContext().getPara(ConstantUtil.COMP_KEY);
        MetaComponent metaComponent = null;
        if (idLoopup.containFieldKey(fieldKey)) {
            metaComponent = idLoopup.getComponentByKey(fieldKey);
        } else if (Objects.isNull(metaComponent)) {
            if (StringUtils.isNotBlank(containerKey)) {
                metaForm = getMidContext().getMetaFactory().getMetaForm(containerKey);
                idLoopup = IDLookup.getIDLookup(metaForm);
                metaComponent = idLoopup.getComponentByKey(fieldKey);
            }
        }
        String parentGridKeyLU = IOMetaObject.FindSubDetail(metaForm, metaComponent);
        if (!"".equals(parentGridKeyLU)) {

            return true;
        }
        return false;
    }

    /**
     * Affect :用于控制属性的可见性
     *
     * @return
     * @Param: null
     */
    public Boolean setVestEnable() throws Throwable {
        String para = (String) getMidContext().getDefaultContext().getPara("OwnerFormKey");
        MetaForm metaForm = getMidContext().getMetaFactory().getMetaForm(para);
        if (StringUtils.isBlank(metaForm.getExtend())) {
            return false;
        }
        return true;
    }


    /**
     * 判断是都含有马甲
     *
     * @param
     * @throws Throwable
     */
    public boolean isExtend() throws Throwable {
        String formKey = (String) getMidContext().getDefaultContext().getPara("OwnerFormKey");
        MetaForm form1 = null;
        MetaFormProfile metaFormProfile = getMidContext().getMetaFactory().getMetaFormList().get(formKey);
        if (metaFormProfile != null) {
            form1 = getMidContext().getMetaFactory().getMetaFormList().get(formKey).getForm();
        }
        String ref = "";
        if (form1 != null && form1.getDataSource() != null) {
            ref = form1.getDataSource().getRefObjectKey();
        }
        AtomicInteger atomicInteger = new AtomicInteger(0);
        final String refFinal = ref;
        getMidContext().getMetaFactory().getMetaFormList().forEach(form -> {
            if (formKey.equals(form.getExtend())) {
                atomicInteger.set(1);
                return;
            }
            if (formKey.equals(form.getExtend())) {
                MetaForm form2 = form.getForm();
                if (form2 != null && form2.getDataSource() != null) {
                    if (StringUtils.isNotEmpty(refFinal)) {
                        if (form2.getDataSource().getDataObject().getKey().equals(refFinal)) {
                            atomicInteger.set(2);
                            return;
                        }

                    }
                }
            }
        });
        if (atomicInteger.get() == 0) {
            return false;
        } else {
            return true;
        }
    }


    /**
     * Affect :用于控制属性的可见性
     *
     * @return
     * @Param: null
     */
    public Boolean setTypeEnable() throws Throwable {
        String para = (String) getMidContext().getDefaultContext().getPara("OwnerFormKey");
        if (StringUtils.isBlank(para)) {
            return true;
        }
        IMetaFactory globalInstance = getMidContext().getMetaFactory();
        MetaDataObject metaDataObject = globalInstance.getDataObject(para);
        if (Objects.isNull(metaDataObject)) {
            MetaForm metaForm = globalInstance.getMetaForm(para);
            MetaDataSource dataSource = metaForm.getDataSource();
            if (dataSource != null) {
                metaDataObject = dataSource.getDataObject();
            } else {
                return false;
            }
        }
        if (metaDataObject.getSecondaryType() == DataObjectSecondaryType.MIGRATION) {
            return true;
        }
        return false;
    }

    /**
     * 父表标识下拉框(从页面中获取)
     *
     * @param tabKey
     * @param
     * @param
     * @return
     * @throws Throwable
     */
    public String parentTableKey(String tabKey) throws Throwable {
        String str = "0,无数据表";
        if (StringUtils.isEmpty(tabKey)) {
            return str;
        }
        String rowStr = "";
//        String parentKey = "";
        RichDocumentContext midContext = getMidContext();
        DefaultContext defaultContext = midContext.getDefaultContext();
        String para = (String) defaultContext.getPara("OwnerFormKey");
        String Type = (String) defaultContext.getPara(ConstantUtil.TYPE);
        String containerKey = (String) defaultContext.getPara("ContainerKey");
        MetaForm metaForm = null;
        MetaDataObject dataObject = null;
        MetaTableCollection tableCollection = null;
        if (ConstantUtil.DATA_OBJECT.equals(Type)) {
            dataObject = getMidContext().getMetaFactory().getDataObject(para);
            if (dataObject != null) {
                tableCollection = dataObject.getTableCollection();
            }
        } else {
            metaForm = getMidContext().getMetaFactory().getMetaForm(para);
            if (Objects.isNull(metaForm.getDataSource())) {
                if (containerKey != null) {
                    String OtherKey = containerKey;
                    metaForm = getMidContext().getMetaFactory().getMetaForm(OtherKey);
                }
            }
            MetaDataSource dataSource = metaForm.getDataSource();
            if (dataSource != null) {
                tableCollection = dataSource.getDataObject().getTableCollection();

            }
        }
        if (tableCollection != null) {
            MetaTable ownerMetaTable = tableCollection.get(tabKey);
            for (MetaTable metaTable : tableCollection) {
                String tableKey = metaTable.getKey();
                int tableMode = metaTable.getTableMode();
                if (tableKey.equals(tabKey)
                        || tableMode == TableMode.HEAD) {
                    continue;
                }
                if (tabKey.equalsIgnoreCase(metaTable.getParentKey())) {
                    continue;//防止设置环状父子表
                }
                String caption = metaTable.getCaption();
                caption = RegExUtils.replaceAll(caption, ",", "，");
                caption = RegExUtils.replaceAll(caption, "\\s*", "");
//                if (ownerMetaTable != null) {
//                    parentKey = ownerMetaTable.getParentKey();
//                } else {   //新增的table
//                    parentKey = "";
//                }
                rowStr = ";" + tableKey + "," + tableKey + " " + caption;
                str += rowStr;
            }

        }
        return str;
    }

    /**
     * 暂时用于检查修改小数位数
     */

    public boolean checkDataType(String tableKey, String columnKey) throws Throwable {
        if ("无数据表".equalsIgnoreCase(tableKey) || "无字段".equalsIgnoreCase(columnKey) || "".equalsIgnoreCase(columnKey)) {
            return true;
        } else {
            RichDocumentContext midContext = getMidContext();
            String para = (String) midContext.getDefaultContext().getPara("OwnerFormKey");
            String containerKey = (String) midContext.getDefaultContext().getPara("ContainerKey");
            MetaForm metaForm = getMidContext().getMetaFactory().getMetaForm(para);
            MetaDataSource dataSourse = metaForm.getDataSource();
            MetaTable table = null;
            if (dataSourse != null) {
                table = dataSourse.getDataObject().getTable(tableKey);
            } else if (containerKey != null && !containerKey.isEmpty()) {
                String OtherKey = containerKey;
                metaForm = getMidContext().getMetaFactory().getMetaForm(OtherKey);
                table = metaForm.getDataSource().getDataObject().getTable(tableKey);
            }
            if (Objects.isNull(table)) {
                return true;
            }
            MetaColumn metaColumn = table.get(columnKey);
            if (Objects.isNull(metaColumn)) {
                return true;
            }
            int dataType = metaColumn.getDataType();
            if (DataType.INT == dataType || DataType.LONG == dataType) {
                return false;
            } else {
                return true;
            }
        }
    }


    /**
     * 关联表标识下拉框
     *
     * @return
     * @throws Throwable
     */
    public String relatedTable(int type) throws Throwable {
        if (associatedTableMap != null) { //新增表了，清空重新算
            associatedTableMap.clear();
        }
        String str = "0,新增表;1,无数据表";
        String rowStr = "";
        RichDocumentContext midContext = getMidContext();
        DefaultContext defaultContext = midContext.getDefaultContext();
        String para = (String) defaultContext.getPara("OwnerFormKey");
        String containerKey = (String) defaultContext.getPara("ContainerKey");
        MetaForm containerForm = null;
        if (containerKey != null) {
            int keylong = containerKey.length();
            if (keylong > 0) {
                if (!containerKey.equals("null")) {
                    containerForm = getMidContext().getMetaFactory().getMetaForm(containerKey);
                }
            }
        }
        int i = 2;
        MetaForm metaForm = getMidContext().getMetaFactory().getMetaForm(para);
        if (Objects.isNull(metaForm.getDataSource())) {
            return str;
        }
        String refObjectKey = metaForm.getDataSource().getRefObjectKey();
        if (!refObjectKey.isEmpty()) {//区分引入数据对象的表单
            str = "1,无数据表";
        }
        MetaTableCollection tableCollection = null;
        if (Objects.isNull(metaForm.getDataSource())) {
            tableCollection = containerForm.getDataSource().getDataObject().getTableCollection();
        } else {
            tableCollection = metaForm.getDataSource().getDataObject().getTableCollection();
        }

        for (MetaTable metaTable : tableCollection) {
            String tableKey = metaTable.getKey();
            int tableMode = metaTable.getTableMode();
            if (type == 2) {
                if ((tableMode != TableMode.HEAD)) {
                    continue;
                }
            } else {
                if ((tableMode == TableMode.HEAD && type != 216)) {
                    continue;
                }
            }
            String caption = metaTable.getCaption();
            caption = RegExUtils.replaceAll(caption, ",", "，");
            caption = RegExUtils.replaceAll(caption, "\\s*", "");
            rowStr = ";" + i + "," + tableKey + " " + caption;
            str += rowStr;
            associatedTableMap.put(i, tableKey);
            i++;
        }
        associatedTableMap.put(0, "HeadGrade");
        associatedTableMap.put(1, "");
        return str;

    }

    /**
     * 条件关联表
     *
     * @return
     * @throws Throwable
     */
    public String condTableKey() throws Throwable {
        StringBuilder str = new StringBuilder(256);
        StringBuilder rowStr;
        RichDocumentContext midContext = getMidContext();
        String para = (String) midContext.getDefaultContext().getPara("OwnerFormKey");
        String containerKey = (String) midContext.getDefaultContext().getPara("ContainerKey");
        MetaForm metaForm = getMidContext().getMetaFactory().getMetaForm(para);
        if (Objects.isNull(metaForm.getDataSource())) {
            if (containerKey != null) {
                String OtherKey = containerKey;
                metaForm = getMidContext().getMetaFactory().getMetaForm(OtherKey);
            }
        }
        MetaTableCollection tableCollection = metaForm.getDataSource().getDataObject().getTableCollection();
        for (MetaTable metaTable : tableCollection) {
            String caption = metaTable.getCaption();
            caption = RegExUtils.replaceAll(caption, ",", "，");
            caption = RegExUtils.replaceAll(caption, "\\s*", "");
            rowStr =
                    new StringBuilder().append(";").append(metaTable.getKey()).append(",").append(metaTable.getKey()).append(" ").append(caption);
            str = str.append(rowStr);
        }
        return str.toString();
    }

    /**
     * 条件关联字段
     *
     * @return
     * @throws Throwable
     */
    public String condColumnKey(String tableKey) throws Throwable {
        StringBuilder str = new StringBuilder(256);
        StringBuilder columnStr;
        if (StringUtils.isNotEmpty(tableKey)) {
            RichDocumentContext midContext = getMidContext();
            String para = (String) midContext.getDefaultContext().getPara("OwnerFormKey");
            String containerKey = (String) midContext.getDefaultContext().getPara("ContainerKey");
            MetaForm metaForm = getMidContext().getMetaFactory().getMetaForm(para);
            if (Objects.isNull(metaForm.getDataSource())) {
                if (containerKey != null) {
                    String OtherKey = containerKey;
                    metaForm = getMidContext().getMetaFactory().getMetaForm(OtherKey);
                }
            }
            MetaTable table = metaForm.getDataSource().getDataObject().getTable(tableKey);
            if (table != null) {
                DataTable dataTable = WebDesignerDataTableUtil.generateDataTable(table);
                DataTableMetaData dataTableMetaData = dataTable.getMetaData();
                for (int i = 0, len = dataTableMetaData.getColumnCount(); i < len; i++) {
                    ColumnInfo columnInfo = dataTableMetaData.getColumnInfo(i);
                    String columnKey = columnInfo.getColumnKey();
                    if (columnKey.equals("MapCount") || columnKey.equals("SelectField")) {
                        continue;
                    }
                    columnStr = new StringBuilder().append(";").append(columnKey).append(",").append(columnKey);
                    str = str.append(columnStr);
                }
            }
            return str.toString();
        } else {
            return str.toString();
        }

    }

    /**
     * 关联表格的key下拉框
     *
     * @return
     * @throws Throwable
     */
    public String getGridKey() throws Throwable {
        String str = "";
        RichDocumentContext midContext = getMidContext();
        DefaultContext defaultContext = midContext.getDefaultContext();
        String para = (String) defaultContext.getPara("OwnerFormKey");
        MetaForm metaForm = getMidContext().getMetaFactory().getMetaForm(para);
        IDLookup idLoopup = IDLookup.reloadIDLookup(metaForm);
        List<MetaGrid> metaGrids = idLoopup.getMetaGrids();
        List<MetaTableRow> metaDetailTableRows = idLoopup.getMetaDetailTableRows();
        if (StringUtils.isNotEmpty(IOMetaObject.currentFormKey) && !para.equalsIgnoreCase(IOMetaObject.currentFormKey)
                && !IOMetaObject.currentFormKey.equalsIgnoreCase("MobileFormDesigner")) { //嵌入表单中组件
            MetaForm parenMetaForm = getMidContext().getMetaFactory().getMetaForm(IOMetaObject.currentFormKey);
            IDLookup parenLookup = IDLookup.reloadIDLookup(parenMetaForm);
            List<MetaGrid> metaGrids1 = parenLookup.getMetaGrids();
            if (metaGrids1 != null && !metaGrids1.isEmpty()) {
                for (MetaGrid metaGrid : metaGrids1) {
                    String key = metaGrid.getKey();
                    String caption = metaGrid.getCaption();
                    caption = RegExUtils.replaceAll(caption, ",", "，");
                    caption = RegExUtils.replaceAll(caption, "\\s*", "");
                    if (StringUtils.isEmpty(caption)) {
                        caption = key;
                    }
                    str = str + key + "," + caption + ";";
                }
            }
            List<MetaTableRow> metaDetailTableRows1 = parenLookup.getMetaDetailTableRows();
            if (metaDetailTableRows1 != null && !metaDetailTableRows1.isEmpty()) {
                for (MetaTableRow metaTableRow : metaDetailTableRows1) {
                    String key = metaTableRow.getKey();
                    String caption = metaTableRow.getCaption();
                    caption = RegExUtils.replaceAll(caption, ",", "，");
                    caption = RegExUtils.replaceAll(caption, "\\s*", "");
                    if (StringUtils.isEmpty(caption)) {
                        caption = key;
                    }
                    str = str + key + "," + caption + ";";
                }
            }
        } else {
//            if (CollectionUtils.isEmpty(metaGrids) && CollectionUtils.isEmpty(metaDetailTableRows)) { //当把页面上表格全删光，再点击新增组件弹框(subdetail依赖于表格)
//                return str;
//            }
            if(metaGrids != null && !metaGrids.isEmpty()) {
                for (MetaGrid metaGrid : metaGrids) {
                    String key = metaGrid.getKey();
                    String caption = metaGrid.getCaption();
                    caption = RegExUtils.replaceAll(caption, ",", "，");
                    caption = RegExUtils.replaceAll(caption, "\\s*", "");
                    if (StringUtils.isEmpty(caption)) {
                        caption = key;
                    }
                    str = str + key + "," + caption + ";";
                }
            }

            if (metaDetailTableRows != null && !metaDetailTableRows.isEmpty()) {
                for (MetaTableRow metaTableRow : metaDetailTableRows) {
                    String key = metaTableRow.getKey();
                    String caption = metaTableRow.getCaption();
                    caption = RegExUtils.replaceAll(caption, ",", "，");
                    caption = RegExUtils.replaceAll(caption, "\\s*", "");
                    if (StringUtils.isEmpty(caption)) {
                        caption = key;
                    }
                    str = str + key + "," + caption + ";";
                }
            }
        }
        if (StringUtils.isEmpty(str)) {
            return str;
        } else {
            return str.substring(0, str.length() - 1);
        }

    }

    //宏公式

    public void selectMacro() throws Throwable {
        RichDocumentContext midContext = getMidContext();
        String para = (String) midContext.getDefaultContext().getPara("OwnerFormKey");//获得表单key
        RichDocument document = getMidContext().getRichDocument();
        DataTable dataTable = document.getDataTable(ConstantUtil.ED_NEW_MACRO_DETAIL);//获得当前表单
        DataTable dataTableHead = document.getDataTable(ConstantUtil.ED_NEW_MACRO_HEAD);//获得当前表单
        String inputMacroKey = dataTableHead.getString(0, ConstantUtil.KEY);
        if (StringUtils.isBlank(inputMacroKey)) {
            inputMacroKey = "";
        }
        String formKey = dataTableHead.getString(0, "FormKey");
        if (StringUtils.isNotEmpty(formKey)) {
            para = formKey;
        }
        MetaForm ownerMetaForm = getMidContext().getMetaFactory().getMetaForm(para);
        String condition = dataTableHead.getString(0, "Condition");
        String projectKey = dataTableHead.getString(0, "ProjectKey");
        dataTableHead.clear();
        int row1 = dataTableHead.append();
        if (StringUtils.isNotEmpty(formKey)) {
            dataTableHead.setString(row1, "FormKey", formKey);
        }
        if (StringUtils.isNotEmpty(condition)) {
            dataTableHead.setString(row1, "Condition", condition);
        }
        if (StringUtils.isNotEmpty(projectKey)) {
            dataTableHead.setString(row1, "ProjectKey", projectKey);
        }
        dataTable.clear();
        try {
            String prokey = ownerMetaForm.getProject().getKey();// 当前工程的Key
            if (StringUtils.isNotEmpty(projectKey)) {
                prokey = projectKey;
            }
            String solu =  FilePathHelper.getCoreSolutionPath();
            String path = solu + File.separator + prokey + File.separator + "CommonDef.xml";
            if (condition.equals("project")) {
            } else if ("erp".equals(condition)) {
                path = solu + File.separator + "CommonDef.xml";
            } else {
                path = LoadFileTree.getPathByFormKey(para);
            }
            selectMacroList(dataTable, path, inputMacroKey);
            if (dataTable.size() <= 0) {
                int append = dataTable.append();
                dataTable.setState(RowState.NORMAL);
                dataTable.setString(append, "Formula", "未查询到结果");
            }

            document.addDirtyTableFlag(ConstantUtil.ED_NEW_MACRO_DETAIL);
        } catch (Throwable throwable) {
            LogSvr.getInstance().error(throwable.getMessage(), throwable);
        }
    }

    public static void selectMacroList(DataTable dataTable, String path, String inputMacroKey) throws Throwable {
        XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(path);
        TagNode node = xmlTreeWithPath.xmlTree.getRoot().getOrCreateChildByTagName(MetaMacroCollection.TAG_NAME);
        List<AbstractNode> macroCollection = node.getChildren();
        for (int i = 0; i < macroCollection.size(); i++) {
            AbstractNode tagNode = macroCollection.get(i);
            if (tagNode instanceof TagNode && ((TagNode) tagNode).getTagName().equalsIgnoreCase("macro")) {
                String key = ((TagNode) tagNode).getAttributes().get(ConstantUtil.KEY);
                if (key.contains(inputMacroKey)) {
                    String args = ((TagNode) tagNode).getAttributes().get("Args");
                    int row = dataTable.append();
                    dataTable.setState(RowState.NORMAL);
                    dataTable.setString(row, "Key", key);
                    dataTable.setString(row, "Args", args);
                    String a1 = "";
                    for (AbstractNode child : ((TagNode) tagNode).getChildren()) {
                        if (child instanceof CDataNode) {
                            a1 = child.getText();
                            break;
                        }
                    }
                    dataTable.setString(row, "Formula", a1);
                }
            }
        }
    }

    public static void selectMacroList(DataTable dataTable, String path) throws Throwable {
        path = path.replace("\\\\", File.separator).replace('\\', File.separatorChar).replace('/', File.separatorChar);
        XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(path);
        TagNode node = xmlTreeWithPath.xmlTree.getRoot().getOrCreateChildByTagName(MetaMacroCollection.TAG_NAME);
        List<AbstractNode> macroCollection = node.getChildren();
        for (int i = 0; i < macroCollection.size(); i++) {
            AbstractNode tagNode = macroCollection.get(i);
            if (tagNode instanceof TagNode && ((TagNode) tagNode).getTagName().equalsIgnoreCase("macro")) {
                String key = ((TagNode) tagNode).getAttributes().get(ConstantUtil.KEY);
                String args = ((TagNode) tagNode).getAttributes().get("Args");
                int row = dataTable.append();
                dataTable.setState(RowState.NORMAL);
                dataTable.setString(row, "Key", key);
                dataTable.setString(row, "Args", args);
                String a1 = "";
                for (AbstractNode child : ((TagNode) tagNode).getChildren()) {
                    if (child instanceof CDataNode) {
                        a1 = child.getText();
                        break;
                    }
                }
                dataTable.setString(row, "Formula", a1);
            }
        }
    }
//数据映射

    /**
     * @return 返回获取的表单列表
     * @throws Throwable
     */
    public String LoadFormKey() throws Throwable {
        final String[] str = {""};
        final StringBuffer[] stringBuffer = new StringBuffer[1];
        MetaFormList metaFormList = getMidContext().getMetaFactory().getMetaFormList();
        for (MetaFormProfile metaForm : metaFormList) {
            if (metaForm.getForm()!=null && metaForm.getForm().getDataSource() != null
                    && metaForm.getForm().getDataSource().getDataObject() != null
                    && metaForm.getFormType() != FormType.View) {
                final String key = metaForm.getKey();
                String caption = metaForm.getCaption();
                caption = RegExUtils.replaceAll(caption, ",", "，");
                caption = RegExUtils.replaceAll(caption, "\\s*", "");
                stringBuffer[0] = new StringBuffer().append(key).append(",").append(key).append("  ").append(caption).append(";");
                str[0] += stringBuffer[0];
            }
        }
        //去除尾部分号
        String substring = str[0].substring(0, str[0].length() - 1);
        return substring;
    }

    /**
     * @return 返回获取的数据对象列表
     * @throws Throwable
     */
    public String loadDataObjectKeyByDataMigration() throws Throwable {
        final String[] str = {""};
        final StringBuffer[] stringBuffer = new StringBuffer[1];
        MetaDataObjectList dataObjectList = getMidContext().getMetaFactory().getDataObjectList();
        for (MetaDataObjectProfile dataObjec : dataObjectList) {
            if (dataObjec.getDataObject() != null && dataObjec.getDataObject().getSecondaryType() != DataObjectSecondaryType.MIGRATION) {
                final String key = dataObjec.getKey();
                String caption = dataObjec.getCaption();
                caption = RegExUtils.replaceAll(caption, ",", "，");
                caption = RegExUtils.replaceAll(caption, "\\s*", "");
                stringBuffer[0] = new StringBuffer().append(key).append(",").append(key).append("   ").append(caption).append(";");
                str[0] += (stringBuffer[0]);
            }
        }
        //去除尾部分号
        String substring = str[0].substring(0, str[0].length() - 1);
        return substring;
    }

    /**
     * 用于自动生成默认映射标识
     *
     * @param SourceFormKey 源FormKey
     * @param TargetFormKey 目标FormKey
     * @return
     */
    public StringBuffer setDefaultValue(String SourceFormKey, String TargetFormKey) {
        StringBuffer str = new StringBuffer();
        if (SourceFormKey != null && !"".equals(SourceFormKey)
                && TargetFormKey != null && !"".equals(TargetFormKey)) {
            String sourceFormKey = SourceFormKey.split(" ")[0];
            String targetFormKey = TargetFormKey.split(" ")[0];
            str.append(sourceFormKey).append("2").append(targetFormKey);
        } else {
            return null;
        }
        return str;
    }

    /**
     * 获取工程中的所有的数据对象表单
     *
     * @return
     */
    public String LoadDataObject() throws Throwable {
        final String[] str = {""};
        final StringBuffer[] stringBuffer = new StringBuffer[1];
        MetaDataObjectList dataObjectList = getMidContext().getMetaFactory().getDataObjectList();
        for (MetaDataObjectProfile dataObjec : dataObjectList) {
            //当类型是MIGRATION 迁移表的时候才是需要的表
            if (dataObjec.getDataObject() != null && dataObjec.getDataObject().getSecondaryType() == DataObjectSecondaryType.MIGRATION) {
                final String key = dataObjec.getKey();
                String caption = dataObjec.getCaption();
                caption = RegExUtils.replaceAll(caption, ",", "，");
                caption = RegExUtils.replaceAll(caption, "\\s*", "");
                stringBuffer[0] = new StringBuffer().append(key).append(",").append(key).append("   ").append(caption).append(";");
                str[0] += (stringBuffer[0]);
            }
        }
        //去除尾部分号
        String substring = str[0].substring(0, str[0].length() - 1);
        return substring;
    }

    /**
     * 用于自动生成默认数据迁移标识
     *
     * @param SourceDataObject 源数据对象
     * @param TargetDataObject 目标数据对象
     * @return
     */
    public StringBuffer setDataObjectKey(String SourceDataObject, String TargetDataObject) throws Throwable {
        StringBuffer str = new StringBuffer();
        if (SourceDataObject != null && !"".equals(SourceDataObject)
                && TargetDataObject != null && !"".equals(TargetDataObject)) {
            String sourceFormKey = SourceDataObject.split(" ")[0];
            String targetFormKey = TargetDataObject.split(" ")[0];
            str.append(sourceFormKey).append("2").append(targetFormKey);
            //获取所有的数据迁移标识，防止添加重复造成数据冲突
            MetaDataMigrationList dataMigrationList = getMidContext().getMetaFactory().getDataMigrationList();
            //当前创建的数据迁移标识是否已经存在，存在的话就进行一个提示
            boolean isExist = dataMigrationList.containsKey(str.toString());
            //已经存在就不自动生成标识
            if (isExist) {
                return str.append("_01");
            }
        } else {
            return null;
        }
        return str;
    }

    //马甲引入组件

    public String getVestAllComponent() throws Throwable {
        StringBuilder str = new StringBuilder(256);
        StringBuilder columnStr;
        RichDocumentContext midContext = getMidContext();
        String para = (String) midContext.getDefaultContext().getPara("OwnerFormKey");//获得表单key
        MetaForm metaForm = getMidContext().getMetaFactory().getMetaForm(para);
        HashMap<String, AbstractMetaObject> allUIComponents = metaForm.getAllUIComponents();
        String filePath = LoadFileTree.getPathByFormKey(getMidContext().getMetaFactory().getMetaForm(metaForm.getExtend()).getKey());
        XmlTree xmlTree1 = XmlTreeWithPath.parseFilePath(filePath).xmlTree;
        // 马甲XmlTree
        String erpXmlFilePath = LoadFileTree.getPathByFormKey(para);
        String tmpPath = XmlFileProcessor.instance.getTmpFile(erpXmlFilePath);
        String vestFilePath = StringUtils.isNotBlank(tmpPath) ? tmpPath : erpXmlFilePath;
        XmlTree vestXmlTree = Xml4jUtil.parseTree(vestFilePath);
        HashMap<String, AbstractNode> mapNodes = vestXmlTree.getMapNodes();
        Set<String> strings = mapNodes.keySet();
        Function<String, Boolean> f = key -> {
            for (String string : strings) {
                boolean b = StringUtils.endsWith(string, "@" + key);
                if (b) {
                    return true;
                }
            }
            return false;
        };
        boolean exist = false;
        for (HashMap.Entry<String, AbstractMetaObject> abstractMetaObjectMap : allUIComponents.entrySet()) {
            AbstractMetaObject allUIComponentsvalue = abstractMetaObjectMap.getValue();
            if (allUIComponentsvalue instanceof MetaGrid) {//表格组件
                MetaGridColumnCollection columnCollection = ((MetaGrid) allUIComponentsvalue).getColumnCollection();
                for (MetaGridColumn metaGridColumn : columnCollection) {
                    if ((Objects.nonNull(xmlTree1.getTagNode("GridColumn@" + metaGridColumn.getKey())))) {
                        String key = metaGridColumn.getKey();
                        String caption = metaGridColumn.getCaption();
                        caption = RegExUtils.replaceAll(caption, ",", "，");
                        caption = RegExUtils.replaceAll(caption, "\\s*", "");
                        MetaGridCell abstractMetaObject = (MetaGridCell) allUIComponents.get(key);
                        MetaGridColumn gridMetaColumnByKey = IDLookup.reloadIDLookup(metaForm).getGridMetaColumnByKey(key);
                        if (gridMetaColumnByKey.getKey().equalsIgnoreCase(key)) {
                            key = metaGridColumn.getMetaKey();
                        }
                        int controlType = abstractMetaObject.getCellType();
                        columnStr = new StringBuilder().append(";").append(key + "@" + caption + "@" + ControlType.toString(controlType) + "@" + ((MetaGrid) allUIComponentsvalue).getKey()).append(",").append(key).append("  ").append("[").append(caption).append("@").append(ControlType.toString(controlType)).append("]").append("  in ").append(((MetaGrid) allUIComponentsvalue).getKey());
                        str = str.append(columnStr);
                        exist = true;
                    }
                }

            }
        }
        if (!exist) {
            if (StringUtils.isEmpty(metaForm.getExtend())) {
                return str.toString();
            }
            HashMap<String, AbstractMetaObject> allUIComponents1 = getMidContext().getMetaFactory().getMetaForm(metaForm.getExtend()).getAllUIComponents();
            List<MetaGrid> metaGrids1 = IDLookup.getIDLookup(getMidContext().getMetaFactory().getMetaForm(metaForm.getExtend())).getMetaGrids();//源表格
            for (MetaGrid metaGrid : metaGrids1) {
                for (MetaGridColumn metaGridColumn : metaGrid.getColumnCollection()) {
                    String key = metaGridColumn.getKey();
                    String caption = metaGridColumn.getCaption();
                    caption = RegExUtils.replaceAll(caption, ",", "，");
                    caption = RegExUtils.replaceAll(caption, "\\s*", "");
                    if (!f.apply(key) && Objects.nonNull(xmlTree1.getTagNode("GridColumn@" + metaGridColumn.getKey()))) {
                        MetaGridCell metaGridCell = (MetaGridCell) allUIComponents1.get(key);
                        int columnType = metaGridCell.getCellType();
                        columnStr =
                                new StringBuilder().append(";").append(key + "@" + caption + "@" + ControlType.toString(columnType) + "@" + metaGrid.getKey()).append(",").append(key).append("  ").append("[").append(caption).append("@").append(ControlType.toString(columnType)).append("]").append("  in ").append(metaGrid.getKey());
                        str = str.append(columnStr);

                    }

                }

            }
       /*      for (HashMap.Entry<String, AbstractMetaObject> allUIComponent : allUIComponents1.entrySet()) {
                 String key = allUIComponent.getKey();
                 AbstractMetaObject abstractMetaObject = allUIComponents.get(key);
                 AbstractMetaObject extendvalue = allUIComponent.getValue();
                 if (Objects.isNull(abstractMetaObject) && extendvalue instanceof MetaGridCell) {
                     String caption = ((MetaGridCell) extendvalue).getCaption();
                     int controlType = ((MetaGridCell) extendvalue).getCellType();
                     columnStr =
                             new StringBuilder().append(";").append(key+"@"+caption+"@"+ControlType.toString(controlType)).append(",").append(key).append("  ").append("[").append(caption).append("@").append(ControlType.toString(controlType)).append("]").append("  in ");
                     str = str.append(columnStr);


             }
         }*/
        }
        return str.toString();
    }

    public String getVestAllHeadComponent() throws Throwable {
        StringBuilder str = new StringBuilder(256);
        StringBuilder columnStr;
        RichDocumentContext midContext = getMidContext();
        String para = (String) midContext.getDefaultContext().getPara("OwnerFormKey");//获得表单key
        MetaForm metaForm = getMidContext().getMetaFactory().getMetaForm(para);
        String extend = metaForm.getExtend();
        if (extend.isEmpty()) {
            return str.toString();
        }
        String erpXmlFilePath = LoadFileTree.getPathByFormKey(para);
        // XmlTree
        String tmpPath = XmlFileProcessor.instance.getTmpFile(erpXmlFilePath);
        String filePath = StringUtils.isNotBlank(tmpPath) ? tmpPath : erpXmlFilePath;
        XmlTree xmlTree = Xml4jUtil.parseTree(filePath);
        HashMap<String, AbstractNode> mapNodes = xmlTree.getMapNodes();
        Set<String> strings = mapNodes.keySet();
        Function<String, Boolean> f = key -> {
            for (String string : strings) {
                boolean b = StringUtils.endsWith(string, "@" + key);
                if (b) {
                    return true;
                }
            }
            return false;
        };

        List<MetaFormProfile> metaFormProfiles = new ArrayList<>();
        MetaFormList metaFormList = getMidContext().getMetaFactory().getMetaFormList();
        for (MetaFormProfile metaFormProfile : metaFormList) {
            if (metaFormProfile.getMergeToSource()) {
                metaFormProfiles.add(metaFormProfile);
            }
        }
        MetaForm specMetaForm = getMidContext().getMetaFactory().getMetaForm(extend);
        MetaForm xmlMetaForm = NewFormCmd.loadMetaForm(extend);
        List<MetaForm> sourceMetaFormList = Arrays.asList(xmlMetaForm, specMetaForm);
        for (MetaForm extendmetaForm : sourceMetaFormList) {
            HashMap<String, AbstractMetaObject> allUIComponents = metaForm.getAllUIComponents();
            HashMap<String, AbstractMetaObject> extendallUIComponents = extendmetaForm.getAllUIComponents();
            for (HashMap.Entry<String, AbstractMetaObject> extendabstractMetaObjectMap : extendallUIComponents.entrySet()) {
                boolean flag = false;
                String key = extendabstractMetaObjectMap.getKey();
                AbstractMetaObject abstractMetaObject = allUIComponents.get(key);//马甲表单
                AbstractMetaObject extendvalue = extendabstractMetaObjectMap.getValue();//源表单
                if (Objects.isNull(abstractMetaObject) && extendvalue instanceof MetaPanel) {
//				String caption = ((MetaPanel) extendvalue).getCaption();
//				int controlType = ((MetaPanel) extendvalue).getControlType();
//				columnStr = new StringBuilder().append(";").append(key + "@" + caption + "@" + ControlType.toString(controlType)).append(",").append(key).append("  ").append("[").append(caption).append("@").append(ControlType.toString(controlType)).append("]");
                    //str = str.append(columnStr);
                    for (MetaFormProfile metaFormProfile : metaFormProfiles) {
                        AbstractMetaObject object = metaFormProfile.getForm().getAllUIComponents().get(key);
                        if (Objects.isNull(object)) {
                            continue;
                        }
                        if (((MetaComponent) object).isExtend()) {
                            flag = true;
                        }
                    }
                    if (!flag) {
                        ArrayList<MetaComponent> componentArray = ((MetaPanel) (extendvalue)).getComponentArray();
                        for (MetaComponent metaComponent : componentArray) {
                            //if (metaComponent.getControlType() != 209) {
                            String key1 = metaComponent.getKey();
                            if (StringUtils.contains(str, key1 + "@")) {
                                continue;
                            }
                            String caption1 = metaComponent.getCaption();
                            caption1 = RegExUtils.replaceAll(caption1, ",", "，");
                            caption1 = RegExUtils.replaceAll(caption1, "\\s*", "");
                            int controlType1 = metaComponent.getControlType();
                            columnStr =
                                    new StringBuilder().append(";").append(key1 + "@" + caption1 + "@" + ControlType.toString(controlType1) + "@" + key).append(",").append(key1).append(" " +
                                            " ").append("[").append(caption1).append("@").append(ControlType.toString(controlType1)).append("]").append("  in ").append(key);
                            str = str.append(columnStr);
                            //}
                        }
                    }
                }
                if (extendvalue instanceof MetaPanel && abstractMetaObject != null) {
                    ArrayList<MetaComponent> componentArray = ((MetaPanel) abstractMetaObject).getComponentArray();//当前表单组件个数
                    ArrayList<MetaComponent> extendcomponentArray = ((MetaPanel) extendvalue).getComponentArray();
                    HashMap<String, String> componentArrayHashMap = new HashMap<>();
                    for (MetaComponent metaComponent : componentArray) {
                        if (!metaComponent.isExtend() /*&& !metaComponent.isShiftExtend()*/) {
                            componentArrayHashMap.put(metaComponent.getKey(), metaComponent.getCaption());
                        }
                    }
                    for (MetaComponent extendmetaComponent : extendcomponentArray) {
                        if (extendmetaComponent instanceof MetaSubDetail) {
                            continue;
                        }
                        String extendmetaComponentKey = extendmetaComponent.getKey();
                        String s = componentArrayHashMap.get(extendmetaComponentKey);
//                    boolean band = isBind((MetaPanel) extendvalue, componentArrayHashMap, extendmetaComponentKey);
                        if (!f.apply(extendmetaComponentKey)) {
                            String key1 = extendmetaComponent.getKey();
                            if (StringUtils.contains(str, key1 + "@")) {
                                continue;
                            }
                            String caption = extendmetaComponent.getCaption();
                            caption = RegExUtils.replaceAll(caption, ",", "，");
                            caption = RegExUtils.replaceAll(caption, "\\s*", "");
                            int controlType = extendmetaComponent.getControlType();
                            columnStr = new StringBuilder().append(";").append(key1 + "@" + caption + "@" + ControlType.toString(controlType) + "@" + key).append(",").append(key1).append("  ").append("[").append(caption).append("@").append(ControlType.toString(controlType)).append("]").append("  in ").append(key);
                            str = str.append(columnStr);
                        }
                    }
                }
            }
        }


        return str.toString();
    }

    private boolean isBind(MetaPanel extendvalue, HashMap<String, String> componentArrayHashMap, String extendmetaComponentKey) {
        boolean s = false;
        for (Map.Entry<String, String> stringStringEntry : componentArrayHashMap.entrySet()) {
            String entryKey = stringStringEntry.getKey();
            if (Objects.isNull(extendvalue.getComponent(entryKey))) {
                continue;
            }
            if (extendvalue.getComponent(entryKey).getBuddyKey().equals(extendmetaComponentKey)) {
                return true;
            }

        }
        return s;
    }

    public String getVestPanelComponent() throws Throwable {
        StringBuilder str = new StringBuilder(256);
        StringBuilder columnStr;
        RichDocumentContext midContext = getMidContext();
        String para = (String) midContext.getDefaultContext().getPara("OwnerFormKey");//获得表单key

        String erpXmlFilePath = LoadFileTree.getPathByFormKey(para);
        // XmlTree
        String tmpPath = XmlFileProcessor.instance.getTmpFile(erpXmlFilePath);
        String filePath = StringUtils.isNotBlank(tmpPath) ? tmpPath : erpXmlFilePath;
        XmlTree xmlTree = Xml4jUtil.parseTree(filePath);
        HashMap<String, AbstractNode> mapNodes = xmlTree.getMapNodes();
        Set<String> strings = mapNodes.keySet();
        Function<String, Boolean> f = key -> {
            for (String string : strings) {
                boolean b = StringUtils.endsWith(string, "@" + key);
                if (b) {
                    return true;
                }
            }
            return false;
        };

        MetaForm metaForm = getMidContext().getMetaFactory().getMetaForm(para);
        HashMap<String, AbstractMetaObject> allUIComponents = metaForm.getAllUIComponents();

        String extend = metaForm.getExtend();
        MetaForm specMetaForm = getMidContext().getMetaFactory().getMetaForm(extend);
        MetaForm xmlMetaForm = NewFormCmd.loadMetaForm(extend);
        List<MetaForm> sourceMetaFormList = Arrays.asList(xmlMetaForm, specMetaForm);

        for (MetaForm extendmetaForm : sourceMetaFormList) {
            HashMap<String, AbstractMetaObject> extendallUIComponents = extendmetaForm.getAllUIComponents();
            for (HashMap.Entry<String, AbstractMetaObject> extendabstractMetaObjectMap : extendallUIComponents.entrySet()) {
                String key = extendabstractMetaObjectMap.getKey();
                AbstractMetaObject abstractMetaObject = allUIComponents.get(key);
                AbstractMetaObject extendvalue = extendabstractMetaObjectMap.getValue();
        /*    if (Objects.isNull(abstractMetaObject) && extendvalue instanceof MetaPanel) {
                String caption = ((MetaPanel) extendvalue).getCaption();
                int controlType = ((MetaPanel) extendvalue).getControlType();
                columnStr = new StringBuilder().append(";").append(key+"@"+caption+"@"+ControlType.toString(controlType)).append(",").append(key).append("  ").append("[").append(caption).append("@").append(ControlType.toString(controlType)).append("]");
                str = str.append(columnStr);
                ArrayList<MetaComponent> componentArray = ((MetaPanel) (extendvalue)).getComponentArray();
                for (MetaComponent metaComponent : componentArray) {
                    if (metaComponent.getControlType() != 209) {
                        String key1 = metaComponent.getKey();
                        String caption1 = metaComponent.getCaption();
                        int controlType1 = metaComponent.getControlType();
                        columnStr =
                                new StringBuilder().append(";").append(key1+"@"+caption1+"@"+ControlType.toString(controlType1)).append(",").append(key1).append(" " +
                                        " ").append("[").append(caption1).append("@").append(ControlType.toString(controlType1)).append("]").append("  in ").append(key);
                        str = str.append(columnStr);
                    }
                }
            }*/
                if (extendvalue instanceof MetaPanel && abstractMetaObject != null) {
                    ArrayList<MetaComponent> componentArray = ((MetaPanel) abstractMetaObject).getComponentArray();//当前表单组件个数
                    ArrayList<MetaComponent> extendcomponentArray = ((MetaPanel) extendvalue).getComponentArray();
                    HashMap<String, String> componentArrayHashMap = new HashMap<>();
                    for (MetaComponent metaComponent : componentArray) {
                        componentArrayHashMap.put(metaComponent.getKey(), metaComponent.getCaption());
                    }
                    for (MetaComponent extendmetaComponent : extendcomponentArray) {
                        String key1 = extendmetaComponent.getKey();
                        if (StringUtils.contains(str, key1 + "@")) {
                            continue;
                        }
                        if (extendmetaComponent.getControlType() != ControlType.LABEL && !f.apply(key1)) {
                            String caption = extendmetaComponent.getCaption();
                            caption = RegExUtils.replaceAll(caption, ",", "，");
                            caption = RegExUtils.replaceAll(caption, "\\s*", "");
                            int controlType = extendmetaComponent.getControlType();
                            columnStr =
                                    new StringBuilder().append(";").append(key1 + "@" + caption + "@" + ControlType.toString(controlType) + "@" + key).append(",").append(key1).append(
                                            "  ").append("[").append(caption).append("@").append(ControlType.toString(controlType)).append("]").append("  in ").append(key);
                            str = str.append(columnStr);
                        }
                    }
                }
            }
        }
        return str.toString();
    }


    /**
     * @param value 检查输入值是否符合规范
     * @return
     */
    public Boolean checkValue(String value) {

        //检测数据格式
        return PATTERN.matcher(value).matches();
    }

    /**
     * 判断 是否启用关联数据映射
     * 源单和目标表单其中一个是马甲的时候启用关联数据映射
     * 并返回 对应原单的数据映射
     */
    public String isEnableLinkDataMap(String source, String target) throws Throwable {
        StringBuilder stringBuilder = new StringBuilder();
        IMetaFactory globalInstance = getMidContext().getMetaFactory();
        MetaFormProfile metaFormProfile = globalInstance.getMetaFormList()
                .get(source);
        MetaFormProfile formProfile = globalInstance.getMetaFormList()
                .get(target);
        if (metaFormProfile != null && formProfile != null) {
            List<KeyPairMetaObject> customList = getMidContext().getMetaFactory().getCustomList();
            String sourceVariable = globalInstance.getMetaForm(source).getExtend();
            String targetVariable = globalInstance.getMetaForm(target).getExtend();
            String sourceExtend = StringUtils.isNoneEmpty(sourceVariable)
                    ? sourceVariable : source;
            String targetExtend = StringUtils.isNoneEmpty(targetVariable)
                    ? targetVariable : target;
            for (KeyPairMetaObject erpMetaMap : customList) {
                if (erpMetaMap instanceof ERPMetaMap) {
                    if (StringUtils.isNotEmpty(((ERPMetaMap) erpMetaMap).getExtend())) {
                        continue;
                    }
                    String key = erpMetaMap.getKey();
                    String caption = ((ERPMetaMap) erpMetaMap).getCaption();
                    caption = RegExUtils.replaceAll(caption, ",", "，");
                    caption = RegExUtils.replaceAll(caption, "\\s*", "");
                    String srcFormKey = ((ERPMetaMap) erpMetaMap).getSrcFormKey();
                    String tgtFormKey = ((ERPMetaMap) erpMetaMap).getTgtFormKey();
                    if (srcFormKey.equals(sourceExtend) && tgtFormKey.equals(targetExtend)) {
                       /* if (StringUtils.isNotEmpty(sourceVariable)
                                || StringUtils.isNotEmpty(targetVariable)) {*/
                        String string = stringBuilder.toString();
                        if (string.contains(key + " " + caption)) {
                            continue;
                        }
                        stringBuilder.append(key).append(",").append(key).append(" ").append(caption).append(";");

                        //}
                    }
                }
            }
            String string = stringBuilder.toString();
            if (StringUtils.isEmpty(string)) {
                return "";
            }
            string = string.substring(0, string.length() - 1);
            return string;
        }
        return "";
    }

    /**
     * 判断 是否启用关联数据迁移
     * 源数据对象和目标数据对象其中一个是马甲的时候启用关联数据对象
     * 并返回 对应原数据对象的数据迁移
     */
    public String isEnableLinkDataMigration(String source, String target) throws Throwable {
        StringBuilder stringBuilder = new StringBuilder();
        IMetaFactory globalInstance = getMidContext().getMetaFactory();
        MetaDataObjectProfile sourceDataObjectProfile = globalInstance.getDataObjectList().get(source);
        MetaDataObjectProfile targetDataObjectProfile = globalInstance.getDataObjectList().get(target);

        if (sourceDataObjectProfile != null && targetDataObjectProfile != null) {
            String sourceVariable = globalInstance.getDataObject(source).getExtend();
            String targetVariable = globalInstance.getDataObject(target).getExtend();
            String sourceExtend = StringUtils.isNoneEmpty(sourceVariable) ? sourceVariable : source;
            String targetExtend = StringUtils.isNoneEmpty(targetVariable) ? targetVariable : target;
            MetaDataMigrationList dataMigrationList = globalInstance.getDataMigrationList();
            Iterator<MetaDataMigrationProfile> iterator = dataMigrationList.iterator();
            while (iterator.hasNext()) {
                MetaDataMigrationProfile metaDataMigrationProfile = iterator.next();
                if (StringUtils.isNotEmpty(metaDataMigrationProfile.getDataMigration().getExtend())) {
                    continue;
                }
                String srcDataObjectKey = metaDataMigrationProfile.getSrcDataObjectKey();
                String tgtDataObjectKey = metaDataMigrationProfile.getTgtDataObjectKey();
                if (StringUtils.equals(sourceExtend, srcDataObjectKey) && StringUtils.equals(targetExtend, tgtDataObjectKey)) {
                    String key = metaDataMigrationProfile.getKey();
                    String caption = metaDataMigrationProfile.getCaption();
                    caption = RegExUtils.replaceAll(caption, ",", "，");
                    caption = RegExUtils.replaceAll(caption, "\\s*", "");
                   /* if (StringUtils.isNotEmpty(sourceVariable)
                            || StringUtils.isNotEmpty(targetVariable)) {*/
                    String string = stringBuilder.toString();
                    if (string.contains(key + " " + caption)) {
                        continue;
                    }
                    stringBuilder.append(key).append(",").append(key).append(" ").append(caption).append(";");
                    //  }
                }
            }
            String string = stringBuilder.toString();
            if (StringUtils.isEmpty(string)) {
                return "";
            }
            string = string.substring(0, string.length() - 1);
            return string;
        }
        return "";
    }

    //控制mergeToSource马甲映射只创建一个
    public boolean ismergeToSource(String source, String target, String extend) throws Throwable {
        boolean merge = true;
        String dataMapPath = LoadFileTree.getDataMapPathByKey(extend);
        String sourcePath = LoadFileTree.getPathByFormKey(source);
        XmlTreeWithPath sourceParse = XmlTreeWithPath.parseFilePath(sourcePath);
        String toSource = sourceParse.xmlTree.getRoot().getAttributes().get("MergeToSource");
        if (!"true".equalsIgnoreCase(toSource)) {
            return false;
        }
        String targetPath = LoadFileTree.getPathByFormKey(target);
        XmlTreeWithPath targetParse = XmlTreeWithPath.parseFilePath(targetPath);
        String toTarget = targetParse.xmlTree.getRoot().getAttributes().get("MergeToSource");
        if (!"true".equalsIgnoreCase(toTarget)) {
            return false;
        }
        if (!dataMapPath.isEmpty()) {
            XmlTreeWithPath parse = XmlTreeWithPath.parseFilePath(dataMapPath);
            String mergeToSource = parse.xmlTree.getRoot().getAttributes().get("MergeToSource");
            if ("true".equalsIgnoreCase(mergeToSource)) {
                merge = false;
            }

        }
        return merge;
    }

    //表达式弹框


    public void setFuncTable(String FunctionSearch) throws Throwable {
        cache = CacheFactory.getInstance().createCache(ExpAutoCompleteCmd.cacheKey);
        RichDocument document = getMidContext().getRichDocument();
        String formulaKeys = (String) getMidContext().getPara("FormulaKeys");
        DataTable dataTable = document.getDataTable("ED_New_FunctionTable");
        dataTable.clear();
        Set<String> formulaKeyCollect = Arrays.stream(formulaKeys.split(",")).collect(Collectors.toSet());
        for (String s : formulaKeyCollect) {
            HashMap<String, List<String>> dataSource = (HashMap<String, List<String>>) cache.get(s);
            dataTableSetFunc(FunctionSearch, dataTable, dataSource);
        }
        if (formulaKeyCollect.contains("designer") || formulaKeyCollect.contains("macro")) {
            List<String> macroIdList = (List<String>) cache.get("macroIdList");
            List<String> macroDescList = (List<String>) cache.get("macroDescList");
            // 重新获取宏公式
            if (CollectionUtils.isEmpty(macroIdList)) {
                macroIdList = new ArrayList<>();
                macroDescList = new ArrayList<>();
                // 添加宏公式到自动完成列表中
                Map<String, String> macroMap = this.getCommonDefMacro(getMidContext());
                if (null != macroMap && !macroMap.isEmpty()) {
                    //按map的key排序
                    Map<String, String> resultMap = macroMap.entrySet().stream()
                            .sorted(Map.Entry.comparingByKey())
                            .collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue,
                                    (oldValue, newValue) -> oldValue, LinkedHashMap::new));
                    for (Map.Entry<String, String> entry : resultMap.entrySet()) {
                        if (macroIdList.contains(entry.getKey())) {
                            continue;
                        }
                        macroIdList.add(entry.getKey());
                        macroDescList.add(entry.getValue());
                    }
                }
            }
            for (int i = 0; i < macroIdList.size(); i++) {
                String FunctionKey = macroIdList.get(i);
                String FunctionCaption = CollectionUtils.isEmpty(macroDescList) ? "" : macroDescList.get(i);
                if (FunctionKey.toLowerCase().contains(FunctionSearch.toLowerCase().trim())
                        || FunctionKey.toLowerCase().startsWith(FunctionSearch.trim().toLowerCase())
                        || FunctionCaption.toLowerCase().contains(FunctionSearch.toLowerCase().trim())
                        || FunctionCaption.toLowerCase().startsWith(FunctionSearch.trim().toLowerCase())) {
                    String ParamKey = "";
                    String ReturnKey = "";
                    dataTable.append();
                    dataTable.setString("FunctionKey", FunctionKey);
                    dataTable.setString("FunctionCaption", FunctionCaption);
                    dataTable.setString("ParamKey", ParamKey);
                    dataTable.setString("ReturnKey", ReturnKey);
                }
            }

        }
        document.addDirtyTableFlag("ED_New_FunctionTable");
    }

    /***
     * 函数信息设置及搜索
     * @param
     * @throws Throwable
     */
    @SuppressWarnings("unchecked")
    public void setColumnList(String search) throws Throwable {
        RichDocument document = getMidContext().getRichDocument();
        MetaTable table = null;
        DataTable dataTable = document.getDataTable(ConstantUtil.TBL_Detail_Column);
        dataTable.clear();
        String formKey = (String) getMidContext().getPara("FormKey");
        String tableKey = (String) getMidContext().getPara("TableKey");
        boolean isMainTable = StringUtils.isEmpty(tableKey);
        MetaForm metaForm = getMidContext().getMetaFactory().getMetaForm(formKey);
        MetaDataSource dataSource = metaForm.getDataSource();
        String refObjectKey = dataSource.getRefObjectKey();
        List<MetaColumn> columnList = new ArrayList<>();
        if (StringUtils.isNotEmpty(refObjectKey)) {
            MetaDataObject dataObject = getMidContext().getMetaFactory().getDataObject(refObjectKey);
            if (isMainTable) {
                table = dataObject.getMainTable();
            } else {
                table = dataObject.getTable(tableKey);
            }
            if (Objects.isNull(table)) {
                return;
            }
            if (isMainTable) {
                tableKey = table.getKey();
            }
            Collection<MetaColumn> items = table.items();
            for (MetaColumn item : items) {
                columnList.add(item);
            }
        } else {
            if (isMainTable) {
                table = dataSource.getDataObject().getMainTable();
            } else {
                table = dataSource.getDataObject().getTable(tableKey);
            }
            if (Objects.isNull(table)) {
                return;
            }
            Collection<MetaColumn> items = table.items();
            for (MetaColumn item : items) {
                columnList.add(item);
            }
        }
        for (int i = 0; i < columnList.size(); i++) {
            MetaColumn metaColumn = columnList.get(i);
            if (metaColumn.getKey().toLowerCase().contains(search.toLowerCase().trim())
                    || metaColumn.getKey().toLowerCase().startsWith(search.trim().toLowerCase())
                    || metaColumn.getCaption().toLowerCase().contains(search.toLowerCase().trim())
                    || metaColumn.getCaption().toLowerCase().startsWith(search.trim().toLowerCase())) {
                int appendi = dataTable.append();
                if (isMainTable) {
                    dataTable.setString("ColumnKey", table.getKey() + "|" + metaColumn.getKey());
                } else {
                    dataTable.setString("ColumnKey", metaColumn.getKey());
                }
                dataTable.setString("Caption", metaColumn.getCaption());
                IOMetaObject.loadCellFormat(dataTable, metaForm, tableKey, IDLookup.reloadIDLookup(metaForm), metaColumn, appendi);
            }
        }

        document.addDirtyTableFlag(ConstantUtil.TBL_Detail_Column);
    }

    public void dataTableSetFunc(String FunctionSearch, DataTable dataTable, HashMap<String, List<String>> dataSource) {
        List<String> funcList = dataSource.get("funcList");
        List<String> funcDescList = dataSource.get("funcDescList");
        List<String> paramDescList = dataSource.get("paramDescList");
        List<String> returnValueDescList = dataSource.get("returnValueDescList");

        if (!CollectionUtils.isEmpty(funcList)) {
            for (int i = 0; i < funcList.size(); i++) {
                String FunctionKey = funcList.get(i);
                String FunctionCaption = CollectionUtils.isEmpty(funcDescList) ? "" : funcDescList.get(i);
                if (FunctionKey.toLowerCase().contains(FunctionSearch.toLowerCase().trim())
                        || FunctionKey.toLowerCase().startsWith(FunctionSearch.trim().toLowerCase())
                        || FunctionCaption.toLowerCase().contains(FunctionSearch.toLowerCase().trim())
                        || FunctionCaption.toLowerCase().startsWith(FunctionSearch.trim().toLowerCase())) {
                    String ParamKey = CollectionUtils.isEmpty(paramDescList) ? "" : paramDescList.get(i);
                    String ReturnKey = CollectionUtils.isEmpty(returnValueDescList) ? "" : returnValueDescList.get(i);
                    dataTable.append();
                    dataTable.setString("FunctionKey", FunctionKey);
                    dataTable.setString("FunctionCaption", FunctionCaption);
                    dataTable.setString("ParamKey", ParamKey);
                    dataTable.setString("ReturnKey", ReturnKey);
                }

            }

            // 如果函数表格没有数据，那么就inexOf()检索一下函数列表
            if (dataTable.size() == 0) {
                for (int i = 0; i < funcList.size(); i++) {
                    String FunctionKey = funcList.get(i);
                    String FunctionCaption = CollectionUtils.isEmpty(funcDescList) ? "" : funcDescList.get(i);
                    if (FunctionKey.toLowerCase().contains(FunctionSearch.toLowerCase().trim())
                            || FunctionKey.toLowerCase().startsWith(FunctionSearch.trim().toLowerCase())
                            || FunctionCaption.toLowerCase().contains(FunctionSearch.toLowerCase().trim())
                            || FunctionCaption.toLowerCase().startsWith(FunctionSearch.trim().toLowerCase())) {
                        String ParamKey = CollectionUtils.isEmpty(paramDescList) ? "" : paramDescList.get(i);
                        String ReturnKey = CollectionUtils.isEmpty(returnValueDescList) ? "" : returnValueDescList.get(i);
                        dataTable.append();
                        dataTable.setString("FunctionKey", FunctionKey);
                        dataTable.setString("FunctionCaption", FunctionCaption);
                        dataTable.setString("ParamKey", ParamKey);
                        dataTable.setString("ReturnKey", ReturnKey);
                    }
                }
            }
        }
    }

    /***
     * 表单信息设置及搜索
     * @param FormSearch
     * @throws Throwable
     */
    @SuppressWarnings("unchecked")
    public void setFormTable(String FormSearch, String isFuzzyQuery) throws Throwable {
        cache = CacheFactory.getInstance().createCache(ExpAutoCompleteCmd.cacheKey);
        RichDocument document = getMidContext().getRichDocument();
        DataTable dataTable = document.getDataTable("ED_New_FormTable");
        DataTable fieldDataTable = document.getDataTable("ED_New_FieldTable");
        dataTable.clear();
        fieldDataTable.clear();
        List<String> formKeyList = (List<String>) cache.get("FormKeyList");
        List<String> formCaptionList = (List<String>) cache.get("formCaptionList");
        if (CollectionUtils.isEmpty(formKeyList)) {
            formKeyList = new ArrayList<>();
            formCaptionList = new ArrayList<>();
            IMetaFactory metaFactory = getMidContext().getVE().getMetaFactory();
            MetaFormList metaFormList = metaFactory.getMetaFormList();
            for (int i = 0; i < metaFormList.size(); i++) {
                MetaForm metaForm = metaFormList.get(i).getForm();
                formKeyList.add(metaForm.getKey());
                formCaptionList.add(metaForm.getCaption());
            }
        }
        if ("".equals(isFuzzyQuery) || Boolean.valueOf(isFuzzyQuery)) {
            for (int i = 0; i < formKeyList.size(); i++) {
                String FormKey = formKeyList.get(i);
                String FormCaption = formCaptionList.get(i);
                if (FormKey.toLowerCase().contains(FormSearch.toLowerCase().trim())
                        || FormKey.toLowerCase().startsWith(FormSearch.trim().toLowerCase())
                        || FormCaption.toLowerCase().contains(FormSearch.toLowerCase().trim())
                        || FormCaption.toLowerCase().startsWith(FormSearch.trim().toLowerCase())) {
                    dataTable.append();
                    dataTable.setString(ConstantUtil.FORM_KEY, FormKey);
                    dataTable.setString("FormCaption", FormCaption);
                }
            }
        } else {
            String[] split = FormSearch.split(",");
            for (String fs : split) {
                for (int i = 0; i < formKeyList.size(); i++) {
                    String FormKey = formKeyList.get(i);
                    String FormCaption = formCaptionList.get(i);
                    if (FormKey.toLowerCase().equals(fs.toLowerCase().trim())
                            || FormCaption.toLowerCase().equals(fs.toLowerCase().trim())) {
                        dataTable.append();
                        dataTable.setString(ConstantUtil.FORM_KEY, FormKey);
                        dataTable.setString("FormCaption", FormCaption);
                    }
                }
            }
        }

        document.addDirtyTableFlag("ED_New_FormTable");
        document.addDirtyTableFlag("ED_New_FieldTable");
    }

    /***
     * 字段信息设置及搜索
     * @param SelectFormKey
     * @param FieldSearch
     * @throws Throwable
     */
    public void setFieldTable(String SelectFormKey, String FieldSearch) throws Throwable {
        if (StringUtils.isEmpty(SelectFormKey)) {
            return;
        }
        RichDocument document = getMidContext().getRichDocument();
        DataTable dataTable = document.getDataTable("ED_New_FieldTable");
        dataTable.clear();
        IMetaFactory metaFactory = getMidContext().getVE().getMetaFactory();
        MetaForm metaForm = metaFactory.getMetaForm(SelectFormKey);
        if (metaForm != null) {
            IDLookup idLookup = IDLookup.getIDLookup(metaForm);
            Collection<String> keys = idLookup.getFieldKeys();
            if (null != keys && !keys.isEmpty()) {
                List<String> list = new ArrayList<>(keys);
                Collections.sort(list);
                String caption = "";
                for (String key : list) {
                    if (StringUtils.isNotEmpty(key)) {
                        caption = idLookup.getFieldCaption(key);
                        if (StringUtils.isEmpty(caption)) {
                            // grid
                            if (null != idLookup.getGridCellByKey(key)) {
                                caption = idLookup.getGridCellByKey(key).getCaption();
                            }
                            // listView
                            if (StringUtils.isEmpty(caption)) {
                                if (null != idLookup.getListViewColumnByKey(key)) {
                                    caption = idLookup.getListViewColumnByKey(key).getCaption();
                                }
                            }
                        }
                        if (key.toLowerCase().indexOf(FieldSearch.toLowerCase().trim()) != -1
                                || key.toLowerCase().startsWith(FieldSearch.trim().toLowerCase())
                                || caption.toLowerCase().indexOf(FieldSearch.toLowerCase().trim()) != -1
                                || caption.toLowerCase().startsWith(FieldSearch.trim().toLowerCase())) {
                            dataTable.append();
                            dataTable.setString(ConstantUtil.FIELD_KEY, key);
                            dataTable.setString("FieldCaption", caption);
                        }

                    }

                }
            }
        }
        document.addDirtyTableFlag("ED_New_FieldTable");
    }

    /***
     * 获取宏表达式列表
     * @param context 上下文
     * @return 宏表达式列表
     */
    private Map<String, String> getCommonDefMacro(DefaultContext context) throws Throwable {
        Map<String, String> macroMap = new HashMap<>(10000);
        IMetaFactory metaFactory = context.getVE().getMetaFactory();
        ExecutorService executorService = new ThreadPoolExecutor(2, 2, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        CountDownLatch countDownLatch = new CountDownLatch(2);
        // 公共宏公式
        Future<Map<String, String>> commonMacro = executorService.submit(() -> {
            Map<String, String> map = new HashMap<>();
            try {
                // 公共的commonDef
                MetaCommonDef metaCommonDef = metaFactory.getCommonDef("");
                if (null != metaCommonDef) {
                    setMacroMap(map, metaCommonDef.getMacroCollection());
                }
            } catch (Throwable throwable) {
                logger.warning(ExceptionUtils.getStackTrace(throwable));
            } finally {
                countDownLatch.countDown();
            }
            return map;
        });

        // 所有表单下的宏公式
        Future<Map<String, String>> formsMacro = executorService.submit(() -> {
            Map<String, String> map = new HashMap<>();
            try {
                // 所有metaForm下的组件及宏公式
                MetaFormList metaFormList = getMidContext().getMetaFactory().getMetaFormList();
                if (metaFormList != null && !metaFormList.isEmpty()) {
                    for (MetaFormProfile metaFormProfile : metaFormList) {
                        MetaProject metaProject = (MetaProject) metaFormProfile.getForm().getProject();
                        MetaCommonDef metaCommonDef = metaFactory.getCommonDef(metaProject.getKey());
                        // commonDef
                        if (null != metaCommonDef) {
                            setMacroMap(map, metaCommonDef.getMacroCollection());
                        }

                        // 宏表达式
                        MetaMacroCollection metaMacroCollection = metaFormProfile.getForm().getMacroCollection();
                        setMacroMap(map, metaMacroCollection);
                    }
                }
            } catch (Throwable throwable) {
                logger.warning(ExceptionUtils.getStackTrace(throwable));
            } finally {
                countDownLatch.countDown();
            }
            return map;
        });
        countDownLatch.await();
        macroMap.putAll(commonMacro.get());
        macroMap.putAll(formsMacro.get());
        return macroMap;
    }

    /***
     * 设置宏表达式
     * @param macroMap 宏表达式map
     * @param macroCollection 宏表达式集合
     */
    private void setMacroMap(Map<String, String> macroMap, MetaMacroCollection macroCollection) {
        if (null != macroCollection && !macroCollection.isEmpty()) {
            String args = "";
            String key = "";
            String value = "";
            for (MetaMacro metaMacro : macroCollection) {
                args = metaMacro.getArgs();
                if (StringUtils.isNotEmpty(args)) {
                    key = metaMacro.getKey() + "(" + args + ")";
                } else {
                    key = metaMacro.getKey() + "()";
                }
                value = metaMacro.getContent();
                macroMap.put(key, value);
            }
        }
    }

    public void setInitKey() {
        IOMetaObject.setMetaTable(null);
        IOMetaObject.setGridTableKey(null);
        /*DataObjectComboBox.parentTableKeyMap.clear();*/
    }

    public String getAddableCompComboBoxByVest() throws Throwable {
        String formKey = (String) _context.getPara("OwnerFormKey");
        if (StringUtils.isBlank(formKey)) {
            return "";
        }

        IMetaFactory metaFactory = getMidContext().getMetaFactory();
        MetaForm metaForm = metaFactory.getMetaForm(formKey);
        String originalFormKey = metaForm.getExtend();
        MetaForm originalMetaForm = metaFactory.getMetaForm(originalFormKey);

        HashMap<String, AbstractMetaObject> compMap = metaForm.getAllUIComponents();
        HashMap<String, AbstractMetaObject> originalCompMap = originalMetaForm.getAllUIComponents();

        String parentCompKey = (String) _context.getPara("ParentCompKey");
        AbstractMetaObject parentComp = compMap.get(parentCompKey);
        AbstractMetaObject originalParentComp = originalCompMap.get(parentCompKey);

        List<String> resultList = new ArrayList<>();
        if (parentComp instanceof MetaGridLayoutPanel && originalParentComp instanceof MetaGridLayoutPanel) {
            MetaGridLayoutPanel parentPanel = (MetaGridLayoutPanel) parentComp;
            MetaGridLayoutPanel originalParentPanel = (MetaGridLayoutPanel) originalParentComp;

            Set<String> buddyKeySet = originalParentPanel.getComponentArray().stream()
                    .map(MetaComponent::getBuddyKey).collect(Collectors.toSet());
            for (MetaComponent component : originalParentPanel.getComponentArray()) {
                String key = component.getKey();
                if (parentPanel.containsComponent(key) || buddyKeySet.contains(key)) {
                    continue;
                }
                String caption = component.getCaption();
                caption = RegExUtils.replaceAll(caption, ",", "，");
                caption = RegExUtils.replaceAll(caption, "\\s*", "");
                resultList.add(key + "," + key + " " + caption);
            }
        }
        if (parentComp instanceof MetaGrid && originalParentComp instanceof MetaGrid) {
            MetaGrid parentPanel = (MetaGrid) parentComp;
            MetaGrid originalParentPanel = (MetaGrid) originalParentComp;

            Set<String> existKeySet = new HashSet<>();
            MetaGridRowCollection rowCollection = parentPanel.getRowCollection();
            for (MetaGridRow cells : rowCollection) {
                for (MetaGridCell cell : cells) {
                    if (cell.isVestDeleted()) {
                        continue;
                    }
                    existKeySet.add(cell.getKey());
                }
            }

            MetaGridRowCollection originalRowCollection = originalParentPanel.getRowCollection();
            for (MetaGridRow cells : originalRowCollection) {
                for (MetaGridCell cell : cells) {
                    String key = cell.getKey();
                    if (existKeySet.contains(key)) {
                        continue;
                    }
                    String caption = cell.getCaption();
                    caption = RegExUtils.replaceAll(caption, ",", "，");
                    caption = RegExUtils.replaceAll(caption, "\\s*", "");
                    resultList.add(key + "," + key + " " + caption);
                }
            }
        }
        return StringUtils.join(resultList, ";");
    }

    /**
     * 获取CommonDef 参数组内容
     * 获取参数组内容的逻辑
     * 先查找当前工程下的参数组 和 solution下的参数组 结合
     * 如果有重名 只展示一个 // 则以当前工程下的参数组为准
     */
    public String getParamGroup() throws Throwable {
        IMetaFactory metaFactory = getMidContext().getMetaFactory();
        ComboxStringBuilder csb = ComboxStringBuilder.newInstance();
        final MetaParaTable paraTable = metaFactory.getParaTable();
        if (paraTable != null) {
            for (MetaParaGroup paraGroup : paraTable) {
                csb.addItem(paraGroup.getKey(), paraGroup.getKey() + " " + paraGroup.getCaption());
                }
            }
        return csb.toString();
    }
    public String getParamGroupByProjectKey(String projectKey) throws Throwable {
        ComboxStringBuilder csb = ComboxStringBuilder.newInstance();
        IMetaFactory metaFactory = getMidContext().getMetaFactory();
        MetaParaTable paraTable = metaFactory.getParaTable();
        if (paraTable != null) {
            for (MetaParaGroup paraGroup : paraTable) {
                csb.addItem(paraGroup.getKey(), paraGroup.getKey() + " " + paraGroup.getCaption());
            }
        }
        return csb.toString();
    }

    public JSONArray getParamGroupDetail(String paraGroupKey) throws Throwable {
        IMetaFactory metaFactory = getMidContext().getMetaFactory();
        MetaParaTable paraTable = metaFactory.getParaTable();
        MetaParaGroup metaParaGroup = paraTable.get(paraGroupKey);
        if(metaParaGroup != null){
            JSONArray result = new JSONArray();
            for (MetaParaItem paraItem : metaParaGroup) {
                JSONObject item = new JSONObject();
                item.put("Key", paraItem.getKey());
                item.put("Value", paraItem.getValue());
                item.put("Caption", paraItem.getCaption());
                result.put(item);
            }
            return result;
        }
        return null;
    }

    public String getAllAuxiliaryType(String dataObjectKey) throws Throwable{
        ComboxStringBuilder csb = ComboxStringBuilder.newInstance();
        csb.addItem(DataObjectSecondaryType.STR_NORMAL, ConstantUtil.STR_NORMAL_CAPTION);
        csb.addItem(DataObjectSecondaryType.STR_DICT, ConstantUtil.STR_DICT_CAPTION);
        csb.addItem(DataObjectSecondaryType.STR_CHAINDICT, ConstantUtil.STR_CHAINDICT_CAPTION);
        MetaFormList metaFormList = getMidContext().getMetaFactory().getMetaFormList();
        for (int i = 0; i < metaFormList.size(); i++){
            MetaFormProfile metaFormProfile = metaFormList.get(i);
            MetaForm form = metaFormProfile.getForm();
            if(form == null || form.getDataSource() == null) {
                continue;
            }
            MetaDataObject dataObject = form.getDataSource().getDataObject();
            if(dataObject != null){
                if(StringUtils.equals(dataObject.getKey(),dataObjectKey)){
                    return csb.toString();
                }
            }else{
                String refObjectKey = form.getDataSource().getRefObjectKey();
                if(StringUtils.equals(refObjectKey,dataObjectKey)){
                    return csb.toString();
                }
            }
        }
        csb.addItem(DataObjectSecondaryType.STR_MIGRATION, ConstantUtil.STR_MIGRATION_CAPTION);
        return csb.toString();
    }

    //获取图表绑定数据源标志
    public String getAllTblKey(String dataSourceType) throws Throwable {
        String formKey = (String) _context.getPara("OwnerFormKey");
        ComboxStringBuilder csb = ComboxStringBuilder.newInstance();
        MetaForm metaForm = getMidContext().getMetaFactory().getMetaForm(formKey);
        if (metaForm != null) { //表单
            if (StringUtils.equalsIgnoreCase(dataSourceType, ChartSourceType.toString(ChartSourceType.DATAOBJECT))) {
                MetaTableCollection metaTables = metaForm.getDataSource().getDataObject().getTableCollection();
                for (MetaTable metaTable : metaTables) {
                    csb.addItem(metaTable.getKey(), metaTable.getCaption());
                }
            } else if (StringUtils.equalsIgnoreCase(dataSourceType, ChartSourceType.toString(ChartSourceType.GRID))) {
                HashMap<String, AbstractMetaObject> uicomponents = metaForm.getAllUIComponents();
                for (String componentKey : uicomponents.keySet()) {
                    if (uicomponents.get(componentKey) instanceof MetaGrid) {
                        MetaGrid metaGrid = (MetaGrid)uicomponents.get(componentKey);
                        csb.addItem(componentKey, metaGrid.getCaption());
                    }
                }
            }
        }
        return csb.toString();
    }

    //获取图表项目来源字段
    public String getAllColKey(String tableKey, String dataSourceType) throws Throwable {
        String formKey = (String) _context.getPara("OwnerFormKey");
        ComboxStringBuilder csb = ComboxStringBuilder.newInstance();
        MetaForm metaForm = getMidContext().getMetaFactory().getMetaForm(formKey);
        if (metaForm != null && StringUtils.isNotEmpty(tableKey)) { //表单
            if (StringUtils.equalsIgnoreCase(dataSourceType, ChartSourceType.toString(ChartSourceType.DATAOBJECT))) {
                MetaTable metaTable = metaForm.getDataSource().getDataObject().getTable(tableKey);
                for (MetaColumn metaColumn : metaTable.items()) {
                    csb.addItem(metaColumn.getKey(), metaColumn.getCaption());
                }
            } else if (StringUtils.equalsIgnoreCase(dataSourceType, ChartSourceType.toString(ChartSourceType.GRID))) {
                MetaGrid metaGrid = (MetaGrid) metaForm.componentByKey(tableKey);
                for (MetaGridColumn metaGridColumn : metaGrid.getColumnCollection()) {
                    csb.addItem(metaGridColumn.getKey(), metaGridColumn.getCaption());
                }
            }
        }
        return csb.toString();
    }
    //获取getCommonDefVestScope
    public String getCommonDefVestScope() throws Throwable {
        ComboxStringBuilder csb = ComboxStringBuilder.newInstance();
        csb.addItem("root","[系统级别]");

        for (String projectKey : MetaFactory.getGlobalInstance().getProjectKeys()) {
            csb.addItem(projectKey,"["+projectKey+"] "+MetaFactory.getGlobalInstance().getMetaProject(projectKey).getCaption());
        }
        return csb.toString();
    }
    public DataTable getColumnList(String tableKey, String cellList, String OwnerFormKey) throws Throwable {
        RichDocumentContext context = this.getMidContext();
        MetaForm metaFormKeyDialog = context.getMetaFactory().getMetaForm("D_AutoColumnList");
        MetaTable gridMetaTable =
                metaFormKeyDialog.getDataSource().getDataObject().getMetaTable("ED_AutoColumnListDtl");
        DataTable dataTable = WebDesignerDataTableUtil.generateDataTable(gridMetaTable);
        if (StringUtils.isBlank(tableKey)) {
            WebDesignerDataTableUtil.setSequence(dataTable);
            return dataTable;

        }

        if (tableKey.matches("^[0-9]*$")) {
            tableKey = associatedTableMap.get(Integer.parseInt(tableKey));
            if (StringUtils.isBlank(tableKey)) {
                WebDesignerDataTableUtil.setSequence(dataTable);
                return dataTable;
            }
        }
        MetaForm metaForm = getMidContext().getMetaFactory().getMetaForm(OwnerFormKey);
        IDLookup idLookup = IDLookup.reloadIDLookup(metaForm);
        MetaDataSource dataSourse = metaForm.getDataSource();
        if (dataSourse == null) {
            WebDesignerDataTableUtil.setSequence(dataTable);
            return dataTable;
        }
        MetaTable table = dataSourse.getDataObject().getTable(tableKey);
        for (MetaColumn column : table) {
            String key = column.getKey();
            if (ConstantUtil.OID.equals(key) || ConstantUtil.POID.equals(key) || ConstantUtil.SOID.equals(key)
                    || ConstantUtil.VERID.equals(key) || ConstantUtil.DVERID.equals(key)
                    || ConstantUtil.MAP_COUNT.equals(key) || ConstantUtil.SELECT_FIELD.equals(key)
                    || key.contains(ConstantUtil.NODB) || ConstantUtil.SEQUENCE.equals(key)) {
                continue;
            }
            AbstractMetaObject metaObjectColumnByKey = idLookup.getMetaObjectColumnByKey(key);
            MetaComponent componentByKey = null;
            MetaGridCell metaGridCell = null;
            if (metaObjectColumnByKey instanceof MetaComponent) {
                componentByKey = (MetaComponent)metaObjectColumnByKey;
            }
            if (Objects.isNull(componentByKey)) {
                metaGridCell = idLookup.getGridCellByKey(key);
            }
            if (componentByKey != null || metaGridCell != null) {
                continue;
            }
            String caption = column.getCaption();
            String type, dataElementKey = "";
            if(column.getDataElement() != null && column.getDataElement().getDomain() != null ){
                Integer refControlType = column.getDataElement().getDomain().getRefControlType();
                type = ControlType.toString(refControlType);
                dataElementKey = column.getDataElementKey();
            }else{
                int dataType = column.getDataType();
                String cellType = DataType.toString(dataType);
                type = XmlDiffProcessor.getGridCellType(cellType, key);
            }
            dataTable.append();
            dataTable.setString("ColumnKey", key);
            dataTable.setString("DataElementKey", dataElementKey);
            dataTable.setString("Key", key);
            dataTable.setString("ColumnName", StringUtils.isEmpty(caption) ? "列名称" : caption);
            dataTable.setString("ControlType", type);
            dataTable.setState(RowState.NORMAL);
        }
        WebDesignerDataTableUtil.setSequence(dataTable);
        return dataTable;
    }

    public String getAllDictItem() throws Throwable{
        IMetaFactory metaFactory = getMidContext().getMetaFactory();
        List<String> itemList = new ArrayList<>();
        for (MetaFormProfile metaFormProfile : metaFactory.getMetaFormList()) {
            final MetaForm metaForm = metaFormProfile.getForm();
            if (Objects.isNull(metaForm)) {
                continue;
            }
            if (metaForm.getFormType() == FormType.Dict && metaForm.getDataSource() != null) {
                String itemKey = metaForm.getDataSource().getDataObject().getKey();
                itemList.add(itemKey + "," + itemKey + " " + metaForm.getCaption());
            }
        }
        return StringUtils.join(itemList, ";");
    }
    public static String getPreferencesInfo(String key){
        File file =new File(WebDesignerConfiguration.getDesignerDataPath()  + File.separator + "DesignerData.xml");
        String value;
        if(!file.exists()){return null;}
        try {
            String s = FileUtils.readFileToString(file, StandardCharsets.UTF_8);
            com.bokesoft.yes.xml.node.XmlTree parse = XmlParser.parse(s);
            com.bokesoft.yes.xml.node.TagNode node = parse.getRoot().findFirstTagNodeByTagName(key);
            if(node != null){
                value = node.getAttributes().get("Value").toString();
            } else{
                if("Font".equalsIgnoreCase(key)){
                    value = "inherit";
                }else if("FontSize".equalsIgnoreCase(key)){
                    value = "inherit";
                }else if("ReloadOnlyComment".equalsIgnoreCase(key)){
                    value = "false";
                }else if("FileTreeRowClick".equalsIgnoreCase(key)){
                    value = "false";
                }else{
                    value = "true";
                }
            }
        } catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return value;
    }
    public void setPreferencesInfo(String key,String value){
        String dataPath =WebDesignerConfiguration.getDesignerDataPath()  + File.separator + "DesignerData.xml";
        File file =new File(dataPath);
        if(!file.exists()) {
            throw new RuntimeException("设计器DesignerData.xml文件不存在！");
        }
        try {
            XmlTreeWithPath xmlTree = XmlTreeWithPath.parseFilePath(dataPath);
            TagNode root = xmlTree.xmlTree.getRoot();
            TagNode node = root.findFirstTagNodeByTagName(key);
            if(node !=null){
                node.setAttribute("Value",value);
                String xml = DesignIOMetaUtil.getXml(root);
                FileUtils.writeStringToFile(file,xml, StandardCharsets.UTF_8);
            } else {
                node = new TagNode(key, null).setAttribute("Value",value);
                TagNode preference = root.getChildByTagName("Preference");
                preference.addNode(node);
                String xml = DesignIOMetaUtil.getXml(root);
                FileUtils.writeStringToFile(file,xml, StandardCharsets.UTF_8);
            }
        } catch (Throwable e) {
            throw new RuntimeException(e);
        }
        if(key.equals("DelayedProcessScope")){
            ReloadForm.setDelayedProcessScope(Boolean.parseBoolean(value));
        }
    }

    public String getDataElements() throws Throwable {
        StringBuilder str = new StringBuilder(256).append(",");
        RichDocumentContext midContext = getMidContext();
        String para = (String) midContext.getDefaultContext().getPara("OwnerFormKey");
        String containerKey = (String) midContext.getDefaultContext().getPara("ContainerKey");
        MetaProject metaProject = null;
        String solutionKey = "";
        IMetaFactory metaFactory = midContext.getMetaFactory();
        if (metaFactory.getMetaFormList().get(para) == null) {
            metaProject = (MetaProject) metaFactory.getDataObjectList().get(para).getProject();
        } else {
            if (containerKey != null && !containerKey.isEmpty()) {
                metaProject = (MetaProject) metaFactory.getMetaFormList().get(containerKey).getProject();
            } else {
                metaProject = (MetaProject) metaFactory.getMetaFormList().get(para).getProject();
            }
        }
        MetaSolution solution = (MetaSolution) metaProject.getSolution();
        solutionKey = solution.getKey();

        MetaDataElementDef dataElementDef = getMidContext().getMetaFactory().getDataElementDef(solutionKey);

        if (dataElementDef.getDataElementCollection() == null) {
            return "";
        }
        for (MetaDataElement metaDataElement : dataElementDef.getDataElementCollection()) {
            StringBuilder columnStr;

            String key = metaDataElement.getKey();
            String caption = metaDataElement.getCaption();
            columnStr =
                    new StringBuilder().append(";").append(key).append(",").append(key).append(" ").append(caption == null ? "" : caption.replaceAll(","," "));
            str = str.append(columnStr);
        }
        return str.toString();
    }
    public String getDomainKeys() throws Throwable {
        StringBuilder str = new StringBuilder(256).append(",");
        RichDocumentContext midContext = getMidContext();
        String para = (String) midContext.getDefaultContext().getPara("OwnerFormKey");
        String filePath = FilePathHelper.toBackFilePath(para);
        String projectKey = LoadFileTree.getProjectKey(filePath);
        getDomainKey(str,projectKey);
        return str.toString();
    }
    public String getDomainKeyorNewKeys(String projectKey) throws Throwable {
        StringBuilder str = new StringBuilder(256).append("NewDomain,新增域 新增域");
        getDomainKey(str,projectKey);
        return str.toString();
    }
    private String getDomainKey(StringBuilder str,String projectKey) throws Throwable {
        String solutionKey = "";
        IMetaFactory metaFactory = getMidContext().getMetaFactory();
        if (StringUtils.isEmpty(projectKey)) {
            solutionKey = "";
        }else {
            MetaSolution solution = (MetaSolution) metaFactory.getMetaProject(projectKey).getSolution();
            solutionKey = solution.getKey();
        }
        MetaDomainDef domainDef = getMidContext().getMetaFactory().getDomainDef(solutionKey);

        if (domainDef.getDomainCollection() == null) {
            return "";
        }
        for (MetaDomain metaDomain : domainDef.getDomainCollection()) {
            StringBuilder columnStr;

            String key = metaDomain.getKey();
            String caption = metaDomain.getCaption();
            columnStr =
                    new StringBuilder().append(";").append(key).append(",").append(key).append(" ").append(caption == null ? "" : caption);
            str = str.append(columnStr);
        }
        return str.toString();
    }

    public String getQueryDomainFileKeys(){
        final StringBuilder str = new StringBuilder(256);
        cache = CacheFactory.getInstance().createCache("mapDomainKeyToFileKey");
        HashMap<String, String> mapDomainKeyToFileKey = new HashMap();
        LoadFileTree.mapDomainKeyToXmlPath.forEach((key, treeNode) -> {
            StringBuilder columnStr;
            columnStr =
                    new StringBuilder().append(treeNode.name.substring(0,treeNode.name.indexOf(".xml"))).append(",").append(treeNode.name.substring(0,treeNode.name.indexOf(".xml"))).append(" ").append(treeNode.description).append(";");
            str.append(columnStr);
            XmlTree xmlTree = null;
            try {
                xmlTree = Xml4jUtil.parseTree(treeNode.key);
            } catch (Throwable e) {
                throw new RuntimeException(e);
            }
            for (Map.Entry<String,AbstractNode> entry : xmlTree.getMapNodes().entrySet()) {
                TagNode node = (TagNode) entry.getValue();
                if(MetaDomain.TAG_NAME.equals(node.getTagName())){
                    mapDomainKeyToFileKey.put(node.getAttributes().get("Key"), treeNode.name.substring(0,treeNode.name.indexOf(".xml")));
                }
            }
        });
        cache.put("mapDomainKeyToFileKey",mapDomainKeyToFileKey);
        return str.toString();
    }

    /***
     * 获取数据元素文件集合
     * @return
     */
    public String getQueryDataElementFileKeys(){
        final StringBuilder str = new StringBuilder(256);
        cache = CacheFactory.getInstance().createCache("mapDataElementKeyToFileKey");
        HashMap<String, String> mapDataElementKeyToFileKey = new HashMap();
        LoadFileTree.mapDataElementKeyToXmlPath.forEach((key, treeNode) -> {
            StringBuilder columnStr;
            columnStr =
                    new StringBuilder().append(treeNode.name.substring(0,treeNode.name.indexOf(".xml"))).append(",").append(treeNode.name.substring(0,treeNode.name.indexOf(".xml"))).append(" ").append(treeNode.description).append(";");
            str.append(columnStr);
            XmlTree xmlTree = null;
            try {
                xmlTree = Xml4jUtil.parseTree(treeNode.key);
            } catch (Throwable e) {
                throw new RuntimeException(e);
            }
            for (Map.Entry<String, AbstractNode> entry : xmlTree.getMapNodes().entrySet()) {
                TagNode node = (TagNode) entry.getValue();
                if(MetaDataElement.TAG_NAME.equals(node.getTagName())){
                    mapDataElementKeyToFileKey.put(node.getAttributes().get("Key"), treeNode.name.substring(0,treeNode.name.indexOf(".xml")));
                }
            }
        });
        cache.put("mapDataElementKeyToFileKey",mapDataElementKeyToFileKey);
        return str.toString();
    }


    public DataTable getDomainData(String domainKey, String domainName, String controlType, String dataType, String domainFileKey) throws Throwable {
        RichDocumentContext context = this.getMidContext();
        MetaForm metaFormKeyDialog = context.getMetaFactory().getMetaForm("D_SetDomainData_Rpt");
        MetaTable gridMetaTable = metaFormKeyDialog.getDataSource().getDataObject().getMetaTable("ED_SetDomainDataDtl");
        DataTable dataTable = WebDesignerDataTableUtil.generateDataTable(gridMetaTable);

        cache = CacheFactory.getInstance().createCache("mapDomainKeyToFileKey");
        HashMap<String, String> mapDomainKeyToFileKey = (HashMap<String, String>) cache.get("mapDomainKeyToFileKey");

        MetaDomainDef domainDef = getMidContext().getMetaFactory().getDomainDef("");
        if (domainDef.getDomainCollection() == null) {
            return dataTable;
        }
        for (MetaDomain metaDomain : domainDef.getDomainCollection()) {
            Boolean result = true;
            if (StringUtils.isNotEmpty(domainKey)) {
                result = result && StringUtils.contains(metaDomain.getKey().toUpperCase(), domainKey.toUpperCase());
            }
            if (StringUtils.isNotEmpty(domainName)) {
                result = result && StringUtils.contains(metaDomain.getCaption().toUpperCase(), domainName.toUpperCase());
            }
            if (StringUtils.isNotEmpty(controlType)) {
                result = result && StringUtils.equals(ControlType.toString(metaDomain.getRefControlType()), controlType);
            }
            if (StringUtils.isNotEmpty(dataType)) {
                result = result && StringUtils.equals(DataType.toString(metaDomain.getDataType()), dataType);
            }
            if (StringUtils.isNotEmpty(domainFileKey)) {
                result = result && StringUtils.equals(mapDomainKeyToFileKey.get(metaDomain.getKey()), domainFileKey);
            }
            if (result) {
                dataTable.append();
                dataTable.setString("DetailDomainKey", metaDomain.getKey());
                dataTable.setString("DetailDomainName", metaDomain.getCaption());
                dataTable.setString("DetailControlType", ControlType.toString(metaDomain.getRefControlType()));
                dataTable.setString("DetailDataType", DataType.toString(metaDomain.getDataType()));
                dataTable.setString("DetailDomainFileKey", mapDomainKeyToFileKey.get(metaDomain.getKey()));
            }
        }
        return dataTable;
    }

    public String beautifySQL(String sqlString) throws Throwable {
        if (sqlString == null) {
            return null;
        }
        String sqlFormat = null;
        try {
            sqlFormat = CCJSqlParserUtil.parse(sqlString).toString();
        } catch (Exception e) {
            //com.bokesoft.yes.log.LogSvr.getInstance().error("SQL格式出错：", e);
            String[] keyWords = {"ADD", "ALL", "ALTER",
                    "ANALYZE", "AND", "AS",
                    "ASC", "ASENSITIVE", "BEFORE",
                    "BETWEEN", "BIGINT", "BINARY",
                    "BLOB", "BOTH", "BY",
                    "CALL", "CASCADE", "CASE",
                    "CHANGE", "CHAR", "CHARACTER",
                    "CHECK", "COLLATE", "COLUMN",
                    "CONDITION", "CONNECTION", "CONSTRAINT",
                    "CONTINUE", "CONVERT", "CREATE",
                    "CROSS", "CURRENT_DATE", "CURRENT_TIME",
                    "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR",
                    "DATABASE", "DATABASES", "DAY_HOUR",
                    "DAY_MICROSECOND", "DAY_MINUTE", "DAY_SECOND",
                    "DEC", "DECIMAL", "DECLARE",
                    "DEFAULT", "DELAYED", "DELETE",
                    "DESC", "DESCRIBE", "DETERMINISTIC",
                    "DISTINCT", "DISTINCTROW", "DIV",
                    "DOUBLE", "DROP", "DUAL",
                    "EACH", "ELSE", "ELSEIF",
                    "ENCLOSED", "ESCAPED", "EXISTS",
                    "EXIT", "EXPLAIN", "FALSE",
                    "FETCH", "FLOAT", "FLOAT4",
                    "FLOAT8", "FOR", "FORCE",
                    "FOREIGN", "FROM", "FULLTEXT",
                    "GRANT", "GROUP",
                    "HAVING", "HIGH_PRIORITY", "HOUR_MICROSECOND",
                    "HOUR_MINUTE", "HOUR_SECOND", "IF",
                    "IGNORE", "IN", "INDEX",
                    "INFILE", "INNER", "INOUT",
                    "INSENSITIVE", "INSERT", "INT",
                    "INT1", "INT2", "INT3",
                    "INT4", "INT8", "INTEGER",
                    "INTERVAL", "INTO", "IS",
                    "ITERATE", "JOIN", "KEY",
                    "KEYS", "KILL", "LABEL",
                    "LEADING", "LEAVE", "LEFT",
                    "LIKE", "LIMIT", "LINEAR",
                    "LINES", "LOAD", "LOCALTIME",
                    "LOCALTIMESTAMP", "LOCK", "LONG",
                    "LONGBLOB", "LONGTEXT", "LOOP",
                    "LOW_PRIORITY", "MATCH", "MEDIUMBLOB",
                    "MEDIUMINT", "MEDIUMTEXT", "MIDDLEINT",
                    "MINUTE_MICROSECOND", "MINUTE_SECOND", "MOD",
                    "MODIFIES", "NATURAL", "NOT",
                    "NO_WRITE_TO_BINLOG", "NULL", "NUMERIC",
                    "ON", "OPTIMIZE", "OPTION",
                    "OPTIONALLY", "OR", "ORDER",
                    "OUT", "OUTER", "OUTFILE",
                    "PRECISION", "PRIMARY", "PROCEDURE",
                    "PURGE", "RAID0", "RANGE",
                    "READ", "READS", "REAL",
                    "REFERENCES", "REGEXP", "RELEASE",
                    "RENAME", "REPEAT", "REPLACE",
                    "REQUIRE", "RESTRICT", "RETURN",
                    "REVOKE", "RIGHT", "RLIKE",
                    "SCHEMA", "SCHEMAS", "SECOND_MICROSECOND",
                    "SELECT", "SENSITIVE", "SEPARATOR",
                    "SET", "SHOW", "SMALLINT",
                    "SPATIAL", "SPECIFIC", "SQL",
                    "SQLEXCEPTION", "SQLSTATE", "SQLWARNING",
                    "SQL_BIG_RESULT", "SQL_CALC_FOUND_ROWS", "SQL_SMALL_RESULT",
                    "SSL", "STARTING", "STRAIGHT_JOIN",
                    "TABLE", "TERMINATED", "THEN",
                    "TINYBLOB", "TINYINT", "TINYTEXT",
                    "TO", "TRAILING", "TRIGGER",
                    "TRUE", "UNDO", "UNION",
                    "UNIQUE", "UNLOCK", "UNSIGNED",
                    "UPDATE", "USAGE", "USE",
                    "USING", "UTC_DATE", "UTC_TIME",
                    "UTC_TIMESTAMP", "VALUES", "VARBINARY",
                    "VARCHAR", "VARCHARACTER", "VARYING",
                    "WHEN", "WHERE", "WHILE",
                    "WITH", "WRITE", "X509",
                    "XOR", "YEAR_MONTH",
                    "ZEROFILL"};
            sqlFormat = sqlString.trim()
                    .replaceAll("\\s+", " ")
                    .replaceAll("\n", " ")
                    .replaceAll("\t", "")
                    .replaceAll("\\(\\s+", "(")
                    .replaceAll("\\s+\\)", ")")
                    .replaceAll("\\s+,\\s+", ", ");
            Matcher matcher;
            for (String word : keyWords) {
                String regex = "\\b" + word + "\\b";
                matcher = Pattern.compile(regex).matcher(sqlFormat.toUpperCase());
                while (matcher.find()) {
                    sqlFormat = sqlFormat.substring(0, matcher.start()) + word + sqlFormat.substring(matcher.end());
                }
            }
        }
        try {
            //独占一行
            String[] singleLineWords = {"FROM", "HAVING", "SELECT", "WHERE", "ORDER BY", "GROUP BY", "VALUES", "UNION ALL"};
            for (String word : singleLineWords) {
                if (sqlFormat.contains(word)) {
                    if (sqlFormat.indexOf(word) == 0) {
                        sqlFormat = StringUtils.replace(sqlFormat, word + " ", word + "\n\t");
                    } else {
                        sqlFormat = StringUtils.replace(sqlFormat, " " + word + " ", "\n" + word + "\n\t");
                        sqlFormat = StringUtils.replace(sqlFormat, "(" + word + " ", "(" + word + "\n\t");
                    }
                }
            }
            //部分关键字换行
            String[] keyWords = {"AND", "OR", "LEFT JOIN", "INNER JOIN" , "JOIN", "IF", "SET", "UNION", "WHEN", "WHILE"};
            for (String word : keyWords) {
                if (sqlFormat.contains(word)) {
                    if (StringUtils.equals(word,"JOIN")) {
                        String[] spiltStrings = sqlFormat.split(" ");
                        int index = Arrays.asList(spiltStrings).indexOf(word);
                        if (index != -1 && !(spiltStrings[index-1].endsWith("INNER") || spiltStrings[index-1].endsWith("LEFT"))){
                            sqlFormat = StringUtils.replace(sqlFormat, " " + word + " ", "\n" + word + " ");
                        }
                    } else {
                        sqlFormat = StringUtils.replace(sqlFormat, " " + word + " ", "\n" + word + " ");
                    }
                }
            }
            //逗号换行
            if (sqlFormat.contains(",")) {
                sqlFormat = StringUtils.replace(sqlFormat, ", ", ",\n\t");
            }
            //添加缩进
            if (sqlFormat.contains("(")) {
                int index = sqlFormat.indexOf("(");
                int lastIndex = sqlFormat.lastIndexOf(")");
                if (lastIndex != -1) {
                    int oriIndent = 0;
                    while (true) {
                        if (sqlFormat.substring(index - oriIndent - 1, index - oriIndent).equals("\t")) {
                            oriIndent = oriIndent + 1;
                        } else {
                            break;
                        }
                    }
                    sqlFormat = sqlFormat.substring(0, index) + addIndent(sqlFormat.substring(index + 1, lastIndex), oriIndent + 1) + sqlFormat.substring(lastIndex + 1);
                }
            }
        } catch (Exception e) {
            return sqlFormat;


        }
        return sqlFormat;
    }

    private String addIndent(String braceString, int num) {
        if (!(braceString.contains(" ") || braceString.contains(",") || braceString.contains("\n"))) {
            return "(" + braceString + ")";
        }
        String result = braceString;
        int index = braceString.indexOf("(");
        int lastIndex = braceString.lastIndexOf(")");
        if (index != -1 && lastIndex != -1) {
            result = braceString.substring(index + 1, lastIndex);
            result = braceString.substring(0, index) + addIndent(result, num + 1);
        }
        for (int i = 0; i < num; i++) {
            result = "\t" + result;
            result = result.replace("\n", "\n\t");
        }
        return "(\n" + result + "\n)";
    }

    public boolean isExistDoman(String key) throws Throwable {
        return MetaUtil.getDomain(getMidContext().getMetaFactory(), key) != null;
    }
    public boolean isExistDataElement(String key) throws Throwable {
        return MetaUtil.getDataElement(getMidContext().getMetaFactory(), key) != null;
    }

    public String checkMacro(String key,String dataSourceType) throws Throwable {
        RichDocument richDocument = _context.getRichDocument();
        if (dataSourceType.isEmpty()){
            dataSourceType = "xml";
        }
        if (!dataSourceType.equalsIgnoreCase("xml")){
            return "true";
        }
        DataTable dataTable = richDocument.get("ED_MacroFormula_Head");
        if (dataTable == null){
            if (key.endsWith("@pre")){
                return "非马甲表单不允许存在@pre结尾宏公式";
            } else if (key.endsWith("@post")){
                return "非马甲表单不允许存在@post结尾宏公式";
            }
            return "true";
        }else {
            String FormKey = dataTable.getString("FormKey");
            if (StringUtils.isNotEmpty(FormKey)) {
                MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(FormKey);
                String extend = metaForm.getExtend();
                if (extend.isEmpty()&&key.endsWith("@pre")){
                    return "非马甲表单不允许存在@pre结尾宏公式";
                } else if (extend.isEmpty()&&key.endsWith("@post")){

                    return "非马甲表单不允许存在@post结尾宏公式";
                }

            } else {
                if (key.endsWith("@pre")){
                    return "非马甲表单不允许存在@pre结尾宏公式";
                } else if (key.endsWith("@post")){
                    return "非马甲表单不允许存在@post结尾宏公式";
                } else {

                }
            }
        }
        return "true";
    }
    public Object changeDomainKey(String key,String name) throws Throwable {
        MetaDomain domain = MetaUtil.getDomain(getMidContext().getMetaFactory(), key);
        switch (name){
            case "DataType":
                return DataType.toString(domain.getDataType());
            case "Precision":
                return domain.getPrecision() == null?0:domain.getPrecision();
            case "Scale":
                return domain.getScale()== null?0:domain.getScale();
            case "Length":
                return domain.getLength() == null?0:domain.getLength();
        }
        return "";
    }

    public void changeDomainKey(String key) throws Throwable {
        if (MetaUtil.getDomain(getMidContext().getMetaFactory(), key) != null) {
            RichDocument richDocument = getMidContext().getRichDocument();
            DataTable ed_newDomain = richDocument.get("ED_NewDomain");
            MetaDomain domain = MetaUtil.getDomain(getMidContext().getMetaFactory(), key);
            ed_newDomain.setObject("DataType", DataType.toString(domain.getDataType()));
            ed_newDomain.setObject("Precision", domain.getPrecision() == null ? 0 : domain.getPrecision());
            ed_newDomain.setObject("Scale", domain.getScale() == null ? 0 : domain.getScale());
            ed_newDomain.setObject("Length", domain.getLength() == null ? 0 : domain.getLength());
            ed_newDomain.setObject("DomainCaption", domain.getCaption() == null ? "" : domain.getCaption());
            ed_newDomain.setObject("DomainNewKey", domain.getKey() == null ? "" : domain.getKey());
            ed_newDomain.setObject("AllowMultiSelection", domain.isAllowMultiSelection() == null ? "" : domain.isAllowMultiSelection());
            ed_newDomain.setObject("Case", domain.getCase() == null ? "" : domain.getCase());
            ed_newDomain.setObject("ItemKey", domain.getItemKey() == null ? "" : domain.getItemKey());
            ed_newDomain.setObject("GroupKey", domain.getGroupKey() == null ? "" : domain.getGroupKey());
            ed_newDomain.setObject("SourceType",ComboBoxSourceType.format(domain.getSourceType() == null ? -1 : domain.getSourceType()) );
//            dataTable.setObject("UseGroupingSeparator", domain.getGroupKey() == null ? "" : domain.getGroupKey());
            Integer refControlType = domain.getRefControlType();
            if (refControlType == null) {
                refControlType = ControlType.TEXTEDITOR;
            }
            ed_newDomain.setObject("ControlType", ControlType.toString(refControlType));
            DataTable ed_defaultItem = richDocument.get("ED_DefaultItem");
            MetaListBoxItemCollection items = domain.getItems();
            if (items != null) {
                ed_defaultItem.clear();
                for (MetaDefaultItem item : items) {
                    String value = item.getValue();
                    String caption = item.getCaption();
                    String icon = item.getIcon();
                    int append = ed_defaultItem.append();
                    ed_defaultItem.setObject(append, "Key", item.getKey());
                    ed_defaultItem.setObject(append, "Value", value);
                    ed_defaultItem.setObject(append, "Caption", caption);
                    ed_defaultItem.setObject(append, "Icon", icon);
                }
                richDocument.addDirtyTableFlag("ED_DefaultItem");

            }
            richDocument.addDirtyTableFlag("ED_NewDomain");
        }
    }
    public Object changeDataElementKey(String key,String name) throws Throwable {
        MetaDataElement dataElement = MetaUtil.getDataElement(getMidContext().getMetaFactory(), key);
        switch (name){
            case "DataType":
                return dataElement.getDataType();
            case "Precision":
                return dataElement.getPrecision() == null?0:dataElement.getPrecision();
            case "Scale":
                return dataElement.getScale()==null?0:dataElement.getScale();
            case "Length":
                return dataElement.getLength()==null?0:dataElement.getLength();
        }



        return "";
    }


    public boolean isExistParaGroup(String key) throws Throwable {
        MetaParaGroup metaParaItems = MetaFactory.getGlobalInstance().getParaTable().get(key);
        if (metaParaItems != null){
            return metaParaItems.isExtend();
        }
        return false;
    }
    public boolean isExistParameter(String key) throws Throwable {
        MetaParameterID metaParaItems = MetaFactory.getGlobalInstance().getParameter().get(key);
        return metaParaItems != null;
    }
    /**
     * DataElementKey下拉框
     *
     * @return
     * @throws Throwable
     */
    public String getDataElementFileKeys(String dataElementPath,String formKey) throws Throwable {
        StringBuilder str = new StringBuilder(256).append("NewDataElementFile,NewDataElementFile 创建新的数据元素文件");
        String formPath = LoadFileTree.getPathByFormKey(formKey);
        LoadFileTree.mapDataElementKeyToXmlPath.forEach((a, b) -> {
            String path;
            if (StringUtils.isNotEmpty(dataElementPath)) {
                path = Paths.get(FilePathHelper.toBackFilePath(dataElementPath)).relativize(Paths.get(b.key)).toString();
            } else if (StringUtils.isNotEmpty(formPath)) {
                path = Paths.get(formPath).relativize(Paths.get(b.key)).toString();
            } else {
                path = b.key;
            }
            StringBuilder rowStr;
            rowStr = new StringBuilder().append(";").append(path).append(",").append(a).append(" ").append(path);
            str.append(rowStr);
        });
        return str.toString();

    }
    /**
     * DomainKey下拉框
     *
     * @return
     * @throws Throwable
     */
    public String getDomainFileKeys(String domainPath,String formKey) throws Throwable {
        StringBuilder str = new StringBuilder(256).append("NewDomainFile,NewDomainFile 创建新的域文件");
        String formPath = LoadFileTree.getPathByFormKey(formKey);
        LoadFileTree.mapDomainKeyToXmlPath.forEach((a, b) -> {
            String path;
            if (StringUtils.isNotEmpty(domainPath)) {
                path = Paths.get(FilePathHelper.toBackFilePath(domainPath)).relativize(Paths.get(b.key)).toString();
            } else if (StringUtils.isNotEmpty(formPath)) {
                path = Paths.get(formPath).relativize(Paths.get(b.key)).toString();
            } else {
                path = b.key;
            }
            StringBuilder rowStr;
            rowStr = new StringBuilder().append(";").append(b.key).append(",").append(a).append(" ").append(path);
            str.append(rowStr);
        });
        return str.toString();

    }
    public String getFilePosition() throws Throwable {
        final IMetaFactory metaFactory = getMidContext().getMetaFactory();
        StringBuilder sb = new StringBuilder(256).append(", 当前作用域");
        MetaProjectCollection projectCollection = metaFactory.getSolution().getProjectCollection();
        for (MetaProjectProfile metaProjectProfile : projectCollection) {
            final MetaProject metaProject = metaProjectProfile.getProject();
            if (Objects.isNull(metaProject)) {
                continue;
            }
            final IMetaSolution solution = metaProject.getSolution();
            final boolean flag = solution instanceof MetaSolution;
            if (!flag) {
                continue;
            }
            MetaSolution metaSolution = (MetaSolution) solution;
            if (!LoadFileTree.isDesignableSolution(metaSolution.getKey())) {
                continue;
            }

            String key = metaProjectProfile.getKey();
            String caption = metaProjectProfile.getCaption();
            caption = RegExUtils.replaceAll(caption, ",", "，");
            caption = RegExUtils.replaceAll(caption, "\\s*", "");

            if (sb.length() > 0) {
                sb.append(";");
            }
            sb.append(key).append(",").append(key).append(" ").append(caption);
        }
        return sb.toString();
    }

    public Boolean checkColumn(String type, String tableKey, String formKey, String columnKey) throws Throwable {
        //默认成功
        String str = "success";
        TwoTuple<MetaForm, MetaDataObject> twoTuple = null;
        twoTuple = publicMethodUtil.MetaFormOrMetaDataObject(formKey);
        boolean metaFormNotNull = twoTuple.metaForm != null;
        boolean metaDataObjectNotNull = twoTuple.metaDataObject != null;
        MetaForm metaForm = twoTuple.metaForm;
        MetaDataObject metaDataObject = twoTuple.metaDataObject;
        if (ConstantUtil.TABLE_KEY.equals(type)) {
            if (metaFormNotNull) {
                MetaTable table = metaForm.getDataSource().getDataObject().getTable(tableKey);
                if (table != null) {
                    str = "当前添加的表标识 " + "<span style = 'color:red;font-size:14px'>" + tableKey + "</span>" + " 已经存在,请勿重复添加";
                }
            } else if (metaDataObjectNotNull) {
                MetaTable table = metaDataObject.getTable(tableKey);
                if (table != null) {
                    str = "当前添加的表标识 " + "<span style = 'color:red;font-size:14px'>" + tableKey + "</span>" + " 已经存在,请勿重复添加";
                }
            }
        } else if (ConstantUtil.COLUMN_KEY.equals(type)) {
            if (metaFormNotNull) {
                MetaColumn metaColumn = metaForm.getDataSource().getDataObject().findColumn(tableKey, columnKey);
                if (metaColumn != null) {
                    str = "当前添加的列标识 " + "<span style = 'color:red;font-size:14px'>" + columnKey + "</span>" + " 已经存在,请勿重复添加";
                }
            } else if (metaDataObjectNotNull) {
                MetaColumn metaColumn = metaDataObject.findColumn(tableKey, columnKey);
                if (metaColumn != null) {
                    str = "当前添加的列标识 " + "<span style = 'color:red;font-size:14px'>" + columnKey + "</span>" + " 已经存在,请勿重复添加";
                }
            }
        }
        if (str != "success") {
            throw new RuntimeException(str);
        } /*else if (type.equals("TableKey")) {
            newDtl();
        }*/
        return true;
    }

    public boolean newDtl() throws Throwable {
        RichDocumentContext midContext = getMidContext();
        RichDocument document = midContext.getRichDocument();
        DataTable tableCollection = document.getDataTable(ConstantUtil.ED_TABLE_COLLECTION);
        Long parentId = tableCollection.getLong(ConstantUtil.OID);
        DataTable tableFields = document.getDataTable(ConstantUtil.ED_TABLE_FIELDS);
        if (tableFields.findRow(ConstantUtil.POID, parentId) == -1) {
            tableFields.append();
            tableFields.setLong(ConstantUtil.POID, parentId);
            tableFields.setString(ConstantUtil.COLUMN_KEY, "OID");
            tableFields.setString("ColumnName", "对象标识");
            tableFields.setString("DataElementKey", "OID");
            tableFields.setString(ConstantUtil.COLUMN_TYPE, MetaUtil.getDataElement(getMidContext().getMetaFactory(), "OID").getDataType().toString());

            tableFields.append();
            tableFields.setLong(ConstantUtil.POID, parentId);
            tableFields.setString(ConstantUtil.COLUMN_KEY, "SOID");
            tableFields.setString("ColumnName", "主对象标识");
            tableFields.setString("DataElementKey", "SOID");
            tableFields.setString(ConstantUtil.COLUMN_TYPE, MetaUtil.getDataElement(getMidContext().getMetaFactory(), "SOID").getDataType().toString());

            tableFields.append();
            tableFields.setLong(ConstantUtil.POID, parentId);
            tableFields.setString(ConstantUtil.COLUMN_KEY, "POID");
            tableFields.setString("ColumnName", "父对象标识");
            tableFields.setString("DataElementKey", "POID");
            tableFields.setString(ConstantUtil.COLUMN_TYPE, MetaUtil.getDataElement(getMidContext().getMetaFactory(), "POID").getDataType().toString());

            tableFields.append();
            tableFields.setLong(ConstantUtil.POID, parentId);
            tableFields.setString(ConstantUtil.COLUMN_KEY, "VERID");
            tableFields.setString("ColumnName", "对象版本");
            tableFields.setString("DataElementKey", "VERID");
            tableFields.setString(ConstantUtil.COLUMN_TYPE, MetaUtil.getDataElement(getMidContext().getMetaFactory(), "VERID").getDataType().toString());

            tableFields.append();
            tableFields.setLong(ConstantUtil.POID, parentId);
            tableFields.setString(ConstantUtil.COLUMN_KEY, "DVERID");
            tableFields.setString("ColumnName", "对象明细版本");
            tableFields.setString("DataElementKey", "DVERID");
            tableFields.setString(ConstantUtil.COLUMN_TYPE, MetaUtil.getDataElement(getMidContext().getMetaFactory(), "DVERID").getDataType().toString());
            document.addDirtyTableFlag(ConstantUtil.ED_TABLE_FIELDS);
            return true;
        }
        return false;
    }

    public Boolean IsReport(String formKey) throws Throwable {
        TwoTuple<MetaForm, MetaDataObject> twoTuple = null;
        twoTuple = publicMethodUtil.MetaFormOrMetaDataObject(formKey);
        boolean metaFormNotNull = twoTuple.metaForm != null;
        if (metaFormNotNull) {
            MetaForm metaForm = twoTuple.metaForm;
            if (metaForm.getFormType() == FormType.Report) {
                return true;
            }
        }
        return false;
    }

    public String getColumnKeyByDataEle(int controlType) throws Throwable {
        RichDocumentContext midContext = getMidContext();
        String ownerFormKey = (String) midContext.getPara("OwnerFormKey");
        String gridKey = (String) midContext.getPara("GridKey");
        MetaForm metaForm = getMidContext().getMetaFactory().getMetaForm(ownerFormKey);
        MetaGrid metaGrid = (MetaGrid) metaForm.getAllUIComponents().get(gridKey);
        String tableKey = metaGrid.getTableKey();
        // 表格创建组件 和表头创建组件 controlType 不一致
        return getColumnKeyByDataEle(tableKey, controlType * 10);
    }

    public String getColumnKeyByDataEle(String tableKey, int controlType) throws Throwable {
        StringBuilder str = new StringBuilder(256).append("无字段,无字段");
        if (StringUtils.isBlank(tableKey)) {
            return str.toString();
        }
        StringBuilder columnStr;
        RichDocumentContext midContext = getMidContext();
        String para = (String)midContext.getDefaultContext().getPara("OwnerFormKey");
        String containerKey = (String)midContext.getDefaultContext().getPara("ContainerKey");
        MetaForm metaForm = getMidContext().getMetaFactory().getMetaForm(para);
        MetaDataSource dataSourse = metaForm.getDataSource();
        MetaTable table = null;
        if (dataSourse != null) {
            table = dataSourse.getDataObject().getTable(tableKey);
        } else if (containerKey != null && !containerKey.isEmpty()) {
            String OtherKey = containerKey;
            metaForm = getMidContext().getMetaFactory().getMetaForm(OtherKey);
            table = metaForm.getDataSource().getDataObject().getTable(tableKey);
        }
        if (Objects.isNull(table)) {
            return str.toString();
        }
        DataTable dataTable = WebDesignerDataTableUtil.generateDataTable(table);
        DataTableMetaData dataTableMetaData = dataTable.getMetaData();
        for (int i = 0, len = dataTableMetaData.getColumnCount(); i < len; i++) {
            ColumnInfo columnInfo = dataTableMetaData.getColumnInfo(i);
            String columnKey = columnInfo.getColumnKey();
            if ("MapCount".equals(columnKey) || "SelectField".equals(columnKey)) {
                continue;
            }
            MetaColumn metaColumn = table.get(columnKey);
            if (metaColumn != null) {
                if (metaColumn.getDataElement() != null && metaColumn.getDataElement().getDomain() != null
                        && metaColumn.getDataElement().getDomain().getRefControlType() == controlType / 10) {
                    String caption = metaColumn.getCaption();
                    caption = RegExUtils.replaceAll(caption, ",", "，");
                    caption = RegExUtils.replaceAll(caption, "\\s*", "");
                    columnStr = new StringBuilder().append(";").append(columnKey).append(",").append(columnKey)
                            .append(" ").append(caption);
                    str = str.append(columnStr);
                }
                if(metaColumn.getDataElement() == null){
                    String caption = metaColumn.getCaption();
                    caption = RegExUtils.replaceAll(caption, ",", "，");
                    caption = RegExUtils.replaceAll(caption, "\\s*", "");
                    columnStr = new StringBuilder().append(";").append(columnKey).append(",").append(columnKey)
                            .append(" ").append(caption);
                    str = str.append(columnStr);
                }
            }
        }
        return str.toString();
    }
    public String getDataElementKeyToGridColumn(String columnKey) throws Throwable {
        RichDocumentContext midContext = getMidContext();
        String ownerFormKey = (String) midContext.getPara("OwnerFormKey");
        String gridKey = (String) midContext.getPara("GridKey");
        MetaForm metaForm = getMidContext().getMetaFactory().getMetaForm(ownerFormKey);
        MetaGrid metaGrid = (MetaGrid) metaForm.getAllUIComponents().get(gridKey);
        String tableKey = metaGrid.getTableKey();
        if(tableKey.contains(ConstantUtil.NODB)){
            return "";
        }
        return getDataElementKey(tableKey,columnKey);
    }

    public String getDataElementKey(String tableKey, String columnKey) throws Throwable {
        RichDocumentContext midContext = getMidContext();
        String para = (String)midContext.getDefaultContext().getPara("OwnerFormKey");
        String containerKey = (String)midContext.getDefaultContext().getPara("ContainerKey");
        MetaForm metaForm = getMidContext().getMetaFactory().getMetaForm(para);
        MetaDataSource dataSourse = metaForm.getDataSource();
        MetaTable table = null;
        if (dataSourse != null) {
            table = dataSourse.getDataObject().getTable(tableKey);
        } else if (containerKey != null && !containerKey.isEmpty()) {
            String OtherKey = containerKey;
            metaForm = getMidContext().getMetaFactory().getMetaForm(OtherKey);
            table = metaForm.getDataSource().getDataObject().getTable(tableKey);
        }
        if (table == null)
            return "";
        MetaColumn metaColumn = table.get(columnKey);
        if (metaColumn == null)
            return "";
        return metaColumn.getDataElementKey();
    }


    public String getItemKeyByDataElementKey(String dataElementKey) throws Throwable {
        RichDocumentContext midContext = getMidContext();
        MetaDataElement dataElement = MetaUtil.getDataElement(midContext.getMetaFactory(), dataElementKey);
        if (dataElement == null)
            return "";
        MetaDomain domain = dataElement.getDomain();
        if (domain == null)
            return "";
        return domain.getItemKey() == null ? "" : domain.getItemKey();
    }

    public boolean isNewColumnToGrid(String columnKey) throws Throwable{
        if (columnKey.isEmpty()){
            return true;
        }
        RichDocumentContext midContext = getMidContext();
        String ownerFormKey = (String) midContext.getPara("OwnerFormKey");
        String gridKey = (String) midContext.getPara("GridKey");
        MetaForm metaForm = getMidContext().getMetaFactory().getMetaForm(ownerFormKey);
        MetaGrid metaGrid = (MetaGrid) metaForm.getAllUIComponents().get(gridKey);
        String tableKey = metaGrid.getTableKey();
        if(tableKey.contains(ConstantUtil.NODB)){
            return true;
        }
        return isNewColumn(tableKey, columnKey);
    }

    public boolean isNewColumn(String tableKey, String columnKey) throws Throwable{
        RichDocumentContext midContext = getMidContext();
        String para = (String)midContext.getDefaultContext().getPara("OwnerFormKey");
        String containerKey = (String)midContext.getDefaultContext().getPara("ContainerKey");
        MetaForm metaForm = getMidContext().getMetaFactory().getMetaForm(para);
        MetaDataSource dataSourse = metaForm.getDataSource();
        MetaTable table = null;
        if (dataSourse != null) {
            table = dataSourse.getDataObject().getTable(tableKey);
        } else if (containerKey != null && !containerKey.isEmpty()) {
            String OtherKey = containerKey;
            metaForm = getMidContext().getMetaFactory().getMetaForm(OtherKey);
            table = metaForm.getDataSource().getDataObject().getTable(tableKey);
        }
        if (table == null) return true;
        MetaColumn metaColumn = table.get(columnKey);
        return metaColumn == null ? true : metaColumn.getDataElement() == null ;
    }

    public String getDataElementsByDomainKey(String domainKey, String formKey) throws Throwable{
        RichDocumentContext midContext = getMidContext();
        StringBuilder sb = new StringBuilder(256);
        String solutionKey;
        if(StringUtils.isEmpty(formKey)){
            solutionKey = "";
        }else{
            MetaProject project = (MetaProject) midContext.getMetaFactory().getMetaFormList().get(formKey).getProject();
            MetaSolution solution = (MetaSolution) project.getSolution();
            solutionKey = solution.getKey();
        }
        MetaDataElementDef dataElementDef = midContext.getMetaFactory().getDataElementDef(solutionKey);
        if(dataElementDef == null)
            return sb.toString();
        MetaDataElementCollection dataElementCollection = dataElementDef.getDataElementCollection();
        if(dataElementCollection == null)
            return sb.toString();
        Iterator<MetaDataElement> iterator = dataElementCollection.iterator();
        while (iterator.hasNext()){
            MetaDataElement metaDataElement = iterator.next();
            if(metaDataElement.getDomainKey() == null || !metaDataElement.getDomainKey().equals(domainKey))
                continue;
            if(sb.length() > 0)
                sb.append(";");
            sb.append(metaDataElement.getKey()).append(",").append(" ").append(metaDataElement.getCaption().replaceAll(","," "));
        }
        return sb.toString();
    }

    public void setDataElementInfo(String dataElementKey) throws Throwable {
        MetaDataElement dataElement = MetaUtil.getDataElement(getMidContext().getMetaFactory(), dataElementKey);
        if (dataElement == null)
            return;
        RichDocument richDocument = getMidContext().getRichDocument();
        DataTable ed_NewDataElement = richDocument.get("ED_NewDataElement");
        ed_NewDataElement.setObject("DataElementCaption", StringUtils.isEmpty(dataElement.getCaption()) ? "" : dataElement.getCaption());
        ed_NewDataElement.setObject("ParamID", StringUtils.isEmpty(dataElement.getParamID()) ? "" : dataElement.getParamID());
        ed_NewDataElement.setObject("DefaultCaption", StringUtils.isEmpty(dataElement.getDefaultCaption()) ? "" : dataElement.getDefaultCaption());
        ed_NewDataElement.setObject("DataDiffLog", dataElement.getDataDiffLog() == null ? false : true);
        ed_NewDataElement.setObject("NoHistory", dataElement.getNoHistory() == null ? false : true);
        DataTable ed_fieldLabelCollection = richDocument.get("ED_FieldLabelCollection");
        MetaFieldLabelCollection fieldLabelCollection = dataElement.getFieldLabelCollection();
        if (fieldLabelCollection != null) {
            ed_fieldLabelCollection.clear();
            for (MetaFieldLabel label : fieldLabelCollection) {
                int append = ed_fieldLabelCollection.append();
                ed_fieldLabelCollection.setObject(append, "Key", label.getKey());
                ed_fieldLabelCollection.setObject(append, "Length", label.getLength());
                ed_fieldLabelCollection.setObject(append, "Text", StringUtils.isEmpty(label.getText()) ? "" : label.getText());
            }
            richDocument.addDirtyTableFlag("ED_NewDataElement");

        }
        richDocument.addDirtyTableFlag("ED_NewDataElement");
    }

    public String getControlType(String controlType) throws Throwable{
        if(StringUtils.isEmpty(controlType))
            return ControlType.STR_TEXTEDITOR;
        int num = Integer.parseInt(controlType);
        if(controlType.length() > 3){
            num = num / 10;
        }
        return ControlType.toString(num);
    }

    public String getFileTreeIcon(String type, String name,String parentKey){
        String iconPath = "webdesigner/fileTree/";
        String fileName = "";
        String realName = name.split(" ")[0];
        boolean isForm = parentKey.endsWith("Form");
        if ("solution".equals(type) || "importsolution".equals(type) || "jarsolution".equals(type)){
            fileName = "Solution.png";
        }else if ("project".equals(type)){
            fileName = "Project.png";
        }else if("file".equals(type)){
            fileName = "XML.png";
        }else if("fold".equals(type)){
            if ("BPM".equals(realName)){
                fileName = "BPM.png";
            }else if ("Custom".equals(realName) || "DataMap".equals(realName) || "DataStruct".equals(realName)){
                fileName = "DataMap.png";
            }else if ("DataMigration".equals(realName)){
                fileName = "DataMigration.png";
            }else if ("DataObject".equals(realName)){
                fileName = "DataObject.png";
            }else if ("ExcelTemplate".equals(realName) || ("Report".equals(realName) && !isForm)){
                fileName = "Report.png";
            }else if ("i18n".equals(realName)){
                fileName = "i18n2.png";
            }else if ("Form".equals(realName) || "Template".equals(realName)){
                fileName = "Form.png";
            }else if ("initializeData".equals(realName)){
                fileName = "hot.png";
            }else if ("RelationCheck".equals(realName)){
                fileName = "Relation.png";
            }else if ("DataElement".equals(realName) || "Domain".equals(realName)){
                fileName = "BPMItem.png";
            }else if (isForm){
                fileName = "Fold.png";
            }else {
                fileName = "Empty.png";
            }
        }
        iconPath = iconPath + fileName;
        return iconPath;
    }

    public boolean hasExtensionForm(String sourceFormKey) throws Throwable {
        if(sourceFormKey.isEmpty()) return false;
        MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(sourceFormKey);
        MetaForm extensionForm = ExtensionUtil.newDefaultProvider().getExtMetaForm(getMidContext(), metaForm);
        return extensionForm != null;
    }

    public DataTable getDataElementData(String dataElementKey, String dataElementName, String DataElementFileKey,
                                        String domainKey, String domainName, String controlType, String dataType, String domainFileKey) throws Throwable {
        RichDocumentContext context = this.getMidContext();
        MetaForm metaFormKeyDialog = context.getMetaFactory().getMetaForm("D_SetDataElement_Rpt");
        MetaTable gridMetaTable =
                metaFormKeyDialog.getDataSource().getDataObject().getMetaTable("ED_SetDataElementDtl");
        DataTable dataTable = WebDesignerDataTableUtil.generateDataTable(gridMetaTable);
        List<String> dataElementKeyList = new ArrayList<>();

        cache = CacheFactory.getInstance().createCache("mapDataElementKeyToFileKey");
        HashMap<String, String> mapDataElementKeyToFileKey = (HashMap<String, String>) cache.get("mapDataElementKeyToFileKey");
        cache = CacheFactory.getInstance().createCache("mapDomainKeyToFileKey");
        HashMap<String, String> mapDomainKeyToFileKey = (HashMap<String, String>) cache.get("mapDomainKeyToFileKey");
        MetaDataElementDef dataElementDef = getMidContext().getMetaFactory().getDataElementDef();

        if (dataElementDef.getDataElementCollection() == null) {
            return dataTable;
        }
        MetaDomainDef domainDef = getMidContext().getMetaFactory().getDomainDef();
        if (domainDef.getDomainCollection() == null) {
            return dataTable;
        }
        for (MetaDataElement metaDataElement : dataElementDef.getDataElementCollection()) {
            MetaDomain metaDomain = domainDef.getDomainCollection().get(metaDataElement.getDomainKey());
            Boolean result = true;
            if (StringUtils.isNotEmpty(dataElementKey)) {
                result = result && StringUtils.contains(metaDataElement.getKey().toUpperCase(), dataElementKey.toUpperCase());
            }
            if (StringUtils.isNotEmpty(dataElementName)) {
                result = result && StringUtils.contains(metaDataElement.getCaption() == null ? "" : metaDataElement.getCaption().toUpperCase(), dataElementName.toUpperCase());
            }
            if (StringUtils.isNotEmpty(DataElementFileKey)) {
                result = result && StringUtils.equals(mapDataElementKeyToFileKey.get(metaDataElement.getKey()), DataElementFileKey);
            }
            if (StringUtils.isNotEmpty(domainKey)) {
                result = result && StringUtils.contains(metaDomain.getKey().toUpperCase(), domainKey.toUpperCase());
            }
            if (StringUtils.isNotEmpty(domainName)) {
                result = result && StringUtils.contains(metaDomain.getCaption() == null ? "" : metaDomain.getCaption().toUpperCase(), domainName.toUpperCase());
            }
            if (StringUtils.isNotEmpty(controlType)) {
                result = result && StringUtils.equals(ControlType.toString(metaDomain.getRefControlType()), controlType);
            }
            if (StringUtils.isNotEmpty(dataType)) {
                result = result && StringUtils.equals(DataType.toString(metaDomain.getDataType()), dataType);
            }
            if (StringUtils.isNotEmpty(domainFileKey)) {
                result = result && StringUtils.equals(mapDomainKeyToFileKey.get(metaDomain.getKey()), domainFileKey);
            }
            if (result) {
                dataTable.append();
                dataTable.setString("DetailDataElementKey", metaDataElement.getKey());
                dataTable.setString("DetailDataElementName", metaDataElement.getCaption());
                dataTable.setString("DetailDataElementFileKey",  mapDataElementKeyToFileKey.get(metaDataElement.getKey()));
                dataTable.setString("DetailDomainKey", metaDomain.getKey());
                dataTable.setString("DetailDomainName", metaDomain.getCaption());
                dataTable.setString("DetailControlType", ControlType.toString(metaDomain.getRefControlType()));
                dataTable.setString("DetailDataType", DataType.toString(metaDomain.getDataType()));
                dataTable.setString("DetailDomainFileKey", mapDomainKeyToFileKey.get(metaDomain.getKey()));
            }
        }
        return dataTable;
    }

    public DataTable getUnusedSystemField(String dataObjectKey, String tableKey) throws Throwable {
        MetaDataObject dataObject = MetaFactory.getGlobalInstance().getDataObject(dataObjectKey);
        RichDocumentContext context = this.getMidContext();
        MetaForm metaFormKeyDialog = context.getMetaFactory().getMetaForm("D_SetSystemRow_Rpt");
        MetaTable gridMetaTable =
                metaFormKeyDialog.getDataSource().getDataObject().getMetaTable("ED_SetSystemRowDtl");
        DataTable dataTable = WebDesignerDataTableUtil.generateDataTable(gridMetaTable);
        XmlDiffProcessor.PRIMARY_TABLE_COLUMN_LIST.stream()
                .filter(itemMap -> {
                    String key = itemMap.get(ConstantUtil.KEY);
                    if (dataObject == null || dataObject.getTable(tableKey) == null) {
                        return true;
                    } else {
                        MetaTable table = dataObject.getTable(tableKey);
                        return !table.containsKey(key);
                    }
                }).forEach(itemMap -> {
                    dataTable.append();
                    dataTable.setString(ConstantUtil.FIELD_KEY, itemMap.get(ConstantUtil.KEY));
                    dataTable.setString(ConstantUtil.CAPTION, itemMap.get(ConstantUtil.CAPTION));
                    dataTable.setString(ConstantUtil.DataElementKey, itemMap.get(ConstantUtil.DataElementKey));
        });
        return dataTable;
    }

    public void addSystemRow(String datas, String tableKey) throws Throwable{
        if(StringUtils.isEmpty(datas) ){
            return;
        }
        RichDocumentContext context = this.getMidContext();
        RichDocument parentDocument = context.getParentDocument();
        Long poid = -1L;
        DataTable ed_tableCollection = parentDocument.getDataTable("ED_TableCollection");
        for (int i = 0; i < ed_tableCollection.size(); i++) {
            String tableMark = ed_tableCollection.getString("TableMark");
            if(tableMark.equals(tableKey)){
                poid = ed_tableCollection.getLong(ConstantUtil.OID);
            }
        }
        if(poid < 0){
            return;
        }
        JSONArray jsonArray = new JSONArray(datas);
        DataTable ed_tableFields = parentDocument.getDataTable("ED_TableFields");
        for (int i = 0; i < jsonArray.length(); i++) {
            JSONObject data = jsonArray.getJSONObject(i);
            ed_tableFields.append();
            ed_tableFields.setString(ConstantUtil.COLUMN_KEY, data.getString(ConstantUtil.FIELD_KEY));
            ed_tableFields.setString("ColumnName", data.getString(ConstantUtil.CAPTION));
            String dataElementKey = data.getString(ConstantUtil.DataElementKey);
            ed_tableFields.setString(ConstantUtil.DataElementKey, dataElementKey);
            ed_tableFields.setLong(ConstantUtil.POID, poid);
            MetaDataElement dataElement = MetaUtil.getDataElement(getMidContext().getMetaFactory(), dataElementKey);
            if(dataElement != null){
                ed_tableFields.setInt("ColumnType", dataElement.getDataType());
                ed_tableFields.setInt("Precision", dataElement.getPrecision() == null?0:dataElement.getPrecision());
                ed_tableFields.setInt("Scale",  dataElement.getScale()==null?0:dataElement.getScale());
                ed_tableFields.setInt("Length",  dataElement.getLength()==null?0:dataElement.getLength());
            }

            ed_tableFields.setString("IsPrimaryKey","false");
            ed_tableFields.setString("SupportI18n","false");
            ed_tableFields.setString("Persist","1");
            ed_tableFields.setString("NeedRights","0");
            ed_tableFields.setString("SortType","0");
        }
        parentDocument.addDirtyTableFlag("ED_TableFields");
    }
    public  String GetActiveValue() throws Throwable {
        StringBuffer sql = new StringBuffer();
        StringBuffer sb = new StringBuffer();
        sql.append("Select m.Code, t.Name From " + "EAU_AuthorityActivity"  + " m left join " + "EAU_AuthorityActivity"+ MetaTable._T + " t on m.SOID = t.SOID and t.Lang = ?");
        List<Object> values = new ArrayList<Object>();
        values.add(getMidContext().getEnv().getLocale());
        IDBManager dbManager = getMidContext().getDBManager();
        DataTable table = dbManager.execPrepareQuery(sql.toString(), values);
        table.beforeFirst();
        while (table.next()) {
            String name = table.getString(SystemField.NAME_DICT_KEY);
            String code = table.getString(SystemField.CODE_DICT_KEY);
            if(sb.length() > 0){
                sb.append(";");
            }
            sb.append(code).append(",").append(code).append(" ").append(name.replaceAll(","," "));
        }
        return sb.toString();
    }
    public  String GetTCodeValue() throws Throwable {
        StringBuffer sql = new StringBuffer();
        StringBuffer sb = new StringBuffer();
        sql.append("Select m.Code, t.Name From " + "EGS_TCode"  + " m left join " + "EGS_TCode"+ MetaTable._T + " t on m.SOID = t.SOID and t.Lang = ?");
        List<Object> values = new ArrayList<Object>();
        values.add(getMidContext().getEnv().getLocale());
        IDBManager dbManager = getMidContext().getDBManager();
        DataTable table = dbManager.execPrepareQuery(sql.toString(), values);
        table.beforeFirst();
        while (table.next()) {
            String name = table.getString(SystemField.NAME_DICT_KEY);
            if(name == null){
                name = "";
            }
            String code = table.getString(SystemField.CODE_DICT_KEY);
            if(sb.length() > 0){
                sb.append(";");
            }
            sb.append(code).append(",").append(code).append(" ").append(name.replaceAll(","," "));
        }
        return sb.toString();
    }
    public DataTable getBreakpoint(long oid) throws Throwable {
        RichDocumentContext context = this.getMidContext();
        MetaTable metaTable = context.getDataObject().getMetaTable(Constants.TBL_BREAKPOINT);
        DataTable dataTable = WebDesignerDataTableUtil.generateDataTable(metaTable);

        Breakpoint breakpoint = DebuggerFacade.getBreakpoint(oid);
        int rowIndex = dataTable.append();
        if (Objects.isNull(breakpoint)) {
            dataTable.setLong(rowIndex, "OID", context.applyNewOID());
            dataTable.setString(rowIndex, "Type", "Expr");
            dataTable.setString(rowIndex, "ScriptText", "");
            dataTable.setString(rowIndex, "Condition", "");
            dataTable.setBoolean(rowIndex, "IsEnable", true);
        } else {
            dataTable.setLong(rowIndex, "OID", oid);
            dataTable.setString(rowIndex, "Type", String.valueOf(breakpoint.getType()));
            dataTable.setString(rowIndex, "ScriptText", breakpoint.getText());
            dataTable.setString(rowIndex, "Condition", breakpoint.getCondition());
            dataTable.setBoolean(rowIndex, "IsEnable", breakpoint.getEnable());
        }
        context.getRichDocument().addDirtyTableFlag(Constants.TBL_BREAKPOINT);
        return dataTable;
    }

    public void saveBreakpoint() throws Throwable {
        RichDocument document = this.getDocument();
        DataTable dataTable = document.getDataTable(Constants.TBL_BREAKPOINT);
        Long oid = dataTable.getLong(ConstantUtil.OID);
        Optional<Breakpoint> optional = Optional.ofNullable(DebuggerFacade.getBreakpoint(oid));
        Breakpoint breakpoint = optional.orElse(new Breakpoint());
        breakpoint.setOid(oid);
        breakpoint.setEnable(dataTable.getBoolean("IsEnable"));
        breakpoint.setType(dataTable.getString("Type"));
        breakpoint.setText(dataTable.getString("ScriptText"));
        breakpoint.setCondition(dataTable.getString("Condition"));

        RichDocumentContext context = this.getMidContext();
        RichDocument parentDocument = context.getParentDocument();
        DataTable dataTableList = parentDocument.getDataTable(Constants.TBL_BREAKPOINT_LIST);
        int rowIndex = optional.map(item -> dataTableList.getPos()).orElseGet(dataTableList::append);
        dataTableList.setLong(rowIndex, "OID", breakpoint.getOid());
        dataTableList.setString(rowIndex, "Type", String.valueOf(breakpoint.getType()));
        dataTableList.setString(rowIndex, "ScriptText", breakpoint.getText());
        dataTableList.setString(rowIndex, "Condition", breakpoint.getCondition());
        dataTableList.setBoolean(rowIndex, "IsEnable", breakpoint.getEnable());
        dataTableList.setString(rowIndex, "EditButton", "编辑");
        dataTableList.setString(rowIndex, "DeleteButton", "删除");
        parentDocument.addDirtyTableFlag(Constants.TBL_BREAKPOINT_LIST);

        DebuggerFacade.saveBreakpoint(breakpoint);
    }

    public void deleteBreakpoint(Long oid) throws Throwable {
        RichDocument document = this.getDocument();
        DataTable dataTable = document.getDataTable(Constants.TBL_BREAKPOINT_LIST);
        int size = dataTable.size();
        for (int rowIndex = size - 1; rowIndex >= 0; rowIndex--) {
            Long aLong = dataTable.getLong(rowIndex, "OID");
            if (!Objects.equals(aLong, oid)) {
                continue;
            }
            dataTable.delete(rowIndex);
            document.addDirtyTableFlag(Constants.TBL_BREAKPOINT_LIST);
            DebuggerFacade.deleteBreakpoint(oid);
            return;
        }
    }

    public void deleteAllBreakpoint() throws Throwable {
        RichDocument document = this.getDocument();
        DataTable dataTable = document.getDataTable(Constants.TBL_BREAKPOINT_LIST);
        dataTable.deleteAll();
        document.addDirtyTableFlag(Constants.TBL_BREAKPOINT_LIST);
        DebuggerFacade.clearBreakpoint();
    }

    public void toggleBreakpoint(Long oid) throws Throwable {
        Breakpoint breakpoint = DebuggerFacade.getBreakpoint(oid);
        if (Objects.isNull(breakpoint)) {
            return;
        }
        RichDocument document = this.getDocument();
        DataTable dataTable = document.getDataTable(Constants.TBL_BREAKPOINT_LIST);
        breakpoint.setEnable(dataTable.getBoolean("IsEnable"));
        DebuggerFacade.saveBreakpoint(breakpoint);
    }

    public void toggleDebugger(boolean enable) throws Throwable {
        RichDocument document = this.getDocument();
        DataTable dataTable = document.getDataTable(Constants.TBL_TOOLBAR);
        dataTable.setInt("ToggleEnableVisible", enable ? 0 : 1);
        document.addDirtyTableFlag(Constants.TBL_TOOLBAR);

        DebuggerFacade.toggleDebugger(enable);
    }

    public <EC extends IEvalContext> boolean toggleStack(int oid) throws Throwable {
        if (oid < 0) {
            return false;
        }
        RichDocument document = this.getDocument();
        DebuggerContext<EC> debuggerContext = DebuggerContext.getInstance();
        SyntaxTreeWrapper<EC> syntaxTreeWrapper = debuggerContext.getSyntaxTreeWrapperMap().get(oid);

        DataTable dataTable = document.getDataTable(Constants.TBL_VARIANT_LIST);
        dataTable.clear();
        IOMetaObject.paddingVariant(dataTable, syntaxTreeWrapper);
        document.addDirtyTableFlag(Constants.TBL_VARIANT_LIST);

        dataTable = document.getDataTable(Constants.TBL_SYNTAX_TREE);
        dataTable.clear();
        IOMetaObject.paddingSyntaxTree(dataTable, syntaxTreeWrapper);
        document.addDirtyTableFlag(Constants.TBL_SYNTAX_TREE);
        return true;
    }

    public void operateDebugger(String operateType) {
        DebuggerFacade.operateDebugger(OperateTypeEnum.getEnum(operateType));
    }

    public boolean isText(String value) {
        return StringUtils.equals(value, "Text");
    }

    public boolean isNumber(String value) {
        return StringUtils.equals(value, "Number");
    }

    public boolean isBoolean(String value) {
        return StringUtils.equals(value, "Boolean");
    }
    public boolean CanVisible(String formKey) throws Throwable {
        String ownerFormKey = (String) _context.getPara("OwnerFormKey");
        if (MetaFactory.getGlobalInstance().getMetaFormList().get(ownerFormKey) ==null){
            return false;
        }
        return !MetaFactory.getGlobalInstance().getMetaForm(ownerFormKey).getExtend().isEmpty();
    }

    public String getParamID() throws Throwable{
        StringBuilder sb = new StringBuilder(256);
        MetaParameter parameter = this._context.getMetaFactory().getParameter();
        if(parameter == null){
            return sb.toString();
        }
        for (int i = 0; i < parameter.size(); i++) {
            MetaParameterID metaParameterID = parameter.get(i);
            String key = metaParameterID.getKey();
            String description = metaParameterID.getDescription();
            if(sb.length() > 0)
                sb.append(";");
            sb.append(key).append(",").append(" ").append(description.replaceAll(","," "));
        }
        return sb.toString();
    }
}
