package com.bokesoft.yes.design.function;

import com.bokesoft.erp.entity.util.EntityDesigerContextAction;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import java.io.File;
import java.nio.file.Paths;
import java.util.List;

public class CompositeComponentUtil extends EntityDesigerContextAction {
    public CompositeComponentUtil(RichDocumentContext _context) {
        super(_context);
    }

    public String getCompositeComponentList() throws Throwable {
        StringBuilder sb = new StringBuilder(256);
        Element node = getCompositeComponentRoot();
        List<Element> compositeComponents = node.elements("CompositeComponent");
        for (int i = 0; i < compositeComponents.size(); i++){
            Element element = compositeComponents.get(i);
            String key = element.attributeValue(ConstantUtil.KEY);
            String caption = element.attributeValue(ConstantUtil.CAPTION);
            if (sb.length() > 0) {
                sb.append(";");
            }
            sb.append(key).append(",").append(" ").append(caption);
        }
        return sb.toString();
    }

    public static Element getCompositeComponentRoot() throws Throwable{
        String solutionPath = LoadFileTree.getSolutionPath(ConstantUtil.SolutionKey);
        String entryPath = Paths.get(solutionPath, File.separator + "Resource" + File.separator + "designer" + File.separator + ConstantUtil.CompositeComponentFileName).toString();
        // 创建SAX读取器
        SAXReader reader = new SAXReader();
        // 加载文档
        Document document = reader.read(new File(entryPath));
        Element node = document.getRootElement();
        return node;
    }
}
