package com.bokesoft.yes.design.form;

import java.util.HashMap;

public class FormDesignPropertyDefine {

	//表单属性集合
	private static final String FormProperties_XML = " " +
			"<Property Key=\"FormType\" Caption=\"表单类型\" Editable=\"false\" Control=\"Combobox\" DefaultValue=\"Normal\" " +
			"OnInitialize=\"Normal,普通;Entity,实体;Dict,字典;View,视图;Detail,明细;Report,报表;ChainDict,链式字典;CompDict,复合字典;Template,模版;Extension,扩展\"/>"
			+ "<Property Key=\"Key\" Caption=\"表单标识\" Control=\"TextEditor\" Editable=\"false\"/>"
			+ "<Property Key=\"Caption\" Caption=\"表单名称\" Control=\"TextEditor\"/>"
			+ "<Property Key=\"Description\" Caption=\"描述\" Control=\"TextEditor\"/>"
			+ "<Property Key=\"FormulaCaption\" Caption=\"表达式名称\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog(\"{self.key}\",{{self.value}})'/>"
			+ "<Property Key=\"CaptionDependency\" Caption=\"表达式名称依赖字段\" Control=\"TextEditor\"/>"
			+ "<Property Key=\"AbbrCaption\" Caption=\"缩写名称\" Control=\"TextEditor\"/>"
			+ "<Property Key=\"FormulaAbbrCaption\" Caption=\"表达式缩写名称\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog(\"{self.key}\",{{self.value}})'/>"
			+ "<Property Key=\"AliasKey\" Caption=\"别名标识\" Control=\"ComboBoxEditor\" OnInitialize=\"=Macro_getAllForms()\"/>"
			+ "<Property Key=\"InitState\" Caption=\"表单打开状态\" Control=\"Combobox\" OnInitialize=\"Default,默认;New,新增;Edit,修改;Delete,删除\" DefaultValue=\"Edit\"/>"
			+ "<Property Key=\"Platform\" Caption=\"支持平台\" Control=\"Combobox\" OnInitialize=\"All,所有平台;PC,电脑端;Mobile,移动端\" DefaultValue=\"All\"/>"
			+ "<Property Key=\"ConfirmClose\" Caption=\"关闭确认\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"true\"/>"
			+ "<Property Key=\"OnLoad\" Caption=\"加载事件\" Control=\"ButtonEditor\" Type=\"CDATA\" OnButtonClick='Macro_ShowFormulaDialog(\"{self.key}\",{{self.value}})'/>"
			+ "<Property Key=\"OnPostShow\" Caption=\"加载后事件\" Control=\"ButtonEditor\" Type=\"CDATA\" OnButtonClick='Macro_ShowFormulaDialog(\"{self.key}\",{{self.value}})'/>"
			+ "<Property Key=\"OnClose\" Caption=\"关闭事件\" Control=\"ButtonEditor\" Type=\"CDATA\" OnButtonClick='Macro_ShowFormulaDialog(\"{self.key}\",{{self.value}})'/>"
			+ "<Property Key=\"UseVariant\" Caption=\"启用表单变体\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>"
			+ "<Property Key=\"FormDisplay\" Caption=\"表单是否已经打开\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>"
			+ "<Property Key=\"Extend\" Caption=\"继承的表单标识\" Control=\"ComboBoxEditor\" OnInitialize=\"=Macro_getAllForms()\"/>"
			+ "<Property Key=\"SourceForm\" Caption=\"源表单标识\" Control=\"ComboBoxEditor\" OnInitialize=\"=Macro_getAllForms()\" Editable=\"false\"/>"
			+ "<Property Key=\"ViewKey\" Caption=\"关联的视图\" Control=\"ComboBoxEditor\" OnInitialize=\"=Macro_getAllForms()\"/>"
			+ "<Property Key=\"LinkedFormKey\" Caption=\"关联表单标识\" Control=\"ComboBoxEditor\" OnInitialize=\"=Macro_getAllForms()\"/>"
			+ "<Property Key=\"UserData\" Caption=\"用户自定义数据\" Control=\"TextEditor\"/>"
			+ "<Property Key=\"MergeToSource\" Caption=\"合并至源单\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>"
			+ "<Property Key=\"I18N\" Caption=\"多语言表单\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>"
			+ "<Property Key=\"Version\" Caption=\"配置版本\" Control=\"TextEditor\" Editable=\"false\"/>"
			+ "<Property Key=\"PopWidth\" Caption=\"弹出窗宽度\" Node='Body' Group=\"弹出视图大小\" Control=\"DefSizeEditor\"/>"
			+ "<Property Key=\"PopHeight\" Caption=\"弹出窗高度\" Node='Body' Group=\"弹出视图大小\" Control=\"DefSizeEditor\"/>"

			+ "<Property Key=\"Authenticate\" Caption=\"认证登录\" Group=\"移动端属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"true\"/>"
			+ "<Property Key=\"HasNavigationBar\" Caption=\"持有导航条\" Group=\"移动端属性\" Control=\"Combobox\" OnInitialize=\",;true,是;false,否\"/>"
			+ "<Property Key=\"ScreenOrientation\" Caption=\"屏幕方向\" Group=\"移动端属性\" Control=\"Combobox\" OnInitialize=\"unspecified,默认;portrait,竖屏;landscape,横屏\" DefaultValue=\"unspecified\"/>"
			+ "<Property Key=\"FullScreenType\" Caption=\"全屏类型\" Group=\"移动端属性\" Control=\"Combobox\" OnInitialize=\",;Normal,默认;FullScreen,全屏;Immersive,沉浸式\"/>"
			+ "<Property Key=\"StatusBarColor\" Caption=\"状态栏颜色\" Group=\"移动端属性\" Control=\"ColorEditor\"/>"
			+ "<Property Key=\"OffLine\" Caption=\"离线表单\" Group=\"移动端属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>";

	//基础属性集合
	private static final String BaseProperties_XML = " "
			+ "<Property Key=\"ControlType\" Caption=\"控件类型\" Group=\"基础属性\" Control=\"TextEditor\" Editable=\"false\"/>"
			+ "<Property Key=\"Key\" Caption=\"标识\" Group=\"基础属性\" Control=\"TextEditor\"/>"
			+ "<Property Key=\"Caption\" Caption=\"名称\" Group=\"基础属性\" Control=\"TextEditor\"/>"
			+ "<Property Key=\"FormulaCaption\" Caption=\"表达式名称\" Group=\"基础属性\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog(\"{self.key}\",{{self.value}})'/>"
			+ "<Property Key=\"CaptionDependency\" Caption=\"表达式名称依赖\" Group=\"基础属性\" Control=\"TextEditor\"/>"
			+ "<Property Key=\"Enable\" Caption=\"可用性\" Group=\"基础属性\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog(\"{self.key}\",{{self.value}})'/>"
			+ "<Property Key=\"EnableDependency\" Caption=\"可用性依赖\" Group=\"基础属性\" Control=\"TextEditor\"/>"
			+ "<Property Key=\"Visible\" Caption=\"可见性\" Group=\"基础属性\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog(\"{self.key}\",{{self.value}})'/>"
			+ "<Property Key=\"VisibleDependency\" Caption=\"可见性依赖\" Group=\"基础属性\" Control=\"TextEditor\"/>"
			+ "<Property Key=\"BuddyKey\" Caption=\"伙伴组件\" Group=\"基础属性\" Control=\"ComboBoxEditor\" OnInitialize=\"=Macro_getAllComponentInForm(Para('formID'))\" Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"TableKey\" Caption=\"关联表标识\" Group=\"数据关联\" Node='DataBinding' Control=\"ComboBoxEditor\" OnInitialize=\"=Macro_getAllTableKey()\" Visible='Macro_IsBaseControl() && !Macro_InSubDetail(GetPropertyValue(\"Key\"))'/>"
			+ "<Property Key=\"ColumnKey\" Caption=\"关联字段标识\" Group=\"数据关联\" Node='DataBinding' Control=\"ComboBoxEditor\" OnInitialize=\"=Macro_getAllColumnKey(GetPropertyValue('TableKey','','DataBinding'))\" Visible='Macro_IsBaseControl() && !Macro_InSubDetail(GetPropertyValue(\"Key\"))'/>"
			+ "<Property Key=\"Required\" Caption=\"必填\" Group=\"数据关联\" Node='DataBinding' Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\" Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"DefaultValue\" Caption=\"默认值\" Group=\"数据关联\" Node='DataBinding' Control=\"TextEditor\" Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"DefaultFormulaValue\" Caption=\"表达式默认值\" Group=\"数据关联\" Node='DataBinding' Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})' Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"ValueDependency\" Caption=\"表达式值依赖\" Group=\"数据关联\" Node='DataBinding' Control=\"TextEditor\" Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"ValueValidation\" Caption=\"值验证事件\" Group=\"数据关联\" Node='DataBinding' Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})' Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"ValueChanged\" Caption=\"值改变事件\" Group=\"数据关联\" Node='DataBinding' Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})' Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"BindingCellKey\" Caption=\"关联单元格标识\" Group=\"数据关联\" Control=\"ComboBoxEditor\" OnInitialize=\"=Macro_InSubDetailSetBindingCell(GetPropertyValue('Key'))\" Visible='Macro_IsBaseControl() && Macro_InSubDetail(GetPropertyValue(\"Key\"))'/>"
			+ "<Property Key=\"AsQuery\" Caption=\"查询\" Group=\"数据关联\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\" Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"Clearable\" Caption=\"查询后清除值\" Group=\"数据关联\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"true\" Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"Condition\" Caption=\"字段查询属性\" Group=\"数据关联\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFieldQueryPropertiesSettingDialog()' DefaultValue=\"点击设置\" Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"X\" Caption=\"X\" Group=\"界面显示\" Control=\"NumberEditor\" Visible='GetTagName(\"parent\")==\"GridLayoutPanel\"'/>"
			+ "<Property Key=\"Y\" Caption=\"Y\" Group=\"界面显示\" Control=\"NumberEditor\" Visible='GetTagName(\"parent\")==\"GridLayoutPanel\"'/>"
			+ "<Property Key=\"XSpan\" Caption=\"XSpan\" Group=\"界面显示\" Control=\"NumberEditor\" Visible='GetTagName(\"parent\")==\"GridLayoutPanel\"'/>"
			+ "<Property Key=\"YSpan\" Caption=\"YSpan\" Group=\"界面显示\" Control=\"NumberEditor\" Visible='GetTagName(\"parent\")==\"GridLayoutPanel\"'/>"
			+ "<Property Key=\"Layout\" Caption=\"布局定义\" Group=\"布局\" Control=\"ButtonEditor\" DefaultValue=\"点击设置\" OnButtonClick='LoadD_Layout()' Visible='GetTagName()==\"GridLayoutPanel\"'/>"
			+ "<Property Key=\"ExtraLayout\" Caption=\"布局扩展\" Group=\"布局\" Control=\"ButtonEditor\" DefaultValue=\"点击设置\" OnButtonClick='LoadAreaDesigner()' Visible='GetTagName()==\"GridLayoutPanel\"'/>"
			+ "<Property Key=\"Orientation\" Caption=\"布局方向\" Group=\"布局\" Control=\"Combobox\" OnInitialize=\"Horizontal,水平方向;Vertical,垂直方向\" DefaultValue=\"Horizontal\"  Visible='GetTagName()==\"SplitPanel\" || GetTagName()==\"LinearLayoutPanel\"'/>"
			+ "<Property Key=\"SplitSize\" Caption=\"分割尺寸\" Group=\"布局\" Control=\"ButtonEditor\" DefaultValue=\"点击设置\" OnButtonClick='loadD_Separate()' Visible='GetTagName()==\"SplitPanel\"'/>"
			+ "<Property Key=\"Width\" Caption=\"宽度\" Group=\"尺寸\" Control=\"DefSizeEditor\"/>"
			+ "<Property Key=\"Height\" Caption=\"高度\" Group=\"尺寸\" Control=\"DefSizeEditor\"/>"
			+ "<Property Key=\"MinHeight\" Caption=\"最小高度\" Group=\"尺寸\" Control=\"DefSizeEditor\"/>"
			+ "<Property Key=\"Weight\" Caption=\"权重\" Group=\"尺寸\" Control=\"NumberEditor\"/>"
			+ "<Property Key=\"HAlign\" Caption=\"水平对齐\" Group=\"界面样式\" Node='Format' Control=\"Combobox\" OnInitialize=\",;Left,居左;Center,居中;Right,居右\" Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"VAlign\" Caption=\"垂直对齐\" Group=\"界面样式\" Node='Format' Control=\"Combobox\" OnInitialize=\"Top,居上;Center,居中;Bottom,居下\" DefaultValue=\"Center\" Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"ForeColor\" Caption=\"前景色\" Group=\"界面样式\" Node='Format' Control=\"ColorEditor\" Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"BackColor\" Caption=\"背景色\" Group=\"界面样式\" Node='Format' Control=\"ColorEditor\"/>"
			+ "<Property Key=\"HighlightColor\" Caption=\"高亮色\" Group=\"界面样式\" Node='Format' Control=\"ColorEditor\" Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"Name\" Caption=\"字体\" Group=\"界面样式\" Node='Format|Font' Control=\"TextEditor\" Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"Size\" Caption=\"字体大小\" Group=\"界面样式\" Node='Format|Font' Control=\"TextEditor\" Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"Bold\" Caption=\"粗体\" Group=\"界面样式\" Node='Format|Font' Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\" Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"Italic\" Caption=\"斜体\" Group=\"界面样式\" Node='Format|Font' Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\" Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"Underline\" Caption=\"下划线\" Group=\"界面样式\" Node='Format|Font' Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\" Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"UnderlineColor\" Caption=\"下划线颜色\" Group=\"界面样式\" Node='Format|Font' Control=\"ColorEditor\" Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"CssClass\" Caption=\"CSS类名\" Group=\"界面样式\" Control=\"TextEditor\"/>"
			+ "<Property Key=\"BorderStyle\" Caption=\"边框样式\" Group=\"边框\" Control=\"TextEditor\"/>"
			+ "<Property Key=\"BorderColor\" Caption=\"边框颜色\" Group=\"边框\" Control=\"ColorEditor\"/>"
			+ "<Property Key=\"BorderWidth\" Caption=\"边框宽度\" Group=\"边框\" Control=\"PxDefSizeEditor\"/>"
			+ "<Property Key=\"BorderRadius\" Caption=\"边框圆角化\" Group=\"边框\" Control=\"NumberEditor\"/>"
			+ "<Property Key=\"CheckRule\" Caption=\"检查规则\" Group=\"检查规则\" Node='DataBinding' Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})' Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"CheckDependency\" Caption=\"检查规则依赖\" Group=\"检查规则\" Node='DataBinding' Control=\"TextEditor\" Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"ErrorInfo\" Caption=\"错误描述\" Group=\"检查规则\" Node='DataBinding' Control=\"TextEditor\" Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"ErrorStringID\" Caption=\"错误字符串标识\" Group=\"检查规则\" Node='DataBinding' Control=\"TextEditor\" Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"RequiredIcon\" Caption=\"必填项图标\" Group=\"检查规则\" Node='DataBinding' Control=\"TextEditor\" Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"CheckRulePassIcon\" Caption=\"检查通过图标\" Group=\"检查规则\" Node='DataBinding' Control=\"TextEditor\" Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"CheckRuleErrorIcon\" Caption=\"检查错误图标\" Group=\"检查规则\" Node='DataBinding' Control=\"TextEditor\" Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"Padding\" Caption=\"填充\" Group=\"填充\" Control=\"TextEditor\"/>"
			+ "<Property Key=\"TopPadding\" Caption=\"上填充\" Group=\"填充\" Control=\"PxDefSizeEditor\"/>"
			+ "<Property Key=\"RightPadding\" Caption=\"右填充\" Group=\"填充\" Control=\"PxDefSizeEditor\"/>"
			+ "<Property Key=\"BottomPadding\" Caption=\"下填充\" Group=\"填充\" Control=\"PxDefSizeEditor\"/>"
			+ "<Property Key=\"LeftPadding\" Caption=\"左填充\" Group=\"填充\" Control=\"PxDefSizeEditor\"/>"
			+ "<Property Key=\"Margin\" Caption=\"边距\" Group=\"边距\" Control=\"TextEditor\"/>"
			+ "<Property Key=\"TopMargin\" Caption=\"上边距\" Group=\"边距\" Control=\"PxDefSizeEditor\"/>"
			+ "<Property Key=\"RightMargin\" Caption=\"右边距\" Group=\"边距\" Control=\"PxDefSizeEditor\"/>"
			+ "<Property Key=\"BottomMargin\" Caption=\"下边距\" Group=\"边距\" Control=\"PxDefSizeEditor\"/>"
			+ "<Property Key=\"LeftMargin\" Caption=\"左边距\" Group=\"边距\" Control=\"PxDefSizeEditor\"/>";

	private static final String EditViewColumn_XML = " "
			+ "<Property Key=\"ColumnType\" Caption=\"列类型\" Group=\"基础属性\" Control=\"TextEditor\" Visible='GetTagName()==\"EditViewColumn\"' DefaultValue=\"Label\" Editable=\"false\"/>"
			+ "<Property Key=\"Key\" Caption=\"标识\" Group=\"基础属性\" Control=\"TextEditor\"/>"
			+ "<Property Key=\"Caption\" Caption=\"名称\" Group=\"基础属性\" Control=\"TextEditor\"/>"
			+ "<Property Key=\"FormulaCaption\" Caption=\"表达式名称\" Group=\"基础属性\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog(\"{self.key}\",{{self.value}})'/>"
			+ "<Property Key=\"CaptionDependency\" Caption=\"表达式名称依赖\" Group=\"基础属性\" Control=\"TextEditor\"/>"
			+ "<Property Key=\"Enable\" Caption=\"可用性\" Group=\"基础属性\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog(\"{self.key}\",{{self.value}})'/>"
			+ "<Property Key=\"EnableDependency\" Caption=\"可用性依赖\" Group=\"基础属性\" Control=\"TextEditor\"/>"
			+ "<Property Key=\"Visible\" Caption=\"可见性\" Group=\"基础属性\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog(\"{self.key}\",{{self.value}})'/>"
			+ "<Property Key=\"VisibleDependency\" Caption=\"可见性依赖\" Group=\"基础属性\" Control=\"TextEditor\"/>"
			+ "<Property Key=\"BuddyKey\" Caption=\"伙伴组件\" Group=\"基础属性\" Control=\"ComboBoxEditor\" OnInitialize=\"=Macro_getAllComponentInForm(Para('formID'))\" Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"TableKey\" Caption=\"关联表标识\" Group=\"数据关联\" Node='DataBinding' Control=\"ComboBoxEditor\" OnInitialize=\"=Macro_getAllTableKey()\" Visible='Macro_IsBaseControl() && !Macro_InSubDetail(GetPropertyValue(\"Key\"))'/>"
			+ "<Property Key=\"ColumnKey\" Caption=\"关联字段标识\" Group=\"数据关联\" Node='DataBinding' Control=\"ComboBoxEditor\" OnInitialize=\"=Macro_getAllColumnKey(GetPropertyValue('TableKey','','DataBinding'))\" Visible='Macro_IsBaseControl() && !Macro_InSubDetail(GetPropertyValue(\"Key\"))'/>"
			+ "<Property Key=\"Required\" Caption=\"必填\" Group=\"数据关联\" Node='DataBinding' Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\" Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"DefaultValue\" Caption=\"默认值\" Group=\"数据关联\" Node='DataBinding' Control=\"TextEditor\" Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"DefaultFormulaValue\" Caption=\"表达式默认值\" Group=\"数据关联\" Node='DataBinding' Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})' Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"ValueDependency\" Caption=\"表达式值依赖\" Group=\"数据关联\" Node='DataBinding' Control=\"TextEditor\" Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"ValueValidation\" Caption=\"值验证事件\" Group=\"数据关联\" Node='DataBinding' Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})' Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"ValueChanged\" Caption=\"值改变事件\" Group=\"数据关联\" Node='DataBinding' Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})' Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"X\" Caption=\"X\" Group=\"界面显示\" Control=\"NumberEditor\" Visible='GetTagName(\"parent\")==\"GridLayoutPanel\" || IsEditViewColumnInGridLayout()'/>"
			+ "<Property Key=\"Y\" Caption=\"Y\" Group=\"界面显示\" Control=\"NumberEditor\" Visible='GetTagName(\"parent\")==\"GridLayoutPanel\" || IsEditViewColumnInGridLayout()'/>"
			+ "<Property Key=\"XSpan\" Caption=\"XSpan\" Group=\"界面显示\" Control=\"NumberEditor\" Visible='GetTagName(\"parent\")==\"GridLayoutPanel\" || IsEditViewColumnInGridLayout()'/>"
			+ "<Property Key=\"YSpan\" Caption=\"YSpan\" Group=\"界面显示\" Control=\"NumberEditor\" Visible='GetTagName(\"parent\")==\"GridLayoutPanel\" || IsEditViewColumnInGridLayout()'/>"
			+ "<Property Key=\"Layout\" Caption=\"布局定义\" Group=\"布局\" Control=\"ButtonEditor\" DefaultValue=\"点击设置\" OnButtonClick='LoadD_Layout()' Visible='GetTagName()==\"GridLayoutPanel\"'/>"
			+ "<Property Key=\"ExtraLayout\" Caption=\"布局扩展\" Group=\"布局\" Control=\"ButtonEditor\" DefaultValue=\"点击设置\" OnButtonClick='LoadAreaDesigner()' Visible='GetTagName()==\"GridLayoutPanel\"'/>"
			+ "<Property Key=\"Orientation\" Caption=\"布局方向\" Group=\"布局\" Control=\"Combobox\" OnInitialize=\"Horizontal,水平方向;Vertical,垂直方向\" DefaultValue=\"Horizontal\"  Visible='GetTagName()==\"SplitPanel\" || GetTagName()==\"LinearLayoutPanel\"'/>"
			+ "<Property Key=\"SplitSize\" Caption=\"分割尺寸\" Group=\"布局\" Control=\"ButtonEditor\" DefaultValue=\"点击设置\" OnButtonClick='loadD_Separate()' Visible='GetTagName()==\"SplitPanel\"'/>"
			+ "<Property Key=\"Width\" Caption=\"宽度\" Group=\"尺寸\" Control=\"DefSizeEditor\"/>"
			+ "<Property Key=\"Height\" Caption=\"高度\" Group=\"尺寸\" Control=\"DefSizeEditor\"/>"
			+ "<Property Key=\"MinHeight\" Caption=\"最小高度\" Group=\"尺寸\" Control=\"DefSizeEditor\"/>"
			+ "<Property Key=\"Weight\" Caption=\"权重\" Group=\"尺寸\" Control=\"NumberEditor\"/>"
			+ "<Property Key=\"HAlign\" Caption=\"水平对齐\" Group=\"界面样式\" Node='Format' Control=\"Combobox\" OnInitialize=\",;Left,居左;Center,居中;Right,居右\" Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"VAlign\" Caption=\"垂直对齐\" Group=\"界面样式\" Node='Format' Control=\"Combobox\" OnInitialize=\"Top,居上;Center,居中;Bottom,居下\" DefaultValue=\"Center\" Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"ForeColor\" Caption=\"前景色\" Group=\"界面样式\" Node='Format' Control=\"ColorEditor\" Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"BackColor\" Caption=\"背景色\" Group=\"界面样式\" Node='Format' Control=\"ColorEditor\"/>"
			+ "<Property Key=\"HighlightColor\" Caption=\"高亮色\" Group=\"界面样式\" Node='Format' Control=\"ColorEditor\" Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"Name\" Caption=\"字体\" Group=\"界面样式\" Node='Format|Font' Control=\"TextEditor\" Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"Size\" Caption=\"字体大小\" Group=\"界面样式\" Node='Format|Font' Control=\"TextEditor\" Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"Bold\" Caption=\"粗体\" Group=\"界面样式\" Node='Format|Font' Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\" Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"Italic\" Caption=\"斜体\" Group=\"界面样式\" Node='Format|Font' Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\" Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"Underline\" Caption=\"下划线\" Group=\"界面样式\" Node='Format|Font' Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\" Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"UnderlineColor\" Caption=\"下划线颜色\" Group=\"界面样式\" Node='Format|Font' Control=\"ColorEditor\" Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"CssClass\" Caption=\"CSS类名\" Group=\"界面样式\" Control=\"TextEditor\"/>"
			+ "<Property Key=\"BorderStyle\" Caption=\"边框样式\" Group=\"边框\" Control=\"TextEditor\"/>"
			+ "<Property Key=\"BorderColor\" Caption=\"边框颜色\" Group=\"边框\" Control=\"ColorEditor\"/>"
			+ "<Property Key=\"BorderWidth\" Caption=\"边框宽度\" Group=\"边框\" Control=\"PxDefSizeEditor\"/>"
			+ "<Property Key=\"BorderRadius\" Caption=\"边框圆角化\" Group=\"边框\" Control=\"NumberEditor\"/>"
			+ "<Property Key=\"CheckRule\" Caption=\"检查规则\" Group=\"检查规则\" Node='DataBinding' Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})' Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"CheckDependency\" Caption=\"检查规则依赖\" Group=\"检查规则\" Node='DataBinding' Control=\"TextEditor\" Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"ErrorInfo\" Caption=\"错误描述\" Group=\"检查规则\" Node='DataBinding' Control=\"TextEditor\" Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"ErrorStringID\" Caption=\"错误字符串标识\" Group=\"检查规则\" Node='DataBinding' Control=\"TextEditor\" Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"RequiredIcon\" Caption=\"必填项图标\" Group=\"检查规则\" Node='DataBinding' Control=\"TextEditor\" Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"CheckRulePassIcon\" Caption=\"检查通过图标\" Group=\"检查规则\" Node='DataBinding' Control=\"TextEditor\" Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"CheckRuleErrorIcon\" Caption=\"检查错误图标\" Group=\"检查规则\" Node='DataBinding' Control=\"TextEditor\" Visible='Macro_IsBaseControl()'/>"
			+ "<Property Key=\"Padding\" Caption=\"填充\" Group=\"填充\" Control=\"TextEditor\"/>"
			+ "<Property Key=\"TopPadding\" Caption=\"上填充\" Group=\"填充\" Control=\"PxDefSizeEditor\"/>"
			+ "<Property Key=\"RightPadding\" Caption=\"右填充\" Group=\"填充\" Control=\"PxDefSizeEditor\"/>"
			+ "<Property Key=\"BottomPadding\" Caption=\"下填充\" Group=\"填充\" Control=\"PxDefSizeEditor\"/>"
			+ "<Property Key=\"LeftPadding\" Caption=\"左填充\" Group=\"填充\" Control=\"PxDefSizeEditor\"/>"
			+ "<Property Key=\"Margin\" Caption=\"边距\" Group=\"边距\" Control=\"TextEditor\"/>"
			+ "<Property Key=\"TopMargin\" Caption=\"上边距\" Group=\"边距\" Control=\"PxDefSizeEditor\"/>"
			+ "<Property Key=\"RightMargin\" Caption=\"右边距\" Group=\"边距\" Control=\"PxDefSizeEditor\"/>"
			+ "<Property Key=\"BottomMargin\" Caption=\"下边距\" Group=\"边距\" Control=\"PxDefSizeEditor\"/>"
			+ "<Property Key=\"LeftMargin\" Caption=\"左边距\" Group=\"边距\" Control=\"PxDefSizeEditor\"/>";

	//基础面板属性集合
	private static final String BasePanelProperties_XML = " "
			+ "<Property Key=\"OverflowX\" Caption=\"水平滚动条\" Group=\"面板属性\" Control=\"Combobox\" OnInitialize=\"Visible,可见;Scroll,滚动;Hidden,隐藏;Auto,自动\" DefaultValue=\"Visible\"/>"
			+ "<Property Key=\"OverflowY\" Caption=\"垂直滚动条\" Group=\"面板属性\" Control=\"Combobox\" OnInitialize=\"Visible,可见;Scroll,滚动;Hidden,隐藏;Auto,自动\" DefaultValue=\"Visible\"/>"
			+ "<Property Key=\"BackImage\" Caption=\"背景图片\" Group=\"面板属性\" Control=\"TextEditor\" />"
			+ "<Property Key=\"BackImagePosition\" Caption=\"背景图片位置\" Group=\"面板属性\" Control=\"Combobox\" OnInitialize=\"top,居上;bottom,居下;left,居左;right,居右;center,居中\" />"
			+ "<Property Key=\"BackImageRepeatX\" Caption=\"水平重复填充\" Group=\"面板属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>"
			+ "<Property Key=\"BackImageRepeatY\" Caption=\"垂直重复填充\" Group=\"面板属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>";

	// 基础布局的属性集合
	private static final String BaseLayoutProperties_XML = " "
			+ "<Property Key=\"ControlType\" Caption=\"布局类型\" Group=\"基础属性\" Control=\"TextEditor\" Editable=\"false\"/>"
			+ "<Property Key=\"Key\" Caption=\"标识\" Group=\"基础属性\" Control=\"TextEditor\" Editable=\"false\"/>"
			+ "<Property Key=\"Padding\" Caption=\"填充\" Group=\"基础属性\" Control=\"TextEditor\"/>"
			+ "<Property Key=\"TopPadding\" Caption=\"上填充\" Group=\"基础属性\" Control=\"PxDefSizeEditor\"/>"
			+ "<Property Key=\"RightPadding\" Caption=\"右填充\" Group=\"基础属性\" Control=\"PxDefSizeEditor\"/>"
			+ "<Property Key=\"BottomPadding\" Caption=\"下填充\" Group=\"基础属性\" Control=\"PxDefSizeEditor\"/>"
			+ "<Property Key=\"LeftPadding\" Caption=\"左填充\" Group=\"基础属性\" Control=\"PxDefSizeEditor\"/>"
			+ "<Property Key=\"Margin\" Caption=\"边距\" Group=\"基础属性\" Control=\"TextEditor\"/>"
			+ "<Property Key=\"TopMargin\" Caption=\"上边距\" Group=\"基础属性\" Control=\"PxDefSizeEditor\"/>"
			+ "<Property Key=\"RightMargin\" Caption=\"右边距\" Group=\"基础属性\" Control=\"PxDefSizeEditor\"/>"
			+ "<Property Key=\"BottomMargin\" Caption=\"下边距\" Group=\"基础属性\" Control=\"PxDefSizeEditor\"/>"
			+ "<Property Key=\"LeftMargin\" Caption=\"左边距\" Group=\"基础属性\" Control=\"PxDefSizeEditor\"/>"
//			+ "<Property Key=\"HAlign\" Caption=\"水平对齐\" Group=\"界面样式\" Node='Format' Control=\"Combobox\" OnInitialize=\",;Left,居左;Center,居中;Right,居右\" Visible='Macro_IsBaseControl()'/>"
//			+ "<Property Key=\"VAlign\" Caption=\"垂直对齐\" Group=\"界面样式\" Node='Format' Control=\"Combobox\" OnInitialize=\"Top,居上;Center,居中;Bottom,居下\" DefaultValue=\"Center\" Visible='Macro_IsBaseControl()'/>"
//			+ "<Property Key=\"ForeColor\" Caption=\"前景色\" Group=\"界面样式\" Node='Format' Control=\"ColorEditor\" Visible='Macro_IsBaseControl()'/>"
//			+ "<Property Key=\"BackColor\" Caption=\"背景色\" Group=\"界面样式\" Node='Format' Control=\"ColorEditor\"/>"
//			+ "<Property Key=\"HighlightColor\" Caption=\"高亮色\" Group=\"界面样式\" Node='Format' Control=\"ColorEditor\" Visible='Macro_IsBaseControl()'/>"
//			+ "<Property Key=\"Name\" Caption=\"字体\" Group=\"界面样式\" Node='Format|Font' Control=\"TextEditor\" Visible='Macro_IsBaseControl()'/>"
//			+ "<Property Key=\"Size\" Caption=\"字体大小\" Group=\"界面样式\" Node='Format|Font' Control=\"TextEditor\" Visible='Macro_IsBaseControl()'/>"
//			+ "<Property Key=\"Bold\" Caption=\"粗体\" Group=\"界面样式\" Node='Format|Font' Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\" Visible='Macro_IsBaseControl()'/>"
//			+ "<Property Key=\"Italic\" Caption=\"斜体\" Group=\"界面样式\" Node='Format|Font' Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\" Visible='Macro_IsBaseControl()'/>"
//			+ "<Property Key=\"Underline\" Caption=\"下划线\" Group=\"界面样式\" Node='Format|Font' Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\" Visible='Macro_IsBaseControl()'/>"
//			+ "<Property Key=\"UnderlineColor\" Caption=\"下划线颜色\" Group=\"界面样式\" Node='Format|Font' Control=\"ColorEditor\" Visible='Macro_IsBaseControl()'/>"
//			+ "<Property Key=\"BorderStyle\" Caption=\"边框样式\" Group=\"边框\" Control=\"TextEditor\"/>"
//			+ "<Property Key=\"BorderColor\" Caption=\"边框颜色\" Group=\"边框\" Control=\"ColorEditor\"/>"
//			+ "<Property Key=\"BorderWidth\" Caption=\"边框宽度\" Group=\"边框\" Control=\"PxDefSizeEditor\"/>"
//			+ "<Property Key=\"BorderRadius\" Caption=\"边框圆角化\" Group=\"边框\" Control=\"NumberEditor\"/>"
			+ "<Property Key=\"X\" Caption=\"X\" Group=\"界面显示\" Control=\"NumberEditor\" Visible='IsEditViewColumnInGridLayout()'/>"
			+ "<Property Key=\"Y\" Caption=\"Y\" Group=\"界面显示\" Control=\"NumberEditor\" Visible='IsEditViewColumnInGridLayout()'/>"
			+ "<Property Key=\"XSpan\" Caption=\"XSpan\" Group=\"界面显示\" Control=\"NumberEditor\" Visible='IsEditViewColumnInGridLayout()'/>"
			+ "<Property Key=\"YSpan\" Caption=\"YSpan\" Group=\"界面显示\" Control=\"NumberEditor\" Visible='IsEditViewColumnInGridLayout()'/>";

	//组件特有属性集合
	private static final HashMap<String, String> ControlProperties_XML_Map = new HashMap<>();
	private static final HashMap<String, String[]> ControlProperties_Not_Exist_Map = new HashMap<>();

	static {
		ControlProperties_XML_Map.put("Form", FormDesignPropertyDefine.FormProperties_XML);

		ControlProperties_XML_Map.put("Block", " "
				+ "<Property Key=\"Key\" Caption=\"标识\" Group=\"基础属性\" Control=\"TextEditor\"/>"
				+ "<Property Key=\"IsRoot\" Caption=\"主Block\" Group=\"基础属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"true\"/>"
		);

		ControlProperties_XML_Map.put("TableRow", " "
				+ "<Property Key=\"RowType\" Caption=\"行类型\" Group=\"基础属性\" Control=\"Combobox\" OnInitialize=\"Fix,固定行;Detail,明细行;Group,分组头行;GroupTail,分组尾行\" DefaultValue=\"Fix\" Editable='false'/>"
				+ "<Property Key=\"Key\" Caption=\"标识\" Group=\"基础属性\" Control=\"TextEditor\"/>"
				+ "<Property Key=\"Caption\" Caption=\"名称\" Group=\"基础属性\" Control=\"TextEditor\"/>"
				+ "<Property Key=\"Enable\" Caption=\"可用性\" Group=\"基础属性\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog(\"{self.key}\",{{self.value}})'/>"
				+ "<Property Key=\"EnableDependency\" Caption=\"可用性依赖\" Group=\"基础属性\" Control=\"TextEditor\"/>"
				+ "<Property Key=\"Visible\" Caption=\"可见性\" Group=\"基础属性\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog(\"{self.key}\",{{self.value}})'/>"
				+ "<Property Key=\"VisibleDependency\" Caption=\"可见性依赖\" Group=\"基础属性\" Control=\"TextEditor\"/>"
				+ "<Property Key=\"ActionCollection\" Caption=\"行操作集合\" Group=\"基础属性\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowRowActionsSettingDialog()' DefaultValue=\"点击设置\" Visible=\"GetPropertyValue('RowType')=='Detail'\"/>"
				+ "<Property Key=\"HasGroupHead\" Caption=\"分组头\" Group=\"明细行属性\" Control=\"Combobox\" OnInitialize='None,无;Contain,包含' Default='None' Visible=\"GetPropertyValue('RowType')=='Detail'\"/>"
				+ "<Property Key=\"HasGroupTail\" Caption=\"分组尾\" Group=\"明细行属性\" Control=\"Combobox\" OnInitialize='None,无;Contain,包含' Default='None' Visible=\"GetPropertyValue('RowType')=='Detail'\"/>"
				+ "<Property Key=\"TableKey\" Caption=\"数据表标识\" Group=\"明细行属性\" Control=\"ComboBoxEditor\" OnInitialize=\"=Macro_getAllTableKey()\" Visible=\"GetPropertyValue('RowType')=='Detail'\"/>"
				+ "<Property Key=\"Style\" Caption=\"显示样式\" Group=\"明细行属性\" Control=\"Combobox\" OnInitialize='List,列表样式;Tiled,平铺样式' Default='List' Visible=\"GetPropertyValue('RowType')=='Detail'\"/>"
				+ "<Property Key=\"ColumnCount\" Caption=\"平铺列数\" Group=\"明细行属性\" Control=\"NumberEditor\" Visible=\"GetPropertyValue('RowType')=='Detail' && GetPropertyValue('Style')=='Tiled'\"/>"
				+ "<Property Key=\"IndicatorSet\" Caption=\"索引条设置\" Group=\"明细行属性\" Control=\"ButtonEditor\" DefaultValue=\"点击设置\" OnButtonClick='D_IndicatorSetting()' Visible=\"GetPropertyValue('RowType')=='Detail'\"/>"
				+ "<Property Key=\"PromptImage\" Caption=\"加载中的行视图\" Group=\"明细行属性\" Control=\"TextEditor\" Visible=\"GetPropertyValue('RowType')=='Detail'\"/>"
				+ "<Property Key=\"PromptRowCount\" Caption=\"加载中的行视图行数\" Group=\"明细行属性\" Control=\"NumberEditor\" Visible=\"GetPropertyValue('RowType')=='Detail'\"/>"
				+ "<Property Key=\"PageLoadType\" Caption=\"分页类型\" Group=\"明细行属性\" Control=\"Combobox\" OnInitialize=\"NONE,不分页;UI,界面分页;DB,数据库分页\" DefaultValue=\"NONE\" Visible=\"GetPropertyValue('RowType')=='Detail'\"/>"
				+ "<Property Key=\"PageRowCount\" Caption=\"分页显示行数\" Group=\"明细行属性\" Control=\"NumberEditor\" Default='50' Visible=\"GetPropertyValue('RowType')=='Detail'\"/>"
				+ "<Property Key=\"ShowTotalRowCount\" Caption=\"显示行总数\" Group=\"明细行属性\" Control=\"Combobox\" OnInitialize=\",默认;true,是;false,否\" Visible=\"GetPropertyValue('RowType')=='Detail'\"/>"
				+ "<Property Key=\"HasSubDetail\" Caption=\"关联子明细\" Group=\"明细行属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" Default='false' Visible=\"GetPropertyValue('RowType')=='Detail'\"/>"
				+ "<Property Key=\"LinkType\" Caption=\"子明细关联方式\" Group=\"明细行属性\" Control=\"Combobox\" OnInitialize=\"Parent,父对象关联;Foreign,外键关联\" DefaultValue='Parent' Visible=\"GetPropertyValue('RowType')=='Detail' && GetPropertyValue('HasSubDetail')=='true'\"/>"
				+ "<Property Key=\"Source\" Caption=\"外键关联源表字段\" Group=\"明细行属性\" Control=\"TextEditor\" Visible=\"GetPropertyValue('RowType')=='Detail' && GetPropertyValue('HasSubDetail')=='true' && GetPropertyValue('LinkType')=='Foreign'\"/>"
				+ "<Property Key=\"Target\" Caption=\"外键关联目标表字段\" Group=\"明细行属性\" Control=\"TextEditor\" Visible=\"GetPropertyValue('RowType')=='Detail' && GetPropertyValue('HasSubDetail')=='true' && GetPropertyValue('LinkType')=='Foreign'\"/>"
				+ "<Property Key=\"LinkList\" Caption=\"联动列表\" Group=\"明细行属性\" Control=\"TextEditor\" Visible=\"GetPropertyValue('RowType')=='Detail' && GetPropertyValue('HasSubDetail')=='true' && GetPropertyValue('LinkType')=='Parent'\"/>"
				+ "<Property Key=\"LinkFields\" Caption=\"联动字段\" Group=\"明细行属性\" Control=\"TextEditor\" Visible=\"GetPropertyValue('RowType')=='Detail' && GetPropertyValue('HasSubDetail')=='true' && GetPropertyValue('LinkType')=='Parent'\"/>"
				+ "<Property Key=\"GroupColumnKeys\" Caption=\"分组字段\" Group=\"分组行属性\" Control=\"ComboBoxEditor\" OnInitialize=\"=GetAllColumnsInTableRowData(GetPropertyValue('Key'))\" Visible=\"GetPropertyValue('RowType')=='Group'\"/>"
				+ "<Property Key=\"GroupCollapse\" Caption=\"折叠分组\" Group=\"分组行属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\" Visible=\"GetPropertyValue('RowType')=='Group'\"/>"
				+ "<Property Key=\"HoverHead\" Caption=\"组头悬停\" Group=\"分组行属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\" Visible=\"GetPropertyValue('RowType')=='Group'\"/>"
				+ "<Property Key=\"TopMargin\" Caption=\"顶边距\" Group=\"行显示属性\" Control=\"PxDefSizeEditor\"/>"
				+ "<Property Key=\"IsShowTopMargin\" Caption=\"显示头行顶边距\" Group=\"行显示属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>"
				+ "<Property Key=\"SelectColor\" Caption=\"选中颜色\" Group=\"行显示属性\" Control=\"ColorEditor\"/>"
				+ "<Property Key=\"BackColor\" Caption=\"背景颜色\" Node='Format' Group=\"行显示属性\" Control=\"ColorEditor\"/>"
				+ "<Property Key=\"HighlightColor\" Caption=\"高亮颜色\" Node='Format' Group=\"行显示属性\" Control=\"ColorEditor\"/>"
				+ "<Property Key=\"SeparatorStyle\" Caption=\"间隔样式\" Group=\"边框属性\" Control=\"TextEditor\"/>"
				+ "<Property Key=\"SeparatorRadius\" Caption=\"间隔圆角\" Group=\"边框属性\" Control=\"NumberEditor\"/>"
				+ "<Property Key=\"SeparatorColor\" Caption=\"间隔颜色\" Group=\"边框属性\" Control=\"ColorEditor\"/>"
				+ "<Property Key=\"SeparatorOffset\" Caption=\"距离左边界大小\" Group=\"边框属性\" Control=\"PxDefSizeEditor\"/>"
				+ "<Property Key=\"RowClick\" Caption=\"行点击事件\" Type='CDATA' Group=\"事件属性\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})'/>"
				+ "<Property Key=\"RowDblClick\" Caption=\"行双击事件\" Type='CDATA' Group=\"事件属性\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})'/>"
				+ "<Property Key=\"FocusRowChanged\" Caption=\"焦点行改变事件\" Type='CDATA' Group=\"事件属性\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})' Visible=\"GetPropertyValue('RowType')=='Detail'\"/>"
				+ "<Property Key=\"OnCollapse\" Caption=\"分组折叠事件\" Type='CDATA' Group=\"事件属性\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})' Visible=\"GetPropertyValue('RowType')=='Group' && GetPropertyValue('GroupCollapse')=='true'\"/>"
				+ "<Property Key=\"OnExpand\" Caption=\"分组展开事件\" Type='CDATA' Group=\"事件属性\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})' Visible=\"GetPropertyValue('RowType')=='Group' && GetPropertyValue('GroupCollapse')=='true'\"/>"
		);

		ControlProperties_XML_Map.put("CollectionViewRow", " "
				+ "<Property Key=\"Key\" Caption=\"标识\" Group=\"基础属性\" Control=\"TextEditor\"/>"
				+ "<Property Key=\"Enable\" Caption=\"可用性\" Group=\"基础属性\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog(\"{self.key}\",{{self.value}})'/>"
				+ "<Property Key=\"EnableDependency\" Caption=\"可用性依赖\" Group=\"基础属性\" Control=\"TextEditor\"/>"
				+ "<Property Key=\"Visible\" Caption=\"可见性\" Group=\"基础属性\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog(\"{self.key}\",{{self.value}})'/>"
				+ "<Property Key=\"VisibleDependency\" Caption=\"可见性依赖\" Group=\"基础属性\" Control=\"TextEditor\"/>"
				+ "<Property Key=\"TopMargin\" Caption=\"顶边距\" Group=\"行显示属性\" Control=\"PxDefSizeEditor\"/>"
				+ "<Property Key=\"BackColor\" Caption=\"背景颜色\" Group=\"行显示属性\" Node='Format' Control=\"ColorEditor\"/>"
				+ "<Property Key=\"SeparatorStyle\" Caption=\"间隔样式\" Group=\"边框属性\" Control=\"TextEditor\"/>"
				+ "<Property Key=\"SeparatorRadius\" Caption=\"间隔圆角\" Group=\"边框属性\" Control=\"NumberEditor\"/>"
				+ "<Property Key=\"SeparatorColor\" Caption=\"间隔颜色\" Group=\"边框属性\" Control=\"ColorEditor\"/>"
				+ "<Property Key=\"SeparatorOffset\" Caption=\"距离左边界大小\" Group=\"边框属性\" Control=\"PxDefSizeEditor\"/>"
				+ "<Property Key=\"RowClick\" Caption=\"行点击事件\" Type='CDATA' Group=\"事件属性\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})'/>"
				+ "<Property Key=\"RowDblClick\" Caption=\"行双击事件\" Type='CDATA' Group=\"事件属性\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})'/>"
				+ "<Property Key=\"FocusRowChanged\" Caption=\"焦点行改变事件\" Type='CDATA' Group=\"事件属性\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})' Visible=\"GetPropertyValue('RowType')=='Detail'\"/>"
		);

		ControlProperties_XML_Map.put("Label", " " +
				"<Property Key=\"Icon\" Caption=\"图标\" Group=\"组件属性\" Control=\"TextEditor\"/>" +
				"<Property Key=\"SingleLine\" Caption=\"单行\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"true\"/>" +
				"<Property Key=\"LineBreakMode\" Caption=\"截断类型\" Group=\"组件属性\" Control=\"Combobox\" " +
				"OnInitialize=\"Head,头部省略;Tail,尾部省略;Middle,中间省略;Marquee,滚动显示;EndHide,尾部截断\" DefaultValue=\"EndHide\"/>" +
				"<Property Key=\"MaxLines\" Caption=\"最大行数\" Group=\"组件属性\" Control=\"NumberEditor\"/>" +
				"<Property Key=\"ExpandCaption\" Caption=\"展开收缩文本\" Group=\"组件属性\" Control=\"TextEditor\"/>"
		);

		ControlProperties_Not_Exist_Map.put("Button", new String[]{
				"<Property Key=\"TableKey\" Caption=\"关联表标识\" Group=\"数据关联\" Node='DataBinding' Control=\"ComboBoxEditor\" OnInitialize=\"=Macro_getAllTableKey()\" Visible='Macro_IsBaseControl() && !Macro_InSubDetail(GetPropertyValue(\"Key\"))'/>",
				"<Property Key=\"ColumnKey\" Caption=\"关联字段标识\" Group=\"数据关联\" Node='DataBinding' Control=\"ComboBoxEditor\" OnInitialize=\"=Macro_getAllColumnKey(GetPropertyValue('TableKey','','DataBinding'))\" Visible='Macro_IsBaseControl() && !Macro_InSubDetail(GetPropertyValue(\"Key\"))'/>",
				"<Property Key=\"Required\" Caption=\"必填\" Group=\"数据关联\" Node='DataBinding' Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\" Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"ValueValidation\" Caption=\"值验证事件\" Group=\"数据关联\" Node='DataBinding' Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})' Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"ValueChanged\" Caption=\"值改变事件\" Group=\"数据关联\" Node='DataBinding' Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})' Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"BindingCellKey\" Caption=\"关联单元格标识\" Group=\"数据关联\" Control=\"ComboBoxEditor\" OnInitialize=\"=Macro_setBindingCellKeyByFieldKey(GetPropertyValue('Key'))\" Visible='Macro_IsBaseControl() && Macro_InSubDetail(GetPropertyValue(\"Key\"))'/>",
				"<Property Key=\"AsQuery\" Caption=\"查询\" Group=\"数据关联\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\" Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"Clearable\" Caption=\"查询后清除值\" Group=\"数据关联\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"true\" Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"Condition\" Caption=\"字段查询属性\" Group=\"数据关联\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFieldQueryPropertiesSettingDialog()' DefaultValue=\"点击设置\" Visible='Macro_IsBaseControl()'/>"
		});
		ControlProperties_XML_Map.put("Button", " " +
				"<Property Key=\"OnClick\" Caption=\"点击事件\" Group=\"组件属性\" Type=\"CDATA\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})'/>" +
				"<Property Key=\"UploadFile\" Caption=\"上传文件\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"UploadType\" Caption=\"上传方式\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"single,单选上传;multiple,多选上传\" DefaultValue=\"single\"/>" +
				"<Property Key=\"Icon\" Caption=\"图标\" Group=\"组件属性\" Control=\"TextEditor\"/>" +
				"<Property Key=\"IconLocation\" Caption=\"图标位置\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"Left,左;Top,上;Right,右;Bottom,下\" DefaultValue=\"Left\"/>" +
				"<Property Key=\"OnlyIcon\" Caption=\"仅显示图标\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"NeedAuthenticate\" Caption=\"需要认证标志\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"ClickAnim\" Caption=\"点击动画\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\",;Scale,缩放动画\" DefaultValue=\"\"/>" +
				"<Property Key=\"Type\" Caption=\"按钮类型\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"Normal,默认;Primary,主要;Warning,警告;Danger,危险\" DefaultValue=\"Normal\"/>"
		);

		ControlProperties_XML_Map.put("CheckBox", " " +
				"<Property Key=\"Icon\" Caption=\"默认图标\" Group=\"组件属性\" Control=\"TextEditor\"/>" +
				"<Property Key=\"SelectedIcon\" Caption=\"选中图标\" Group=\"组件属性\" Control=\"TextEditor\"/>" +
				"<Property Key=\"IconLocation\" Caption=\"图标位置\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"Left,左;Top,上;Right,右;Bottom,下\" DefaultValue=\"Left\"/>" +
				"<Property Key=\"HideButton\" Caption=\"隐藏图标按钮\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>"
		);

		ControlProperties_XML_Map.put("CheckListBox", " " +
				"<Property Key=\"Cache\" Caption=\"下拉项缓存\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"true\"/>" +
				"<Property Key=\"SourceType1\" Caption=\"下拉框来源\" Group=\"组件属性\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowComboBoxSourceSettingDialog()' DefaultValue=\"点击设置\"/>" +
				"<Property Key=\"PromptText\" Caption=\"空值提示\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"Style\" Caption=\"显示样式\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"Pop,弹出菜单式;Tag,流式标签式;Tiled,平铺标签式;DropDown,停靠样式\" DefaultValue=\"Pop\"/>" +
				"<Property Key=\"ColumnCount\" Caption=\"列数\" Group=\"组件属性\" Control=\"NumberEditor\" Visible=\"GetPropertyValue('Style')=='Tiled'\" DefaultValue=\"3\"/>" +
				"<Property Key=\"EditType\" Caption=\"编辑样式\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"Pop,底部向上弹出;Dialog,中间显示对话框;Sideslip,侧滑新界面;DropView,停靠弹出菜单样式\" DefaultValue=\"Dialog\"/>" +
				"<Property Key=\"PopAnim\" Caption=\"弹出动画\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\",;SLIDEBOTTOM,底部弹出，底部弹回;SLIDEBTOT,底部弹出，顶上弹回;SLIDETOP,顶上弹出，顶上弹回;SLIDETTOB,顶上弹出，底部弹回;FADE,淡入淡出;SCALE,缩放\" DefaultValue=\"\"/>"
		);

		ControlProperties_XML_Map.put("ComboBox", " " +
				"<Property Key=\"SourceType1\" Caption=\"下拉框来源\" Group=\"组件属性\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowComboBoxSourceSettingDialog()' DefaultValue=\"点击设置\"/>" +
				"<Property Key=\"Editable\" Caption=\"可编辑\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"IntegerValue\" Caption=\"整型值\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"PromptText\" Caption=\"空值提示\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"Style\" Caption=\"显示样式\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"Pop,弹出菜单式;Tag,流式标签式;Tiled,平铺标签式;DropDown,停靠样式\" DefaultValue=\"Pop\"/>" +
				"<Property Key=\"ColumnCount\" Caption=\"列数\" Group=\"组件属性\" Control=\"NumberEditor\" Visible=\"GetPropertyValue('Style')=='Tiled'\" DefaultValue=\"3\"/>" +
				"<Property Key=\"EditType\" Caption=\"编辑样式\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"Pop,底部向上弹出;Dialog,中间显示对话框;Sideslip,侧滑新界面;DropView,停靠弹出菜单样式\" DefaultValue=\"Dialog\"/>" +
				"<Property Key=\"PopAnim\" Caption=\"弹出动画\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\",;SLIDEBOTTOM,底部弹出，底部弹回;SLIDEBTOT,底部弹出，顶上弹回;SLIDETOP,顶上弹出，顶上弹回;SLIDETTOB,顶上弹出，底部弹回;FADE,淡入淡出;SCALE,缩放\" DefaultValue=\"\"/>" +
				"<Property Key=\"PromptSize\" Caption=\"联想数据条数\" Group=\"组件属性\" Control=\"NumberEditor\" DefaultValue=\"-1\"/>"
		);

		ControlProperties_XML_Map.put("DatePicker", " " +
				"<Property Key=\"Format\" Caption=\"显示格式\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"yyyy-MM-dd HH:mm:ss\"/>" +
				"<Property Key=\"OnlyDate\" Caption=\"仅显示日期\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"PromptText\" Caption=\"空值提示\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"EditType\" Caption=\"编辑样式\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"Pop,底部向上弹出;Dialog,中间显示对话框;Sideslip,侧滑新界面;DropView,停靠弹出菜单样式\" DefaultValue=\"Dialog\"/>"
		);

		ControlProperties_XML_Map.put("UTCDatePicker", " " +
				"<Property Key=\"Format\" Caption=\"显示格式\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"yyyy-MM-dd HH:mm:ss\"/>" +
				"<Property Key=\"OnlyDate\" Caption=\"仅显示日期\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"true\"/>" +
				"<Property Key=\"PromptText\" Caption=\"空值提示\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"EditType\" Caption=\"编辑样式\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"Pop,底部向上弹出;Dialog,中间显示对话框;Sideslip,侧滑新界面;DropView,停靠弹出菜单样式\" DefaultValue=\"Dialog\"/>"
		);

		ControlProperties_XML_Map.put("Dict", " " +
				"<Property Key=\"ItemKey\" Caption=\"字典标识\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"Root\" Caption=\"字典显示的根节点\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"IsDynamic\" Caption=\"为动态字典\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"IsAllowMultiSelection\" Caption=\"允许多选\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"Independent\" Caption=\"父子节点联动\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"IsCompDict\" Caption=\"复合字典\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"RefKey\" Caption=\"动态字典ItemKey关联字段\" Group=\"组件属性\" Control=\"TextEditor\"/>" +
				// 需要改成多选
				"<Property Key=\"StateMask\" Caption=\"字典状态过滤\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"Enable,启用状态;Disable,停用状态;Discard,作废状态\" DefaultValue=\"Enable\"/>" +
				// 过滤
				"<Property Key=\"ItemKeySourceType\" Caption=\"来源类型\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"DataObject,字典数据集;Para,参数组\" DefaultValue=\"DataObject\"/>" +
				"<Property Key=\"ItemKeySource\" Caption=\"字典标识来源\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"IgnoreRight\" Caption=\"忽略数据权限\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"EditType\" Caption=\"编辑样式\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"Pop,底部向上弹出;Dialog,中间显示对话框;Sideslip,侧滑新界面;DropView,停靠弹出菜单样式\" DefaultValue=\"Sideslip\"/>" +
				"<Property Key=\"Editable\" Caption=\"可编辑\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"true\"/>" +
				"<Property Key=\"LoadType\" Caption=\"字典加载策略\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"R2L,从根节点到子节点;L2R,从子节点到根节点\" DefaultValue=\"R2L\"/>" +
				"<Property Key=\"FormulaText\" Caption=\"表达式显示值\" Group=\"组件属性\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog(\"{self.key}\",{{self.value}})'/>" +
				"<Property Key=\"TextField\" Caption=\"显示字段\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"PromptText\" Caption=\"空值提示\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"IsPromptData\" Caption=\"单选字典是否模糊联想\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"DisableKeyboard\" Caption=\"禁用软键盘\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\",;true,是;false,否\" DefaultValue=\"\"/>" +
				"<Property Key=\"QueryMatchType\" Caption=\"模糊查询匹配方式\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"Full,全匹配;Right,右通配;Left,左通配\" DefaultValue=\"Full\"/>"
		);

		ControlProperties_XML_Map.put("DynamicDict", " " +
				"<Property Key=\"ItemKey\" Caption=\"字典标识\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"Root\" Caption=\"字典显示的根节点\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"IsDynamic\" Caption=\"为动态字典\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"true\"/>" +
				"<Property Key=\"IsAllowMultiSelection\" Caption=\"允许多选\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"Independent\" Caption=\"父子节点联动\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"IsCompDict\" Caption=\"复合字典\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"RefKey\" Caption=\"动态字典ItemKey关联字段\" Group=\"组件属性\" Control=\"TextEditor\"/>" +
				// 需要改成多选
				"<Property Key=\"StateMask\" Caption=\"字典状态过滤\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"Enable,启用状态;Disable,停用状态;Discard,作废状态\" DefaultValue=\"Enable\"/>" +
				// 过滤
				"<Property Key=\"ItemKeySourceType\" Caption=\"来源类型\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"DataObject,字典数据集;Para,参数组\" DefaultValue=\"DataObject\"/>" +
				"<Property Key=\"ItemKeySource\" Caption=\"Para时itemKey的值\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"IgnoreRight\" Caption=\"忽略数据权限\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"EditType\" Caption=\"编辑样式\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"Pop,底部向上弹出;Dialog,中间显示对话框;Sideslip,侧滑新界面;DropView,停靠弹出菜单样式\" DefaultValue=\"Sideslip\"/>" +
				"<Property Key=\"Editable\" Caption=\"可编辑\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"true\"/>" +
				"<Property Key=\"LoadType\" Caption=\"字典加载策略\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"R2L,从根节点到子节点;L2R,从子节点到根节点\" DefaultValue=\"R2L\"/>" +
				"<Property Key=\"FormulaText\" Caption=\"表达式显示值\" Group=\"组件属性\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog(\"{self.key}\",{{self.value}})'/>" +
				"<Property Key=\"TextField\" Caption=\"显示字段\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"PromptText\" Caption=\"空值提示\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"IsPromptData\" Caption=\"单选字典是否模糊联想\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"DisableKeyboard\" Caption=\"禁用软键盘\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\",;true,是;false,否\" DefaultValue=\"\"/>" +
				"<Property Key=\"QueryMatchType\" Caption=\"模糊查询匹配方式\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"Full,全匹配;Right,右通配;Left,左通配\" DefaultValue=\"Full\"/>"
		);

		ControlProperties_XML_Map.put("CompDict", " " +
				"<Property Key=\"ItemKey\" Caption=\"字典标识\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"Root\" Caption=\"字典显示的根节点\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"IsDynamic\" Caption=\"为动态字典\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"IsAllowMultiSelection\" Caption=\"允许多选\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"Independent\" Caption=\"父子节点联动\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"IsCompDict\" Caption=\"复合字典\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"true\"/>" +
				"<Property Key=\"RefKey\" Caption=\"动态字典ItemKey关联字段\" Group=\"组件属性\" Control=\"TextEditor\"/>" +
				// 需要改成多选
				"<Property Key=\"StateMask\" Caption=\"字典状态过滤\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"Enable,启用状态;Disable,停用状态;Discard,作废状态\" DefaultValue=\"Enable\"/>" +
				// 过滤
				"<Property Key=\"ItemKeySourceType\" Caption=\"来源类型\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"DataObject,字典数据集;Para,参数组\" DefaultValue=\"DataObject\"/>" +
				"<Property Key=\"ItemKeySource\" Caption=\"Para时itemKey的值\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"IgnoreRight\" Caption=\"忽略数据权限\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"EditType\" Caption=\"编辑样式\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"Pop,底部向上弹出;Dialog,中间显示对话框;Sideslip,侧滑新界面;DropView,停靠弹出菜单样式\" DefaultValue=\"Sideslip\"/>" +
				"<Property Key=\"Editable\" Caption=\"可编辑\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"true\"/>" +
				"<Property Key=\"LoadType\" Caption=\"字典加载策略\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"R2L,从根节点到子节点;L2R,从子节点到根节点\" DefaultValue=\"R2L\"/>" +
				"<Property Key=\"FormulaText\" Caption=\"表达式显示值\" Group=\"组件属性\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog(\"{self.key}\",{{self.value}})'/>" +
				"<Property Key=\"TextField\" Caption=\"显示字段\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"PromptText\" Caption=\"空值提示\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"IsPromptData\" Caption=\"单选字典是否模糊联想\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"DisableKeyboard\" Caption=\"禁用软键盘\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\",;true,是;false,否\" DefaultValue=\"\"/>" +
				"<Property Key=\"QueryMatchType\" Caption=\"模糊查询匹配方式\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"Full,全匹配;Right,右通配;Left,左通配\" DefaultValue=\"Full\"/>"

		);

		ControlProperties_XML_Map.put("DictView", "");

		ControlProperties_XML_Map.put("DictPane", "");

		ControlProperties_XML_Map.put("DictSearchBox", "");

		ControlProperties_XML_Map.put("HyperLink", " " +
				"<Property Key=\"OnClick\" Caption=\"点击事件\" Group=\"组件属性\" Type=\"CDATA\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})'/>" +
				"<Property Key=\"URL\" Caption=\"URL\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"FormulaURL\" Caption=\"表达式URL\" Group=\"组件属性\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog(\"{self.key}\",{{self.value}})'/>" +
				"<Property Key=\"TargetShowType\" Caption=\"目标显示方式\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"New,新窗口;NewTab,新Tab页;Current,当前页\" DefaultValue=\"NewTab\"/>" +
				"<Property Key=\"NeedAuthenticate\" Caption=\"需要认证标志\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>"
		);

		ControlProperties_XML_Map.put("NumberEditor", " " +
						"<Property Key=\"Precision\" Caption=\"数值精度\" Group=\"组件属性\" Control=\"NumberEditor\" DefaultValue=\"16\"/>" +
						"<Property Key=\"Scale\" Caption=\"小数位数\" Group=\"组件属性\" Control=\"NumberEditor\" DefaultValue=\"2\"/>" +
						"<Property Key=\"UseGroupingSeparator\" Caption=\"使用组分割\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"true\"/>" +
						"<Property Key=\"PromptText\" Caption=\"空值提示\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
						"<Property Key=\"SelectOnFocus\" Caption=\"光标进入默认全选\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"true\"/>" +
//        		"<Property Key=\"SelectOnFocus\" Caption=\"移动端光标进入默认全选\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +		
						"<Property Key=\"RoundingMode\" Caption=\"四舍五入规则\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"HALF_UP,四舍五入;ROUND_UP,向大值舍入;ROUND_DOWN,向小值舍入;ROUND_CEILING,向右值舍入;ROUND_FLOOR,向左值舍入\" DefaultValue=\"HALF_UP\"/>" +
						"<Property Key=\"ShowZero\" Caption=\"显示零值\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
//        		"<Property Key=\"ZeroString\" Caption=\"0值字符串\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
//        		"<Property Key=\"NegtiveForeColor\" Caption=\"负数前景色\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
						"<Property Key=\"Format\" Caption=\"文本显示格式化类型\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\",;PercentStyle,百分比;DollarStyle,美元;RMBStyle,人民币\" DefaultValue=\"\"/>" +
						"<Property Key=\"ImeOptions\" Caption=\"软键盘的回车键类型\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\",;Done,完成;Next,下一步;Search,搜索;Send,发送;Go,开始;Default,默认\" DefaultValue=\"\"/>" +
						"<Property Key=\"OnFocus\" Caption=\"焦点获取事件\" Group=\"组件属性\" Type=\"CDATA\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})'/>" +
						"<Property Key=\"StripTrailingZeros\" Caption=\"去尾零\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
						"<Property Key=\"DisableKeyboard\" Caption=\"禁用软键盘\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\",;true,是;false,否\" DefaultValue=\"\"/>" +
						"<Property Key=\"Suffix\" Caption=\"后缀\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
						"<Property Key=\"Prefix\" Caption=\"前缀\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
						"<Property Key=\"FormulaText\" Caption=\"表达式显示值\" Group=\"组件属性\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog(\"{self.key}\",{{self.value}})'/>" +
						"<Property Key=\"AllowNull\" Caption=\"显示空值\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>"
		);

		ControlProperties_XML_Map.put("TextEditor", " " +
				"<Property Key=\"MaxLength\" Caption=\"文本输入长度\" Group=\"组件属性\" Control=\"NumberEditor\" DefaultValue=\"255\"/>" +
				"<Property Key=\"ShowWordLimit\" Caption=\"显示字数统计\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"InvalidChars\" Caption=\"不允许输入的字符集合\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"Case\" Caption=\"大小写转换类型\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"None,无限制;Lower,全小写;Upper,全大写\" DefaultValue=\"None\"/>" +
				"<Property Key=\"PromptText\" Caption=\"空值提示\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"Trim\" Caption=\"去除首尾多余空格\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"SelectOnFocus\" Caption=\"光标进入默认全选\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"true\"/>" +
				"<Property Key=\"Mask\" Caption=\"掩码\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"Icon\" Caption=\"右侧图标url\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"PreIcon\" Caption=\"左侧图标url\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"EmbedText\" Caption=\"左侧内嵌文本\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"HoldFocus\" Caption=\"保持焦点\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"KeyEnter\" Caption=\"回车事件\" Group=\"组件属性\" Type=\"CDATA\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})'/>" +
				"<Property Key=\"EmbedTextSize\" Caption=\"左侧内嵌文本大小\" Group=\"组件属性\" Control=\"NumberEditor\" DefaultValue=\"-1\"/>" +
				"<Property Key=\"EmbedTextColor\" Caption=\"左侧内嵌文本颜色\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"ImeOptions\" Caption=\"软键盘的回车键类型\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\",;Done,完成;Next,下一步;Search,搜索;Send,发送;Go,开始;Default,默认\" DefaultValue=\"\"/>" +
				"<Property Key=\"DisableKeyboard\" Caption=\"禁用软键盘\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\",;true,是;false,否\" DefaultValue=\"\"/>" +
				"<Property Key=\"OnFocus\" Caption=\"焦点获取事件\" Group=\"组件属性\" Type=\"CDATA\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})'/>" +
				"<Property Key=\"Suffix\" Caption=\"后缀\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"Prefix\" Caption=\"前缀\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>"
		);

		ControlProperties_XML_Map.put("TextArea", " " +
				"<Property Key=\"MaxLength\" Caption=\"文本输入长度\" Group=\"组件属性\" Control=\"NumberEditor\" DefaultValue=\"255\"/>" +
				"<Property Key=\"ShowWordLimit\" Caption=\"显示字数统计\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"InvalidChars\" Caption=\"不允许输入的字符集合\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"Case\" Caption=\"大小写转换类型\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"None,无限制;Lower,全小写;Upper,全大写\" DefaultValue=\"None\"/>" +
				"<Property Key=\"PromptText\" Caption=\"空值提示\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"Trim\" Caption=\"去除首尾多余空格\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"SelectOnFocus\" Caption=\"光标进入默认全选\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"true\"/>" +
				"<Property Key=\"Mask\" Caption=\"掩码\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"Icon\" Caption=\"右侧图标url\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"PreIcon\" Caption=\"左侧图标url\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"EmbedText\" Caption=\"左侧内嵌文本\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"HoldFocus\" Caption=\"保持焦点\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"KeyEnter\" Caption=\"回车事件\" Group=\"组件属性\" Type=\"CDATA\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})'/>" +
				"<Property Key=\"EmbedTextSize\" Caption=\"左侧内嵌文本大小\" Group=\"组件属性\" Control=\"NumberEditor\" DefaultValue=\"-1\"/>" +
				"<Property Key=\"EmbedTextColor\" Caption=\"左侧内嵌文本颜色\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"ImeOptions\" Caption=\"软键盘的回车键类型\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\",;Done,完成;Next,下一步;Search,搜索;Send,发送;Go,开始;Default,默认\" DefaultValue=\"\"/>" +
				"<Property Key=\"DisableKeyboard\" Caption=\"禁用软键盘\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\",;true,是;false,否\" DefaultValue=\"\"/>" +
				"<Property Key=\"OnFocus\" Caption=\"焦点获取事件\" Group=\"组件属性\" Type=\"CDATA\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})'/>" +
				"<Property Key=\"Suffix\" Caption=\"后缀\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"Prefix\" Caption=\"前缀\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>"
		);

		ControlProperties_XML_Map.put("Image", " " +
				"<Property Key=\"SourceType\" Caption=\"图片来源类型\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"Data,数据;Resource,系统资源;URL,URL\" DefaultValue=\"Data\"/>" +
				"<Property Key=\"Image\" Caption=\"定义图片来源\" Group=\"组件属性\" Control=\"TextEditor\" Visible=\"GetPropertyValue('SourceType')=='Resource'\" DefaultValue=\"\"/>" +
				"<Property Key=\"OnClick\" Caption=\"点击事件\" Group=\"组件属性\" Type=\"CDATA\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})'/>" +
				"<Property Key=\"ImageScaleType\" Caption=\"拉伸缩放类型\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\",;Center,Center;Fit_XY,Fit_XY;Fit_Start,Fit_Start;Fit_Center,Fit_Center;Fit_End,Fit_End;Center_Crop,Center_Crop;Start,Start\" DefaultValue=\"\"/>" +
				"<Property Key=\"MaxSize\" Caption=\"上传文件大小\" Group=\"组件属性\" Control=\"NumberEditor\" DefaultValue=\"-1\"/>" +
				"<Property Key=\"ImageCut\" Caption=\"剪切\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"PromptImage\" Caption=\"无值时的提示图片\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"Radius\" Caption=\"圆角半径\" Group=\"组件属性\" Control=\"NumberEditor\" DefaultValue=\"-1\"/>" +
				"<Property Key=\"FileName\" Caption=\"图片固定名称\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"ViewMode\" Caption=\"图片查看模式\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"Self,保持原样;Pop,点击弹出原图\" DefaultValue=\"Self\"/>" +
				"<Property Key=\"ViewOpt\" Caption=\"允许操作\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"MaskImage\" Caption=\"图片形状遮罩模板\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"ShowThumbnail\" Caption=\"显示缩略图\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"true\"/>" +
				"<Property Key=\"UploadProgress\" Caption=\"上传进度指示器的样式\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"None,没有;Strip,条状;Circle,圆环状;Percent,百分比\" DefaultValue=\"None\"/>" +
				"<Property Key=\"MaxShowSize\" Caption=\"图片加载到内存最大值\" Group=\"组件属性\" Control=\"NumberEditor\" DefaultValue=\"10000\"/>"
		);

		ControlProperties_XML_Map.put("Icon", " " +
				"<Property Key=\"Icon\" Caption=\"定义图片来源\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"URL\" Caption=\"定义网络图片来源\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"ImageScaleType\" Caption=\"拉伸缩放类型\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\",;Center,Center;Fit_XY,Fit_XY;Fit_Start,Fit_Start;Fit_Center,Fit_Center;Fit_End,Fit_End;Center_Crop,Center_Crop;Start,Start\" DefaultValue=\"\"/>"
		);

		ControlProperties_XML_Map.put("GIFImage", " " +
				"<Property Key=\"SourceType\" Caption=\"图片来源类型\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"Data,数据;Resource,系统资源;URL,URL\" DefaultValue=\"Data\"/>" +
				"<Property Key=\"Image\" Caption=\"定义图片来源\" Group=\"组件属性\" Control=\"TextEditor\" Visible=\"GetPropertyValue('SourceType')=='Resource'\" DefaultValue=\"\"/>" +
				"<Property Key=\"OnClick\" Caption=\"点击事件\" Group=\"组件属性\" Type=\"CDATA\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})'/>" +
				"<Property Key=\"ImageScaleType\" Caption=\"拉伸缩放类型\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\",;Center,Center;Fit_XY,Fit_XY;Fit_Start,Fit_Start;Fit_Center,Fit_Center;Fit_End,Fit_End;Center_Crop,Center_Crop;Start,Start\" DefaultValue=\"\"/>"
		);

		ControlProperties_XML_Map.put("ProgressBar", " " +
				"<Property Key=\"MaxPos\" Caption=\"最大进度值\" Group=\"组件属性\" Control=\"NumberEditor\" DefaultValue=\"100\"/>" +
				"<Property Key=\"MinPos\" Caption=\"最小进度值\" Group=\"组件属性\" Control=\"NumberEditor\" DefaultValue=\"0\"/>" +
				"<Property Key=\"StepValue\" Caption=\"步进值\" Group=\"组件属性\" Control=\"NumberEditor\" DefaultValue=\"1\"/>" +
				"<Property Key=\"Dynamic\" Caption=\"进度动态效果\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"BarColor\" Caption=\"默认颜色\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"#dddddd\"/>" +
				"<Property Key=\"ProgressColor\" Caption=\"进度颜色\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"#00aaee\"/>" +
				"<Property Key=\"Style\" Caption=\"进度动态效果\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"Horizontal,水平样式;Circle,圆形样式;Number,数字样式\" DefaultValue=\"Horizontal\"/>" +
				"<Property Key=\"Repeat\" Caption=\"循环显示进度\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>"
		);

		ControlProperties_XML_Map.put("RadioButton", " " +
				"<Property Key=\"GroupKey\" Caption=\"组标识\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"IsGroupHead\" Caption=\"为组的主控件\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"Value\" Caption=\"选中时的值\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"Icon\" Caption=\"默认图标\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"SelectedIcon\" Caption=\"选中图标\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"IconLocation\" Caption=\"图标位置\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"Left,左;Top,上;Right,右;Bottom,下\" DefaultValue=\"Left\"/>" +
				"<Property Key=\"HideButton\" Caption=\"隐藏图标按钮\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>"
		);

		ControlProperties_XML_Map.put("TextButton", " " +
				"<Property Key=\"OnClick\" Caption=\"点击事件\" Group=\"组件属性\" Type=\"CDATA\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})'/>" +
				"<Property Key=\"MaxLength\" Caption=\"文本输入长度\" Group=\"组件属性\" Control=\"NumberEditor\" DefaultValue=\"255\"/>" +
				"<Property Key=\"InvalidChars\" Caption=\"不允许输入的字符集合\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"Case\" Caption=\"大小写转换类型\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"None,无限制;Lower,全小写;Upper,全大写\" DefaultValue=\"None\"/>" +
				"<Property Key=\"PromptText\" Caption=\"空值提示\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"Trim\" Caption=\"去除首尾多余空格\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"SelectOnFocus\" Caption=\"光标进入默认全选\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"true\"/>" +
				"<Property Key=\"Mask\" Caption=\"掩码\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"Icon\" Caption=\"右侧图标url\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"PreIcon\" Caption=\"左侧图标url\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"EmbedText\" Caption=\"左侧内嵌文本\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"HoldFocus\" Caption=\"保持焦点\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"KeyEnter\" Caption=\"回车事件\" Group=\"组件属性\" Type=\"CDATA\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})'/>"
		);

		ControlProperties_XML_Map.put("ImageList", " " +
				"<Property Key=\"OnClick\" Caption=\"点击事件\" Group=\"组件属性\" Type=\"CDATA\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})'/>" +
				"<Property Key=\"ImageScaleType\" Caption=\"拉伸缩放类型\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\",;Center,Center;Fit_XY,Fit_XY;Fit_Start,Fit_Start;Fit_Center,Fit_Center;Fit_End,Fit_End;Center_Crop,Center_Crop;Start,Start\" DefaultValue=\"\"/>" +
				"<Property Key=\"PromptImage\" Caption=\"无值时的提示图片\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"Radius\" Caption=\"圆角半径\" Group=\"组件属性\" Control=\"NumberEditor\" DefaultValue=\"-1\"/>" +
				"<Property Key=\"MaskImage\" Caption=\"图片形状遮罩模板\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>"
		);

		ControlProperties_XML_Map.put("ToolBar", "");

		ControlProperties_Not_Exist_Map.put("Separator", new String[]{
				"<Property Key=\"TableKey\" Caption=\"关联表标识\" Group=\"数据关联\" Node='DataBinding' Control=\"ComboBoxEditor\" OnInitialize=\"=Macro_getAllTableKey()\" Visible='Macro_IsBaseControl() && !Macro_InSubDetail(GetPropertyValue(\"Key\"))'/>",
				"<Property Key=\"ColumnKey\" Caption=\"关联字段标识\" Group=\"数据关联\" Node='DataBinding' Control=\"ComboBoxEditor\" OnInitialize=\"=Macro_getAllColumnKey(GetPropertyValue('TableKey','','DataBinding'))\" Visible='Macro_IsBaseControl() && !Macro_InSubDetail(GetPropertyValue(\"Key\"))'/>",
				"<Property Key=\"Required\" Caption=\"必填\" Group=\"数据关联\" Node='DataBinding' Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\" Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"DefaultValue\" Caption=\"默认值\" Group=\"数据关联\" Node='DataBinding' Control=\"TextEditor\" Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"DefaultFormulaValue\" Caption=\"表达式默认值\" Group=\"数据关联\" Node='DataBinding' Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})' Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"ValueDependency\" Caption=\"表达式值依赖\" Group=\"数据关联\" Node='DataBinding' Control=\"TextEditor\" Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"ValueValidation\" Caption=\"值验证事件\" Group=\"数据关联\" Node='DataBinding' Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})' Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"ValueChanged\" Caption=\"值改变事件\" Group=\"数据关联\" Node='DataBinding' Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})' Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"BindingCellKey\" Caption=\"关联单元格标识\" Group=\"数据关联\" Control=\"ComboBoxEditor\" OnInitialize=\"=Macro_InSubDetailSetBindingCell(GetPropertyValue('Key'))\" Visible='Macro_IsBaseControl() && Macro_InSubDetail(GetPropertyValue(\"Key\"))'/>",
				"<Property Key=\"AsQuery\" Caption=\"查询\" Group=\"数据关联\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\" Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"Clearable\" Caption=\"查询后清除值\" Group=\"数据关联\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"true\" Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"Condition\" Caption=\"字段查询属性\" Group=\"数据关联\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFieldQueryPropertiesSettingDialog()' DefaultValue=\"点击设置\" Visible='Macro_IsBaseControl()'/>"
		});
		ControlProperties_XML_Map.put("Separator", " " +
				"<Property Key=\"Orientation\" Caption=\"方向\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"Horizontal,水平方向;Vertical,垂直方向\" DefaultValue=\"Horizontal\"/>" +
				"<Property Key=\"Icon\" Caption=\"图标url\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"IconLocation\" Caption=\"图标位置\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"Left,左;Top,上;Right,右;Bottom,下\" DefaultValue=\"Left\"/>"
		);

		ControlProperties_XML_Map.put("ToggleButton", " " +
				"<Property Key=\"TextOn\" Caption=\"选中时文字\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"TextOff\" Caption=\"未选中时文字\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"Icon\" Caption=\"图标url\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"IconOn\" Caption=\"选中时图片\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"IconOff\" Caption=\"未选中时图片\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"IconLocation\" Caption=\"图标位置\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"Left,左;Top,上;Right,右;Bottom,下\" DefaultValue=\"Left\"/>" +
				"<Property Key=\"OnClick\" Caption=\"点击事件\" Group=\"组件属性\" Type=\"CDATA\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})'/>"
		);

		ControlProperties_XML_Map.put("PasswordEditor", " " +
				"<Property Key=\"SafeInput\" Caption=\"自定义安全软件盘\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"ShowSwitchIcon\" Caption=\"显示切换文本样式\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"true\"/>" +
				"<Property Key=\"Style\" Caption=\"样式\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"Normal,普通样式;Box,方框样式;Underline,下划线样式\" DefaultValue=\"Normal\"/>" +
				"<Property Key=\"ShowPlainText\" Caption=\"初始是否显示明文\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"Spacing\" Caption=\"方框和下划线样式的间距\" Group=\"组件属性\" Control=\"PxDefSizeEditor\"/>" +
				"<Property Key=\"MaxLength\" Caption=\"文本输入长度\" Group=\"组件属性\" Control=\"NumberEditor\" DefaultValue=\"255\"/>" +
				"<Property Key=\"ShowWordLimit\" Caption=\"显示字数统计\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"InvalidChars\" Caption=\"不允许输入的字符集合\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"Case\" Caption=\"大小写转换类型\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"None,无限制;Lower,全小写;Upper,全大写\" DefaultValue=\"None\"/>" +
				"<Property Key=\"PromptText\" Caption=\"空值提示\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"Trim\" Caption=\"去除首尾多余空格\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"SelectOnFocus\" Caption=\"光标进入默认全选\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"true\"/>" +
				"<Property Key=\"Mask\" Caption=\"掩码\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"Icon\" Caption=\"右侧图标url\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"PreIcon\" Caption=\"左侧图标url\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"EmbedText\" Caption=\"左侧内嵌文本\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"HoldFocus\" Caption=\"保持焦点\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"KeyEnter\" Caption=\"回车事件\" Group=\"组件属性\" Type=\"CDATA\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})'/>" +
				"<Property Key=\"EmbedTextSize\" Caption=\"左侧内嵌文本大小\" Group=\"组件属性\" Control=\"NumberEditor\" DefaultValue=\"-1\"/>" +
				"<Property Key=\"EmbedTextColor\" Caption=\"左侧内嵌文本颜色\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"ImeOptions\" Caption=\"软键盘的回车键类型\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\",;Done,完成;Next,下一步;Search,搜索;Send,发送;Go,开始;Default,默认\" DefaultValue=\"\"/>" +
				"<Property Key=\"DisableKeyboard\" Caption=\"禁用软键盘\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\",;true,是;false,否\" DefaultValue=\"\"/>" +
				"<Property Key=\"OnFocus\" Caption=\"焦点获取事件\" Group=\"组件属性\" Type=\"CDATA\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})'/>" +
				"<Property Key=\"Suffix\" Caption=\"后缀\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"Prefix\" Caption=\"前缀\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>"
		);

		ControlProperties_XML_Map.put("StepEditor", " " +
				"<Property Key=\"MinValue\" Caption=\"最小值\" Group=\"组件属性\" Control=\"NumberEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"MaxValue\" Caption=\"最大值\" Group=\"组件属性\" Control=\"NumberEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"Step\" Caption=\"步进值\" Group=\"组件属性\" Control=\"NumberEditor\" DefaultValue=\"1\"/>" +
				"<Property Key=\"DisableKeyboard\" Caption=\"禁用软键盘\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\",;true,是;false,否\" DefaultValue=\"\"/>" +
				"<Property Key=\"ShowType\" Caption=\"显示样式\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"BothSides,BothSides;RightSide,RightSide\" DefaultValue=\"BothSides\"/>" +
				"<Property Key=\"EditType\" Caption=\"编辑样式\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"Input,软键盘输入;Scroll,底部向上弹出滚动\" DefaultValue=\"Input\"/>"

		);

		ControlProperties_XML_Map.put("ScoreBar", " " +
				"<Property Key=\"Count\" Caption=\"打分项目数\" Group=\"组件属性\" Control=\"NumberEditor\" DefaultValue=\"5\"/>" +
				"<Property Key=\"Icon\" Caption=\"默认图标\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"SelectIcon\" Caption=\"选中图标\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"SupportHalf\" Caption=\"支持步进半分\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"true\"/>"
		);

		ControlProperties_XML_Map.put("Switch", "");

		ControlProperties_XML_Map.put("Slider", " " +
				"<Property Key=\"MaxPos\" Caption=\"最大进度值\" Group=\"组件属性\" Control=\"NumberEditor\" DefaultValue=\"100\"/>" +
				"<Property Key=\"MinPos\" Caption=\"最小进度值\" Group=\"组件属性\" Control=\"NumberEditor\" DefaultValue=\"0\"/>" +
				"<Property Key=\"StepValue\" Caption=\"步进值\" Group=\"组件属性\" Control=\"NumberEditor\" DefaultValue=\"1\"/>" +
				"<Property Key=\"BarColor\" Caption=\"滑杆颜色\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"#dddddd\"/>" +
				"<Property Key=\"ProgressColor\" Caption=\"进度颜色\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"#00aaee\"/>" +
				"<Property Key=\"AllowMultiSelection\" Caption=\"允许多选\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>"
		);

		ControlProperties_XML_Map.put("NumberInfoEditor", " " +
				"<Property Key=\"Format\" Caption=\"数值格式化字符串\" Group=\"组件属性\" Control=\"TextEditor\"/>" +
				"<Property Key=\"ImeOptions\" Caption=\"软键盘的回车键类型\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\",;Done,完成;Next,下一步;Search,搜索;Send,发送;Go,开始;Default,默认\" DefaultValue=\"\"/>" +
				"<Property Key=\"OnFocus\" Caption=\"焦点获取事件\" Group=\"组件属性\" Type=\"CDATA\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})'/>" +
				"<Property Key=\"DisableKeyboard\" Caption=\"禁用软键盘\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\",;true,是;false,否\" DefaultValue=\"\"/>"
		);

		ControlProperties_XML_Map.put("CountDownView", " " +
				"<Property Key=\"Style\" Caption=\"显示样式\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"Rectangle,矩形样式;Circle,圆形样式\" DefaultValue=\"Rectangle\"/>" +
				"<Property Key=\"Stepper\" Caption=\"步进值\" Group=\"组件属性\" Control=\"NumberEditor\" DefaultValue=\"1\"/>" +
				"<Property Key=\"OnFinish\" Caption=\"计时结束事件\" Group=\"组件属性\" Type=\"CDATA\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})'/>" +
				"<Property Key=\"OnClick\" Caption=\"计时点击事件\" Group=\"组件属性\" Type=\"CDATA\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})'/>" +
				"<Property Key=\"Repeat\" Caption=\"重复\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"MaxTime\" Caption=\"最大值\" Group=\"组件属性\" Control=\"NumberEditor\" DefaultValue=\"60\"/>" +
				"<Property Key=\"EndCaption\" Caption=\"结束时显示文本\" Group=\"组件属性\" Control=\"TextEditor\"/>"
		);

		ControlProperties_XML_Map.put("CountUp", " " +
				"<Property Key=\"RollingType\" Caption=\"滚动类型\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"Right,右边滚动较快;Left,左边滚动较快;All,滚动速度相同;Random,随机速度;AdaptiveLines,自适应滚动\" DefaultValue=\"Right\"/>" +
				"<Property Key=\"RollingLines\" Caption=\"滚动行数\" Group=\"组件属性\" Control=\"NumberEditor\" DefaultValue=\"15\"/>"
		);

		ControlProperties_XML_Map.put("ValidateBox", " " +
				"<Property Key=\"PromptText\" Caption=\"提示文本\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"DisableKeyboard\" Caption=\"禁用软键盘\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\",;true,是;false,否\" DefaultValue=\"\"/>"
		);

		ControlProperties_XML_Map.put("MonthPicker", " " +
				"<Property Key=\"Format\" Caption=\"显示格式\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"yyyy-MM\"/>" +
				"<Property Key=\"PromptText\" Caption=\"空值提示\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"EditType\" Caption=\"编辑样式\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"Pop,底部向上弹出;Dialog,中间显示对话框;Sideslip,侧滑新界面;DropView,停靠弹出菜单样式\" DefaultValue=\"Pop\"/>"
		);

		ControlProperties_XML_Map.put("TimePicker", " " +
				"<Property Key=\"Format\" Caption=\"显示格式\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"HH:mm:ss\"/>" +
				"<Property Key=\"PromptText\" Caption=\"空值提示\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"Second\" Caption=\"时分秒\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"EditType\" Caption=\"编辑样式\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"Pop,底部向上弹出;Dialog,中间显示对话框;Sideslip,侧滑新界面;DropView,停靠弹出菜单样式\" DefaultValue=\"Pop\"/>"
		);

		ControlProperties_XML_Map.put("DateRangePicker", " " +
				"<Property Key=\"RangeSeparator\" Caption=\"区间日期连接符\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"StartPlaceholder\" Caption=\"开始日期的占位内容\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"EndPlaceholder\" Caption=\"结束日期的占位内容\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"PromptText\" Caption=\"提示信息\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"Format\" Caption=\"显示格式\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"yyyy-MM-dd\"/>"
		);

		ControlProperties_XML_Map.put("TimeZoneDatePicker", " " +
				"<Property Key=\"ShowTimeOff\" Caption=\"显示时差\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>"
		);

		ControlProperties_XML_Map.put("BatchImageUploader", " " +
				"<Property Key=\"MaxSize\" Caption=\"文件大小\" Group=\"组件属性\" Control=\"NumberEditor\" DefaultValue=\"-1\"/>" +
				"<Property Key=\"MaxCount\" Caption=\"文件个数\" Group=\"组件属性\" Control=\"NumberEditor\" DefaultValue=\"-1\"/>"
		);

		ControlProperties_XML_Map.put("MultiStateButton", " " +
				"<Property Key=\"IconLocation\" Caption=\"图标位置\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"Left,左;Top,上;Right,右;Bottom,下\" DefaultValue=\"Left\"/>" +
				"<Property Key=\"OnClick\" Caption=\"点击事件\" Group=\"组件属性\" Type=\"CDATA\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})'/>" +
				"<Property Key=\"StateItemCollection\" Caption=\"下拉项集合\" Group=\"组件属性\" Control=\"ButtonEditor\" OnButtonClick=''/>"
		);

		ControlProperties_XML_Map.put("ComboView", " " +
				"<Property Key=\"Icon\" Caption=\"图标url\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"IconLocation\" Caption=\"图标位置\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"Left,左;Top,上;Right,右;Bottom,下\" DefaultValue=\"Left\"/>"
		);

		ControlProperties_XML_Map.put("VideoPlayer", " " +
				"<Property Key=\"SourceType\" Caption=\"视频来源类型\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"Data,数据;Resource,系统资源;URL,URL\" DefaultValue=\"Data\"/>" +
				"<Property Key=\"Path\" Caption=\"视频来源\" Group=\"组件属性\" Control=\"TextEditor\" Visible=\"GetPropertyValue('SourceType')=='Resource'\" DefaultValue=\"\"/>" +
				"<Property Key=\"UploadProgress\" Caption=\"上传进度指示器的样式\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"None,没有;Strip,条状;Circle,圆环状;Percent,百分比\" DefaultValue=\"None\"/>"
		);

		ControlProperties_XML_Map.put("BarCoder", " " +
				"<Property Key=\"CodeType\" Caption=\"条码类型\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"QR_CODE,QR_CODE;PDF_417,PDF_417;EAN_13,EAN_13;EAN_8,EAN_8;UPC_A,UPC_A;UPC_E,UPC_E;CODABAR,CODABAR;CODE_39,CODE_39;CODE_93,CODE_93;CODE_128,CODE_128\" DefaultValue=\"QR_CODE\"/>"
		);

		ControlProperties_XML_Map.put("NoticeBar", " " +
				"<Property Key=\"PreIcon\" Caption=\"前置图标\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"ActionIcon\" Caption=\"操作图标\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"Scrollable\" Caption=\"可滚动\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"true\"/>" +
				"<Property Key=\"SingleLine\" Caption=\"单行\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"true\"/>" +
				"<Property Key=\"Orientation\" Caption=\"滚动方向\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"Horizontal,水平方向;Vertical,垂直方向\" DefaultValue=\"Horizontal\"/>" +
				"<Property Key=\"Action\" Caption=\"操作图片点击事件\" Group=\"组件属性\" Type=\"CDATA\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})'/>"
		);

		ControlProperties_XML_Map.put("TimeCountDown", " " +
				"<Property Key=\"Format\" Caption=\"显示格式\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"HH:mm:ss\"/>" +
				"<Property Key=\"OnFinish\" Caption=\"计时结束事件\" Group=\"组件属性\" Type=\"CDATA\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})'/>"
		);

		ControlProperties_XML_Map.put("PriceLabel", " " +
				"<Property Key=\"PreText\" Caption=\"前置文本\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"DecimalDigits\" Caption=\"小数位数\" Group=\"组件属性\" Control=\"NumberEditor\" DefaultValue=\"2\"/>" +
				"<Property Key=\"ShowThousandth\" Caption=\"显示千分位\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"true\"/>" +
				"<Property Key=\"ItemCollection\" Caption=\"格式化部分的项的集合\" Group=\"组件属性\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowPriceLabelItemSettingDialog()' DefaultValue=\"点击设置\"/>"
		);

		ControlProperties_XML_Map.put("RelativeTime", " " +
				"<Property Key=\"Interval\" Caption=\"自动更新时间\" Group=\"组件属性\" Control=\"NumberEditor\" DefaultValue=\"60\"/>"
		);

		ControlProperties_Not_Exist_Map.put("HoverButton", new String[]{
				"<Property Key=\"TableKey\" Caption=\"关联表标识\" Group=\"数据关联\" Node='DataBinding' Control=\"ComboBoxEditor\" OnInitialize=\"=Macro_getAllTableKey()\" Visible='Macro_IsBaseControl() && !Macro_InSubDetail(GetPropertyValue(\"Key\"))'/>",
				"<Property Key=\"ColumnKey\" Caption=\"关联字段标识\" Group=\"数据关联\" Node='DataBinding' Control=\"ComboBoxEditor\" OnInitialize=\"=Macro_getAllColumnKey(GetPropertyValue('TableKey','','DataBinding'))\" Visible='Macro_IsBaseControl() && !Macro_InSubDetail(GetPropertyValue(\"Key\"))'/>",
				"<Property Key=\"Required\" Caption=\"必填\" Group=\"数据关联\" Node='DataBinding' Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\" Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"ValueValidation\" Caption=\"值验证事件\" Group=\"数据关联\" Node='DataBinding' Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})' Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"ValueChanged\" Caption=\"值改变事件\" Group=\"数据关联\" Node='DataBinding' Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})' Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"BindingCellKey\" Caption=\"关联单元格标识\" Group=\"数据关联\" Control=\"ComboBoxEditor\" OnInitialize=\"=Macro_setBindingCellKeyByFieldKey(GetPropertyValue('Key'))\" Visible='Macro_IsBaseControl() && Macro_InSubDetail(GetPropertyValue(\"Key\"))'/>",
				"<Property Key=\"AsQuery\" Caption=\"查询\" Group=\"数据关联\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\" Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"Clearable\" Caption=\"查询后清除值\" Group=\"数据关联\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"true\" Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"Condition\" Caption=\"字段查询属性\" Group=\"数据关联\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFieldQueryPropertiesSettingDialog()' DefaultValue=\"点击设置\" Visible='Macro_IsBaseControl()'/>"
		});
		ControlProperties_XML_Map.put("HoverButton", " " +
				"<Property Key=\"Location\" Caption=\"位置\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"top|left,顶部靠左;top,顶部居中;top|right,顶部靠右;center|left,中间靠左;center,中间居中;center|right,中间靠右;bottom|left,底部靠左;bottom,底部居中;bottom|right,底部靠右\" DefaultValue=\"bottom|right\"/>" +
				"<Property Key=\"OnClick\" Caption=\"点击事件\" Group=\"组件属性\" Type=\"CDATA\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})'/>" +
				"<Property Key=\"UploadFile\" Caption=\"上传文件\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"UploadType\" Caption=\"上传方式\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"single,单选上传;multiple,多选上传\" DefaultValue=\"single\"/>" +
				"<Property Key=\"Icon\" Caption=\"图标\" Group=\"组件属性\" Control=\"TextEditor\"/>" +
				"<Property Key=\"IconLocation\" Caption=\"图标位置\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"Left,左;Top,上;Right,右;Bottom,下\" DefaultValue=\"Left\"/>" +
				"<Property Key=\"OnlyIcon\" Caption=\"仅显示图标\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"NeedAuthenticate\" Caption=\"需要认证标志\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"ClickAnim\" Caption=\"点击动画\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\",;Scale,缩放动画\" DefaultValue=\"\"/>" +
				"<Property Key=\"Type\" Caption=\"按钮类型\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"Normal,默认;Primary,主要;Warning,警告;Danger,危险\" DefaultValue=\"Normal\"/>"
		);

		ControlProperties_XML_Map.put("BPMGraph", " " +
				"<Property Key=\"ViewTag\" Caption=\"流程图标记\" Group=\"组件属性\" Control=\"TextEditor\"/>" +
				"<Property Key=\"TableKey\" Caption=\"关联的执行记录表标识\" Group=\"组件属性\" Control=\"TextEditor\"/>" +
				"<Property Key=\"ProcessKey\" Caption=\"流程标识\" Group=\"组件属性\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})'/>" +
				"<Property Key=\"ProcessVer\" Caption=\"流程版本\" Group=\"组件属性\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})'/>" +
				"<Property Key=\"ProcessPath\" Caption=\"流程流转路径\" Group=\"组件属性\" Control=\"TextEditor\"/>" +
				"<Property Key=\"OID\" Caption=\"OID表达式\" Group=\"组件属性\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})'/>"
		);

		ControlProperties_XML_Map.put("WebBrowser", " " +
				"<Property Key=\"SourceType\" Caption=\"来源类型\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"Html,html;Url,url;Resource,resource\" DefaultValue=\"Url\"/>" +
				"<Property Key=\"URLPrefix\" Caption=\"前缀\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>"
		);

		ControlProperties_XML_Map.put("Map", " " +
						"<Property Key=\"Type\" Caption=\"地图类型\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"CUSTOM,自定义;BAIDU,百度;GAODE,高德\" DefaultValue=\"BAIDU\"/>" +
						"<Property Key=\"URL\" Caption=\"地图URL\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>"
				// 参数，事件集合
		);

		ControlProperties_XML_Map.put("RichEditor", "");

		ControlProperties_Not_Exist_Map.put("Chart", new String[]{
				"<Property Key=\"TableKey\" Caption=\"关联表标识\" Group=\"数据关联\" Node='DataBinding' Control=\"ComboBoxEditor\" OnInitialize=\"=Macro_getAllTableKey()\" Visible='Macro_IsBaseControl() && !Macro_InSubDetail(GetPropertyValue(\"Key\"))'/>",
				"<Property Key=\"ColumnKey\" Caption=\"关联字段标识\" Group=\"数据关联\" Node='DataBinding' Control=\"ComboBoxEditor\" OnInitialize=\"=Macro_getAllColumnKey(GetPropertyValue('TableKey','','DataBinding'))\" Visible='Macro_IsBaseControl() && !Macro_InSubDetail(GetPropertyValue(\"Key\"))'/>",
				"<Property Key=\"Required\" Caption=\"必填\" Group=\"数据关联\" Node='DataBinding' Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\" Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"DefaultValue\" Caption=\"默认值\" Group=\"数据关联\" Node='DataBinding' Control=\"TextEditor\" Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"DefaultFormulaValue\" Caption=\"表达式默认值\" Group=\"数据关联\" Node='DataBinding' Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})' Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"ValueDependency\" Caption=\"表达式值依赖\" Group=\"数据关联\" Node='DataBinding' Control=\"TextEditor\" Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"ValueValidation\" Caption=\"值验证事件\" Group=\"数据关联\" Node='DataBinding' Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})' Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"ValueChanged\" Caption=\"值改变事件\" Group=\"数据关联\" Node='DataBinding' Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})' Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"BindingCellKey\" Caption=\"关联单元格标识\" Group=\"数据关联\" Control=\"ComboBoxEditor\" OnInitialize=\"=Macro_InSubDetailSetBindingCell(GetPropertyValue('Key'))\" Visible='Macro_IsBaseControl() && Macro_InSubDetail(GetPropertyValue(\"Key\"))'/>",
				"<Property Key=\"AsQuery\" Caption=\"查询\" Group=\"数据关联\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\" Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"Clearable\" Caption=\"查询后清除值\" Group=\"数据关联\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"true\" Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"Condition\" Caption=\"字段查询属性\" Group=\"数据关联\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFieldQueryPropertiesSettingDialog()' DefaultValue=\"点击设置\" Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"CheckRule\" Caption=\"检查规则\" Group=\"检查规则\" Node='DataBinding' Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})' Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"CheckDependency\" Caption=\"检查规则依赖\" Group=\"检查规则\" Node='DataBinding' Control=\"TextEditor\" Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"ErrorInfo\" Caption=\"错误描述\" Group=\"检查规则\" Node='DataBinding' Control=\"TextEditor\" Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"ErrorStringID\" Caption=\"错误字符串标识\" Group=\"检查规则\" Node='DataBinding' Control=\"TextEditor\" Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"RequiredIcon\" Caption=\"必填项图标\" Group=\"检查规则\" Node='DataBinding' Control=\"TextEditor\" Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"CheckRulePassIcon\" Caption=\"检查通过图标\" Group=\"检查规则\" Node='DataBinding' Control=\"TextEditor\" Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"CheckRuleErrorIcon\" Caption=\"检查错误图标\" Group=\"检查规则\" Node='DataBinding' Control=\"TextEditor\" Visible='Macro_IsBaseControl()'/>"
		});
		ControlProperties_XML_Map.put("Chart", " " +
				"<Property Key=\"ChartType\" Caption=\"图表类型\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"VBar,垂直条状图;StackedVBar,累积垂直条状图;HBar,水平条状图;StackedHBar,累积水平条状图;Area,面积图;Line,线图;Scatter,散点图;Pie,饼图\" DefaultValue=\"Line\"/>" +
				"<Property Key=\"Title\" Caption=\"图表的标题\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"SeriesInRow\" Caption=\"系列在行标志\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"SeriesAxisTitle\" Caption=\"系列轴标题\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"CategoryAxisTitle\" Caption=\"项目轴标题\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"SourceType\" Caption=\"数据来源类型\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\",;DataObject,数据对象;ListView,列表视图;Grid,表格\" DefaultValue=\"\"/>" +
				"<Property Key=\"SourceSetting\" Caption=\"数据来源设置\" Group=\"组件属性\" Control=\"ButtonEditor\" OnButtonClick=\"D_ChartDataSource(GetPropertyValue('SourceType'))\" DefaultValue=\"点击设置\"/>" +
				"<Property Key=\"ShowValues\" Caption=\"显示值\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"true\"/>" +
				"<Property Key=\"Fill\" Caption=\"填满内部\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"HasAnimation\" Caption=\"有显示动画\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"OnClick\" Caption=\"点击事件\" Group=\"组件属性\" Type=\"CDATA\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})'/>"

		);

		ControlProperties_XML_Map.put("ListView", "");
		ControlProperties_XML_Map.put("Grid", "");
		ControlProperties_XML_Map.put("TableView", "");
		
		ControlProperties_XML_Map.put("EditView",
				"<Property Key=\"TableKey\" Caption=\"数据表标识\" Group=\"数据关联\" Control=\"ComboBoxEditor\" OnInitialize=\"=Macro_getAllTableKey()\"/>" +
				"<Property Key=\"RowHeight\" Caption=\"行高\" Group=\"界面显示\" Control=\"NumberEditor\" DefaultValue='-1'/>" +
				"<Property Key=\"PageLoadType\" Caption=\"分页类型\" Group=\"分页策略\" Control=\"Combobox\" OnInitialize=\"NONE,不分页;UI,界面分页;DB,数据库分页\" DefaultValue=\"NONE\"/>" +
				"<Property Key=\"PageRowCount\" Caption=\"分页显示行数\" Group=\"分页策略\" Control=\"NumberEditor\" Default='50' Visible=\"GetPropertyValue('RowType')!='NONE'\"/>" +
				"<Property Key=\"ShowHead\" Caption=\"显示表头\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"DefaultSelectRow\" Caption=\"默认选中行序号\" Group=\"组件属性\" Control=\"NumberEditor\" Default='-1'/>" +
				"<Property Key=\"PromptText\" Caption=\"空值提示\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"PromptImage\" Caption=\"加载中的行视图\" Group=\"组件属性\" Control=\"TextEditor\"/>" +
				"<Property Key=\"PromptRowCount\" Caption=\"加载中的行视图数量\" Group=\"组件属性\" Default='2' Control=\"NumberEditor\"/>" +
				"<Property Key=\"ItemAnim\" Caption=\"行插入删除动画\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"FadeIn,淡入淡出;FadeInRight,从右边淡入淡出;FadeInUp,从上边淡入淡出;FadeInLeft,从左边淡入淡出;FadeInDown,从下边淡入淡出;FlipInBottomX,沿x轴向下翻转;FlipInTopX,沿x轴向上翻转;FlipInLeftY,沿y轴向左翻转;FlipInRightY,沿y轴向右翻转;Landing,膨胀;ScaleIn,缩小;ScaleInBottom,从底部缩放;ScaleInLeft,从左边缩放;ScaleInRight,从右边缩放;ScaleInTop,从顶部缩放;SlideInDown,从底部滑出;SlideInLeft,从左边滑出;SlideInRight,从右边滑出;SlideInUp,从顶部滑出\" DefaultValue=\"FadeIn\"/>" +
				"<Property Key=\"LayoutAnim\" Caption=\"布局动画行,显示动画\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\",;Fade,淡入淡出;SlideInDown,从底部滑入;SlideInRight,从右边滑入;Explode,放大\" DefaultValue=\"\"/>" + 
				"<Property Key=\"Orientation\" Caption=\"布局方向\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"Horizontal,水平方向;Vertical,垂直方向\" DefaultValue=\"Vertical\"/>" +
				"<Property Key=\"ItemCollection\" Caption=\"固定项配置对象集合\" Group=\"组件属性\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowEditViewItemCollectionSettingDialog()' DefaultValue=\"点击设置\"/>" +
				"<Property Key=\"ScrollXY\" Caption=\"允许上下左右滚动\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"EditRowFormKey\" Caption=\"行编辑表单名称\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"ShowTotalRowCount\" Caption=\"显示总行数\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\",;true,是;false,否\" DefaultValue=\"\"/>" +
				"<Property Key=\"HasSubDetail\" Caption=\"有子明细\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"LinkType\" Caption=\"子明细关联方式\" Group=\"明细行属性\" Control=\"Combobox\" OnInitialize=\"Parent,父对象关联;Foreign,外键关联\" DefaultValue='Parent' Visible=\"GetPropertyValue('RowType')=='Detail' && GetPropertyValue('HasSubDetail')=='true'\"/>" + 
				"<Property Key=\"Source\" Caption=\"外键关联的源字段\" Group=\"组件属性\" Control=\"TextEditor\" Visible=\"GetPropertyValue('LinkType')=='Foreign'\"/>" +
 				"<Property Key=\"Target\" Caption=\"外键关联的目标表字段\" Group=\"组件属性\" Control=\"TextEditor\" Visible=\"GetPropertyValue('LinkType')=='Foreign'\"/>" +
 				"<Property Key=\"SeparatorStyle\" Caption=\"间隔样式\" Group=\"列表行属性\" Node='EditViewRow' Control=\"TextEditor\"/>" +
				"<Property Key=\"SeparatorRadius\" Caption=\"间隔圆角\" Group=\"列表行属性\" Node='EditViewRow' Control=\"NumberEditor\"/>" +
				"<Property Key=\"SeparatorColor\" Caption=\"间隔颜色\" Group=\"列表行属性\" Node='EditViewRow' Control=\"TextEditor\"/>" +
				"<Property Key=\"SeparatorOffset\" Caption=\"距离左边界大小\" Group=\"列表行属性\" Node='EditViewRow' Control=\"PxDefSizeEditor\"/>" +
				"<Property Key=\"EditViewRowTopMargin\" Caption=\"顶边界\" Group=\"列表行属性\" Node='EditViewRow' Control=\"PxDefSizeEditor\"/>" +
				"<Property Key=\"RowGap\" Caption=\"行间距\" Group=\"列表行属性\" Node='EditViewRow' Control=\"NumberEditor\"/>" +
				"<Property Key=\"SelectColor\" Caption=\"选中颜色\" Group=\"列表行属性\" Node='EditViewRow' Control=\"ColorEditor\"/>" +
				"<Property Key=\"EditViewRowBackColor\" Caption=\"背景颜色\" Group=\"列表行属性\" Node='EditViewRow' Control=\"ColorEditor\"/>" +
				"<Property Key=\"EditViewRowHighlightColor\" Caption=\"高亮颜色\" Group=\"列表行属性\" Node='EditViewRow' Control=\"ColorEditor\"/>" +
				"<Property Key=\"ActionCollection\" Caption=\"行操作集合\" Group=\"列表行属性\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowRowActionsSettingDialog()' DefaultValue=\"点击设置\"/>" + 
				"<Property Key=\"LayoutType\" Caption=\"根布局类型\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"GridLayout,网格布局;LinearLayout,线性布局\"/>"
//				"<Property Key=\"Layout\" Caption=\"布局定义\" Group=\"布局\" Control=\"ButtonEditor\" DefaultValue=\"点击设置\" OnButtonClick='LoadD_Layout()' Visible=\"GetEditViewLayout()=='GridLayout'\"/>" +
//				"<Property Key=\"LayoutOrientation\" Caption=\"布局方向\" Group=\"布局\" Control=\"Combobox\" OnInitialize=\"Horizontal,水平方向;Vertical,垂直方向\" Visible=\"GetEditViewLayout()=='LinearLayout'\"/>"
				
		);

		ControlProperties_XML_Map.put("CollectionView", "");
		ControlProperties_XML_Map.put("Rotator", "");
		ControlProperties_XML_Map.put("Gallery", "");
		ControlProperties_XML_Map.put("TiledList", "");
		ControlProperties_XML_Map.put("WaterFall", "");
		ControlProperties_XML_Map.put("RotatorList", "");
		ControlProperties_XML_Map.put("WizardList", "");
		ControlProperties_XML_Map.put("SubDetail", " " +
				"<Property Key=\"BindingGridKey\" Caption=\"关联表格标识\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>"
		);

		ControlProperties_XML_Map.put("RefreshControl", ""
				+ "<Property Key=\"Orientation\" Caption=\"方向\" Group=\"组件属性\" Control=\"Combobox\" DefaultValue=\"Vertiacl\" OnInitialize=\"Horizontal,水平方向;Vertical,垂直方向\"/>"
				+ "<Property Key=\"RefreshHeader\" Caption=\"下拉刷新定义\" Group=\"组件属性\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowRefreshHeaderSettingDialog()' DefaultValue=\"点击设置\"/>"
				+ "<Property Key=\"RefreshFooter\" Caption=\"上拉刷新定义\" Group=\"组件属性\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowRefreshFooterSettingDialog()' DefaultValue=\"点击设置\"/>"
				
		);
		ControlProperties_XML_Map.put("ProgressIndicator", "");

		ControlProperties_XML_Map.put("Embed", " " +
				"<Property Key=\"FormKey\" Caption=\"表单标识\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"RootKey\" Caption=\"根组件标识\" Group=\"组件属性\" Control=\"TextEditor\" DefaultValue=\"\"/>" +
				"<Property Key=\"IncludeDataTable\" Caption=\"嵌入数据表标志\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"true\"/>"
		);

		ControlProperties_Not_Exist_Map.put("TabGroup", new String[]{
				"<Property Key=\"TableKey\" Caption=\"关联表标识\" Group=\"数据关联\" Node='DataBinding' Control=\"ComboBoxEditor\" OnInitialize=\"=Macro_getAllTableKey()\" Visible='Macro_IsBaseControl() && !Macro_InSubDetail(GetPropertyValue(\"Key\"))'/>",
				"<Property Key=\"ColumnKey\" Caption=\"关联字段标识\" Group=\"数据关联\" Node='DataBinding' Control=\"ComboBoxEditor\" OnInitialize=\"=Macro_getAllColumnKey(GetPropertyValue('TableKey','','DataBinding'))\" Visible='Macro_IsBaseControl() && !Macro_InSubDetail(GetPropertyValue(\"Key\"))'/>",
				"<Property Key=\"Required\" Caption=\"必填\" Group=\"数据关联\" Node='DataBinding' Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\" Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"DefaultValue\" Caption=\"默认值\" Group=\"数据关联\" Node='DataBinding' Control=\"TextEditor\" Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"DefaultFormulaValue\" Caption=\"表达式默认值\" Group=\"数据关联\" Node='DataBinding' Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})' Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"ValueDependency\" Caption=\"表达式值依赖\" Group=\"数据关联\" Node='DataBinding' Control=\"TextEditor\" Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"ValueValidation\" Caption=\"值验证事件\" Group=\"数据关联\" Node='DataBinding' Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})' Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"ValueChanged\" Caption=\"值改变事件\" Group=\"数据关联\" Node='DataBinding' Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})' Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"BindingCellKey\" Caption=\"关联单元格标识\" Group=\"数据关联\" Control=\"ComboBoxEditor\" OnInitialize=\"=Macro_setBindingCellKeyByFieldKey(GetPropertyValue('Key'))\" Visible='Macro_IsBaseControl() && Macro_InSubDetail(GetPropertyValue(\"Key\"))'/>",
				"<Property Key=\"AsQuery\" Caption=\"查询\" Group=\"数据关联\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\" Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"Clearable\" Caption=\"查询后清除值\" Group=\"数据关联\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"true\" Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"Condition\" Caption=\"字段查询属性\" Group=\"数据关联\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFieldQueryPropertiesSettingDialog()' DefaultValue=\"点击设置\" Visible='Macro_IsBaseControl()'/>"
		});
		ControlProperties_XML_Map.put("TabGroup",""+
				"<Property Key=\"Direction\" Caption=\"方位\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"top,顶部位置;left,左部位置;Right,右部位置;bottom,底部位置;center,中间位置\" DefaultValue=\"bottom\"/>" +
				"<Property Key=\"TabMode\" Caption=\"模式\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"Fixed,固定;Scrollable,滚动\" DefaultValue=\"Fixed\"/>" +
				"<Property Key=\"IndicatorHeight\" Caption=\"指示器高度\" Group=\"组件属性\" Control=\"PxDefSizeEditor\"/>" +
				"<Property Key=\"IndicatorColor\" Caption=\"指示器器颜色\" Group=\"组件属性\" Control=\"ColorEditor\"/>" +
				"<Property Key=\"ClickAnim\" Caption=\"点击动画\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\",;Scale,缩放动画\" DefaultValue=\"\"/>"
		);

		ControlProperties_XML_Map.put("TabItem", ""+
				"<Property Key=\"Key\" Caption=\"标识\" Group=\"Tab项属性\" Control=\"TextEditor\"/>" +
				"<Property Key=\"Text\" Caption=\"名称\" Group=\"Tab项属性\" Control=\"TextEditor\"/>" +
				"<Property Key=\"Icon\" Caption=\"图标\" Group=\"Tab项属性\" Control=\"TextEditor\"/>" +
				"<Property Key=\"FormKey\" Caption=\"表单标识\" Group=\"Tab项属性\" Control=\"ComboBoxEditor\" OnInitialize=\"=Macro_getAllForms()\"/>" +
				"<Property Key=\"Action\" Caption=\"切换事件\" Group=\"Tab项属性\" Control=\"ButtonEditor\" Type=\"CDATA\" OnButtonClick='Macro_ShowFormulaDialog(\"{self.key}\",{{self.value}})'/>" +
				"<Property Key=\"OnClick\" Caption=\"点击事件\" Group=\"Tab项属性\" Type=\"CDATA\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})'/>" +
				"<Property Key=\"SelectedIcon\" Caption=\"选中状态图标\" Group=\"Tab项属性\" Control=\"TextEditor\"/>" +
				"<Property Key=\"ClickAnim\" Caption=\"点击动画\" Group=\"Tab项属性\" Control=\"Combobox\" OnInitialize=\",;Scale,缩放动画\" DefaultValue=\"\"/>" +
				"<Property Key=\"Visible\" Caption=\"可见性\" Group=\"Tab项属性\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog(\"{self.key}\",{{self.value}})'/>" +
				"<Property Key=\"VisibleDependency\" Caption=\"可见性依赖\" Group=\"Tab项属性\" Control=\"TextEditor\"/>" +
				"<Property Key=\"HAlign\" Caption=\"水平对齐\" Group=\"界面样式\" Node='Format' Control=\"Combobox\" OnInitialize=\"Left,居左;Center,居中;Right,居右\" DefaultValue=\"Center\"/>" +
				"<Property Key=\"VAlign\" Caption=\"垂直对齐\" Group=\"界面样式\" Node='Format' Control=\"Combobox\" OnInitialize=\"Top,居上;Center,居中;Bottom,居下\" DefaultValue=\"Center\"/>" +
				"<Property Key=\"ForeColor\" Caption=\"前景色\" Group=\"界面样式\" Node='Format' Control=\"ColorEditor\"/>" +
				"<Property Key=\"BackColor\" Caption=\"背景色\" Group=\"界面样式\" Node='Format' Control=\"ColorEditor\"/>" +
				"<Property Key=\"HighlightColor\" Caption=\"高亮色\" Group=\"界面样式\" Node='Format' Control=\"ColorEditor\"/>" +
				"<Property Key=\"Name\" Caption=\"字体\" Group=\"界面样式\" Node='Format|Font' Control=\"TextEditor\"/>" +
				"<Property Key=\"Size\" Caption=\"字体大小\" Group=\"界面样式\" Node='Format|Font' Control=\"TextEditor\"/>" +
				"<Property Key=\"Bold\" Caption=\"粗体\" Group=\"界面样式\" Node='Format|Font' Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"Italic\" Caption=\"斜体\" Group=\"界面样式\" Node='Format|Font' Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"Underline\" Caption=\"下划线\" Group=\"界面样式\" Node='Format|Font' Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"UnderlineColor\" Caption=\"下划线颜色\" Group=\"界面样式\" Node='Format|Font' Control=\"ColorEditor\"/>"
		);
		ControlProperties_Not_Exist_Map.put("Container", new String[]{
				"<Property Key=\"TableKey\" Caption=\"关联表标识\" Group=\"数据关联\" Node='DataBinding' Control=\"ComboBoxEditor\" OnInitialize=\"=Macro_getAllTableKey()\" Visible='Macro_IsBaseControl() && !Macro_InSubDetail(GetPropertyValue(\"Key\"))'/>",
				"<Property Key=\"ColumnKey\" Caption=\"关联字段标识\" Group=\"数据关联\" Node='DataBinding' Control=\"ComboBoxEditor\" OnInitialize=\"=Macro_getAllColumnKey(GetPropertyValue('TableKey','','DataBinding'))\" Visible='Macro_IsBaseControl() && !Macro_InSubDetail(GetPropertyValue(\"Key\"))'/>",
				"<Property Key=\"Required\" Caption=\"必填\" Group=\"数据关联\" Node='DataBinding' Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\" Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"DefaultValue\" Caption=\"默认值\" Group=\"数据关联\" Node='DataBinding' Control=\"TextEditor\" Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"DefaultFormulaValue\" Caption=\"表达式默认值\" Group=\"数据关联\" Node='DataBinding' Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})' Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"ValueDependency\" Caption=\"表达式值依赖\" Group=\"数据关联\" Node='DataBinding' Control=\"TextEditor\" Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"ValueValidation\" Caption=\"值验证事件\" Group=\"数据关联\" Node='DataBinding' Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})' Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"ValueChanged\" Caption=\"值改变事件\" Group=\"数据关联\" Node='DataBinding' Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})' Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"BindingCellKey\" Caption=\"关联单元格标识\" Group=\"数据关联\" Control=\"ComboBoxEditor\" OnInitialize=\"=Macro_setBindingCellKeyByFieldKey(GetPropertyValue('Key'))\" Visible='Macro_IsBaseControl() && Macro_InSubDetail(GetPropertyValue(\"Key\"))'/>",
				"<Property Key=\"AsQuery\" Caption=\"查询\" Group=\"数据关联\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\" Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"Clearable\" Caption=\"查询后清除值\" Group=\"数据关联\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"true\" Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"Condition\" Caption=\"字段查询属性\" Group=\"数据关联\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFieldQueryPropertiesSettingDialog()' DefaultValue=\"点击设置\" Visible='Macro_IsBaseControl()'/>"
		});
		ControlProperties_XML_Map.put("Container", " " +
				"<Property Key=\"HasTabGroup\" Caption=\"页签组\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"None,无;Contain,包含\" DefaultValue=\"None\"/>" +
				"<Property Key=\"DefaultFormKey\" Caption=\"关联表单标识\" Group=\"组件属性\" Control=\"ComboBoxEditor\" OnInitialize=\"=Macro_getAllForms()\"/>" +
				"<Property Key=\"FormulaFormKey\" Caption=\"关联表达式表单标识\" Group=\"组件属性\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog(\"{self.key}\",{{self.value}})'/>"
		);
		ControlProperties_XML_Map.put("PopView", " " +
				"<Property Key=\"Key\" Caption=\"标识\" Group=\"基础属性\" Control=\"TextEditor\"/>" +
				"<Property Key=\"Caption\" Caption=\"名称\" Group=\"基础属性\" Control=\"TextEditor\"/>" +
				"<Property Key=\"OnClose\" Caption=\"关闭事件\" Group=\"组件属性\" Control=\"ButtonEditor\" Type=\"CDATA\" OnButtonClick='Macro_ShowFormulaDialog(\"{self.key}\",{{self.value}})'/>" +
				"<Property Key=\"OnPostShow\" Caption=\"显示事件\" Group=\"组件属性\" Control=\"ButtonEditor\" Type=\"CDATA\" OnButtonClick='Macro_ShowFormulaDialog(\"{self.key}\",{{self.value}})'/>" +
				"<Property Key=\"PopAnim\" Caption=\"弹出动画\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\",;SLIDEBOTTOM,底部弹出，底部弹回;SLIDEBTOT,底部弹出，顶上弹回;SLIDETOP,顶上弹出，顶上弹回;SLIDETTOB,顶上弹出，底部弹回;FADE,淡入淡出;SCALE,缩放\" DefaultValue=\"\"/>"
		);

		ControlProperties_Not_Exist_Map.put("Carousel", new String[]{
				"<Property Key=\"TableKey\" Caption=\"关联表标识\" Group=\"数据关联\" Node='DataBinding' Control=\"ComboBoxEditor\" OnInitialize=\"=Macro_getAllTableKey()\" Visible='Macro_IsBaseControl() && !Macro_InSubDetail(GetPropertyValue(\"Key\"))'/>",
				"<Property Key=\"ColumnKey\" Caption=\"关联字段标识\" Group=\"数据关联\" Node='DataBinding' Control=\"ComboBoxEditor\" OnInitialize=\"=Macro_getAllColumnKey(GetPropertyValue('TableKey','','DataBinding'))\" Visible='Macro_IsBaseControl() && !Macro_InSubDetail(GetPropertyValue(\"Key\"))'/>",
				"<Property Key=\"Required\" Caption=\"必填\" Group=\"数据关联\" Node='DataBinding' Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\" Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"DefaultValue\" Caption=\"默认值\" Group=\"数据关联\" Node='DataBinding' Control=\"TextEditor\" Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"DefaultFormulaValue\" Caption=\"表达式默认值\" Group=\"数据关联\" Node='DataBinding' Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})' Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"ValueDependency\" Caption=\"表达式值依赖\" Group=\"数据关联\" Node='DataBinding' Control=\"TextEditor\" Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"ValueValidation\" Caption=\"值验证事件\" Group=\"数据关联\" Node='DataBinding' Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})' Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"ValueChanged\" Caption=\"值改变事件\" Group=\"数据关联\" Node='DataBinding' Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})' Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"BindingCellKey\" Caption=\"关联单元格标识\" Group=\"数据关联\" Control=\"ComboBoxEditor\" OnInitialize=\"=Macro_setBindingCellKeyByFieldKey(GetPropertyValue('Key'))\" Visible='Macro_IsBaseControl() && Macro_InSubDetail(GetPropertyValue(\"Key\"))'/>",
				"<Property Key=\"AsQuery\" Caption=\"查询\" Group=\"数据关联\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\" Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"Clearable\" Caption=\"查询后清除值\" Group=\"数据关联\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"true\" Visible='Macro_IsBaseControl()'/>",
				"<Property Key=\"Condition\" Caption=\"字段查询属性\" Group=\"数据关联\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFieldQueryPropertiesSettingDialog()' DefaultValue=\"点击设置\" Visible='Macro_IsBaseControl()'/>"
		});
		ControlProperties_XML_Map.put("Carousel",
				"<Property Key=\"OnClick\" Caption=\"点击事件\" Group=\"组件属性\" Type=\"CDATA\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowFormulaDialog({{self.key}},{{self.value}})'/>" +
						"<Property Key=\"SourceType1\" Caption=\"子项来源\" Group=\"组件属性\" Control=\"ButtonEditor\" OnButtonClick='Macro_ShowCarouselSourceSettingDialog()' DefaultValue=\"点击设置\"/>" +
						"<Property Key=\"ShowDots\" Caption=\"显示指示点\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"true\"/>" +
						"<Property Key=\"Autoplay\" Caption=\"自动播放\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"true\"/>" +
						"<Property Key=\"AutoplayInterval\" Caption=\"自动播放间隔\" Group=\"组件属性\" Control=\"NumberEditor\" Visible='GetPropertyValue(\"Autoplay\", \"true\")==\"true\"' DefaultValue=\"-1\"/>" +
						"<Property Key=\"Infinite\" Caption=\"循环播放\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"true\"/>"
		);

		ControlProperties_XML_Map.put("ModuleEditor", "");

		ControlProperties_XML_Map.put("GridLayoutPanel", " " +
				"<Property Key=\"OddColumnColor\" Caption=\"奇数列背景色\" Group=\"组件属性\" Control=\"ColorEditor\"/>" +
				"<Property Key=\"ForceLayout\" Caption=\"强制自由布局\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"true\"/>"
		);
		ControlProperties_XML_Map.put("ColumnLayoutPanel", "");
		ControlProperties_XML_Map.put("SplitPanel", "");
		ControlProperties_XML_Map.put("PagePanel", "");
		ControlProperties_XML_Map.put("TabPanel", " " +
				"<Property Key=\"TabPosition\" Caption=\"页签位置\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"top,顶部;bottom,底部;left,左部;right,右部\" DefaultValue=\"top\"/>" +
				"<Property Key=\"TabMode\" Caption=\"模式\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"Fixed,固定;Scrollable,滚动\" DefaultValue=\"Fixed\"/>" +
				"<Property Key=\"ShowHead\" Caption=\"显示页签\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"true\"/>" +
				"<Property Key=\"HoverHead\" Caption=\"页签悬停\" Group=\"组件属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"IndicatorHeight\" Caption=\"指示器高度\" Group=\"组件属性\" Control=\"PxDefSizeEditor\"/>" +
				"<Property Key=\"IndicatorColor\" Caption=\"指示器颜色\" Group=\"组件属性\" Control=\"ColorEditor\"/>" +
				"<Property Key=\"ItemChanged\" Caption=\"页签切换事件\" Group=\"组件属性\" Control=\"ButtonEditor\" Type=\"CDATA\" OnButtonClick='Macro_ShowFormulaDialog(\"{self.key}\",{{self.value}})'/>"
		);
		ControlProperties_XML_Map.put("FlowLayoutPanel", "");
		ControlProperties_XML_Map.put("BorderLayoutPanel", "");
		ControlProperties_XML_Map.put("TableLayoutPanel", "");
		ControlProperties_XML_Map.put("FluidTableLayoutPanel", " " +
				"<Property Key=\"RowGap\" Caption=\"行间距\" Group=\"组件属性\" Control=\"NumberEditor\"/>" +
				"<Property Key=\"ColumnGap\" Caption=\"列间距\" Group=\"组件属性\" Control=\"NumberEditor\"/>" +
				"<Property Key=\"RepeatGap\" Caption=\"排列间距\" Group=\"组件属性\" Control=\"NumberEditor\"/>" +
				"<Property Key=\"RepeatCount\" Caption=\"排列重复数\" Group=\"组件属性\" Control=\"NumberEditor\"/>" +
				"<Property Key=\"RowHeight\" Caption=\"默认行高\" Group=\"组件属性\" Control=\"NumberEditor\" DefaultValue='20'/>" +
				"<Property Key=\"ColumnDef\" Caption=\"列定义\" Group=\"组件属性\" Control=\"ButtonEditor\" OnButtonClick=''/>"
		);
		ControlProperties_XML_Map.put("LinearLayoutPanel", "");
		ControlProperties_XML_Map.put("SlidingLayoutPanel", " " +
				"<Property Key=\"Style\" Caption=\"样式\" Group=\"移动端属性\" Control=\"Combobox\" OnInitialize=\"Drawer,抽屉样式;Sliding,侧滑样式;Toggle,缩放样式\" DefaultValue=\"Drawer\"/>" +
				"<Property Key=\"SlipPosition\" Caption=\"侧滑组件默认方向\" Group=\"移动端属性\" Control=\"Combobox\" OnInitialize=\"Left,左边;Right,右边\" DefaultValue=\"Left\"/>" +
				"<Property Key=\"LeftWidth\" Caption=\"左侧滑宽度\" Group=\"移动端属性\" Control=\"DefSizeEditor\" DefaultValue=\"200px\"/>" +
				"<Property Key=\"RightWidth\" Caption=\"右侧滑宽度\" Group=\"移动端属性\" Control=\"DefSizeEditor\" DefaultValue=\"200px\"/>"
		);
		ControlProperties_XML_Map.put("CollapsePanel", " " +
				"<Property Key=\"CollapseType\" Caption=\"折叠样式\" Group=\"移动端属性\" Control=\"Combobox\" OnInitialize=\"Multiple,折叠样式;Accordion,手风琴样式\" DefaultValue=\"Multiple\"/>"
		);
		ControlProperties_XML_Map.put("FlexGridLayoutPanel", " " +
				"<Property Key=\"ColumnCount\" Caption=\"列数\" Group=\"组件属性\" Control=\"NumberEditor\"/>" +
				"<Property Key=\"RowGap\" Caption=\"行间距\" Group=\"组件属性\" Control=\"NumberEditor\"/>" +
				"<Property Key=\"ColumnGap\" Caption=\"列间距\" Group=\"组件属性\" Control=\"NumberEditor\"/>" +
				"<Property Key=\"RowHeight\" Caption=\"默认行高\" Group=\"组件属性\" Control=\"NumberEditor\" DefaultValue='30'/>"
		);

		ControlProperties_XML_Map.put("FlexFlowLayoutPanel", "");

		ControlProperties_XML_Map.put("BorderLayout", "");
		ControlProperties_XML_Map.put("ColumnLayout", "");
		ControlProperties_XML_Map.put("FluidLayout", "");

		ControlProperties_XML_Map.put("GridLayout",
				"<Property Key=\"Layout\" Caption=\"布局定义\" Group=\"布局属性\" Control=\"ButtonEditor\" DefaultValue=\"点击设置\" OnButtonClick='LoadD_Layout()'/>"
		);

		ControlProperties_XML_Map.put("SplitLayout",
				"<Property Key=\"Orientation\" Caption=\"布局方向\" Group=\"布局属性\" Control=\"Combobox\" DefaultValue=\"Horizontal\" OnInitialize=\"Horizontal,水平方向;Vertical,垂直方向\"/>"
		);

		ControlProperties_XML_Map.put("FlowLayout", "");
		ControlProperties_XML_Map.put("FlexFlowLayout", "");

		ControlProperties_XML_Map.put("TabLayout",
				"<Property Key=\"TabPosition\" Caption=\"页签位置\" Group=\"布局属性\" Control=\"Combobox\" OnInitialize=\"Top,顶部;Bottom,底部;Left,左部;Right,右部\" DefaultValue=\"Top\"/>" +
				"<Property Key=\"TabMode\" Caption=\"模式\" Group=\"布局属性\" Control=\"Combobox\" OnInitialize=\"Fixed,固定;Scrollable,滚动\" DefaultValue=\"Fixed\"/>" +
				"<Property Key=\"ShowHead\" Caption=\"显示页签\" Group=\"布局属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"true\"/>" +
				"<Property Key=\"HoverHead\" Caption=\"页签悬停\" Group=\"布局属性\" Control=\"Combobox\" OnInitialize=\"true,是;false,否\" DefaultValue=\"false\"/>" +
				"<Property Key=\"IndicatorHeight\" Caption=\"指示器高度\" Group=\"布局属性\" Control=\"PxDefSizeEditor\"/>" +
				"<Property Key=\"IndicatorColor\" Caption=\"指示器颜色\" Group=\"布局属性\" Control=\"ColorEditor\"/>" +
				"<Property Key=\"ItemChanged\" Caption=\"页签切换事件\" Group=\"布局属性\" Control=\"ButtonEditor\" Type=\"CDATA\" OnButtonClick='Macro_ShowFormulaDialog(\"{self.key}\",{{self.value}})'/>"				
		);

		ControlProperties_XML_Map.put("TableLayout", "");
		ControlProperties_XML_Map.put("FluidTableLayout", "");

		ControlProperties_XML_Map.put("LinearLayout",
				"<Property Key=\"Orientation\" Caption=\"布局方向\" Group=\"布局属性\" Control=\"Combobox\" DefaultValue=\"Horizontal\" OnInitialize=\"Horizontal,水平方向;Vertical,垂直方向\"/>"
		);

		ControlProperties_XML_Map.put("WizardLayout", "");
		ControlProperties_XML_Map.put("SlidingLayout", "");
		ControlProperties_XML_Map.put("TableViewLayout", "");
		ControlProperties_XML_Map.put("CustomLayout", "");
		ControlProperties_XML_Map.put("FlexBox", "");
		ControlProperties_XML_Map.put("Collapse", "");
		ControlProperties_XML_Map.put("FlexGridLayout",
				"<Property Key=\"ColumnCount\" Caption=\"列数\" Group=\"组件属性\" Control=\"NumberEditor\"/>" +
				"<Property Key=\"RowGap\" Caption=\"行间距\" Group=\"组件属性\" Control=\"NumberEditor\"/>" +
				"<Property Key=\"ColumnGap\" Caption=\"列间距\" Group=\"组件属性\" Control=\"NumberEditor\"/>" +
				"<Property Key=\"RowHeight\" Caption=\"默认行高\" Group=\"组件属性\" Control=\"NumberEditor\" DefaultValue='30'/>"
		);
	}

	public static String getDefineXML() {
		return "<FormMap>"
					+ "<DefineCollection>"
						+ getProperties()
					+ "</DefineCollection>"
				+ "</FormMap>";
	}

	private static String getProperties() {
		String result = "";
		for (String key : ControlProperties_XML_Map.keySet()) {
			String xml = ControlProperties_XML_Map.get(key);
			boolean isPanel = key.endsWith("Panel");
			String properties = "", caption = "";
			if (key.equals("Form")) {
				properties = xml;
				caption = "表单属性";
			} else if (key.equals("Block") || key.equals("PopView")) {
				properties = xml;
			} else if (key.equals("TableRow") || key.equals("CollectionViewRow")) {
				properties = xml;
			} else if (key.equals("TabItem")) {
				properties = xml;
			} else if (key.equals("GridLayout")
					|| key.equals("LinearLayout")
					|| key.equals("FlexFlowLayout")
					|| key.equals("ColumnLayout")
					|| key.equals("SplitLayout")
					|| key.equals("TabLayout")
					|| key.equals("FlowLayout")
					|| key.equals("FlexGridLayout")) {
				properties = BaseLayoutProperties_XML + xml;
			} else {
				properties += BaseProperties_XML;
				String[] notExistProperties = ControlProperties_Not_Exist_Map.get(key);
				if (notExistProperties != null) {
					for (String notExistPro : notExistProperties) {
						properties = properties.replace(notExistPro, "");
					}
				}
				properties += (isPanel ? BasePanelProperties_XML : "") + xml;

				// 添加EditViewColumn各种类型的控件
				if (!isPanel) {
					result += "<Define Key=\"EditViewColumn_" + key + "\" Caption=\"" + caption + "\" Extends=\"\">"
								+ "<PropertyCollection>"
									+ EditViewColumn_XML
									+ xml
								+ "</PropertyCollection>"
							+ "</Define>";
				}
			}
			result += "<Define Key=\"" + key + "\" Caption=\"" + caption + "\" Extends=\"\">"
						+ "<PropertyCollection>"
							+ properties
						+ "</PropertyCollection>"
					+ "</Define>";
		}
		return result;
	}
}
