package com.bokesoft.yes.design.enums;

/***
 * 节点Key和Caption枚举
 * @date 2020-09-27
 * @author zhsy
 */
public enum NodeKeyAndCaptionEnum {
	/**
	 * 节点key及对应的caption
	 **/
	Begin("Begin", "开始节点"),
	End("End", "结束节点"),
	BranchEnd("BranchEnd", "分支结束"),
	UserTask("UserTask", "用户任务"),
	ServiceTask("ServiceTask", "系统任务"),
	ManualTask("ManualTask", "人工任务"),
	Audit("Audit", "审批任务"),
	Decision("Decision", "选择节点"),
	State("State", "状态节点"),
	Fork("Fork", "分支节点"),
	Join("Join", "合并节点"),
	ExclusiveFork("ExclusiveFork", "互斥分支"),
	ComplexJoin("ComplexJoin", "复杂合并"),
	DataMap("DataMap", "数据映射"),
	SubProcess("SubProcess", "子流程"),
	Inline("Inline", "内联流程"),
	StateAction("StateAction", "状态机操作"),
	Countersign("Countersign", "会签节点"),
	Swimline("Swimline", "泳道"),
	GateWay("GateWay", "路由节点"),
	MultiUserTask("MultiUserTask", "多人任务节点"),
	MultiAudit("MultiAudit", "多人审批节点"),
	SequenceFlow("SequenceFlow", "顺序流"),
	Association("Association", "关联线"),
	ExceptionFlow("ExceptionFlow", "异常流");

	/***key*/
	private String key;
	/***caption*/
	private String caption;

	NodeKeyAndCaptionEnum(String key, String caption) {
		this.key = key;
		this.caption = caption;
	}

	/***
	 * 获取key
	 * @return
	 */
	public String getKey() {
		return key;
	}

	/***
	 * 设置key
	 * @return
	 */
	public void setKey(String key) {
		this.key = key;
	}

	/***
	 * 获取caption
	 * @return
	 */
	public String getCaption() {
		return caption;
	}

	/***
	 * 设置caption
	 * @return
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}
}