package com.bokesoft.yes.design.datamap.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;

import com.bokesoft.erp.WebDesignerConfiguration;
import com.bokesoft.yes.helper.DataObjectHelper;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigrationProfile;
import com.bokesoft.yigo.meta.form.component.control.MetaDataBinding;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.tree.DefaultCDATA;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.dataMigration.util.DataMigrationOperJsonUtil;
import com.bokesoft.yes.design.dataMigration.util.DataMigrationOperXmlUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.design.utils.DesignReloadMetaObject;
import com.bokesoft.yes.design.utils.IDLookup;
import com.bokesoft.yes.design.utils.ReloadForm;
import com.bokesoft.yes.design.utils.TwoTuple;
import com.bokesoft.yes.design.utils.XMLWriter;
import com.bokesoft.yes.design.utils.XmlFormat;
import com.bokesoft.yes.design.utils.publicMethodUtil;
import com.bokesoft.yes.design.vo.JsonDataMapVo;
import com.bokesoft.yes.design.vo.ResponseResult;
import com.bokesoft.yes.design.xml.XmlParser;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.design.xml.node.Xml4jUtil;
import com.bokesoft.yes.design.xml.node.XmlTree;

import com.bokesoft.yes.util.DataConstant;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.def.FormType;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectList;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectProfile;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.MetaFormProfile;

public class DataMapOperXmlUtil {
	private static final Logger logger = Logger.getLogger(DataMapOperXmlUtil.class.getName());
	/***数据迁移操作类*/
	private static final DataMapOperJsonUtil dataMapOperJsonUtil;
	private static final DataMigrationOperJsonUtil dataMigrationOperJsonUtil;

	static {
		dataMigrationOperJsonUtil = new DataMigrationOperJsonUtil();
		dataMapOperJsonUtil = new DataMapOperJsonUtil();
	}

	/***
	 * 更新xml文件
	 * @param jsonDataMapVo 前端传过来的数据对象
	 * @return 新增结果
	 */
	public ResponseResult<JSONArray> dataMapUpdateXml(JsonDataMapVo jsonDataMapVo) throws Throwable {
		ResponseResult<JSONArray> result = new ResponseResult<>();
		FileOutputStream fileOutputStream = null;
		XMLWriter writer = null;
		String filePaths = jsonDataMapVo.getFilePath();
		// 前端传过来的要更新的json
		JSONObject frontUpdateJson = JSON.parseObject(jsonDataMapVo.getContent());
		if (jsonDataMapVo.getBatchAddArr() != null && jsonDataMapVo.getBatchAddArr().size() >= 0) {
			String tempPath = XmlFileProcessor.instance.getTmpFile(filePaths);
			if (StringUtils.isBlank(tempPath)) {
				tempPath = filePaths;
			}
			// 创建SAX读取器
			SAXReader reader = new SAXReader();
			// 加载文档
			Document document = reader.read(new File(tempPath));
			for (String field : jsonDataMapVo.getBatchAddArr()) {
				frontUpdateJson.put("value", field);
				try {
					getJsonArrayResponseResultByArry(frontUpdateJson, jsonDataMapVo, result, document);
				} catch (Exception e) {
					logger.warning("更新xml异常，异常为:" + ExceptionUtils.getStackTrace(e));
					result.setCode(999);
					result.setMsg("更新xml失败，失败消息为:" + e.getMessage());
				} catch (Throwable throwable) {
					logger.warning(throwable.getMessage());
				}
			}
			OutputFormat format = getOutputFormat();
			String solutionPath = FilePathHelper.getWorkspacePath() + File.separator;
			String newFilePath = Paths.get(WebDesignerConfiguration.getDesignerDataPath(), "tmp", filePaths.substring(solutionPath.length()).replace(File.separator, "__") + "." + System.currentTimeMillis()).toString();
			fileOutputStream = new FileOutputStream(newFilePath);
			XmlFileProcessor.stackput(filePaths, newFilePath);
			writer = new XMLWriter(fileOutputStream, format);
			writer.write(document);
			result.setCode(0);
			result.setMsg("更新xml成功");
			setData(result, filePaths);
			closeFileStream(fileOutputStream, writer);
		} else {
			getJsonArrayResponseResult(frontUpdateJson, jsonDataMapVo, result, fileOutputStream, writer, filePaths);
		}
		return result;
	}

	private ResponseResult<JSONArray> getJsonArrayResponseResultByArry(JSONObject frontUpdateJson,
																	   JsonDataMapVo jsonDataMapVo,
																	   ResponseResult<JSONArray> result,
																	   Document document) throws Throwable {


		ResponseResult<JSONArray> result1 = getJsonArrayResponseResult(frontUpdateJson, jsonDataMapVo, result, document);
		return result1;
	}

	private ResponseResult<JSONArray> getJsonArrayResponseResult(JSONObject frontUpdateJson, JsonDataMapVo jsonDataMapVo, ResponseResult<JSONArray> result, Document document) throws Throwable {
		//目标字段用于更新的时候作为判断条件，防止修改重复字段
		String targetField = jsonDataMapVo.getTargetField();
		// 获取的根节点是临时文件的根节点，再未保存前就修改临时文件
		Element root = document.getRootElement();
		boolean mergeToSource = StringUtils.isNotEmpty(root.attributeValue("MergeToSource"));
		boolean extend = StringUtils.isNotEmpty(root.attributeValue("Extend"));
		//当前的Formkey
		String formKey = jsonDataMapVo.getFormKey();
		//修改前的值
		String oldValue = jsonDataMapVo.getOldValue();
		if (oldValue != null) {
			oldValue = oldValue.replaceAll("'", "\"");

		}
		// 要更新键值
		String key = frontUpdateJson.getString("key");
		String keyID = frontUpdateJson.getString("keyID");
		//获取宽度
		String width = frontUpdateJson.getString("width");
		//获取箭头所指的字段
		String endField = frontUpdateJson.getString("targetField");
		// 更新后的值

		if (endField != null) {
			endField = endField.replaceAll("'", "\"");
		}


		String value = "", field = "", nodeName = "", tableKey = "", type = "", fieldKey = "";
		try {
			//获取tabelkey
			tableKey = frontUpdateJson.getString("tableKey");
			//获取类型
			type = frontUpdateJson.getString(ConstantUtil.TYPE);
			//获取当前操作的是哪一个字段
			fieldKey = frontUpdateJson.getString("fieldKey");
			if (fieldKey != null) {
				fieldKey = fieldKey.replaceAll("'", "\"");
			}
		} catch (Exception e) {
			logger.warning(e.getMessage());
		}
		if ("formField".equalsIgnoreCase(key) || "targetFormField".equalsIgnoreCase(key)) {
			value = frontUpdateJson.getString("value");
			String[] split = value.split("_@_");
			formKey = split[4];
			field = split[1];
			tableKey = split[3];
			nodeName = jsonDataMapVo.getNodeName();
		} else if (key.contains("feedbackFormField")) {
			value = frontUpdateJson.getString("value");
			String[] split = value.split("_@_");
			formKey = split[4];
			field = split[1];
			tableKey = split[3];
			nodeName = jsonDataMapVo.getNodeName();
		} else if ("StatusFieldKey_Feed".equalsIgnoreCase(key) || "Condition_Feed".equalsIgnoreCase(key) || "StatusValue_Feed".equalsIgnoreCase(key)) {
			nodeName = "";
			value = frontUpdateJson.getString("value");
		} else {
			nodeName = jsonDataMapVo.getNodeName();
			value = frontUpdateJson.getString("value");
			if (value != null) {
				value = value.replaceAll("'", "\"");
			}
		}
		//根据情况去添加节点
		String tableNode = "", filedNode = "";
		List<Element> elements = null;
		if (ConstantUtil.SOURCE_TABLE_COLLECTION.equalsIgnoreCase(nodeName)) {
			tableNode = ConstantUtil.SOURCE_TABLE;
			filedNode = ConstantUtil.SOURCE_FIELD;
			elements = root.element(nodeName).elements(tableNode);
		} else if (ConstantUtil.TARGET_TABLE_COLLECTION.equalsIgnoreCase(nodeName)) {
			tableNode = ConstantUtil.TARGET_TABLE;
			filedNode = ConstantUtil.TARGET_FIELD;
			elements = root.element(nodeName).elements(tableNode);
		} else if (ConstantUtil.FEEDBACK_COLLECTION.equalsIgnoreCase(nodeName)) {
			if (!"sourcekey".equalsIgnoreCase(key)) {
				key = "FeedBackField";

			}
			tableNode = ConstantUtil.FEEDBACK_TABLE;
			filedNode = "FeedbackField";
		}
		if (formKey != null) {
			formKey = formKey.split("__")[0];
			String name = root.getName();
			if (ConstantUtil.MAP.equalsIgnoreCase(name)) {//数据映射
				if (ConstantUtil.SOURCE_TABLE_COLLECTION.equalsIgnoreCase(nodeName)) {
					formKey = root.attributeValue(ConstantUtil.SRC_FORM_KEY);
				} else if (ConstantUtil.TARGET_TABLE_COLLECTION.equalsIgnoreCase(nodeName)) {
					formKey = root.attributeValue(ConstantUtil.TGT_FORM_KEY);
				} else if (ConstantUtil.FEEDBACK_COLLECTION.equalsIgnoreCase(nodeName)) {
					List<Element> feedbackElements = root.element(ConstantUtil.FEEDBACK_COLLECTION).elements(ConstantUtil.FEEDBACK_OBJECT);
					for (Element element1 : feedbackElements) {
						if (formKey.equalsIgnoreCase(element1.attributeValue(ConstantUtil.FORM_KEY))) {
							formKey = element1.attributeValue(ConstantUtil.FORM_KEY);
							break;
						}
					}
				}
			} else {//数据迁移
				if (ConstantUtil.SOURCE_TABLE_COLLECTION.equalsIgnoreCase(nodeName)) {
					formKey = root.attributeValue(ConstantUtil.SRC_DATA_OBJECT_KEY);
				} else if (ConstantUtil.TARGET_TABLE_COLLECTION.equalsIgnoreCase(nodeName)) {
					formKey = root.attributeValue(ConstantUtil.TGT_DATA_OBJECT_KEY);
				}
			}
		}
		String name = root.getQName().getName();
		String nodeKey = ConstantUtil.KEY;
		if (ConstantUtil.DATA_MIGRATION.equalsIgnoreCase(name)) {
			nodeKey = ConstantUtil.TABLE_KEY;
		}
		switch (key) {
			case ConstantUtil.CAPTION:
			case "RemainderPushValue":
			case "MinPushValue":
			case "MapCondition":
			case "PostProcess":
			case "StatusFieldKey":
			case "StatusValue":
			case "DetailCondition":
			case "HeadCondition":
			case ConstantUtil.DESCRIPTION:
				if ("DetailCondition".equalsIgnoreCase(key)) {
					key = "Condition";
				}
				if (StringUtils.isNotEmpty(value)) {
					root.addAttribute(key, value);
				} else {
					deleteXmlElementAttribute(root, root.attribute(key));
				}
				break;
			case "StatusFieldKey_Feed":
				Element element5 = root.element(ConstantUtil.FEEDBACK_COLLECTION);
				if (StringUtils.isNotEmpty(value)) {
					element5.addAttribute("StatusFieldKey", value);
				} else {
					deleteXmlElementAttribute(element5, element5.attribute("StatusFieldKey"));
				}
				break;
			case "StatusValue_Feed":
				Element element3 = root.element(ConstantUtil.FEEDBACK_COLLECTION);
				if (StringUtils.isNotEmpty(value)) {
					element3.addAttribute("StatusValue", value);
				} else {
					deleteXmlElementAttribute(element3, element3.attribute("StatusValue"));
				}
				break;
			case "Condition_Feed":
				Element element4 = root.element(ConstantUtil.FEEDBACK_COLLECTION);
				if (StringUtils.isNotEmpty(value)) {
					element4.addAttribute("Condition", value);
				} else {
					deleteXmlElementAttribute(element4, element4.attribute("Condition"));
				}
				break;
			case "MapRelationValue":
			case "AllowRemainderPush":
			case "MarkMapCount":
				if ("false".equalsIgnoreCase(value)) {
					root.addAttribute(key, value);
				} else {
					deleteXmlElementAttribute(root, root.attribute(key));
				}
				break;
			case "PullDataOnly":
				if ("true".equalsIgnoreCase(value)) {
					root.addAttribute(key, value);
				} else {
					deleteXmlElementAttribute(root, root.attribute(key));
				}
				break;
			case "sourceTypeKey":
				Element node = (Element) root.selectSingleNode("/Map/SourceTableCollection/SourceTable[@Key='" + tableKey + "']");
				String maxKey1 = node.attributeValue("MaxKey");
				Element elements11 = (Element) root.selectSingleNode("/Map/SourceTableCollection/SourceTable[@Key='" + tableKey + "']/SourceField[@Definition='" + fieldKey + "'][@TargetFieldKey='" + endField + "']");
				if ("default".equals(value)) {
					if (mergeToSource) {
						if (StringUtils.isNotEmpty(maxKey1)) {
							node.addAttribute("MaxKey", (Integer.valueOf(maxKey1) + 1) + "");
							elements11.addAttribute("Key", "merge_" + (Integer.valueOf(maxKey1) + 1));
						} else {
							node.addAttribute("MaxKey", node.elements().size() + "");
							elements11.addAttribute("Key", "merge_" + node.elements().size());

						}
					} else {
						if (StringUtils.isNotEmpty(maxKey1)) {
							node.addAttribute("MaxKey", (Integer.valueOf(maxKey1) + 1) + "");
							elements11.addAttribute("Key", "field_" + (Integer.valueOf(maxKey1) + 1));
						} else {
							node.addAttribute("MaxKey", node.elements().size() + "");
							elements11.addAttribute("Key", "field_" + node.elements().size());

						}
					}

				} else {
					elements11.addAttribute("Key", value);
				}
				break;
			case "formField":
			case "targetFormField":
				Element element = root.element(nodeName);
				//为空就说明是第一次添加，去创建
				Element tabelele = null;
				if (Objects.isNull(element.element(tableNode))) {
					tabelele = element.addElement(tableNode);
					if (ConstantUtil.DATA_MIGRATION.equalsIgnoreCase(name)) {
						tabelele.addAttribute(ConstantUtil.TABLE_KEY, tableKey);
						if (nodeName.equalsIgnoreCase(ConstantUtil.TARGET_TABLE_COLLECTION)) {
							tabelele.addElement(filedNode).addAttribute(ConstantUtil.FIELD_KEY, field);
						} else {
							tabelele.addElement(filedNode).addAttribute(ConstantUtil.DEFINITION, field);
						}
					} else {
						tabelele.addAttribute(ConstantUtil.DATA_SOURCE, tableKey);
						tabelele.addAttribute(ConstantUtil.KEY, tableKey);
						tabelele.addAttribute(ConstantUtil.TYPE, "Table");
						if (nodeName.equalsIgnoreCase(ConstantUtil.SOURCE_TABLE_COLLECTION)) {
							if (mergeToSource) {
								tabelele.addElement(filedNode).addAttribute(ConstantUtil.DEFINITION, field).addAttribute(ConstantUtil.KEY, "merge_1");
								tabelele.addAttribute("MaxKey", "1");
							} else {
								if (!extend) {
									tabelele.addElement(filedNode).addAttribute(ConstantUtil.DEFINITION, field).addAttribute(ConstantUtil.KEY, "1");
									tabelele.addAttribute("MaxKey", "1");
								} else {
									tabelele.addElement(filedNode).addAttribute(ConstantUtil.DEFINITION, field).addAttribute(ConstantUtil.KEY, "field_1");
									tabelele.addAttribute("MaxKey", "1");
								}

							}
						} else {
							tabelele.addElement(filedNode).addAttribute(ConstantUtil.DEFINITION, field);
						}


					}
				} else {
					List<Element> tableList = element.elements(tableNode);
					List<String> list = new ArrayList<String>();
					//根据XML数据格式获取Tablekey，同时去确认是哪一种数据格式在进行添加操作的时候做不同处理
					for (Element eleList : tableList) {
						if (ConstantUtil.MAP.equalsIgnoreCase(name)) {
							list.add(eleList.attributeValue(ConstantUtil.KEY));
						} else if (ConstantUtil.DATA_MIGRATION.equalsIgnoreCase(name)) {
							list.add(eleList.attributeValue(ConstantUtil.TABLE_KEY));
						}
					}
					//如果当前表还没有table节点,就先创建一个
					if (!list.contains(tableKey)) {
						tabelele = element.addElement(tableNode);
						//数据映射和数据迁移的XML结构有点差异，这里添加的时候做不同处理
						if (ConstantUtil.DATA_MIGRATION.equalsIgnoreCase(name)) {
							tabelele.addAttribute(ConstantUtil.TABLE_KEY, tableKey);
							if ("targetFormField".equalsIgnoreCase(key)) {
								tabelele.addElement(filedNode).addAttribute(ConstantUtil.FIELD_KEY, field);
							} else {
								tabelele.addElement(filedNode).addAttribute(ConstantUtil.DEFINITION, field);
							}
						} else {
							tabelele.addAttribute(ConstantUtil.DATA_SOURCE, tableKey);
							tabelele.addAttribute(ConstantUtil.KEY, tableKey);
							tabelele.addAttribute(ConstantUtil.TYPE, "Table");
							if (nodeName.equalsIgnoreCase(ConstantUtil.SOURCE_TABLE_COLLECTION)) {
								if (mergeToSource) {
									tabelele.addElement(filedNode).addAttribute(ConstantUtil.DEFINITION, field).addAttribute(ConstantUtil.KEY, "merge_1");
									tabelele.addAttribute("MaxKey", "1");
								} else {
									if (!extend) {
										tabelele.addElement(filedNode).addAttribute(ConstantUtil.DEFINITION, field).addAttribute(ConstantUtil.KEY, "1");
										tabelele.addAttribute("MaxKey", "1");
									} else {
										tabelele.addElement(filedNode).addAttribute(ConstantUtil.DEFINITION, field).addAttribute(ConstantUtil.KEY, "field_1");
										tabelele.addAttribute("MaxKey", "1");
									}
								}
							} else {
								tabelele.addElement(filedNode).addAttribute(ConstantUtil.DEFINITION, field);
							}
						}
					} else {
						//如果当前tableKey在XMl中已经存在就直接进行添加
						findTablekey(nodeName, field, tableKey, filedNode, tableList, name, mergeToSource, extend);
					}
				}
				break;
			case "sourceContent":
			case "sourcekey":
				if (ConstantUtil.FEEDBACK_COLLECTION.equalsIgnoreCase(nodeName)) {
					//用于判断是否是当前表的第一个字段
					List<Element> feedbackObject = root.element(nodeName).elements(ConstantUtil.FEEDBACK_OBJECT);
					for (Element ele : feedbackObject) {
						List<Element> feedbackTable = ele.elements(tableNode);
						for (Element element1 : feedbackTable) {
							if (element1.attributeValue(ConstantUtil.TABLE_KEY).equalsIgnoreCase(tableKey)) {
								if (StringUtils.isNotEmpty(value)) {
									//字段已经存在就进行修改，不存在就进行添加
									if (StringUtils.isNotEmpty(oldValue)) {
										List<Element> Field = element1.elements(filedNode);
										for (Element eleCoustOrFormula : Field) {
											if (eleCoustOrFormula.attributeValue(ConstantUtil.FIELD_KEY).equalsIgnoreCase(oldValue)) {
												eleCoustOrFormula.addAttribute(ConstantUtil.FIELD_KEY, value);
											}
										}
									} else {
										ele.addElement(filedNode).addAttribute(ConstantUtil.FIELD_KEY, value);
									}
								}
							}
						}
					}
				} else {
					for (Element ele : elements) {
						String table = getTableKey(ele);
						if (table.equalsIgnoreCase(tableKey)) {
							List<Element> Field = ele.elements(filedNode);
							if (StringUtils.isNotEmpty(value)) {
								//字段已经存在就进行修改，不存在就进行添加
								if (StringUtils.isNotEmpty(oldValue)) {
									for (Element eleCoustOrFormula : Field) {
										String name1 = root.getName();
										if (!ConstantUtil.DATA_MIGRATION.equalsIgnoreCase(name1) && !ConstantUtil.TARGET_FIELD.equalsIgnoreCase(filedNode)) {
											if (eleCoustOrFormula.attributeValue(ConstantUtil.KEY).equalsIgnoreCase(keyID)
													|| eleCoustOrFormula.attributeValue(ConstantUtil.DEFINITION).equalsIgnoreCase(oldValue)) {
												eleCoustOrFormula.addAttribute(ConstantUtil.DEFINITION, value);
											}
										} else {
											if (eleCoustOrFormula.attributeValue(ConstantUtil.DEFINITION).equalsIgnoreCase(oldValue)) {
												eleCoustOrFormula.addAttribute(ConstantUtil.DEFINITION, value);
											}
										}
									}
								} else {
									Node node1 = ele.selectSingleNode("SourceField[@Definition='" + value + "']");
									if (node1 != null) {
										break;
									}
									String maxKey = ele.attributeValue("MaxKey");
									if (mergeToSource) {//功能马甲
										if (StringUtils.isNotEmpty(maxKey)) {
											ele.addElement(filedNode)
													.addAttribute(ConstantUtil.DEFINITION, value)
													.addAttribute(ConstantUtil.TYPE, type)
													.addAttribute("Key", "merge_" + (Integer.valueOf(maxKey) + 1));
											ele.addAttribute("MaxKey", (Integer.valueOf(maxKey) + 1) + "");
										} else {
											ele.addElement(filedNode)
													.addAttribute(ConstantUtil.DEFINITION, value)
													.addAttribute(ConstantUtil.TYPE, type)
													.addAttribute("Key", "merge_" + ele.elements().size());
											ele.addAttribute("MaxKey", ele.elements().size() + "");
										}
									} else {
										if (!extend) {
											if (StringUtils.isNotEmpty(maxKey)) {
												if (ConstantUtil.TARGET_FIELD.equalsIgnoreCase(filedNode)) {
													ele.addElement(filedNode)
															.addAttribute(ConstantUtil.DEFINITION, value)
															.addAttribute(ConstantUtil.TYPE, type);
												} else {
													ele.addElement(filedNode)
															.addAttribute(ConstantUtil.DEFINITION, value)
															.addAttribute(ConstantUtil.TYPE, type)
															.addAttribute("Key", (Integer.valueOf(maxKey) + 1) + "");
												}
												ele.addAttribute("MaxKey", (Integer.valueOf(maxKey) + 1) + "");
											} else {
												if (ConstantUtil.TARGET_FIELD.equalsIgnoreCase(filedNode)) {
													ele.addElement(filedNode)
															.addAttribute(ConstantUtil.DEFINITION, value)
															.addAttribute(ConstantUtil.TYPE, type);
												} else {
													ele.addElement(filedNode)
															.addAttribute(ConstantUtil.DEFINITION, value)
															.addAttribute(ConstantUtil.TYPE, type)
															.addAttribute("Key", ele.elements().size() + "");
												}
												ele.addAttribute("MaxKey", ele.elements().size() + "");
											}
										} else {
											if (StringUtils.isNotEmpty(maxKey)) {
												if (ConstantUtil.TARGET_FIELD.equalsIgnoreCase(filedNode)) {
													ele.addElement(filedNode)
															.addAttribute(ConstantUtil.DEFINITION, value)
															.addAttribute(ConstantUtil.TYPE, type);
												} else {
													ele.addElement(filedNode)
															.addAttribute(ConstantUtil.DEFINITION, value)
															.addAttribute(ConstantUtil.TYPE, type)
															.addAttribute("Key", "field_" + (Integer.valueOf(maxKey) + 1));
												}
												ele.addAttribute("MaxKey", (Integer.valueOf(maxKey) + 1) + "");
											} else {
												if (ConstantUtil.TARGET_FIELD.equalsIgnoreCase(filedNode)) {
													ele.addElement(filedNode)
															.addAttribute(ConstantUtil.DEFINITION, value)
															.addAttribute(ConstantUtil.TYPE, type);
												} else {
													ele.addElement(filedNode)
															.addAttribute(ConstantUtil.DEFINITION, value)
															.addAttribute(ConstantUtil.TYPE, type)
															.addAttribute("Key", "field_" + ele.elements().size());
												}
												ele.addAttribute("MaxKey", ele.elements().size() + "");
											}
										}


									}
								}
							} else {
								for (Element elefield : Field) {
									if (elefield.attributeValue(ConstantUtil.DEFINITION).equalsIgnoreCase(oldValue)) {
										ele.remove(elefield);
									}
								}
							}
						}
					}
				}
				break;
			case ConstantUtil.TARGET_TABLE_KEY:
				boolean TargetFlag = false;
				Element tagNode = null;
				for (Element ele : elements) {
					if (ele.attributeValue(ConstantUtil.TARGET_TABLE_KEY) != null && ele.attributeValue(ConstantUtil.TARGET_TABLE_KEY).equalsIgnoreCase(value) && !ele.attributeValue(ConstantUtil.KEY).equalsIgnoreCase(tableKey)) {
						TargetFlag = true;
						break;
					}
					if (ele.attributeValue(ConstantUtil.KEY).equalsIgnoreCase(tableKey)) {
						tagNode = ele;
					}
				}
				if (Objects.isNull(tagNode)) {
					tableNode = ConstantUtil.SOURCE_TABLE;
					nodeName = ConstantUtil.SOURCE_TABLE_COLLECTION;
					elements = root.element(nodeName).elements(tableNode);
					for (Element ele : elements) {
						if (ele.attributeValue(ConstantUtil.TARGET_TABLE_KEY) != null && ele.attributeValue(ConstantUtil.TARGET_TABLE_KEY).equalsIgnoreCase(value) && !ele.attributeValue(ConstantUtil.KEY).equalsIgnoreCase(tableKey)) {
							TargetFlag = true;
							break;
						}
						if (ele.attributeValue(ConstantUtil.KEY).equalsIgnoreCase(tableKey)) {
							tagNode = ele;
						}
					}
				}
				if (TargetFlag) {
					result.setCode(999);
					result.setMsg("该表是其他源表的目标表,不能再选！");
					return result;
				} else {
					if (value.isEmpty()) {
						tagNode.remove(tagNode.attribute(ConstantUtil.TARGET_TABLE_KEY));
					} else {
						tagNode.addAttribute(ConstantUtil.TARGET_TABLE_KEY, value);
					}
				}
				break;
			case "IsPrimary":
				//当操作是将当前表修改为主表的时候先去判断是否已经存在主表，存在就做一些处理操作
				if ("true".equalsIgnoreCase(value)) {
					for (Element ele : elements) {
						if ("true".equalsIgnoreCase(ele.attributeValue("IsPrimary")) && !ele.attributeValue(nodeKey).equalsIgnoreCase(tableKey)) {
							ele.remove(ele.attribute("IsPrimary"));
						} else if (ele.attributeValue(nodeKey).equalsIgnoreCase(tableKey)) {
							ele.addAttribute("IsPrimary", value);
						}
					}
				} else {
					for (Element eleNode : elements) {
						if (eleNode.attributeValue(nodeKey).equalsIgnoreCase(tableKey) && eleNode.attribute("IsPrimary") != null) {
							eleNode.remove(eleNode.attribute("IsPrimary"));
							break;
						}
					}
				}
				break;
			case "DataMapCondition":
				for (Element eleNode : elements) {
					if (eleNode.attributeValue(nodeKey).equalsIgnoreCase(tableKey)) {
						if (eleNode.attribute("Condition") != null) {
							eleNode.remove(eleNode.attribute("Condition"));
						}
						eleNode.addAttribute("Condition", value);
						break;
					}
				}
				break;
			case "RowTrigger":
				for (Element eleNode : elements) {
					if (eleNode.attributeValue(nodeKey).equalsIgnoreCase(tableKey)) {
						if (eleNode.attribute("RowTrigger") != null) {
							eleNode.remove(eleNode.attribute("RowTrigger"));
						}
						eleNode.addAttribute("RowTrigger", value);
						break;
					}
				}
				break;
			case "RefFieldKey":
				for (Element ele : elements) {
					String tableKey1 = getTableKey(ele);
					if (tableKey1.equalsIgnoreCase(tableKey)) {
						List<Element> sourceField = ele.elements(ConstantUtil.SOURCE_FIELD);
						for (Element elefield : sourceField) {
							if (elefield.attributeValue(ConstantUtil.DEFINITION).equalsIgnoreCase(fieldKey)) {
								if (!"".equalsIgnoreCase(value) && StringUtils.isNotEmpty(value)) {
									elefield.addAttribute("RefFieldKey", value);
								} else {
									elefield.remove(elefield.attribute("RefFieldKey"));
								}
							}
						}
					}
				}
				break;
			case "EdgeType":
				//先去判断是否已经存在关注字段，有关注字段的是不是这个当前修改的字段
				if ("Focus".equalsIgnoreCase(value)) {
					for (Element ele : elements) {
						List<Element> sourceField = ele.elements(ConstantUtil.SOURCE_FIELD);
						//先去xml中判断是否已经存在关注字段，并且这个关注字段是不是当前正在修改的
						for (Element elefield : sourceField) {
							if ("Focus".equalsIgnoreCase(elefield.attributeValue("EdgeType"))) {
								//不是当前字段
								if (!elefield.attributeValue(ConstantUtil.DEFINITION).equalsIgnoreCase(fieldKey)) {
									result.setCode(999);
									result.setMsg("修改失败,关注字段已经存在无法设置");
									return result;
								}
							}
						}
						//没有找到关注字段的话就将当前字段设置成关注字段
						for (Element elefield : sourceField) {
							if (elefield.attributeValue(ConstantUtil.DEFINITION).equalsIgnoreCase(fieldKey) && endField.equalsIgnoreCase(elefield.attributeValue(ConstantUtil.TARGET_FIELD_KEY))) {
								elefield.addAttribute("EdgeType", "Focus");
							}
						}
					}
				} else {//处理从关注字段切换为普通字段
					for (Element ele : elements) {
						List<Element> sourceField = ele.elements(ConstantUtil.SOURCE_FIELD);
						//先去xml中判断是否已经存在关注字段，并且这个关注字段是不是当前正在修改的
						for (Element elefield : sourceField) {
							if (elefield.attributeValue(ConstantUtil.DEFINITION).equalsIgnoreCase(fieldKey) && endField.equalsIgnoreCase(elefield.attributeValue(ConstantUtil.TARGET_FIELD_KEY))) {
								elefield.remove(elefield.attribute("EdgeType"));
							}
						}
					}
				}
				break;
			case "FeedbackFormKey":
				Element feedbackCollection = root.element(ConstantUtil.FEEDBACK_COLLECTION);
				String top = frontUpdateJson.getString("top");
				if ("null".equalsIgnoreCase(top)) {
					top = "26";
				}
				String left = frontUpdateJson.getString("left");
				if ("null".equalsIgnoreCase(left)) {
					left = "723";
				}
				String dataObject = MetaFactory.getGlobalInstance().getMetaForm(value).getDataSource().getDataObject().getKey();
				if (Objects.isNull(feedbackCollection) && value != null) {
					Element collection = root.addElement(ConstantUtil.FEEDBACK_COLLECTION).addElement(ConstantUtil.FEEDBACK_OBJECT);
					collection.addAttribute(ConstantUtil.HEIGHT, "60").addAttribute(ConstantUtil.FORM_KEY, value).addAttribute(ConstantUtil.OBJECT_KEY, dataObject).addAttribute("Width", width).addAttribute(ConstantUtil.X, left).addAttribute(ConstantUtil.Y, String.valueOf(Integer.valueOf(top) + 80));
				} else if (value != null) {
					Element collection = feedbackCollection.addElement(ConstantUtil.FEEDBACK_OBJECT);
					collection.addAttribute(ConstantUtil.HEIGHT, "60").addAttribute(ConstantUtil.FORM_KEY, value).addAttribute(ConstantUtil.OBJECT_KEY, dataObject).addAttribute("Width", width).addAttribute(ConstantUtil.X, left).addAttribute(ConstantUtil.Y, String.valueOf(Integer.valueOf(top) + 80));
				}
				break;
			case "FeedBackField":
				//用于判断是否是当前表的第一个字段
				Boolean flag = false;
				List<Element> feedbackObject = root.element(nodeName).elements(ConstantUtil.FEEDBACK_OBJECT);
				for (Element ele : feedbackObject) {
					if (ele.attributeValue(ConstantUtil.FORM_KEY).equalsIgnoreCase(formKey)) {
						List<Element> feedbackTable = ele.elements(tableNode);
						for (Element element1 : feedbackTable) {
							List<Element> filedNode1 = element1.elements(filedNode);
							boolean a = false;
							for (Element element2 : filedNode1) {
								if (element2.attributeValue(ConstantUtil.FIELD_KEY).equalsIgnoreCase(field)) {
									a = true;
									flag = true;
									break;
								}
							}
							if (!a && element1.attributeValue(ConstantUtil.TABLE_KEY).equalsIgnoreCase(tableKey)) {
								element1.addElement(filedNode).addAttribute(ConstantUtil.FIELD_KEY, field);
								flag = true;
							}
						}
						if (!flag) {
							ele.addElement(tableNode).addAttribute(ConstantUtil.TABLE_KEY, tableKey).addElement(filedNode).addAttribute(ConstantUtil.FIELD_KEY, field);
						}
					}

				}
				break;
			case "Editable":
			case "ConditionField":
				setLigature(key, value, nodeName, tableKey, fieldKey, root, endField);
				break;
			case "OpSign":
			case "PostTrigger":
			case "PostFormulaTrigger":
			case "FeedCondition":
				List<Element> targetTable = root.element(nodeName).elements(ConstantUtil.TARGET_TABLE);
				//数据处理
				dataProcessing(key, endField, value, tableKey, fieldKey, targetTable);
				break;
			case "GroupingPolicy":
			case "PeriodValue":
			case "MigrationOpSign":
			case "IsNegtive":
			case "MapFormula":
				//因为有冲突所以做一个特殊处理
				if ("MigrationOpSign".equalsIgnoreCase(key)) {
					key = key.split("Migration")[1];
				}
				for (Element ele : elements) {
					String tableKey1 = getTableKey(ele);
					if (tableKey1.equalsIgnoreCase(tableKey)) {
						List<Element> sourceField = ele.elements(ConstantUtil.SOURCE_FIELD);
						for (Element source : sourceField) {
							if (source.attributeValue(ConstantUtil.DEFINITION).equalsIgnoreCase(fieldKey) && targetField != null && source.attributeValue(ConstantUtil.TARGET_FIELD_KEY).equalsIgnoreCase(targetField)) {
								if (value != null && !"".equalsIgnoreCase(value)) {
									source.addAttribute(key, value);
								} else {
									source.remove(source.attribute(key));
								}
							}
						}
					}
				}
				break;
			default:
				break;

		}
		return null;
	}

	private ResponseResult<JSONArray> getJsonArrayResponseResult(JSONObject frontUpdateJson,
																 JsonDataMapVo jsonDataMapVo,
																 ResponseResult<JSONArray> result,
																 FileOutputStream fileOutputStream, XMLWriter writer,
																 String filePaths) throws Throwable {
		String tempPath;
		try {
			tempPath = XmlFileProcessor.instance.getTmpFile(filePaths);
			if (StringUtils.isBlank(tempPath)) {
				tempPath = filePaths;
			}
			// 创建SAX读取器
			SAXReader reader = new SAXReader();
			// 加载文档
			Document document = reader.read(new File(tempPath));
			ResponseResult<JSONArray> result1 = getJsonArrayResponseResult(frontUpdateJson, jsonDataMapVo, result, document);
			if (result1 != null) {
				return result1;
			}
			OutputFormat format = getOutputFormat();
			String solutionPath = FilePathHelper.getWorkspacePath() + File.separator;
			String tmpDirPath = WebDesignerConfiguration.getDesignerDataPath() + File.separator + "tmp";
			File tmpDirFile = new File(tmpDirPath);
			if (!tmpDirFile.exists() || tmpDirFile.isDirectory()) {
				tmpDirFile.mkdirs();
			}
			String newFilePath = Paths.get(tmpDirPath, filePaths.substring(solutionPath.length()).replace(File.separator, "__") + "." + System.currentTimeMillis()).toString();
			fileOutputStream = new FileOutputStream(newFilePath);
			XmlFileProcessor.stackput(filePaths, newFilePath);
			writer = new XMLWriter(fileOutputStream, format);
			writer.write(document);
			result.setCode(0);
			result.setMsg("更新xml成功");
		} catch (Exception e) {
			logger.warning("更新xml异常，异常为:" + ExceptionUtils.getStackTrace(e));
			result.setCode(999);
			result.setMsg("更新xml失败，失败消息为:" + e.getMessage());
		} catch (Throwable throwable) {
			logger.warning(throwable.getMessage());
		} finally {
			setData(result, filePaths);
			closeFileStream(fileOutputStream, writer);
		}
		return null;
	}

	public static void setData(ResponseResult<JSONArray> result, String filePaths) throws Throwable {
		// 打开数据迁移的时候去拿取数据
		String xml_file = XmlFormat.formatXML_file(filePaths);
		String secondLine = DesignIOMetaUtil.getSecondLine(xml_file);
		JSONObject jsonFileContent;
		if (secondLine.indexOf("<DataMigration") == 0) {//数据迁移
			jsonFileContent = dataMigrationOperJsonUtil.convertXmlToJson(filePaths);
		} else {
			jsonFileContent = dataMapOperJsonUtil.convertXmlToJson(filePaths);
		}

		JSONArray array = new JSONArray();
		array.add(jsonFileContent);
		result.setData(array);
	}

	/**
	 * @param field     当前传过来的字段
	 * @param tableKey  当前操作的Tbalekey
	 * @param filedNode 当前字段的节点
	 * @param tableList 存放TableKey的集合
	 *                  如果当前tableKey在XMl中已经存在就直接进行添加
	 */
	public void findTablekey(String nodeName, String field, String tableKey, String filedNode,
							 List<Element> tableList, String name, boolean mergeToSource, boolean extend) {
		for (Element ele : tableList) {
			String table = getTableKey(ele);
			if (table.equalsIgnoreCase(tableKey)) {
				boolean isBe = false;
				List<Element> elements1 = ele.elements(filedNode);
				for (Element ele1 : elements1) {
					//根据XML结构去获取field
					String fieldValue = getFieldValue(ele1);
					if (fieldValue.equalsIgnoreCase(field) && Objects.isNull(ele1.element(ConstantUtil.TARGET_FIELD_KEY))) {
						isBe = true;
					}
				}
				//防止添加没有意义的重复字段
				if (!isBe) {
					if (ConstantUtil.MAP.equalsIgnoreCase(name)) {
						if (ConstantUtil.SOURCE_TABLE_COLLECTION.equalsIgnoreCase(nodeName)) {
							if (mergeToSource) {
								ele.addElement(filedNode).addAttribute(ConstantUtil.DEFINITION, field).addAttribute(ConstantUtil.KEY, "merge_" + ele.elements().size());
								String maxKey = ele.attributeValue("MaxKey");
								if (StringUtils.isNotEmpty(maxKey)) {
									ele.addAttribute("MaxKey", (Integer.valueOf(maxKey) + 1) + "");
								} else {
									ele.addAttribute("MaxKey", "" + ele.elements().size());
								}
							} else {
								if (!extend) {
									String maxKey = ele.attributeValue("MaxKey");
									if (StringUtils.isNotEmpty(maxKey)) {
										ele.addAttribute("MaxKey", (Integer.valueOf(maxKey) + 1) + "");
										ele.addElement(filedNode).addAttribute(ConstantUtil.DEFINITION, field).addAttribute(ConstantUtil.KEY, (Integer.valueOf(maxKey) + 1) + "");
									} else {
										ele.addAttribute("MaxKey", "" + ele.elements().size());
										ele.addElement(filedNode).addAttribute(ConstantUtil.DEFINITION, field).addAttribute(ConstantUtil.KEY, ele.elements().size() + "");
									}
								} else {
									ele.addElement(filedNode).addAttribute(ConstantUtil.DEFINITION, field).addAttribute(ConstantUtil.KEY, "field_" + ele.elements().size());
									String maxKey = ele.attributeValue("MaxKey");
									if (StringUtils.isNotEmpty(maxKey)) {
										ele.addAttribute("MaxKey", (Integer.valueOf(maxKey) + 1) + "");
									} else {
										ele.addAttribute("MaxKey", "" + ele.elements().size());
									}
								}

							}
						} else {
							ele.addElement(filedNode).addAttribute(ConstantUtil.DEFINITION, field);
						}
					} else if (ConstantUtil.DATA_MIGRATION.equalsIgnoreCase(name)) {
						if (ConstantUtil.SOURCE_TABLE_COLLECTION.equalsIgnoreCase(nodeName)) {
							ele.addElement(filedNode).addAttribute(ConstantUtil.DEFINITION, field);
						} else {
							ele.addElement(filedNode).addAttribute(ConstantUtil.FIELD_KEY, field);
						}
					}
				}
			}
		}
	}

	/***
	 * 获取当前Form表单中的所有字段
	 * @return 结果对象
	 * @param jsonDataMapVo
	 */
	public ResponseResult<JSONArray> getFormField(JsonDataMapVo jsonDataMapVo, Element root) {
		boolean isIdentical = root.attributeValue(ConstantUtil.SRC_DATA_OBJECT_KEY).equalsIgnoreCase(root.attributeValue(ConstantUtil.TGT_DATA_OBJECT_KEY));
		ResponseResult<JSONArray> result = new ResponseResult<>();
		try {
			String name = root.getName();
			String formKey = jsonDataMapVo.getFormKey();
			String filePath = jsonDataMapVo.getFilePath();
			String temFilePath = XmlFileProcessor.instance.getTmpFile(filePath);
			if (temFilePath != null) {
				filePath = temFilePath;
			}
			if (ConstantUtil.MAP.equals(name)) {//数据映射
				if ("source".equalsIgnoreCase(jsonDataMapVo.getOperationType())) {
					formKey = root.attributeValue(ConstantUtil.SRC_FORM_KEY);
				} else if ("target".equalsIgnoreCase(jsonDataMapVo.getOperationType())) {
					formKey = root.attributeValue(ConstantUtil.TGT_FORM_KEY);
				} else {
					String objectKey = jsonDataMapVo.getFormKey().split("__")[0];
					Element element = DataMapOperJsonUtil.getElement(filePath);
					List<Element> elements = element.element(ConstantUtil.FEEDBACK_COLLECTION).elements(ConstantUtil.FEEDBACK_OBJECT);
					for (Element element1 : elements) {
						if (objectKey.equalsIgnoreCase(element1.attributeValue(ConstantUtil.FORM_KEY))) {
							formKey = element1.attributeValue(ConstantUtil.FORM_KEY);
							break;
						}
					}
				}

			} else {
				if ("source".equalsIgnoreCase(jsonDataMapVo.getOperationType())) {
					formKey = root.attributeValue(ConstantUtil.SRC_DATA_OBJECT_KEY);
				} else if ("target".equalsIgnoreCase(jsonDataMapVo.getOperationType())) {
					formKey = root.attributeValue(ConstantUtil.TGT_DATA_OBJECT_KEY);
				}
			}
			TwoTuple<MetaForm, MetaDataObject> metaFormOrMetaDataObject = publicMethodUtil.MetaFormOrMetaDataObject(formKey);
			MetaForm metaForm = metaFormOrMetaDataObject.metaForm;
			MetaDataObject metaDataObject = metaFormOrMetaDataObject.metaDataObject;
			JSONArray nodesJsonArray = new JSONArray();
			MetaTableCollection tableCollection = null;
			//如果源单和目标表单相同就要进行区分，防止前端添加动态Id出现重复
			if (isIdentical && root.attributeValue(ConstantUtil.SRC_DATA_OBJECT_KEY).equalsIgnoreCase(formKey) && "source".equalsIgnoreCase(jsonDataMapVo.getOperationType())) {
				formKey = formKey + "__S";
			} else if (isIdentical && root.attributeValue(ConstantUtil.TGT_DATA_OBJECT_KEY).equalsIgnoreCase(formKey) && "target".equalsIgnoreCase(jsonDataMapVo.getOperationType())) {
				formKey = formKey + "__T";
			} else if (root.attributeValue(ConstantUtil.SRC_DATA_OBJECT_KEY).equalsIgnoreCase(formKey) || root.attributeValue(ConstantUtil.TGT_DATA_OBJECT_KEY).equalsIgnoreCase(formKey)) {
				if ("feedback".equalsIgnoreCase(jsonDataMapVo.getOperationType())) {
					formKey = formKey + "__Feed";
				}
			}
			if (ConstantUtil.MAP.equals(name)) {//数据映射
				String extend = root.attributeValue("Extend");
				String mergeToSource = root.attributeValue("MergeToSource");
				boolean isFilter = StringUtils.isNotEmpty(extend) && StringUtils.isNotEmpty(mergeToSource);
				String formKey1 = jsonDataMapVo.getFormKey().split("__")[0];
				if ("source".equalsIgnoreCase(jsonDataMapVo.getOperationType())) {
					formKey1 = root.attributeValue(ConstantUtil.SRC_FORM_KEY);
				} else if ("target".equalsIgnoreCase(jsonDataMapVo.getOperationType())) {
					formKey1 = root.attributeValue(ConstantUtil.TGT_FORM_KEY);
				} else {
					String objectKey = jsonDataMapVo.getFormKey().split("__")[0];
					Element element = DataMapOperJsonUtil.getElement(filePath);
					List<Element> elements = element.element(ConstantUtil.FEEDBACK_COLLECTION).elements(ConstantUtil.FEEDBACK_OBJECT);
					for (Element element1 : elements) {
						if (objectKey.equalsIgnoreCase(element1.attributeValue(ConstantUtil.FORM_KEY))) {
							formKey1 = element1.attributeValue(ConstantUtil.FORM_KEY);
							break;
						}
					}
				}
				MetaForm metaForm1 = MetaFactory.getGlobalInstance().getMetaForm(formKey1);
				IDLookup idLookup = IDLookup.getIDLookup(metaForm1);
				if (metaForm != null) {//表单
					tableCollection = metaForm.getDataSource().getDataObject().getTableCollection();
				} else if (metaDataObject != null) {//数据对象表单
					tableCollection = metaDataObject.getTableCollection();
				}
				if (tableCollection != null) {
					for (int i = 0; i < tableCollection.size(); i++) {
						MetaTable metaColumns = tableCollection.get(i);
						int finalI = i + 1;
						String finalTableKey = metaColumns.getKey();
						Map<String, List<String>> columKeysAndFieldKeys = idLookup.getColumKeysAndFieldListKeys(finalTableKey);
						if (MapUtils.isEmpty(columKeysAndFieldKeys)) {
							continue;
						}
						if (!finalTableKey.contains("_NODB")) {
							Collection<MetaColumn> elementMap = metaColumns.items();
							if (elementMap != null) {
								for (MetaColumn metaColumn : elementMap) {
									if (!metaColumn.getKey().contains("_NODB")) {
										List<String> fieldKeys = columKeysAndFieldKeys.get(metaColumn.getKey());
										if (CollectionUtils.isEmpty(fieldKeys)) {
											continue;
										}
										for (String fieldKey : fieldKeys) {
											if (isFilter) {
												Map<String, String> map = filterFiledMap(extend, metaForm1);
												if (!map.containsValue(fieldKey)) {
													setArray(formKey, nodesJsonArray, finalI, finalTableKey, metaColumn, false, true, "", metaColumns, null, idLookup, fieldKey);
												}
											} else {
												setArray(formKey, nodesJsonArray, finalI, finalTableKey, metaColumn, false, true, "", metaColumns, null, idLookup, fieldKey);
											}
										}
									}
								}
							}
						}
					}
				}
			} else if (ConstantUtil.DATA_MIGRATION.equals(name)) {//数据迁移
				setArrayUniversal(formKey, metaForm, metaDataObject, nodesJsonArray, true, true);
			}
			result.setCode(0);
			result.setMsg("获取表单字段成功");
			result.setData(nodesJsonArray);
		} catch (Throwable e) {
			logger.warning("获取表单字段异常，异常为:" + ExceptionUtils.getStackTrace(e));
			result.setCode(999);
			result.setMsg("获取表单字段失败，失败消息为:" + e.getMessage());
		}
		return result;
	}

	public void setArrayUniversal(String formKey, MetaForm metaForm, MetaDataObject metaDataObject, JSONArray nodesJsonArray, boolean isNotMap, boolean isAll) throws Throwable {
		MetaTableCollection tableCollection = null;
		if (metaForm != null) {
			tableCollection = metaForm.getDataSource().getDataObject().getTableCollection();
		} else if (metaDataObject != null) {
			tableCollection = metaDataObject.getTableCollection();
		}
		if (tableCollection != null) {
			for (int i = 0; i < tableCollection.size(); i++) {
				MetaTable metaColumns = tableCollection.get(i);
				int finalI = i + 1;
				String finalTable = metaColumns.getKey();
				if (!metaColumns.getKey().contains("_NODB")) {
					Collection<MetaColumn> elementMap = metaColumns.items();
					if (elementMap != null) {
						for (MetaColumn metaColumn : elementMap) {
							if (!("MapCount".equalsIgnoreCase(metaColumn.getKey())) && !metaColumn.getKey().contains("_NODB") && isNotMap) {
								setArray(formKey, nodesJsonArray, finalI, finalTable, metaColumn, isNotMap, isAll, "", metaColumns, null, null, null);
							}
						}
					}
				}
			}
		}
	}

	public void setLayuiArrayUniversal(String formKey, MetaForm metaForm, MetaDataObject metaDataObject, JSONArray nodesJsonArray, boolean isNotMap, boolean isAll, String nodeName, XmlTreeWithPath xmlTree) throws Throwable {
		MetaTableCollection tableCollection = null;
		if (metaForm != null) {
			tableCollection = metaForm.getDataSource().getDataObject().getTableCollection();
		} else if (metaDataObject != null) {
			tableCollection = metaDataObject.getTableCollection();
		}
		if (tableCollection != null) {
			for (int i = 0; i < tableCollection.size(); i++) {
				MetaTable metaColumns = tableCollection.get(i);
				int finalI = i + 1;
				String finalTable = metaColumns.getKey();
				if (!metaColumns.getKey().contains("_NODB")) {
					Collection<MetaColumn> elementMap = metaColumns.items();
					if (elementMap != null) {
						for (MetaColumn metaColumn : elementMap) {
							if (!"MapCount".equals(metaColumn.getKey()) && !metaColumn.getKey().contains("_NODB") && isNotMap) {
								setArray(formKey, nodesJsonArray, finalI, finalTable, metaColumn, isNotMap, isAll, nodeName, metaColumns, xmlTree, null, null);
							}
						}
					}
				}
			}
		}
	}

	public void setArrayUniversalByTableKey(String formKey, MetaForm metaForm, MetaDataObject metaDataObject, JSONArray nodesJsonArray, String tableKey, boolean isNotMap, boolean isAll, String nodeName, XmlTreeWithPath xmlTreeWithPath) throws Throwable {
		MetaTableCollection tableCollection = null;
		if (metaForm != null) {
			tableCollection = metaForm.getDataSource().getDataObject().getTableCollection();
		} else if (metaDataObject != null) {
			tableCollection = metaDataObject.getTableCollection();
		}
		if (tableCollection != null) {
			for (int i = 0; i < tableCollection.size(); i++) {
				MetaTable metaColumns = tableCollection.get(i);
				int finalI = i + 1;
				String finalTable = metaColumns.getKey();
				if (metaColumns.getKey().equals(tableKey)) {
					Collection<MetaColumn> elementMap = metaColumns.items();
					if (elementMap != null) {
						for (MetaColumn metaColumn : elementMap) {
							if (!metaColumn.getKey().contains("_NODB")) {
								setArray(formKey, nodesJsonArray, finalI, finalTable, metaColumn, isNotMap, isAll, nodeName, metaColumns, xmlTreeWithPath, null, null);
							}
						}
					}
				}
			}
		}
	}

	public void setArray(String formKey, JSONArray nodesJsonArray, int finalI, String finalTable, MetaColumn metaColumn, boolean isNotMap, boolean isAll, String nodeName, MetaTable table, XmlTreeWithPath xmlTree, IDLookup idLookup, String fieldKey) throws Throwable {
		JSONObject nodeJsonObj = new JSONObject();
		nodeJsonObj.put(ConstantUtil.DATA_SOURCE, "(表" + finalI + ")");

		if (isNotMap && StringUtils.isNotEmpty(nodeName)) {
			nodeJsonObj.put(ConstantUtil.KEY, metaColumn.getKey());
			int groupType = metaColumn.getGroupType();
			String Caption = metaColumn.getCaption() + DataMigrationOperJsonUtil.getGroupType(groupType);
			nodeJsonObj.put(ConstantUtil.CAPTION, ConstantUtil.SOURCE_TABLE_COLLECTION.equalsIgnoreCase(nodeName) ? metaColumn.getCaption() : Caption);
			nodeJsonObj.put("name", "(表" + finalI + ")" + metaColumn.getKey() + "  " + metaColumn.getCaption());
			nodeJsonObj.put("value", finalI + "_@_" + metaColumn.getKey() + "_@_" + metaColumn.getCaption() + "_@_" + finalTable + "_@_" + formKey);

		} else {
			if (isNotMap) {
				nodeJsonObj.put(ConstantUtil.KEY, metaColumn.getKey());
				nodeJsonObj.put(ConstantUtil.CAPTION, metaColumn.getCaption());
				nodeJsonObj.put("name", "(表" + finalI + ")" + metaColumn.getKey() + "  " + metaColumn.getCaption());
				nodeJsonObj.put("value", finalI + "_@_" + metaColumn.getKey() + "_@_" + metaColumn.getCaption() + "_@_" + finalTable + "_@_" + formKey);
			} else {
				Map<String, List<String>> columKeysAndFieldKeys = idLookup.getColumKeysAndFieldListKeys(finalTable);
				List<String> fieldKeys = columKeysAndFieldKeys.get(metaColumn.getKey());
				if (fieldKeys.size() > 0) {
					nodeJsonObj.put(ConstantUtil.KEY, fieldKey);
					nodeJsonObj.put("name", "(表" + finalI + ")" + fieldKey + "  " + metaColumn.getCaption());
					nodeJsonObj.put("value", finalI + "_@_" + fieldKey + "_@_" + metaColumn.getCaption() + "_@_" + finalTable + "_@_" + formKey);

				} else {
					nodeJsonObj.put(ConstantUtil.KEY, metaColumn.getKey());
					nodeJsonObj.put("name", "(表" + finalI + ")" + metaColumn.getKey() + "  " + metaColumn.getCaption());
					nodeJsonObj.put("value", finalI + "_@_" + metaColumn.getKey() + "_@_" + metaColumn.getCaption() + "_@_" + finalTable + "_@_" + formKey);
				}
				nodeJsonObj.put(ConstantUtil.CAPTION, metaColumn.getCaption());
			}

		}
		nodeJsonObj.put(ConstantUtil.TABLE_KEY, finalTable);
		if (!isAll && StringUtils.isNotEmpty(nodeName) && xmlTree != null && !isNotMap) {
			TagNode root = xmlTree.xmlTree.getRoot();
			Set<String> set = publicMethodUtil.getNodes(table, nodeName, formKey, root);
			nodeJsonObj.put("checked", set.contains(fieldKey));

		} else if (StringUtils.isNotEmpty(nodeName) && xmlTree != null) {
			TagNode root = xmlTree.xmlTree.getRoot();
			Set<String> set = publicMethodUtil.getNodes(table, nodeName, formKey, root);
			nodeJsonObj.put("checked", set.contains(metaColumn.getKey()));
		}
		nodesJsonArray.add(nodeJsonObj);
	}

	/**
	 * @param metaForm
	 * @return 返回源单已经使用的字段
	 * @throws Throwable
	 */
	public static Map<String, String> filterFiledMap(String extend, MetaForm metaForm) throws Throwable {
		HashMap<String, String> hashMap = new HashMap<>();
		String extendForm = metaForm != null && StringUtils.isNotEmpty(metaForm.getExtend()) ? metaForm.getExtend() : metaForm.getKey();
		String dataMapPath = LoadFileTree.getDataMapPathByKey(extend);
		if (StringUtils.isNotEmpty(dataMapPath)) {
			TagNode node = Xml4jUtil.parseTree(dataMapPath).getRoot();
			boolean srcFormKey = node.getAttributes().get(ConstantUtil.SRC_FORM_KEY).equalsIgnoreCase(extendForm);
			List<TagNode> tagNodes = srcFormKey ? node.findNodesByTagName(ConstantUtil.SOURCE_FIELD) : node.findNodesByTagName(ConstantUtil.TARGET_FIELD);
			setFilterFiledMap(hashMap, tagNodes, true);
			//反填表单
			List<TagNode> feedbackFieldList = node.findNodesByTagName(ConstantUtil.FEEDBACK_FIELD);
			setFilterFiledMap(hashMap, feedbackFieldList, false);

		}
		return hashMap;
	}

	/**
	 * 使用的字段集合
	 *
	 * @param hashMap
	 * @param tagNodes
	 */
	private static void setFilterFiledMap(HashMap<String, String> hashMap, List<TagNode> tagNodes, boolean notFeed) {
		for (TagNode tagNode : tagNodes) {
			String uuid = UUID.randomUUID().toString().replaceAll("-", "");
			String definition = "";
			if (notFeed) {
				if (tagNode.getTagName().equals(ConstantUtil.SOURCE_FIELD)) {
					definition = tagNode.getAttributes().get(ConstantUtil.KEY);
				} else {
					definition = tagNode.getAttributes().get(ConstantUtil.DEFINITION);
				}
			} else {
				definition = tagNode.getAttributes().get(ConstantUtil.FIELD_KEY);
			}
			hashMap.put(uuid, definition);
		}
	}

	/**
	 * 根据tablekey去获取字段属性
	 *
	 * @param jsonDataMapVo
	 * @return
	 */
	public ResponseResult<JSONArray> getTableKeyField(JsonDataMapVo jsonDataMapVo) {
		ResponseResult<JSONArray> result = new ResponseResult<>();
		try {
			String formKey = jsonDataMapVo.getFormKey().split("__")[0];
			String tableKey = jsonDataMapVo.getTableKey();
			String nodeName = jsonDataMapVo.getNodeName();
			String filePath = jsonDataMapVo.getFilePath();
			String tmpFile = XmlFileProcessor.instance.getTmpFile(filePath);
			if (tmpFile != null) {
				filePath = tmpFile;
			}
			XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(filePath);
			Element element = DataMapOperJsonUtil.getElement(filePath);
			String name = element.getName();
			if (ConstantUtil.MAP.equals(name)) {//数据映射
				if (ConstantUtil.SOURCE_TABLE_COLLECTION.equals(nodeName)) {
					formKey = element.attributeValue(ConstantUtil.SRC_FORM_KEY);
				} else if (ConstantUtil.TARGET_TABLE_COLLECTION.equals(nodeName)) {
					formKey = element.attributeValue(ConstantUtil.TGT_FORM_KEY);
				}

			} else {
				if (ConstantUtil.SOURCE_TABLE_COLLECTION.equals(nodeName)) {
					formKey = element.attributeValue(ConstantUtil.SRC_DATA_OBJECT_KEY);
				} else if (ConstantUtil.TARGET_TABLE_COLLECTION.equals(nodeName)) {
					formKey = element.attributeValue(ConstantUtil.TGT_DATA_OBJECT_KEY);
				}
			}

			JSONArray nodesJsonArray = new JSONArray();
			TwoTuple<MetaForm, MetaDataObject> metaFormOrMetaDataObject = publicMethodUtil.MetaFormOrMetaDataObject(formKey);
			MetaForm metaForm = metaFormOrMetaDataObject.metaForm;
			MetaDataObject metaDataObject = metaFormOrMetaDataObject.metaDataObject;


			if (ConstantUtil.MAP.equals(name)) {//数据映射
				MetaTableCollection tableCollection = null;
				String formKey1 = jsonDataMapVo.getFormKey().split("__")[0];
				String extend = element.attributeValue("Extend");
				String mergeToSource = element.attributeValue("MergeToSource");
				boolean isFilter = StringUtils.isNotEmpty(extend) && StringUtils.isNotEmpty(mergeToSource);
				if (ConstantUtil.SOURCE_TABLE_COLLECTION.equals(nodeName)) {
					formKey1 = element.attributeValue(ConstantUtil.SRC_FORM_KEY);
				} else if (ConstantUtil.TARGET_TABLE_COLLECTION.equals(nodeName)) {
					formKey1 = element.attributeValue(ConstantUtil.TGT_FORM_KEY);
				} else {
					String objectKey = jsonDataMapVo.getFormKey().split("__")[0];
					List<Element> elements = element.element(ConstantUtil.FEEDBACK_COLLECTION).elements(ConstantUtil.FEEDBACK_OBJECT);
					for (Element element1 : elements) {
						if (objectKey.equalsIgnoreCase(element1.attributeValue(ConstantUtil.FORM_KEY))) {
							formKey1 = element1.attributeValue(ConstantUtil.FORM_KEY);
							break;
						}
					}
				}
				MetaForm metaForm1 = MetaFactory.getGlobalInstance().getMetaForm(formKey1);
				IDLookup idLookup = IDLookup.getIDLookup(metaForm1);
				if (metaForm != null) {//表单
					tableCollection = metaForm.getDataSource().getDataObject().getTableCollection();

				} else if (metaDataObject != null) {//数据对象表单
					tableCollection = metaDataObject.getTableCollection();
				}
				if (tableCollection != null) {
					for (int i = 0; i < tableCollection.size(); i++) {
						MetaTable metaColumns = tableCollection.get(i);
						int finalI = i + 1;
						String finalTable = metaColumns.getKey();
						Map<String, List<String>> columKeysAndFieldKeys = idLookup.getColumKeysAndFieldListKeys(finalTable);
						if (MapUtils.isEmpty(columKeysAndFieldKeys)) {
							continue;
						}
						if (metaColumns.getKey().equals(tableKey)) {
							Collection<MetaColumn> elementMap = metaColumns.items();
							if (elementMap != null) {
								for (MetaColumn metaColumn : elementMap) {
									if (!metaColumn.getKey().contains("_NODB")) {
										List<String> fieldKeys = columKeysAndFieldKeys.get(metaColumn.getKey());
										if (CollectionUtils.isEmpty(fieldKeys)) {
											continue;
										}
										for (String fieldKey : fieldKeys) {
											if (isFilter) {
												Map<String, String> map = filterFiledMap(extend, metaForm1);
												if (!map.containsValue(fieldKey)) {
													setArray(formKey, nodesJsonArray, finalI, finalTable, metaColumn, false, false, nodeName, metaColumns, xmlTreeWithPath, idLookup, fieldKey);
												}
											} else {
												setArray(formKey, nodesJsonArray, finalI, finalTable, metaColumn, false, false, nodeName, metaColumns, xmlTreeWithPath, idLookup, fieldKey);
											}
										}


									}
								}
							}
						}
					}
				}
			} else if (ConstantUtil.DATA_MIGRATION.equals(name)) {//数据迁移
				setArrayUniversalByTableKey(formKey, metaForm, metaDataObject, nodesJsonArray, tableKey, true, false, nodeName, xmlTreeWithPath);
			}
			result.setCode(0);
			result.setMsg("获取数据表字段成功");
			result.setData(nodesJsonArray);
		} catch (Throwable e) {
			logger.warning("获取数据表字段异常，异常为:" + ExceptionUtils.getStackTrace(e));
			result.setCode(999);
			result.setMsg("获取数据表字段失败，失败消息为:" + e.getMessage());
		}
		return result;
	}

	/**
	 * @param formKey
	 * @param tableKey
	 * @param extend
	 * @return 过滤table字段
	 * @throws Throwable
	 */
	public static Map<String, String> filterTableFiled(String formKey, String tableKey, String extend) throws Throwable {
		HashMap<String, String> hashMap = new HashMap<>();
		String linkPath = StringUtils.isNotEmpty(extend) ? LoadFileTree.getDataMapPathByKey(extend) : null;
		TagNode root = Objects.requireNonNull(Xml4jUtil.parseTree(linkPath)).getRoot();
		boolean srcDataObjectKey = root.getAttributes().get(ConstantUtil.SRC_DATA_OBJECT_KEY).equalsIgnoreCase(formKey);
		List<TagNode> tagNodes = srcDataObjectKey ? root.findNodesByTagName(ConstantUtil.SOURCE_TABLE) : root.findNodesByTagName(ConstantUtil.TARGET_TABLE);
		for (TagNode tagNode : tagNodes) {
			if (tagNode.getAttributes().get(ConstantUtil.DATA_SOURCE).equalsIgnoreCase(tableKey)) {
				List<TagNode> filedNodes = srcDataObjectKey ? tagNode.findNodesByTagName(ConstantUtil.SOURCE_FIELD) : tagNode.findNodesByTagName(ConstantUtil.TARGET_FIELD);
				setFilterFiledMap(hashMap, filedNodes, true);
				break;
			}
		}
		return hashMap;
	}

	/**
	 * 根据tablekey去获取字段属性
	 *
	 * @param jsonDataMapVo
	 * @return
	 */
	public ResponseResult<JSONArray> getTreeFields(JsonDataMapVo jsonDataMapVo) {
		ResponseResult<JSONArray> result = new ResponseResult<>();
		JSONArray nodesJsonArray = new JSONArray();
		try {
			//如果源表单和目标表单相同的话就进行拆分拿到真正的formKey
			String formKey = jsonDataMapVo.getFormKey().split("__")[0];
			String tableKey = jsonDataMapVo.getTableKey();
			String filePath = jsonDataMapVo.getFilePath();
			String tmpFile = XmlFileProcessor.instance.getTmpFile(filePath);
			if (tmpFile != null) {
				filePath = tmpFile;
			}
			Element element = DataMapOperJsonUtil.getElement(filePath);
			String nodeName = jsonDataMapVo.getNodeName();
			XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(filePath);
			String name = element.getName();
			if (ConstantUtil.MAP.equals(name)) {//数据映射
				if (ConstantUtil.SOURCE_TABLE_COLLECTION.equals(nodeName)) {
					formKey = element.attributeValue(ConstantUtil.SRC_FORM_KEY);
				} else if (ConstantUtil.TARGET_TABLE_COLLECTION.equals(nodeName)) {
					formKey = element.attributeValue(ConstantUtil.TGT_FORM_KEY);
				} else {
					String objectKey = jsonDataMapVo.getFormKey().split("__")[0];
					List<Element> elements = element.element(ConstantUtil.FEEDBACK_COLLECTION).elements(ConstantUtil.FEEDBACK_OBJECT);
					for (Element element1 : elements) {
						if (objectKey.equalsIgnoreCase(element1.attributeValue(ConstantUtil.FORM_KEY))) {
							formKey = element1.attributeValue(ConstantUtil.FORM_KEY);
							break;
						}
					}
				}
			} else {
				if (ConstantUtil.SOURCE_TABLE_COLLECTION.equals(nodeName)) {
					formKey = element.attributeValue(ConstantUtil.SRC_DATA_OBJECT_KEY);
				} else if (ConstantUtil.TARGET_TABLE_COLLECTION.equals(nodeName)) {
					formKey = element.attributeValue(ConstantUtil.TGT_DATA_OBJECT_KEY);
				}
			}
			//form可能有两种类型，数据对象和普通表单，根据表单的不同做不同的区分方法
			TwoTuple<MetaForm, MetaDataObject> metaFormOrMetaDataObject = publicMethodUtil.MetaFormOrMetaDataObject(formKey);
			MetaForm metaForm = metaFormOrMetaDataObject.metaForm;
			MetaDataObject metaDataObject = metaFormOrMetaDataObject.metaDataObject;

			if (ConstantUtil.MAP.equals(name)) {//数据映射
				String extend = element.attributeValue("Extend");
				String mergeToSource = element.attributeValue("MergeToSource");
				boolean isFilter = StringUtils.isNotEmpty(extend) && StringUtils.isNotEmpty(mergeToSource);
				MetaTableCollection tableCollection = null;
				String formKey1 = jsonDataMapVo.getFormKey().split("__")[0];
				if (ConstantUtil.SOURCE_TABLE_COLLECTION.equals(nodeName)) {
					formKey1 = element.attributeValue(ConstantUtil.SRC_FORM_KEY);
				} else if (ConstantUtil.TARGET_TABLE_COLLECTION.equals(nodeName)) {
					formKey1 = element.attributeValue(ConstantUtil.TGT_FORM_KEY);
				} else {
					String objectKey = jsonDataMapVo.getFormKey().split("__")[0];
					List<Element> elements = element.element(ConstantUtil.FEEDBACK_COLLECTION).elements(ConstantUtil.FEEDBACK_OBJECT);
					for (Element element1 : elements) {
						if (objectKey.equalsIgnoreCase(element1.attributeValue(ConstantUtil.FORM_KEY))) {
							formKey1 = element1.attributeValue(ConstantUtil.FORM_KEY);
							break;
						}
					}
				}
				MetaForm metaForm1 = MetaFactory.getGlobalInstance().getMetaForm(formKey1);
				IDLookup idLookup = IDLookup.getIDLookup(metaForm1);
				if (metaForm != null) {//表单
					tableCollection = metaForm.getDataSource().getDataObject().getTableCollection();
				} else if (metaDataObject != null) {//数据对象表单
					tableCollection = metaDataObject.getTableCollection();
				}
				if (tableCollection != null) {
					for (int i = 0; i < tableCollection.size(); i++) {
						MetaTable metaColumns = tableCollection.get(i);
						int finalI = i + 1;
						String finalTable = metaColumns.getKey();
						Map<String, List<String>> columKeysAndFieldKeys = idLookup.getColumKeysAndFieldListKeys(finalTable);
						if (MapUtils.isEmpty(columKeysAndFieldKeys)) {
							continue;
						}
						if (metaColumns.getKey().equals(tableKey)) {
							Collection<MetaColumn> elementMap = metaColumns.items();
							if (elementMap != null) {
								for (MetaColumn metaColumn : elementMap) {
									if (!metaColumn.getKey().contains("_NODB")) {
										List<String> fieldKeys = columKeysAndFieldKeys.get(metaColumn.getKey());
										if (CollectionUtils.isEmpty(fieldKeys)) {
											continue;
										}
										for (String fieldKey : fieldKeys) {

											if (isFilter) {
												Map<String, String> map = filterFiledMap(extend, metaForm1);
												if (!map.containsValue(fieldKey)) {
													setArray(formKey, nodesJsonArray, finalI, finalTable, metaColumn, false, false, nodeName, metaColumns, xmlTreeWithPath, idLookup, fieldKey);
												}
											} else {
												setArray(formKey, nodesJsonArray, finalI, finalTable, metaColumn, false, false, nodeName, metaColumns, xmlTreeWithPath, idLookup, fieldKey);
											}

										}
									}
								}
							}
						}
					}
				}

			} else if (ConstantUtil.DATA_MIGRATION.equals(name)) {//数据迁移
				setArrayUniversalByTableKey(formKey, metaForm, metaDataObject, nodesJsonArray, tableKey, true, false, nodeName, xmlTreeWithPath);
			}
			result.setCode(0);
			result.setMsg("获取数据表字段成功");
			result.setData(nodesJsonArray);
		} catch (Throwable e) {
			logger.warning("获取数据表字段异常，异常为:" + ExceptionUtils.getStackTrace(e));
			result.setCode(999);
			result.setMsg("获取数据表字段失败，失败消息为:" + e.getMessage());
		}
		return result;
	}

	/**
	 * 删除字段方法
	 *
	 * @param jsonDataMapVo
	 * @return
	 */
	public ResponseResult<JSONArray> getdeleteField(JsonDataMapVo jsonDataMapVo) throws Throwable {
		ResponseResult<JSONArray> result = new ResponseResult<>();
		FileOutputStream fileOutputStream = null;
		XMLWriter writer = null;
		String tempPath = "", filePaths = "";
		try {
			// xml文件路径
			filePaths = jsonDataMapVo.getFilePath();
			tempPath = XmlFileProcessor.instance.getTmpFile(filePaths);
			if (StringUtils.isBlank(tempPath)) {
				tempPath = filePaths;
			}
			// 要删除键值
			String key = jsonDataMapVo.getFieldKey();
			if (key != null) {
				key = key.replaceAll("'", "\"");
			}
			//当前操作的FormKey
			String formKey = jsonDataMapVo.getFormKey().split("__")[0];
			//所在的TableKey
			String tableKey = jsonDataMapVo.getTableKey();
			//操作的是源表单还是目标表单
			String nodeName = jsonDataMapVo.getNodeName();
			// 创建SAX读取器
			SAXReader reader = new SAXReader();
			// 加载文档
			Document document = reader.read(new File(tempPath));
			//根据情况去添加节点
			if (ConstantUtil.SOURCE_TABLE_COLLECTION.equalsIgnoreCase(nodeName)) {
				List<Node> sourceFieldList = getMapSourceFieldNodeListByTableKey(document, tableKey);
				Element sourceTable = getMapSourceTableNodeByTableKey(document, tableKey);
				Element sourceField = getMapSourceFieldNodeByTableKey_Definitionkey(document, tableKey, key);
				if (sourceFieldList.size() == 1) {
					Element sourceTableList = getMapSourceTableCollectionNode(document);
					if (Objects.isNull(sourceTableList)) {
						String xpathExpression = "/DataMigration/SourceTableCollection";
						sourceTableList = (Element) document.selectSingleNode(xpathExpression);
					}
					sourceTableList.remove(sourceTable);
				} else {
					sourceTable.remove(sourceField);
				}
			} else if (ConstantUtil.TARGET_TABLE_COLLECTION.equalsIgnoreCase(nodeName)) {
				List<Node> targetFieldList = getMapTargetFieldNodeListByTableKey(document, tableKey);
				Element targetTable = getMapTargetTableNodeByTableKey(document, tableKey);
				Element targetField = getMapTargetFieldNodeByTableKey_Definitionkey(document, tableKey, key);
				if (targetFieldList.size() == 1) {
					Element targetTableList = getMapTargetTableCollectionNode(document);
					if (targetTableList == null) {
						targetTableList = (Element) document.selectSingleNode("/DataMigration/TargetTableCollection");
					}
					targetTableList.remove(targetTable);
				} else {
					targetTable.remove(targetField);
				}
				//删除源字段中关联的字段
				List<Node> mapSourceTableNodeList = getMapSourceTableNodeList(document);
				for (Node sourceTableNode : mapSourceTableNodeList) {
					List<Node> sourceFieldNodeList = sourceTableNode.selectNodes("SourceField[@TargetFieldKey='" + key + "']");
					for (Node sourceFieldNode : sourceFieldNodeList) {
						Element node = (Element) sourceFieldNode;
						String tableKey1 = node.attributeValue("TargetTableKey");
						if (StringUtils.isNotEmpty(tableKey1)) {
							if (tableKey.equalsIgnoreCase(tableKey1)) {
								node.remove(node.attribute("TargetTableKey"));
								node.remove(node.attribute("TargetFieldKey"));
							} else {

							}
						} else {
							node.remove(node.attribute("TargetFieldKey"));
						}
					}
				}
			} else if (ConstantUtil.FEEDBACK_COLLECTION.equalsIgnoreCase(nodeName)) {
				List<Node> feedbackFieldList = getMapFeedbackFieldNodeList(document, formKey, tableKey);
				Element feedbackTable = getMapFeedbackTableNode(document, formKey, tableKey);
				Element feedField = getMapFeedbackFieldNode(document, formKey, tableKey, key);
				if (feedbackFieldList.size() == 1 && feedField != null) {
					Element feedbackTableList = getMapFeedbackObjectNode(document, formKey);
					feedbackTableList.remove(feedbackTable);
				} else {
					feedbackTable.remove(feedField);
				}
				//删除目标字段中关联的字段
				deleteField(key, tableKey, document);
			}

			OutputFormat format = getOutputFormat();
			String solutionPath = FilePathHelper.getWorkspacePath() + File.separator;
			String newFilePath = Paths.get(WebDesignerConfiguration.getDesignerDataPath(), "tmp", filePaths.substring(solutionPath.length()).replace(File.separator, "__") + "." + System.currentTimeMillis()).toString();
			fileOutputStream = new FileOutputStream(newFilePath);
			writer = new XMLWriter(fileOutputStream, format);
			writer.write(document);
			XmlFileProcessor.stackput(filePaths, newFilePath);
			result.setCode(0);
			result.setMsg("删除字段成功");

		} catch (Exception e) {
			logger.warning("删除字段异常，异常为:" + ExceptionUtils.getStackTrace(e));
			result.setCode(999);
			result.setMsg("删除字段失败，失败消息为:" + e.getMessage());
		} finally {
			setData(result, filePaths);
			closeFileStream(fileOutputStream, writer);
		}
		return result;
	}

	private void deleteField(String key, String tableKey, Document document) {
		List<Node> mapTargetTableNodeList = getMapTargetTableNodeList(document);
		for (Node targetTableNode : mapTargetTableNodeList) {
			List<Node> targetFieldNodeList = targetTableNode.selectNodes("TargetField");
			for (Node targetFieldNode : targetFieldNodeList) {
				List<Node> feedbackNodes = targetFieldNode.selectNodes("Feedback[@FieldKey='" + key + "']");
				for (Node feedbackNode : feedbackNodes) {
					String tableValue = ((Element) feedbackNode).attributeValue("TableKey");
					if (tableKey.equalsIgnoreCase(tableValue)) {
						((Element) targetFieldNode).remove(feedbackNode);
					}
				}
			}
		}
	}

	/**
	 * 根据tableKey获取数据映射中的源表单集合
	 *
	 * @param document
	 * @return
	 */
	public static Element getMapSourceTableCollectionNode(Document document) {
		String xpathExpression = "/Map/SourceTableCollection";
		Element nodes = (Element) document.selectSingleNode(xpathExpression);
		return nodes;
	}

	/**
	 * 根据tableKey获取数据映射中的目标表单集合
	 *
	 * @param document
	 * @return
	 */
	public static Element getMapTargetTableCollectionNode(Document document) {
		String xpathExpression = "/Map/TargetTableCollection";
		Element nodes = (Element) document.selectSingleNode(xpathExpression);
		return nodes;
	}

	/**
	 * 根据formKey获取数据映射中的反填表单
	 *
	 * @param document
	 * @return
	 */
	public static Element getMapFeedbackObjectNode(Document document, String formKey) {
		Element node = (Element) document.selectSingleNode("/Map/FeedbackCollection/FeedbackObject[@FormKey='" + formKey + "']");
		return node;
	}

	/**
	 * 根据formKey获取数据映射中的反填表单中的TableNode
	 *
	 * @param document
	 * @return
	 */
	public static Element getMapFeedbackTableNode(Document document, String formKey, String tableKey) {
		Element node = (Element) getMapFeedbackObjectNode(document, formKey).selectSingleNode("FeedbackTable[@TableKey='" + tableKey + "']");
		return node;
	}

	/**
	 * 根据formKey获取数据映射中的反填表单中的TableNode
	 *
	 * @param document
	 * @return
	 */
	public static List<Node> getMapFeedbackFieldNodeList(Document document, String formKey, String tableKey) {
		List<Node> feedbackField = getMapFeedbackTableNode(document, formKey, tableKey).selectNodes("FeedbackField");
		return feedbackField;
	}

	/**
	 * 根据formKey获取数据映射中的反填表单中的TableNode
	 *
	 * @param document
	 * @return
	 */
	public static Element getMapFeedbackFieldNode(Document document, String formKey, String tableKey, String key) {
		Element node = (Element) getMapFeedbackTableNode(document, formKey, tableKey).selectSingleNode("FeedbackField[@FieldKey='" + key + "']");
		return node;
	}

	/**
	 * 根据tableKey获取数据映射中的SourceTable集合
	 *
	 * @param document
	 * @return
	 */
	public static List<Node> getMapSourceTableNodeList(Document document) {
		List<Node> node;
		if (Objects.isNull(getMapSourceTableCollectionNode(document))) {
			node = DataMigrationOperXmlUtil.getMapSourceTableCollectionNode(document).selectNodes("SourceTable");
		} else {
			node = getMapSourceTableCollectionNode(document).selectNodes("SourceTable");
		}
		return node;
	}

	/**
	 * 根据tableKey获取数据映射中的TargetTable集合
	 *
	 * @param document
	 * @return
	 */
	public static List<Node> getMapTargetTableNodeList(Document document) {
		List<Node> node;
		if (Objects.isNull(getMapTargetTableCollectionNode(document))) {
			node = DataMigrationOperXmlUtil.getMapTargetTableCollectionNode(document).selectNodes("SourceTable");
		} else {
			node = getMapTargetTableCollectionNode(document).selectNodes("SourceTable");
		}
		return node;
	}

	/**
	 * 根据tableKey获取数据映射中的SourceTableNode
	 *
	 * @param document
	 * @param tableKey
	 * @return
	 */
	public static Element getMapSourceTableNodeByTableKey(Document document, String tableKey) {
		Element node = null;
		if (Objects.isNull(getMapSourceTableCollectionNode(document))) {//数据迁移
			node = (Element) DataMigrationOperXmlUtil.getMapSourceTableCollectionNode(document).selectSingleNode("SourceTable[@TableKey='" + tableKey + "']");
		} else {//数据映射
			node = (Element) getMapSourceTableCollectionNode(document).selectSingleNode("SourceTable[@Key='" + tableKey + "']");
		}
		return node;
	}

	/**
	 * 根据tableKey获取数据映射中的TargetTableNode
	 *
	 * @param document
	 * @param tableKey
	 * @return
	 */
	public static Element getMapTargetTableNodeByTableKey(Document document, String tableKey) {
		Element node = null;
		if (Objects.isNull(getMapTargetTableCollectionNode(document))) {
			node = (Element) DataMigrationOperXmlUtil.getMapTargetTableCollectionNode(document).selectSingleNode("TargetTable[@TableKey='" + tableKey + "']");
		} else {
			node = (Element) getMapTargetTableCollectionNode(document).selectSingleNode("TargetTable[@Key='" + tableKey + "']");
		}
		return node;
	}

	/**
	 * 根据tableKey获取数据映射中的源字段集合
	 *
	 * @param document
	 * @param tableKey
	 * @return
	 */
	public static List<Node> getMapSourceFieldNodeListByTableKey(Document document, String tableKey) {
		List<Node> nodes1 = getMapSourceTableNodeByTableKey(document, tableKey).selectNodes("SourceField");
		return nodes1;
	}

	/**
	 * 根据tableKey获取数据映射中的目标字段集合
	 *
	 * @param document
	 * @param tableKey
	 * @return
	 */
	public static List<Node> getMapTargetFieldNodeListByTableKey(Document document, String tableKey) {
		List<Node> nodes1 = getMapTargetTableNodeByTableKey(document, tableKey).selectNodes("TargetField");
		return nodes1;
	}

	/**
	 * 根据tableKey和字段Key获取数据映射中的源字段集合
	 *
	 * @param document
	 * @param tableKey
	 * @return
	 */
	public static Element getMapSourceFieldNodeByTableKey_Definitionkey(Document document, String tableKey, String key) {
		if (key != null) {
			key = key.replaceAll("'", "\"");
		}
		Element nodes1 = (Element) getMapSourceTableNodeByTableKey(document, tableKey).selectSingleNode("SourceField[@Definition='" + key + "']");
		return nodes1;
	}

	/**
	 * 根据tableKey和字段Key获取数据映射中的源字段集合
	 *
	 * @param document
	 * @param tableKey
	 * @return
	 */
	public static Element getMapSourceFieldNodeByTableKey_TargetFieldKey(Document document, String tableKey, String key) {
		Element nodes1 = (Element) getMapSourceTableNodeByTableKey(document, tableKey).selectSingleNode("SourceField[@TargetFieldKey='" + key + "']");
		return nodes1;
	}

	/**
	 * 根据tableKey获取数据映射中的目标字段集合
	 *
	 * @param document
	 * @param tableKey
	 * @return
	 */
	public static Element getMapTargetFieldNodeByTableKey_Definitionkey(Document document, String tableKey, String key) {
		if (key != null) {
			key = key.replaceAll("'", "\"");
		}
		Element nodes1 = (Element) getMapTargetTableNodeByTableKey(document, tableKey).selectSingleNode("TargetField[@Definition='" + key + "']");
		if (Objects.isNull(nodes1)) {
			nodes1 = (Element) getMapTargetTableNodeByTableKey(document, tableKey).selectSingleNode("TargetField" + "[@FieldKey" + "='" + key + "']");
		}
		return nodes1;
	}


	/**
	 * @param jsonDataMapVo
	 * @return 获取字段信息
	 * @throws Throwable
	 */
	public ResponseResult<JSONArray> fieldInfo(JsonDataMapVo jsonDataMapVo) throws Throwable {
		String tempPath = XmlFileProcessor.instance.getTmpFile(jsonDataMapVo.getFilePath());
		if (StringUtils.isBlank(tempPath)) {
			tempPath = jsonDataMapVo.getFilePath();
		}
		//保证数据的实时性数据就从临时文件中获取
		Element root = DataMapOperJsonUtil.getElement(tempPath);
		ResponseResult<JSONArray> result = new ResponseResult<>();
		MetaTable metaTable = null;
		JSONArray array = null;
		IDLookup idLookup = null;
		try {
			array = new JSONArray();
			JSONObject nodeJson = new JSONObject();
			String formKey = jsonDataMapVo.getFormKey().split("__")[0];
			String fieldKey = jsonDataMapVo.getFieldKey();
			if (fieldKey != null) {
				fieldKey = fieldKey.replaceAll("'", "\"");
			}
			String tableKey = jsonDataMapVo.getTableKey();
			String nodeName = jsonDataMapVo.getNodeName();
			String operationType = jsonDataMapVo.getOperationType();
			//数据迁移目标用的是数据对象在getMetaForm中是找不到的，所以做一个区分
			TwoTuple<MetaForm, MetaDataObject> metaFormOrMetaDataObject = publicMethodUtil.MetaFormOrMetaDataObject(formKey);
			MetaForm metaForm = metaFormOrMetaDataObject.metaForm;
			MetaDataObject metaDataObject = metaFormOrMetaDataObject.metaDataObject;
			if (metaForm != null) {
				metaTable = metaForm.getMetaTable(tableKey);
				idLookup = IDLookup.getIDLookup(metaForm);
			} else if (metaDataObject != null) {
				metaTable = metaDataObject.getMetaTable(tableKey);
			}
			if (metaTable != null) {    //根据情况去添加节点
				String tableNode = "", filedNode = "";
				if (ConstantUtil.SOURCE_TABLE_COLLECTION.equalsIgnoreCase(nodeName)) {
					tableNode = ConstantUtil.SOURCE_TABLE;
					filedNode = ConstantUtil.SOURCE_FIELD;
				} else if (ConstantUtil.TARGET_TABLE_COLLECTION.equalsIgnoreCase(nodeName)) {
					tableNode = ConstantUtil.TARGET_TABLE;
					filedNode = ConstantUtil.TARGET_FIELD;
				} else if (ConstantUtil.FEEDBACK_COLLECTION.equalsIgnoreCase(nodeName)) {
					tableNode = ConstantUtil.FEEDBACK_TABLE;
					filedNode = "FeedbackField";
				}
				List<Element> elements = root.element(nodeName).elements(tableNode);
				//反填表单要比目标表单和源表单多一层，需要进一步处理
				if (ConstantUtil.FEEDBACK_COLLECTION.equalsIgnoreCase(nodeName)) {
					List<Element> feedbackObject = root.element(nodeName).elements(ConstantUtil.FEEDBACK_OBJECT);
					for (Element ele : feedbackObject) {
						if (ele.attributeValue(ConstantUtil.FORM_KEY).equalsIgnoreCase(formKey)) {
							elements = ele.elements("tableNode");
						}
					}
				}
				String TargetTableKey = null;
				String refFieldKey = null;
				String IsPrimary = "false";
				String Condition = "";
				String RowTrigger = " ";
				String keyId = "";
				if ("field".equalsIgnoreCase(operationType)) {
					//获取字段信息
					MetaColumn metaColumn = getMetaColumn(fieldKey, tableKey, metaTable, idLookup);
					if (Objects.isNull(metaColumn)) {
						metaColumn = metaTable.get(fieldKey);
					}
					for (Element ele : elements) {
						Boolean key = isMigration(nodeName, nodeJson, tableKey, ele);
						if (key) {
							IsPrimary = String.valueOf(!ConstantUtil.SOURCE_FIELD.equals(filedNode));
							List<Element> sourceField = ele.elements(ConstantUtil.SOURCE_FIELD);
							//获取字段上的一些属性
							for (Element element : sourceField) {
								if (element.attributeValue(ConstantUtil.DEFINITION).equalsIgnoreCase(fieldKey)) {
									refFieldKey = element.attributeValue("RefFieldKey");
									keyId = element.attributeValue("Key");
									if (ele.attributeValue("IsPrimary") != null) {
										IsPrimary = ele.attributeValue("IsPrimary");
									}
									break;
								}
							}
						}
					}
					if (refFieldKey != null) {
						nodeJson.put("refFieldKey", refFieldKey);
					} else {
						nodeJson.put("refFieldKey", "");
					}
					nodeJson.put("IsPrimary", IsPrimary);
					if (!ConstantUtil.DATA_MIGRATION.equalsIgnoreCase(root.getName())) {
						nodeJson.put(ConstantUtil.KEY, keyId);
					}
					if (metaColumn != null) {
						nodeJson.put(ConstantUtil.CAPTION, metaColumn.getCaption());
						nodeJson.put("DataType", DataType.toString(metaColumn.getDataType()));
					}
				} else if ("table".equalsIgnoreCase(operationType)) {
					for (Element ele : elements) {
						//区分数据映射和数据迁移
						Boolean key = isMigration(nodeName, nodeJson, tableKey, ele);
						if (key) {
							TargetTableKey = ele.attributeValue(ConstantUtil.TARGET_TABLE_KEY);
							if (ele.attributeValue("IsPrimary") != null) {
								IsPrimary = ele.attributeValue("IsPrimary");
								if ("true".equalsIgnoreCase(IsPrimary)) {
									Condition = ele.attributeValue("Condition");
								}
							}
							RowTrigger = ele.attributeValue("RowTrigger");
						}
					}
					nodeJson.put("tableKey", metaTable.getKey());
					nodeJson.put("tableCaption", metaTable.getCaption());
					nodeJson.put(ConstantUtil.TARGET_TABLE_KEY, TargetTableKey);
					nodeJson.put("IsPrimary", IsPrimary);
					nodeJson.put("Condition", Condition);
					nodeJson.put("RowTrigger", RowTrigger);
				} else if ("ConstAndFormula".equalsIgnoreCase(operationType)) {
					for (Element ele : elements) {
						//区分数据映射和数据迁移
						Boolean key = isMigration(nodeName, nodeJson, tableKey, ele);
						if (key) {
							List<Element> Field = ele.elements(filedNode);
							//这种还是没有添加数据的公式字段和常量字段
							if ("".equalsIgnoreCase(fieldKey)) {
								String tableKey1 = getTableKey(ele);
								if (tableKey1.equalsIgnoreCase(tableKey)) {
									if (ele.attributeValue("IsPrimary") != null) {
										IsPrimary = ele.attributeValue("IsPrimary");
									}
									nodeJson.put("IsPrimary", IsPrimary);
								}
							} else {
								String name = root.getName();
								IsPrimary = loadformula(nodeJson, fieldKey, IsPrimary, ele, Field, name);
							}
						}
					}
				}
				nodeJson.put("isMigration", root.getQName().getName());
			} else if ("collection".equalsIgnoreCase(operationType)) {
				Element element = root.element(ConstantUtil.FEEDBACK_COLLECTION);
				if (element != null) {
					nodeJson.put("StatusFieldKey", element.attributeValue("StatusFieldKey"));
					nodeJson.put("StatusValue", element.attributeValue("StatusValue"));
					nodeJson.put("Condition", element.attributeValue("Condition"));
				}

			}

			array.add(nodeJson);
			result.setCode(0);
			result.setMsg("获取字段信息成功");
			result.setData(array);
		} catch (Exception e) {
			logger.warning("获取字段信息失败，异常为:" + ExceptionUtils.getStackTrace(e));
			result.setCode(999);
			result.setMsg("获取字段信息失败，失败消息为:" + e.getMessage());
		} catch (Throwable throwable) {
			logger.warning(throwable.getMessage());
		}
		return result;
	}

	/**
	 * @param nodeJson
	 * @param fieldKey
	 * @param isPrimary
	 * @param ele
	 * @param field
	 * @return 获取公式字段和常量字段的信息，这个是有值的情况下
	 */
	public String loadformula(JSONObject nodeJson, String fieldKey, String isPrimary, Element ele, List<Element> field, String name) {
		for (Element elefield : field) {
			if (Objects.isNull(elefield.attributeValue(ConstantUtil.DEFINITION)) || elefield.attributeValue(ConstantUtil.DEFINITION).equalsIgnoreCase(fieldKey)) {
				String type = elefield.attributeValue(ConstantUtil.TYPE);
				if (ele.attributeValue("IsPrimary") != null) {
					isPrimary = ele.attributeValue("IsPrimary");
				}
				nodeJson.put("IsPrimary", isPrimary);
				nodeJson.put("refFieldKey", elefield.attributeValue("RefFieldKey"));
				nodeJson.put("type", type);
				if (!ConstantUtil.DATA_MIGRATION.equalsIgnoreCase(name)) {
					nodeJson.put(ConstantUtil.KEY, elefield.attributeValue("Key"));
				}
				break;
			}
		}
		return isPrimary;
	}

	/**
	 * @param nodeJson 集合，用于向前端传输Json数据
	 * @param tableKey 当前操作的TableKey
	 * @param ele      字段节点
	 * @return 用于确认当前是否有匹配的节点
	 */
	public static Boolean isMigration(String nodeName, JSONObject nodeJson, String tableKey, Element ele) {
		Boolean key = false;
		if (ele.attributeValue(ConstantUtil.KEY) != null) {
			key = ele.attributeValue(ConstantUtil.KEY).equalsIgnoreCase(tableKey);
		} else if (ele.attributeValue(ConstantUtil.TABLE_KEY) != null) {
			key = ele.attributeValue(ConstantUtil.TABLE_KEY).equalsIgnoreCase(tableKey);
			if (ConstantUtil.TARGET_TABLE_COLLECTION.equalsIgnoreCase(nodeName)) {
				nodeJson.put("isMigration", "isMigration");
			}
		}
		return key;
	}

	public static MetaColumn getMetaColumn(String fieldKey, String tableKey, MetaTable table, IDLookup idLookup) {
		MetaColumn metaColumn = null;
		if (Objects.isNull(metaColumn) && idLookup != null && table != null) {
			metaColumn = table.get(fieldKey);
			if (Objects.isNull(metaColumn)) {
				Map<String, String> columKeysAndFieldKeys = idLookup.getColumKeysAndFieldKeys(tableKey);
				for (String key : columKeysAndFieldKeys.keySet()) {
					if (key.indexOf("_NODB") == -1 && columKeysAndFieldKeys.get(key).equalsIgnoreCase(fieldKey)) {
						metaColumn = table.get(key);
					}
				}
			}

		}
		return metaColumn;
	}

	/**
	 * 获取目标表单中的表名
	 *
	 * @param jsonDataMapVo
	 * @return
	 */
	public ResponseResult<JSONArray> getTargetTableList(JsonDataMapVo jsonDataMapVo) {
		ResponseResult<JSONArray> result = new ResponseResult<>();
		JSONArray array = null;
		try {
			array = new JSONArray();
			String filePaths = jsonDataMapVo.getFilePath();
			String tempPath = XmlFileProcessor.instance.getTmpFile(filePaths);
			if (StringUtils.isBlank(tempPath)) {
				tempPath = filePaths;
			}
			// 创建SAX读取器
			SAXReader reader = new SAXReader();
			// 加载文档
			Document document = reader.read(new File(tempPath));
			// 获取根节点
			Element root = document.getRootElement();
			List<Element> elements = root.element(ConstantUtil.TARGET_TABLE_COLLECTION).elements(ConstantUtil.TARGET_TABLE);
			for (Element ele : elements) {
				JSONObject nodeJson = new JSONObject();
				nodeJson.put("name", ele.attributeValue(ConstantUtil.KEY));
				nodeJson.put("value", ele.attributeValue(ConstantUtil.KEY));
				array.add(nodeJson);
			}
			result.setCode(0);
			result.setMsg("获取目标表成功");
			result.setData(array);
		} catch (Exception e) {
			logger.warning("获取目标表失败，异常为:" + ExceptionUtils.getStackTrace(e));
			result.setCode(999);
			result.setMsg("获取目标表失败，失败消息为:" + e.getMessage());
		} catch (Throwable throwable) {
			logger.warning(throwable.getMessage());
		}
		return result;
	}

	/**
	 * 获取源映射字段List
	 *
	 * @param jsonDataMapVo
	 * @return
	 */
	public ResponseResult<JSONArray> getSourceFieldList(JsonDataMapVo jsonDataMapVo) {
		ResponseResult<JSONArray> result = new ResponseResult<>();
		JSONArray array = null;
		try {
			array = new JSONArray();
			String filePaths = jsonDataMapVo.getFilePath();
			String tableKey = jsonDataMapVo.getTableKey();
			String tempPath = XmlFileProcessor.instance.getTmpFile(filePaths);
			if (StringUtils.isBlank(tempPath)) {
				tempPath = filePaths;
			}
			// 创建SAX读取器
			SAXReader reader = new SAXReader();
			// 加载文档
			Document document = reader.read(new File(tempPath));
			// 获取根节点
			Element root = document.getRootElement();
//			String mergeToSource = root.attributeValue("MergeToSource");
			String extend = root.attributeValue("Extend");
			JSONObject defaults = new JSONObject();
			defaults.put("name", "默认");
			defaults.put("value", "default");
			array.add(defaults);
			if (StringUtils.isNotEmpty(extend)) {//只开启含有mergeToSource属性的
				String dataMapPathByKey = LoadFileTree.getDataMapPathByKey(extend);
				root = reader.read(new File(dataMapPathByKey)).getRootElement();
				List<Node> elements = root.selectNodes("/Map/SourceTableCollection/SourceTable[@Key='" + tableKey + "']/SourceField");
				for (Node ele1 : elements) {
					Element ele = (Element) ele1;
					JSONObject nodeJson = new JSONObject();
					nodeJson.put("name", ele.attributeValue(ConstantUtil.DEFINITION) + "->" + ele.attributeValue("TargetFieldKey") + "  _" + ele.attributeValue(ConstantUtil.KEY));
					nodeJson.put("value", ele.attributeValue(ConstantUtil.KEY));
					array.add(nodeJson);
				}
			}
			result.setCode(0);
			result.setMsg("获取目标表成功");
			result.setData(array);
		} catch (Exception e) {
			logger.warning("获取目标表失败，异常为:" + ExceptionUtils.getStackTrace(e));
			result.setCode(999);
			result.setMsg("获取目标表失败，失败消息为:" + e.getMessage());
		} catch (Throwable throwable) {
			logger.warning(throwable.getMessage());
		}
		return result;
	}

	/**
	 * 获取参照主表中的字段
	 *
	 * @param jsonDataMapVo
	 * @return
	 */
	public ResponseResult<JSONArray> getRefFieldKey(JsonDataMapVo jsonDataMapVo) {
		ResponseResult<JSONArray> result = new ResponseResult<>();
		JSONArray array = null;
		try {
			array = new JSONArray();
			String filePaths = jsonDataMapVo.getFilePath();
			String tempPath = XmlFileProcessor.instance.getTmpFile(filePaths);
			if (StringUtils.isBlank(tempPath)) {
				tempPath = filePaths;
			}
			// 创建SAX读取器
			SAXReader reader = new SAXReader();
			// 加载文档
			Document document = reader.read(new File(tempPath));
			// 获取根节点
			Element root = document.getRootElement();
			//获取源单的表单名
			String formKey = root.attributeValue(ConstantUtil.SRC_DATA_OBJECT_KEY);
			TwoTuple<MetaForm, MetaDataObject> metaFormOrMetaDataObject = publicMethodUtil.MetaFormOrMetaDataObject(formKey);
			MetaForm metaForm = metaFormOrMetaDataObject.metaForm;
			MetaDataObject metaDataObject = metaFormOrMetaDataObject.metaDataObject;
			List<Element> elements = root.element(ConstantUtil.SOURCE_TABLE_COLLECTION).elements(ConstantUtil.SOURCE_TABLE);
			for (Element ele : elements) {
				JSONObject nodeJson;
				if ("true".equalsIgnoreCase(ele.attributeValue("IsPrimary"))) {
					String name = root.getQName().getName();
					String tableKey = ele.attributeValue(ConstantUtil.MAP.equalsIgnoreCase(name) ? ConstantUtil.KEY : ConstantUtil.TABLE_KEY);
					MetaTable table = Optional.ofNullable(metaForm).map(form -> form.getDataSource().getDataObject().getTable(tableKey)).orElse(Optional.ofNullable(metaDataObject).map(dataObject -> dataObject.getTable(tableKey)).orElse(null));
					for (MetaColumn col : Objects.requireNonNull(table)) {
						if (!"MapCount".equalsIgnoreCase(col.getKey())) {
							nodeJson = new JSONObject();
							nodeJson.put("name", "主表" + "   " + col.getKey() + "  " + col.getCaption());
							nodeJson.put("value", col.getKey());
							array.add(nodeJson);
						}
					}
				}
			}
			result.setCode(0);
			result.setMsg("获取主表字段成功");
			result.setData(array);
		} catch (Exception e) {
			logger.warning("获取主表字段成功失败，异常为:" + ExceptionUtils.getStackTrace(e));
			result.setCode(999);
			result.setMsg("获取主表字段成功失败，失败消息为:" + e.getMessage());
		} catch (Throwable throwable) {
			logger.warning(throwable.getMessage());
		}
		return result;
	}

	/**
	 * 添加目标字段
	 *
	 * @param jsonDataMapVo
	 * @return
	 */
	public ResponseResult<JSONArray> setTargetField(JsonDataMapVo jsonDataMapVo) throws Throwable {
		ResponseResult<JSONArray> result = new ResponseResult<>();
		FileOutputStream fileOutputStream = null;
		XMLWriter writer = null;
		String tempPath = "", filePaths = "";
		try {
			filePaths = jsonDataMapVo.getFilePath();
			tempPath = XmlFileProcessor.instance.getTmpFile(filePaths);
			if (StringUtils.isBlank(tempPath)) {
				tempPath = filePaths;
			}
			// 创建SAX读取器
			SAXReader reader = new SAXReader();
			// 加载文档
			Document document = reader.read(new File(tempPath));
			// 获取根节点
			Element root = document.getRootElement();
			//数据分割方法
			Map map = carveUp(jsonDataMapVo);


			//获取数据
//			String sourceFormKey = ((String) map.get(ConstantUtil.SOURCE_FORM_KEY)).split("__")[0];
			String targetFormKey = ((String) map.get(ConstantUtil.TARGET_FORM_KEY)).split("__")[0], sourceField = (String) map.get("sourceField"), targetField = (String) map.get("targetField"), sourceTableKey = (String) map.get("sourceTableKey"), targetTablekey = (String) map.get("targetTablekey");

			if (sourceField != null) {
				sourceField = sourceField.replaceAll("'", "\"");
			}
			if (targetField != null) {
				targetField = targetField.replaceAll("'", "\"");
			}

			String nodeName = jsonDataMapVo.getNodeName();


			String name = root.getName();
			if (ConstantUtil.MAP.equalsIgnoreCase(name)) {
				//这个是源单字段到目标字段
				if (ConstantUtil.SOURCE_TABLE_COLLECTION.equalsIgnoreCase(nodeName)) {
					//源表单添加目标字段
					sourceAddTarget(root, sourceField, targetField, sourceTableKey, targetTablekey);
				} else if (ConstantUtil.TARGET_TABLE_COLLECTION.equalsIgnoreCase(nodeName)) {
					//这个是处理目标字段到反填字段
					List<Element> feedbackElements = root.element(ConstantUtil.FEEDBACK_COLLECTION).elements(ConstantUtil.FEEDBACK_OBJECT);
					for (Element element1 : feedbackElements) {
						if (targetFormKey.equalsIgnoreCase(element1.attributeValue(ConstantUtil.FORM_KEY))) {
							targetFormKey = element1.attributeValue(ConstantUtil.FORM_KEY);
							break;
						}
					}
					addtargetField(root, targetFormKey, sourceField, targetField, sourceTableKey, targetTablekey, nodeName);
				}
			} else {
				//这个是源单字段到目标字段
				if (ConstantUtil.SOURCE_TABLE_COLLECTION.equalsIgnoreCase(nodeName)) {
					//源表单添加目标字段
					sourceAddTarget(root, sourceField, targetField, sourceTableKey, targetTablekey);
				} else if (ConstantUtil.TARGET_TABLE_COLLECTION.equalsIgnoreCase(nodeName)) {
					//这个是处理目标字段到反填字段
					addtargetField(root, targetFormKey, sourceField, targetField, sourceTableKey, targetTablekey, nodeName);
				}
			}

			OutputFormat format = getOutputFormat();
			String solutionPath = FilePathHelper.getWorkspacePath() + File.separator;
			String newFilePath = Paths.get(WebDesignerConfiguration.getDesignerDataPath(), "tmp", filePaths.substring(solutionPath.length()).replace(File.separator, "__") + "." + System.currentTimeMillis()).toString();
			fileOutputStream = new FileOutputStream(newFilePath);
			writer = new XMLWriter(fileOutputStream, format);
			writer.write(document);
			XmlFileProcessor.stackput(filePaths, newFilePath);
			result.setCode(0);
			result.setMsg("success");

		} catch (Exception e) {
			logger.warning("failure，异常为:" + ExceptionUtils.getStackTrace(e));
			result.setCode(999);
			result.setMsg("failure，失败消息为:" + e.getMessage());
		} catch (Throwable throwable) {
			logger.warning(throwable.getMessage());
		} finally {
			setData(result, filePaths);
			closeFileStream(fileOutputStream, writer);
		}
		return result;
	}

	/**
	 * @param root
	 * @param targetFormKey
	 * @param sourceField
	 * @param targetField
	 * @param sourceTableKey
	 * @param targetTablekey
	 * @param nodeName       这个是处理目标字段到反填字段
	 */
	public void addtargetField(Element root, String targetFormKey, String sourceField, String targetField, String sourceTableKey, String targetTablekey, String nodeName) throws Throwable {
		List<Element> targetTable = root.element(nodeName).elements(ConstantUtil.TARGET_TABLE);
		for (Element ele : targetTable) {
			if (ele.attributeValue(ConstantUtil.KEY).equalsIgnoreCase(sourceTableKey)) {
				List<Element> targetField1 = ele.elements(ConstantUtil.TARGET_FIELD);
				for (Element targetfield : targetField1) {
					if (targetfield.attributeValue(ConstantUtil.DEFINITION).equalsIgnoreCase(sourceField)) {
						List<Element> feedbacks = targetfield.elements("Feedback");
						//当源单字段和目标字段之间没有连接的时候再进行连接
						boolean isExist = false;
						for (Element feedback : feedbacks) {
							isExist = feedback.attributeValue(ConstantUtil.FIELD_KEY).equalsIgnoreCase(targetField);
						}
						if (!isExist) {

							MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(targetFormKey);
							String key = metaForm.getDataSource().getDataObject().getKey();
							targetfield.addElement("Feedback").addAttribute("DataObjectKey", key).addAttribute(ConstantUtil.FEED_FORM_KEY, targetFormKey).addAttribute(ConstantUtil.FIELD_KEY, targetField).addAttribute(ConstantUtil.TABLE_KEY, targetTablekey);
						}
					}
				}
			}
		}
	}

	/**
	 * @param root
	 * @param sourceField
	 * @param targetField
	 * @param sourceTableKey
	 * @param targetTablekey 源单添加目标字段
	 */
	public void sourceAddTarget(Element root, String sourceField, String targetField, String sourceTableKey, String targetTablekey) {
		List<Element> elements = root.element(ConstantUtil.SOURCE_TABLE_COLLECTION).elements(ConstantUtil.SOURCE_TABLE);
		boolean mergeToSource = StringUtils.isNotEmpty(root.attributeValue("MergeToSource"));
		boolean extend = StringUtils.isNotEmpty(root.attributeValue("Extend"));
		String type = null;
		for (Element ele : elements) {
			String tableKey = getTableKey(ele);
			if (tableKey.equalsIgnoreCase(sourceTableKey)) {
				List<Element> sourceField1 = ele.elements(ConstantUtil.SOURCE_FIELD);
				//当前源单字段已经有目标字段的时候就再去创建一个同名字段然后不同目标字段
				for (Element elefiled : sourceField1) {
					//当前字段没有目标字段的时候直接添加，有的话就去判断是否重复
					String attributeValue = elefiled.attributeValue(ConstantUtil.DEFINITION).replaceAll("'", "\"");
					boolean definition = attributeValue.equalsIgnoreCase(sourceField);
					boolean targetFieldKey = Objects.isNull(elefiled.attributeValue(ConstantUtil.TARGET_FIELD_KEY));
					boolean isEqual = false;
					if (elefiled.attributeValue(ConstantUtil.TARGET_FIELD_KEY) != null) {
						if (elefiled.attributeValue(ConstantUtil.TARGET_FIELD_KEY).equalsIgnoreCase(targetField)) {
							isEqual = !targetTablekey.equalsIgnoreCase(elefiled.attributeValue(ConstantUtil.TARGET_TABLE_KEY));
						} else {
							isEqual = true;
						}
					}
					if (definition) {
						if (targetFieldKey) {
							elefiled.addAttribute(ConstantUtil.DEFINITION, sourceField).addAttribute(ConstantUtil.TARGET_FIELD_KEY, targetField).addAttribute(ConstantUtil.TARGET_TABLE_KEY, targetTablekey);
						} else {
							type = elefiled.attributeValue(ConstantUtil.TYPE);
						}
						String maxKey = ele.attributeValue("MaxKey");
						if (isEqual) {
							if (StringUtils.isNotEmpty(type)) {
								if (mergeToSource) {
									if (StringUtils.isNotEmpty(maxKey)) {
										ele.addElement(ConstantUtil.SOURCE_FIELD)
												.addAttribute(ConstantUtil.DEFINITION, sourceField)
												.addAttribute(ConstantUtil.TYPE, type)
												.addAttribute(ConstantUtil.TARGET_FIELD_KEY, targetField)
												.addAttribute(ConstantUtil.TARGET_TABLE_KEY, targetTablekey)
												.addAttribute("Key", "merge_" + (Integer.valueOf(maxKey) + 1));
										ele.addAttribute("MaxKey", (Integer.valueOf(maxKey) + 1) + "");
									} else {
										ele.addElement(ConstantUtil.SOURCE_FIELD)
												.addAttribute(ConstantUtil.DEFINITION, sourceField)
												.addAttribute(ConstantUtil.TYPE, type)
												.addAttribute(ConstantUtil.TARGET_FIELD_KEY, targetField)
												.addAttribute(ConstantUtil.TARGET_TABLE_KEY, targetTablekey)
												.addAttribute("Key", "merge_" + ele.elements().size());
										ele.addAttribute("MaxKey", ele.elements().size() + "");
									}
								} else {
									if (!extend) {
										if (StringUtils.isNotEmpty(maxKey)) {
											ele.addElement(ConstantUtil.SOURCE_FIELD)
													.addAttribute(ConstantUtil.DEFINITION, sourceField)
													.addAttribute(ConstantUtil.TYPE, type)
													.addAttribute(ConstantUtil.TARGET_FIELD_KEY, targetField)
													.addAttribute(ConstantUtil.TARGET_TABLE_KEY, targetTablekey)
													.addAttribute("Key", (Integer.valueOf(maxKey) + 1) + "");
											ele.addAttribute("MaxKey", (Integer.valueOf(maxKey) + 1) + "");
										} else {
											ele.addElement(ConstantUtil.SOURCE_FIELD)
													.addAttribute(ConstantUtil.DEFINITION, sourceField)
													.addAttribute(ConstantUtil.TYPE, type)
													.addAttribute(ConstantUtil.TARGET_FIELD_KEY, targetField)
													.addAttribute(ConstantUtil.TARGET_TABLE_KEY, targetTablekey)
													.addAttribute("Key", ele.elements().size() + "");
											ele.addAttribute("MaxKey", ele.elements().size() + "");
										}
									} else {
										if (StringUtils.isNotEmpty(maxKey)) {
											ele.addElement(ConstantUtil.SOURCE_FIELD)
													.addAttribute(ConstantUtil.DEFINITION, sourceField)
													.addAttribute(ConstantUtil.TYPE, type)
													.addAttribute(ConstantUtil.TARGET_FIELD_KEY, targetField)
													.addAttribute(ConstantUtil.TARGET_TABLE_KEY, targetTablekey)
													.addAttribute("Key", "field_" + (Integer.valueOf(maxKey) + 1));
											ele.addAttribute("MaxKey", (Integer.valueOf(maxKey) + 1) + "");
										} else {
											ele.addElement(ConstantUtil.SOURCE_FIELD)
													.addAttribute(ConstantUtil.DEFINITION, sourceField)
													.addAttribute(ConstantUtil.TYPE, type)
													.addAttribute(ConstantUtil.TARGET_FIELD_KEY, targetField)
													.addAttribute(ConstantUtil.TARGET_TABLE_KEY, targetTablekey)
													.addAttribute("Key", "field_" + ele.elements().size());
											ele.addAttribute("MaxKey", ele.elements().size() + "");
										}
									}

								}
							} else {
								if (mergeToSource) {
									if (StringUtils.isNotEmpty(maxKey)) {
										ele.addElement(ConstantUtil.SOURCE_FIELD)
												.addAttribute(ConstantUtil.DEFINITION, sourceField)
												.addAttribute(ConstantUtil.TARGET_FIELD_KEY, targetField)
												.addAttribute(ConstantUtil.TARGET_TABLE_KEY, targetTablekey)
												.addAttribute("Key", "merge_" + (Integer.valueOf(maxKey) + 1));
										ele.addAttribute("MaxKey", (Integer.valueOf(maxKey) + 1) + "");
									} else {
										ele.addElement(ConstantUtil.SOURCE_FIELD)
												.addAttribute(ConstantUtil.DEFINITION, sourceField)
												.addAttribute(ConstantUtil.TARGET_FIELD_KEY, targetField)
												.addAttribute(ConstantUtil.TARGET_TABLE_KEY, targetTablekey)
												.addAttribute("Key", "merge_" + ele.elements().size());
										ele.addAttribute("MaxKey", ele.elements().size() + "");
									}
								} else {
									if (!extend) {
										if (StringUtils.isNotEmpty(maxKey)) {
											ele.addElement(ConstantUtil.SOURCE_FIELD)
													.addAttribute(ConstantUtil.DEFINITION, sourceField)
													.addAttribute(ConstantUtil.TARGET_FIELD_KEY, targetField)
													.addAttribute(ConstantUtil.TARGET_TABLE_KEY, targetTablekey)
													.addAttribute("Key", (Integer.valueOf(maxKey) + 1) + "");
											ele.addAttribute("MaxKey", (Integer.valueOf(maxKey) + 1) + "");
										} else {
											ele.addElement(ConstantUtil.SOURCE_FIELD)
													.addAttribute(ConstantUtil.DEFINITION, sourceField)
													.addAttribute(ConstantUtil.TARGET_FIELD_KEY, targetField)
													.addAttribute(ConstantUtil.TARGET_TABLE_KEY, targetTablekey)
													.addAttribute("Key", ele.elements().size() + "");
											ele.addAttribute("MaxKey", ele.elements().size() + "");
										}
									} else {
										if (StringUtils.isNotEmpty(maxKey)) {
											ele.addElement(ConstantUtil.SOURCE_FIELD)
													.addAttribute(ConstantUtil.DEFINITION, sourceField)
													.addAttribute(ConstantUtil.TARGET_FIELD_KEY, targetField)
													.addAttribute(ConstantUtil.TARGET_TABLE_KEY, targetTablekey)
													.addAttribute("Key", "field_" + (Integer.valueOf(maxKey) + 1));
											ele.addAttribute("MaxKey", (Integer.valueOf(maxKey) + 1) + "");
										} else {
											ele.addElement(ConstantUtil.SOURCE_FIELD)
													.addAttribute(ConstantUtil.DEFINITION, sourceField)
													.addAttribute(ConstantUtil.TARGET_FIELD_KEY, targetField)
													.addAttribute(ConstantUtil.TARGET_TABLE_KEY, targetTablekey)
													.addAttribute("Key", "field_" + ele.elements().size());
											ele.addAttribute("MaxKey", ele.elements().size() + "");
										}
									}

								}
							}
						}
						break;
					}
				}
			}
		}
	}

	/**
	 * 判断当前源单字段和目标表字段是否已经存在连接
	 *
	 * @param jsonDataMapVo
	 * @return
	 */
	public ResponseResult<Boolean> isConnected(JsonDataMapVo jsonDataMapVo) throws IOException {
		ResponseResult<Boolean> result = new ResponseResult<>();
		try {
			String filePaths = jsonDataMapVo.getFilePath();
			String temFilePath = XmlFileProcessor.instance.getTmpFile(filePaths);
			if (temFilePath != null) {
				filePaths = temFilePath;
			}
			String sourceFieldKey = jsonDataMapVo.getSourceFieldKey();
			if (sourceFieldKey != null) {
				sourceFieldKey = sourceFieldKey.replaceAll("'", "\"");
			}
			String targetFieldKey = jsonDataMapVo.getTargetFieldKey();
			if (targetFieldKey != null) {
				targetFieldKey = targetFieldKey.replaceAll("'", "\"");
			}
			String key = jsonDataMapVo.getFormKey().split("&&")[0];
			String targetKey = jsonDataMapVo.getFormKey().split("&&")[1];
			if (targetKey.indexOf("__") != -1) {
				targetKey = targetKey.split("__")[0];
			}
			if (key.indexOf("__") != -1) {
				key = key.split("__")[0];
			}
			XmlTreeWithPath xmlTree = XmlTreeWithPath.parseFilePath(filePaths);
			boolean isExist = false;
			if (ConstantUtil.SOURCE_TABLE_COLLECTION.equalsIgnoreCase(jsonDataMapVo.getNodeName())) {
				isExist = handleSTL(sourceFieldKey, targetFieldKey, xmlTree, isExist);
				isExist = publicMethodUtil.isExist(sourceFieldKey, isExist, key, targetKey, targetFieldKey, result);
			} else if (ConstantUtil.TARGET_TABLE_COLLECTION.equalsIgnoreCase(jsonDataMapVo.getNodeName())) {
				List<TagNode> targetField = xmlTree.xmlTree.getRoot().findNodesByTagName(ConstantUtil.TARGET_FIELD);
				for (TagNode element : targetField) {
					if (element.getAttributes().get(ConstantUtil.DEFINITION).equalsIgnoreCase(sourceFieldKey)) {
						List<TagNode> feedback = element.findNodesByTagName("Feedback");
						for (TagNode element1 : feedback) {
							if (element1.getAttributes().get(ConstantUtil.FIELD_KEY).equalsIgnoreCase(targetFieldKey)) {
								break;
							}
						}
					}
				}
				// 判断 类型是否相同
				isExist = publicMethodUtil.isExist(sourceFieldKey, isExist, key, targetKey, targetFieldKey, result);
			}
			result.setCode(0);
			result.setData(isExist);
		} catch (Exception e) {
			logger.warning("判断失败，异常为:" + ExceptionUtils.getStackTrace(e));
			result.setCode(999);
			result.setMsg("判断失败，失败消息为:" + e.getMessage());
		} catch (Throwable throwable) {
			logger.warning(throwable.getMessage());
		}
		return result;
	}


	/**
	 * @param sourceFieldKey
	 * @param targetFieldKey
	 * @param xmlTree
	 * @param isExist
	 * @return 处理源单字段
	 */
	private boolean handleSTL(String sourceFieldKey, String targetFieldKey, XmlTreeWithPath xmlTree, boolean isExist) {
		List<TagNode> sourceField = xmlTree.xmlTree.getRoot().findNodesByTagName(ConstantUtil.SOURCE_FIELD);
		for (TagNode element1 : sourceField) {
			if (element1.getAttributes().get(ConstantUtil.DEFINITION).equalsIgnoreCase(sourceFieldKey) && element1.getAttributes().get(ConstantUtil.TARGET_FIELD_KEY) != null) {
				isExist = element1.getAttributes().get(ConstantUtil.TARGET_FIELD_KEY).equalsIgnoreCase(targetFieldKey);
				break;
			}
		}
		return isExist;
	}

	/**
	 * 获取连线信息
	 *
	 * @param jsonDataMapVo
	 * @return
	 */
	public ResponseResult<JSONArray> ligatureinfo(JsonDataMapVo jsonDataMapVo) {
		ResponseResult<JSONArray> result = new ResponseResult<>();
		JSONArray array = new JSONArray();
		JSONObject nodeJson = new JSONObject();
		try {
			//从临时文件中获取数据sourceTypeKey
			String tempPath = XmlFileProcessor.instance.getTmpFile(jsonDataMapVo.getFilePath());
			//当temppath为空时就去创建一个
			if (StringUtils.isBlank(tempPath)) {
				tempPath = jsonDataMapVo.getFilePath();
			}
			//获取节点
			Element root = DataMapOperJsonUtil.getElement(tempPath);
//			boolean mergeToSource = StringUtils.isNotEmpty(root.attributeValue("MergeToSource"));
			boolean extend = StringUtils.isNotEmpty(root.attributeValue("Extend"));
			String name = root.getQName().getName();
			//数据分割方法
			Map map = carveUp(jsonDataMapVo);
			//获取数据
			String sourceFormKey = ((String) map.get(ConstantUtil.SOURCE_FORM_KEY)).split("__")[0], targetFormKey = ((String) map.get(ConstantUtil.TARGET_FORM_KEY)).split("__")[0], sourceField = (String) map.get("sourceField"), targetField = (String) map.get("targetField"), sourceTableKey = (String) map.get("sourceTableKey"), targetTablekey = (String) map.get("targetTablekey");
			//用于判断连线是源单到目标字段还是目标表单到反填表单
			String operationType = jsonDataMapVo.getOperationType();
			MetaColumn metaColumn = null;
			//获取目标字段的信息
			MetaColumn targetmetaColumn = null;
			//根据标识区分获取
			if (ConstantUtil.MAP.equalsIgnoreCase(name)) {
				MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(sourceFormKey);
				MetaTable table = metaForm.getDataSource().getDataObject().getTable(sourceTableKey);
				IDLookup idLookup = IDLookup.getIDLookup(metaForm);
				//源单字段信息
				metaColumn = getMetaColumn(sourceField, sourceTableKey, table, idLookup);
				MetaForm targetmetaForm = MetaFactory.getGlobalInstance().getMetaForm(targetFormKey);
				MetaTable targettable = targetmetaForm.getDataSource().getDataObject().getTable(targetTablekey);
				IDLookup targetidLookup = IDLookup.getIDLookup(targetmetaForm);
				targetmetaColumn = getMetaColumn(targetField, targetTablekey, targettable, targetidLookup);
			} else if (ConstantUtil.DATA_MIGRATION.equalsIgnoreCase(name)) {
				sourceFormKey = root.attributeValue(ConstantUtil.SRC_DATA_OBJECT_KEY);
				targetFormKey = root.attributeValue(ConstantUtil.TGT_DATA_OBJECT_KEY);
				MetaDataObject dataObject = MetaFactory.getGlobalInstance().getDataObject(targetFormKey);
				MetaTable targettable = dataObject.getTable(targetTablekey);
				targetmetaColumn = targettable.get(targetField);
				int groupType = -1;
				if (targetmetaColumn != null) {
					groupType = targetmetaColumn.getGroupType();
				}
				String fieldCaption = DataMigrationOperJsonUtil.getGroupType(groupType);
				//做为前端区分标识
				nodeJson.put("Migration", "Migration");
				//前端根据不同的类型去渲染不同的面板
				nodeJson.put("GroupType", fieldCaption);
			}
			if (metaColumn != null) {
				nodeJson.put("sourcekey", metaColumn.getKey());
				nodeJson.put("sourceCaption", metaColumn.getCaption());
			}
			if (sourceField != null) {
				sourceField = sourceField.replaceAll("'", "\"");
			}
			if (targetField != null) {
				targetField = targetField.replaceAll("'", "\"");
			}
			if ("false".equalsIgnoreCase(operationType)) {
				if (ConstantUtil.MAP.equalsIgnoreCase(name)) {
					if (root.attributeValue(ConstantUtil.SRC_FORM_KEY).equalsIgnoreCase(sourceFormKey)) {
						List<Element> elements = root.element(ConstantUtil.SOURCE_TABLE_COLLECTION).elements(ConstantUtil.SOURCE_TABLE);
						for (Element ele : elements) {
							String tableKey = getTableKey(ele);
							if (tableKey.equalsIgnoreCase(sourceTableKey)) {
								List<Element> sourceField1 = ele.elements(ConstantUtil.SOURCE_FIELD);
								for (Element eleFiled : sourceField1) {
									String fieldValue = getFieldValue(eleFiled);
									String targetValue = eleFiled.attributeValue(ConstantUtil.TARGET_FIELD_KEY);
									if (StringUtils.isNotEmpty(targetValue)) {
										targetValue = targetValue.replaceAll("'", "\"");
									}
									fieldValue = fieldValue.replaceAll("'", "\"");
									if (fieldValue.equalsIgnoreCase(sourceField) && targetField != null && targetField.equalsIgnoreCase(targetValue)) {
										//当数据为true的时候就说明数据结构是数据迁移的，另作处理
										if (nodeJson.get("Migration") != null) {
											List<String> keys = Arrays.asList("GroupingPolicy", "PeriodValue", "OpSign", "IsNegtive");
											for (String key : keys) {
												String value = eleFiled.attributeValue(key);
												switch (key) {
													case "GroupingPolicy":
													case "PeriodValue":
													case "OpSign":
													case "IsNegtive":
														nodeJson.put(key, value);
														break;
													default:
														break;
												}
											}
										} else {
											String editable = eleFiled.attributeValue("Editable");
											String EdgeType = eleFiled.attributeValue("EdgeType");
											String ConditionField = eleFiled.attributeValue("Condition");
											nodeJson.put("targetkey", eleFiled.attributeValue("TargetFieldKey"));
											nodeJson.put("targetTableKey", eleFiled.attributeValue("TargetTableKey"));
											if (editable != null) {
												nodeJson.put("Editable", editable);
											} else {
												nodeJson.put("Editable", "true");
											}
											if (EdgeType != null) {
												nodeJson.put("EdgeType", EdgeType);
											} else {
												nodeJson.put("EdgeType", "common");
											}
											if (ConditionField != null) {
												nodeJson.put("ConditionField", ConditionField);
											} else {
												nodeJson.put("ConditionField", "");
											}
											String key1 = eleFiled.attributeValue("Key");
											nodeJson.put("sourceTypeKey", key1);
										}
									}
								}
							}
						}
					}
				} else {
					if (root.attributeValue(ConstantUtil.SRC_DATA_OBJECT_KEY).equalsIgnoreCase(sourceFormKey)) {
						List<Element> elements = root.element(ConstantUtil.SOURCE_TABLE_COLLECTION).elements(ConstantUtil.SOURCE_TABLE);
						for (Element ele : elements) {
							String tableKey = getTableKey(ele);
							if (tableKey.equalsIgnoreCase(sourceTableKey)) {
								List<Element> sourceField1 = ele.elements(ConstantUtil.SOURCE_FIELD);
								for (Element eleFiled : sourceField1) {
									String fieldValue = getFieldValue(eleFiled);
									if (fieldValue.equalsIgnoreCase(sourceField) && eleFiled.attributeValue(ConstantUtil.TARGET_FIELD_KEY).equalsIgnoreCase(targetField)) {
										//当数据为true的时候就说明数据结构是数据迁移的，另作处理
										if (nodeJson.get("Migration") != null) {
											List<String> keys = Arrays.asList("GroupingPolicy", "PeriodValue", "OpSign", "IsNegtive", "MapFormula");
											for (String key : keys) {
												String value = eleFiled.attributeValue(key);
												switch (key) {
													case "GroupingPolicy":
													case "PeriodValue":
													case "OpSign":
													case "IsNegtive":
													case "MapFormula":
														nodeJson.put(key, value);
														break;
													default:
														break;
												}
											}
										} else {
											String editable = eleFiled.attributeValue("Editable");
											String EdgeType = eleFiled.attributeValue("EdgeType");
											String ConditionField = eleFiled.attributeValue("Condition");
											if (editable != null) {
												nodeJson.put("Editable", editable);
											} else {
												nodeJson.put("Editable", "true");
											}
											if (EdgeType != null) {
												nodeJson.put("EdgeType", EdgeType);
											} else {
												nodeJson.put("EdgeType", "common");
											}
											if (ConditionField != null) {
												nodeJson.put("ConditionField", ConditionField);
											} else {
												nodeJson.put("ConditionField", "");
											}
										}
									}
								}
							}
						}
					}
				}

				if (targetmetaColumn != null) {
					nodeJson.put("targetkey", targetmetaColumn.getKey());
					nodeJson.put("targetCaption", targetmetaColumn.getCaption());
					nodeJson.put("targetTableKey", targetTablekey);
				}
			} else if ("true".equalsIgnoreCase(operationType)) {
				nodeJson.put("FieldCaption", targetmetaColumn.getCaption());
				if (Objects.isNull(metaColumn)) {
					nodeJson.put("sourceCaption", "");
				} else {
					nodeJson.put("sourceCaption", metaColumn.getCaption());
				}
				Element targetTableCollection = root.element(ConstantUtil.TARGET_TABLE_COLLECTION);
				if (targetTableCollection != null) {
					List<Element> targetTable = targetTableCollection.elements(ConstantUtil.TARGET_TABLE);
					for (Element ele : targetTable) {
						if (ele.attributeValue(ConstantUtil.KEY).equalsIgnoreCase(sourceTableKey)) {
							List<Element> fields = ele.elements(ConstantUtil.TARGET_FIELD);
							for (Element field : fields) {
								if (field.attributeValue(ConstantUtil.DEFINITION).equalsIgnoreCase(sourceField)) {
									List<Element> feedback = field.elements("Feedback");
									//获取信息
									loadInfo(nodeJson, targetField, feedback);
								}
							}
						}
					}
				}

			}
			if (!extend) {
				nodeJson.put("sourceTypeKey", "canNot");
			}
			array.add(nodeJson);
			result.setCode(0);
			result.setData(array);
		} catch (Exception e) {
			logger.warning("获取连线信息失败，异常为:" + ExceptionUtils.getStackTrace(e));
			result.setCode(999);
			result.setMsg("获取连线信息失败，失败消息为:" + e.getMessage());
		} catch (Throwable throwable) {
			logger.warning(throwable.getMessage());
		}
		return result;
	}

	//获取信息
	private void loadInfo(JSONObject nodeJson, String targetField, List<Element> feedback) {
		for (Element feed : feedback) {
			if (feed.attributeValue(ConstantUtil.FIELD_KEY).equalsIgnoreCase(targetField)) {
				if (StringUtils.isBlank(feed.attributeValue("OpSign"))) {
					nodeJson.put("OpSign", "");
				} else {
					nodeJson.put("OpSign", feed.attributeValue("OpSign"));
				}
				Element postTrigger = feed.element("PostTrigger");
				if (Objects.isNull(postTrigger)) {
					nodeJson.put("PostTrigger", "");
				} else {
					List<Node> content = postTrigger.content();
					String text = getCDATA(content);
					nodeJson.put("PostTrigger", text);
				}
				Element postFormulaTrigger = feed.element("PostFormulaTrigger");
				if (Objects.isNull(postFormulaTrigger)) {
					nodeJson.put("PostFormulaTrigger", "");
				} else {
					List<Node> content = postFormulaTrigger.content();
					//获取cdata节点信息
					String text = getCDATA(content);
					nodeJson.put("PostFormulaTrigger", text);
				}
				if (StringUtils.isBlank(feed.attributeValue("Condition"))) {
					nodeJson.put("Condition", "");
				} else {
					nodeJson.put("Condition", feed.attributeValue("Condition"));
				}
			}
		}
	}

	/**
	 * @param content
	 * @return 获取cdata节点信息
	 */
	private String getCDATA(List<Node> content) {
		String text = "";
		for (Node con : content) {
			if (con instanceof DefaultCDATA) {
				text = con.getText();
			}
		}
		return text;
	}

	/***
	 * 获取所有表单
	 * @return 结果对象
	 * @param jsonDataMapVo
	 */
	public ResponseResult<JSONArray> getAllFormkey(JsonDataMapVo jsonDataMapVo) {
		ResponseResult<JSONArray> result = new ResponseResult<>();
		JSONArray array = new JSONArray();
		try {
			MetaFormList metaForm = MetaFactory.getGlobalInstance().getMetaFormList();
			JSONObject placeholder = new JSONObject();
			placeholder.put("id", "placeholder");
			placeholder.put("text", "  ");
			array.add(placeholder);
			metaForm.forEach(formKey -> {
				JSONObject json = new JSONObject();
				if (formKey.getFormType() != FormType.View) {
					json.put("id", formKey.getKey() + "  " + formKey.getCaption());
					json.put("text", formKey.getKey() + "  " + formKey.getCaption());
					array.add(json);
				}
			});
			result.setCode(0);
			result.setMsg("获取所有表单成功");
			result.setData(array);
		} catch (Throwable e) {
			logger.warning("获取所有表单异常，异常为:" + ExceptionUtils.getStackTrace(e));
			result.setCode(999);
			result.setMsg("获取所有表单失败，失败消息为:" + e.getMessage());
		}
		return result;
	}
	/***
	 * 更新面板的坐标
	 * @return 结果反馈
	 * @param jsonDataMapVo
	 */
	public ResponseResult<JSONArray> coordinateData(JsonDataMapVo jsonDataMapVo) {
		ResponseResult<JSONArray> result = new ResponseResult<>();
		JSONArray array = new JSONArray();
		try {
			String filePaths = jsonDataMapVo.getFilePath();
			String tempPath = XmlFileProcessor.instance.getTmpFile(filePaths);
			if (StringUtils.isBlank(tempPath)) {
				tempPath = filePaths;
			}
			//获取节点
			Element root = DataMapOperJsonUtil.getElement(tempPath);
			String formKey = jsonDataMapVo.getFormKey();
			String nodeName = jsonDataMapVo.getNodeName();
			switch (nodeName) {
				case ConstantUtil.SOURCE_TABLE_COLLECTION:
					Element sourceTableCollection = root.element(nodeName);
					JSONObject sourceJson = new JSONObject();
					sourceJson.put(ConstantUtil.HEIGHT, sourceTableCollection.attributeValue(ConstantUtil.HEIGHT));
					sourceJson.put("Width", sourceTableCollection.attributeValue("Width"));
					sourceJson.put(ConstantUtil.X, sourceTableCollection.attributeValue(ConstantUtil.X));
					sourceJson.put(ConstantUtil.Y, sourceTableCollection.attributeValue(ConstantUtil.Y));
					array.add(sourceJson);
					break;
				case ConstantUtil.TARGET_TABLE_COLLECTION:
					Element targetTableCollection = root.element(nodeName);
					JSONObject targetJson = new JSONObject();
					targetJson.put(ConstantUtil.HEIGHT, targetTableCollection.attributeValue(ConstantUtil.HEIGHT));
					targetJson.put("Width", targetTableCollection.attributeValue("Width"));
					targetJson.put(ConstantUtil.X, targetTableCollection.attributeValue(ConstantUtil.X));
					targetJson.put(ConstantUtil.Y, targetTableCollection.attributeValue(ConstantUtil.Y));
					array.add(targetJson);
					break;
				case ConstantUtil.FEEDBACK_COLLECTION:
					List<Element> feedbackObject = root.element(nodeName).elements(ConstantUtil.FEEDBACK_OBJECT);
					for (Element ele : feedbackObject) {
						if (ele.attributeValue(ConstantUtil.FORM_KEY).equalsIgnoreCase(formKey)) {
							JSONObject jsonObject = new JSONObject();
							jsonObject.put(ConstantUtil.X, ele.attributeValue(ConstantUtil.X));
							jsonObject.put(ConstantUtil.Y, ele.attributeValue(ConstantUtil.Y));
							array.add(jsonObject);
						}
					}
					break;
				default:
					break;
			}
			result.setCode(0);
			result.setMsg("获取坐标成功");
			result.setData(array);
		} catch (Throwable e) {
			logger.warning("获取坐标异常，异常为:" + ExceptionUtils.getStackTrace(e));
			result.setCode(999);
			result.setMsg("获取坐标失败，失败消息为:" + e.getMessage());
		}
		return result;
	}

	/***
	 * 当前端删除连线的时候需要处理XML
	 * @return 结果反馈
	 * @param jsonDataMapVo
	 */
	public ResponseResult<JSONArray> updateLigatureXML(JsonDataMapVo jsonDataMapVo) throws IOException {
		ResponseResult<JSONArray> result = new ResponseResult<>();
		FileOutputStream fileOutputStream = null;
		XMLWriter writer = null;
		String tempPath = "";
		try {
			//获取路径
			String filePaths = jsonDataMapVo.getFilePath();
			tempPath = XmlFileProcessor.instance.getTmpFile(filePaths);
			if (StringUtils.isBlank(tempPath)) {
				tempPath = filePaths;
			}
			// 创建SAX读取器
			SAXReader reader = new SAXReader();
			// 加载文档
			Document document = reader.read(new File(tempPath));
			// 获取根节点
			Element root = document.getRootElement();
			//数据分割方法
			Map map = carveUp(jsonDataMapVo);
			//获取数据
			String sourceField = (String) map.get("sourceField"), targetField = (String) map.get("targetField"), sourceTableKey = (String) map.get("sourceTableKey");
			if (sourceField != null) {
				sourceField = sourceField.replaceAll("'", "\"");
			}
			if (targetField != null) {
				targetField = targetField.replaceAll("'", "\"");
			}
			String nodeName = jsonDataMapVo.getNodeName();
			//根据情况去添加节点
			String tableNode = "", filedNode = "";
			if (ConstantUtil.SOURCE_TABLE_COLLECTION.equalsIgnoreCase(nodeName)) {
				tableNode = ConstantUtil.SOURCE_TABLE;
				filedNode = ConstantUtil.SOURCE_FIELD;
			} else if (ConstantUtil.TARGET_TABLE_COLLECTION.equalsIgnoreCase(nodeName)) {
				tableNode = ConstantUtil.TARGET_TABLE;
				filedNode = ConstantUtil.TARGET_FIELD;
			}
			switch (nodeName) {
				case ConstantUtil.SOURCE_TABLE_COLLECTION:
				case ConstantUtil.TARGET_TABLE_COLLECTION:
					List<Element> table = root.element(nodeName).elements(tableNode);
					for (Element ele : table) {
						String tableKey = getTableKey(ele);
						if (tableKey.equalsIgnoreCase(sourceTableKey)) {
							List<Element> Field = ele.elements(filedNode);
							Boolean haveRepeat = false;
							Element node = null;
							for (Element field : Field) {
								if (ConstantUtil.SOURCE_TABLE_COLLECTION.equalsIgnoreCase(nodeName)) {
									if (field.attributeValue(ConstantUtil.DEFINITION).equalsIgnoreCase(sourceField) && field.attributeValue(ConstantUtil.TARGET_FIELD_KEY) != null
											&& !field.attributeValue(ConstantUtil.TARGET_FIELD_KEY).equalsIgnoreCase(targetField)) {
										haveRepeat = true;
									}
									if (field.attributeValue(ConstantUtil.DEFINITION).equalsIgnoreCase(sourceField) && field.attributeValue(ConstantUtil.TARGET_FIELD_KEY) != null
											&& field.attributeValue(ConstantUtil.TARGET_FIELD_KEY).equalsIgnoreCase(targetField)) {
										List<Attribute> attributes = field.attributes();
										String type = null;
										//获取type
										for (Attribute attribute : attributes) {
											if (ConstantUtil.TYPE.equalsIgnoreCase(attribute.getQName().getName())) {
												type = attribute.getValue();
											}
										}
										if (haveRepeat) {
											node = field;
										} else {
											String key = field.attributeValue(ConstantUtil.KEY);
											attributes.clear();
											if (type != null && !"".equalsIgnoreCase(type)) {
												field.addAttribute(ConstantUtil.DEFINITION, sourceField).addAttribute(ConstantUtil.TYPE, type).addAttribute(ConstantUtil.KEY, key);
											} else {
												field.addAttribute(ConstantUtil.DEFINITION, sourceField).addAttribute(ConstantUtil.KEY, key);
											}
										}
									}
								} else if (ConstantUtil.TARGET_TABLE_COLLECTION.equalsIgnoreCase(nodeName)) {
									//目标表单到反填表单
									updateTargetLigatureXML(sourceField, targetField, field);
								}
							}
							if (haveRepeat) {
								Field.remove(node);
							}
						}
					}
					break;
				default:
					break;
			}
			OutputFormat format = getOutputFormat();
			String solutionPath = FilePathHelper.getWorkspacePath() + File.separator;
			String newFilePath = Paths.get(WebDesignerConfiguration.getDesignerDataPath(), "tmp", filePaths.substring(solutionPath.length()).replace(File.separator, "__") + "." + System.currentTimeMillis()).toString();
			fileOutputStream = new FileOutputStream(newFilePath);
			writer = new XMLWriter(fileOutputStream, format);
			writer.write(document);
			XmlFileProcessor.stackput(filePaths, newFilePath);
			result.setCode(0);
			result.setMsg("success");

		} catch (Exception e) {
			logger.warning("failure，异常为:" + ExceptionUtils.getStackTrace(e));
			result.setCode(999);
			result.setMsg("failure，失败消息为:" + e.getMessage());
		} catch (Throwable throwable) {
			logger.warning(throwable.getMessage());
		} finally {
			closeFileStream(fileOutputStream, writer);
		}
		return result;
	}

	/***
	 *删除反填表单  然后进行后台的XMl进行处理操作
	 * @return 结果反馈
	 * @param jsonDataMapVo
	 */
	public ResponseResult<JSONArray> handleDeleteXML(JsonDataMapVo jsonDataMapVo) throws Throwable {
		ResponseResult<JSONArray> result = new ResponseResult<>();
		FileOutputStream fileOutputStream = null;
		XMLWriter writer = null;
		String tempPath = "", filePaths = "";
		try {
			//获取路径
			filePaths = jsonDataMapVo.getFilePath();
			tempPath = XmlFileProcessor.instance.getTmpFile(filePaths);
			if (StringUtils.isBlank(tempPath)) {
				tempPath = filePaths;
			}
			// 创建SAX读取器
			SAXReader reader = new SAXReader();
			// 加载文档
			Document document = reader.read(new File(tempPath));
			// 获取当前的树节点
			Element element = document.getRootElement();
			String formKey = jsonDataMapVo.getFormKey().split("__Feed")[0];
			Element mapFeedbackObjectNode = getMapFeedbackObjectNode(document, formKey);
			List<Node> feedbackTableNodeList = mapFeedbackObjectNode.selectNodes("FeedbackTable");
			for (Node feedbackTableNode : feedbackTableNodeList) {
				String tableKey = ((Element) feedbackTableNode).attributeValue("TableKey");
				List<Node> feedbackFieldNodeList = feedbackTableNode.selectNodes("FeedbackField");
				for (Node feedbackFieldNode : feedbackFieldNodeList) {
					String fieldKey = ((Element) feedbackFieldNode).attributeValue("FieldKey");
					deleteField(fieldKey, tableKey, document);
				}
			}
			List<Element> feedbackObject = element.element(ConstantUtil.FEEDBACK_COLLECTION).elements(ConstantUtil.FEEDBACK_OBJECT);
			// 删除这条数据
			Iterator<Element> iterator = feedbackObject.iterator();
			if (feedbackObject.size() <= 1) {
				element.remove(element.element(ConstantUtil.FEEDBACK_COLLECTION));
			} else {
				while (iterator.hasNext()) {
					Element next = iterator.next();

					if (next.attributeValue(ConstantUtil.FORM_KEY).equalsIgnoreCase(formKey)) {
						iterator.remove();
					}
				}
			}

			OutputFormat format = getOutputFormat();
			String solutionPath = FilePathHelper.getWorkspacePath() + File.separator;
			String newFilePath = Paths.get(WebDesignerConfiguration.getDesignerDataPath(), "tmp", filePaths.substring(solutionPath.length()).replace(File.separator, "__") + "." + System.currentTimeMillis()).toString();
			fileOutputStream = new FileOutputStream(newFilePath);
			writer = new XMLWriter(fileOutputStream, format);
			writer.write(document);
			XmlFileProcessor.stackput(filePaths, newFilePath);
			result.setCode(0);
			result.setMsg("success");

		} catch (Exception e) {
			logger.warning("删除异常，异常为:" + ExceptionUtils.getStackTrace(e));
			result.setCode(999);
			result.setMsg("删除异常，失败消息为:" + e.getMessage());
		} catch (Throwable throwable) {
			logger.warning(throwable.getMessage());
		} finally {
			setData(result, filePaths);
			closeFileStream(fileOutputStream, writer);
		}
		return result;
	}

	/**
	 * @param sourceField
	 * @param targetField
	 * @param field       更新目标表单到反填表单XML
	 */
	public void updateTargetLigatureXML(String sourceField, String targetField, Element field) {
		if (field.attributeValue(ConstantUtil.DEFINITION).equalsIgnoreCase(sourceField)) {
			List<Element> feedback = field.elements("Feedback");
			for (Element feed : feedback) {
				if (feed.attributeValue(ConstantUtil.FIELD_KEY).equalsIgnoreCase(targetField)) {
					field.remove(feed);
				}
			}
		}
	}

	/***
	 * 用于替换XML
	 * 数据迁移和数据映射共用保存方法
	 * @return 结果反馈
	 * @param
	 */
	public ResponseResult<List<JSONObject>> SaveHtml(String filePaths) throws Throwable {
//		ResponseResult<JSONArray> result1 = new ResponseResult<>();
		ResponseResult<List<JSONObject>> result = new ResponseResult<>();
		try {
			File file = new File(filePaths);
			String tmpFile = XmlFileProcessor.instance.getTmpFile(filePaths);
			if (StringUtils.isBlank(tmpFile)) {
				tmpFile = filePaths;
			}
			String newContent = FileUtils.readFileToString(new File(tmpFile), "UTF-8");
			//重新写入文件夹
			FileUtils.writeStringToFile(file, newContent, "UTF-8");
			result.setCode(0);
			result.setMsg("保存成功");
			XmlFileProcessor.instance.clearTmpFile(filePaths);
			//处理
			String fileContent = FileUtils.readFileToString(new File(filePaths), "UTF-8");
			XmlTree parse = XmlParser.parse(fileContent);
			//只有数据映射才需要添加六个默认字段
			TagNode root = parse.getRoot();
			if (ConstantUtil.MAP.equalsIgnoreCase(root.getTagName())) {
				List<TagNode> targetTable = root.findNodesByTagName(ConstantUtil.TARGET_TABLE);
				List<TagNode> sourceTable = root.findNodesByTagName(ConstantUtil.SOURCE_TABLE);
				IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
				String srcFormKey = root.getAttributes().get(ConstantUtil.SRC_FORM_KEY);//原表单key
				String tgtFormKey = root.getAttributes().get(ConstantUtil.TGT_FORM_KEY);//目标表单key
				//获取所有的表单
				MetaFormList metaFormList = metaFactory.getMetaFormList();
				//获取所有数据对象表单
				MetaDataObjectList dataObjectList = metaFactory.getDataObjectList();
				// 源单
				MetaFormProfile metaFormProfile = metaFormList.get(srcFormKey);
				MetaFormProfile formProfile = metaFormList.get(tgtFormKey);
				// 目标表单
				String srcObjectKey = root.getAttributes().get(ConstantUtil.SRC_DATA_OBJECT_KEY);//原表单key
				String tgtObjectKey = root.getAttributes().get(ConstantUtil.TGT_DATA_OBJECT_KEY);//目标表单key
				String extend = root.getAttributes().get(ConstantUtil.EXTEND);//目标表单key

				MetaDataObjectProfile dataObjectProfile = dataObjectList.get(srcObjectKey);
				MetaDataObjectProfile metaDataObjectProfile = dataObjectList.get(tgtObjectKey);
				String targetTableKey = null;//目标表数据源映射主表Key
				String sourceTableKey = null;//源表数据源映射主表Key
				for (TagNode tagNode : targetTable) {
					String isPrimary = tagNode.getAttributes().get("IsPrimary");
					// 只有当前表单设置主表的时候才会去创建默认字段
					if (isPrimary != null && !"false".equalsIgnoreCase(isPrimary)) {
						targetTableKey = tagNode.getAttributes().get(ConstantUtil.KEY);
					}
				}
				for (TagNode tagNode : sourceTable) {
					String isPrimary = tagNode.getAttributes().get("IsPrimary");
					if (isPrimary != null && !"false".equalsIgnoreCase(isPrimary)) {
						sourceTableKey = tagNode.getAttributes().get(ConstantUtil.DATA_MIGRATION.equalsIgnoreCase(root.getTagName()) ? ConstantUtil.TABLE_KEY : ConstantUtil.DATA_SOURCE);
					}
				}
				List<JSONObject> jsonObjects = new ArrayList<>();
				String pullDataOnly = root.getAttributes().get("PullDataOnly");

				if (("false".equalsIgnoreCase(pullDataOnly) || StringUtils.isEmpty(pullDataOnly)) && StringUtils.isEmpty(extend)) {//非仅推动数据
					//源单表会分为 普通表单和数据对象表单
					if (sourceTableKey != null && metaFormProfile != null && "".equalsIgnoreCase(metaFactory.getMetaForm(srcFormKey).getDataSource().getRefObjectKey())) { //不为空这里就是引用了数据对象表单
						MetaForm srcMetaForm = metaFormProfile.getForm();
						setsourcefiled(jsonObjects, srcMetaForm, null, srcFormKey, sourceTableKey, targetTableKey);
					} else if (sourceTableKey != null && dataObjectProfile != null) {
						MetaDataObject dataObject = dataObjectProfile.getDataObject();
						setsourcefiled(jsonObjects, null, dataObject, srcFormKey, sourceTableKey, targetTableKey);
					}
					// 目标表单会分为数据对象表单和普通表单
					if (targetTableKey != null && formProfile != null && "".equalsIgnoreCase(formProfile.getForm().getDataSource().getRefObjectKey())) {//不为空这里就是引用了数据对象表单
						MetaForm tgtMetaForm = formProfile.getForm();
						setargetfiled(jsonObjects, tgtMetaForm, null, tgtFormKey, targetTableKey, sourceTableKey);

					} else if (targetTableKey != null && formProfile != null && metaDataObjectProfile != null) {
						MetaDataObject dataObject = metaDataObjectProfile.getDataObject();
						setargetfiled(jsonObjects, formProfile.getForm(), dataObject, tgtFormKey, targetTableKey,
								sourceTableKey);
					}
				}
				result.setData(jsonObjects);
				//重新加载数据映射
				String projectKey = LoadFileTree.getProjectKey(filePaths);
				ReloadForm.reloadCustom(projectKey, LoadFileTree.getKeyByFilePath(filePaths));
			} else {//重新加载数据迁移
				IMetaFactory iMetaFactory = MetaFactory.getGlobalInstance();
				String key = LoadFileTree.getKeyByFilePath(filePaths);
				MetaDataMigrationProfile metaDataMigrationProfile = iMetaFactory.getDataMigrationList().get(key);
				String resource = LoadFileTree.getResource(filePaths,metaDataMigrationProfile.getProject().getKey());
				/*
				List<JSONObject> jsonObjects = new ArrayList<>();
				String tgtObjectKey = root.getAttributes().get(ConstantUtil.TGT_DATA_OBJECT_KEY);//目标表单key
				MetaDataObjectList dataObjectList = iMetaFactory.getDataObjectList();
				MetaDataObject dataObject = dataObjectList.get(tgtObjectKey).getDataObject();
				String dataObjectKey = dataObject.getKey();
				String path = LoadFileTree.loadFilePathByDataObjectFieldKey(dataObjectKey);
				JSONObject jsonObject = new JSONObject();
				jsonObject.put("filePath", path);
				jsonObject.put("key", dataObjectKey);
				jsonObject.put("type", ConstantUtil.DATA_OBJECT);
                jsonObjects.add(jsonObject);
				result.setData(jsonObjects);
                DataObjectHelper.reload(dataObjectKey,path,null);
				*/
                ReloadForm.reloadDataMigrationKey(iMetaFactory, key, resource);
			}
		} catch (Throwable e) {
			throw new Throwable("保存出现异常，失败消息为:" + e.getMessage());

		}
		return result;
	}

	/**
	 * 新建数据映射或者数据迁移保存之后源单生成默认字段
	 */
	private void setsourcefiled(List<JSONObject> jsonObjects, MetaForm metaForm, MetaDataObject dataObject, String srcFormKey, String mainTableKey, String targetTableKey) throws Throwable {//主表字段添加
		//在此处新增字段
		String path = null;
		if (dataObject != null) {//引入数据对象表单
			String key = dataObject.getKey();
			path = LoadFileTree.loadFilePathByDataObjectFieldKey(key);
			JSONObject jsonObject = new JSONObject();
			jsonObject.put("filePath", path);
			jsonObject.put("key", key);
			jsonObject.put("type", ConstantUtil.DATA_OBJECT);
			jsonObjects.add(jsonObject);
		} else if (metaForm != null) {
			path = LoadFileTree.getPathByFormKey(srcFormKey);
			JSONObject jsonObject = new JSONObject();
			jsonObject.put("filePath", path);
			jsonObject.put("key", srcFormKey);
			jsonObject.put("type", "Form");
			jsonObjects.add(jsonObject);
		}
		// 创建SAX读取器
		SAXReader reader = new SAXReader();
		// 加载文档
		Document document = reader.read(new File(path));
		// 获取根节点
		Element element = document.getRootElement();
		//做一个检测，防止重复添加
		boolean checkColumn = false;
		XmlTreeWithPath xmlTree = null;
		if (dataObject != null) {//数据对象表单
			String filePath = LoadFileTree.loadFilePathByDataObjectFieldKey(dataObject.getKey());
			xmlTree = XmlTreeWithPath.parseFilePath(filePath);
		} else if (metaForm != null) {
			String filePath = LoadFileTree.getPathByFormKey(metaForm.getKey());
			xmlTree = XmlTreeWithPath.parseFilePath(filePath);
		}
		List<TagNode> table = xmlTree.xmlTree.getRoot().findNodesByTagName("Table");
		for (TagNode tag : table) {
			if (tag.getAttributes().get(ConstantUtil.KEY).equalsIgnoreCase(mainTableKey)) {
				// 六个默认字段  要么同时存在 要么同时不存在
				String strings = "MapCount";
				//去判断主表中是否已经存在流程标识
				List<TagNode> column = tag.findNodesByTagName("Column");
				for (TagNode tagNode : column) {
					String key = tagNode.getAttributes().get(ConstantUtil.KEY);
					if (strings.equalsIgnoreCase(key)) {
						checkColumn = true;
						break;
					}
				}
			}
		}
		//当不存在时候再进行添加
		if (!checkColumn && !mainTableKey.isEmpty()) {//添加数据源  当目标表也有主表的情况下才进行添加
			//找到数据源tableNode
			List<Element> tableNode = findTableNode(element);
			//向数据源中添加一个MapCount字段
			for (Element ele : tableNode) {
				if (ele.attributeValue(ConstantUtil.KEY).equalsIgnoreCase(mainTableKey)) {
					ele.addElement("Column").addAttribute(ConstantUtil.KEY, "MapCount").addAttribute(ConstantUtil.CAPTION, "MapCount").addAttribute("DataType", "Integer");
				}
			}
			// 格式化输出流，同时指定编码格式。也可以在FileOutputStream中指定。
			OutputFormat format = getOutputFormat();
			FileOutputStream fileOutputStream = new FileOutputStream(path);
			XMLWriter writer = new XMLWriter(fileOutputStream, format);
			writer.write(document);
			//添加完roaloadform
			if (dataObject != null) {//引入数据对象表单
				String key = dataObject.getKey();
				String resource1 = LoadFileTree.getPathByDataObject(key);
				DataObjectHelper.reload(null,key, resource1, null);
			} else {
				DesignReloadMetaObject.reloadMetaFormRollbackError(null,srcFormKey);
			}
		}

	}

	/**
	 * 当新建的数据迁移进行保存的时候生成默认的六个字段
	 */
	private void setargetfiled(List<JSONObject> jsonObjects, MetaForm metaForm, MetaDataObject dataObject, String tgtFormKey, String mainTableKey, String sourceTableKey) throws Throwable {//目标表字段添加
		//在此处新增字段
		String path = null;
		String dataObjectPath = null;
		String formPath = null;
		if (dataObject != null) {//引入数据对象表单
			String key = dataObject.getKey();
			path = LoadFileTree.loadFilePathByDataObjectFieldKey(key);
			dataObjectPath = path;
			formPath = LoadFileTree.getPathByFormKey(metaForm.getKey());

			JSONObject jsonObject = new JSONObject();
			jsonObject.put("filePath", path);
			jsonObject.put("key", key);
			jsonObject.put("type", ConstantUtil.DATA_OBJECT);
			jsonObjects.add(jsonObject);
		} else if (metaForm != null) {
			path = LoadFileTree.getPathByFormKey(tgtFormKey);
			formPath = path;
			JSONObject jsonObject = new JSONObject();
			jsonObject.put("filePath", path);
			jsonObject.put("key", tgtFormKey);
			jsonObject.put("type", "Form");
			jsonObjects.add(jsonObject);
		}

		// 创建SAX读取器
		SAXReader reader = new SAXReader();
		// 加载文档
		Document document = reader.read(new File(path));
		// 获取根节点
		Element element = document.getRootElement();
		//做一个检测，防止重复添加
		boolean checkColumn = checkColumn(metaForm, dataObject, mainTableKey);
		//当不存在时候再进行添加
		if (!checkColumn && sourceTableKey != null) {//添加数据源  当源单和目标表单同时设有主表的情况下才进行添加
			//找到数据源tableNode
			List<Element> tableNode = findTableNode(element);
			//向数据源中添加一个流程标识字段
			for (Element ele : tableNode) {
				if (ele.attributeValue(ConstantUtil.KEY).equalsIgnoreCase(mainTableKey)) {
					List<String> longs = Arrays.asList("SrcOID", "SrcSOID", "SrcSequence");
					for (String keyAndCaption : longs) {
						ele.addElement("Column").addAttribute(ConstantUtil.KEY, keyAndCaption).addAttribute(ConstantUtil.CAPTION, keyAndCaption).addAttribute("DataType", "Long");
					}
					List<String> strings = Arrays.asList("MapKey", "SrcDocumentNumber", DataConstant.STR_FLD_SRCFORMKEY);
					for (String keyAndCaption : strings) {
						ele.addElement("Column").addAttribute(ConstantUtil.KEY, keyAndCaption).addAttribute(ConstantUtil.CAPTION, keyAndCaption).addAttribute("DataType", "Varchar");
					}
				}
			}
			//添加组件   当主表设置的是表格的时候添加几个默认组件

			if (dataObject != null) {//数据对象表单
				//数据对象
				// 格式化输出流，同时指定编码格式。也可以在FileOutputStream中指定。
				OutputFormat format = getOutputFormat();
				FileOutputStream fileOutputStream = new FileOutputStream(path);
				XMLWriter writer = new XMLWriter(fileOutputStream, format);
				writer.write(document);

				//表单
				Document formDocument = reader.read(new File(formPath));
				element = formDocument.getRootElement();
				String cellKey = getGridCellKey(metaForm, mainTableKey);
				if (cellKey != null) {
					String columnKey = getGridColumnKey(metaForm, cellKey);
					boolean checkGridColumn = checkGridColumn(metaForm, mainTableKey);
					boolean checkGridCell = checkGridCell(metaForm, mainTableKey);
					if (columnKey != null && columnKey.equalsIgnoreCase(cellKey)) {//添加组件
						List<Element> elements = element.element("Body").element("Block").element("FlexFlowLayoutPanel").elements(ConstantUtil.SPLIT_PANEL);
						if (!checkGridColumn) {
							findcheckGridColumnNode(elements, cellKey);
						}
						if (!checkGridCell) {
							findcheckGridCellNode(elements, cellKey);
						}
					}
				}
				FileOutputStream fileOutputStream1 = new FileOutputStream(formPath);
				XMLWriter writer1 = new XMLWriter(fileOutputStream1, format);
				writer1.write(formDocument);

			} else {
				String cellKey = getGridCellKey(metaForm, mainTableKey);
				if (cellKey != null) {
					String columnKey = getGridColumnKey(metaForm, cellKey);
					boolean checkGridColumn = checkGridColumn(metaForm, mainTableKey);
					boolean checkGridCell = checkGridCell(metaForm, mainTableKey);
					if (columnKey != null && columnKey.equalsIgnoreCase(cellKey)) {//添加组件
						List<Element> elements = element.element("Body").element("Block").element("FlexFlowLayoutPanel").elements(ConstantUtil.SPLIT_PANEL);
						if (!checkGridColumn) {
							findcheckGridColumnNode(elements, cellKey);
						}
						if (!checkGridCell) {
							findcheckGridCellNode(elements, cellKey);
						}
					}
				}
				// 格式化输出流，同时指定编码格式。也可以在FileOutputStream中指定。
				OutputFormat format = getOutputFormat();
				FileOutputStream fileOutputStream = new FileOutputStream(path);
				XMLWriter writer = new XMLWriter(fileOutputStream, format);
				writer.write(document);
			}


			//添加完roaloadform
			if (dataObject != null) {//引入数据对象表单
				String resource = LoadFileTree.getPathByDataObject(dataObject.getKey());
				DataObjectHelper.reload(null,dataObject.getKey(), resource, null);
			} else {
				String metaFormKey = metaForm.getKey();
				DesignReloadMetaObject.reloadMetaFormRollbackError(null,metaFormKey);
			}

		}
	}
	/**
	 * @param element
	 * @return 从表单中获取TableNode节点
	 */
	private List<Element> findTableNode(Element element) {
		//区分数据对象表单和普通表单
		List<Element> elements = ConstantUtil.DATA_OBJECT.equalsIgnoreCase(element.getQName().getName()) ? element.element("TableCollection").elements("Table") : element.element(ConstantUtil.DATA_SOURCE).element(ConstantUtil.DATA_OBJECT).element("TableCollection").elements("Table");
		return elements;
	}

	/**
	 * @param elements
	 * @return 从表单中获取checkGridColumn节点
	 */

	private void findcheckGridColumnNode(List<Element> elements, String keyss) {
		for (Element element1 : elements) {
			if (keyss.equalsIgnoreCase(element1.attributeValue(ConstantUtil.KEY))) {
				List<String> strings = Arrays.asList("SrcOID", "SrcSOID", "SrcSequence", "MapKey", "SrcDocumentNumber", DataConstant.STR_FLD_SRCFORMKEY);
				Element elementGridColumn = element1.element("GridColumnCollection");
				//当迁移进行保存的时候创建六个默认字段
				for (String keyAndCaption : strings) {
					elementGridColumn.addElement("GridColumn").addAttribute(ConstantUtil.KEY, keyAndCaption).addAttribute(ConstantUtil.CAPTION, keyAndCaption).addAttribute("Width", "80px").addAttribute(ConstantUtil.VISIBLE, "DebugMode()");
				}
				break;
			} else {
				elements = element1.elements();
				if (elements.size() > 0) {
					findcheckGridColumnNode(elements, keyss);
				} else {
					continue;
				}
			}
		}

	}


	/**
	 * @param elements
	 * @return 从表单中获取checkGridCell节点
	 */
	private void findcheckGridCellNode(List<Element> elements, String keyss) {
		for (Element element1 : elements) {
			if (keyss.equalsIgnoreCase(element1.attributeValue(ConstantUtil.KEY))) {
				List<String> strings = Arrays.asList("SrcOID", "SrcSOID", "SrcSequence", "MapKey", "SrcDocumentNumber", DataConstant.STR_FLD_SRCFORMKEY);
				Element elementGridCell = element1.element("GridRowCollection").element("GridRow");
				for (String keyAndCaption : strings) {
					switch (keyAndCaption) {
						case "SrcOID":
						case "SrcSOID":
						case "SrcSequence":
							elementGridCell.addElement("GridCell").addAttribute(ConstantUtil.KEY, keyAndCaption).addAttribute(ConstantUtil.CAPTION, keyAndCaption).addAttribute("CellType", "NumberEditor").addAttribute(ConstantUtil.ENABLE, "false").addElement(MetaDataBinding.TAG_NAME).addAttribute(ConstantUtil.COLUMN_KEY, keyAndCaption);
							break;
						case "MapKey":
						case "SrcDocumentNumber":
						case DataConstant.STR_FLD_SRCFORMKEY:
							elementGridCell.addElement("GridCell").addAttribute(ConstantUtil.KEY, keyAndCaption).addAttribute(ConstantUtil.CAPTION, keyAndCaption).addAttribute("CellType", "TextEditor").addAttribute(ConstantUtil.ENABLE, "false").addElement(MetaDataBinding.TAG_NAME).addAttribute(ConstantUtil.COLUMN_KEY, keyAndCaption);
							break;
						default:
							break;
					}
				}
			} else {
				elements = element1.elements();
				if (elements.size() > 0) {
					findcheckGridCellNode(elements, keyss);
				} else {
					continue;
				}
			}
		}
	}

	/**
	 * @param metaForm
	 * @param mainTableKey
	 * @return 检查主表中是否已经映射字段，有的话就不再进行添加
	 * @throws Throwable
	 */
	private boolean checkColumn(MetaForm metaForm, MetaDataObject dataObject, String mainTableKey) throws Throwable {
		boolean ishas = false;
		XmlTreeWithPath xmlTree = null;
		if (dataObject != null) {//数据对象表单
			String filePath = LoadFileTree.loadFilePathByDataObjectFieldKey(dataObject.getKey());
			xmlTree = XmlTreeWithPath.parseFilePath(filePath);
		} else if (metaForm != null) {
			String filePath = LoadFileTree.getPathByFormKey(metaForm.getKey());
			xmlTree = XmlTreeWithPath.parseFilePath(filePath);
		}
		if (xmlTree != null) {
			List<TagNode> table = xmlTree.xmlTree.getRoot().findNodesByTagName("Table");
			for (TagNode tag : table) {
				if (tag.getAttributes().get(ConstantUtil.KEY).equalsIgnoreCase(mainTableKey)) {
					// 六个默认字段  要么同时存在 要么同时不存在
					List<String> strings = Arrays.asList("SrcOID", "SrcSOID", "SrcSequence", "MapKey", "SrcDocumentNumber", DataConstant.STR_FLD_SRCFORMKEY);
					//去判断主表中是否已经存在流程标识
					List<TagNode> column = tag.findNodesByTagName("Column");
					for (TagNode tagNode : column) {
						String key = tagNode.getAttributes().get(ConstantUtil.KEY);
						if (strings.contains(key)) {
							ishas = strings.contains(key);
							break;
						}
					}
				}
			}
		}
		return ishas;
	}

	private boolean checkGridCell(MetaForm metaForm, String mainTableKey) throws Throwable {
		boolean ishas = false;
		XmlTreeWithPath xmlTree;
		String filePath = LoadFileTree.getPathByFormKey(metaForm.getKey());
		xmlTree = XmlTreeWithPath.parseFilePath(filePath);

		List<TagNode> grid = xmlTree.xmlTree.getRoot().findNodesByTagName("GridRow");
		for (TagNode tag : grid) {
			if (tag.getAttributes().get(ConstantUtil.TABLE_KEY).equalsIgnoreCase(mainTableKey)) {
				// 六个默认字段  要么同时存在 要么同时不存在
				List<String> strings = Arrays.asList("SrcOID", "SrcSOID", "SrcSequence", "MapKey", "SrcDocumentNumber", DataConstant.STR_FLD_SRCFORMKEY);
				List<TagNode> gridColumnCollection = tag.findNodesByTagName("GridCell");
				for (TagNode tagNode : gridColumnCollection) {
					if (strings.contains(tagNode.getAttributes().get(ConstantUtil.KEY))) {
						ishas = true;
						break;
					}
				}
			}
		}
		return ishas;
	}

	private boolean checkGridColumn(MetaForm metaForm, String mainTableKey) throws Throwable {
		boolean ishas = false;
		XmlTreeWithPath xmlTree;
		String filePath = LoadFileTree.getPathByFormKey(metaForm.getKey());
		xmlTree = XmlTreeWithPath.parseFilePath(filePath);
		List<TagNode> grid = xmlTree.xmlTree.getRoot().findNodesByTagName("GridRow");
		for (TagNode tag : grid) {
			if (tag.getAttributes().get(ConstantUtil.TABLE_KEY).equalsIgnoreCase(mainTableKey)) {
				// 六个默认字段  要么同时存在 要么同时不存在
				List<String> strings = Arrays.asList("SrcOID", "SrcSOID", "SrcSequence", "MapKey", "SrcDocumentNumber", DataConstant.STR_FLD_SRCFORMKEY);
				List<TagNode> gridColumnCollection = tag.findNodesByTagName("GridColumnCollection");
				for (TagNode tagNode : gridColumnCollection) {
					if (strings.contains(tagNode.getAttributes().get(ConstantUtil.KEY))) {
						ishas = true;
						break;
					}
				}
			}
		}
		return ishas;
	}

	private String getGridColumnKey(MetaForm metaForm, String cellKey) throws Throwable {
		String tableKey = null;
		String filePath = LoadFileTree.getPathByFormKey(metaForm.getKey());
		XmlTreeWithPath xmlTree = XmlTreeWithPath.parseFilePath(filePath);
		List<TagNode> grid = xmlTree.xmlTree.getRoot().findNodesByTagName("GridColumn");
		for (TagNode tagNode : grid) {
			String key = tagNode.getParent().getParent().getAttributes().get(ConstantUtil.KEY);
			if (cellKey.equalsIgnoreCase(key)) {
				tableKey = cellKey;
			}
		}
		return tableKey;
	}

	private String getGridCellKey(MetaForm metaForm, String mainTableKey) throws Throwable {
		XmlTreeWithPath xmlTree = null;
		String tableKey = null;
		String filePath = LoadFileTree.getPathByFormKey(metaForm.getKey());
		xmlTree = XmlTreeWithPath.parseFilePath(filePath);
		List<TagNode> grid = xmlTree != null ? xmlTree.xmlTree.getRoot().findNodesByTagName("GridRow") : null;
		for (TagNode tagNode : grid) {
			if (mainTableKey.equalsIgnoreCase(tagNode.getAttributes().get(ConstantUtil.TABLE_KEY))) {
				String key = tagNode.getParent().getParent().getAttributes().get(ConstantUtil.KEY);
				tableKey = key;
			}
		}
		return tableKey;
	}
	/**
	 * @param bFiled
	 * @param sField
	 * @param tableKey
	 * @param isMap
	 * @param filedNode
	 * @param filedLabel
	 * @param element    源单 和 目标表单 tr 更换
	 */
	public void sourceAndTargetSwap(String bFiled, String sField, String tableKey, boolean isMap, String filedNode, String filedLabel, Element element) {
		if (element.attributeValue(isMap ? ConstantUtil.KEY : ConstantUtil.TABLE_KEY).equalsIgnoreCase(tableKey)) {
			List<Element> filedList = element.elements(filedNode);
			Integer bIndex = null, sIndex = null;
			Element tempBNode = null;
			for (Element node : filedList) {
				if (node.attributeValue(filedLabel).equalsIgnoreCase(bFiled)) {
					bIndex = filedList.indexOf(node);
					tempBNode = node;
				}
				if (node.attributeValue(filedLabel).equalsIgnoreCase(sField)) {
					sIndex = filedList.indexOf(node);
				}
			}
			if (bIndex != null && sIndex != null) {
				filedList.set(bIndex, (Element) filedList.get(sIndex).clone());
				filedList.set(sIndex, (Element) tempBNode.clone());
				bIndex = null;
				sIndex = null;
			}
		}
	}

	/**
	 * @param bFiled
	 * @param sField
	 * @param tableKey
	 * @param feedBackTableList 反填表单 tr更换
	 */
	public void feedBackSwap(String bFiled, String sField, String tableKey, List<Element> feedBackTableList) {
		feedBackTableList.forEach(table -> {
			if (table.attributeValue(ConstantUtil.TABLE_KEY).equalsIgnoreCase(tableKey)) {
				List<Element> feedBackField = table.elements(ConstantUtil.FEEDBACK_FIELD);
				Integer bIndex = null, sIndex = null;
				Element bNode = null;
				for (Element field : feedBackField) {
					if (field.attributeValue(ConstantUtil.FIELD_KEY).equalsIgnoreCase(bFiled)) {
						bIndex = feedBackField.indexOf(field);
						bNode = field;
					}
					if (field.attributeValue(ConstantUtil.FIELD_KEY).equalsIgnoreCase(sField)) {
						sIndex = feedBackField.indexOf(field);
					}
					if (bIndex != null && sIndex != null) {
						// 交换位置
						feedBackField.set(bIndex, (Element) feedBackField.get(sIndex).clone());
						feedBackField.set(sIndex, (Element) bNode.clone());
						bIndex = null;
						sIndex = null;
					}
				}
			}
		});
	}
//////////////////////////////////////////////////公共方法封装区/////////////////////////////////////////////


	/**
	 * 分割字段方法
	 */
	private static Map<String, String> carveUp(JsonDataMapVo jsonDataMapVo) {
		Map<String, String> map = new LinkedHashMap<String, String>();
		String sourceFormKey = "", targetFormKey = "", sourceField = "", targetField = "", sourceTableKey = "", targetTablekey = "";
		//分割获取源表单和目标表单
		if (jsonDataMapVo.getFormKey() != null) {
			sourceFormKey = jsonDataMapVo.getFormKey().split("&&")[0];
			targetFormKey = jsonDataMapVo.getFormKey().split("&&")[1];
			map.put(ConstantUtil.SOURCE_FORM_KEY, sourceFormKey);
			map.put(ConstantUtil.TARGET_FORM_KEY, targetFormKey);
		}
		//分割获取源单字段和目标字段
		if (jsonDataMapVo.getFieldKey() != null) {
			sourceField = jsonDataMapVo.getSourceFieldKey();
			targetField = jsonDataMapVo.getTargetFieldKey();
			map.put("sourceField", sourceField);
			map.put("targetField", targetField);
		}
		//分割获取源单table和目标表单Table
		if (jsonDataMapVo.getTableKey() != null) {
			sourceTableKey = jsonDataMapVo.getTableKey().split("&&")[0];
			targetTablekey = jsonDataMapVo.getTableKey().split("&&")[1];
			map.put("sourceTableKey", sourceTableKey);
			map.put("targetTablekey", targetTablekey);
		}
		return map;
	}

	//数据处理方法
	public void dataProcessing(String key, String endField, String value, String tableKey, String fieldKey, List<Element> targetTable) {
		for (Element ele : targetTable) {
			if (tableKey.equalsIgnoreCase(ele.attributeValue(ConstantUtil.DATA_SOURCE))
					|| tableKey.equalsIgnoreCase(ele.attributeValue(ConstantUtil.KEY))) {
				List<Element> targetField = ele.elements(ConstantUtil.TARGET_FIELD);
				for (Element target : targetField) {
					if (target.attributeValue(ConstantUtil.DEFINITION).equalsIgnoreCase(fieldKey)) {
						//进一步数据处理
						dataProcessing(key, endField, value, target);
					}
				}
			}
		}
	}

	//进一步数据处理方法
	public void dataProcessing(String key, String endField, String value, Element target) {
		List<Element> feedback = target.elements("Feedback");
		for (Element feed : feedback) {
			if (feed.attributeValue(ConstantUtil.FIELD_KEY).equalsIgnoreCase(endField)) {
				if ("OpSign".equalsIgnoreCase(key)) {
					if ("AddDelta".equalsIgnoreCase(value)) {
						feed.addAttribute(key, value);
					} else {
						feed.remove(feed.attribute(key));
					}
				} else if ("PostTrigger".equalsIgnoreCase(key)) {
					setNode(key, value, feed);
				} else if ("PostFormulaTrigger".equalsIgnoreCase(key)) {
					setNode(key, value, feed);
				} else if ("FeedCondition".equalsIgnoreCase(key)) {
					if (value != null) {
						feed.addAttribute("Condition", value);
					} else {
						feed.remove(feed.attribute("Condition"));
					}
				}
			}
		}
	}

	public void setNode(String key, String value, Element feed) {
		if (value != null && Objects.isNull(feed.element(key))) {
			feed.addElement(key).addCDATA(value);
		} else if (value != null && feed.element(key) != null) {
			feed.remove(feed.element(key));
			feed.addElement(key).addCDATA(value);
		} else {
			feed.remove(feed.element(key));
		}
	}

	//用于处理连线面板信息更新
	private void setLigature(String key, String value, String nodeName, String tableKey, String fieldKey, Element root, String endField) {
		List<Element> targetTable = root.element(nodeName).elements(ConstantUtil.SOURCE_TABLE);
		for (Element ele : targetTable) {
			if (tableKey.equalsIgnoreCase(StringUtils.isNotEmpty(ele.attributeValue(ConstantUtil.DATA_SOURCE)) ? ele.attributeValue(ConstantUtil.DATA_SOURCE) : ele.attributeValue(ConstantUtil.KEY))) {
				List<Element> sourceField = ele.elements(ConstantUtil.SOURCE_FIELD);
				for (Element source : sourceField) {
					if (source.attributeValue(ConstantUtil.DEFINITION).equalsIgnoreCase(fieldKey) && source.attributeValue(ConstantUtil.TARGET_FIELD_KEY).equalsIgnoreCase(endField)) {
						if ("Editable".equalsIgnoreCase(key)) {
							if ("false".equalsIgnoreCase(value)) {
								source.addAttribute(key, value);
							} else {
								source.remove(source.attribute("Editable"));
							}
						} else if ("ConditionField".equalsIgnoreCase(key)) {
							if (value != null) {
								source.addAttribute(ConstantUtil.CONDITION, value);
							} else {
								source.remove(source.attribute(ConstantUtil.CONDITION));
							}
						}
					}
				}
			}
		}
	}

	/***
	 * 写xml格式化
	 * @return 格式化类
	 */
	public static OutputFormat getOutputFormat() {
		// 格式化输出流，同时指定编码格式。也可以在FileOutputStream中指定。
		OutputFormat format = OutputFormat.createPrettyPrint();
		// 设置xml标签和Process标签之间没有空行
		format.setNewLineAfterDeclaration(false);
		format.setIndentSize(4);
		format.setExpandEmptyElements(false);
		format.setPadText(false);
		return format;
	}

	/***
	 * 删除xml元素属性
	 * @param element 元素
	 * @param attribute 属性
	 */
	private void deleteXmlElementAttribute(Element element, Attribute attribute) {
		if (null != attribute) {
			element.remove(attribute);
		}
	}

	/***
	 * 关闭文件流
	 * @param fileOutputStream 文件输出流
	 * @param writer 写对象
	 */
	public static void closeFileStream(FileOutputStream fileOutputStream, XMLWriter writer) {
		try {
			if (null != fileOutputStream) {
				fileOutputStream.close();
			}
			if (null != writer) {
				writer.close();
			}
		} catch (Exception e) {
			logger.warning("关闭writer异常，异常为:" + ExceptionUtils.getStackTrace(e));
		}
	}

	/**
	 * @param ele 节点
	 * @return 根据不同的XML结构去处理不同的表单
	 */
	public static String getTableKey(Element ele) {
		String table = "";
		if (ele.attributeValue(ConstantUtil.KEY) != null) {
			table = ele.attributeValue(ConstantUtil.KEY);
		} else if (ele.attributeValue(ConstantUtil.TABLE_KEY) != null) {
			table = ele.attributeValue(ConstantUtil.TABLE_KEY);
		}
		return table;
	}

	/**
	 * @param ele1
	 * @return 返回字段key
	 */
	public static String getFieldValue(Element ele1) {
		String filedVaule = "";
		if (ele1.attributeValue(ConstantUtil.DEFINITION) != null) {
			filedVaule = ele1.attributeValue(ConstantUtil.DEFINITION);
		} else if (ele1.attributeValue(ConstantUtil.FIELD_KEY) != null) {
			filedVaule = ele1.attributeValue(ConstantUtil.FIELD_KEY);
		}
		return filedVaule;
	}

	/***
	 * 校验是否存在主表
	 * @return 结果反馈
	 * @param
	 */
	public ResponseResult<JSONArray> isHaveMainTable(String filePaths) {
		ResponseResult<JSONArray> result = new ResponseResult<>();
		try {
			XmlTreeWithPath xmlTree = XmlTreeWithPath.parseFilePath(filePaths);
			String tagName = xmlTree.xmlTree.getRoot().getTagName();
			List<TagNode> sourceTable = xmlTree.xmlTree.getRoot().findNodesByTagName(ConstantUtil.SOURCE_TABLE);
			List<TagNode> targetTable = xmlTree.xmlTree.getRoot().findNodesByTagName(ConstantUtil.TARGET_TABLE);
			if (ConstantUtil.MAP.equalsIgnoreCase(tagName)) {
				//合并
				sourceTable.addAll(targetTable);
				ArrayList<String> strings = new ArrayList<>();
				//strings.size() == 2 说明两者都有主表
				for (TagNode tagNode : sourceTable) {
					if ("true".equalsIgnoreCase(tagNode.getAttributes().get("IsPrimary"))) {
						String name = tagNode.getTagName();
						strings.add(name);
					}
				}
				if (strings.size() == 0 || strings.size() == 1 && strings.contains(ConstantUtil.TARGET_TABLE)) {
					result.setCode(0);
					result.setMsg("映射问题:源表单未设置主表");
				} else if (strings.size() == 2) {
					result.setCode(0);
				} else if (strings.contains(ConstantUtil.SOURCE_TABLE)) {
					result.setCode(0);
					result.setMsg("映射问题:目标表单未设置主表");
				}
			} else if (ConstantUtil.DATA_MIGRATION.equalsIgnoreCase(tagName)) {
				for (TagNode tagNode : sourceTable) {
					if ("true".equalsIgnoreCase(tagNode.getAttributes().get("IsPrimary"))) {
						result.setCode(0);
						return result;
					}
				}
				result.setCode(0);
				//if (sourceTable.size() != 0) {
				result.setMsg("迁移问题:来源单未设置主表");
				//}
			}
		} catch (Throwable e) {
			logger.warning("验证出现异常，异常为:" + ExceptionUtils.getStackTrace(e));
			result.setCode(999);
			result.setMsg("验证失败，失败消息为:" + e.getMessage());
		}
		return result;
	}
}
