package com.bokesoft.yes.design.dataObject.util;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.IndexFacade;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.IndexFileWrapper;
import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.MetaObjectType;
import com.bokesoft.yes.design.Property;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.cmd.CommitDiffCmd;
import com.bokesoft.yes.design.cmd.XmlDiffProcessor;
import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.datamap.util.DataMapOperJsonUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.design.utils.DesignReloadMetaObject;
import com.bokesoft.yes.design.vo.DataObjectVO;
import com.bokesoft.yes.design.vo.ResponseResult;
import com.bokesoft.yes.design.xml.node.AbstractNode;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.design.xml.node.Xml4jUtil;
import com.bokesoft.yes.design.xml.node.XmlTree;
import com.bokesoft.yes.design.xml.parse.Element;
import com.bokesoft.yes.helper.DataObjectHelper;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.helper.MetaFormHelper;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.struct.abstractdatatable.RowState;
import com.bokesoft.yigo.common.def.*;
import com.bokesoft.yigo.meta.datamigration.DMPeriodGranularityType;
import com.bokesoft.yigo.meta.dataobject.*;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.MetaEmbed;
import com.bokesoft.yigo.meta.form.component.container.MetaSubDetail;
import com.bokesoft.yigo.meta.form.component.control.MetaDataBinding;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.json.JSONArray;

import java.io.File;
import java.util.*;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class DataObjectOperJsonUtil {
    private static final Logger logger = Logger.getLogger(DataMapOperJsonUtil.class.getName());

    private static final List<String> systemFields = Arrays.asList("ClientID", "Notes", "ResetPattern", "SequenceValue", "StatusItem");

    /**
     * 处理数据对象XML
     */
    public ResponseResult<JSONObject> handleDataObject(String formkey, Document document, List<Diff> diffs) throws Throwable {

        JSONObject jsonObject = new JSONObject();

        for (Diff diff : diffs) {
            String formPath = this.handleDataObjectByOidFilter(diff, diffs, document);
            if (StringUtils.isNotBlank(formPath)) {
                jsonObject.put("xmlPath_form", formPath);
                continue;
            }

            if (!diff.isPropertyDiff()) {
                continue;
            }

            DataTable headTable = document.get(ConstantUtil.TBL_DATA_OBJECT_FORM_HEAD);
            if (Objects.isNull(headTable)) {
                headTable = document.get("ED_DataObjectHead");
            }

            DataTable fieldTable = document.get(ConstantUtil.TBL_DATA_OBJECT_FIELD);
            if (Objects.isNull(fieldTable)) {
                fieldTable = document.get("ED_TableFields");
            }

            //检查是否设置了分组字段
            if (Objects.equals(headTable.getObject("AuxiliaryType"), "Migration")) {
                boolean isSetGroupField = false;
                for (int i = 0; i < fieldTable.size(); i++) {
                    String groupType = fieldTable.getString(i, "GroupType");
                    isSetGroupField = !StringUtils.equals(groupType, "-1");
                    if (isSetGroupField) {
                        break;
                    }
                }
                if (!isSetGroupField) {
                    ResponseResult<JSONObject> result = new ResponseResult<>();
					jsonObject.put("code", -1);
					jsonObject.put("msg", "操作失败，请设置分组字段");
					result.setData(jsonObject);
                    return result;
                }
            }

            // TODO 这里是不是要优化一下
            CommitDiffCmd.loadXmlTrees(diffs, "", ConstantUtil.DATA_OBJECT);
            XmlTreeWithPath xmlTree = diff.getXmlTree();
            if (Objects.isNull(xmlTree)) {
                // #75578 表单数据源中切换数据对象来源为来源数据对象时 选择来源数据对象时对页面检查出了错误却依然点击确认
                throw new RuntimeException("warning: 修改数据源失败，请检查修改内容是否正确。");
            }

            //添加对应节点
            String mainTableNodeKey = headTable.getString("MainTable");
            diff.setReserveTwo(mainTableNodeKey);

            //获取DataTable
            DataTable collecTable = document.get(ConstantUtil.TBL_DATA_OBJECT_COLLECTION);
            if (Objects.isNull(collecTable)) {
                collecTable = document.get("ED_TableCollection");
            }
            DataTable ed_parameterCollection = document.get("ED_ParameterCollection");
            DataTable ed_indexCollection = document.get("ED_IndexCollection");

            XmlDiffProcessor.dealHeadTable(xmlTree, headTable, collecTable, fieldTable, ed_parameterCollection, ed_indexCollection ,diff);
            XmlDiffProcessor.dealEmbedTable(xmlTree, document, diff);
            XmlDiffProcessor.dealEventTable(xmlTree, document, diff);

            XmlFileProcessor.instance.processDiff(diffs, false);

            IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
            MetaDataObjectList dataObjectList = metaFactory.getDataObjectList();
            MetaDataObjectProfile metaDataObjectProfile = dataObjectList.get(formkey);
            String mergeToSourceMapKey = "";
            if (Objects.nonNull(metaDataObjectProfile)) {
                if (StringUtils.isNotBlank(metaDataObjectProfile.getExtend())) {
                    String extendPath = LoadFileTree.loadFilePathByDataObjectFieldKey(metaDataObjectProfile.getExtend());
                    String tempPath = XmlFileProcessor.instance.getTmpFile(extendPath);
                    extendPath = StringUtils.isNotBlank(tempPath) ? tempPath : extendPath;
                    DataObjectHelper.reload(null,metaDataObjectProfile.getExtend(), extendPath, null);
                } else {
                    MetaDataObject metaDataObject = metaDataObjectProfile.getDataObject();
                    if (Objects.nonNull(metaDataObject)) {
                        mergeToSourceMapKey = metaDataObject.getMergeToSourceMapKey();
                    }
                }
            }

            String path = diff.getFilePath();
            String tempPath = XmlFileProcessor.instance.getTmpFile(path);
            DataObjectHelper.reload(null,formkey, tempPath, null);

            if (StringUtils.isNotBlank(mergeToSourceMapKey)) {
                String vestPath = LoadFileTree.loadFilePathByDataObjectFieldKey(mergeToSourceMapKey);
                String tempVestPath = XmlFileProcessor.instance.getTmpFile(vestPath);
                vestPath = StringUtils.isNotBlank(tempVestPath) ? tempVestPath : vestPath;
                DataObjectHelper.reload(null,mergeToSourceMapKey, vestPath, null);
            }

            String newContent = FileUtils.readFileToString(new File(tempPath), "UTF-8");
            jsonObject.put("xmlPath", StringUtils.isBlank(path) ? path : FilePathHelper.toFrontFilePath(path));
            jsonObject.put("newXml", newContent);

            if (StringUtils.isNotBlank(path)) {
                String tempFilePath = XmlFileProcessor.instance.getTmpFile(path);
                IndexFileWrapper file = IndexFileWrapper.newInstance(path, tempFilePath);
                IndexFacade.reload(file);
            }
        }
        ResponseResult<JSONObject> result = new ResponseResult<>();
        jsonObject.put("code", 0);
		jsonObject.put("msg", "操作数据对象成功");
		result.setData(jsonObject);
		return result;
    }

    /**
     * 处理字段信息和基本属性
     */
    public ResponseResult<JSONObject> FieldinforOrBasicAttribute(DataObjectVO dataObjectVO) throws Throwable {
        ResponseResult<JSONObject> result = new ResponseResult<>();
        JSONObject jsonObject = new JSONObject();
//        String formkey = null;
        try {
//            formkey = dataObjectVO.getFormkey();
            //处理diffs数据
            String diffJsonString = (String) dataObjectVO.getDiff();
            JSONArray array = new JSONArray(diffJsonString);
            int len = array.length();
            List<Diff> diffs = new ArrayList<Diff>(len);
            for (int i = 0; i < len; i++) {
                diffs.add(Diff.fromJson(array.getJSONObject(i)));
            }
            for (Diff diff : diffs) {
                if (!diff.isPropertyDiff()) {
                    continue;
                }
                //处理XMLTree
                CommitDiffCmd.loadXmlTrees(diffs, "", ConstantUtil.DATA_OBJECT);
                //获取XMltree
                XmlTreeWithPath xmlTree = diff.getXmlTree();
                //处理字段信息
                if (diff.getMetaObjectType() == MetaObjectType.Fieldinformation) {
                    XmlDiffProcessor.handleFieldinformation(diff, xmlTree);
                }
//                List<UICommand> uiCommands = new ArrayList<UICommand>();
                String path = diff.getFilePath();
                //给diff一个完整的路径
                diff.setFilePath(path);
                XmlFileProcessor.instance.processDiff(diffs, false);
                String tempPath = XmlFileProcessor.instance.getTmpFile(path);
                String newContent = FileUtils.readFileToString(new File(tempPath), "UTF-8");
                jsonObject.put("xmlPath", path);
                jsonObject.put("newXml", newContent);
            }
            result.setCode(0);
            result.setMsg("操作数据对象成功");
            result.setData(jsonObject);
        } catch (Exception e) {
            logger.warning("操作数据对象异常，异常为:" + ExceptionUtils.getStackTrace(e));
            result.setCode(999);
            result.setMsg("操作数据对象失败，失败消息为:" + e.getMessage());
        } catch (Throwable throwable) {
            logger.warning(throwable.getMessage());
        }
        return result;
    }

    private static boolean exist(TagNode tagNode, String primary) {//判断是否存在
        boolean equals = false;
        List<AbstractNode> children = tagNode.getChildren();
        for (AbstractNode child : children) {
            if (child instanceof TagNode) {
                String primaryKey = ((TagNode) child).getPrimaryKey();
                if (primary.equals(primaryKey)) {
                    equals = true;
                    break;
                }
            }
        }
        return equals;
    }

    public ResponseResult<JSONObject> getKey(DataObjectVO dataObjectVO) {
        String key = dataObjectVO.getKey();
        String formkey = dataObjectVO.getFormkey();

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("code", 999);
        try {
            MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(formkey);
            List<MetaComponent> allComponents = metaForm.getAllComponents();
            for (MetaComponent allComponent : allComponents) {
                String allComponentKey = allComponent.getKey();
                if (allComponent instanceof MetaSubDetail && ((MetaSubDetail) allComponent).getRoot().getKey().equalsIgnoreCase(key)) {
                    jsonObject.put("subKey", allComponentKey);
                    jsonObject.put("code", 0);
                    jsonObject.put("msg", "操作数据成功");
                }
            }
        } catch (Throwable throwable) {
            logger.warning(throwable.getMessage());
        }
        ResponseResult<JSONObject> result = new ResponseResult<>();
        result.setData(jsonObject);
        return result;
    }

    /**
     * 获取行数用于获取XMl中的第一行进行拼接一个新的xml作为临时文件的内容
     */
//    private static Line getLine(String content, int line) {
//        // \r 13 <回车> Carriage Return; \n 10 <换行> Line Feed
//        // Dos和windows采用回车+换行CR/LF表示下一行, \r\n
//        // 而UNIX/Linux采用换行符LF表示下一行 \n
//        // 苹果机(MAC OS系统)则采用回车符CR表示下一行 \r
//        int pos = 0;
//        for (int i = 0; i < line; i++) {
//            pos = content.indexOf("\n", pos + 1);
//        }
//        int pos2 = content.indexOf("\n", pos + 1);
//        if (content.substring(pos2 - 1, pos2).equals("\r")) {
//            --pos2;
//        }
//        String lineContent = content.substring(pos + 1, pos2);
//        return new Line(pos + 1, lineContent);
//    }


    public String getEmbedKey(DataObjectVO dataObjectVO) {
        String formkey = dataObjectVO.getFormkey();
//        ResponseResult<JSONObject> result = new ResponseResult<>();
        List<JSONObject> jsonObjects = new ArrayList<>();
        try {
            MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(formkey);
            for (MetaEmbed embed : metaForm.getEmbeds()) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("Key", embed.getKey());
                jsonObjects.add(jsonObject);
            }
        } catch (Throwable throwable) {
            logger.warning(throwable.getMessage());
        }
        return jsonObjects.toString();
    }

    public static void dealHeadTable(XmlTreeWithPath xmlTree, String controlerType, String primaryKey, DataTable headTable,
                                     DataTable collecTable, DataTable fieldTable, DataTable ed_parameterCollection,
                                     Diff diff, String formKey) throws Throwable {
        controlerType = MetaObjectType.DataObject.name;
//        int state = headTable.getState();
        TagNode parentNode;
        // 来源数据源的DataObject
        MetaDataObject curDataObject = null;
        if (diff.getDataObject() != null) {
            curDataObject = DataObjectHelper.loadByKey(diff.getDataObject().getKey());
        }

        if (xmlTree.xmlTree.getRoot().findNodesByTagName(MetaObjectType.DataObject.name).size() == 0) {
            List<TagNode> dataSource = xmlTree.xmlTree.getRoot().findNodesByTagName("DataSource");
            if (dataSource.size() <= 0) {
                // 将整个父节点替换掉
                genXmlDiff(xmlTree, xmlTree.xmlTree.getRoot(), diff, true);
                return;
            }
            MetaDataObject metaDataObject = MetaFactory.getGlobalInstance().getDataObject(dataSource.get(0).getAttributes().get("RefObjectKey"));
            String filePath = LoadFileTree.loadFilePathByDataObjectFieldKey(metaDataObject.getKey());
            XmlTreeWithPath dataObjectXmlTree = XmlTreeWithPath.parseFilePath(filePath);
            parentNode = dataObjectXmlTree.xmlTree.getRoot().findNodesByTagName(MetaObjectType.DataObject.name).get(0);
        } else {
            parentNode = xmlTree.xmlTree.getRoot().findNodesByTagName(MetaObjectType.DataObject.name).get(0);
        }
        //	if (RowState.MODIFIED == state) {
        for (int i = 0; i < headTable.size(); i++) {
            primaryKey = (String) headTable.getOriginalObject(i, "Mark");
            String mark = headTable.getString(i, "Mark");
            String caption = headTable.getString(i, ConstantUtil.CAPTION);
            String mainTable = headTable.getString(i, "MainTable");
            String mainType = headTable.getString(i, "MainType");

            if ("Virtual".equals(mainType)) {
                parentNode.getAttributes().remove("PrimaryType");
                parentNode.getAttributes().remove("SecondaryType");
                parentNode.getAttributes().remove("QueryFields");
                parentNode.getAttributes().remove("DisplayFields");
            } else {
                parentNode.setAttribute("PrimaryType", mainType);
            }

            String displayFields = headTable.getString(i, "DisplayFields");
            String queryFields = headTable.getString(i, "QueryFields");
            String loadRightsType = headTable.getString(i, "LoadRightsType");
            String checkAfterLoad = headTable.getString(i, "CheckAfterLoad");
            parentNode.setAttribute(ConstantUtil.KEY, mark);
            parentNode.setAttribute(ConstantUtil.CAPTION, caption);
//            String orgPrimaryTableKey = parentNode.getAttributes().get(ConstantUtil.PRIMARY_TABLE_KEY);
            boolean hasPrimaryTable = false;
            for (int j = 0; j < collecTable.size(); j++) {
                hasPrimaryTable = collecTable.getBoolean(j, "IsPrimaryTable") || "1".equals(collecTable.getString(j, "IsPrimaryTable"));
                if (hasPrimaryTable) {
                    break;
                }
            }
            if (!hasPrimaryTable) { // 没有主表不设置mainTable
                mainTable = "";
            }
            parentNode.setAttribute(ConstantUtil.PRIMARY_TABLE_KEY, mainTable);
            if (loadRightsType != null) {
                parentNode.setAttribute("LoadRightsType", loadRightsType);
            }
            parentNode.setAttribute("CheckAfterLoad", checkAfterLoad);
            String maintainDict = headTable.getString(i, "MaintainDict");
            parentNode.setAttribute("MaintainDict", maintainDict);
            String auxiliaryType = headTable.getString("AuxiliaryType");
            dealCollecTable(xmlTree, controlerType, primaryKey, collecTable, fieldTable, diff, formKey, ed_parameterCollection, curDataObject);
            parentNode.setAttribute("SecondaryType", auxiliaryType);
            if ("Dict".equalsIgnoreCase(auxiliaryType) || "ChainDict".equalsIgnoreCase(auxiliaryType)) {
                parentNode.setAttribute("DisplayFields", displayFields);
                parentNode.setAttribute("QueryFields", queryFields);
            } else {
                parentNode.getAttributes().remove("DisplayFields");
                parentNode.getAttributes().remove("QueryFields");
            }
            if (auxiliaryType.equalsIgnoreCase(DataObjectSecondaryType.STR_NORMAL) || auxiliaryType.equalsIgnoreCase(DataObjectSecondaryType.STR_MIGRATION)) {
                if (auxiliaryType.equalsIgnoreCase(DataObjectSecondaryType.STR_MIGRATION)) {
                    if (!hasPrimaryTable) {
                        throw new Throwable("迁移表必须存在主表");
                    }
                }
                TagNode detailnode = xmlTree.xmlTree.getTagNode("Table@" + mainTable);
                if (Objects.isNull(detailnode)) {
                    genXmlDiff(xmlTree, parentNode, diff, true);
                    return;
                }
                /*if (numberOfCitations("Code", mark, mainTable) == 0) {
					detailnode.deleteChildByTagKey("Code");
				}
				if (numberOfCitations(ConstantUtil.NAME, mark, mainTable) == 0) {
					detailnode.deleteChildByTagKey(ConstantUtil.NAME);
				}
				if (numberOfCitations(ConstantUtil.ENABLE, mark, mainTable) == 0) {
					detailnode.deleteChildByTagKey(ConstantUtil.ENABLE);
				}
				if (numberOfCitations("ParentID", mark, mainTable) == 0) {
					detailnode.deleteChildByTagKey("ParentID");
				}
				if (numberOfCitations("NodeType", mark, mainTable) == 0) {
					detailnode.deleteChildByTagKey("NodeType");
				}
				if (numberOfCitations("TLeft", mark, mainTable) == 0) {
					detailnode.deleteChildByTagKey("TLeft");
				}
				if (numberOfCitations("TRight", mark, mainTable) == 0) {
					detailnode.deleteChildByTagKey("TRight");
				}
				if (numberOfCitations("ForeignName", mark, mainTable) == 0) {
					detailnode.deleteChildByTagKey("ForeignName");
				}*/
            } else if (auxiliaryType.equalsIgnoreCase(DataObjectSecondaryType.STR_CHAINDICT) || auxiliaryType.equalsIgnoreCase(DataObjectSecondaryType.STR_DICT)) {
                TagNode tagNode = xmlTree.xmlTree.getTagNode("Table@" + mainTable);
                if (Objects.isNull(tagNode)) {
                    genXmlDiff(xmlTree, parentNode, diff, true);
                    return;
                }
                if (!exist(tagNode, ConstantUtil.COLUMN + "@" + "Code")) {
                    TagNode column = new TagNode(ConstantUtil.COLUMN, null);
                    column.setAttribute(ConstantUtil.KEY, "Code");
                    column.setAttribute(ConstantUtil.CAPTION, "代码");
                    column.setAttribute(ConstantUtil.DATA_TYPE, "Varchar");
                    column.setAttribute(ConstantUtil.LENGTH, "50");
                    tagNode.addNode(column);
                }
                if (!exist(tagNode, ConstantUtil.COLUMN + "@" + ConstantUtil.NAME)) {
                    TagNode column1 = new TagNode(ConstantUtil.COLUMN, null);
                    column1.setAttribute(ConstantUtil.KEY, ConstantUtil.NAME);
                    column1.setAttribute(ConstantUtil.CAPTION, "名称");
                    column1.setAttribute(ConstantUtil.DATA_TYPE, "Varchar");
                    column1.setAttribute(ConstantUtil.LENGTH, "100");
                    tagNode.addNode(column1);
                }
                if (!exist(tagNode, ConstantUtil.COLUMN + "@" + ConstantUtil.ENABLE)) {
                    TagNode column2 = new TagNode(ConstantUtil.COLUMN, null);
                    column2.setAttribute(ConstantUtil.KEY, ConstantUtil.ENABLE);
                    column2.setAttribute(ConstantUtil.CAPTION, "启用标记");
                    column2.setAttribute(ConstantUtil.DATA_TYPE, "Integer");
                    tagNode.addNode(column2);
                }
                if (!exist(tagNode, ConstantUtil.COLUMN + "@" + "ParentID")) {
                    TagNode column3 = new TagNode(ConstantUtil.COLUMN, null);
                    column3.setAttribute(ConstantUtil.KEY, "ParentID");
                    column3.setAttribute(ConstantUtil.CAPTION, "父节点");
                    column3.setAttribute(ConstantUtil.DATA_TYPE, "Long");
                    tagNode.addNode(column3);
                }
                if (!exist(tagNode, ConstantUtil.COLUMN + "@" + "NodeType")) {
                    TagNode column4 = new TagNode(ConstantUtil.COLUMN, null);
                    column4.setAttribute(ConstantUtil.KEY, "NodeType");
                    column4.setAttribute(ConstantUtil.CAPTION, "节点类型");
                    column4.setAttribute(ConstantUtil.DATA_TYPE, "Integer");
                    tagNode.addNode(column4);
                }
                if (!exist(tagNode, ConstantUtil.COLUMN + "@" + "TLeft")) {
                    TagNode column5 = new TagNode(ConstantUtil.COLUMN, null);
                    column5.setAttribute(ConstantUtil.KEY, "TLeft");
                    column5.setAttribute(ConstantUtil.CAPTION, "TLeft");
                    column5.setAttribute(ConstantUtil.DATA_TYPE, "Integer");
                    tagNode.addNode(column5);
                }
                if (!exist(tagNode, ConstantUtil.COLUMN + "@" + "TRight")) {
                    TagNode column6 = new TagNode(ConstantUtil.COLUMN, null);
                    column6.setAttribute(ConstantUtil.KEY, "TRight");
                    column6.setAttribute(ConstantUtil.CAPTION, "TRight");
                    column6.setAttribute(ConstantUtil.DATA_TYPE, "Integer");
                    tagNode.addNode(column6);
                }
                if (!exist(tagNode, ConstantUtil.COLUMN + "@" + "ForeignName")) {
                    TagNode column7 = new TagNode(ConstantUtil.COLUMN, null);
                    column7.setAttribute(ConstantUtil.KEY, "ForeignName");
                    column7.setAttribute(ConstantUtil.CAPTION, "名称(外文)");
                    column7.setAttribute(ConstantUtil.DATA_TYPE, "Varchar");
                    column7.setAttribute(ConstantUtil.LENGTH, "255");
                    tagNode.addNode(column7);
                }
            }
        }
        //}
        // 因为数据源改动可能引起字段列标识表标识改动,将整个父节点替换掉
        genXmlDiff(xmlTree, diff.getXmlTree().xmlTree.getRoot(), diff, true);
    }

    public static void genXmlDiff(XmlTreeWithPath xmlTree, TagNode node, Diff diff, boolean isFirst) {
        Element element = node.getElement();
        int startLine = xmlTree.xmlTree.getLineByIndex(element.getBgIndex());
        String orgXmlFragment = xmlTree.xmlTree.getNodeString(startLine);
        String newXmlFragment = DesignIOMetaUtil.getXml(node);
        if (isFirst) {
            diff.setXmlDiff(xmlTree, startLine, orgXmlFragment, newXmlFragment);
        } else {
            diff.setXmlDiff2(xmlTree, startLine, orgXmlFragment, newXmlFragment);
        }
    }

    private static void dealCollecTable(XmlTreeWithPath xmlTree, String controlerType, String primaryKey, DataTable collecTable,
                                        DataTable fieldTable, Diff diff, String formKey, DataTable ed_parameterCollection, MetaDataObject curDataObject) throws Throwable {
        controlerType = MetaObjectType.table.name;
        collecTable.setShowDeleted(true);
        for (int i = 0; i < collecTable.size(); i++) {
            int rowState = collecTable.getState(i);
            TagNode parentNode = null;
            TagNode dataObjectNoed = null;
            if (xmlTree.xmlTree.getRoot().findNodesByTagName(MetaObjectType.DataObject.name).size() == 0) {
                MetaDataObject metaDataObject = MetaFactory.getGlobalInstance().getDataObject(xmlTree.xmlTree.getRoot().findNodesByTagName("DataSource").get(0).getAttributes().get("RefObjectKey"));
                String filePath = LoadFileTree.loadFilePathByDataObjectFieldKey(metaDataObject.getKey());
                XmlTreeWithPath dataObjectxmlTree = XmlTreeWithPath.parseFilePath(filePath);
                parentNode = dataObjectxmlTree.xmlTree.getRoot().findNodesByTagName(MetaObjectType.tableCollection.name).get(0);
                dataObjectNoed = dataObjectxmlTree.xmlTree.getRoot().findNodesByTagName(MetaObjectType.tableCollection.name).get(0).getParent();
            } else {
                parentNode = xmlTree.xmlTree.getRoot().findNodesByTagName(MetaObjectType.tableCollection.name).get(0);
                dataObjectNoed = xmlTree.xmlTree.getRoot().findNodesByTagName(MetaObjectType.tableCollection.name).get(0).getParent();
            }
            Long parentOID = null;
            String xmlTreeKey = null;
            TagNode curNode = null;
            String tableMode = null;
            String isPrimariy = null;
            primaryKey = (String) collecTable.getOriginalObject(i, "TableMark");
            String TableMark = collecTable.getString(i, "TableMark");
            String AssociationTable = collecTable.getString(i, "AssociationTable");
            if (StringUtils.isBlank(primaryKey)) {
                primaryKey = TableMark;
            }
            String TableName = collecTable.getString(i, "TableName");
            String parentTableKey = collecTable.getString(i, "ParentTableKey");
            Integer DataTableMode = collecTable.getInt(i, "TableMode");
            if (TableMode.HEAD == DataTableMode) {
                tableMode = TableMode.STR_HEAD;
            } else if (TableMode.DETAIL == DataTableMode) {
                tableMode = TableMode.STR_DETAIL;
            }
            xmlTreeKey = getXmlTreeKey(diff, controlerType, primaryKey);//用原来的key来定位，（万一key修改了）也能定位
            curNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);//当前表单的xmlTree，遇到嵌入式表单的，就报null
            //boolean containKey = xmlTree.containKey("Table@"+primaryKey);//是否本页面节点
            String tagName = xmlTree.xmlTree.getRoot().getTagName();
            if (MetaObjectType.DataObject.name.equals(tagName)) { //来源数据对象fa
                String key = xmlTree.xmlTree.getRoot().getAttributes().get(ConstantUtil.KEY);
                if (!key.equals(formKey)) { //非当前页面(嵌入式)
                    // continue;//现在已经支持修改不做处理
                }
            }
            if (Objects.isNull(curNode)) {  //新增节点
                xmlTreeKey = getXmlTreeKey(diff, controlerType, TableMark);
                curNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
            }

            if (RowState.MODIFIED == rowState || RowState.NORMAL == rowState) {
                parentOID = collecTable.getLong(i, ConstantUtil.OID);
                String dataType = dataObjectNoed.getAttributes().get("SecondaryType");
                if (StringUtils.isBlank(dataType)) {
                    dataType = "Normal";
                }

                dealFieldTable(xmlTree, controlerType, fieldTable, diff, curNode, parentOID, curDataObject);
                isPrimariy = String.valueOf(collecTable.getString(i, "IsPrimaryTable"));
                dealPrimariyTable(xmlTree, isPrimariy, diff, curNode, dataType);
                if (!curNode.getAttributes().get(ConstantUtil.KEY).equalsIgnoreCase(TableMark) && !ConstantUtil.DATA_OBJECT.equalsIgnoreCase(diff.getReserveOne())) {
                    String orgKey = curNode.getAttributes().get(ConstantUtil.KEY);
                    TagNode bodyNode = xmlTree.xmlTree.getRoot().getOrCreateChildByTagName("Body");
                    List<TagNode> nodeList = bodyNode.findNodesByTagName(MetaDataBinding.TAG_NAME);
                    for (TagNode tagNode : nodeList) {
                        if (tagNode.getAttributes().get(ConstantUtil.TABLE_KEY) != null) {
                            if (tagNode.getAttributes().get(ConstantUtil.TABLE_KEY).equalsIgnoreCase(orgKey)) {
                                tagNode.setAttribute(ConstantUtil.TABLE_KEY, TableMark);
                            }
                        }
                    }
                    List<TagNode> rowNodeList = bodyNode.findNodesByTagName(ConstantUtil.GRID_ROW);
                    for (TagNode tagNode : rowNodeList) {
                        if (tagNode.getAttributes().get(ConstantUtil.TABLE_KEY) != null) {
                            if (tagNode.getAttributes().get(ConstantUtil.TABLE_KEY).equalsIgnoreCase(orgKey)) {
                                tagNode.setAttribute(ConstantUtil.TABLE_KEY, TableMark);
                            }
                        }
                    }
                }
                if (curNode.getAttributes().get(ConstantUtil.KEY).equalsIgnoreCase(curNode.getParent().getParent().getAttributes().get(ConstantUtil.PRIMARY_TABLE_KEY))) {
                    curNode.getParent().getParent().setAttribute(ConstantUtil.PRIMARY_TABLE_KEY, TableMark);
                }
                curNode.setAttribute(ConstantUtil.KEY, TableMark);
                curNode.setAttribute(ConstantUtil.CAPTION, TableName);
                if (StringUtils.isNotEmpty(AssociationTable)) {
                    curNode.setAttribute(ConstantUtil.DB_TABLE_NAME, AssociationTable);

                }
                curNode.setAttribute(ConstantUtil.PARENT_KEY, "无数据表".equalsIgnoreCase(parentTableKey) ? "" : parentTableKey);
                if ("0".equalsIgnoreCase(parentTableKey)) {
                    curNode.getAttributes().remove(ConstantUtil.PARENT_KEY);
                }
                curNode.setAttribute(ConstantUtil.TABLE_MODE, tableMode);
                curNode.setAttribute("Persist", collecTable.getInt(i, "Persist") == 1 ? "true" : "false");
                if ("true".equalsIgnoreCase(curNode.getAttributes().get("Persist"))) {
                    curNode.getAttributes().remove("Persist");
                }
                curNode.setAttribute("GroupBy", collecTable.getString(i, "GroupBy"));
                if (collecTable.getString(i, "GroupBy").isEmpty()) {
                    curNode.getAttributes().remove("GroupBy");
                }
                curNode.setAttribute("Formula", collecTable.getString(i, "Formula"));
                if (StringUtils.isBlank(collecTable.getString(i, "Formula"))) {
                    curNode.getAttributes().remove("Formula");
                }
                curNode.setAttribute(ConstantUtil.INDEX_PREFIX, collecTable.getString(i, ConstantUtil.INDEX_PREFIX));
                if (StringUtils.isBlank(collecTable.getString(i, ConstantUtil.INDEX_PREFIX))) {
                    curNode.getAttributes().remove(ConstantUtil.INDEX_PREFIX);
                }
                curNode.setAttribute("Impl", collecTable.getString(i, "Impl"));
                if (StringUtils.isBlank(collecTable.getString(i, "Impl"))) {
                    curNode.getAttributes().remove("Impl");
                }
                curNode.setAttribute("OrderBy", collecTable.getString(i, "OrderBy"));
                if (collecTable.getString(i, "OrderBy").isEmpty()) {
                    curNode.getAttributes().remove("OrderBy");
                }
                TagNode childByTagNameOne = curNode.getOrCreateChildByTagName(ConstantUtil.STATEMENT);
                childByTagNameOne.setCDataValue(collecTable.getString(i, ConstantUtil.STATEMENT));
                if (StringUtils.isBlank(collecTable.getString(i, ConstantUtil.STATEMENT))) {
                    curNode.deleteChildByTagName(ConstantUtil.STATEMENT);
                }
                curNode.getOrCreateChildByTagName(ConstantUtil.STATEMENT).setAttribute(ConstantUtil.TYPE, collecTable.getString(i, "QueryType"));
                if (StringUtils.isEmpty(collecTable.getString(i, "QueryType"))) {
                    curNode.getOrCreateChildByTagName(ConstantUtil.STATEMENT).getAttributes().remove(ConstantUtil.TYPE);
                }
                String newValue = collecTable.getString(i, ConstantUtil.TYPE);
                if (MetaObjectType.DataObject.name.equalsIgnoreCase(newValue)) {
                    curNode.getAttributes().remove("SourceType");
                    curNode.deleteChildByTagName(ConstantUtil.STATEMENT);
                } else {
                    curNode.setAttribute("SourceType", newValue);
                    if (!"Query".equals(newValue)) {
                        curNode.deleteChildByTagName(ConstantUtil.STATEMENT);
                    }
                }
                TagNode childByTagName = curNode.getOrCreateChildByTagName("TableFilter");
                childByTagName.setAttribute(ConstantUtil.TYPE, collecTable.getString(i, "TableFilterType"));
                if (StringUtils.isNotEmpty(collecTable.getString(i, "TableFilter"))) {
                    childByTagName.setCDataValue(collecTable.getString(i, "TableFilter"));
                    childByTagName.setAttribute(MetaConstants.TABLEFILTER_TYPE, collecTable.getString(i, "TableFilterType"));
                } else if (StringUtils.isNotEmpty(collecTable.getString(i, "TableFilterTwo"))) {
                    childByTagName.setCDataValue(collecTable.getString(i, "TableFilterTwo"));
                } else {
                    curNode.getChildren().remove(childByTagName);
                }
                if (!primaryKey.equalsIgnoreCase(TableMark)) {
                    replaceTableKey(diff, primaryKey, TableMark);
                }
            } else if (RowState.NEW == rowState) {
                //不能添加重复表
                boolean ishas = false;
                TagNode node = new TagNode(controlerType, null);
                List<TagNode> table = parentNode.findNodesByTagName(ConstantUtil.TABLE);
                for (TagNode tagNode : table) {
                    if (tagNode.getAttributes().get(ConstantUtil.KEY).equals(TableMark)) {
                        ishas = true;
                    }
                }
                if (!ishas) {
                    node.setAttribute(ConstantUtil.KEY, TableMark);
                    node.setAttribute(ConstantUtil.CAPTION, TableName);
                    node.setAttribute(ConstantUtil.DB_TABLE_NAME, AssociationTable);
                    node.setAttribute(ConstantUtil.INDEX_PREFIX, TableMark);
                    node.setAttribute(ConstantUtil.PARENT_KEY, "无数据表".equalsIgnoreCase(parentTableKey) ? "" : parentTableKey);
                    if ("0".equalsIgnoreCase(parentTableKey)) {
                        node.getAttributes().remove(ConstantUtil.PARENT_KEY);
                    }
                    node.setAttribute(ConstantUtil.TABLE_MODE, tableMode);
                    node.setAttribute("Persist", collecTable.getInt(i, "Persist") == 1 ? "true" : "false");
                    if (collecTable.getInt(i, "Persist") == 1) {
                        node.getAttributes().remove("Persist");
                    }
                    node.setAttribute("GroupBy", collecTable.getString(i, "GroupBy"));
                    if (collecTable.getString(i, "GroupBy").isEmpty()) {
                        node.getAttributes().remove("GroupBy");
                    }
                    node.setAttribute("Formula", collecTable.getString(i, "Formula"));
                    if (collecTable.getString(i, "Formula").isEmpty()) {
                        node.getAttributes().remove("Formula");
                    }
                    node.setAttribute("Impl", collecTable.getString(i, "Impl"));
                    if (collecTable.getString(i, "Impl").isEmpty()) {
                        node.getAttributes().remove("Impl");
                    }
                    node.setAttribute("OrderBy", collecTable.getString(i, "OrderBy"));
                    if (collecTable.getString(i, "OrderBy").isEmpty()) {
                        node.getAttributes().remove("OrderBy");
                    }
                    node.setAttribute(ConstantUtil.INDEX_PREFIX, collecTable.getString(i, ConstantUtil.INDEX_PREFIX));
                    if (collecTable.getString(i, ConstantUtil.INDEX_PREFIX).isEmpty()) {
                        node.getAttributes().remove(ConstantUtil.INDEX_PREFIX);
                    }
                    node.getOrCreateChildByTagName(ConstantUtil.STATEMENT).setAttribute(ConstantUtil.TYPE, collecTable.getString(i, "QueryType"));
                    if (collecTable.getString(i, "QueryType").isEmpty()) {
                        node.getOrCreateChildByTagName(ConstantUtil.STATEMENT).getAttributes().remove("QueryType");
                    }
                    String newValue = collecTable.getString(i, ConstantUtil.TYPE);
                    if (MetaObjectType.DataObject.name.equalsIgnoreCase(newValue)) {
                        node.getAttributes().remove("SourceType");
                    } else {
                        if (!newValue.isEmpty()) {
                            node.setAttribute("SourceType", newValue);
                        }
                        if (!"Query".equals(newValue)) {
                            node.deleteChildByTagName(ConstantUtil.STATEMENT);
                        }
                    }

                    parentNode.addNode(node);
                    xmlTree.xmlTree.updateMap(true);

                    parentOID = collecTable.getLong(i, ConstantUtil.OID);
                    String dataType = dataObjectNoed.getAttributes().get("SecondaryType");
                    if (StringUtils.isBlank(dataType)) {
                        dataType = "Normal";
                    }
                    isPrimariy = String.valueOf(collecTable.getString(i, "IsPrimaryTable"));
                    dealFieldTable(xmlTree, controlerType, fieldTable, diff, node, parentOID, curDataObject);
                    dealPrimariyTable(xmlTree, isPrimariy, diff, node, dataType);
                    TagNode childByTagName = node.getOrCreateChildByTagName("TableFilter");
                    childByTagName.setAttribute(ConstantUtil.TYPE, collecTable.getString(i, "TableFilterType"));
                    if (StringUtils.isNotEmpty(collecTable.getString(i, "TableFilter"))) {
                        childByTagName.setCDataValue(collecTable.getString(i, "TableFilter"));
                    }
                    if (StringUtils.isNotEmpty(collecTable.getString(i, "TableFilterTwo"))) {
                        childByTagName.setCDataValue(collecTable.getString(i, "TableFilterTwo"));
                    }
                    if (collecTable.getString(i, "TableFilter").isEmpty() && collecTable.getString(i, "TableFilterTwo").isEmpty()) {
                        node.deleteChildByTagName("TableFilter");
                    }
                    TagNode childByTagNameOne = node.getOrCreateChildByTagName(ConstantUtil.STATEMENT);
                    childByTagNameOne.setCDataValue(collecTable.getString(i, ConstantUtil.STATEMENT));
                    if (collecTable.getString(i, ConstantUtil.STATEMENT).isEmpty()) {
                        node.deleteChildByTagName(ConstantUtil.STATEMENT);
                    }
                }
            } else if (RowState.DELETED == rowState) {
                List<AbstractNode> children = parentNode.getChildren();
                children.remove(curNode);
            }
            dealParameterCollection(ed_parameterCollection, curNode, parentOID);
        }
    }

    private static void dealParameterCollection(DataTable ed_parameterCollection,
                                                TagNode parentNode, Long parentOID) throws Throwable {
        if (Objects.isNull(parentNode) || Objects.isNull(parentOID)) {
            return;
        }
        List<TagNode> parameterCollection = parentNode.findNodesByTagName(MetaParameterCollection.TAG_NAME);
        ed_parameterCollection.setShowDeleted(true);
        for (int i = 0; i < ed_parameterCollection.size(); i++) {
            Long rowPOID = ed_parameterCollection.getLong(i, ConstantUtil.POID);
            // 针对系统字段，同样也适用于普通字段

            if (parameterCollection.size() > 0 && parentOID.equals(rowPOID)) {
                TagNode tagNode = parameterCollection.get(0);
                tagNode.getChildren().clear();
            } else if (parentOID.equals(rowPOID)) {
                TagNode parameterCollections = new TagNode(MetaParameterCollection.TAG_NAME, null);
                parentNode.addNode(parameterCollections);
            }
        }
        for (int i = 0; i < ed_parameterCollection.size(); i++) {
            Long rowPOID = ed_parameterCollection.getLong(i, ConstantUtil.POID);
            if (parentOID.equals(rowPOID)) {
                String sourceType = (String) ed_parameterCollection.getString(i, "SourceType");
                String value = (String) ed_parameterCollection.getString(i, ConstantUtil.VALUE);
                String description1 = (String) ed_parameterCollection.getString(i, "Description");
                String dataType = (String) ed_parameterCollection.getString(i, ConstantUtil.DATA_TYPE);
                int rowState = ed_parameterCollection.getState(i);
                // 针对系统字段，同样也适用于普通字段
                if (parentOID.equals(rowPOID) && RowState.DELETED != rowState) {
                    TagNode parameter = new TagNode(ConstantUtil.PARAMETER, null);
                    if ("Const".equalsIgnoreCase(sourceType)) {
                        parameter.setAttribute(ConstantUtil.VALUE, value);
                        parameter.setAttribute("SourceType", sourceType);
                    } else {
                        parameter.setAttribute("Formula", value);
                    }
                    parameter.setAttribute(ConstantUtil.DATA_TYPE, dataType);
                    parameter.setAttribute(ConstantUtil.DESCRIPTION, description1);
                    TagNode tagNode = parentNode.findNodesByTagName(MetaParameterCollection.TAG_NAME).get(0);
                    tagNode.addNode(parameter);
                }
            }
        }
    }

    public static String getXmlTreeKey(Diff diff, String controlerType, String primaryKey) throws Throwable {
        XmlTreeWithPath xmlTree = diff.getXmlTree();
        MetaObjectType metaObjectType = diff.getMetaObjectType();
        if (metaObjectType == MetaObjectType.field
                || metaObjectType == MetaObjectType.panel
                || metaObjectType == MetaObjectType.subDetail
                || metaObjectType == MetaObjectType.grid
                || metaObjectType == MetaObjectType.D_DictView
                || metaObjectType == MetaObjectType.listView) {// 面板字段
            String buddyKey = "";
            String name = diff.properties.get(0).property.name;
            String controlType = ControlType.toString(diff.getControlType());
            TagNode fieldNode = xmlTree.xmlTree.getTagNode(controlType + "@" + diff.getKey());
            if (fieldNode != null) {
                buddyKey = fieldNode.getAttributes().get(ConstantUtil.BUDDY_KEY);
            }
            if (ControlType.STR_LABEL.equals(controlType)) { // label
                if (Property.key.name.equalsIgnoreCase(name)) {
                    String orgVal = diff.properties.get(0).orgValue;
                    return new StringBuilder().append(controlType).append("@").append(orgVal).toString();
                } else {
                    String key = diff.getKey();
                    return new StringBuilder().append(controlType).append("@").append(key).toString();
                }
            } else {
                if (Property.key.name.equalsIgnoreCase(name)) {// key label的key也要改
                    String orgVal = diff.properties.get(0).orgValue;
                    StringBuilder fieldString = new StringBuilder().append(controlType).append("@").append(orgVal);
                    TagNode coluNode = xmlTree.xmlTree.getTagNode(fieldString.toString());
                    if (Objects.isNull(coluNode)) {
                        throw new Throwable("warning: 不能修改!");
                    }
                    String key = coluNode.getAttributes().get(ConstantUtil.BUDDY_KEY);
                    if (StringUtils.isBlank(key)) {
                        return fieldString.toString();
                    }
                    StringBuilder labString = new StringBuilder().append(ConstantUtil.LABEL).append("@").append(key);
                    return labString.append(",").append(fieldString).toString();
                } else if (Property.BuddyKey.name.equalsIgnoreCase(name)) {// key label的key也要改
                    StringBuilder fieldString = new StringBuilder().append(controlType).append("@").append(diff.getKey());
                    TagNode coluNode = xmlTree.xmlTree.getTagNode(fieldString.toString());
                    if (Objects.isNull(coluNode)) {
                        throw new Throwable("不能修改!");
                    }
                    StringBuilder labString = new StringBuilder().append(ConstantUtil.LABEL).append("@").append(buddyKey);
                    return labString.append(",").append(fieldString).toString();
                } else if (Property.buddyCaption.name.equalsIgnoreCase(name)
                        || Property.buddyX.name.equalsIgnoreCase(name) || Property.buddyY.name.equalsIgnoreCase(name)) {
                    return new StringBuilder().append(ConstantUtil.LABEL).append("@").append(buddyKey).toString();
                } else {
                    String key = diff.getKey();
                    return new StringBuilder().append(controlType).append("@").append(key).toString();
                }
            }

        } else if ((metaObjectType == MetaObjectType.gridField && diff.properties.size() > 0)
                || metaObjectType == MetaObjectType.GridCellType) {// 表格字段
            String name = diff.properties.get(0).property.name;
            if (Property.key.name.equalsIgnoreCase(name)) {
                String orgVal = diff.properties.get(0).orgValue;
                StringBuilder CellPrimary = new StringBuilder().append(ConstantUtil.GRID_CELL).append("@").append(orgVal);
                StringBuilder ColumnPrimary = new StringBuilder().append(ConstantUtil.GRID_COLUMN).append("@").append(orgVal);
                return CellPrimary.append(",").append(ColumnPrimary).toString();
            } else {
                String key = diff.getKey();
                if (Property.visible.name.equalsIgnoreCase(name)) {
                    return new StringBuilder().append(ConstantUtil.GRID_COLUMN).append("@").append(key).toString();
                } else if (Property.caption.name.equalsIgnoreCase(name)) {
                    StringBuilder CellPrimary = new StringBuilder().append(ConstantUtil.GRID_CELL).append("@").append(key);
                    StringBuilder ColumnPrimary = new StringBuilder().append(ConstantUtil.GRID_COLUMN).append("@").append(key);
                    return CellPrimary.append(",").append(ColumnPrimary).toString();
                } else { // 单元格属性 enable columnkey required defaultvalue defaultforval valchanged..
                    return new StringBuilder().append(ConstantUtil.GRID_CELL).append("@").append(key).toString();
                }
            }
        } else if (metaObjectType == MetaObjectType.listViewField) {// ListView字段
            String name = diff.properties.get(0).property.name;
            if (Property.key.name.equalsIgnoreCase(name)) {
                String orgVal = diff.properties.get(0).orgValue;
                return new StringBuilder().append(ConstantUtil.LIST_VIEW_COLUMN).append("@").append(orgVal).toString();
            } else {
                String key = diff.getKey();
                if (Property.visible.name.equalsIgnoreCase(name)) {
                    return new StringBuilder().append(ConstantUtil.LIST_VIEW_COLUMN).append("@").append(key).toString();
                } else if (Property.caption.name.equalsIgnoreCase(name)) {
                    return new StringBuilder().append(ConstantUtil.LIST_VIEW_COLUMN).append("@").append(key).toString();
                } else { // 单元格属性 enable columnkey required defaultvalue defaultforval valchanged..
                    return new StringBuilder().append(ConstantUtil.LIST_VIEW_COLUMN).append("@").append(key).toString();
                }
            }
        } else if (metaObjectType == MetaObjectType.operationCollection || metaObjectType == MetaObjectType.operation) {
            String key = !ConstantUtil.KEY.equals(diff.properties.get(0).property.name) ? diff.getKey() : primaryKey;
            StringBuilder optPrimary = new StringBuilder().append(MetaObjectType.operation.name).append("@")
                    .append(key);
            StringBuilder colPrimary = new StringBuilder().append(MetaObjectType.operationCollection.name).append("@")
                    .append(key);
            return optPrimary.append(",").append(colPrimary).toString();
        } else if (metaObjectType == MetaObjectType.toolbar) {//toolbar
            String orgVal = diff.properties.get(0).orgValue;
            if (ConstantUtil.CAPTION.equals(diff.properties.get(0).property.name)) {
                return new StringBuilder().append(ConstantUtil.TOOL_BAR).append("@").append(diff.getKey()).toString();
            } else {
                return new StringBuilder().append(ConstantUtil.TOOL_BAR).append("@").append(orgVal).toString();
            }

        } else if (metaObjectType == MetaObjectType.ToolBar) {//newToolbar
            return new StringBuilder().append(ConstantUtil.TOOL_BAR).append("@").toString();

        } else if (MetaObjectType.GridHeadColumn.equals(metaObjectType)) {
            if (diff.properties.get(0).property.name.equals(ConstantUtil.KEY)) {
                return "GridColumn@" + diff.properties.get(0).orgValue;
            }
            return "GridColumn@" + diff.getKey();
        } else {
            return new StringBuilder().append(controlerType).append("@").append(primaryKey).toString();
        }

    }

    private static void dealFieldTable(XmlTreeWithPath xmlTree, String controlerType, DataTable fieldTable, Diff diff,
                                       TagNode parentNode, long parentOID, MetaDataObject curDataObject) throws Throwable {
        controlerType = MetaObjectType.column.name;
        fieldTable.setShowDeleted(true);
        parentNode.deleteChildByTagName(ConstantUtil.COLUMN);
        String tableKey = parentNode.getAttributes().get(ConstantUtil.KEY);
        List<AbstractNode> children = parentNode.getChildren();
        children.clear();
        int index = 0;
        for (int i = 0; i < fieldTable.size(); i++) {
            int rowState = fieldTable.getState(i);
            String orgColKey = (String) fieldTable.getOriginalObject(i, ConstantUtil.COLUMN_KEY);
            Long rowPOID = fieldTable.getLong(i, ConstantUtil.POID);
            String ColumnKey = fieldTable.getString(i, ConstantUtil.COLUMN_KEY).trim();
            String ColumnName = fieldTable.getString(i, "ColumnName").replaceAll("\r", "");
            Integer ColumnType = fieldTable.getInt(i, ConstantUtil.COLUMN_TYPE);
//            String TableColumnName = fieldTable.getString(i, "TableColumnName");
            // 针对系统字段，同样也适用于普通字段
            if (parentOID == rowPOID && RowState.DELETED != rowState) {
                boolean isDictCol = false;
                if (!orgColKey.equalsIgnoreCase(ColumnKey)) {
                    if (!ConstantUtil.DATA_OBJECT.equalsIgnoreCase(diff.getReserveOne())) {
                        MetaFormHelper.updateColumnKey(diff, orgColKey, ColumnKey);
                    }
                    isDictCol = changeDictBinding(diff, fieldTable, orgColKey, ColumnKey, ColumnName);
                }
                boolean contains = false;
                // 判断当前添加的字段已经在表中存在
                List<TagNode> column = parentNode.findNodesByTagName(ConstantUtil.COLUMN);
                for (TagNode tagNode : column) {
                    if (tagNode.getAttributes().get(ConstantUtil.KEY).equals(ColumnKey)) {
                        contains = true;
                        break;
                    }
                }
                if (!contains) {
                    TagNode node = new TagNode(controlerType, null);
                    node.setAttribute(ConstantUtil.KEY, ColumnKey);
                    node.setAttribute(ConstantUtil.CAPTION, ColumnName);
                    node.setAttribute(ConstantUtil.DATA_TYPE, DataType.toString(ColumnType));
                    node.setAttribute(ConstantUtil.DB_COLUMN_NAME, fieldTable.getString(i, ConstantUtil.DB_COLUMN_NAME));
                    MetaForm metaForm = diff.getMetaForm();
                    MetaTable table;
                    if (Objects.isNull(metaForm)) {
                        table = curDataObject.getTable(tableKey);
                    } else {
                        table = metaForm.getDataSource().getDataObject().getTable(tableKey);
                    }
                    if (table != null) {
                        MetaColumn metaColumn = table.get(orgColKey);
                        String defaultValue = null;
                        if (metaColumn != null) {
                            defaultValue = metaColumn.getDefaultValue();
                        }
                        if (StringUtils.isBlank(defaultValue)) {
                            (node).setAttribute("DefaultValue", fieldTable.getString(i, "DefaultValue"));
                        } else {
                            node.setAttributeNotRemove("DefaultValue", fieldTable.getString(i, "DefaultValue"));
                        }
                    } else {
                        (node).setAttribute("DefaultValue", fieldTable.getString(i, "DefaultValue"));
                    }
                    (node).setAttribute(ConstantUtil.DESCRIPTION, fieldTable.getString(i, ConstantUtil.DESCRIPTION));
                    (node).setAttribute(ConstantUtil.LENGTH, fieldTable.getString(i, ConstantUtil.LENGTH));
                    if ("0".equalsIgnoreCase((node).getAttributes().get(ConstantUtil.LENGTH)) || !StringUtils.isNotEmpty((node).getAttributes().get(ConstantUtil.LENGTH))) {
                        (node).getAttributes().remove(ConstantUtil.LENGTH);
                    }
                    (node).setAttribute(ConstantUtil.DESCRIPTION, fieldTable.getString(i, ConstantUtil.DESCRIPTION));
                    if (!StringUtils.isNotEmpty(node.getAttributes().get(ConstantUtil.DESCRIPTION))) {
                        (node).getAttributes().remove(ConstantUtil.DESCRIPTION);
                    }
                    (node).setAttribute("Precision", fieldTable.getString(i, "Precision"));
                    if ("0".equalsIgnoreCase((node).getAttributes().get("Precision")) || !StringUtils.isNotEmpty((node).getAttributes().get("Precision"))) {
                        (node).getAttributes().remove("Precision");
                    }
                    (node).setAttribute("Scale", fieldTable.getString(i, "Scale"));
                    if ("0".equalsIgnoreCase((node).getAttributes().get("Scale")) || !StringUtils.isNotEmpty((node).getAttributes().get("Scale"))) {
                        ((TagNode) node).getAttributes().remove("Scale");
                    }
                    if (RowState.NEW != rowState) {
                        (node).setAttribute("Persist", fieldTable.getInt(i, "Persist") == 0 ? "false" : "true");
                    }
                    (node).setAttribute(ConstantUtil.IS_PRIMARY, fieldTable.getInt(i, ConstantUtil.IS_PRIMARY) == 0 ? "false" : "true");
                    (node).setAttribute("Expand", fieldTable.getInt(i, "Expand") == 0 ? "false" : "true");
                    (node).setAttribute("AccessControl", fieldTable.getInt(i, "AccessControl") == 0 ? "false" : "true");
                    (node).setAttribute("IgnoreQuery", fieldTable.getInt(i, "IgnoreQuery") == 0 ? "false" : "true");
                    if ("false".equalsIgnoreCase(((TagNode) node).getAttributes().get("IgnoreQuery")) || !StringUtils.isNotEmpty((node).getAttributes().get("IgnoreQuery"))) {
                        (node).getAttributes().remove("IgnoreQuery");
                    }
                    (node).setAttribute("IgnoreSave", fieldTable.getInt(i, "IgnoreSave") == 0 ? "false" : "true");
                    (node).setAttribute(ConstantUtil.CACHE, fieldTable.getInt(i, ConstantUtil.CACHE) == 0 ? "false" : "true");
                    if ("false".equalsIgnoreCase(((TagNode) node).getAttributes().get(ConstantUtil.CACHE)) || !StringUtils.isNotEmpty((node).getAttributes().get(ConstantUtil.CACHE))) {
                        ((TagNode) node).getAttributes().remove(ConstantUtil.CACHE);
                    }
                    (node).setAttribute("Hidden", fieldTable.getInt(i, "Hidden") == 0 ? "false" : "true");
                    (node).setAttribute(ConstantUtil.SORT_TYPE, StringUtils.isNotEmpty(fieldTable.getString(i, ConstantUtil.SORT_TYPE)) ? SortType.toString(Integer.valueOf(fieldTable.getString(i, ConstantUtil.SORT_TYPE))) : "");
                    (node).setAttribute(ConstantUtil.PERIOD_GRANULARITY, StringUtils.isNotEmpty(fieldTable.getString(i, ConstantUtil.PERIOD_GRANULARITY)) ? DMPeriodGranularityType.toString(Integer.valueOf(fieldTable.getString(i, ConstantUtil.PERIOD_GRANULARITY))) : "");
                    String needRightsType = fieldTable.getString(i, ConstantUtil.NEED_RIGHTS);
                    if (StringUtils.isNotEmpty(needRightsType)) {
                        String needRights = ColumnRightsType.toString(Integer.parseInt(needRightsType));
                        if ("True".equalsIgnoreCase(needRights)) {
                            // 绑定了这个字段的节点
                            List<TagNode> collect = (List<TagNode>) (List) diff.getXmlTree().xmlTree.getMapNodes().values().stream().filter(
                                    n -> ((TagNode) n).getChildrenByTagName(MetaDataBinding.TAG_NAME).size() > 0 &&
                                            ((TagNode) n).getOrCreateChildByTagName(MetaDataBinding.TAG_NAME).getAttributes().get(ConstantUtil.COLUMN_KEY).equalsIgnoreCase(ColumnKey)
                            ).collect(Collectors.toList());
                            for (TagNode tagNode : collect) {
                                if ("true".equalsIgnoreCase(tagNode.getAttributes().get(Property.IgnoreRights.name))) {
                                    throw new Throwable("已在控件中设置忽略权限，不允许设置为检查权限！已撤销");
                                }
                            }
                            node.setAttribute(ConstantUtil.ITEM_KEY, fieldTable.getString(i, ConstantUtil.ITEM_KEY));
                        } else {
                            node.deleteAttribute(ConstantUtil.NEED_RIGHTS);
                            node.deleteAttribute(ConstantUtil.ITEM_KEY);
                        }
                        node.setAttribute(ConstantUtil.NEED_RIGHTS, needRights);
                    } else {
                        node.deleteAttribute(ConstantUtil.NEED_RIGHTS);
                        node.deleteAttribute(ConstantUtil.ITEM_KEY);
                    }
                    String supportI18n = fieldTable.getString(i, ConstantUtil.SUPPORT_I18N);
                    supportI18n = StringUtils.isBlank(supportI18n) ? "false" : supportI18n;
                    node.setAttribute(ConstantUtil.SUPPORT_I18N, supportI18n);
                    node.setAttribute(ConstantUtil.SPLIT_TYPE, StringUtils.isBlank(fieldTable.getString(i, ConstantUtil.SPLIT_TYPE)) ? "" : DataSplitType.toString(Integer.valueOf(fieldTable.getString(i, ConstantUtil.SPLIT_TYPE))));
                    node.setAttribute(ConstantUtil.GROUP_TYPE, StringUtils.isBlank(fieldTable.getString(i, ConstantUtil.GROUP_TYPE)) ? "" : fieldTable.getString(i, ConstantUtil.GROUP_TYPE));
                    if (isDictCol) {
                        String dictKey = ColumnKey.substring(0, ColumnKey.length() - 2);
                        node.setAttribute(ConstantUtil.CODE_COLUMN_KEY, dictKey + "Code");
                    } else {
                        node.setAttribute(ConstantUtil.CODE_COLUMN_KEY, !StringUtils.isNotEmpty(fieldTable.getString(i, ConstantUtil.CODE_COLUMN_KEY)) ? "" : fieldTable.getString(i, ConstantUtil.CODE_COLUMN_KEY));
                    }
                    if ("-1".equalsIgnoreCase(node.getAttributes().get(ConstantUtil.GROUP_TYPE))) {
                        node.getAttributes().remove(ConstantUtil.GROUP_TYPE);
                    }
                    try {
                        children.add(index, node);
                        index++;
                    } catch (Exception e) {
                        children.add(node);
                    }
                }
            }
        }
    }

    private static void dealPrimariyTable(XmlTreeWithPath xmlTree, String isPrimariy, Diff diff, TagNode curNode, String dataType) throws Throwable {
        if ("1".equals(isPrimariy) || "true".equals(isPrimariy)) {
            if (dataType.equalsIgnoreCase(DataObjectSecondaryType.STR_CHAINDICT) || dataType.equalsIgnoreCase(DataObjectSecondaryType.STR_DICT)) {
                if (!exist(curNode, ConstantUtil.COLUMN + "@" + "Code")) {
                    TagNode column = new TagNode(ConstantUtil.COLUMN, null);
                    column.setAttribute(ConstantUtil.KEY, "Code");
                    column.setAttribute(ConstantUtil.CAPTION, "代码");
                    column.setAttribute(ConstantUtil.DATA_TYPE, "Varchar");
                    column.setAttribute(ConstantUtil.LENGTH, "50");
                    curNode.addNode(column);
                }
                if (!exist(curNode, ConstantUtil.COLUMN + "@" + ConstantUtil.NAME)) {
                    TagNode column1 = new TagNode(ConstantUtil.COLUMN, null);
                    column1.setAttribute(ConstantUtil.KEY, ConstantUtil.NAME);
                    column1.setAttribute(ConstantUtil.CAPTION, "名称");
                    column1.setAttribute(ConstantUtil.DATA_TYPE, "Varchar");
                    column1.setAttribute(ConstantUtil.LENGTH, "100");
                    curNode.addNode(column1);
                }
                if (!exist(curNode, ConstantUtil.COLUMN + "@" + ConstantUtil.ENABLE)) {
                    TagNode column2 = new TagNode(ConstantUtil.COLUMN, null);
                    column2.setAttribute(ConstantUtil.KEY, ConstantUtil.ENABLE);
                    column2.setAttribute(ConstantUtil.CAPTION, "启用标记");
                    column2.setAttribute(ConstantUtil.DATA_TYPE, "Integer");
                    curNode.addNode(column2);
                }
                if (!exist(curNode, ConstantUtil.COLUMN + "@" + "ParentID")) {
                    TagNode column3 = new TagNode(ConstantUtil.COLUMN, null);
                    column3.setAttribute(ConstantUtil.KEY, "ParentID");
                    column3.setAttribute(ConstantUtil.CAPTION, "父节点");
                    column3.setAttribute(ConstantUtil.DATA_TYPE, "Long");
                    curNode.addNode(column3);
                }
                if (!exist(curNode, ConstantUtil.COLUMN + "@" + "NodeType")) {
                    TagNode column4 = new TagNode(ConstantUtil.COLUMN, null);
                    column4.setAttribute(ConstantUtil.KEY, "NodeType");
                    column4.setAttribute(ConstantUtil.CAPTION, "节点类型");
                    column4.setAttribute(ConstantUtil.DATA_TYPE, "Integer");
                    curNode.addNode(column4);
                }
                if (!exist(curNode, ConstantUtil.COLUMN + "@" + "TLeft")) {
                    TagNode column5 = new TagNode(ConstantUtil.COLUMN, null);
                    column5.setAttribute(ConstantUtil.KEY, "TLeft");
                    column5.setAttribute(ConstantUtil.CAPTION, "TLeft");
                    column5.setAttribute(ConstantUtil.DATA_TYPE, "Integer");
                    curNode.addNode(column5);
                }
                if (!exist(curNode, ConstantUtil.COLUMN + "@" + "TRight")) {
                    TagNode column6 = new TagNode(ConstantUtil.COLUMN, null);
                    column6.setAttribute(ConstantUtil.KEY, "TRight");
                    column6.setAttribute(ConstantUtil.CAPTION, "TRight");
                    column6.setAttribute(ConstantUtil.DATA_TYPE, "Integer");
                    curNode.addNode(column6);
                }
                if (!exist(curNode, ConstantUtil.COLUMN + "@" + "ForeignName")) {
                    TagNode column7 = new TagNode(ConstantUtil.COLUMN, null);
                    column7.setAttribute(ConstantUtil.KEY, "ForeignName");
                    column7.setAttribute(ConstantUtil.CAPTION, "名称(外文)");
                    column7.setAttribute(ConstantUtil.DATA_TYPE, "Varchar");
                    column7.setAttribute(ConstantUtil.LENGTH, "255");
                    curNode.addNode(column7);
                }
                MetaDataObject dataObject;
                if (Objects.isNull(diff.getMetaForm())) {
                    dataObject = MetaFactory.getGlobalInstance().getDataObject(diff.formKey);
                } else {
                    dataObject = diff.getMetaForm().getDataSource().getDataObject();
                }
//                String key = dataObject.getKey();
                for (MetaTable metaColumns : dataObject.getTableCollection()) {
                    String tableKey = metaColumns.getKey();
                    TagNode tableNode = xmlTree.xmlTree.getTagNode("Table@" + tableKey);
                    if (tableNode != null && !curNode.getAttributes().get(ConstantUtil.KEY).equals(tableKey)) {
/*
						if (XmlDiffProcessor.numberOfCitations("Code", key, key1) == 0) {
							detailnode.deleteChildByTagKey("Code");
						}
						if (XmlDiffProcessor.numberOfCitations(ConstantUtil.NAME, key, key1) == 0) {
							detailnode.deleteChildByTagKey(ConstantUtil.NAME);
						}
						if (XmlDiffProcessor.numberOfCitations(ConstantUtil.ENABLE, key, key1) == 0) {
							detailnode.deleteChildByTagKey(ConstantUtil.ENABLE);
						}
						if (XmlDiffProcessor.numberOfCitations("ParentID", key, key1) == 0) {
							detailnode.deleteChildByTagKey("ParentID");
						}
						if (XmlDiffProcessor.numberOfCitations("TLeft", key, key1) == 0) {
							detailnode.deleteChildByTagKey("TLeft");
						}
						if (XmlDiffProcessor.numberOfCitations("TRight", key, key1) == 0) {
							detailnode.deleteChildByTagKey("TRight");
						}
						if (XmlDiffProcessor.numberOfCitations("NodeType", key, key1) == 0) {
							detailnode.deleteChildByTagKey("NodeType");
						}
						if (XmlDiffProcessor.numberOfCitations("ForeignName", key, key1) == 0) {
							detailnode.deleteChildByTagKey("ForeignName");
						}
						if (XmlDiffProcessor.numberOfCitations("DocumentNumber", key, key1) == 0) {
							detailnode.deleteChildByTagKey("DocumentNumber");
						}
						if (XmlDiffProcessor.numberOfCitations(ConstantUtil.STATUS, key, key1) == 0) {
							detailnode.deleteChildByTagKey(ConstantUtil.STATUS);
						}
						if (XmlDiffProcessor.numberOfCitations("BillDate", key, key1) == 0) {
							detailnode.deleteChildByTagKey("BillDate");
						}
						if (XmlDiffProcessor.numberOfCitations("Creator", key, key1) == 0) {
							detailnode.deleteChildByTagKey("Creator");
						}
						if (XmlDiffProcessor.numberOfCitations("CreateTime", key, key1) == 0) {
							detailnode.deleteChildByTagKey("CreateTime");
						}
						if (XmlDiffProcessor.numberOfCitations("Modifier", key, key1) == 0) {
							detailnode.deleteChildByTagKey("Modifier");
						}
						if (XmlDiffProcessor.numberOfCitations("ModifyTime", key, key1) == 0) {
							detailnode.deleteChildByTagKey("ModifyTime");
						}
						if (XmlDiffProcessor.numberOfCitations("ClientID", key, key1) == 0) {
							detailnode.deleteChildByTagKey("ClientID");
						}
						if (XmlDiffProcessor.numberOfCitations("Notes", key, key1) == 0) {
							detailnode.deleteChildByTagKey("Notes");
						}*/
                    }
                }
            } else {
                // 对主表添加字段
                HashSet<String> contains = new HashSet<>();
                List<AbstractNode> tmpNodeList = new ArrayList<>();
                String controlerType = ConstantUtil.COLUMN;
                List<TagNode> column = curNode.findNodesByTagName(ConstantUtil.COLUMN);
                for (TagNode tagNode : column) {
                    if (ConstantUtil.PRIMARY_TABLE_FIELDS.contains(tagNode.getAttributes().get(ConstantUtil.KEY))) {
                        contains.add(tagNode.getAttributes().get(ConstantUtil.KEY));
                    }
                }
                if (!contains.contains(ConstantUtil.DOCUMENT_NUMBER)) {
                    TagNode node = new TagNode(controlerType, null);
                    node.setAttribute(ConstantUtil.KEY, ConstantUtil.DOCUMENT_NUMBER);
                    node.setAttribute(ConstantUtil.CAPTION, ConstantUtil.STR_DOCUMENT_NUMBER);
                    node.setAttribute(ConstantUtil.DATA_TYPE, DataType.toString(1002));
                    (node).setAttribute(ConstantUtil.LENGTH, "50");
                    tmpNodeList.add(node);
                }
                if (!contains.contains(ConstantUtil.STATUS)) {
                    TagNode node = new TagNode(controlerType, null);
                    node.setAttribute(ConstantUtil.KEY, ConstantUtil.STATUS);
                    node.setAttribute(ConstantUtil.CAPTION, ConstantUtil.STR_STATUS);
                    node.setAttribute(ConstantUtil.DATA_TYPE, DataType.toString(1001));
                    tmpNodeList.add(node);
                }
                if (!contains.contains(ConstantUtil.CREATOR)) {
                    TagNode node = new TagNode(controlerType, null);
                    node.setAttribute(ConstantUtil.KEY, ConstantUtil.CREATOR);
                    node.setAttribute(ConstantUtil.CAPTION, ConstantUtil.STR_CREATOR);
                    node.setAttribute(ConstantUtil.DATA_TYPE, DataType.toString(1010));
                    tmpNodeList.add(node);
                }
                if (!contains.contains(ConstantUtil.CREATE_TIME)) {
                    TagNode node = new TagNode(controlerType, null);
                    node.setAttribute(ConstantUtil.KEY, ConstantUtil.CREATE_TIME);
                    node.setAttribute(ConstantUtil.CAPTION, ConstantUtil.STR_CREATE_TIME);
                    node.setAttribute(ConstantUtil.DATA_TYPE, DataType.toString(1004));
                    tmpNodeList.add(node);
                }
                if (!contains.contains(ConstantUtil.MODIFIER)) {
                    TagNode node = new TagNode(controlerType, null);
                    node.setAttribute(ConstantUtil.KEY, ConstantUtil.MODIFIER);
                    node.setAttribute(ConstantUtil.CAPTION, ConstantUtil.STR_MODIFIER);
                    node.setAttribute(ConstantUtil.DATA_TYPE, DataType.toString(1010));
                    tmpNodeList.add(node);
                }
                if (!contains.contains(ConstantUtil.MODIFY_TIME)) {
                    TagNode node = new TagNode(controlerType, null);
                    node.setAttribute(ConstantUtil.KEY, ConstantUtil.MODIFY_TIME);
                    node.setAttribute(ConstantUtil.CAPTION, ConstantUtil.STR_MODIFY_TIME);
                    node.setAttribute(ConstantUtil.DATA_TYPE, DataType.toString(1004));
                    tmpNodeList.add(node);
                }
                if (!contains.contains(ConstantUtil.CLIENT_ID)) {
                    TagNode node = new TagNode(controlerType, null);
                    node.setAttribute(ConstantUtil.KEY, ConstantUtil.CLIENT_ID);
                    node.setAttribute(ConstantUtil.CAPTION, ConstantUtil.STR_CLIENT_ID);
                    node.setAttribute(ConstantUtil.DATA_TYPE, DataType.toString(1010));
                    tmpNodeList.add(node);
                }

                List<AbstractNode> children = curNode.getChildren();
                children.addAll(tmpNodeList);
            }
            curNode.getParent().getParent().getAttributes().put(ConstantUtil.PRIMARY_TABLE_KEY, curNode.getAttributes().get(ConstantUtil.KEY));
        } else {
            MetaDataObject dataObject = null;
            if (ConstantUtil.DATA_OBJECT.equalsIgnoreCase(diff.getReserveOne())) {
                dataObject = diff.getDataObject();

            } else {
                dataObject = diff.getMetaForm().getDataSource().getDataObject();
            }
            String key = dataObject.getKey();
            if (dataType.equalsIgnoreCase(DataObjectSecondaryType.STR_CHAINDICT) || dataType.equalsIgnoreCase(DataObjectSecondaryType.STR_DICT)) {
                /*if (XmlDiffProcessor.numberOfCitations("Code", key, curNode.getAttributes().get(ConstantUtil.KEY)) == 0) {
					curNode.deleteChildByTagKey("Code");
				}
				if (XmlDiffProcessor.numberOfCitations(ConstantUtil.NAME, key, curNode.getAttributes().get(ConstantUtil.KEY)) == 0) {
					curNode.deleteChildByTagKey(ConstantUtil.NAME);
				}
				if (XmlDiffProcessor.numberOfCitations(ConstantUtil.ENABLE, key, curNode.getAttributes().get(ConstantUtil.KEY)) == 0) {
					curNode.deleteChildByTagKey(ConstantUtil.ENABLE);
				}
				if (XmlDiffProcessor.numberOfCitations("ParentID", key, curNode.getAttributes().get(ConstantUtil.KEY)) == 0) {
					curNode.deleteChildByTagKey("ParentID");
				}
				if (XmlDiffProcessor.numberOfCitations("TLeft", key, curNode.getAttributes().get(ConstantUtil.KEY)) == 0) {
					curNode.deleteChildByTagKey("TLeft");
				}
				if (XmlDiffProcessor.numberOfCitations("TRight", key, curNode.getAttributes().get(ConstantUtil.KEY)) == 0) {
					curNode.deleteChildByTagKey("TRight");
				}
				if (XmlDiffProcessor.numberOfCitations("NodeType", key, curNode.getAttributes().get(ConstantUtil.KEY)) == 0) {
					curNode.deleteChildByTagKey("NodeType");
				}
				if (XmlDiffProcessor.numberOfCitations("ForeignName", key, curNode.getAttributes().get(ConstantUtil.KEY)) == 0) {
					curNode.deleteChildByTagKey("ForeignName");
				}
				if (XmlDiffProcessor.numberOfCitations("DocumentNumber", key, curNode.getAttributes().get(ConstantUtil.KEY)) == 0) {
					curNode.deleteChildByTagKey("DocumentNumber");
				}
				if (XmlDiffProcessor.numberOfCitations(ConstantUtil.STATUS, key, curNode.getAttributes().get(ConstantUtil.KEY)) == 0) {
					curNode.deleteChildByTagKey(ConstantUtil.STATUS);
				}
				if (XmlDiffProcessor.numberOfCitations("BillDate", key, curNode.getAttributes().get(ConstantUtil.KEY)) == 0) {
					curNode.deleteChildByTagKey("BillDate");
				}
				if (XmlDiffProcessor.numberOfCitations("Creator", key, curNode.getAttributes().get(ConstantUtil.KEY)) == 0) {
					curNode.deleteChildByTagKey("Creator");
				}
				if (XmlDiffProcessor.numberOfCitations("CreateTime", key, curNode.getAttributes().get(ConstantUtil.KEY)) == 0) {
					curNode.deleteChildByTagKey("CreateTime");
				}
				if (XmlDiffProcessor.numberOfCitations("Modifier", key, curNode.getAttributes().get(ConstantUtil.KEY)) == 0) {
					curNode.deleteChildByTagKey("Modifier");
				}
				if (XmlDiffProcessor.numberOfCitations("ModifyTime", key, curNode.getAttributes().get(ConstantUtil.KEY)) == 0) {
					curNode.deleteChildByTagKey("ModifyTime");
				}
				if (XmlDiffProcessor.numberOfCitations("ClientID", key, curNode.getAttributes().get(ConstantUtil.KEY)) == 0) {
					curNode.deleteChildByTagKey("ClientID");
				}
				if (XmlDiffProcessor.numberOfCitations("Notes", key, curNode.getAttributes().get(ConstantUtil.KEY)) == 0) {
					curNode.deleteChildByTagKey("Notes");
				}*/
            } else if (curNode != null) { // 非主表删除主表字段
                if (XmlDiffProcessor.fieldHastRely(ConstantUtil.DOCUMENT_NUMBER, key, curNode.getAttributes().get(ConstantUtil.KEY))) {
                    curNode.deleteChildByTagKey(ConstantUtil.DOCUMENT_NUMBER);
                }
                if (XmlDiffProcessor.fieldHastRely(ConstantUtil.STATUS, key, curNode.getAttributes().get(ConstantUtil.KEY))) {
                    curNode.deleteChildByTagKey(ConstantUtil.STATUS);
                }
                if (XmlDiffProcessor.fieldHastRely(ConstantUtil.DOCUMENT_DATE, key, curNode.getAttributes().get(ConstantUtil.KEY))) {
                    curNode.deleteChildByTagKey(ConstantUtil.DOCUMENT_DATE);
                }
                if (XmlDiffProcessor.fieldHastRely(ConstantUtil.CREATOR, key, curNode.getAttributes().get(ConstantUtil.KEY))) {
                    curNode.deleteChildByTagKey(ConstantUtil.CREATOR);
                }
                if (XmlDiffProcessor.fieldHastRely(ConstantUtil.CREATE_TIME, key, curNode.getAttributes().get(ConstantUtil.KEY))) {
                    curNode.deleteChildByTagKey(ConstantUtil.CREATE_TIME);
                }
                if (XmlDiffProcessor.fieldHastRely(ConstantUtil.MODIFIER, key, curNode.getAttributes().get(ConstantUtil.KEY))) {
                    curNode.deleteChildByTagKey(ConstantUtil.MODIFIER);
                }
                if (XmlDiffProcessor.fieldHastRely(ConstantUtil.MODIFY_TIME, key, curNode.getAttributes().get(ConstantUtil.KEY))) {
                    curNode.deleteChildByTagKey(ConstantUtil.MODIFY_TIME);
                }
                if (XmlDiffProcessor.fieldHastRely(ConstantUtil.CLIENT_ID, key, curNode.getAttributes().get(ConstantUtil.KEY))) {
                    curNode.deleteChildByTagKey(ConstantUtil.CLIENT_ID);
                }
                if (XmlDiffProcessor.fieldHastRely(ConstantUtil.NOTES, key, curNode.getAttributes().get(ConstantUtil.KEY))) {
                    curNode.deleteChildByTagKey(ConstantUtil.NOTES);
                }
            }

        }
    }

    private static void replaceTableKey(Diff diff, String orgTableKey, String tableKey) throws Throwable {
        MetaFormHelper.updateTableKey(diff, orgTableKey, tableKey);

        XmlTree xmlTree = diff.getXmlTree().xmlTree;
        TagNode dataNode = xmlTree.getRoot().getChildByTagName("DataSource");
        TagNode dataObjectNode = null;
        if (MetaObjectType.DataObject.name.equalsIgnoreCase(diff.getMetaObjectType().name)) {
            dataObjectNode = xmlTree.getRoot();
        } else {
            dataObjectNode = dataNode.findFirstTagNodeByTagName(ConstantUtil.DATA_OBJECT);
        }
        if (dataObjectNode.getAttributes().get(ConstantUtil.PRIMARY_TABLE_KEY) != null) {
            if (dataObjectNode.getAttributes().get(ConstantUtil.PRIMARY_TABLE_KEY).equalsIgnoreCase(orgTableKey)) {
                dataObjectNode.setAttribute(ConstantUtil.PRIMARY_TABLE_KEY, tableKey);
            }
        }
        List<TagNode> tableList = dataObjectNode.findNodesByTagName(ConstantUtil.TABLE);
        for (TagNode tagNode : tableList) {
            if (tagNode.getAttributes().get(ConstantUtil.PARENT_KEY) != null) {
                if (tagNode.getAttributes().get(ConstantUtil.PARENT_KEY).equalsIgnoreCase(orgTableKey)) {
                    tagNode.setAttribute(ConstantUtil.PARENT_KEY, tableKey);
                }
            }
            if (tagNode.getAttributes().get(ConstantUtil.INDEX_PREFIX) != null) {
                if (tagNode.getAttributes().get(ConstantUtil.INDEX_PREFIX).equalsIgnoreCase(orgTableKey)) {
                    tagNode.setAttribute(ConstantUtil.INDEX_PREFIX, tableKey);
                }
            }
        }
    }

    private static Boolean changeDictBinding(Diff diff, DataTable fieldTable, String orgDictColKey, String dictColKey, String columnName) throws Throwable {
        XmlTree xmlTree = diff.getXmlTree().xmlTree;
        List<TagNode> columnNodeList = xmlTree.getRoot().findNodesByTagName("Column");
        String orgDictKey = orgDictColKey;
        String dictKey = dictColKey;
        if (orgDictColKey.toLowerCase().endsWith("id")) {
            orgDictKey = orgDictColKey.substring(0, orgDictColKey.length() - 2);
        }
        if (dictColKey.toLowerCase().endsWith("id")) {
            dictKey = dictColKey.substring(0, dictColKey.length() - 2);
        }
        boolean hasCodeColumn = false;
        for (TagNode columnNode : columnNodeList) {
            if (columnNode.getAttributes().get(ConstantUtil.KEY).equalsIgnoreCase(orgDictKey + "Code")) {
                columnNode.setAttribute(ConstantUtil.KEY, dictKey + "Code");
                columnNode.setAttribute(ConstantUtil.CAPTION, columnName);
                hasCodeColumn = true;
            }
            if (hasCodeColumn && columnNode.getAttributes().get(ConstantUtil.KEY).equalsIgnoreCase(dictColKey)) {
                columnNode.setAttribute(ConstantUtil.CODE_COLUMN_KEY, dictKey + "Code");
            }
        }
        if (!hasCodeColumn) {//DataObject
            for (int i = 0; i < fieldTable.size(); i++) {
                if (fieldTable.getString(i, ConstantUtil.COLUMN_KEY).trim().equalsIgnoreCase(orgDictKey + "Code")) {
                    fieldTable.setString(i, ConstantUtil.COLUMN_KEY, dictKey + "Code");
                    fieldTable.setString(i, "ColumnName", columnName);
                    hasCodeColumn = true;
                }
            }
        }
        return hasCodeColumn;
    }

    private String handleDataObjectByOidFilter(Diff diff, List<Diff> diffs, Document document) throws Throwable {
        if (!StringUtils.equals(MetaOIDFilter.TAG_NAME, diff.getReserveOne())) {
            return null;
        }
        String path = LoadFileTree.getPathByFormKey(diff.formKey);
        diff.setFilePath(path);
        String tmpPath = XmlFileProcessor.instance.getTmpFile(path);
        String filePath = StringUtils.isNotBlank(tmpPath) ? tmpPath : path;
        XmlTree xmlTree = Xml4jUtil.parseTree(filePath);
        if (Objects.isNull(xmlTree)) {
            String dataObjectPath = LoadFileTree.getPathByDataObject(path);
            xmlTree = Xml4jUtil.parseTree(dataObjectPath);
        }
        XmlDiffProcessor.dealEventTable(new XmlTreeWithPath(path, tmpPath, xmlTree), document, diff);
        XmlFileProcessor.instance.processDiff(diffs, false);
        DesignReloadMetaObject.reloadMetaFormRollbackError(null,diff.formKey);
        return path;
    }
}

class Line {
    final int pos;
    final String content;

    public Line(int pos, String content) {
        this.pos = pos;
        this.content = content;
    }
}
