package com.bokesoft.yes.design.dataMigration.util;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.design.datamap.util.DataMapOperJsonUtil;
import com.bokesoft.yes.design.datamap.util.DataMapOperXmlUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.erp.config.MetaFormNODBProcess;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigrationList;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigrationProfile;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.dom4j.Element;

import java.io.File;
import java.util.*;
import java.util.logging.Logger;

public class DataMigrationOperJsonUtil {
	private static final Logger logger = Logger.getLogger(DataMapOperJsonUtil.class.getName());
	/***xml扩展名*/
	private static final String XML_EXTENSION = ".xml";

	/**
	 * 新增数据映射创建XMl文件和tree
	 *
	 * @param projectKey    选择的工程名
	 * @param sourceFormKey 源FormKey
	 * @param targetFormKey 目标表单
	 * @param key           迁移标识
	 * @param caption       迁移名称
	 * @param version       版本号
	 * @return
	 */
	public Map<String, String> createDataMigrationXml(String projectKey, String sourceFormKey, String targetFormKey, String key, String caption, String extend, String version) {
		Map<String, String> result = new HashMap<>(10);
		String filePath = "";
		try {
			int verionNo = Integer.parseInt(version) + 1;
			String newFileName = key + XML_EXTENSION;
			//创建一个新的路径
			filePath = LoadFileTree.newDataMigration(projectKey, newFileName, key, caption);
			StringBuilder sb = new StringBuilder();
			sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n");
			sb.append("<DataMigration Caption=\"" + caption + "\" Key=\"" + key + "\"\n");
			sb.append("SrcDataObjectKey=\"" + sourceFormKey + "\" TgtDataObjectKey=\"" + targetFormKey + "\" ");
			if (StringUtils.isNotEmpty(extend)) {
				sb.append(" Extend=\"" + extend.split(" ")[0] +"\" ");
			}
			sb.append(">\n");
			sb.append("    <SourceTableCollection Height=\"60\" Width=\"296\" X=\"30\" Y=\"80\"/>\n");
			sb.append("    <TargetTableCollection Height=\"60\" Width=\"296\" X=\"457\" Y=\"80\"/>\n");
			sb.append("</DataMigration>\n");
			//创建一个初始的XMl Content
			String fileContent =  sb.toString();
			//生成一个临时文件
			XmlFileProcessor.instance.saveTempFile(filePath, fileContent,projectKey);
			//创建的时候直接生成文件夹
			FileUtils.writeStringToFile(new File(filePath), fileContent, "UTF-8");
			result.put("result", "true");
			result.put("filePath", filePath);
			result.put("version", String.valueOf(verionNo));
			result.put("fileName", newFileName.replaceAll(".xml", ""));
		} catch (Exception e) {
			logger.warning(e.getMessage());
		} catch (Throwable throwable) {
			logger.warning(throwable.getMessage());
		}
		return result;
	}

	/***
	 * 转换xml文件为json文件
	 * @param filePaths xml文件路径
	 *
	 */
	public JSONObject convertXmlToJson(String filePaths) throws Throwable {
		JSONObject workFlowJson = new JSONObject(new LinkedHashMap());
		String tmpFile = XmlFileProcessor.instance.getTmpFile(filePaths);
		if (StringUtils.isBlank(tmpFile)){
			tmpFile = filePaths;
		}
		Element root = DataMapOperJsonUtil.getElement(tmpFile);
		String extend = root.attributeValue("Extend");
		String caption = root.attributeValue(ConstantUtil.CAPTION);
		try {
			//源表单显示
			JSONObject source = setSourceFormJson(root);
			//目标表单显示
			JSONObject target = setTargetFormJson(root);
			// 连线列表json设置
			JSONObject paths = setPaths(root);
			// 设置迁移基本属性
			JSONObject workFlowDesc = setWorkFlowAttributes(root);
			// 数据迁移数据
			workFlowJson.put("paths", paths);
			workFlowJson.put(ConstantUtil.DATA_MIGRATIONPROPS, workFlowDesc);
			workFlowJson.put("extend", extend);
			workFlowJson.put("source", source);
			workFlowJson.put("target", target);
			workFlowJson.put(ConstantUtil.CAPTION, caption);
		} catch (Throwable e) {
			logger.warning("转换xml文件为json文件异常，异常为:" + ExceptionUtils.getStackTrace(e));
		}
		return workFlowJson;
	}
	/**
	 * 用于前端自动添加路径
	 */
	public JSONObject setPaths(Element root) {
		JSONObject pathJson = new JSONObject(new LinkedHashMap<>());
		JSONObject temp;
		//用于防止ID冲突
		int i = 1;
		//源单和目标表单的Formkey
		String srcDataObjectKey = root.attributeValue(ConstantUtil.SRC_DATA_OBJECT_KEY);
		String tgtDataObjectKey = root.attributeValue(ConstantUtil.TGT_DATA_OBJECT_KEY);
		//判断源单formKey和目标是否相同
		boolean isIdentical = srcDataObjectKey.equalsIgnoreCase(tgtDataObjectKey);
		if (isIdentical) {
			srcDataObjectKey = srcDataObjectKey + "__S";
			tgtDataObjectKey = tgtDataObjectKey + "__T";
		}
		List<Element> elements = root.element(ConstantUtil.SOURCE_TABLE_COLLECTION).elements(ConstantUtil.SOURCE_TABLE);
		//保存公式字段或者常量字段
		HashMap<String, Integer> listHashMap = new HashMap<>();
		int listHashMapi = -1;
		for (Element ele : elements) {
			List<Element> sourceField = ele.elements(ConstantUtil.SOURCE_FIELD);
			for (Element elefield : sourceField) {
				// 先将公式和常量字段过滤出来
				//不为空就是公式字段或者常量字段 或者是名称相同的字段
				if (elefield.attributeValue(ConstantUtil.TYPE) != null && !listHashMap.containsKey(elefield.attributeValue(ConstantUtil.DEFINITION))) {
					String definition = elefield.attributeValue(ConstantUtil.DEFINITION);
					listHashMap.put(definition, ++listHashMapi);
				}
				//判断 是否有目标字段,判断是不是普通字段而非公式或者常量字段
				if (elefield.attributeValue(ConstantUtil.TARGET_FIELD_KEY) != null&& !listHashMap.containsKey(elefield.attributeValue(ConstantUtil.DEFINITION))) {
					temp = new JSONObject(new LinkedHashMap<>());
					String tableKey = DataMapOperXmlUtil.getTableKey(ele);
					//模仿前端源单字段ID
					StringBuffer sourceID = new StringBuffer().append("F_").append(srcDataObjectKey)
							.append(elefield.attributeValue(ConstantUtil.DEFINITION))
							.append(tableKey);
					//处理目标字段
					isConstOrFormula(root, temp, tgtDataObjectKey, ele, elefield);
					temp.put("sourceEndpoint", sourceID);
					//判断当前path是不是关注字段
					if ("Focus".equalsIgnoreCase(elefield.attributeValue("EdgeType"))) {
						temp.put("EdgeType", "Focus");
					}
					//必须成对出现，不允许单条数据传到前端
					if (temp.size() > 1) {
						pathJson.put("path" + i, temp);
					}
					i++;
					//处理公式字段和常量字段
				} else if (elefield.attributeValue(ConstantUtil.TARGET_FIELD_KEY) != null &&
						listHashMap.containsKey(elefield.attributeValue(ConstantUtil.DEFINITION))) {
					temp = new JSONObject(new LinkedHashMap<>());
					//模仿前端公式和常量字段ID
					StringBuffer sourceConstAndFormula = null;
					//相同字段所用的sourceNumber应该相同
					String tableKey = DataMapOperXmlUtil.getTableKey(ele);
					int index = listHashMap.get(elefield.attributeValue(ConstantUtil.DEFINITION));

					sourceConstAndFormula = new StringBuffer().append("F_")
							.append(tableKey).append(srcDataObjectKey).append(index + 1);
					//处理目标字段
					isConstOrFormula(root, temp, tgtDataObjectKey, ele, elefield);
					temp.put("sourceEndpoint", sourceConstAndFormula);
					if ("Focus".equalsIgnoreCase(elefield.attributeValue("EdgeType"))) {
						temp.put("EdgeType", "Focus");
					}
					if (temp.size() > 1) {
						pathJson.put("path" + i, temp);
					}
					i++;
				}
			}
		}
		JSONObject setpathJson = new JSONObject(new LinkedHashMap<>());
		setpathJson.put("path", pathJson);
		return setpathJson;
	}
	/**
	 * 判断目标字段是不是普通字段
	 *
	 * @param root             节点
	 * @param temp             jsonObject
	 * @param tgtDataObjectKey 目标表单标识
	 * @param ele              表节点
	 * @param elefield         字段节点
	 * @return
	 */
	public void isConstOrFormula(Element root, JSONObject temp, String tgtDataObjectKey, Element ele, Element elefield) {
		//去判断目标字段是不是普通字段
		List<Element> elementList = root.element(ConstantUtil.TARGET_TABLE_COLLECTION).elements(ConstantUtil.TARGET_TABLE);
		ArrayList<String> list = new ArrayList<>();
		HashMap<String, Integer> listHashMap = new HashMap<>();
		int listHashMapi = -1;
		String targetTableKey = elefield.attributeValue(ConstantUtil.TARGET_TABLE_KEY);
		for (Element targetele : elementList) {
			//当为空的时候说明目标字段是源表绑定的目标表标识里面的字段
			if (StringUtils.isBlank(targetTableKey)) {
				targetTableKey = ele.attributeValue(ConstantUtil.TARGET_TABLE_KEY);
			}
			String tableKey = DataMapOperXmlUtil.getTableKey(targetele);
			if (tableKey.equalsIgnoreCase(targetTableKey)) {
				List<Element> targetField = targetele.elements(ConstantUtil.TARGET_FIELD);
				for (Element targetfield : targetField) {
					if (targetfield.attributeValue(ConstantUtil.TYPE) != null) {
						String fieldValue = DataMapOperXmlUtil.getFieldValue(targetfield);
						listHashMap.put(fieldValue, ++listHashMapi);
						list.add(fieldValue);
					}
					//获取字段值
					String fieldValue = DataMapOperXmlUtil.getFieldValue(targetfield);
					if (fieldValue.equalsIgnoreCase(elefield.attributeValue(ConstantUtil.TARGET_FIELD_KEY))) {
						if (("Const".equalsIgnoreCase(targetfield.attributeValue(ConstantUtil.TYPE))
								|| "Formula".equalsIgnoreCase(targetfield.attributeValue(ConstantUtil.TYPE)))) {
							int index = listHashMap.get(fieldValue);
							StringBuffer targetID = new StringBuffer().append("F_")
									.append(targetTableKey).append(tgtDataObjectKey).append(index + 1);
							temp.put("targetEndpoint", targetID);
						} else if (Objects.isNull(targetfield.attributeValue(ConstantUtil.TYPE))) {
							//模仿非公式和常量字段前端目标字段ID
							StringBuffer targetID = new StringBuffer().append("F_").append(tgtDataObjectKey)
									.append(elefield.attributeValue(ConstantUtil.TARGET_FIELD_KEY))
									.append(targetTableKey);
							temp.put("targetEndpoint", targetID);
						}
					}
				}
			}
		}
	}
	/**
	 * 根据XML总数据转换成Json返回给前端，用于前端动态添加表格
	 *
	 * @param root 节点
	 * @return
	 */
	public JSONObject setSourceFormJson(Element root) {
		//判断源表单和目标表单是否相同
		boolean isIdentical = root.attributeValue(ConstantUtil.SRC_DATA_OBJECT_KEY).equalsIgnoreCase(root.attributeValue(
				ConstantUtil.TGT_DATA_OBJECT_KEY));
		JSONObject setSourceFormJson = null;
		MetaDataObject metaDataObject = null;
		try {
			String key = ConstantUtil.DEFINITION;
			setSourceFormJson = new JSONObject(new LinkedHashMap());
			//这个集合的主要作用是防止数据相同字段重复添加
			HashMap<Object, Object> hashMap = new HashMap<>();
			JSONObject temp;
			Element sourceTableCollection = root.element(ConstantUtil.SOURCE_TABLE_COLLECTION);
			List<Element> sourceTable = sourceTableCollection.elements(ConstantUtil.SOURCE_TABLE);
			if (sourceTable.size() != 0) {
				for (Element Definition : sourceTable) {
					List<Element> SourceField = Definition.elements(ConstantUtil.SOURCE_FIELD);
					for (int i = 0; i < SourceField.size(); i++) {
						Element sourceField = SourceField.get(i);
						temp = new JSONObject(new LinkedHashMap());
						String srcDataObjectKey = root.attributeValue(ConstantUtil.SRC_DATA_OBJECT_KEY);
						metaDataObject = MetaFactory.getGlobalInstance().getDataObject(srcDataObjectKey);
						String tableKey = Definition.attributeValue(ConstantUtil.TABLE_KEY);
						if (tableKey == null){
							tableKey = Definition.attributeValue(ConstantUtil.KEY);
						}
						//如果来源表单和目标表单相同就增加特定标识
						if (isIdentical) {
							srcDataObjectKey = root.attributeValue(ConstantUtil.SRC_DATA_OBJECT_KEY) + "__S";
						}
						//防止添加重复数据
						if (!hashMap.containsKey(sourceField.attributeValue(ConstantUtil.DEFINITION) + tableKey)) {
							//获取当前XMl中的源单字段
							getSourceField(setSourceFormJson,
									temp, key, sourceField, srcDataObjectKey, metaDataObject, tableKey);
						}
						//每次添加完一条就在数据中加一条
						hashMap.put(sourceField.attributeValue(ConstantUtil.DEFINITION) + tableKey, sourceField.attributeValue(ConstantUtil.DEFINITION));
					}
				}
			}
		} catch (Throwable throwable) {
			logger.warning(throwable.getMessage());
		}
		JSONObject sourceJson = new JSONObject(new LinkedHashMap());
		sourceJson.put("source", setSourceFormJson);
		return sourceJson;
	}

	/**
	 * @param setSourceFormJson
	 * @param temp
	 * @param key
	 * @param sourceField
	 * @param srcDataObjectKey
	 * @param
	 * @param tableKey
	 * @return 获取源单中的字段
	 */
	public void getSourceField(JSONObject setSourceFormJson,
							   JSONObject temp,
							   String key,
							   Element sourceField,
							   String srcDataObjectKey,
							   MetaDataObject metaDataObject,
							   String tableKey) {
		MetaTable metaTable = null;
		MetaTableCollection metaTableCollection = null;
		metaTable = metaDataObject.getTable(tableKey);
		metaTableCollection = metaDataObject.getTableCollection();

		String definitionKey = sourceField.attributeValue(ConstantUtil.DEFINITION);
		MetaColumn metaColumn = null;
		metaColumn = metaTable.get(definitionKey);
		if (metaTable != null && !tableKey.contains(MetaFormNODBProcess.STR_NODBTable_Profix) && metaTableCollection != null) {
			//获取当前tableKey的位置
			int indexOf = metaTableCollection.indexOf(metaTable);
			String fieldCaption = null;
			if (metaColumn != null) {
				fieldCaption = metaColumn.getCaption();
			}
			//添加类型为公式的Field
			if (StringUtils.isNotEmpty(sourceField.attributeValue(ConstantUtil.TYPE))) {
				if (StringUtils.isBlank(definitionKey)) {
					definitionKey = "  ";
				}
				StringBuffer fieldValue = new StringBuffer().append((indexOf + 1)).append("_@_")
						.append(definitionKey).append("_@_").append("  ").append("_@_").append(tableKey).append("_@_").append(srcDataObjectKey);
				temp.put(ConstantUtil.DEFINITION, fieldValue);
			} else {
				//非公式字段数据处理
				StringBuffer fieldValue = new StringBuffer().append((indexOf + 1)).append("_@_")
						.append(definitionKey).append("_@_").append(StringUtils.isEmpty(fieldCaption) ? "SpecialField" : fieldCaption)
						.append("_@_").append(tableKey).append("_@_").append(srcDataObjectKey);
				temp.put(ConstantUtil.DEFINITION, fieldValue);
			}
			setSourceFormJson.put(key + (setSourceFormJson.size() + 1), temp);
		} else if (Objects.isNull(metaTable)) {
			definitionKey = sourceField.attributeValue(ConstantUtil.DEFINITION);
			//添加类型为公式的Field
			if (StringUtils.isNotEmpty(sourceField.attributeValue(ConstantUtil.TYPE))) {
				if (StringUtils.isBlank(definitionKey)) {
					definitionKey = "  ";
				}
				StringBuffer fieldValue = new StringBuffer().append((-1)).append("_@_")
						.append(definitionKey).append("_@_").append("  ").append("_@_").append(tableKey).append("_@_").append(srcDataObjectKey);
				temp.put(ConstantUtil.DEFINITION, fieldValue);
			} else {
				//非公式字段数据处理
				StringBuffer fieldValue = new StringBuffer().append((-1)).append("_@_")
						.append(definitionKey).append("_@_").append(" ")
						.append("_@_").append(tableKey).append("_@_").append(srcDataObjectKey);
				temp.put(ConstantUtil.DEFINITION, fieldValue);
			}
			setSourceFormJson.put(key + (setSourceFormJson.size() + 1), temp);
		}

	}

	public JSONObject setTargetFormJson(Element root) throws Throwable {
		boolean isIdentical =
				root.attributeValue(ConstantUtil.SRC_DATA_OBJECT_KEY).equalsIgnoreCase(root.attributeValue(ConstantUtil.TGT_DATA_OBJECT_KEY));
		String TgtDataObjectKey = root.attributeValue(ConstantUtil.TGT_DATA_OBJECT_KEY);
		MetaDataObject dataObject = MetaFactory.getGlobalInstance().getDataObject(TgtDataObjectKey);
		//判断源表单和目标表单是否相同
		if (isIdentical) {
			TgtDataObjectKey = root.attributeValue(ConstantUtil.TGT_DATA_OBJECT_KEY) + "__T";
		}
		JSONObject settargetFormJson = null;
		try {
			String key = ConstantUtil.DEFINITION;
			settargetFormJson = new JSONObject(new LinkedHashMap());
			JSONObject temp;
			Element targetTableCollection = root.element(ConstantUtil.TARGET_TABLE_COLLECTION);
			List<Element> targetTable = targetTableCollection.elements(ConstantUtil.TARGET_TABLE);
			if (targetTable.size() != 0) {
				for (Element Definition : targetTable) {
					List<Element> TargetField = Definition.elements(ConstantUtil.TARGET_FIELD);
					for (int i = 0; i < TargetField.size(); i++) {
						Element targetField = TargetField.get(i);
						temp = new JSONObject(new LinkedHashMap());
						String tableKey = Definition.attributeValue(ConstantUtil.TABLE_KEY);
						if (tableKey != null && tableKey.indexOf(MetaFormNODBProcess.STR_NODBTable_Profix) == -1) {
							MetaTable metaTable = dataObject.getTable(tableKey);
							//获取当前tableKey的位置
							int indexOf = 0;
							if (metaTable != null) {
								indexOf = dataObject.getTableCollection().indexOf(metaTable);
							}
							String definitionKey = targetField.attributeValue(ConstantUtil.FIELD_KEY);
							//当前字段的Caption
							String CoumnCaption = metaTable.get(definitionKey) != null ? metaTable.get(definitionKey).getCaption() : null;
							int groupType = -1;
							if (metaTable.get(definitionKey) != null) {
								groupType = metaTable.get(definitionKey).getGroupType();
							}
							//获取分组类型
							String fieldCaption = getGroupType(groupType);
							//非公式字段数据处理
							StringBuffer fieldValue = new StringBuffer().append((indexOf + 1)).append("_@_")
									.append(definitionKey).append("_@_").append(CoumnCaption + fieldCaption)
									.append("_@_").append(tableKey).append("_@_").append(TgtDataObjectKey).append("_@_").append("Migration");
							temp.put(ConstantUtil.FIELD_KEY, fieldValue);
							settargetFormJson.put(key + (settargetFormJson.size() + 1), temp);
						}
					}
				}
			}
		} catch (Throwable throwable) {
			logger.warning(throwable.getMessage());
		}
		JSONObject sourceJson = new JSONObject(new LinkedHashMap());
		sourceJson.put("target", settargetFormJson);
		return sourceJson;
	}

	//获取分组类型方法
	public static String getGroupType(int groupType) {
		String fieldCaption = "<无分组>";
		switch (groupType) {
			case -1:
				fieldCaption = "<无分组>";
				break;
			case 0:
				fieldCaption = "<直接量>";
				break;
			case 1:
				fieldCaption = "<期间分组>";
				break;
			default:
				break;
		}
		return fieldCaption;
	}

	/***
	 * 设置数据迁移基础属性
	 * @param root 根元素
	 * @return 设置后的JSON对象
	 */
	public JSONObject setWorkFlowAttributes(Element root) {
		List<String> keyList = Arrays.asList(ConstantUtil.KEY, ConstantUtil.CAPTION, ConstantUtil.DESCRIPTION,
				"sourceForm", "targetForm"
				, "StatusFieldKey", "StatusValue", "DetailCondition", "HeadCondition");
		JSONObject workFlowDescSub = new JSONObject(new LinkedHashMap());
		JSONObject temp;
		String value;
		for (String key : keyList) {
			value = root.attributeValue(key);
			temp = new JSONObject(new LinkedHashMap());
			if ("DetailCondition".equalsIgnoreCase(key)) {
				value = root.attributeValue("Condition");
			}
			if (key.equalsIgnoreCase("sourceForm")) {
				value = root.attributeValue(ConstantUtil.SRC_DATA_OBJECT_KEY);
			}
			if (key.equalsIgnoreCase("targetForm")) {
				value = root.attributeValue(ConstantUtil.TGT_DATA_OBJECT_KEY);
			}
			temp.put("value", value);
			workFlowDescSub.put(key, temp);
		}
		JSONObject workFlowDesc = new JSONObject(new LinkedHashMap());
		workFlowDesc.put(ConstantUtil.DATA_MIGRATIONPROPS, workFlowDescSub);
		return workFlowDesc;
	}

	public boolean existDataMigrationVest(String extend, IMetaFactory iMetaFactory) throws Throwable{
		MetaDataMigrationList dataMigrationList = iMetaFactory.getDataMigrationList();
		Iterator<MetaDataMigrationProfile> iterator = dataMigrationList.iterator();
		while (iterator.hasNext()){
			MetaDataMigrationProfile dataMigrationProfile = iterator.next();

			if (StringUtils.isEmpty(extend)) {
				break;
			}
			if (StringUtils.isEmpty(dataMigrationProfile.getDataMigration().getExtend())) {
				continue;
			}
			if (dataMigrationProfile.getDataMigration().getExtend().equals(extend.split(" ")[0])) {
				return true;
			}
		}
		return false;
	}

}
