package com.bokesoft.yes.design.codemirror;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.vo.Exp;
import com.bokesoft.yes.design.vo.Para;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.mid.base.CoreSetting;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/***
 * 从老的xml文件生成前端函数
 */
public class GenerateFrontFunsFromXml {

	public static void main(String[] args) {
		try {
			String fileName = "D:/SourceV2/erp-backend-starter/src/main/resources/yigo/properties/designer_formula.json";
			String path = "d:/express.xml";
//			generateFrontFunsJson(path,fileName);
		} catch (Throwable e) {
			LogSvr.getInstance().error(e.getMessage(), e);
		}
	}

	public static String generateFrontFunsJson(String formulaKey) throws Exception {
		//1.创建SAXReader对象用于读取xml文件
		SAXReader reader = new SAXReader();
		//2.读取xml文件，获得Document对象
		File pathFile = FileUtils.getFile(FilePathHelper.getCoreSolutionPath(), "Formula",  formulaKey + ".xml");
		if (!pathFile.exists()) {
			throw new Exception("未找到" + formulaKey + ".xml公式文件！");
		}
		Document doc = reader.read(pathFile);
		Map<String, Object> map = new HashMap<>();
		StringBuffer keyWordsBuf = new StringBuffer();
		Exp exp = null;
		Para para = null;
		List<Para> paras = null;

		//3.获取根元素
		Element root = doc.getRootElement();
		//4.获取根元素下的所有子元素（通过迭代器）
		Iterator<Element> it = root.elementIterator();
		while (it.hasNext()) {
			exp = new Exp();
			Element e = it.next();
			//获取id属性(attribute是属性的意思)
			Attribute key = e.attribute(ConstantUtil.KEY);
			Attribute Desc = e.attribute("Desc");
			Attribute Desc1 = e.attribute("Desc1");
			Attribute ReturnValueType = e.attribute("ReturnValueType");
			Attribute ReternValueDesc = e.attribute("ReternValueDesc");
			exp.setKey(key.getStringValue());
			exp.setDesc(Desc.getStringValue().trim());
			if (null != Desc1) {
				exp.setDescDetail(Desc1.getStringValue().trim());
			} else {
				exp.setDescDetail("");
			}
			exp.setReturnValueType(ReturnValueType.getStringValue().trim());
			if (null != ReternValueDesc) {
				exp.setReturnValueDesc(ReternValueDesc.getStringValue().trim());
			}
			keyWordsBuf.append(key.getStringValue() + " ");
			List<Element> elements = e.elements("Para");
			StringBuilder params = new StringBuilder();
			if (null != elements && !elements.isEmpty()) {
				paras = new ArrayList<>();
				for (Element element : elements) {
					para = new Para();
					para.setKey(element.attribute(ConstantUtil.KEY).getStringValue().trim());
					para.setType(element.attribute(ConstantUtil.TYPE).getStringValue().trim());
					para.setDesc(element.attribute("Desc").getStringValue().trim());
					if (element.attribute("IsOptional") != null) {
						para.setOptional(element.attribute("IsOptional").getStringValue().trim());
					} else {
						para.setOptional("false");
					}
					params.append(element.attribute(ConstantUtil.KEY).getStringValue().trim() + ",");
					paras.add(para);
				}
				exp.setParas(paras);
			}
			if (params.length() > 0) {
				map.put(key.getStringValue() + "(" + params.substring(0, params.toString().lastIndexOf(",")) + ")", exp);
			} else {
				map.put(key.getStringValue() + "()", exp);
			}
			if (null != Desc && StringUtils.isNotEmpty(Desc.getStringValue())) {
				map.put(Desc.getStringValue(), BeanUtils.cloneBean(exp));
			}
		}
		map.put("keyWords", keyWordsBuf.toString());
		return JSON.toJSONString(map, SerializerFeature.DisableCircularReferenceDetect);
	}

}