package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.common.util.DebugUtil;
import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.DiffProperty;
import com.bokesoft.yes.design.MetaObjectType;
import com.bokesoft.yes.design.Property;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.design.utils.IDLookup;
import com.bokesoft.yes.design.xml.XmlParser;
import com.bokesoft.yes.design.xml.ex.XmlSyntaxException;
import com.bokesoft.yes.design.xml.node.AbstractNode;
import com.bokesoft.yes.design.xml.node.CDataNode;
import com.bokesoft.yes.design.xml.node.CommentNode;
import com.bokesoft.yes.design.xml.node.DTDNode;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.design.xml.node.TextNode;
import com.bokesoft.yes.design.xml.node.XmlTree;
import com.bokesoft.yes.design.xml.parse.Element;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.common.MetaMacro;
import com.bokesoft.yigo.meta.common.MetaMacroCollection;
import com.bokesoft.yigo.meta.commondef.MetaOperation;
import com.bokesoft.yigo.meta.commondef.MetaOperationCollection;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaEmbed;
import com.bokesoft.yigo.meta.form.component.control.MetaAttachment;
import com.bokesoft.yigo.meta.form.component.control.MetaBPMGraph;
import com.bokesoft.yigo.meta.form.component.control.MetaButton;
import com.bokesoft.yigo.meta.form.component.control.MetaCalendar;
import com.bokesoft.yigo.meta.form.component.control.MetaCheckBox;
import com.bokesoft.yigo.meta.form.component.control.MetaCheckListBox;
import com.bokesoft.yigo.meta.form.component.control.MetaColorPicker;
import com.bokesoft.yigo.meta.form.component.control.MetaComboBox;
import com.bokesoft.yigo.meta.form.component.control.MetaCompDict;
import com.bokesoft.yigo.meta.form.component.control.MetaCountDownView;
import com.bokesoft.yigo.meta.form.component.control.MetaCountUp;
import com.bokesoft.yigo.meta.form.component.control.MetaDataBinding;
import com.bokesoft.yigo.meta.form.component.control.MetaDatePicker;
import com.bokesoft.yigo.meta.form.component.control.MetaDefaultItem;
import com.bokesoft.yigo.meta.form.component.control.MetaDict;
import com.bokesoft.yigo.meta.form.component.control.MetaDropdownButton;
import com.bokesoft.yigo.meta.form.component.control.MetaDynamicDict;
import com.bokesoft.yigo.meta.form.component.control.MetaEmpty;
import com.bokesoft.yigo.meta.form.component.control.MetaFileChooser;
import com.bokesoft.yigo.meta.form.component.control.MetaFlatCanvas;
import com.bokesoft.yigo.meta.form.component.control.MetaFontPicker;
import com.bokesoft.yigo.meta.form.component.control.MetaGIFImage;
import com.bokesoft.yigo.meta.form.component.control.MetaGridDesigner;
import com.bokesoft.yigo.meta.form.component.control.MetaHyperLink;
import com.bokesoft.yigo.meta.form.component.control.MetaIcon;
import com.bokesoft.yigo.meta.form.component.control.MetaImage;
import com.bokesoft.yigo.meta.form.component.control.MetaImageButton;
import com.bokesoft.yigo.meta.form.component.control.MetaImageList;
import com.bokesoft.yigo.meta.form.component.control.MetaImageListItem;
import com.bokesoft.yigo.meta.form.component.control.MetaLabel;
import com.bokesoft.yigo.meta.form.component.control.MetaMaskEditor;
import com.bokesoft.yigo.meta.form.component.control.MetaMonthPicker;
import com.bokesoft.yigo.meta.form.component.control.MetaNumberEditor;
import com.bokesoft.yigo.meta.form.component.control.MetaNumberInfoEditor;
import com.bokesoft.yigo.meta.form.component.control.MetaPasswordEditor;
import com.bokesoft.yigo.meta.form.component.control.MetaPopButton;
import com.bokesoft.yigo.meta.form.component.control.MetaProgressBar;
import com.bokesoft.yigo.meta.form.component.control.MetaRadioButton;
import com.bokesoft.yigo.meta.form.component.control.MetaRichEditor;
import com.bokesoft.yigo.meta.form.component.control.MetaScoreBar;
import com.bokesoft.yigo.meta.form.component.control.MetaSearchBox;
import com.bokesoft.yigo.meta.form.component.control.MetaSegmentedControl;
import com.bokesoft.yigo.meta.form.component.control.MetaSeparator;
import com.bokesoft.yigo.meta.form.component.control.MetaSlider;
import com.bokesoft.yigo.meta.form.component.control.MetaSplitButton;
import com.bokesoft.yigo.meta.form.component.control.MetaStateList;
import com.bokesoft.yigo.meta.form.component.control.MetaStepEditor;
import com.bokesoft.yigo.meta.form.component.control.MetaSubForm;
import com.bokesoft.yigo.meta.form.component.control.MetaSwitch;
import com.bokesoft.yigo.meta.form.component.control.MetaTabGroup;
import com.bokesoft.yigo.meta.form.component.control.MetaTabItem;
import com.bokesoft.yigo.meta.form.component.control.MetaTabItemCollection;
import com.bokesoft.yigo.meta.form.component.control.MetaTextArea;
import com.bokesoft.yigo.meta.form.component.control.MetaTextButton;
import com.bokesoft.yigo.meta.form.component.control.MetaTextEditor;
import com.bokesoft.yigo.meta.form.component.control.MetaTimePicker;
import com.bokesoft.yigo.meta.form.component.control.MetaToggleButton;
import com.bokesoft.yigo.meta.form.component.control.MetaUTCDatePicker;
import com.bokesoft.yigo.meta.form.component.control.MetaUploadButton;
import com.bokesoft.yigo.meta.form.component.control.MetaValidateBox;
import com.bokesoft.yigo.meta.form.component.control.MetaWebBrowser;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaFilter;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaFilterValue;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaItemFilter;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridColumn;
import com.bokesoft.yigo.meta.form.component.panel.MetaFlexFlowLayoutPanel;
import com.bokesoft.yigo.meta.form.component.panel.MetaSplitPanel;
import com.bokesoft.yigo.meta.form.component.panel.MetaTabPanel;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaGridLayoutPanel;
import com.bokesoft.yigo.meta.permission.filter.MetaItem;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.*;

/**
 * 将差异中的XML源代码差异转化为设计界面中的属性差异
 */
public class XmlDiffToPropertyDiff {
	/**
	 * 单例对象
	 */
	public static final XmlDiffToPropertyDiff instance = new XmlDiffToPropertyDiff();

	/**
	 * 生成差异，目前只处理了一行的属性变化
	 *
	 * @param diffs
	 * @return 返回是否转化成功
	 * @throws Throwable
	 */
	public boolean processDiff(List<Diff> diffs) throws Throwable {
		boolean result = true;
		for (Diff diff : diffs) {
			boolean tmp = processDiff(diff);
			result = result && tmp;
		}
		return result;
	}

	private boolean processDiff(Diff diff) throws Throwable {
//		if (diff.getXmlTree().getTagNode("GridRowCollection@").getChildren().size()/3 > 1){
//		diff.setMetaObjectType(MetaObjectType.getMetaObjectType("GridFieldMultiRowTable"));
//		}
		if (diff.getMetaObjectType() != null) {
			if ("SetupMainTable".equals(diff.getMetaObjectType().name) || ConstantUtil.DATA_SOURCE.equals(diff.getMetaObjectType().name) || "newToolBar".equals(diff.getMetaObjectType().name) || "GridFieldMultiRowTable".equals(diff.getMetaObjectType().name) || "GridCellType".equals(diff.getMetaObjectType().name) || diff.isEmbed) {
				if ("".equals(diff.tableKey) || "".equals(diff.subTableKey)) {
					return true;
				}
			}
		}
		if (diff.isPropertyDiff()) {
			return true;
		}
		String orgXml = diff.getXmlTree().xmlTree.getOrgXml();
		String newXml = diff.getNewXml();
		// 1.去掉相同若干行
		String[] orgLines = orgXml.split("\r\n");
		String tmpNewXml = newXml.replaceAll("\r\n", "\n");
		String[] newLines = tmpNewXml.split("\n");
		int startSameLines = 0;
		for (int size = Math.min(orgLines.length, newLines.length); startSameLines < size; startSameLines++) {
			if (!orgLines[startSameLines].equals(newLines[startSameLines])) {
				break;
			}
		}
		int endSameLines = 0;
		for (int size = Math.min(orgLines.length, newLines.length) - startSameLines; endSameLines < size; endSameLines++) {
			if (!orgLines[orgLines.length - endSameLines - 1].equals(newLines[newLines.length - endSameLines - 1])) {
				break;
			}
		}
		String orgXmlFragment = orgXml;
		String newXmlFragment = newXml;
		if (startSameLines > 0 || endSameLines > 0) {
			orgXmlFragment = StringUtils.join(orgLines, "\r\n", startSameLines, orgLines.length - endSameLines);
			if (orgXmlFragment.length() > 0) {
				orgXmlFragment += "\r\n";
			}
			newXmlFragment = StringUtils.join(newLines, "\r\n", startSameLines, newLines.length - endSameLines);
			if (newXmlFragment.length() > 0) {
				newXmlFragment += "\r\n";
			}
		}
		diff.setXmlDiff(diff.getXmlTree(), startSameLines, orgXmlFragment, newXmlFragment);
		//SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");//设置日期格式
		//String o1 = orgXmlFragment.replaceAll("\r", "R").replaceAll("\n", "N");
		//String n1 = newXmlFragment.replaceAll("\r", "R").replaceAll("\n", "N");
		//FileUtils.write(new java.io.File("c:/tmp/1.txt"), "\n" + df.format(new Date()) + "\tOrg:" + o1 + "\tNew:" + n1, "UTF-8", true);
		// 2.取原Node节点，若跨Node节点，则转化失败
		XmlTreeWithPath orgXmlTree = diff.getXmlTree();
		if (Objects.isNull(orgXmlTree)) { // 表示没有差异
			return true;
		}
		if (Objects.isNull(orgXmlTree.xmlTree.getRoot())) { // 表示XML没有解析成功
			return false;
		}
		int startPos = orgXmlTree.xmlTree.getLineStartPos(startSameLines + 1);
		int endPos = startPos + orgXmlFragment.length() - 1;
		List<AbstractNode> detailNodes = orgXmlTree.xmlTree.getDetailNodeByLine(startPos, endPos);
		List<AbstractNode> componentNodes = null;
		try {
			componentNodes = getComponentNodes(detailNodes);
		} catch (RuntimeException e) {
			DebugUtil.debug(e.getMessage());
			// diff.setXmlError(e.getMessage());
			return false;
		}
		if (componentNodes.size() > 1) {
			return false;
		}
		// 3.将新XML片断补充完整
		int nodeStartPos = startPos;
		int nodeEndPos = endPos;
		for (AbstractNode node : detailNodes) {
			nodeStartPos = Math.min(nodeStartPos, node.getElement().getBgIndex());
			nodeEndPos = Math.max(nodeEndPos, node.getElement().getEndIndex());
		}
		for (AbstractNode node : componentNodes) {
			nodeStartPos = Math.min(nodeStartPos, node.getElement().getBgIndex());
			List<AbstractNode> children = ((TagNode) node).getChildren();
			int tmp = CollectionUtils.isEmpty(children) ? node.getElement().getEndIndex() : children.get(children.size() - 1).getElement().getEndIndex();
			nodeEndPos = Math.max(nodeEndPos, tmp);
		}
		String newXmlFragmentFull = new StringBuilder(1024)
				.append(orgXmlTree.xmlTree.getOrgXml().substring(nodeStartPos, startPos)).append(newXmlFragment)
				.append(orgXmlTree.xmlTree.getOrgXml().substring(endPos + 1, nodeEndPos + 1)).toString();
		// 4.解析新的XML片断
		List<AbstractNode> newTagNodes = null;
		try {
			newTagNodes = getComponentNodes(newXmlFragmentFull);
		} catch (RuntimeException e) {
			DebugUtil.debug(e.getMessage());
			// diff.setXmlError(e.getMessage());
			return false;
		}
		if (componentNodes.size() == 0 && newTagNodes.size() == 0) {
			return true;
		}
		if (componentNodes.size() != 1 || newTagNodes.size() != 1) {
			return false;
		}
		// 5.最后进行比较
		TagNode orgTagNode = (TagNode) componentNodes.get(0);
		TagNode newTagNode = (TagNode) newTagNodes.get(0);
		return genPropertyDiff(diff, orgTagNode, newTagNode);
	}

	private List<AbstractNode> getComponentNodes(String xml) throws Throwable {
		String tmp = new StringBuilder(xml.length() + 30).append("<TempRoot>").append(xml).append("</TempRoot>").toString();
		XmlTree xmlTree = XmlParser.parse(tmp);
		List<AbstractNode> nodes = xmlTree.getRoot().getChildren();

		for (Iterator<AbstractNode> it = nodes.iterator(); it.hasNext(); ) {
			AbstractNode node = it.next();
			if (node instanceof CommentNode || node instanceof TextNode || node instanceof DTDNode) {
				it.remove();
			} else if (node instanceof CDataNode) {
				throw new XmlSyntaxException("无法解析CDATA[" + node.getElement().getText() + "]");
			} else {
				TagNode tagNode = (TagNode) node;
				if (tagNode.getElement().getTagType() == Element.T_END) {
					it.remove();
				}
			}
		}
		return nodes;
	}

	private List<AbstractNode> getComponentNodes(List<AbstractNode> nodes) {
		List<AbstractNode> result = new ArrayList<AbstractNode>();
		boolean changed = false;
		for (Iterator<AbstractNode> it = nodes.iterator(); it.hasNext(); ) {
			AbstractNode node = it.next();
			if (node instanceof CommentNode || node instanceof TextNode || node instanceof DTDNode) {
				changed = true;
			} else if (node instanceof CDataNode) {
				AbstractNode parent = node.getParent();
				if (!result.contains(parent)) {
					result.add(parent);
				}
				changed = true;
			} else {
				TagNode tagNode = (TagNode) node;
				String tagName = tagNode.getTagName();
				if (isEqualsAny(tagName, MetaAttachment.TAG_NAME, MetaBPMGraph.TAG_NAME, MetaButton.TAG_NAME,
						MetaCalendar.TAG_NAME, MetaCheckBox.TAG_NAME, MetaCheckListBox.TAG_NAME,
						MetaColorPicker.TAG_NAME, MetaComboBox.TAG_NAME, MetaCompDict.TAG_NAME,
						MetaCountDownView.TAG_NAME, MetaCountUp.TAG_NAME, MetaDataBinding.TAG_NAME,
						MetaDatePicker.TAG_NAME, MetaDefaultItem.TAG_NAME, MetaDict.TAG_NAME,
						MetaDropdownButton.TAG_NAME, MetaDynamicDict.TAG_NAME, MetaEmpty.TAG_NAME,
						MetaFileChooser.TAG_NAME, MetaFlatCanvas.TAG_NAME, MetaFontPicker.TAG_NAME,
						MetaGIFImage.TAG_NAME, MetaGridDesigner.TAG_NAME, MetaHyperLink.TAG_NAME, MetaIcon.TAG_NAME,
						MetaImage.TAG_NAME, MetaImageButton.TAG_NAME, MetaImageList.TAG_NAME,
						MetaImageListItem.TAG_NAME, MetaLabel.TAG_NAME, MetaMaskEditor.TAG_NAME,
						MetaMonthPicker.TAG_NAME, MetaNumberEditor.TAG_NAME, MetaNumberInfoEditor.TAG_NAME,
						MetaPasswordEditor.TAG_NAME, MetaPopButton.TAG_NAME, MetaProgressBar.TAG_NAME,
						MetaRadioButton.TAG_NAME, MetaRichEditor.TAG_NAME, MetaScoreBar.TAG_NAME,
						MetaSearchBox.TAG_NAME, MetaSegmentedControl.TAG_NAME, MetaSeparator.TAG_NAME,
						MetaSlider.TAG_NAME, MetaSplitButton.TAG_NAME, MetaStateList.TAG_NAME, MetaStepEditor.TAG_NAME,
						MetaSubForm.TAG_NAME, MetaSwitch.TAG_NAME, MetaTabGroup.TAG_NAME, MetaTabItem.TAG_NAME,
						MetaTabItemCollection.TAG_NAME, MetaTextArea.TAG_NAME, MetaTextButton.TAG_NAME,
						MetaTextEditor.TAG_NAME, MetaTimePicker.TAG_NAME, MetaToggleButton.TAG_NAME,
						MetaUploadButton.TAG_NAME, MetaUTCDatePicker.TAG_NAME, MetaValidateBox.TAG_NAME,
						MetaWebBrowser.TAG_NAME)) {
					result.add(node);
				} else if (isEqualsAny(tagName, MetaGridCell.TAG_NAME, MetaGridColumn.TAG_NAME, MetaGrid.TAG_NAME)) {
					result.add(node);
				} else if (isEqualsAny(tagName, MetaOperation.TAG_NAME, MetaOperationCollection.TAG_NAME,
						MetaMacro.TAG_NAME, MetaMacroCollection.TAG_NAME)) {
					result.add(node);
				} else if (isEqualsAny(tagName, MetaGridLayoutPanel.TAG_NAME, MetaSplitPanel.TAG_NAME,
						MetaEmbed.TAG_NAME, MetaFlexFlowLayoutPanel.TAG_NAME, MetaTabPanel.TAG_NAME)) {
					result.add(node);
				} else if (isEqualsAny(tagName, MetaDataBinding.TAG_NAME, MetaConstants.DATABINDING_VALUECHANGED,
						MetaItemFilter.TAG_NAME, MetaFilter.TAG_NAME, MetaFilterValue.TAG_NAME, MetaItem.TAG_NAME,
						MetaConstants.Event_OnClick, MetaConstants.DATABINDING_DEFAULTFORMULAVALUE,
						MetaConstants.COMBOBOX_FORMULAITEMS)) {
					result.add(node.getParent());
					changed = true;
				} else if (isEqualsAny(tagName, MetaConstants.TABPANEL_ITEMCHANGED)) {
					result.add(node.getParent());
					changed = true;
				} else {
					throw new RuntimeException("未处理的TagName:" + tagName);
				}
			}
		}
		if (changed) {
			return getComponentNodes(result);
		} else {
			return nodes;
		}
	}

	private boolean isEqualsAny(String left, String... rights) {
		for (String right : rights) {
			if (left.equals(right)) {
				return true;
			}
		}
		return false;
	}

	private boolean genPropertyDiff(Diff diff, TagNode orgNode, TagNode newNode) throws Throwable {
		String tagName = orgNode.getTagName();
		if (tagName.equals(newNode.getTagName())) {
			Map<String, String> orgAttributes = orgNode.getAttributes();
			String key = orgAttributes.get(MetaConstants.COMMON_KEY);
			if (StringUtils.isBlank(key)) {
				return false;
			}
			Map<String, String> newAttributes = newNode.getAttributes();
			if (key.equals(newAttributes.get(MetaConstants.COMMON_KEY))) {
				Set<String> allProperties = new HashSet<String>();
				List<DiffProperty> diffProperties = new ArrayList<DiffProperty>();
				for (Map.Entry<String, String> entry : orgAttributes.entrySet()) {
					String attribute = entry.getKey();
					String orgValue = entry.getValue();
					String newValue = newAttributes.get(attribute);
					if (!orgValue.equals(newValue)) {
						Property property = Property.getProperty(attribute);
						if (Objects.isNull(property)) {
							return false;
						}
						DiffProperty diffProperty = new DiffProperty(property, orgValue, newValue);
						diffProperties.add(diffProperty);
					}
					allProperties.add(attribute);
				}
				for (Map.Entry<String, String> entry : newAttributes.entrySet()) {
					String attribute = entry.getKey();
					if (!allProperties.contains(attribute)) {
						String newValue = entry.getValue();
						Property property = Property.getProperty(attribute);
						if (Objects.isNull(property)) {
							return false;
						}
						DiffProperty diffProperty = new DiffProperty(property, "", newValue);
						diffProperties.add(diffProperty);
					}
				}
				MetaObjectType metaObjectType = getMetaObjectType(tagName);
				if (Objects.isNull(metaObjectType)) {
					return false;
				}
				diff.setMetaObjectType(metaObjectType);

				MetaForm metaForm = diff.getMetaForm();
				IDLookup idLookup = IDLookup.getIDLookup(metaForm);
				String primaryFieldKey = idLookup.getFieldKeyByBuddyKey(key);
				if (primaryFieldKey != null && primaryFieldKey.length() > 0) {
					diff.setKey(primaryFieldKey);
					diff.setControlType(idLookup.getComponentByKey(primaryFieldKey).getControlType());
					for (DiffProperty diffProperty : diffProperties) {
						if (diffProperty.property == Property.caption) {
							diffProperty.property = Property.buddyCaption;
						} else if (diffProperty.property == Property.x) {
							diffProperty.property = Property.buddyX;
						} else if (diffProperty.property == Property.y) {
							diffProperty.property = Property.buddyY;
						}
					}
				} else {
					diff.setKey(key);
					diff.setControlType(ControlType.parse(tagName));
				}
				diff.properties = diffProperties;
				return true;
			}
		}
		return false;
	}

	private MetaObjectType getMetaObjectType(String tagName) {
		MetaObjectType result = null;

		if (isEqualsAny(tagName, MetaGridCell.TAG_NAME, MetaGridColumn.TAG_NAME)) {
			result = MetaObjectType.gridField;
		} /*else if (propertyForm.formKey.indexOf("ListViewField") !== -1) {
        	diff.metaObjectType = 'ListViewField';
            diff.controlType = propertyForm.getValue('ColumnType');
        }*/ else if (isEqualsAny(tagName, MetaOperationCollection.TAG_NAME)) {
			result = MetaObjectType.operationCollection;
		} else if (isEqualsAny(tagName, MetaOperation.TAG_NAME)) {
			result = MetaObjectType.operation;
		} else if (isEqualsAny(tagName, MetaGridLayoutPanel.TAG_NAME, MetaSplitPanel.TAG_NAME,
				MetaEmbed.TAG_NAME, MetaFlexFlowLayoutPanel.TAG_NAME, MetaTabPanel.TAG_NAME)) {
			result = MetaObjectType.panel;
		}/* else if (propertyForm.formKey.indexOf("SubDetail") !== -1) {
            diff.metaObjectType = 'SubDetail';
            diff.controlType = propertyForm.getValue('ControlType');
        }*/ else if (isEqualsAny(tagName, MetaGrid.TAG_NAME)) {
			result = MetaObjectType.grid;
		}/* else if (propertyForm.formKey.indexOf("ListView") !== -1) {
            diff.metaObjectType = 'ListView';
            diff.controlType = propertyForm.getValue('ControlType');
        }*/ else if (isEqualsAny(tagName, MetaAttachment.TAG_NAME, MetaBPMGraph.TAG_NAME, MetaButton.TAG_NAME,
				MetaCalendar.TAG_NAME, MetaCheckBox.TAG_NAME, MetaCheckListBox.TAG_NAME,
				MetaColorPicker.TAG_NAME, MetaComboBox.TAG_NAME, MetaCompDict.TAG_NAME,
				MetaCountDownView.TAG_NAME, MetaCountUp.TAG_NAME, MetaDataBinding.TAG_NAME,
				MetaDatePicker.TAG_NAME, MetaDefaultItem.TAG_NAME, MetaDict.TAG_NAME,
				MetaDropdownButton.TAG_NAME, MetaDynamicDict.TAG_NAME, MetaEmpty.TAG_NAME,
				MetaFileChooser.TAG_NAME, MetaFlatCanvas.TAG_NAME, MetaFontPicker.TAG_NAME,
				MetaGIFImage.TAG_NAME, MetaGridDesigner.TAG_NAME, MetaHyperLink.TAG_NAME, MetaIcon.TAG_NAME,
				MetaImage.TAG_NAME, MetaImageButton.TAG_NAME, MetaImageList.TAG_NAME,
				MetaImageListItem.TAG_NAME, MetaLabel.TAG_NAME, MetaMaskEditor.TAG_NAME,
				MetaMonthPicker.TAG_NAME, MetaNumberEditor.TAG_NAME, MetaNumberInfoEditor.TAG_NAME,
				MetaPasswordEditor.TAG_NAME, MetaPopButton.TAG_NAME, MetaProgressBar.TAG_NAME,
				MetaRadioButton.TAG_NAME, MetaRichEditor.TAG_NAME, MetaScoreBar.TAG_NAME,
				MetaSearchBox.TAG_NAME, MetaSegmentedControl.TAG_NAME, MetaSeparator.TAG_NAME,
				MetaSlider.TAG_NAME, MetaSplitButton.TAG_NAME, MetaStateList.TAG_NAME, MetaStepEditor.TAG_NAME,
				MetaSubForm.TAG_NAME, MetaSwitch.TAG_NAME, MetaTabGroup.TAG_NAME, MetaTabItem.TAG_NAME,
				MetaTabItemCollection.TAG_NAME, MetaTextArea.TAG_NAME, MetaTextButton.TAG_NAME,
				MetaTextEditor.TAG_NAME, MetaTimePicker.TAG_NAME, MetaToggleButton.TAG_NAME,
				MetaUploadButton.TAG_NAME, MetaUTCDatePicker.TAG_NAME, MetaValidateBox.TAG_NAME,
				MetaWebBrowser.TAG_NAME)) {
			result = MetaObjectType.field;
		}
		return result;
	}
}
