package com.bokesoft.yes.design.cmd;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

import com.bokesoft.yes.common.log.LogSvr;
import org.apache.commons.io.FileUtils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.utils.IDLookup;
import com.bokesoft.yes.design.vo.ResponseResult;
import com.bokesoft.yes.erp.config.MetaFormNODBProcess;
import com.bokesoft.yes.helper.MetaObjectHelper;
import com.bokesoft.yes.meta.persist.dom.xml.XmlCreator;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.def.ComboBoxSourceType;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.TableMode;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.exceltemplate.ExcelFormatDataType;
import com.bokesoft.yigo.meta.exceltemplate.ExcelTemplateCellType;
import com.bokesoft.yigo.meta.exceltemplate.ExcelTemplateRowType;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelCell;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelColumn;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelColumns;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelDisplay;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelFormat;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelListItem;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelRow;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelRows;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelSheet;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelTemplateList;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelTemplateProfile;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelTemplateSave;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelTemplateSubList;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelWorkbook;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.MetaCheckListBox;
import com.bokesoft.yigo.meta.form.component.control.MetaComboBox;
import com.bokesoft.yigo.meta.form.component.control.MetaDefaultItem;
import com.bokesoft.yigo.meta.form.component.control.MetaDict;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaCheckListBoxProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaComboBoxProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDictProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaListBoxItemCollection;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.apache.commons.lang3.StringUtils;

/*
 *文件名: WebPrintDesign
 *创建者: zhangk
 *创建时间:2022/11/12 13:07
 */
public class WebExcelDesign extends DesignerServiceCmd {
    public static final String CMD = "WebExcelDesign";
    private static final String XML_EXTENSION = ".xml";
    /***projectKey*/
    private String projectKey;
    /***formKey*/
    private String formKey;
    /***formCaption*/
    private String formCaption;
    private String associationForm;
//    private boolean createDefaultTemplate = true;

    @Override
    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) {

        projectKey = (String) arguments.get("projectKey");
        formKey = (String) arguments.get("newFormKey");
        formCaption = (String) arguments.get("formCaption");
        associationForm = (String) arguments.get("associationForm");
        //createDefaultTemplate = Integer.valueOf((String) arguments.get("createDefaultTemplate")) == 1;
    }

    /**
     * 创建数据对象
     *
     * @param projectKey 选择的工程名
     * @param key        标识
     * @param caption    名称
     * @return
     */
    public Map<String, String> createXml(String projectKey, String key, String caption) throws Throwable {
        Map<String, String> result = new HashMap<>(10);
        String filePath = "";

        String newFileName = key + XML_EXTENSION;
        //创建一个新的路径
        filePath = LoadFileTree.NewExcelfilePath(result, projectKey, newFileName, key, caption);
        //创建一个初始的XMl Content
        String fileContent = setMetaExcel(key, caption, newFileName, projectKey);
        //创建的时候直接生成文件夹
        FileUtils.writeStringToFile(new File(filePath), fileContent, "UTF-8");
        result.put("result", "true");
        result.put("filePath", filePath);

        result.put("fileName", newFileName.replaceAll(".xml", ""));

        return result;
    }

    public static ResponseResult<JSONArray> SaveExcelXML(String filePaths, IMetaFactory metaFactory) throws Throwable {
        ResponseResult<JSONArray> result = new ResponseResult<>();
        File file = new File(filePaths);
        String tmpFile = XmlFileProcessor.instance.getTmpFile(filePaths);
        if (StringUtils.isBlank(tmpFile)) {
            tmpFile = filePaths;
        }
        String newContent = FileUtils.readFileToString(new File(tmpFile), "UTF-8");
        //重新写入文件夹
        FileUtils.writeStringToFile(file, newContent, "UTF-8");
        XmlFileProcessor.instance.clearTmpFile(filePaths);
        result.setCode(0);
        result.setMsg("保存Excel成功");
        //处理Excel实体
        String key = XmlTreeWithPath.parseFilePath(filePaths).xmlTree.getRoot().getAttributes().get("Key");
        String projectKey = LoadFileTree.getProjectKey(filePaths);
        MetaExcelTemplateSubList excelTemplateSubList = metaFactory.getMetaExcelTemplateList().get(projectKey);
        MetaExcelTemplateProfile excelTemplateProfile = excelTemplateSubList.get(key);
        excelTemplateProfile.setWorkbook(null);
        MetaExcelWorkbook excelTemplateOld = metaFactory.getExcelTemplate(projectKey, key);
        excelElementSorting(filePaths, metaFactory, key, projectKey, excelTemplateProfile, excelTemplateOld);

        return result;
    }

    private static void excelElementSorting(String filePaths, IMetaFactory metaFactory, String key, String projectKey, MetaExcelTemplateProfile excelTemplateProfile, MetaExcelWorkbook excelTemplateOld) throws Throwable {
        MetaExcelWorkbook newExcelTemplate = MetaObjectHelper.deptClone(excelTemplateOld);
        newExcelTemplate.clear();
        for (MetaExcelSheet metaExcelSheet : excelTemplateOld) {
            MetaExcelSheet newMetaExcelSheet = MetaObjectHelper.deptClone(metaExcelSheet);
            newExcelTemplate.add(newMetaExcelSheet);
            newMetaExcelSheet.clear();
            MetaExcelRows oldRows = metaExcelSheet.getRows();
            if (oldRows != null) {
                MetaExcelRows newRows = MetaObjectHelper.deptClone(oldRows);
                newMetaExcelSheet.setRows(newRows);
                newRows.clear();
                ArrayList<MetaExcelRow> metaExcelRows = new ArrayList<>();
                for (MetaExcelRow oldRow : oldRows) {
                    metaExcelRows.add(oldRow);
                }
                List<MetaExcelRow> collect = metaExcelRows.stream().sorted(Comparator.comparing(e -> e.getRowIndex())).collect(Collectors.toList());
                for (MetaExcelRow object : collect) {
                    ArrayList<MetaExcelCell> metaExcelCells = new ArrayList<>();
                    for (MetaExcelCell metaExcelCell : object) {
                        metaExcelCells.add(metaExcelCell);
                    }
                    List<MetaExcelCell> collect1 = metaExcelCells.stream().sorted(Comparator.comparing(a -> a.getCellIndex())).collect(Collectors.toList());
                    object.clear();
                    for (MetaExcelCell metaExcelCell : collect1) {
                        object.add(metaExcelCell);
                    }
                    newRows.add(object);
                }
            }
            MetaExcelColumns oldColumns = metaExcelSheet.getColumns();
            if (oldColumns != null) {
                MetaExcelColumns newMetaExcelColumns = MetaObjectHelper.deptClone(oldColumns);
                newMetaExcelSheet.setColumns(newMetaExcelColumns);
                newMetaExcelColumns.clear();
                ArrayList<MetaExcelColumn> metaExcelColumns = new ArrayList<>();
                for (MetaExcelColumn oldColumn : oldColumns) {
                    metaExcelColumns.add(oldColumn);
                }
                List<MetaExcelColumn> collect1 = metaExcelColumns.stream().sorted(Comparator.comparing(a -> a.getColumnIndex())).collect(Collectors.toList());
                for (MetaExcelColumn excelColumn : collect1) {
                    newMetaExcelColumns.add(excelColumn);
                }
            }


        }

        MetaExcelTemplateSave metaExcelTemplateSave = new MetaExcelTemplateSave(newExcelTemplate);
        org.w3c.dom.Document document = metaExcelTemplateSave.getDocument();
        XmlCreator creator11 = new XmlCreator(document, null);
        FileUtils.writeStringToFile(new File(filePaths), creator11.createXml(), "UTF-8");
        excelTemplateProfile.setWorkbook(null);
        metaFactory.getExcelTemplate(projectKey, key);
    }

    private MetaExcelWorkbook createDefault(String key, String caption, String formKey) throws Throwable {
        MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(formKey);
        MetaDataObject metaDataObject = metaForm.getDataSource().getDataObject();
        MetaTableCollection tableCollection = metaDataObject.getTableCollection();
        Iterator<MetaTable> itTables = tableCollection.iterator();
        if (tableCollection.size() == 0) {
            return null;
        }
        MetaTable metaTable = null;
        MetaExcelWorkbook metaExcelSheets = new MetaExcelWorkbook();
        metaExcelSheets.setKey(key);
        metaExcelSheets.setCaption(caption);
        metaExcelSheets.setFormKey(formKey);

        while (itTables.hasNext()) {
            metaTable = itTables.next();
            String sheetKey = metaTable.getKey();
            // Sheet页名设为表名称
            String sheetName = metaTable.getCaption();
            if (sheetKey.endsWith(MetaFormNODBProcess.STR_NODBTable_Profix)) {
                continue;
            }
            MetaExcelSheet metaExcelSheet = new MetaExcelSheet();
            metaExcelSheet.setName(sheetName);
            metaExcelSheets.add(metaExcelSheet);
            MetaExcelRows metaExcelRows = new MetaExcelRows();
            metaExcelSheet.setRows(metaExcelRows);
            MetaExcelRow metaExcelCells = new MetaExcelRow();
            metaExcelCells.setRowIndex(1);
            metaExcelRows.add(metaExcelCells);
            metaExcelRows.set(0, metaExcelCells);
            MetaExcelRow metaExcelCells1 = new MetaExcelRow();
            metaExcelCells1.setRowIndex(2);
            metaExcelRows.add(metaExcelCells1);
            metaExcelRows.set(1, metaExcelCells1);
            String tableKey = metaTable.getKey();
            Iterator<MetaColumn> iterator = metaTable.iterator();
            MetaColumn metaColumn;
            int i = 1;
            while (iterator.hasNext()) {
                metaColumn = iterator.next();
                if (metaColumn.getKey().endsWith(MetaFormNODBProcess.STR_NODBTable_Profix)) {
                    continue;
                }
                if (metaTable.getTableMode() == TableMode.DETAIL) {
                    String columnKey = metaColumn.getKey();
                    if (metaForm != null) {
                        IDLookup idLookup = IDLookup.getIDLookup(metaForm);
                        MetaGridCell gridCell = idLookup.getGridCellByKey(columnKey);
                        if (gridCell != null) {//先不处理扩展列
                            //lab
                            String fieldCaption = gridCell.getCaption();
//                            String componentKey = gridCell.getKey();
                            MetaExcelCell lab_metaExcelCell = new MetaExcelCell();
                            metaExcelCells.add(lab_metaExcelCell);
                            metaExcelCells.setType(ExcelTemplateRowType.DetailHead);
                            lab_metaExcelCell.setCellIndex(i);
                            lab_metaExcelCell.setDefinition(fieldCaption);
                            lab_metaExcelCell.setMergedRowSpan(1);
                            lab_metaExcelCell.setMergedColumnSpan(1);
                            lab_metaExcelCell.setSourceType(ExcelTemplateCellType.Const);
                            //	MetaExcelDisplay metaExcelDisplay1 = new MetaExcelDisplay();
                            //	lab_metaExcelCell.setDisplay(metaExcelDisplay1);
                            metaExcelCells.add(lab_metaExcelCell);
                            //	MetaExcelFormat metaExcelFormat1 = new MetaExcelFormat();
                            //	metaExcelDisplay1.setFormat(metaExcelFormat1);


                            //绑定字段
                            MetaExcelCell metaExcelCell = new MetaExcelCell();
                            metaExcelCells1.add(metaExcelCell);
                            metaExcelCells1.setType(ExcelTemplateRowType.Detail);
                            metaExcelCells1.setTableKey(tableKey);
                            metaExcelCell.setCellIndex(i);
                            metaExcelCell.setSourceType(ExcelTemplateCellType.Field);
                            metaExcelCell.setDefinition(metaColumn.getKey());
                            metaExcelCell.setMergedColumnSpan(1);
                            metaExcelCell.setMergedRowSpan(1);
                            int controlType = gridCell.getCellType();
                            MetaExcelDisplay metaExcelDisplay = new MetaExcelDisplay();
                            metaExcelCell.setDisplay(metaExcelDisplay);
                            MetaExcelFormat metaExcelFormat = new MetaExcelFormat();
                            metaExcelDisplay.setFormat(metaExcelFormat);
                            metaExcelFormat.setDataType(ExcelFormatDataType.Text);
                            if (controlType == ControlType.DICT) {//字典
                                metaExcelFormat.setDataType(ExcelFormatDataType.Dict);

                                MetaDictProperties component1 = (MetaDictProperties) gridCell.getProperties();
                                metaExcelFormat.setItemKey(component1.getItemKey());
                                metaExcelFormat.setFieldKeys("Name");
                            } else if (controlType == ControlType.COMBOBOX) {//下拉框
                                MetaComboBoxProperties component1 = (MetaComboBoxProperties) gridCell.getProperties();
                                if (component1.getSourceType() == ComboBoxSourceType.ITEMS) {
                                    metaExcelFormat.setDataType(ExcelFormatDataType.List);
                                    MetaListBoxItemCollection items = component1.getItems();
                                    List<MetaExcelListItem> metaExcelListItem = new ArrayList<>();
                                    for (MetaDefaultItem item : items) {
//                                        String key1 = item.getKey();
                                        String caption1 = item.getCaption();
                                        String value = item.getValue();
                                        MetaExcelListItem e = new MetaExcelListItem();
                                        e.setValue(value);
                                        e.setText(caption1);
                                        metaExcelListItem.add(e);

                                    }
                                    if (metaExcelListItem.size() > 0) {
                                        metaExcelFormat.setListItems(metaExcelListItem);
                                    }
                                }
                            } else if (controlType == ControlType.CHECKLISTBOX) {//多选下拉框
                                metaExcelFormat.setDataType(ExcelFormatDataType.MultiList);
                                MetaCheckListBoxProperties component1 = (MetaCheckListBoxProperties) gridCell.getProperties();
                                if (component1.getSourceType() == ComboBoxSourceType.ITEMS) {
                                    MetaListBoxItemCollection items = component1.getItems();
                                    List<MetaExcelListItem> metaExcelListItem = new ArrayList<>();
                                    for (MetaDefaultItem item : items) {
//                                        String key1 = item.getKey();
                                        String caption1 = item.getCaption();
                                        String value = item.getValue();
                                        MetaExcelListItem e = new MetaExcelListItem();
                                        e.setValue(value);
                                        e.setText(caption1);
                                        metaExcelListItem.add(e);

                                    }
                                    if (metaExcelListItem.size() > 0) {
                                        metaExcelFormat.setListItems(metaExcelListItem);
                                    }
                                }
                            }
                            i++;
                        }
                    }
                } else {
                    String columnKey = metaColumn.getKey();
                    if (metaForm != null) {
                        IDLookup idLookup = IDLookup.getIDLookup(metaForm);
                        String componentFieldKey = idLookup.getFieldKeyByTableColumnKey(tableKey, columnKey);
                        if (componentFieldKey != null) {
                            MetaComponent component = idLookup.getComponentByKey(componentFieldKey);
                            if (component != null) {
                                String fieldCaption = component.getCaption();
//                                String componentKey = component.getKey();
                                //lab
                                MetaExcelCell lab_metaExcelCell = new MetaExcelCell();
                                lab_metaExcelCell.setCellIndex(i);
                                lab_metaExcelCell.setDefinition(fieldCaption);
                                lab_metaExcelCell.setMergedRowSpan(1);
                                lab_metaExcelCell.setMergedColumnSpan(component.getXSpan());
                                lab_metaExcelCell.setSourceType(ExcelTemplateCellType.Const);
                                //	MetaExcelDisplay metaExcelDisplay1 = new MetaExcelDisplay();
                                //	lab_metaExcelCell.setDisplay(metaExcelDisplay1);
                                metaExcelCells.add(lab_metaExcelCell);
                                //	MetaExcelFormat metaExcelFormat1 = new MetaExcelFormat();
                                //metaExcelDisplay1.setFormat(metaExcelFormat1);
                                //	metaExcelFormat1.setFieldKeys("Lab_" + componentKey);
                                //绑定字段
                                MetaExcelCell metaExcelCell = new MetaExcelCell();
                                metaExcelCells1.add(metaExcelCell);
                                metaExcelCells1.setType(ExcelTemplateRowType.Head);
                                metaExcelCell.setTableKey(tableKey);
                                metaExcelCell.setCellIndex(i);
                                metaExcelCell.setSourceType(ExcelTemplateCellType.Field);
                                metaExcelCell.setDefinition(metaColumn.getKey());
                                metaExcelCell.setMergedColumnSpan(component.getXSpan());
                                metaExcelCell.setMergedRowSpan(1);
                                if (component.getXSpan() > 1) {
                                    i += component.getXSpan() - 1;
                                }
                                int controlType = component.getControlType();
                                MetaExcelDisplay metaExcelDisplay = new MetaExcelDisplay();
                                metaExcelCell.setDisplay(metaExcelDisplay);
                                MetaExcelFormat metaExcelFormat = new MetaExcelFormat();
                                metaExcelDisplay.setFormat(metaExcelFormat);
                                metaExcelFormat.setDataType(ExcelFormatDataType.Text);
                                if (controlType == ControlType.DICT) {//字典
                                    metaExcelFormat.setDataType(ExcelFormatDataType.Dict);
                                    MetaDict component1 = (MetaDict) component;
                                    metaExcelFormat.setItemKey(component1.getItemKey());
                                    metaExcelFormat.setFieldKeys("Name");
                                } else if (controlType == ControlType.COMBOBOX) {//下拉框
                                    MetaComboBox component1 = (MetaComboBox) component;
                                    if (component1.getSourceType() == ComboBoxSourceType.ITEMS) {
                                        metaExcelFormat.setDataType(ExcelFormatDataType.List);
                                        MetaListBoxItemCollection items = component1.getItems();
                                        List<MetaExcelListItem> metaExcelListItem = new ArrayList<>();
                                        for (MetaDefaultItem item : items) {
//                                            String key1 = item.getKey();
                                            String caption1 = item.getCaption();
                                            String value = item.getValue();
                                            MetaExcelListItem e = new MetaExcelListItem();
                                            e.setValue(value);
                                            e.setText(caption1);
                                            metaExcelListItem.add(e);

                                        }
                                        if (metaExcelListItem.size() > 0) {
                                            metaExcelFormat.setListItems(metaExcelListItem);

                                        }
                                    }
                                } else if (controlType == ControlType.CHECKLISTBOX) {//多选下拉框
                                    metaExcelFormat.setDataType(ExcelFormatDataType.MultiList);
                                    MetaCheckListBox component1 = (MetaCheckListBox) component;
                                    if (component1.getSourceType() == ComboBoxSourceType.ITEMS) {
                                        MetaListBoxItemCollection items = component1.getItems();
                                        List<MetaExcelListItem> metaExcelListItem = new ArrayList<>();
                                        for (MetaDefaultItem item : items) {
//                                            String key1 = item.getKey();
                                            String caption1 = item.getCaption();
                                            String value = item.getValue();
                                            MetaExcelListItem e = new MetaExcelListItem();
                                            e.setValue(value);
                                            e.setText(caption1);
                                            metaExcelListItem.add(e);

                                        }
                                        if (metaExcelListItem.size() > 0) {
                                            metaExcelFormat.setListItems(metaExcelListItem);
                                        }
                                    }
                                }
                                i++;
                            }

                        }

                    }

                }


            }


        }
        metaExcelSheets.setSheet(metaExcelSheets.get(0));


        return metaExcelSheets;

    }

    /**
     * @param key
     * @param caption
     * @throws Throwable 在MetaDataObjectList中创建文件
     */
    private String setMetaExcel(String key, String caption, String newFileName, String projectKey) throws Throwable {
        //获取模板内容
        MetaExcelTemplateList excelTemplateList = MetaFactory.getGlobalInstance().getMetaExcelTemplateList();
        MetaExcelTemplateSubList metaExcelTemplateProfiles = excelTemplateList.get("webconfig");
        MetaExcelTemplateProfile metaExcelTemplateProfile = metaExcelTemplateProfiles.get("D_ExcelTem");
        MetaExcelTemplateProfile depthClone = MetaObjectHelper.deptClone(metaExcelTemplateProfile);
        depthClone.setProject(metaExcelTemplateProfile.getProject());
        if (Objects.isNull(depthClone.getWorkbook())) {
            MetaExcelWorkbook workbook = new MetaExcelWorkbook();
            MetaExcelSheet metaExcelSheet = new MetaExcelSheet();
            metaExcelSheet.setName("Sheet1");
            metaExcelSheet.setRows(new MetaExcelRows());
            workbook.add(metaExcelSheet);
            depthClone.setWorkbook(workbook);
        }
        depthClone.getWorkbook().setFormKey(associationForm);
        depthClone.getWorkbook().setCaption(caption);
        depthClone.getWorkbook().setKey(key);
        //更改模板内容
        MetaExcelTemplateProfile excelTemplateProfile = setKeyAndCaption(depthClone, key, caption,
                excelTemplateList, newFileName, projectKey);
//		if (createDefaultTemplate) {
//			excelTemplateProfile.setWorkbook(createDefault(key, caption, associationForm));
//		}
        MetaExcelTemplateSave metaExcelTemplateSave = new MetaExcelTemplateSave(excelTemplateProfile.getWorkbook());
        org.w3c.dom.Document document = metaExcelTemplateSave.getDocument();
        XmlCreator creator11 = new XmlCreator(document, null);
        return creator11.createXml();

    }

    /**
     * @param dataObjectModule
     * @param Key
     * @param Caption
     * @return 替换内容
     */
    public MetaExcelTemplateProfile setKeyAndCaption(MetaExcelTemplateProfile dataObjectModule, String Key, String Caption,
                                                     MetaExcelTemplateList metaExcelTemplateList, String newFileName, String projectKey) throws Exception {

        dataObjectModule.setKey(Key);
        dataObjectModule.setCaption(Caption);
        dataObjectModule.setResource("ExcelTemplate/" + newFileName);
        try {
            MetaProject project = MetaFactory.getGlobalInstance().getMetaProject(projectKey);
            dataObjectModule.setProject(project);
        } catch (Throwable throwable) {
            LogSvr.getInstance().error(throwable.getMessage(), throwable);
        }
        MetaExcelTemplateSubList metaExcelTemplateProfiles = metaExcelTemplateList.get(projectKey);
        if (Objects.isNull(metaExcelTemplateProfiles)) {
            MetaExcelTemplateSubList excelTemplateSubList = new MetaExcelTemplateSubList();
            excelTemplateSubList.setKey(projectKey);
            excelTemplateSubList.add(dataObjectModule);
            metaExcelTemplateList.add(excelTemplateSubList);
        } else {
            metaExcelTemplateProfiles.add(dataObjectModule);
        }
        dataObjectModule.doPostProcess(0, null);
        return dataObjectModule;
    }

    @Override
    public Object innerDoCmd(DefaultContext defaultContext) throws Throwable {
        JSONObject result = new JSONObject();
        Map<String, String> xml = createXml(projectKey, formKey, formCaption);
        // 成功
        result.put("code", 0);
        result.put("msg", "新增文件成功");
        result.put("filePath", xml.get("filePath"));
        //前端重新装载xml文件命令
        List<UICommand> uiCommands = new ArrayList<>();
        uiCommands.add(UICommand.reloadFileTree(xml.get("filePath")));
        uiCommands.add(UICommand.reloadMenuTree());
        result.put("uICommands", UICommand.toJson(uiCommands));
        return result;
    }

    @Override
    public IServiceCmd<DefaultContext> newInstance() {
        return new WebExcelDesign();
    }

    @Override
    public String getCmd() {
        return CMD;
    }
}
