package com.bokesoft.yes.design.cmd;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.dataMigration.util.DataMigrationOperJsonUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.utils.ReloadForm;
import com.bokesoft.yes.erp.dev.MetaTableCache;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigration;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigrationList;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigrationProfile;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class WebDataMigration extends DesignerServiceCmd {
	public static final String CMD = "WebDataMigration";
	/**
	 * 工程Key
	 */
	private String projectKey;
	/**
	 * 路径
	 */
	private String filePath;
	/**
	 * 源formkey
	 */
	private String sourceFormKey;
	/**
	 * 目标表单
	 */
	private String targetFormKey;
	/**
	 * 关联数据迁移
	 */
	private String extend;
	/**
	 * 映射标识
	 */
	private String key;
	/**
	 * 映射说明
	 */
	private String caption;
	/**
	 * 操作标识
	 */
	private int type;
	/**
	 * 常量CONST_ONE
	 */
	public static final int CONST_ONE = 1;
	/***常量CONST_TWO*/
	public static final int CONST_TWO = 2;
	/***常量true*/
	public static final String CONST_TRUE = "true";
	/***常量false*/
	public static final String CONST_FALSE = "false";
	/***常量result*/
	public static final String CONST_RESULT = "result";
	/***数据迁移操作类*/
	private static final DataMigrationOperJsonUtil dataMigrationOperJsonUtil;

	static {
		dataMigrationOperJsonUtil = new DataMigrationOperJsonUtil();
	}

	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		filePath = FilePathHelper.toBackFilePath((String) arguments.get("filePath"));
		projectKey = (String) arguments.get("projectKey");
		sourceFormKey = (String) arguments.get(ConstantUtil.SOURCE_FORM_KEY);
		targetFormKey = (String) arguments.get(ConstantUtil.TARGET_FORM_KEY);
		key = (String) arguments.get("key");
		caption = (String) arguments.get("caption");
		type = Integer.parseInt(String.valueOf(arguments.get("type")));
		extend = (String) arguments.get("extend");
	}

	@Override
	public Object innerDoCmd(DefaultContext defaultContext) throws Throwable {
		JSONObject result = new JSONObject();
		//是否是新增操作
		if (CONST_ONE == type) {
			IMetaFactory iMetaFactory = MetaFactory.getGlobalInstance();
			MetaDataMigrationList dataMigrationList = iMetaFactory.getDataMigrationList();
			boolean isExist = dataMigrationList.containsKey(key);
			if (isExist) {
				throw new Exception("当前输入的数据迁移标识已经存在,请重新输入");
			}
			if(dataMigrationOperJsonUtil.existDataMigrationVest(extend, iMetaFactory)){
				result.put("code", 1);
				result.put("msg", "新增数据迁移马甲失败：已存在" + extend + "的数据迁移马甲");
			}else {
				Map<String, String> res = dataMigrationOperJsonUtil.createDataMigrationXml(projectKey, sourceFormKey, targetFormKey, key, caption, extend, "0");
				if (CONST_TRUE.equals(res.get(CONST_RESULT))) {
					// 设置文件路径
					this.filePath = res.get("filePath");
					// 成功
					result.put("code", 0);
					result.put("msg", "新增数据迁移成功");
					result.put("filePath", this.filePath);
					//实体处理
					reloadDataMigration(iMetaFactory, dataMigrationList);
					//前端重新装载xml文件命令
					List<UICommand> uiCommands = new ArrayList<>();
					uiCommands.add(UICommand.reloadFileTree(this.filePath));
					uiCommands.add(UICommand.reloadMenuTree());
					result.put("uICommands", UICommand.toJson(uiCommands));
					result.put("caption", this.caption);
					result.put("version", "V1");
				} else {
					result.put("code", 1);
					result.put("msg", res.get("msg"));
				}
			}
		} else if (CONST_TWO == type) {
			// 打开数据迁移的时候去拿取数据
			JSONObject jsonFileContent = getJsonFileContent(filePath);
			String sourceForm = jsonFileContent.getJSONObject(ConstantUtil.DATA_MIGRATIONPROPS).getJSONObject(ConstantUtil.DATA_MIGRATIONPROPS)
					.getJSONObject("sourceForm").getString("value");
			String targetForm = jsonFileContent.getJSONObject(ConstantUtil.DATA_MIGRATIONPROPS).getJSONObject(ConstantUtil.DATA_MIGRATIONPROPS)
					.getJSONObject("targetForm").getString("value");
			IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
			MetaDataObject tagetDataObject = globalInstance.getDataObject(targetForm);
			MetaDataObject metaDataObject = globalInstance.getDataObject(sourceForm);
			String sourceCaption = metaDataObject.getCaption();
			String targetCaption = tagetDataObject.getCaption();
			String extend = (String) jsonFileContent.get("extend");

			result.put("jsonFileContent", jsonFileContent);
			result.put("sourceCaption", sourceCaption);
			result.put("targetCaption", targetCaption);
			result.put("sourceForm", sourceForm);
			result.put("targetForm", targetForm);
			String linkDataMigrationCaption = getLinkCaption(extend, globalInstance);
			result.put("linkDataMigrationCaption", linkDataMigrationCaption);
			String linkDataMigrationPath = LoadFileTree.getDataMigrationPathByKey(extend);
			result.put("linkDataMigrationPath", linkDataMigrationPath);
			// 设置json null值输出，并以空字符串方式显示
			return JSONObject.toJSONString(result,
					SerializerFeature.WriteMapNullValue,
					SerializerFeature.WriteNullStringAsEmpty,
					SerializerFeature.DisableCircularReferenceDetect);
		}
		return result;
	}

	public static JSONObject getJsonFileContent(String tmpFile) throws Throwable {
		return dataMigrationOperJsonUtil.convertXmlToJson(tmpFile);
	}

	private void reloadDataMigration(IMetaFactory iMetaFactory, MetaDataMigrationList dataMigrationList) throws Throwable {
		MetaDataMigrationProfile metaDataMigrationProfile = new MetaDataMigrationProfile();
		MetaDataMigration metaDataMigration = new MetaDataMigration();
		metaDataMigrationProfile.setKey(key);
		metaDataMigrationProfile.setCaption(caption);
		metaDataMigrationProfile.setTgtDataObjectKey(targetFormKey);
		metaDataMigrationProfile.setSrcDataObjectKey(sourceFormKey);
		MetaProject metaProject = iMetaFactory.getMetaProject(projectKey);
		metaDataMigrationProfile.setProject(metaProject);
		String resource = LoadFileTree.getResource(filePath,projectKey);
		metaDataMigrationProfile.setResource(resource);
		metaDataMigration.setKey(key);
		metaDataMigration.setCaption(caption);
		metaDataMigration.setProject(metaProject);
		metaDataMigration.setSrcDataObjectKey(sourceFormKey);
		metaDataMigration.setTgtDataObjectKey(targetFormKey);
		metaDataMigrationProfile.setDataMigration(metaDataMigration);
		if(StringUtils.isNotEmpty(extend)){
			metaDataMigrationProfile.setExtend(extend.split(" ")[0]);
		}
		dataMigrationList.add(metaDataMigrationProfile);
		ReloadForm.reloadDataMigrationKey(iMetaFactory, key, resource);
		MetaTableCache.updateMetaTables(iMetaFactory, metaDataMigration);
	}

	@Override
	public String getCmd() {
		return CMD;
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new WebDataMigration();
	}

	/**
	 * @param extend
	 * @param iMetaFactory
	 * @return 返回caption
	 */
	private String getLinkCaption(String extend, IMetaFactory iMetaFactory) throws Throwable{
		String linkDataMigrationCaption = null;
		MetaDataMigrationList dataMigrationList = iMetaFactory.getDataMigrationList();
		Iterator<MetaDataMigrationProfile> iterator = dataMigrationList.iterator();
		while (iterator.hasNext()){
			MetaDataMigrationProfile dataMigrationProfile = iterator.next();
			if (StringUtils.isEmpty(extend)) {
				break;
			}
			if (dataMigrationProfile.getDataMigration().getKey().equals(extend)) {
				linkDataMigrationCaption = dataMigrationProfile.getDataMigration().getCaption();
				break;
			}
		}
		return linkDataMigrationCaption;
	}

}
