package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.DiffProperty;
import com.bokesoft.yes.design.MetaObjectType;
import com.bokesoft.yes.design.Property;
import com.bokesoft.yes.design.io.IOMetaObject;
import com.bokesoft.yes.design.utils.IDLookup;
import com.bokesoft.yes.view.uistruct.FormDependency;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaBlock;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.panel.MetaPanel;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.tools.ve.VE;
import com.bokesoft.yigo.view.UIExprManager;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.Objects;

/**
 * Web界面构建的差异处理
 */
public class WebBuilderDiffProcessor {
    public static final WebBuilderDiffProcessor instance = new WebBuilderDiffProcessor();

    public List<UICommand> processDiff(DefaultContext context, List<Diff> diffs, List<UICommand> uiCommands) throws Throwable {
        for (Diff diff : diffs) {
            MetaForm metaForm = diff.getMetaForm();
            String fieldKey = diff.getKey();

            if (Objects.equals(diff.getMetaObjectType(), MetaObjectType.dataSource)) {
                return uiCommands;
            }
            if (diff.isGridColumnDrag()) {
                return uiCommands; // 表格列拖拽
            }
            if (StringUtils.isNotBlank(diff.caption)) { //新增
                if (Objects.equals(diff.getMetaObjectType(), MetaObjectType.grid)) {
                    addUICommandReloadDependency(context, metaForm, uiCommands);
                }
                return uiCommands;
            }
            if (diff.isDelete) { // 删除
                if (Objects.equals(diff.getMetaObjectType(), MetaObjectType.grid) || Objects.equals(diff.getMetaObjectType(), MetaObjectType.gridField)) {
                    addUICommandReloadDependency(context, metaForm, uiCommands);
                }
                return uiCommands;
            }

            for (DiffProperty diffProperty : diff.properties) {
                Property property = diffProperty.property;
                if (Objects.equals(diffProperty.property, Property.CheckRule)) {
                    //放在UIFormDiffProcessor里处理
                    continue;
                }

                if (Objects.equals(diffProperty.property, Property.RowTableKey)) {
                    continue;
                }

                if ((property == Property.enable || property == Property.visible)) {
                    if (Objects.equals(diff.getMetaObjectType(), MetaObjectType.operation)) {
                        continue;
                    }
                    //addUICommandReloadDependency(context, metaForm, uiCommands);
                    continue;
                }

                if (Objects.equals(property, Property.valueChanged) || Objects.equals(property, Property.defaultFomulaValue) || Objects.equals(property, Property.defaultValue)) {
                    addUICommandReloadDependency(context, metaForm, uiCommands);
                }

                if (Objects.equals(diff.getMetaObjectType(), MetaObjectType.gridField)) {
                    if (Objects.equals(diffProperty.property, Property.key)) {
                        continue;
                    }
                    String gridKey = IOMetaObject.gridMap.get(fieldKey);
                    MetaComponent metaComponent = metaForm.componentByKey(gridKey);
                    MetaComponent metaComponent1 = metaComponent;
                    metaComponent = decideAllUIComponents(metaComponent, diff);
                    if (!Objects.equals(metaComponent, metaComponent1)) { // 用于解决metaform可能不是要使用的metaform的问题
                        metaForm = MetaFactory.getGlobalInstance().getMetaForm(diff.formKey);
                    }
                    continue;
                }

                if (Objects.equals(diff.getMetaObjectType(), MetaObjectType.listViewField)) { //listView field处理
                    if (StringUtils.equalsIgnoreCase(property.name, Property.key.name)) {
                        continue;
                    }
                    String listViewKey = IOMetaObject.listViewMap.get(fieldKey);
                    MetaComponent metaComponent = metaForm.componentByKey(listViewKey);
                    MetaComponent metaComponent1 = metaComponent;
                    metaComponent = decideAllUIComponents(metaComponent, diff);
                    if (!Objects.equals(metaComponent, metaComponent1)) {
                        metaForm = MetaFactory.getGlobalInstance().getMetaForm(diff.formKey);
                    }
                    continue;
                }

                if (Objects.equals(diff.getMetaObjectType(), MetaObjectType.field) || Objects.equals(diff.getMetaObjectType(), MetaObjectType.panel) || Objects.equals(diff.getMetaObjectType(), MetaObjectType.grid)) {
                    if (Objects.equals(property, Property.key) || Objects.equals(property, Property.caption)) {
                        continue;
                    }
                    if (Objects.equals(property, Property.buddyCaption) || Objects.equals(property, Property.buddyX) || Objects.equals(property, Property.buddyY)) {
                        IDLookup idLookup = IDLookup.getIDLookup(metaForm);
                        MetaComponent metaComp = (MetaComponent) idLookup.getMetaObjectColumnByKey(fieldKey);
                        String buddyKey = metaComp.getBuddyKey();
                        MetaComponent metaComponent = (MetaComponent) idLookup.getMetaObjectColumnByKey(buddyKey); //获取Label
                        MetaComponent tempComponent = metaComponent;
                        metaComponent = decideAllUIComponents(metaComponent, diff);
                        if (tempComponent != metaComponent) {
                            metaForm = MetaFactory.getGlobalInstance().getMetaForm(diff.formKey);
                        }
                        continue;
                    }
                    IDLookup idLookup = IDLookup.getIDLookup(metaForm);
                    MetaComponent metaComponent = (MetaComponent) idLookup.getMetaObjectColumnByKey(fieldKey);
                    if (Objects.isNull(metaComponent)) {
                        metaComponent = idLookup.getNoFieldComponent(fieldKey);
                    }
                    MetaComponent tempComponent = metaComponent;
                    metaComponent = decideAllUIComponents(metaComponent, diff);
                    if (tempComponent != metaComponent) {
                        metaForm = MetaFactory.getGlobalInstance().getMetaForm(diff.formKey);
                    }
                    continue;
                }

                if (Objects.equals(diff.getMetaObjectType(), MetaObjectType.operation)) {
                    MetaBlock ownerMetaBlock = (MetaBlock) metaForm.getMetaBody().get(0);
                    MetaPanel ownerMetaPanel = (MetaPanel) ownerMetaBlock.getRoot();
                    MetaComponent component = ownerMetaPanel.getComponent(0);
                    if (component.getControlType() == ControlType.TOOLBAR) {
                        continue;
                    }
                    uiCommands.add(UICommand.reloadFormKey(diff.formKey)); // 字典操作
                }
            }
        }
        return uiCommands;
    }

    private void addUICommandReloadDependency(DefaultContext context, MetaForm metaForm, List<UICommand> uiCommands) throws Throwable {
         VE ve = context.getVE();
         UIExprManager manager = new UIExprManager(metaForm, ve);
         FormDependency dependency = manager.build();
         uiCommands.add(UICommand.reloadDependency(dependency.toJSON()));
    }

    private MetaComponent decideAllUIComponents(MetaComponent metaComponent, Diff diff) throws Throwable {
        if (Objects.isNull(metaComponent)) {
            MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(diff.formKey);
            metaComponent = (MetaComponent) IDLookup.getIDLookup(metaForm).getMetaObjectColumnByKey(diff.getKey());
        }
        return metaComponent;
    }
}
