package com.bokesoft.yes.design.cmd;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.common.util.DateUtil;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.bpm.util.BpmOperToJsonUtil;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.utils.XMLWriter;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.meta.bpm.process.ProcessDefinitionProfile;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.factory.workflow.ProcessSourceType;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * B/s模式工作流实现类
 *
 * @author zhsy
 * @date 2020-08-10
 */
public class WebBpmDesignCmd extends DesignerServiceCmd {

	public static final String CMD = "WebBpmDesign";

	/***操作类型 1：新增；2：修改；3：删除*/
	private String operType = "NewWork";

	/***projectKey*/
	private String projectKey;
	/***formKey*/
	private String formKey;
	/***formCaption*/
	private String formCaption;
	/***filePath*/
	private String filePath;

	/***常量CONST_ONE*/
	public static final String CONST_ONE = "NewWork";
	/***常量CONST_TWO*/
	public static final String CONST_TWO = "SelectWork";
	public static final String CONST_FOUR = "NewBpmVersion";
	/***常量CONST_THREE*/
	public static final String CONST_THREE = "DeployBpm";

	/***常量true*/
	public static final String CONST_TRUE = "true";
	/***常量false*/
	public static final String CONST_FALSE = "false";
	/***常量result*/
	public static final String CONST_RESULT = "result";

	/***BPM操作类*/
	private static final BpmOperToJsonUtil bpmOperUtil;

	static {
		bpmOperUtil = new BpmOperToJsonUtil();
	}

	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) {
		filePath = FilePathHelper.toBackFilePath((String) arguments.get("filePath"));
		projectKey = (String) arguments.get("projectKey");
		formKey = (String) arguments.get("newFormKey");
		formCaption = (String) arguments.get("formCaption");
		operType = (String) (arguments.get("operType"));
	}

	@Override
	public Object innerDoCmd(DefaultContext context) throws Throwable {
		JSONObject result = new JSONObject();
		if (CONST_ONE.equalsIgnoreCase(operType)) {//新增工作流
			// 新增
			Map<String, String> res = bpmOperUtil.createXml(projectKey, formKey, formCaption, "0");
			if (CONST_TRUE.equals(res.get(CONST_RESULT))) {
				saveBpmXml(result, res, 1);
			} else {
				result.put("code", 1);
				result.put("msg", res.get("msg"));
			}
		} else if (CONST_TWO.equalsIgnoreCase(operType)) {//查询
			// 修改
			JSONObject jsonFileContent = getJsonFileContent(this.filePath);
			result.put("jsonFileContent", jsonFileContent);
			result.put("caption", jsonFileContent.getJSONObject("props").getJSONObject("props")
					.getJSONObject(ConstantUtil.CAPTION).getString("value"));
			result.put("version", "V" + jsonFileContent.getJSONObject("props").getJSONObject("props")
					.getJSONObject(ConstantUtil.VERSION).getString("value"));
			// 设置json null值输出，并以空字符串方式显示
			return JSONObject.toJSONString(result,
					SerializerFeature.WriteMapNullValue,
					SerializerFeature.WriteNullStringAsEmpty,
					SerializerFeature.DisableCircularReferenceDetect);
		} else if (CONST_THREE.equalsIgnoreCase(operType)) {//部署
			List<UICommand> result1 = new ArrayList<UICommand>();
			FileOutputStream fileOutputStream = null;
			XMLWriter writer = null;
			try {
				// 工作流xml文件路径
				// 获取发布BPM的路径
				File workFlowFile = new File(filePath);
				String parentPath = workFlowFile.getParent();
				String bpmFilePath = parentPath.substring(0, parentPath.length() - 4) + File.separator + "BPM.xml";
				// 前端传过来的要更新的json
				// 创建SAX读取器
				SAXReader reader = new SAXReader();
				// 加载文档
				Document document = reader.read(new File(bpmFilePath));
				// 获取根节点
				Element root = document.getRootElement();
				if (null == root.element("DeployInfoCollection")) {
					root.addElement("DeployInfoCollection");
				}
				// 若存在，先删除
				if (null != root.element("DeployInfoCollection").elements("DeployInfo")) {
					List<Element> deployInfoList = root.element("DeployInfoCollection").elements("DeployInfo");
					for (Element ele : deployInfoList) {
						if (formKey.equals(ele.attributeValue(ConstantUtil.KEY))) {
							root.element("DeployInfoCollection").remove(ele);
						}
					}
				}
				// 后新增
				root.element("DeployInfoCollection").addElement("DeployInfo")
						.addAttribute("InitDate",
								DateUtil.getDateFormatText(null, "yyyy-MM-dd HH:mm:ss"))
						.addAttribute(ConstantUtil.KEY, formKey);

				// 格式化输出流，同时指定编码格式。也可以在FileOutputStream中指定。
				OutputFormat format = getOutputFormat();

				fileOutputStream = new FileOutputStream(bpmFilePath);
				writer = new XMLWriter(fileOutputStream, format);
				writer.write(document);
			} catch (Exception e) {
				LogSvr.getInstance().error(e.getMessage(), e);
			} finally {
				closeFileStream(fileOutputStream, writer);
			}
			result1.add(UICommand.showTip("工作流:"+formKey+"部署成功"));
			return  UICommand.toJson(result1);
		} else if (CONST_FOUR.equalsIgnoreCase(operType)) {//新增版本

			XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(filePath);
			String version = xmlTreeWithPath.xmlTree.getRoot().getAttributes().get("Version");
			version = StringUtils.isEmpty(version) ? "1" : version;
			//处理bpm实体
			IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
			HashMap<String, ProcessDefinitionProfile> profileMap = globalInstance.getMetaBPM().getProfileMap();
			String[] vs = formKey.split("_V");
			if (vs.length > 0) {
				formKey = vs[0];
			}
			ProcessDefinitionProfile processDefinitionProfile = profileMap.get(formKey + "_V" + version);
			projectKey = processDefinitionProfile.getProject().getKey();
			Map<String, String> res = bpmOperUtil.createXml(projectKey, formKey, processDefinitionProfile.getCaption(), version);
			saveBpmXml(result, res, Integer.valueOf(res.get("version")));
		}
		return result;
	}

	/***
	 * 关闭文件流
	 * @param fileOutputStream 文件输出流
	 * @param writer 写对象
	 */
	private void closeFileStream(FileOutputStream fileOutputStream, XMLWriter writer) {
		try {
			if (null != fileOutputStream) {
				fileOutputStream.close();
			}
			if (null != writer) {
				writer.close();
			}
		} catch (Exception e) {
		}
	}

	/***
	 * 写xml格式化
	 * @return 格式化类
	 */
	private OutputFormat getOutputFormat() {
		// 格式化输出流，同时指定编码格式。也可以在FileOutputStream中指定。
		OutputFormat format = OutputFormat.createPrettyPrint();
		// 设置xml标签和Process标签之间没有空行
		format.setNewLineAfterDeclaration(false);
		format.setIndentSize(4);
		format.setExpandEmptyElements(false);
		format.setPadText(false);
		return format;
	}

	private void saveBpmXml(JSONObject result, Map<String, String> res, Integer version) throws Throwable {
		// 设置文件路径
		this.filePath = res.get("filePath");
		this.formCaption = res.get("caption");
		// 成功
		result.put("code", 0);
		result.put("msg", "新增文件成功");
		result.put("filePath", this.filePath);
		//前端重新装载xml文件命令
		List<UICommand> uiCommands = new ArrayList<>();
		uiCommands.add(UICommand.reloadFileTree(this.filePath));
		uiCommands.add(UICommand.reloadMenuTree());
		result.put("uICommands", UICommand.toJson(uiCommands));
		result.put("caption", this.formCaption + "V" + version);
		result.put("version", "V" + version);
		result.put("formKey", "V" + formKey + "_V" + version);
		//处理bpm实体
		IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
		ProcessDefinitionProfile formProfile = new ProcessDefinitionProfile();
		HashMap<String, ProcessDefinitionProfile> profileMap = globalInstance.getMetaBPM().getProfileMap();
		MetaProject metaProject = globalInstance.getMetaProject(projectKey);
		formProfile.setKey(formKey);
		formProfile.setCaption(formCaption);
		formProfile.setVersion(version);
		formProfile.setResource(projectKey + File.separator + "BPM/" + formKey + ".xml");
		formProfile.setProject(metaProject);
		formProfile.setSourceType(ProcessSourceType.DIRECTORY);
		profileMap.put(formKey + "_V" + version, formProfile);
	}

	public static JSONObject getJsonFileContent(String filePath) throws Throwable {
		return bpmOperUtil.convertXmlToJson(filePath);
	}

	@Override
	public String getCmd() {
		return CMD;
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new WebBpmDesignCmd();
	}

}
