package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.DiffProperty;
import com.bokesoft.yes.design.MetaObjectType;
import com.bokesoft.yes.design.Property;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yigo.meta.form.MetaForm;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 差异的界面处理
 */
public class UIFormDiffProcessor {
	public static final UIFormDiffProcessor instance = new UIFormDiffProcessor();

	public static String Error = null;

	public List<UICommand> 	processDiff(List<Diff> diffs, List<UICommand> uiCommands, boolean genPropertyDiffSuccess, String xmlError, int anInt) throws Throwable {
		Error = xmlError;
		if (!genPropertyDiffSuccess || Diff.hasGridColumnDrag(diffs)) { //改源代码不走实体修改直接根据xml重新加载
			if (diffs.get(0).getMetaObjectType() == MetaObjectType.ToolBar) {
				uiCommands.add(UICommand.refreshMenuTree(diffs.get(0).formKey));
				uiCommands.add(UICommand.reloadFormKey(diffs.get(0).formKey));
				uiCommands.add(new UICommand("GetType", ConstantUtil.TOOL_BAR));
				uiCommands.add(UICommand.locate(diffs.get(0).getKey()));//每次修改源代码时需要刷新树
			} else {
				if (StringUtils.isBlank(xmlError)) {
					String formKey = diffs.get(0).formKey;
					uiCommands.add(UICommand.refreshMenuTree(formKey));
					uiCommands.add(UICommand.reloadFormKey(formKey));
					if (diffs.get(0).isEmbed != null && diffs.get(0).isEmbed) {//嵌入组件的加载方式
						uiCommands.add(new UICommand("GetType", diffs.get(0).getMetaObjectType()));
						uiCommands.add(UICommand.locate(diffs.get(0).getKey() + "Embed"));
					} else {
						if (StringUtils.isNotBlank(diffs.get(0).getKey())) {
							if (diffs.get(0).parentKey!=null) {
								uiCommands.add(UICommand.locate(diffs.get(0).parentKey));
							}
							uiCommands.add(UICommand.locate(diffs.get(0).getKey()));//每次修改源代码时需要刷新树
						}
					}
				} else {
					uiCommands.add(UICommand.showError(xmlError));
				}
			}
			if (Diff.hasGridColumnDrag(diffs)) {
				uiCommands.add(UICommand.reloadXmlSource(diffs.get(0).getFilePath()));
			}
		} else {
			uiCommands = processDiff(diffs, uiCommands, anInt);
		}

		//diffs.stream().filter(str-> Objects.equals("王五", str)).forEach(str->str.getParamsformKey());
		//以下添加父表单
		String paramsformKey = diffs.get(0).getParamsformKey();
		if (!paramsformKey.equals(diffs.get(0).formKey)) {
			String pathByFormKey = LoadFileTree.getPathByFormKey(paramsformKey);
			uiCommands.add(UICommand.reloadFormKey(paramsformKey));
			uiCommands.add(UICommand.reloadXmlSource(pathByFormKey));
		}
		return uiCommands;
	}

	public List<UICommand> processDiff(List<Diff> diffs, List<UICommand> uiCommands, int anInt) throws Throwable {
		for (Diff diff : diffs) {
			String formKey = diff.formKey;
			if (diff.caption != null || (diff.isButtonQuote !=null && diff.isButtonQuote)) { //新增
				if (diff.getMetaObjectType() != MetaObjectType.DataObject) {
					uiCommands.add(UICommand.refreshMenuTree(formKey));
					uiCommands.add(UICommand.reloadFormKey(formKey));
				}
				if (diff.getMetaObjectType() == MetaObjectType.field || diff.getMetaObjectType() == MetaObjectType.grid
						|| diff.getMetaObjectType() == MetaObjectType.panel || diff.getMetaObjectType() == MetaObjectType.listView) {//component
					uiCommands.add(new UICommand("GetType", diff.getMetaObjectType()));
					uiCommands.add(UICommand.locate(diff.getKey()));
				} else if (diff.getMetaObjectType() == MetaObjectType.gridField
						|| diff.getMetaObjectType() == MetaObjectType.GridFieldMultiRowTable) {//表格列（单元格）
					uiCommands.add(new UICommand("GetType", "columnheader"));
					if (diff.sideKey.equals(diff.parentKey)) {
						uiCommands.add(UICommand.locate(diff.parentKey));
					} else {
						uiCommands.add(UICommand.locate(diff.getKey())); //列的key
					}
				} else if (diff.getMetaObjectType() == MetaObjectType.operation) {
					uiCommands.add(UICommand.locate(diff.getKey()));
				} else if (diff.getMetaObjectType() == MetaObjectType.TableView) {
					uiCommands.add(UICommand.locate(diff.getKey()));
				}  else if (diff.getMetaObjectType() == MetaObjectType.ListViewColumn) {
					uiCommands.add(UICommand.locate(diff.getKey()));
				} else if (diff.getMetaObjectType() == MetaObjectType.operationCollection) {
					uiCommands.add(UICommand.locate("HeadOperationCollection" + anInt));
				} else if (diff.getMetaObjectType() == MetaObjectType.GridFieldRow) {
					uiCommands.add(UICommand.locate(diff.parentKey));
					uiCommands.add(UICommand.locate(diff.getKey()));
				} else if (diff.getMetaObjectType() == MetaObjectType.subDetail) {
					if (!diff.isButtonQuote) {
						if ("Grid".equalsIgnoreCase(XmlDiffProcessor.subDetailBind)) {//这个主要是为了分情况渲染页面
							uiCommands.add(UICommand.reloadFormKey(diff.formKey));//面板布局属性修改需要重新loadform来直接看到修改的结果
							uiCommands.add(UICommand.locate("SubGrid" + anInt));
						} else if (ConstantUtil.GRID_LAYOUT_PANEL.equalsIgnoreCase(XmlDiffProcessor.subDetailBind)) {
							uiCommands.add(UICommand.locate("tempGridLayoutPanel" + anInt));
						}
					} else if (diff.getMetaObjectType() == MetaObjectType.DataObject) {
						String path = diff.getFilePath();
						//重新加载一下XML
						uiCommands.add(UICommand.reloadXmlSource(path));
					} else {
						uiCommands.add(UICommand.locate("tempGridLayoutPanel" + anInt));
					}

				} else if (diff.getMetaObjectType() == MetaObjectType.EmbedPanel) {
					uiCommands.add(new UICommand("GetType", "Panel"));
					uiCommands.add(UICommand.locate(diff.getKey()));
				}
			} else if (diff.isDelete) { //删除
				uiCommands.add(UICommand.refreshMenuTree(formKey));
				uiCommands.add(UICommand.reloadFormKey(formKey));
				if (diff.getMetaObjectType() == MetaObjectType.field) {// 头表字段，考虑非首个tab页内的组件删除，需要重新定位
					uiCommands.add(UICommand.locate(diff.parentKey));
				} else if (diff.getMetaObjectType() == MetaObjectType.gridField) {//表格列（单元格）
					uiCommands.add(UICommand.locate(diff.parentKey));
				} else if (diff.getMetaObjectType() == MetaObjectType.operation) {
				} else if (diff.getMetaObjectType() == MetaObjectType.operationCollection) {
				} else if (diff.getMetaObjectType() == MetaObjectType.toolbar || diff.getMetaObjectType() == MetaObjectType.Embed) {
					uiCommands.add(UICommand.locate(formKey));
				} else if (diff.getMetaObjectType() == MetaObjectType.GridFieldRow) {
					uiCommands.add(UICommand.locate(diff.getKey()));
				} else if (diff.getMetaObjectType() == MetaObjectType.ListViewColumn) {
					uiCommands.add(UICommand.locate(formKey));
				}else {
					uiCommands.add(UICommand.locate(diff.parentKey));
				}
			} else if (MetaObjectType.DataOperationToobar == diff.getMetaObjectType()){
				uiCommands.add(UICommand.refreshMenuTree(formKey));
				uiCommands.add(UICommand.reloadFormKey(diff.formKey));
			} else if (MetaObjectType.ExtraLayout == diff.getMetaObjectType()){
				uiCommands.add(UICommand.reloadFormKey(formKey));
				uiCommands.add(UICommand.locate(diff.getKey()));
			}else { //修改
				MetaForm metaForm = diff.getMetaForm();
				for (DiffProperty diffProperty : diff.properties) {
					Property property = diffProperty.property;
					if (property == Property.defaultValue || property == Property.ShowZero || property == Property.StripTrailingZeros || property == Property.maxLength || property == Property.Scale || property == Property.CheckRule || property == Property.required || property == Property.Second || property == Property.defaultFomulaValue || property == Property.columnKey) {
						if (diff.getMetaObjectType() == MetaObjectType.gridField) {
							//uiCommands.add(UICommand.renderControl(IOMetaObject.gridMap.get(diff.getKey())));
							uiCommands.add(UICommand.reloadFormKey(formKey));
							if (property == Property.CheckRule || property == Property.required || property == Property.Item || property == Property.itemKey) {
								uiCommands.add(UICommand.reloadFormKey(formKey));
							}
							uiCommands.add(UICommand.locate(diff.getKey()));
						} else if (diff.getMetaObjectType() == MetaObjectType.listViewField) {
							//uiCommands.add(UICommand.renderControl(IOMetaObject.listViewMap.get(diff.getKey())));
							uiCommands.add(UICommand.reloadFormKey(formKey));
						} else if (diff.getMetaObjectType() == MetaObjectType.field) {
							if (property == Property.defaultValue || property == Property.defaultFomulaValue) {
								//	uiCommands.add(UICommand.renderControl(diff.getKey())); //
								// 这里要去掉一些重复操作，比如说reloadControl和reloadPanel之间
								uiCommands.add(UICommand.reloadFormKey(formKey));
								uiCommands.add(UICommand.locate(diff.getKey()));
							} else if (property == Property.StripTrailingZeros || property == Property.ShowZero || property == Property.required) {
								uiCommands.add(UICommand.reloadFormKey(formKey));
								uiCommands.add(UICommand.locate(diff.getKey()));
								// TODO: 这里要去掉一些重复操作，比如说reloadControl和reloadPanel之间
							} else {
//								uiCommands.add(UICommand.reloadFormKey(formKey));
//								uiCommands.add(UICommand.renderControl(diff.getKey()));
//								uiCommands.add(UICommand.locate(diff.parentKey));
								uiCommands.add(UICommand.reloadFormKey(formKey));
								uiCommands.add(UICommand.locate(diff.getKey()));
							}
//							uiCommands.add(UICommand.refreshAndLocate(diff.getKey()));
							//	uiCommands.add(UICommand.reloadFileTree(diff.getKey()));
						} else if (diff.getMetaObjectType() == MetaObjectType.comboBoxType) {
							//为了下拉框数据实时回显就刷新一下表单
							uiCommands.add(UICommand.reloadFormKey(formKey));
						}
					} else if (diff.getMetaObjectType() == MetaObjectType.DictViewColumn) {
						uiCommands.add(UICommand.reloadFormKey(formKey));
						uiCommands.add(UICommand.locate(diff.getKey()));
						//uiCommands.add(UICommand.renderControl(diff.getKey()));
					} else if (diff.getMetaObjectType() == MetaObjectType.dataSource) {
						if (Error != null && Error.length() > 0) {
							uiCommands.add(UICommand.showError(Error));
						} else {
							uiCommands.add(UICommand.reloadFormKey(formKey));
						}
					} else if(diff.getMetaObjectType() == MetaObjectType.TabItem) {
						
						
						
					} else if (property == Property.key || property == Property.caption) { //重新定位
						uiCommands.add(UICommand.refreshMenuTree(formKey));
						uiCommands.add(UICommand.reloadFormKey(formKey));
						uiCommands.add(UICommand.locate(diff.getKey()));
					} else if (property == Property.buddyCaption) {
						uiCommands.add(UICommand.reloadFormKey(diff.formKey));
					} else if (property == Property.enable || property == Property.visible) {
						// 现在前端刷新表单依赖的代码都放在了reloadForm中
						uiCommands.add(UICommand.reloadFormKey(diff.formKey));
						//uiCommands.add(UICommand.resetUIStatus());
						//uiCommands.add(UICommand.locate(diff.getKey()));
					} else if (property == Property.DataObjectCheckRule) {
						if (!"new".equalsIgnoreCase(diff.properties.get(0).newValue)) {
							uiCommands.add(UICommand.showError(diff.properties.get(0).newValue));
						}
					} else if (property == Property.Layout || property == Property.Separate
							|| property == Property.Orientation || diff.getMetaObjectType() == MetaObjectType.AddRowPanel) {
						uiCommands.add(UICommand.reloadFormKey(diff.formKey));//面
						// 板布局属性修改需要重新loadform来直接看到修改的结果
						uiCommands.add(UICommand.locate(diff.getKey()));
						//uiCommands.add(UICommand.renderPanelLayout(diff.getKey()));
					} else if (property == Property.x || property == Property.y
							|| property == Property.buddyX || property == Property.buddyY) {
						String fieldKey = diff.getKey();
						uiCommands.add(UICommand.reloadFormKey(formKey));
						uiCommands.add(UICommand.locate(fieldKey));
					} else if (property == Property.Second || property == Property.Stretch || property == Property.ImageCut) {
						if (diff.getMetaObjectType() == MetaObjectType.gridField) {
							//uiCommands.add(UICommand.renderControl(IOMetaObject.gridMap.get(diff.getKey())));
							uiCommands.add(UICommand.reloadFormKey(diff.getDictType()));
						} else {
							uiCommands.add(UICommand.reloadFormKey(diff.formKey));//面板布局属性修改需要重新loadform来直接看到修改的结果
							uiCommands.add(UICommand.locate(diff.getKey()));
						}
					} else if (property == Property.OnlyShow) {
						uiCommands.add(UICommand.reloadFormKey(diff.formKey));//面板布局属性修改需要重新loadform来直接看到修改的结果
						uiCommands.add(UICommand.locate(diff.getKey()));
					} else if (property == Property.XSpan) {
						uiCommands.add(UICommand.reloadFormKey(formKey));
						uiCommands.add(UICommand.locate(diff.getKey()));
					} else if (property == Property.YSpan) {
						uiCommands.add(UICommand.reloadFormKey(formKey));
						uiCommands.add(UICommand.locate(diff.getKey()));
					} else if ("BasicAttribute".equals(diff.getMetaObjectType().name) && ConstantUtil.TYPE.equals(diff.getReserveOne())) {
						uiCommands.add(UICommand.reloadFormKey("BasicAttribute"));
						uiCommands.add(UICommand.locate(diff.getKey()));
					} else if (property == Property.CellGroupType) {
						uiCommands.add(UICommand.reloadFormKey(formKey));
						uiCommands.add(UICommand.locate(diff.getKey()));
					} else if (property == Property.FormulaCaption) {
						uiCommands.add(UICommand.reloadFormKey(diff.formKey));
//						uiCommands.add(UICommand.refreshAndLocate(diff.properties.get(0).newValue));
						uiCommands.add(UICommand.locate(diff.getKey()));
					} else if (property == Property.DataOperationToobar) {
						if (Objects.isNull(metaForm.getDataSource())) {
							break;
						} else {
							uiCommands.add(UICommand.reloadFormKey(formKey));
							uiCommands.add(UICommand.locate(diff.getKey()));
						}
					} else if (property == Property.GroupKey) {
						uiCommands.add(UICommand.locate(diff.getKey()));
					} else {
						uiCommands.add(UICommand.reloadFormKey(formKey));
						uiCommands.add(UICommand.locate(diff.getKey()));
					}
				}
				if (diff.getMetaObjectType() == MetaObjectType.buttonReplace) {
					uiCommands.add(UICommand.reloadFormKey(formKey));
					uiCommands.add(new UICommand("GetType", "Panel"));
					uiCommands.add(UICommand.locate(diff.getKey()));
				} else if (diff.getMetaObjectType() == MetaObjectType.AddRowPanel) {
					uiCommands.add(UICommand.reloadFormKey(diff.formKey));//面板布局属性修改需要重新loadform来直接看到修改的结果
					uiCommands.add(UICommand.locate(diff.parentKey));
				} else if (diff.getMetaObjectType() == MetaObjectType.DeleteRowPanel) {
					uiCommands.add(UICommand.reloadFormKey(diff.formKey));//面板布局属性修改需要重新loadform来直接看到修改的结果
					uiCommands.add(UICommand.locate(diff.parentKey));
				} else if (diff.getMetaObjectType() == MetaObjectType.AddTableViewRow) {
					uiCommands.add(UICommand.reloadFormKey(diff.formKey));
					uiCommands.add(UICommand.locate((diff.getKey() != null && !diff.getKey().isEmpty()) ? diff.getKey() : diff.parentKey));
				} else if (diff.getMetaObjectType() == MetaObjectType.fieldCondition) {
					uiCommands.add(UICommand.reloadFormKey(diff.formKey));
				} else if (diff.getMetaObjectType() == MetaObjectType.comboboxSourceSetting) {
					uiCommands.add(UICommand.reloadFormKey(formKey));
					uiCommands.add(UICommand.locate(diff.getKey()));
				} else if (diff.getMetaObjectType() == MetaObjectType.AddRowLayout) {
					uiCommands.add(UICommand.reloadFormKey(diff.formKey));
					uiCommands.add(UICommand.locate(diff.parentKey));
				} else if (diff.getMetaObjectType() == MetaObjectType.DeleteRowLayout) {
					uiCommands.add(UICommand.reloadFormKey(diff.formKey));
					uiCommands.add(UICommand.locate(diff.parentKey));
				}
			}
			
			if (diff.getMetaObjectType() == MetaObjectType.TabItem) {
				if (diff.insertItemAfter) {
					uiCommands.add(UICommand.refreshMenuTree(formKey));
					uiCommands.add(UICommand.reloadFormKey(formKey));
					uiCommands.add(UICommand.locate(diff.parentKey + "@" + diff.getKey()));
				} if (diff.isDelete) {
				 
				} else {
					uiCommands.add(UICommand.reloadFormKey(formKey));
					uiCommands.add(UICommand.locate(diff.parentKey + "@" + diff.getKey()));
				}
			}
			
			
			if (StringUtils.isNotBlank(diff.getFilePath())) {
				uiCommands.add(UICommand.reloadXmlSource(diff.getFilePath()));
			}
			if (StringUtils.isNotBlank(diff.getDataObjectfilePath())) {
				uiCommands.add(UICommand.reloadXmlSource(diff.getDataObjectfilePath()));
			}
			if (StringUtils.isNotBlank(diff.getOtherDataObjectFilePath())) {
				uiCommands.add(UICommand.reloadXmlSource(diff.getOtherDataObjectFilePath()));
			}
		}
		if(diffs.get(0).isMultyDelete){     //去除重复的UICommand
			uiCommands = uiCommands.stream().distinct().collect(Collectors.toList());
		}
		return uiCommands;
	}
}
