package com.bokesoft.yes.design.cmd;

import com.bokesoft.erp.WebDesignerConfiguration;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.utils.DesignReloadMetaObject;
import com.bokesoft.yes.design.utils.XMLWriter;
import com.bokesoft.yes.erp.config.MetaFormNODBProcess;
import com.bokesoft.yes.helper.DataObjectHelper;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.log.LogSvr;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.def.TableMode;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.dom4j.*;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;

import static com.bokesoft.yes.design.datamap.util.DataMapOperXmlUtil.getOutputFormat;

/**
 *
 */
public class SetSourceDataObjectCmd extends DesignerServiceCmd {
	public static final String CMD = "SetSourceDataObject";
	private String subKey;
	private String sourceDataObjectValue;

	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		subKey = TypeConvertor.toString(arguments.get("subKey"));
		sourceDataObjectValue = TypeConvertor.toString(arguments.get("sourceDataObjectValue"));
	}

	@Override
	public Object innerDoCmd(DefaultContext context) throws Throwable {
		//检测是否有马甲
		for (MetaFormProfile metaFormProfile : MetaFactory.getGlobalInstance().getMetaFormList()) {
			if (subKey.equalsIgnoreCase(metaFormProfile.getExtend())){
				List<UICommand> result = new ArrayList<UICommand>();
				result.add(UICommand.showTip("此表单含有马甲,不支持此操作"));
				return UICommand.toJson(result);
			}
		}
		String filePath = LoadFileTree.getPathByFormKey(subKey);
		FileOutputStream fileOutputStream = null;
		XMLWriter writer = null;
		//	EntryProcessor.instance.NewProject(ProjectKey, ProjectCaption,SolutionKey);
		// 创建SAX读取器
		try {
			SAXReader reader = new SAXReader();
			// 加载文档
			Document document = reader.read(filePath);
			deleteChildAttributeValue(document.getRootElement());
			Element deleteNode = (Element) document.selectSingleNode("/Form/DataSource");
			if (deleteNode != null) {
				document.getRootElement().remove(deleteNode);
			}

			// 创建dom4j文档对象
			Document document1 = DocumentHelper.createDocument();
			// 使用文档对象创建根节点的xml
			Element dataSource = document1.addElement("DataSource");
			dataSource.addAttribute("RefObjectKey", sourceDataObjectValue);
			document.getRootElement().elements().add(0, dataSource);
			Node node = document.selectSingleNode("//Var[@Key='" + "SystemInfoTableKey" + "']");
			if (node != null) {
				Element element = (Element) node;
				MetaDataObject metaDataObject = MetaFactory.getGlobalInstance().getDataObject(sourceDataObjectValue);

				for (MetaTable metaTable : metaDataObject.getTableCollection()) {
					if (metaTable.getKey().endsWith(MetaFormNODBProcess.STR_NODBTable_Profix)) {
						continue;
					}
					int tableMode = metaTable.getTableMode();
					if (tableMode == TableMode.HEAD) {
						element.setAttributeValue("Value",metaTable.getKey()) ;
						break;
					}
				}
			}
			OutputFormat format = getOutputFormat();
			String newFilePath = FilePathHelper.toBackFilePath(WebDesignerConfiguration.getDesignerSolutionTmpDataPath(MetaFactory.getGlobalInstance().getMetaFormList().get(subKey).getProject().getKey())+ File.separator + new File(filePath).getName() + "." + System.currentTimeMillis());
			fileOutputStream = new FileOutputStream(newFilePath);
			writer = new XMLWriter(fileOutputStream, format);
			writer.write(document);
			XmlFileProcessor.stackput(filePath, newFilePath);
			DesignReloadMetaObject.reloadMetaFormRollbackError(null,subKey);
			String s = LoadFileTree.loadFilePathByDataObjectFieldKey(sourceDataObjectValue);
			DataObjectHelper.reload(null,sourceDataObjectValue, s, null);
			List<UICommand> result = new ArrayList<UICommand>();
			result.add(UICommand.reloadXmlSource(filePath));
			result.add(UICommand.reloadFormKey(subKey));
			result.add(UICommand.showTip("操作成功,如若撤销,请关闭此界面,点击设计界面的撤销"));
			return UICommand.toJson(result);
		} catch (MetaException e) {
			LogSvr.getInstance().error("\n", e);
			throw new RuntimeException("warning: " + e.getMessage());
		} catch (Exception e) {
			throw e;
		} finally {
			closeFileStream(fileOutputStream, writer);
		}
	}

	/***
	 * 关闭文件流
	 * @param fileOutputStream 文件输出流
	 * @param writer 写对象
	 */
	private void closeFileStream(FileOutputStream fileOutputStream, XMLWriter writer) {
		try {
			if (null != fileOutputStream) {
				fileOutputStream.close();
			}
			if (null != writer) {
				writer.close();
			}
		} catch (Exception e) {
			LogSvr.getInstance().error(e.getMessage(), e);
		}
	}

	/*
	 * 递归方法，获取所有节点
	 */
	public void deleteChildAttributeValue(Element element) {
		Attribute columnKey = element.attribute("ColumnKey");
		if (columnKey != null) {
			element.remove(columnKey);

		}
		Attribute tableKey = element.attribute("TableKey");

		if (tableKey != null) {
			element.remove(tableKey);

		}
		List<Element> elements = element.elements();
		if (element != null) {
			for (Element element2 : elements) {
				deleteChildAttributeValue(element2);
			}
		}
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new SetSourceDataObjectCmd();
	}
	@Override
	public String getCmd() {
		return CMD;
	}
}
