package com.bokesoft.yes.design.cmd;

import com.bokesoft.erp.all.initiator.InitializingDesigner;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.auth.cache.SessionInfo;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.session.ISessionInfoProvider;
import com.bokesoft.yigo.mid.session.SessionInfoProviderHolder;

import java.util.ArrayList;
import java.util.List;

/*
 *文件名: SetEnvironmentRunType
 *创建者: zhangk
 *创建时间:2024/8/8 11:48
 */
public class SetEnvironmentRunTypeCmd extends DesignerServiceCmd {
	public static final String CMD = "SetEnvironmentRunType";
	private int runType;

	@Override
	public void dealArguments(DefaultContext defaultContext, StringHashMap<Object> arguments) throws Throwable {
		runType = TypeConvertor.toInteger(arguments.get("runType"));
	}

	@Override
	public Object innerDoCmd(DefaultContext defaultContext) throws Throwable {
		List<UICommand> result = new ArrayList<UICommand>();
		if (!InitializingDesigner.isEnable()){
			return result;
		}
		String curClientID = defaultContext.getEnv().getClientID();
		int mode = defaultContext.getEnv().getMode();
		ISessionInfoProvider pcProvider = SessionInfoProviderHolder.getProvider(mode);
		SessionInfo pcSessionInfo = (SessionInfo) pcProvider.getSessionInfoMap().get(curClientID);
		if (runType == 1){
			pcSessionInfo.setOperatingEnvironment(AppRunType.App);
		}else {
			pcSessionInfo.setOperatingEnvironment(AppRunType.Dev);
		}

		return UICommand.toJson(result);
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new SetEnvironmentRunTypeCmd();
	}

	@Override
	public String getCmd() {
		return CMD;
	}
}
