package com.bokesoft.yes.design.cmd;

import com.bokesoft.erp.WebDesignerConfiguration;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.utils.DesignReloadMetaObject;
import com.bokesoft.yes.design.utils.XMLWriter;
import com.bokesoft.yes.erp.config.MetaFormNODBProcess;
import com.bokesoft.yes.helper.DataObjectHelper;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.def.TableMode;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectProfile;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.form.component.MetaEmbed;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.*;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;

import java.io.File;
import java.io.FileOutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

import static com.bokesoft.yes.design.datamap.util.DataMapOperXmlUtil.getOutputFormat;

/**
 *
 */
public class SetDataObjectSourceCmd extends DesignerServiceCmd {
    public static final String CMD = "SetDataObjectSource";
    private String subKey;
    private String dataObjectSourceValue;
//    private String projectKey;

    @Override
    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        subKey = TypeConvertor.toString(arguments.get("subKey"));
        dataObjectSourceValue = TypeConvertor.toString(arguments.get("dataObjectSourceValue"));
//        projectKey = TypeConvertor.toString(arguments.get("projectKey"));
    }

    @Override
    public Object innerDoCmd(DefaultContext context) throws Throwable {
        //检测是否有马甲
        IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
        for (MetaFormProfile metaFormProfile : globalInstance.getMetaFormList()) {
            if (subKey.equalsIgnoreCase(metaFormProfile.getExtend())) {
                List<UICommand> result = new ArrayList<UICommand>();
                result.add(UICommand.showTip("此表单含有马甲,不支持此操作"));
                return UICommand.toJson(result);
            }
        }
        String filePath = LoadFileTree.getPathByFormKey(subKey);
        FileOutputStream fileOutputStream = null;
        XMLWriter writer = null;
        //	EntryProcessor.instance.NewProject(ProjectKey, ProjectCaption,SolutionKey);
        // 创建SAX读取器
        try {
            SAXReader reader = new SAXReader();
            // 加载文档
            Document document = null;
            try {
                document = reader.read(filePath);
            } catch (Exception e) {
                throw new Exception("修改数据对象来源时请先保存新建表单");
            }

//            String formType = document.getRootElement().attributeValue("FormType");
            deleteChildAttributeValue(document.getRootElement());
            //0新增,1来源2,无
            if (dataObjectSourceValue.equalsIgnoreCase("1")) {//来源
            } else if (dataObjectSourceValue.equalsIgnoreCase("0")) {//新增
                Element deleteNode = (Element) document.selectSingleNode("/Form/DataSource");
                if (deleteNode != null) {
                    document.getRootElement().remove(deleteNode);
                }
                Element element = null;
                MetaDataObjectProfile profile = DataObjectHelper.createInsideProfile(globalInstance.getMetaForm(subKey));
                MetaFactory.getGlobalInstance().getDataObjectList().add(profile);
                MetaDataObject dataObject = profile.getDataObject();
                String content = DataObjectHelper.createXml(dataObject);
                Node node = document.selectSingleNode("//Var[@Key='" + "SystemInfoTableKey" + "']");
                if (node != null) {
                    Element element1 = (Element) node;
                    for (MetaTable metaTable : dataObject.getTableCollection()) {
                        if (metaTable.getKey().endsWith(MetaFormNODBProcess.STR_NODBTable_Profix)) {
                            continue;
                        }
                        int tableMode = metaTable.getTableMode();
                        if (tableMode == TableMode.HEAD) {
                            element1.setAttributeValue("Value",metaTable.getKey()) ;
                            break;
                        }
                    }
                }
                element = reader.read(new StringReader(content), "").getRootElement();
                // 创建dom4j文档对象
                Document document1 = DocumentHelper.createDocument();
                // 使用文档对象创建根节点的xml
                Element dataSource = document1.addElement("DataSource");
                dataSource.add(element);
                document.getRootElement().elements().add(0, dataSource);
                globalInstance.getDataObjectList().remove(subKey);
            } else if (dataObjectSourceValue.equalsIgnoreCase("2")) {//无
                List<MetaEmbed> embeds = globalInstance.getMetaForm(subKey).getEmbeds();
                if (embeds.size() > 0) {
                    if (!(embeds.size() == 1 && embeds.get(0).getFormKey().equals("V_Favorite_Impl"))) {
                        List<UICommand> result = new ArrayList<UICommand>();
                        result.add(UICommand.showTip("此表单含有嵌入表单,不支持此操作"));
                        return UICommand.toJson(result);
                    }
                }
                // 数据来源是外部数据对象并且存在同名的数据对象 不允许修改成无数据对象 这里仅仅是在设计器中屏蔽了操作
                String refObjectKey = globalInstance.getMetaForm(subKey).getDataSource().getRefObjectKey();
                if (StringUtils.isNotBlank(refObjectKey) && globalInstance.getDataObjectList().containsKey(subKey)) {
                    List<UICommand> result = new ArrayList<UICommand>();
                    result.add(UICommand.showTip("存在同名的数据对象,不允许修改成无数据对象"));
                    return UICommand.toJson(result);
                }
                Element deleteDataSourceNode = (Element) document.selectSingleNode("/Form/DataSource");
                document.getRootElement().remove(deleteDataSourceNode);
            }
            OutputFormat format = getOutputFormat();
            String newFilePath = FilePathHelper.toBackFilePath(WebDesignerConfiguration.getDesignerSolutionTmpDataPath(MetaFactory.getGlobalInstance().getMetaFormList().get(subKey).getProject().getKey())+ File.separator + new File(filePath).getName() + "." + System.currentTimeMillis());
            fileOutputStream = new FileOutputStream(newFilePath);
            writer = new XMLWriter(fileOutputStream, format);
            writer.write(document);
            XmlFileProcessor.stackput(filePath, newFilePath);
			/*if (StringUtils.isNotEmpty(refKey)) {//是数据对象表单
				MetaForm metaForm1 = metaFactory.getMetaForm(key);
				String refObjectKey = metaForm1.getDataSource().getRefObjectKey();
				String s = LoadFileTree.loadFilePathByDataObjectFieldKey(refObjectKey);
				reloadMetaFormProfiles = DesignReloadMetaObject.reloadMetaDataObjectRollbackError(refObjectKey, s);
			} else {//不是数据对象表单
				reloadMetaFormProfiles = DesignReloadMetaObject.reloadMetaFormRollbackError(key);
			}*/
            DesignReloadMetaObject.reloadMetaFormRollbackError(subKey);
            List<UICommand> result = new ArrayList<UICommand>();
            result.add(UICommand.reloadXmlSource(filePath));
            result.add(UICommand.showTip("操作成功,如若撤销,请关闭此界面,点击设计界面的撤销"));
            return UICommand.toJson(result);
        } catch (Exception e) {
            throw e;
        } finally {
            closeFileStream(fileOutputStream, writer);
        }
    }

    /***
     * 关闭文件流
     * @param fileOutputStream 文件输出流
     * @param writer 写对象
     */
    private void closeFileStream(FileOutputStream fileOutputStream, XMLWriter writer) {
        try {
            if (null != fileOutputStream) {
                fileOutputStream.close();
            }
            if (null != writer) {
                writer.close();
            }
        } catch (Exception e) {
            LogSvr.getInstance().error(e.getMessage(), e);
        }
    }

    /*
     * 递归方法，删除ColumnKeyTableKey节点
     */
    public void deleteChildAttributeValue(Element element) {
        Attribute columnKey = element.attribute("ColumnKey");
        if (columnKey != null) {
            element.remove(columnKey);

        }
        Attribute tableKey = element.attribute("TableKey");

        if (tableKey != null) {
            element.remove(tableKey);

        }
        List<Element> elements = element.elements();
        if (element != null) {
            for (Element element2 : elements) {
                deleteChildAttributeValue(element2);
            }
        }
    }

    @Override
    public IServiceCmd<DefaultContext> newInstance() {
        return new SetDataObjectSourceCmd();
    }

    @Override
    public String getCmd() {
        return CMD;
    }
}
