package com.bokesoft.yes.design.cmd;

import com.bokesoft.erp.performance.Performance;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.MetaObjectType;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.design.utils.CheckXSDUtils;
import com.bokesoft.yes.design.utils.DesignReloadMetaObject;
import com.bokesoft.yes.design.utils.MetaUtils;
import com.bokesoft.yes.design.utils.RebuildTableUtil;
import com.bokesoft.yes.design.vo.CheckXSDResult;
import com.bokesoft.yes.erp.dev.MetaTableCache;
import com.bokesoft.yes.erp.scope.MetaFormAllFormulScopeCache;
import com.bokesoft.yes.helper.DataObjectHelper;
import com.bokesoft.yes.meta.persist.dom.form.MetaFormSave;
import com.bokesoft.yes.meta.persist.dom.xml.XmlCreator;
import com.bokesoft.yes.meta.persist.dom.xml.node.Xml4jUtil;
import com.bokesoft.yes.meta.persist.dom.xml.node.XmlTree;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.tools.dic.proxy.ItemCacheManager;
import com.bokesoft.yes.util.FileUtil;
import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.common.def.FormType;
import com.bokesoft.yigo.meta.commondef.MetaCommonDef;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/**
 * 根据表单的Key保存相关的XML文件
 */
public class SaveFilesByFormKeyCmd extends DesignerServiceCmd {

	public static final String CMD = "SaveFilesByFormKey";

	/**
	 * 当前界面的FormKey
	 */
	private String uiFormKey;
	/**
	 * 入口参数中的FormKey
	 */
	private String entryParas;

	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		uiFormKey = (String) arguments.get("uiFormKey");
		entryParas = (String) arguments.get("entryParas");
	}

	@Override
	public Object innerDoCmd(DefaultContext context) throws Throwable {
		List<String[]> filePaths = LoadFileTree.loadFilePathsByFormKey(context, uiFormKey, entryParas, null);
		IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
		List<UICommand> result = new ArrayList<UICommand>();
		for (String[] tmp : filePaths) {
			String filePath = tmp[0];
			String tmpFilePath = XmlFileProcessor.instance.getTmpFile(filePath);
			if (null != tmpFilePath) {
				Object[] actions = {"SaveFileContent: ", tmpFilePath};
				Performance.endActive(Performance.startAction(actions), actions);
				String tmpContent = FileUtil.File2String(tmpFilePath, "UTF-8");
				String tmpSecondLine = DesignIOMetaUtil.getSecondLine(tmpContent);
				String objectType = DesignIOMetaUtil.getSubString(tmpSecondLine, "<([A-Za-z_]\\w*)\\s");
				String key = DesignIOMetaUtil.getSubString(tmpSecondLine, "Key=\"([A-Za-z_]\\w*)\"");
				String newTmpFilePath = null;
				if (MetaForm.TAG_NAME.equals(objectType)) {//form处理
					MetaForm metaForm = metaFactory.getMetaForm(key);
					if(metaForm.getFormType() == FormType.Dict){
						String itemKey = metaForm.getDataSource().getDataObject().getKey();
						if(itemKey != null){
							new ItemCacheManager(context.getVE()).getItemCache(itemKey).clear();
						}
					}
					if (StringUtils.isBlank(metaForm.getProject().getKey()) || filePath.indexOf(metaForm.getProject().getKey()) == -1) {
						//新增表单所选的项目名 并不等于metaForm的项目名
						setProjectKeyAndCaption(metaForm);
					}
					String formFilePath = LoadFileTree.getPathByFormKey(key);
					newTmpFilePath = XmlFileProcessor.instance.getTmpFile(formFilePath);
					XmlFileProcessor.recycleToTmpFormAndFileMap.remove("Entry@Entry" + key);
					SaveFileContentCmd.reloadDataObjects(result, metaFactory, filePath);
					removeScopeCache(metaForm, metaFactory, result);
					if(StringUtils.isEmpty(metaForm.getExtend())){
						String newContent = FileUtils.readFileToString(new File(newTmpFilePath), "UTF-8");
						FileUtils.writeStringToFile(new File(filePath), newContent, "UTF-8");
						formatXml(metaFactory, newTmpFilePath, key, MetaForm.TAG_NAME, result);
					}else {
						String newContent = FileUtils.readFileToString(new File(newTmpFilePath), "UTF-8");
						FileUtils.writeStringToFile(new File(filePath), newContent, "UTF-8");
					}
					Set<MetaFormProfile> allMetaFormProfilesByDataObjectKey = DataObjectHelper.getAllMetaFormProfilesByDataObjectKey(key);
					for (MetaFormProfile metaFormProfile : allMetaFormProfilesByDataObjectKey) {
						//保存后将当前form运行模式设置为程序运行
						metaFormProfile.setRunType(AppRunType.App);
					}
				} else if (MetaObjectType.DataObject.name.equals(objectType)) {//数据对象处理
					String dataObjectFilePath = LoadFileTree.loadFilePathByDataObjectFieldKey(key);
					newTmpFilePath = XmlFileProcessor.instance.getTmpFile(dataObjectFilePath);
					if(StringUtils.isNotEmpty(metaFactory.getDataObject(key).getExtend())){
						SaveFileContentCmd.reloadDataObjects(result, metaFactory, filePath);
						removeScopeCache(null, metaFactory, result);
						Set<MetaFormProfile> allMetaFormProfilesByDataObjectKey = DataObjectHelper.getAllMetaFormProfilesByDataObjectKey(key);
						for (MetaFormProfile metaFormProfile : allMetaFormProfilesByDataObjectKey) {
							//保存后将当前form运行模式设置为程序运行
							metaFormProfile.setRunType(AppRunType.App);
						}
					} else{
						MetaDataObject metaDataObject = NewFormCmd.loadMetaDataObject(key);
						MetaUtils.saveMetaDataObject(metaFactory,metaDataObject,filePath, key, SaveFilesByFormKeyCmd.CMD, "", key, result, context);
					}
				}
				if (newTmpFilePath != null) {
					String newContent = FileUtils.readFileToString(new File(newTmpFilePath), "UTF-8");
					boolean isNew = !(new File(filePath).exists());
					if (!isNew && tmpSecondLine.contains(ConstantUtil.VERSION)) {//不包含Version属性代码时马甲  略过
						int version = SaveFileContentCmd.checkFileVersion(filePath, newContent);
						newContent = SaveFileContentCmd.versionAddOne(newContent, version);
					}
					FileUtils.writeStringToFile(new File(filePath), newContent, "UTF-8");
					if (!"DataObject".equalsIgnoreCase(objectType) && metaFactory.getMetaForm(key).getDataSource() != null) {
						RebuildTableUtil.rebuildTable(context, filePath);
					}
				}
				XmlFileProcessor.instance.clearTmpFile(filePath);
				result.add(UICommand.reloadXmlSource(filePath));
			}
		}
		result.add(UICommand.showTip("保存成功"));
		MetaTableCache.init(MetaFactory.getGlobalInstance(),null,MetaTableCache.getMetaTables());
		return UICommand.toJson(result);
	}

	public static void removeScopeCache(MetaForm metaForm, IMetaFactory metaFactory, List<UICommand> result) throws Throwable {
		List<MetaFormProfile> metaFormProfiles = new ArrayList<>();
		String refObjectKey = null;
		if (metaForm!=null && metaForm.getDataSource()!=null){
			refObjectKey = metaForm.getDataSource().getRefObjectKey();
		}
		DesignReloadMetaObject.loadEmbedOwnerAndVest(metaFactory,metaFormProfiles,refObjectKey);
		for (MetaFormProfile formProfile : metaFormProfiles) {
			MetaFormAllFormulScopeCache.instance.clear(formProfile.getKey());
			result.add(UICommand.removeScopeCache(formProfile.getKey()));
		}
	}

	private void setProjectKeyAndCaption(MetaForm metaForm) throws Throwable {
		IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
		String projectKey;
		if (StringUtils.isNotEmpty(metaForm.getExtend())) {//马甲
			projectKey = metaForm.getProject().getKey();
		} else {
			projectKey = NewFormCmd.projectKey;
		}
		if (StringUtils.isBlank(projectKey)) {
			return;
		}
		MetaProject metaProject = metaFactory.getMetaProject(projectKey);
		metaForm.setProject(metaProject);
	}

	@Override
	public String getCmd() {
		return CMD;
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new SaveFilesByFormKeyCmd();
	}

	public static void formatXml(IMetaFactory metaFactory, String filePath, String key, String tagName, List<UICommand> result) throws Throwable{
		MetaForm metaForm1 = NewFormCmd.loadMetaForm(key);
		MetaFormSave metaFormSave = new MetaFormSave(metaForm1);
		Document document = metaFormSave.getDocument();
		XmlTree oldXmlTree = Xml4jUtil.parseTree(filePath);
		CheckXSDUtils.resortAttrPosition(oldXmlTree.getRoot(), filePath);
		XmlCreator creator = new XmlCreator(document, oldXmlTree);
		String xml = creator.createXml();
		String newContent = xml.replaceAll("\r\n", "\n").replaceAll("\n", "\r\n");
		CheckXSDResult checkXSDResult = CheckXSDUtils.checkXSD(metaFactory, tagName, key, key, newContent, "", null, null);
		if(!checkXSDResult.isPass() && checkXSDResult.getMsg() != null &&checkXSDResult.getMsg().isEmpty()){
			/*XmlFileProcessor.instance.saveTempFile(filePath, FileUtils.readFileToString(new File(filePath),"UTF-8"), metaForm1.getProjectKey());
			SaveFileContentCmd.reloadForm(metaFactory, key, result);*/
			result.add(UICommand.showTip(checkXSDResult.getMsg()));
		}
		FileUtils.writeStringToFile(new File(filePath), newContent, "UTF-8");
	}

	public static void reloadDataObject(IMetaFactory metaFactory, String key, List<UICommand> result, String filePath) throws Throwable{
		SaveFileContentCmd.reloadDataObjects(result, metaFactory, filePath);
		Set<MetaFormProfile> allMetaFormProfilesByDataObjectKey = DataObjectHelper.getAllMetaFormProfilesByDataObjectKey(key);
		for (MetaFormProfile metaFormProfile : allMetaFormProfilesByDataObjectKey) {
			//保存后将当前form运行模式设置为程序运行
			metaFormProfile.setRunType(AppRunType.App);
		}
	}
}
