package com.bokesoft.yes.design.cmd;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bokesoft.erp.performance.Performance;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.MetaObjectType;
import com.bokesoft.yes.design.bpm.util.GetDataUtil;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.datamap.util.DataMapOperXmlUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.design.io.Tree;
import com.bokesoft.yes.design.io.TreeNode;
import com.bokesoft.yes.design.utils.*;
import com.bokesoft.yes.design.vo.ResponseResult;
import com.bokesoft.yes.design.xml.XmlCreator;
import com.bokesoft.yes.erp.dev.MetaTableCache;
import com.bokesoft.yes.helper.DataObjectHelper;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.meta.persist.dom.form.MetaFormSave;
import com.bokesoft.yes.meta.persist.dom.xml.node.Xml4jUtil;
import com.bokesoft.yes.meta.persist.dom.xml.node.XmlTree;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.mysqls.group.meta.DataObjects;
import com.bokesoft.yes.design.xml.XmlParser;
import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.bpm.process.MetaProcess;
import com.bokesoft.yigo.meta.commondef.MetaCommonDef;
import com.bokesoft.yigo.meta.datamap.MetaMap;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigration;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.entry.MetaEntry;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelWorkbook;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.report.MetaReport;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.meta.solution.MetaProjectProfile;
import com.bokesoft.yigo.meta.solution.MetaSolution;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;

import java.io.File;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 保存XML文件
 */
public class SaveFileContentCmd extends DesignerServiceCmd {

	public static final String CMD = "SaveFileContent";
	/**
	 * 工具类
	 */
	public static DataMapOperXmlUtil dataMapOperJsonUtil = new DataMapOperXmlUtil();
	/***获取数据操作类*/
	private final GetDataUtil getDataUtil = new GetDataUtil();
	/**
	 * 文件路径
	 */
	private String filePath;
	private String projectKey;
	/**
	 * 文件内容
	 */
	private String content;
	/**
	 * 文件名
	 */
	private String key;
	private boolean hasEdited;
	/**
	 * 是否进行格式检查
	 */
//	private boolean isCheckFormat;

	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		filePath = FilePathHelper.toBackFilePath((String) arguments.get("filePath"));
		content = (String) arguments.get("content");
		projectKey = LoadFileTree.getProjectKey(filePath);
		key = (String) arguments.get("key");
		hasEdited = TypeConvertor.toBoolean(arguments.getOrDefault("hasEdited", "true"));
	}

	@Override
	public Object innerDoCmd(DefaultContext context) throws Throwable {
		List<UICommand> result = new ArrayList<>();
		if (!hasEdited) {
			String tmpFilePath = XmlFileProcessor.instance.getTmpFile(filePath);
			content = FileUtils.readFileToString(new File(tmpFilePath), "UTF-8");
		} else {
			//检验语法错误
			try {
				//String xmlFile = XmlFormat.formatXML_file(filePath);
				//判断节点关系是否正确;如果不正确就不保存文件
				String xmlFile1 = XmlFormat.formatXML_str(content);
				XmlParser.parse(xmlFile1);
			} catch (Exception e) {
				throw new RuntimeException("xml结构错误保存失败!", e);
			}
		}
		Object[] actions = {"SaveFileContent: ", filePath};
		Performance.endActive(Performance.startAction(actions), actions);
		IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
		String newContent = content;
		boolean isNew = !(new File(filePath).exists());
		boolean isEntry = "Entry.xml".equals(FilenameUtils.getName(filePath));
		boolean isCommonDef = "CommonDef.xml".equals(FilenameUtils.getName(filePath));
		String secondLine = DesignIOMetaUtil.getSecondLine(newContent);
		String newSecondLine = DesignIOMetaUtil.getSecondLine(newContent);
		boolean hasNoAttribute = newSecondLine.matches("<[A-Za-z_]*>");
		String objectType = "";
		if (!isCommonDef && !hasNoAttribute) {
			objectType = DesignIOMetaUtil.getSubString(newSecondLine, "<([A-Za-z_]\\w*)\\s");
		}
		if (!isNew && !isEntry && !isCommonDef && secondLine.contains(ConstantUtil.VERSION)) {//不包含Version属性代码时马甲  略过
			if (!MetaProcess.TAG_NAME.equals(objectType)) {
				int version = checkFileVersion();
//				if (isCheckFormat) {
//
//					// TODO: 读取一次配置，检查文件格式是否正确
//				}
				newContent = versionAddOne(content, version);
			}
		}
		//StyledDocumentBase, ReadOnlyStyledDocument 中会将 "\r\n" 处理成 "\n",导致保存成文件后,用记事本打开时换行会消失
		if (!newSecondLine.contains("Key")) {
			if (isCommonDef) {
				int endi = filePath.indexOf(File.separatorChar + "CommonDef.xml");
				int iStart = filePath.indexOf(File.separatorChar + "solutions" + File.separatorChar);
				String fileName = key;
				if (iStart + 10 < endi) {
					key = filePath.substring(iStart + 10, endi);
				} else {
					key = null;
				}
				MetaCommonDef commonDef;
				TreeNode treeNode = LoadFileTree.getTreeNode(filePath);
				String solutionKey = treeNode.solutionKey;
				if (StringUtils.isEmpty(projectKey)) {
					commonDef = metaFactory.getCommonDefBySolution(solutionKey);
				} else {
					commonDef = metaFactory.getCommonDef(projectKey);
				}
				if (commonDef == null) {
					newContent = newContent.replaceAll("\r\n", "\n").replaceAll("\n", "\r\n");
					FileUtils.writeStringToFile(new File(filePath), newContent, "UTF-8");
					XmlFileProcessor.instance.clearTmpFile(filePath);
					CommonDefProcessor.getInstance().reloadCommonDef(projectKey, solutionKey);
					result.add(UICommand.reloadMenuTree());
				} else {
					newContent = newContent.replaceAll("\r\n", "\n").replaceAll("\n", "\r\n");
					if (!StringUtils.isEmpty(projectKey)){
						XmlFileProcessor.instance.saveTempFile(filePath, FileUtils.readFileToString(new File(filePath),"UTF-8"), projectKey);
					}
					FileUtils.writeStringToFile(new File(filePath), newContent, "UTF-8");
					CommonDefProcessor.getInstance().reloadCommonDef(projectKey, solutionKey);
					if (StringUtils.isEmpty(projectKey)) {
						commonDef = metaFactory.getCommonDefBySolution(solutionKey);
					} else {
						commonDef = metaFactory.getCommonDef(projectKey);
					}
					MetaUtils.saveMetaCommonDef(metaFactory, commonDef, filePath, fileName, projectKey, solutionKey, result, content);
				}
			} else {
				newContent = newContent.replaceAll("\r\n", "\n").replaceAll("\n", "\r\n");
				FileUtils.writeStringToFile(new File(filePath), newContent, "UTF-8");
			}
		} else {
			String formKey = DesignIOMetaUtil.getSubString(newSecondLine, "Key=\"([A-Za-z_]\\w*)\"");
			if (MetaForm.TAG_NAME.equals(objectType)) {//form处理
				MetaForm metaForm = metaFactory.getMetaForm(formKey);
				if (StringUtils.isBlank(metaForm.getProject().getKey()) || filePath.indexOf(metaForm.getProject().getKey()) == -1) {
					//新增表单所选的项目名 并不等于metaForm的项目名
					setProjectKeyAndCaption(metaForm);
				}
				String extend = metaFactory.getMetaForm(formKey).getExtend();
				if(StringUtils.isNotEmpty(extend)){
					FileUtils.writeStringToFile(new File(filePath), newContent, "UTF-8");
					SaveFileContentCmd.reloadForm(metaFactory, formKey, result);
					if (metaForm.getDataSource() != null) {
						RebuildTableUtil.rebuildTable(context, filePath);
					}
					XmlFileProcessor.recycleToTmpFormAndFileMap.remove("Entry@Entry" + key);
					XmlFileProcessor.instance.clearTmpFile(filePath);
					result.add(UICommand.reloadXmlSource(filePath));
					reloadDataObjects(result, metaFactory, filePath);
					SaveFilesByFormKeyCmd.removeScopeCache(metaForm, metaFactory, result);
				} else {
					//保存未修改前的xml，后续xsd检查失败，方便还原
					File oldFile = new File(filePath);
					String oldContent = oldFile.exists() ? FileUtils.readFileToString(oldFile,"UTF-8") : "";
					// 原代码编辑界面操作保存，先加载对象 （后续调用平台的方法生成xml时，需要修改后的对象）
					XmlFileProcessor.instance.saveTempFile(filePath, newContent, metaForm.getProjectKey());
					FileUtils.writeStringToFile(new File(filePath), newContent, "UTF-8");
					//reloadForm(metaFactory, formKey, result);
					MetaForm metaForm1 = NewFormCmd.loadMetaFormByPath(filePath,projectKey);
					// xml节点顺序，xsd检测
					MetaUtils.saveMetaForm(metaFactory, metaForm1, filePath, formKey, SaveFileContentCmd.CMD, oldContent, key, result, context);
				}
			} else if (isEntry) {//菜单处理
				String projectKey = LoadFileTree.getProjectKey(filePath);
				if (StringUtils.isEmpty(projectKey)) {
					TreeNode treeNode = Tree.map.get(filePath);
					String solutionKey = treeNode.solutionKey;
					if (StringUtils.isEmpty(solutionKey)) {
						newContent = newContent.replaceAll("\r\n", "\n").replaceAll("\n", "\r\n");
						FileUtils.writeStringToFile(new File(filePath), newContent, "UTF-8");
					} else {
						for (MetaSolution metaSolution : metaFactory.getMetaSolutions()) {
							if (!metaSolution.getKey().equals(solutionKey))
								continue;
							for (MetaProjectProfile project : metaSolution.getProjectCollection()) {
								MetaEntry metaEntry = metaFactory.getMetaEntry(project.getKey());
								if (metaEntry == null) {
									continue;
								}
								MetaUtils.saveMetaEntry(metaFactory, metaEntry, filePath, project.getKey(), key, result);
							}
						}
					}
				} else {
					MetaEntry metaEntry = metaFactory.getMetaEntry(projectKey);
					if (metaEntry != null) {
						newContent = newContent.replaceAll("\r\n", "\n").replaceAll("\n", "\r\n");
						XmlFileProcessor.instance.saveTempFile(filePath, FileUtils.readFileToString(new File(filePath),"UTF-8"), projectKey);
						FileUtils.writeStringToFile(new File(filePath), newContent, "UTF-8");
						EntryProcessor.instance.reloadEntry(projectKey);
						metaEntry = metaFactory.getMetaEntry(projectKey);
						MetaUtils.saveMetaEntry(metaFactory, metaEntry, filePath, projectKey, key, result);
					}
				}
			} else if (MetaObjectType.DataObject.name.equals(objectType)) {//数据对象处理
				String extend = metaFactory.getDataObject(formKey).getExtend();
				if(StringUtils.isNotEmpty(extend)){
					XmlFileProcessor.instance.saveTempFile(filePath, newContent,projectKey);
					String s = LoadFileTree.loadFilePathByDataObjectFieldKey(key);
					List<MetaFormProfile> reloadMetaFormProfiles = null;
					reloadMetaFormProfiles = DataObjectHelper.reload(null,key, s, null);
					RebuildTableUtil.rebuildTable(context, filePath);
					if (reloadMetaFormProfiles != null) {
						for (MetaFormProfile metaFormProfile : reloadMetaFormProfiles) {
							result.add(UICommand.reloadFormKey(metaFormProfile.getKey()));
							//保存后将当前form运行模式设置为程序运行
							metaFormProfile.setRunType(AppRunType.App);
						}
					}
					reloadDataObjects(result, metaFactory, filePath);
					SaveFilesByFormKeyCmd.removeScopeCache(null, metaFactory, result);
					FileUtils.writeStringToFile(new File(filePath), newContent, "UTF-8");
					XmlFileProcessor.instance.clearTmpFile(filePath);
				}else{
					String oldContent = FileUtils.readFileToString(new File(filePath),"UTF-8");
					XmlFileProcessor.instance.saveTempFile(filePath, newContent, projectKey);
					FileUtils.writeStringToFile(new File(filePath), newContent, "UTF-8");
					MetaDataObject metaDataObject = NewFormCmd.loadMetaDataObject(formKey);
					MetaUtils.saveMetaDataObject(metaFactory, metaDataObject, filePath, formKey, SaveFileContentCmd.CMD, oldContent, formKey, result, context);
				}
				//清除字典缓存
//				context.getDictCache().removeDictCache(key);
			} else if (MetaDataMigration.TAG_NAME.equals(objectType)) {//数据迁移
				XmlFileProcessor.instance.saveTempFile(filePath, newContent,projectKey);
				ResponseResult<JSONArray> haveMainTable = isHaveMainTable(filePath);
				ResponseResult<List<JSONObject>> responseResult = dataMapOperJsonUtil.SaveHtml(filePath);
				List<JSONObject> data = responseResult.getData();
				if (data != null && data.size() > 0) {
					result.add(UICommand.rebuildTable(data));
				}
				String msg = haveMainTable.getMsg();
				if (StringUtils.isNotEmpty(msg)) {
					result.add(UICommand.showError("保存成功：" + msg));
				} else {
					result.add(UICommand.showTip("保存成功"));
				}
			} else if (MetaMap.TAG_NAME.equals(objectType)) {//数据映射
				XmlFileProcessor.instance.saveTempFile(filePath, newContent,projectKey);
				ResponseResult<JSONArray> haveMainTable = isHaveMainTable(filePath);
				ResponseResult<List<JSONObject>> responseResult = dataMapOperJsonUtil.SaveHtml(filePath);
				List<JSONObject> data = responseResult.getData();
				if (data != null && data.size() > 0) {
					result.add(UICommand.rebuildTable(data));
					if (data.size() > 1) {
						result.add(UICommand.reloadFormKey(data.get(1).getString("key")));//reload目标表
					}
				}
				String msg = haveMainTable.getMsg();
				if (StringUtils.isNotEmpty(msg)) {
					result.add(UICommand.showError(msg));
				}else {
					result.add(UICommand.showTip("保存成功"));
				}
			} else if (MetaProcess.TAG_NAME.equals(objectType)) {//工作流
				FileUtils.writeStringToFile(new File(filePath), newContent, "UTF-8");
				getDataUtil.SaveBPMXML(filePath);
				result.add(UICommand.showTip("保存成功"));
			} else if (MetaReport.TAG_NAME.equals(objectType)) {//打印模板
				FileUtils.writeStringToFile(new File(filePath), newContent, "UTF-8");
				WebPrintDesign.SavePrintXML(filePath, metaFactory);
				result.add(UICommand.showTip("保存成功"));
			} else if (MetaExcelWorkbook.TAG_NAME.equals(objectType)) {//Excel模板
				FileUtils.writeStringToFile(new File(filePath), newContent, "UTF-8");
				WebExcelDesign.SaveExcelXML(filePath, metaFactory);
				result.add(UICommand.showTip("保存成功"));
			} else {
				FileUtils.writeStringToFile(new File(filePath), newContent, "UTF-8");
			}

		}
		result.add(UICommand.reloadXmlSource(filePath));
		List<UICommand> resultList = result.stream().distinct().collect(Collectors.toList());
		MetaTableCache.init(MetaFactory.getGlobalInstance(),null,MetaTableCache.getMetaTables());
		return UICommand.toJson(resultList);
	}

	public static void formatXml(String filePath, String key) throws Throwable {
		MetaForm metaForm1 = NewFormCmd.loadMetaForm(key);
		if (StringUtils.isNotEmpty(metaForm1.getExtend())){
			return;
		}
		MetaFormSave metaFormSave = new MetaFormSave(metaForm1);
		Document document = metaFormSave.getDocument();
		XmlTree oldXmlTree = Xml4jUtil.parseTree(filePath);
		String xml = new XmlCreator(document, oldXmlTree).createXml();
		FileUtils.writeStringToFile(new File(filePath), xml, "UTF-8");
	}


	public static void reloadDataObjects(List<UICommand> result, IMetaFactory metaFactory, String filePath) throws Throwable {
		//Class<?> instance = Class.forName("com.bokesoft.yes.mid.mysqls.group.meta.DataObjects");
		//Method init = instance.getDeclaredMethod("init", IMetaFactory.class);
		//实例化对象的方法
		DataObjects.getInstance().init(metaFactory, true);
		//init.setAccessible(true);
		//init.invoke(instance1, metaFactory);
		result.add(UICommand.reloadXmlSource(filePath));
	}


	public static void setProjectKeyAndCaption(MetaForm metaForm) throws Throwable {
		IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
		String projectKey;
		if (StringUtils.isNotEmpty(metaForm.getExtend())) {//马甲
			projectKey = NewExpandFormCmd.projectKey;
		} else {
			projectKey = NewFormCmd.projectKey;
		}
		if (StringUtils.isBlank(projectKey)) {
			return;
		}
		MetaProject metaProject = metaFactory.getMetaProject(projectKey);
		metaForm.setProject(metaProject);
	}

	@Override
	public String getCmd() {
		return CMD;
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new SaveFileContentCmd();
	}

	/**
	 * 检查文件版本是否一致
	 *
	 * @return
	 * @throws Throwable
	 */
	private int checkFileVersion() throws Throwable {
		Stack<String> stack = XmlFileProcessor.filePathToTmpFileMap.get(filePath);
		if (stack != null && stack.size() > 0) {
			String peek = stack.peek();
			return checkFileVersion(peek, content);
		}
		return checkFileVersion(filePath, content);
	}

	/**
	 * 检查文件版本是否一致
	 *
	 * @param oldFilePath
	 * @param newContent
	 * @return
	 * @throws Throwable
	 */
	public static int checkFileVersion(String oldFilePath, String newContent) throws Throwable {
		File file = new File(oldFilePath);
		String oldContent = FileUtils.readFileToString(file, "UTF-8");
		int oldVersion = getVersion(oldContent);
		int newVersion = getVersion(newContent);
		if (oldVersion != newVersion) {
			throw new RuntimeException("文件" + oldFilePath + "中版本为" + oldVersion + "，而新文件中版本为" + newVersion + "，不一致导致保存失败。");
		}
		return newVersion;
	}

	private static int getVersion(String content) {
		String secondLine = DesignIOMetaUtil.getSecondLine(content);
		String version = DesignIOMetaUtil.getSubString(secondLine, "Version=\"(\\d+)\"");
		return Integer.parseInt(version);
	}

	/**
	 * 验证是否存在主表
	 */
	public static ResponseResult<JSONArray> isHaveMainTable(String filePath) {
		ResponseResult<JSONArray> response = new ResponseResult<>();
		try {
			return dataMapOperJsonUtil.isHaveMainTable(filePath);
		} catch (Exception e) {
			response.setCode(999);
			response.setMsg("保存失败，失败信息为:" + e.getMessage());
		} catch (Throwable throwable) {
			LogSvr.getInstance().error(throwable.getMessage(), throwable);
		}
		return response;
	}

	/**
	 * 版本加1
	 *
	 * @param content
	 * @param version
	 * @return
	 */
	public static String versionAddOne(String content, int version) {
		return content.replace("Version=\"" + version + "\"", "Version=\"" + (version + 1) + "\"");
	}

	public static void reloadForm(IMetaFactory metaFactory, String formKey, List<UICommand> result) throws Throwable{
		List<MetaFormProfile> reloadMetaFormProfiles = null;
		String extend = metaFactory.getMetaForm(formKey).getExtend();
		String refKey = "";
		if (metaFactory.getMetaForm(formKey).getDataSource() != null) {
			refKey = metaFactory.getMetaForm(formKey).getDataSource().getRefObjectKey();
		}
		if (!StringUtils.isNotEmpty(extend)) {//不是马甲
			if (StringUtils.isNotEmpty(refKey)) {//是数据对象表单
				MetaForm metaForm1 = metaFactory.getMetaForm(formKey);
				String refObjectKey = metaForm1.getDataSource().getRefObjectKey();
				String s = LoadFileTree.loadFilePathByDataObjectFieldKey(refObjectKey);
				reloadMetaFormProfiles = DataObjectHelper.reload(null,refObjectKey, s, null);
			} else {//不是数据对象表单
				reloadMetaFormProfiles = DesignReloadMetaObject.reloadMetaFormRollbackError(formKey);
			}
		} else {//马甲
			Boolean mergeToSource = metaFactory.getMetaFormList().get(formKey).getMergeToSource();
			if (mergeToSource) {//功能马甲
				reloadMetaFormProfiles = DesignReloadMetaObject.reloadMetaFormRollbackError(formKey);
			} else {//界面马甲
				if (StringUtils.isNotEmpty(refKey)) {//是数据对象表单
					MetaForm metaForm1 = metaFactory.getMetaForm(formKey);
					String refObjectKey = metaForm1.getDataSource().getRefObjectKey();
					String s = LoadFileTree.loadFilePathByDataObjectFieldKey(refObjectKey);
					reloadMetaFormProfiles = DataObjectHelper.reload(null,refObjectKey, s, null);
				} else {//不是数据对象表单
					reloadMetaFormProfiles = DesignReloadMetaObject.reloadMetaFormRollbackError(formKey);
				}
			}

		}
		if (reloadMetaFormProfiles != null) {
			for (MetaFormProfile metaFormProfile : reloadMetaFormProfiles) {
				result.add(UICommand.reloadFormKey(metaFormProfile.getKey()));
				//保存后将当前form运行模式设置为程序运行
				metaFormProfile.setRunType(AppRunType.App);
			}
		}
	}

	public static void reloadDataObject(IMetaFactory metaFactory, String formKey, List<UICommand> result, String filePath,
										DefaultContext context) throws Throwable{
		List<MetaFormProfile> reloadMetaFormProfiles = null;
		String s = LoadFileTree.loadFilePathByDataObjectFieldKey(formKey);
		RebuildTableUtil.rebuildTable(context, filePath);
		reloadMetaFormProfiles = DataObjectHelper.reload(null,formKey, s, null);
		if (reloadMetaFormProfiles != null) {
			for (MetaFormProfile metaFormProfile : reloadMetaFormProfiles) {
				result.add(UICommand.reloadFormKey(metaFormProfile.getKey()));
				//保存后将当前form运行模式设置为程序运行
				metaFormProfile.setRunType(AppRunType.App);
			}
		}
		RebuildTableUtil.rebuildTable(context, filePath);
		SaveFileContentCmd.reloadDataObjects(result, metaFactory, filePath);
	}
}
