package com.bokesoft.yes.design.cmd;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.utils.DesignReloadMetaObject;
import com.bokesoft.yes.design.utils.ReloadForm;
import com.bokesoft.yes.helper.DataObjectHelper;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.apache.commons.io.FileUtils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ReductionSnapshotXmlCmd extends DesignerServiceCmd {
    public static final String CMD = "ReductionSnapshotXml";

    /**
     * 表单Key，若文件是模板，表单Key指模板文件被打开的FormKey
     */
    private String uiFormKey;
    /**
     * 表单类型
     */
    private String type;
    /**
     * 文件路径
     */
    private String filePath;
    /**
     * 临时文件路径
     */
    private String temFilePath;

    @Override
    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        uiFormKey = (String) arguments.get("uiFormKey");
        type = (String) arguments.get("type");
        filePath = (String) arguments.get("filePath");
        temFilePath = (String) arguments.get("temFilePath");
    }

    @Override
    public Object innerDoCmd(DefaultContext context) throws Throwable {
        List<UICommand> result = new ArrayList<>();
        result.add(UICommand.reloadXmlSourceByTemp(filePath, temFilePath));
        if ("Form".equalsIgnoreCase(type)) {
            DesignReloadMetaObject.reloadMetaFormRollbackError(null,uiFormKey, null, temFilePath);
            result.add(UICommand.reloadFormKey(uiFormKey));
            result.add(UICommand.refreshMenuTree(uiFormKey));
        } else if (ConstantUtil.DATA_OBJECT.equalsIgnoreCase(type)) {
            DataObjectHelper.reload(null,uiFormKey, filePath, null, temFilePath);
        } else if (ConstantUtil.DATA_MIGRATION.equalsIgnoreCase(type)) {
            IMetaFactory iMetaFactory = MetaFactory.getGlobalInstance();
            ReloadForm.reloadDataMigrationKey(iMetaFactory, uiFormKey, temFilePath);
            JSONObject jsonFileContent = WebDataMigration.getJsonFileContent(filePath);
            result.add(UICommand.uadataWebJson(JSONObject.toJSONString(jsonFileContent,
                    SerializerFeature.WriteMapNullValue,
                    SerializerFeature.WriteNullStringAsEmpty,
                    SerializerFeature.DisableCircularReferenceDetect)));
        } else if ("DataMap".equalsIgnoreCase(type)) {
            //重新加载数据映射
            String projectKey = LoadFileTree.getProjectKeyByFilePath(filePath);
            ReloadForm.reloadCustom(projectKey, uiFormKey);
            JSONObject jsonFileContent = WebDataMapDesign.getJsonFileContent(filePath);
            result.add(UICommand.uadataWebJson(JSONObject.toJSONString(jsonFileContent,
                    SerializerFeature.WriteMapNullValue,
                    SerializerFeature.WriteNullStringAsEmpty,
                    SerializerFeature.DisableCircularReferenceDetect)));
        } else if ("BPM".equalsIgnoreCase(type)) {
            String newContent = FileUtils.readFileToString(new File(temFilePath), "UTF-8");
            String newSecondLine = DesignIOMetaUtil.getSecondLine(newContent);
            String version;
            try {
                version = DesignIOMetaUtil.getSubString(newSecondLine, "Version=\"([A-Za-z_]\\w*)\"");
            } catch (Exception e) {
                version = "1";
            }
            IMetaFactory iMetaFactory = MetaFactory.getGlobalInstance();
            iMetaFactory.updateProcessDefination(uiFormKey, Integer.parseInt(version));
            iMetaFactory.updateProcessDefinationByDeployKey(uiFormKey);
            JSONObject jsonFileContent = WebBpmDesignCmd.getJsonFileContent(filePath);
            result.add(UICommand.uadataWebJson(jsonFileContent));

        }
        return UICommand.toJson(result);
    }

    @Override
    public IServiceCmd<DefaultContext> newInstance() {
        return new ReductionSnapshotXmlCmd();
    }

    @Override
    public String getCmd() {
        return CMD;
    }
}
