package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.MetaObjectType;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.design.utils.RebuildTableUtil;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.apache.commons.io.FileUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import java.io.File;

/**
 * 适用于工作流、数据迁移、数据映射新增字段
 */
public class RebuildTableCmd extends DesignerServiceCmd {
    public static final String CMD = "RebuildTable";
    /**
     * 路径
     */
    private static String filePath;
    private static String key;
    private static String type;

    @Override
    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        filePath = FilePathHelper.toBackFilePath((String) arguments.get("filePath"));
        key = (String) arguments.get("key");
        type = (String) arguments.get("type");
    }

    @Override
    public Object innerDoCmd(DefaultContext defaultContext) throws Throwable {
        String content = FileUtils.readFileToString(new File(filePath), "UTF-8");
        String newSecondLine = DesignIOMetaUtil.getSecondLine(content);
        if ("Form".equalsIgnoreCase(type)) {
            SAXReader reader = new SAXReader();
            // 加载文档
            Document document = reader.read(new File(filePath));
            // 获取的根节点是临时文件的根节点，再未保存前就修改临时文件
            Element root = document.getRootElement();
            String name = root.getQName().getName();
            if (!newSecondLine.contains(ConstantUtil.EXTEND) && newSecondLine.contains(ConstantUtil.VERSION) && !MetaObjectType.DataObject.name.equals(name)) {//确保不是马甲
                MetaForm form = MetaFactory.getGlobalInstance().getMetaFormList().get(key).getForm();
                if (form != null) {
                    if (form.getFormType() == 1 || form.getFormType() == 2) {
                        RebuildTableUtil.rebuildTable4VestDiff(defaultContext, form);
                    }
                }
            }
        } else if (ConstantUtil.DATA_OBJECT.equalsIgnoreCase(type)) {
            MetaDataObject dataObject = MetaFactory.getGlobalInstance().getDataObject(key);
            if (dataObject != null) {
                RebuildTableUtil.rebuildTable4VestDiff(defaultContext, dataObject);
            }
        }

        return null;
    }

    @Override
    public String getCmd() {
        return CMD;
    }

    @Override
    public IServiceCmd<DefaultContext> newInstance() {
        return new RebuildTableCmd();
    }

}
