package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.mid.base.DefaultContext;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class ReMigrateCmd extends DesignerServiceCmd {

	public static final String CMD = "ReMigrate";

	private String objectKey;

	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		objectKey = (String) arguments.get("objectKey");
	}

	@Override
	public Object innerDoCmd(DefaultContext context) throws Throwable {
		Class<?> aClass = Class.forName("com.bokesoft.yes.mid.migration.period.KeysTableFocusChangeReMigrate");
		Method reMigrate = aClass.getMethod("reMigrate", DefaultContext.class, String.class, boolean.class);
		reMigrate.invoke(aClass.newInstance(), context, objectKey, true);
		List<UICommand> result = new ArrayList<UICommand>();
		UICommand uiCommand = new UICommand("showTip", "操作成功");
		result.add(uiCommand);
		return UICommand.toJson(result);
	}

	@Override
	public String getCmd() {
		return CMD;
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new ReMigrateCmd();
	}
}
