package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.xml.XmlParser;
import com.bokesoft.yes.design.xml.node.CDataNode;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.design.xml.node.XmlTree;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.parser.MidFunctionImplMap;
import com.bokesoft.yes.parser.Parser;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.parser.IEvalContext;
import org.apache.commons.lang3.StringUtils;

import java.util.*;

/**
 *
 */
public class ParseFormulaCmd extends DesignerServiceCmd {
	public static final String CMD = "ParseFormula";
	/**
	 * formula
	 */
	private String formula;
	private String propertyKey;
	/**
	 * formKey
	 */
	private String formKey;
	private String type;
	private String content;

	@Override
	public void dealArguments(DefaultContext defaultContext, StringHashMap<Object> arguments) throws Throwable {
		formula = TypeConvertor.toString(arguments.get("formula"));
		formKey = TypeConvertor.toString(arguments.get("formKey"));
		propertyKey = TypeConvertor.toString(arguments.get("fieldKey"));
		type = TypeConvertor.toString(arguments.get("type"));
		content = TypeConvertor.toString(arguments.get("content"));
	}

	@Override
	public Object innerDoCmd(DefaultContext defaultContext) throws Throwable {
		List<UICommand> result = new ArrayList<UICommand>();

		if ("One".equalsIgnoreCase(type)) {
			if (!(Objects.equals(propertyKey, "Visible") || Objects.equals(propertyKey, "Enable")
					|| Objects.equals(propertyKey, "DefaultFormulaValue") || Objects.equals(propertyKey, "OnLoad") || Objects.equals(propertyKey, "RowInsert")
					|| Objects.equals(propertyKey, "OnRowDelete") || Objects.equals(propertyKey, "RowDelete") || Objects.equals(propertyKey, "RowClick") || Objects.equals(propertyKey, "RowDblClick")
					|| Objects.equals(propertyKey, "FocusRowChanged") || Objects.equals(propertyKey, "OnClick") || Objects.equals(propertyKey, "ValueChanged")
					|| Objects.equals(propertyKey, "Formula") || Objects.equals(propertyKey, "Action") || Objects.equals(propertyKey, "FormulaItems")
					|| Objects.equals(propertyKey, "CheckRule") || Objects.equals(propertyKey, "ItemChanged") || Objects.equals(propertyKey, "ValueDependency") || Objects.equals(propertyKey, "OnPostShow") || Objects.equals(propertyKey, "FormulaCaption")
					|| Objects.equals(propertyKey, "FormulaAbbrCaption") || Objects.equals(propertyKey, "ErrorInfo"))) {
				return UICommand.toJson(result);
			}
		}

		List<Object> evalFormula = parseFormula(formKey, formula);

		if ("all".equalsIgnoreCase(type)) {
			if (evalFormula.size() == 0) {
				evalFormula.add("表单内宏公式格式都正确");
			}
			result.add(UICommand.showTipByList(evalFormula));
		} else if ("xml".equalsIgnoreCase(type)) {
			if (evalFormula.size() > 0) {
				result.add(UICommand.showTipByList(evalFormula));
			}
		} else if ("One".equalsIgnoreCase(type)) {

		} else {

		}
		return UICommand.toJson(result);
	}

	/**
	 * 公式语法解析、只检测语法是否正确
	 *
	 * @param formKey
	 * @param formula
	 * @throws Throwable
	 */
	public List<Object> parseFormula(String formKey, String formula) throws Throwable {

		ArrayList<Object> result = new ArrayList<>();
		IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
		if (!metaFactory.getMetaFormList().containsKey(formKey)) {

			return result;
		}
		MetaForm metaForm = metaFactory.getMetaForm(formKey);
		if (metaForm.getProject().getKey().equalsIgnoreCase( "webconfig")){
			return result;
		}
		Parser<IEvalContext> parser = new Parser<>(MidFunctionImplMap.getMidInstance());
		if (StringUtils.isEmpty(formula)) {
			Map<String, String> stringStringMap = putFormMacrosIntoList(metaForm);
			stringStringMap.forEach((formulaValue, key) -> {
				try {
					parser.parse(formulaValue);
				} catch (Throwable e) {
					result.add("公式:" + key + "内容：" + formulaValue + "语法有误!!");
				}
			});
		} else {
			try {
				parser.parse(formula);
			} catch (Throwable e) {
				throw new Throwable("输入的表达式语法有误：" + formula);
			}
		}

		return result;
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new ParseFormulaCmd();
	}

	@Override
	public String getCmd() {
		return CMD;
	}

	/***
	 * 放当前表单页面宏公式到完成列表中
	 *
	 * @param metaForm
	 */
	private Map<String, String> putFormMacrosIntoList(MetaForm metaForm) throws Throwable {
		Map<String, String> macroMap = new HashMap<>();
		XmlTree xmlTree = null;
		if (StringUtils.isEmpty(content)) {
			String key = metaForm.getKey();
			String filePath = LoadFileTree.getPathByFormKey(key);
			if (StringUtils.isBlank(filePath)) {
				return macroMap;
			}
			XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(filePath);
			xmlTree = xmlTreeWithPath.xmlTree;
		} else {
			xmlTree = XmlParser.parse(content);
		}
		List<CDataNode> cDataNodes = xmlTree.findCDataNodes();
		// metaForm下的cData
		setMacroMap(macroMap, cDataNodes);
		return macroMap;
	}

	/***
	 * 设置宏表达式
	 * @param macroMap 宏表达式map
	 * @param cDataNodes cDataNode集合
	 */
	public void setMacroMap(Map<String, String> macroMap, List<CDataNode> cDataNodes) {
		if (cDataNodes.size() > 0) {
			String args = "";
			String key = "";
			String value = "";
			for (CDataNode cDataNode : cDataNodes) {
				TagNode parent = cDataNode.getParent();
				if (parent.getTagName().equalsIgnoreCase("ColumnExpand")||parent.getTagName().equalsIgnoreCase("TableFilter") || parent.getTagName().equalsIgnoreCase("Statement") && (StringUtils.isEmpty(parent.getAttributes().get("Type")) || "Sql".equalsIgnoreCase(parent.getAttributes().get("Type")))) {
					continue;
				}
				args = parent.getAttributes().get("Args");
				key = parent.getAttributes().get("Key");
				if (StringUtils.isEmpty(key)) {
					key = parent.getTagName();
				} else {
					if (StringUtils.isNotEmpty(args)) {
						key = key + "(" + args + ")";
					} else {
						key = key + "()";
					}
				}
				value = cDataNode.getText();
				macroMap.put(value, key);
			}

		}
	}
}
