package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.mid.base.DefaultContext;

import java.util.ArrayList;
import java.util.List;


/**
 *
 */
public class NewProjectCmd extends DesignerServiceCmd {

	public static final String CMD = "NewProject";

	/**
	 * 新增的项目Key
	 */
	private String ProjectKey;
	/**
	 * 新增的项目名称
	 */
	private String ProjectCaption;
	private String SolutionKey;

	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		ProjectKey = TypeConvertor.toString(arguments.get("newProject")).trim(); // formKey有特殊的含义
		ProjectCaption = TypeConvertor.toString(arguments.get("ProjectCaption")).trim();
		SolutionKey = TypeConvertor.toString(arguments.get("SolutionKey")).trim();
	}

	/**
	 * 新增表单文件
	 */
	@Override
	public Object innerDoCmd(DefaultContext context) throws Throwable {
		String filePath = LoadFileTree.newProjectFile(ProjectKey, ProjectCaption,SolutionKey);
		if (filePath != null) {
		//	EntryProcessor.instance.NewProject(ProjectKey, ProjectCaption,SolutionKey);
			List<UICommand> result = new ArrayList<UICommand>();
			result.add(UICommand.reloadFileTree(filePath));
			result.add(UICommand.reloadMenuTree());
			return UICommand.toJson(result);
		}
		return null;
	}

	@Override
	public String getCmd() {
		return CMD;
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new NewProjectCmd();
	}

}
