package com.bokesoft.yes.design.cmd;

import com.bokesoft.erp.metaobjectchange.MetaObjectChange;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.helper.MetaObjectHelper;
import com.bokesoft.yes.meta.persist.dom.form.MetaFormLoad;
import com.bokesoft.yes.meta.persist.dom.form.MetaFormSave;
import com.bokesoft.yes.meta.persist.dom.form.component.control.listview.MetaRowActionCollectionAction;
import com.bokesoft.yes.meta.persist.dom.xml.XmlCreator;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.def.*;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaExtFormList;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.MetaComponentFactory;
import com.bokesoft.yigo.meta.form.component.control.MetaButton;
import com.bokesoft.yigo.meta.form.component.control.MetaLabel;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaRowAction;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaRowActionCollection;
import com.bokesoft.yigo.meta.form.component.control.tableview.MetaTableRow;
import com.bokesoft.yigo.meta.form.component.control.tableview.MetaTableRowCollection;
import com.bokesoft.yigo.meta.form.component.control.tableview.MetaTableView;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridRow;
import com.bokesoft.yigo.meta.form.component.panel.MetaFlexFlowLayoutPanel;
import com.bokesoft.yigo.meta.form.component.panel.MetaTabPanel;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.*;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.datatable.DataTable;
import org.apache.commons.io.FileUtils;
import org.json.JSONObject;
import org.w3c.dom.Document;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class NewExtensionFormCmd extends DesignerServiceCmd {
    public static final String CMD = "NewExtensionForm";
    /**
     * 项目的名
     */
    public String projectKey;
    /**
     * 新增的表单Key
     */
    private String formKey;
    /**
     * 新增的表单名称
     */
    private String formCaption;
    /**
     * 指定的目录
     */
    private String directory;
    /**
     * 来源表单标识
     */
    private String sourceFormKey;
    /**
     * 来源表单标识
     */
    private DataTable fieldsTableInSourceForm;

    @Override
    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        formKey = TypeConvertor.toString(arguments.get("newFormKey")).trim(); // formKey有特殊的含义
        formCaption = TypeConvertor.toString(arguments.get("formCaption")).trim();
        projectKey = TypeConvertor.toString(arguments.get("projectKey")).trim();
        directory = TypeConvertor.toString(arguments.get("directory")).trim();
        sourceFormKey = TypeConvertor.toString(arguments.get("sourceFormKey")).trim();
        String tableJSON = TypeConvertor.toString(arguments.get("fieldsTableInSourceForm")).trim();
        if (!tableJSON.isEmpty()) {
            fieldsTableInSourceForm = new DataTable();
            fieldsTableInSourceForm.fromJSON(new JSONObject(tableJSON));
        }
    }

    @Override
    protected Object innerDoCmd(DefaultContext defaultContext) throws Throwable {
        IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
        if (Objects.isNull(globalInstance.getExtFormList().get(formKey))) {
            String fileName = formKey + ".xml";
            String content = getNewFormContent();
            directory = directory.isEmpty() ? "Bill" : directory;
            String filePath = LoadFileTree.newFile(projectKey, FormType.Extension, fileName, formKey, formCaption, directory, "1");
            String tmpFilePath = XmlFileProcessor.instance.saveTempFile(filePath, content, projectKey);
            File file = new File(filePath);
            //写入文件夹
            FileUtils.writeStringToFile(file, content, "UTF-8");
            String resource = LoadFileTree.getResource(tmpFilePath, projectKey);
            globalInstance.getExtFormList().get(formKey).setResource(resource);
            EntryProcessor.instance.newForm(projectKey, FormType.Extension, formKey, formCaption, "", true);
//            ReloadForm.reloadFormKey(globalInstance, formKey, resource);
            globalInstance.getExtMetaForm(sourceFormKey, formKey);
            List<UICommand> result = new ArrayList<UICommand>();
            result.add(UICommand.reloadFileTree(filePath));
            result.add(UICommand.runFormKey(formKey));
            result.add(UICommand.reloadMenuTree());
            return UICommand.toJson(result);
        }
        return null;
    }

    private String getNewFormContent() throws Throwable {
        MetaForm module = MetaObjectHelper.deptClone(loadMetaForm("D_ExtensionModule"));
        IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
        MetaProject metaProject = globalInstance.getMetaProject(projectKey);
        module.setProject(metaProject);
        MetaForm newMetaForm = MetaObjectHelper.deptClone(module);
        newMetaForm.setKey(formKey);
        newMetaForm.setCaption(formCaption);
        newMetaForm.setSourceForm(sourceFormKey);
        layoutFields(newMetaForm);
        MetaFormSave save = new MetaFormSave(newMetaForm);
        Document newDocument = save.getDocument();
        XmlCreator creator = new XmlCreator(newDocument, null);
        String xml = creator.createXml();
        MetaExtFormList metaFormList = globalInstance.getExtFormList();
        MetaFormProfile newFormProfile = MetaObjectHelper.deptClone(metaFormList.get(module.getKey()));
        newMetaForm.setProject(metaProject);
        newFormProfile.setProject(metaProject);
        newFormProfile.setKey(formKey);
        newFormProfile.setCaption(formCaption);
        newFormProfile.setResource("");
        newFormProfile.setSourceForm(sourceFormKey);
        newFormProfile.setPlatform(newMetaForm.getPlatform());
        newFormProfile.setForm(newMetaForm);
        metaFormList.add(newFormProfile);
        MetaObjectChange.fireChangeDesignMetaForm(newMetaForm);
        MetaForm erpNewMetaForm = globalInstance.getExtMetaForm(sourceFormKey, formKey); // 这里进行ERPMetaFactory中的相关处理
        globalInstance.replaceMetaForm(formKey, erpNewMetaForm);
        return xml;
    }

    public MetaForm loadMetaForm(String formKey) throws Throwable {
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        MetaFormProfile formProfile = metaFactory.getExtFormList().get(formKey);
        String resource = formProfile.getResource();
        String projectKey = formProfile.getProject().getKey();
        IMetaResolver resolver = metaFactory.getProjectResolver(projectKey);
        MetaFormLoad formLoad = new MetaFormLoad(AppRunType.Dev);
        formLoad.load(resolver, resource);
        MetaForm newMetaForm = (MetaForm) formLoad.getRootMetaObject();
        newMetaForm.setProject(formProfile.getProject());
        newMetaForm.setResource(resource);
        return newMetaForm;
    }

    //排列关联字段
    private void layoutFields(MetaForm metaForm) throws Throwable {
        MetaComponent rootPanel = metaForm.getMetaBody().get(0).getComponent(0);
        if (rootPanel instanceof MetaFlexFlowLayoutPanel) {
            MetaFlexFlowLayoutPanel metaRootPanel = (MetaFlexFlowLayoutPanel) rootPanel;
            MetaTabPanel metaTabPanel = new MetaTabPanel();
            metaTabPanel.setKey("MainTabPanel");
            metaTabPanel.setHeight(DefSize.parse("100%"));
            metaRootPanel.addComponent(metaTabPanel);
            MetaGridLayoutPanel baseTabItem = getBaseInfoPanel(fieldsTableInSourceForm.size());
            List<MetaButton> buttonList = new ArrayList<>();
            List<MetaComponent> gridList = new ArrayList<>();
            int rowIndex = 0;
            for (int i = fieldsTableInSourceForm.size() - 1; i >= 0; i--) {
                fieldsTableInSourceForm.setPos(i);
                int selected = fieldsTableInSourceForm.getInt("IsSelected");
                if (selected == 1) {
                    String fieldType = fieldsTableInSourceForm.getString("FieldType");
                    if (fieldType.equals("Grid")) {
                        String fieldKey = fieldsTableInSourceForm.getString("FieldKey");
                        String fieldCaption = fieldsTableInSourceForm.getString("FieldCaption");
                        MetaFlexFlowLayoutPanel gridRootPanel = new MetaFlexFlowLayoutPanel();
                        gridRootPanel.setKey(fieldKey + "_RootPanel");
                        gridRootPanel.setCaption(fieldCaption);
                        MetaTableView metaTableView = getTableViewFromGrid(fieldKey, fieldCaption);
                        gridRootPanel.addComponent(metaTableView);
                        gridList.add(gridRootPanel);
                    } else {
                        MetaComponent metaComponent = MetaComponentFactory.getInstance().newComponent(fieldType);
                        metaComponent.setKey(fieldsTableInSourceForm.getString("FieldKey"));
                        metaComponent.setCaption(fieldsTableInSourceForm.getString("FieldCaption"));
                        metaComponent.setCompStyle("innerLabel_m");
                        metaComponent.setCssClass("editcontrol");
                        if (fieldType.equals("Button")) {
                            buttonList.add((MetaButton) metaComponent);
                        } else {
                            metaComponent.setX(1);
                            metaComponent.setY(rowIndex);
                            baseTabItem.addComponent(metaComponent);
                            rowIndex++;
                        }
                    }
                }
            }
            for (MetaButton metaButton : buttonList) {
                metaButton.setX(1);
                metaButton.setY(rowIndex);
                metaButton.setType(ButtonType.NORMAL);
                baseTabItem.addComponent(metaButton);
                rowIndex++;
            }
            baseTabItem.getMetaRowDefCollection().remove(rowIndex + 1, baseTabItem.getMetaRowDefCollection().size() - 1);
            if (baseTabItem.getComponentCount() > 0) {
                metaTabPanel.addComponent(baseTabItem);
            }

            for (MetaComponent metaComponent : gridList) {
                metaTabPanel.addComponent(metaComponent);
            }
        }
    }

    private MetaGridLayoutPanel getBaseInfoPanel(int size) {
        MetaGridLayoutPanel baseInfoPanel = new MetaGridLayoutPanel();
        baseInfoPanel.setKey("BaseInfo");
        baseInfoPanel.setCaption("表单信息");
        baseInfoPanel.setOverflowY(ScrollType.Scroll);
        MetaColumnDefCollection metaColumnDefCollection = new MetaColumnDefCollection();
        metaColumnDefCollection.setColumnGap(5);
        MetaColumnDef metaColumnDef1 = new MetaColumnDef();
        metaColumnDef1.setWidth(DefSize.parse("10px"));
        metaColumnDefCollection.add(metaColumnDef1);
        MetaColumnDef metaColumnDef2 = new MetaColumnDef();
        metaColumnDef2.setWidth(DefSize.parse("100%"));
        metaColumnDefCollection.add(metaColumnDef2);
        MetaColumnDef metaColumnDef3 = new MetaColumnDef();
        metaColumnDef3.setWidth(DefSize.parse("10px"));
        metaColumnDefCollection.add(metaColumnDef3);
        baseInfoPanel.setColumnDefCollection(metaColumnDefCollection);
        MetaRowDefCollection metaRowDefCollection = new MetaRowDefCollection();
        metaRowDefCollection.setRowGap(5);
        metaRowDefCollection.setRowHeight(30);
        for (int i = 0; i < size; i++) {
            MetaRowDef metaRowDef = new MetaRowDef();
            metaRowDefCollection.add(metaRowDef);
        }
        baseInfoPanel.setRowDefCollection(metaRowDefCollection);
        return baseInfoPanel;
    }

    private MetaTableView getTableViewFromGrid(String fieldKey, String fieldCaption) throws Throwable {
        MetaTableView metaTableView = (MetaTableView) MetaComponentFactory.getInstance().newComponent("TableView");
        metaTableView.setKey(fieldKey);
        metaTableView.setCaption(fieldCaption);
        metaTableView.setHeight(DefSize.parse("100%"));
        MetaTableRowCollection metaTableRowCollection = new MetaTableRowCollection();
        MetaTableRow metaTableRow = new MetaTableRow();
        metaTableRow.setRowType(RowType.Detail);
        metaTableRow.setKey(fieldKey + "_DetailRow");
        metaTableRow.setCaption(fieldCaption);
        MetaBaseScript rowClick = new MetaBaseScript("RowClick");
        rowClick.setContent("EditRowPop('" + fieldKey + "', -1)");
        metaTableRow.setRowClick(rowClick);
        MetaRowActionCollection metaRowActions = new MetaRowActionCollection();
        MetaRowAction metaRowAction = new MetaRowAction();
        metaRowAction.setKey("DeleteRow");
        metaRowAction.setCaption("删除");
        metaRowAction.setContent("DeleteRow('" + fieldKey + "', -1)");
        metaRowActions.add(metaRowAction);
        metaTableRow.setActionCollection(metaRowActions);
        MetaGridLayoutPanel gridLayout = new MetaGridLayoutPanel();
        gridLayout.setKey(metaTableRow.getKey() + "_RootPanel");
        MetaRowDefCollection metaRowDefCollection = new MetaRowDefCollection();
        metaRowDefCollection.setRowGap(5);
        metaRowDefCollection.setRowHeight(32);
        MetaRowDef metaRowDef1 = new MetaRowDef();
        metaRowDefCollection.add(metaRowDef1);
        gridLayout.setRowDefCollection(metaRowDefCollection);
        MetaColumnDefCollection metaColumnDefCollection = new MetaColumnDefCollection();
        metaColumnDefCollection.setColumnGap(5);
        MetaColumnDef metaColumnDef1 = new MetaColumnDef();
        metaColumnDef1.setWidth(DefSize.parse("10px"));
        metaColumnDefCollection.add(metaColumnDef1);
        MetaColumnDef metaColumnDef2 = new MetaColumnDef();
        metaColumnDef2.setWidth(DefSize.parse("100%"));
        metaColumnDefCollection.add(metaColumnDef2);
        MetaColumnDef metaColumnDef3 = new MetaColumnDef();
        metaColumnDef3.setWidth(DefSize.parse("10px"));
        metaColumnDefCollection.add(metaColumnDef3);
        gridLayout.setColumnDefCollection(metaColumnDefCollection);
        addGridCells(gridLayout, fieldKey);
        metaTableRow.setRoot(gridLayout);
        metaTableRowCollection.add(metaTableRow);
        metaTableView.setRows(metaTableRowCollection);
        return metaTableView;
    }

    private void addGridCells(MetaGridLayoutPanel gridLayout, String gridKey) throws Throwable {
        MetaForm sourceForm = MetaFactory.getGlobalInstance().getMetaForm(sourceFormKey);
        AbstractMetaObject metaObject = sourceForm.getAllUIComponents().get(gridKey);
        if(metaObject.getTagName().equals("Grid")){
            MetaGrid metaGrid = (MetaGrid) metaObject;
            if(metaGrid.getRowCollection().isEmpty()) return;
            MetaGridRow metaGridRow = metaGrid.getRowCollection().get(0);
            int cellCount = 0;
            for (int i = 0; i < metaGridRow.size(); i++) {
                MetaGridCell metaGridCell = metaGridRow.get(i);
                if(metaGridCell.isRequired()){
                    //添加一个行定义
                    MetaRowDef metaRowDef = new MetaRowDef();
                    gridLayout.getMetaRowDefCollection().add(metaRowDef);
                    //添加对应的单元格组件
                    String cellTagName = ControlType.toString(metaGridCell.getCellType());
                    MetaComponent metaCell = MetaComponentFactory.getInstance().newComponent(cellTagName);
                    metaCell.setKey(metaGridCell.getKey());
                    metaCell.setCaption(metaGridCell.getCaption());
                    metaCell.setX(1);
                    metaCell.setY(cellCount);
                    metaCell.setCssClass("innerLabel-show");
                    gridLayout.addComponent(metaCell);

                    cellCount++;
                }
            }
        }
    }

    @Override
    public IServiceCmd<DefaultContext> newInstance() {
        return new NewExtensionFormCmd();
    }

    @Override
    public String getCmd() {
        return CMD;
    }
}
