package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.factory.extend.DefaultFormExtendProcessor;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;

/**
 *
 */
public class NewExpandFormProcesCmd extends DesignerServiceCmd {
	public static final String CMD = "NewExpandFormProces";

	/**
	 * 关联表单
	 */
//	private String associationForm;
	/**
	 * 新增的扩展表单Key
	 */
	private String formKey;

	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
//		associationForm = TypeConvertor.toString(arguments.get("associationForm")).trim();
		formKey = TypeConvertor.toString(arguments.get("newFormKey")).trim(); // formKey有特殊的含义
	}

	@Override
	public Object innerDoCmd(DefaultContext defaultContext) throws Throwable {

		MetaForm newmetaForm = MetaFactory.getGlobalInstance().getMetaForm(formKey);
		IMetaFactory metaFactory = defaultContext.getVE().getMetaFactory();
		new DefaultFormExtendProcessor().process(metaFactory, newmetaForm);
		return null;
	}


	@Override
	public String getCmd() {
		return CMD;
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new NewExpandFormProcesCmd();
	}

}
