package com.bokesoft.yes.design.cmd;

import com.bokesoft.erp.performance.trace.SessionUICommands;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.MetaObjectType;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.helper.DocumentHelper;
import com.bokesoft.yes.log.LogSvr;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.cmd.richdocument.strut.DocumentRecordDirty;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.FormType;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;

import java.util.*;
import java.util.stream.Collectors;


public class NewCompositeComponentCmd extends DesignerServiceCmd {
    public static final String CMD = "newCompositeComponent";
    private String tableKey;
    private String metaObjectType;
    private Integer x;
    private Integer y;
    private String parentKey;
    private String formKey;
    private Document designerDocument;
    private DocumentRecordDirty formDocument;
    private String reserveTwo;
    private String reserveFour;
    private String sideKey;
    private Boolean insertAfter;
    private String entryParas;
    private static String showXmlError = "";

    @Override
    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        tableKey = (String)arguments.get("tableKey");
        if(StringUtils.isNotEmpty((String)arguments.get("x"))) {
            x = Integer.parseInt((String) arguments.get("x"));
        }
        if(StringUtils.isNotEmpty((String)arguments.get("y"))) {
            y = Integer.parseInt((String) arguments.get("y"));
        }
        parentKey = (String)arguments.get("parentKey");
        formKey = (String)arguments.get("formKey");
        metaObjectType = (String)arguments.get("metaObjectType");
        entryParas = (String)arguments.get("entryParas");
        reserveTwo = (String)arguments.get("reserveTwo");
        reserveFour = (String)arguments.get("reserveFour");
        sideKey = (String)arguments.get("sideKey");
        insertAfter = Boolean.parseBoolean((String)arguments.get("insertAfter"));
        if (arguments.containsKey("designerDocument")) {
            String docStr = (String)arguments.get("designerDocument");
            designerDocument = DocumentHelper.parseDocumentFormJSON(docStr);
        }
        if (arguments.containsKey("formDocument")) {
            String docStr = (String)arguments.get("formDocument");
            String documentFormKey = (String)arguments.get("documentFormKey");
            MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(documentFormKey);
            formDocument = new DocumentRecordDirty(metaForm, false);
            try {
                formDocument.fromJSON(new JSONObject(docStr));
            } catch (Exception e) {
                LogSvr.getInstance().error(e.getMessage(), e);
            }
        }
    }

    @Override
    public Object innerDoCmd(DefaultContext context) throws Throwable {
        final IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        List<UICommand> uiCommands = new ArrayList<>();

        MetaFormProfile tmpProfile = metaFactory.getMetaFormList().get(formKey);
        if(tmpProfile == null) {
            tmpProfile = metaFactory.getExtFormList().get(formKey);
        }
        String prjKey = tmpProfile.getProject().getKey();

        if (LoadFileTree.isJarProjectKey(prjKey)) {
            uiCommands.add(UICommand.showTip("Jar包中的表单无法修改 ("+NewCompositeComponentCmd.class.getSimpleName()+")"));
            return UICommand.toJson(uiCommands);
        }

        List<Diff> diffs = getDiffs();
        if(diffs.size() < 1) {
            return uiCommands;
        }
        uiCommands = commitDiff(context, formKey, entryParas, diffs, designerDocument, formDocument);
        List<com.bokesoft.yes.mid.cmd.richdocument.strut.UICommand> sessionUICommands =
            SessionUICommands.getUICommands(context);
        if (sessionUICommands != null) {
            for (com.bokesoft.yes.mid.cmd.richdocument.strut.UICommand runUICommand : sessionUICommands) {
                UICommand uiCommand = new UICommand(runUICommand.key, runUICommand.content);
                uiCommands.add(uiCommand);
            }
            sessionUICommands.clear(); // 这里是一次性消费，如果传输失败，那这些界面命令将丢失
        }

        MetaForm metaForm = metaFactory.getMetaForm(formKey);
        if (StringUtils.isNotBlank(metaForm.getExtend())) {
            uiCommands.add(UICommand.reloadFormKey(formKey));
            uiCommands.add(UICommand.reloadFormKey(metaForm.getExtend()));
        } else {
            final MetaFormList metaFormList = metaFactory.getMetaFormList();
            for (MetaFormProfile metaFormProfile : metaFormList) {
                final String extend = metaFormProfile.getExtend();
                if (StringUtils.equals(extend, formKey)) {
                    uiCommands.add(UICommand.reloadFormKey(metaFormProfile.getKey()));
                }
            }
        }

        // TODO 是否包含创建表操作，这里还有其他的情况可能需要处理，而不仅仅是 ListView
        boolean hasPreOpt = false;
        if (!hasPreOpt) {
            uiCommands = uiCommands.stream().distinct().collect(Collectors.toList());
            return UICommand.toJson(uiCommands);
        }
        String filePath = LoadFileTree.getPathByFormKey(formKey);
        if (XmlFileProcessor.filePathToTmpFileMap.containsKey(filePath)) {
            Stack<String> stack = XmlFileProcessor.filePathToTmpFileMap.get(filePath);
            String curTmpFile = stack.pop();
            stack.pop(); // 弹出创建新建表的临时文件
            stack.push(curTmpFile);
        }
        uiCommands = uiCommands.stream().distinct().collect(Collectors.toList());
        return UICommand.toJson(uiCommands);
    }

    private List<Diff> getDiffs() throws Throwable {
        List<Diff> diffs = new ArrayList<>();
        DataTable dataTable = designerDocument.get(ConstantUtil.ComponentDtl);
        ArrayList<String> fieldKeyList = new ArrayList();
        for (int i = 0; i < dataTable.size(); i++) {
            Integer selectField = designerDocument.get(ConstantUtil.ComponentDtl).getInt(i, "SelectField");
            if(selectField < 1) continue;
            Diff diff = new Diff("d" + System.currentTimeMillis(), formKey, true);
            String key = dataTable.getString(i, ConstantUtil.ComponentKey);
            MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(formKey);
            metaForm.getAllUIComponents().keySet().forEach(fieldKey -> {
                if (StringUtils.equalsIgnoreCase(fieldKey, key)) {
                    fieldKeyList.add(key);
                }
            });
            String columnKey = dataTable.getString(i, ConstantUtil.COLUMN_KEY);
            String caption = dataTable.getString(i, ConstantUtil.ComponentCaption);
            String controlType = dataTable.getString(i, ConstantUtil.CONTROLTYPE);
            diff.setIsButtonQuote(false);
            diff.setCreate("false");
            diff.setEmbed(false);
            diff.setKey(key);
            diff.setDictType(null);
            diff.setContainerKey(null);
            if(ConstantUtil.Field.equals(metaObjectType)){
                if (ControlType.STR_DYNAMICDICT.equals(controlType)) {
                    String itemKey = dataTable.getString(i, ConstantUtil.ITEM_KEY);
                    diff.setReserveOne(itemKey); // Todo 这里注意动态字典
                }
            }else if(ConstantUtil.GridField.equals(metaObjectType)){
                diff.setReserveOne(key); //
            }
            diff.setReserveTwo(reserveTwo);
            diff.setTrueOrfalse(true);
            diff.setReserveThree(columnKey);
            diff.setReserveFour(reserveFour);
            if (ControlType.STR_DICT.equals(controlType)) {
                String itemKey =  dataTable.getString(i, ConstantUtil.ITEM_KEY);
                diff.setItemKey(itemKey);
            }
            diff.setParamsformKey(formKey);
            diff.parentKey = parentKey.trim();
            String sObjectType = StringUtils.isBlank(metaObjectType) ? null : metaObjectType;
            diff.setMetaObjectType(
                StringUtils.isBlank(metaObjectType) ? null : MetaObjectType.getMetaObjectType(metaObjectType));
            boolean isNewComponent = StringUtils.isNotEmpty(caption); // 新增控件
            if (isNewComponent) { // 新增
                diff.caption = caption;
                diff.sideKey = sideKey;
                diff.x = x;
                diff.y = y;
                if (sObjectType.equals(MetaObjectType.gridField.name)
                    || sObjectType.equals(MetaObjectType.GridFieldRow.name)
                    || sObjectType.equalsIgnoreCase(MetaObjectType.ListViewColumn.name)) {// 表格列
                    diff.insertAfter = insertAfter;
                }
            }
            diff.isDelete = false;
            diff.isMultyDelete = false;
            diff.isMultyMove = false;
            diff.controlType = ControlType.parse(controlType);
            if (diff.controlType == -1 && metaObjectType.equals(MetaObjectType.GridFieldRow.name)
                && StringUtils.isNotEmpty(controlType)) {
                diff.controlType = Integer.parseInt(controlType);
            }
            diff.tableKey = tableKey;
            if (!"".equals(diff.tableKey) && diff.tableKey != null) {
                diff.associatedTable = diff.tableKey;
            }
            diff.x = x;
            diff.y = y;
            diffs.add(diff);
        }
        if(fieldKeyList.size() > 0){
            throw new Throwable( "组件标识 " + fieldKeyList.toString() + "已存在，请修改");
        }
        return diffs;
    }

    public List<UICommand> commitDiff(DefaultContext context, String formKey, String entryParas, List<Diff> diffs,
        Document designerDocument, DocumentRecordDirty formDocument) throws Throwable {
        CommitDiffCmd.loadXmlTrees(diffs, entryParas, null);
        // 1.从属性差异转化为XML节点差异
        final int anInt = XmlDiffProcessor.instance.processDiff(diffs, designerDocument);
        // 2.从XML节点差异转化属性差异（可能转化无效）
        boolean genPropertyDiffSuccess = XmlDiffToPropertyDiff.instance.processDiff(diffs);
        // 3.通过XML节点差异，修改XML临时文件
        Map<String, String> tmpFiles = XmlFileProcessor.instance.processDiff(diffs, true);
        // 4.通过XML节点差异，配置对象读取差异
        List<UICommand> uiCommands = new ArrayList<>();
        String XmlError =
            MetaFormDiffProcessor.instance.processDiff(context,diffs, genPropertyDiffSuccess, formDocument, tmpFiles);
        showXmlError += XmlError;
        // 5.通过属性差异，生成WebJson对象（若属性差异无效，界面刷新）
        if (genPropertyDiffSuccess) {
            WebBuilderDiffProcessor.instance.processDiff(context, diffs, uiCommands);
        }
        // 6.通过属性差异，生成界面UICommand（若属性差异无效，界面刷新）
        UIFormDiffProcessor.instance.processDiff(diffs, uiCommands, genPropertyDiffSuccess, XmlError, anInt);
        // 更新前端Document
        processDocumentDirty(diffs, formKey, uiCommands, formDocument, context);
        // 7.更新Diff的FilePath和ReloadXmlSource
        updateDiffFilePath(uiCommands);
        return uiCommands;
    }

    private static void processDocumentDirty(List<Diff> diffs, String Key, List<UICommand> uiCommands,
        DocumentRecordDirty formDocument, DefaultContext context) throws Throwable {
        // TODO: 判断是否有脏数据
        if (Objects.isNull(formDocument)) {
            return;
        }

        String formKey = formDocument.getMetaForm().getKey();
        if (!StringUtils.equals(diffs.get(0).getParamsformKey(), formKey)) {
            return;
        }

        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        MetaFormProfile metaFormProfile = metaFactory.getMetaFormList().get(Key);
        String extend = metaFormProfile.getExtend();
        // 是马甲或者视图不做处理
        if (StringUtils.isNotBlank(extend) && !metaFormProfile.getMergeToSource()) {
            return;
        }
        if (metaFormProfile.getForm().getFormType() == FormType.View) {
            return;
        }

        RichDocumentContext richDocumentContext = processParentContext(context, formDocument);
        formDocument.setContext(richDocumentContext);
        // 以json的形式返回脏数据
        try {// 当嵌入模板时这个会报错就不进行
            formDocument.setMetaForm(metaFormProfile.getForm());
            JSONObject documentDirty = formDocument.getDirtyJSON(richDocumentContext);
            uiCommands.add(UICommand.processDocumentDirty(formKey, documentDirty));
        } catch (Throwable e) {// 不处理
            LogSvr.getInstance().error("", e);
        }
    }

    private static RichDocumentContext processParentContext(DefaultContext context, DocumentRecordDirty formDocument)
        throws Throwable {
        context.setFormKey(formDocument.getMetaForm().getKey());
        context.setDocument(formDocument);
        RichDocumentContext parentContext = (RichDocumentContext)context.getParentContext();
        if (Objects.isNull(parentContext)) {
            parentContext = new RichDocumentContext(context);
            parentContext.setDocument(formDocument);
            context.setParentContext(parentContext);
        }
        return parentContext;
    }

    private static void updateDiffFilePath(List<UICommand> uiCommands) {
        Map<String, String> diffSequenceToFilePath = new HashMap<String, String>();

        if (StringUtils.isNotEmpty(NewCompositeComponentCmd.showXmlError)) {
            uiCommands.add(UICommand.showTip(NewCompositeComponentCmd.showXmlError));
            NewCompositeComponentCmd.showXmlError = "";
        }
        if (diffSequenceToFilePath.size() > 0) {
            if (UIFormDiffProcessor.Error != null) {
                return;
            }
            uiCommands.add(UICommand.updateDiffFilePath(diffSequenceToFilePath));
        }
    }

    @Override
    public IServiceCmd<DefaultContext> newInstance() {
        return new NewCompositeComponentCmd();
    }

    @Override
    public String getCmd() {
        return CMD;
    }
}
