package com.bokesoft.yes.design.cmd;

import java.io.File;
import java.util.List;

import com.bokesoft.yes.helper.FilePathHelper;
import org.json.JSONArray;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.mid.base.DefaultContext;

/**
 * 取文件内容
 */
public class LoadParentPathsByPathCmd extends DesignerServiceCmd {

	public static final String CMD = "LoadParentPathsByPath";

	private String path;

	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		path = FilePathHelper.toBackFilePath((String) arguments.get("path"));
	}

	@Override
	public Object innerDoCmd(DefaultContext context) throws Throwable {
		List<String> parentPaths = LoadFileTree.loadParentPathsByPath(context, path);
		JSONArray result = new JSONArray();
		if (parentPaths != null) {
			for (String parentPath : parentPaths) {
				String tmpPath = FilePathHelper.toFrontFilePath(parentPath);
				result.put(tmpPath);
			}
		}
		return result;
	}

	@Override
	public String getCmd() {
		return CMD;
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new LoadParentPathsByPathCmd();
	}
}
