package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.io.IOMetaObject;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.json.JSONArray;
import org.json.JSONObject;

import java.util.List;

/**
 * 根据FormKey取Form相关的所有文件，包含模板、数据源文件
 */
public class LoadFilePathsByFormKeyCmd extends DesignerServiceCmd {

	public static final String CMD = "LoadFilePathsByFormKey";

	private String uiFormKey;
	private String entryParas;
	private String container;

	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		uiFormKey = (String) arguments.get("uiFormKey");
		entryParas = (String) arguments.get("entryParas");
		container = (String) arguments.get("Container");
	}

	@Override
	public Object innerDoCmd(DefaultContext context) throws Throwable {
		List<String[]> filePaths = LoadFileTree.loadFilePathsByFormKey(context, uiFormKey, entryParas, container);
		IOMetaObject.currentFormKey = uiFormKey;
		JSONArray result = new JSONArray();
		if (filePaths != null) {
			for (String[] tmp : filePaths) {
				JSONObject json = new JSONObject();
				json.put("filePath", FilePathHelper.toFrontFilePath(tmp[0]));
				json.put("caption", FilePathHelper.toFrontFilePath(tmp[1]));
				result.put(json);
			}
		}
		/*//将修改后且未保存的xml也打开
		XmlFileProcessor.instance.filePathToTmpFileMap.forEach((a,b)->{
			JSONObject json = new JSONObject();
			json.put("filePath", a);
			json.put("caption", a);
			result.put(json);
		});*/
		return result;
	}

	@Override
	public String getCmd() {
		return CMD;
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new LoadFilePathsByFormKeyCmd();
	}
}
