package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.io.IOMetaObject;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.cmd.richdocument.strut.IDLookup;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.MetaEmbed;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridRow;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridRowCollection;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.usrpara.Paras;
import com.bokesoft.yigo.tools.document.DataTableUtil;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;

import java.util.List;

public class LoadDesignerGridTreeOneLevelCmd extends DefaultServiceCmd {

    public static final String CMD = "LoadDesignerGridTreeOneLevel";
    /**
     * 在树表格的DataTable中增加一个字段，记录儿子的个数，可实现成下一层儿子的个数，也可实现也所有子孙的个数。界面通过这个字段判断是否逐层加载
     */
    /**
     * 表单Key
     */
    private String formKey;
    private String belongFormKey;
    /**
     * 数据库表Key
     */
    private String tableKey;
    /**
     * 父节点的值
     */
    private String parentKey;
    /**
     * 表单参数，查询条件通过表单参数传递
     */
    private Paras formParameters;
    private String panelKey;
    private String panelType;

    @Override
    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        formKey = (String) arguments.get("formKey");
        tableKey = (String) arguments.get("tableKey");
        parentKey = (String) arguments.get("parentKey");
        belongFormKey = (String) arguments.get("belongFormKey");
        panelKey = (String) arguments.get("panelKey");
        panelType = (String) arguments.get("panelType");
        Object parameters = arguments.get("parameters");
        if (parameters != null) {
            JSONObject json = new JSONObject(parameters.toString());
            formParameters = new Paras();
            formParameters.fromJSON(json);
        }
    }

    @Override
    public Object doCmd(DefaultContext context) throws Throwable {
        MetaTable metaTable = MetaFactory.getGlobalInstance().getMetaForm(formKey).getDataSource().getDataObject().getTable(tableKey);
        DataTable dataTable = DataTableUtil.newEmptyDataTable(metaTable);
        if ("ED_FileTree".equalsIgnoreCase(tableKey)) {
            LoadFileTree.loadFileTree(context, dataTable, panelKey);
        }else if ("ED_Entry".equalsIgnoreCase(tableKey)) {
            IOMetaObject.loadEntrysTree(dataTable, panelKey);
        } else if ("ED_FormNodeTree".equalsIgnoreCase(tableKey)) {
            String ownerFormKey = (String) context.getPara("OwnerFormKey");
            String OtherKey = (String) context.getPara("ContainerKey");
            MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(ownerFormKey);
            IDLookup idLoopup = IDLookup.getIDLookup(metaForm);
            String parentkey = ownerFormKey;
            String formKey = belongFormKey;;
            List<MetaEmbed> embeds = metaForm.getEmbeds();
            boolean embedKey = false;
            for (MetaEmbed embed : embeds) {//模板因为componentMap没有值所以用getAllUIComponents
                MetaForm metaForm1 = MetaFactory.getGlobalInstance().getMetaForm(embed.getFormKey());
                embedKey = metaForm1.getAllUIComponents().containsKey(panelKey);
                if (embedKey && embed.getRootKey().equals(panelKey)) {
                    formKey = embed.getFormKey();
                    break;
                } else {
                    embedKey = false;
                }
            }
            if (!embedKey && !idLoopup.containFieldKey(panelKey) && StringUtils.isNotEmpty(OtherKey)) {
                parentkey = OtherKey;
                formKey = OtherKey;
            }
            if ("D_GridRow".equals(panelType)){
                MetaComponent component = metaForm.componentByKey(parentKey);
                MetaGridRow metaGridRow = null;
                if (component instanceof MetaGrid) {
                    MetaGridRowCollection rowCollection = ((MetaGrid) component).getRowCollection();
                    for (MetaGridRow metaGridCells : rowCollection) {
                        if (metaGridCells.getKey().equals(panelKey)) {
                            metaGridRow = metaGridCells;
                            break;
                        }
                    }
                }
                IOMetaObject.loadGridRows(dataTable, panelKey,formKey,metaGridRow);
            }else {
                IOMetaObject.loadPanels(context, dataTable, panelKey, formKey,parentkey);
            }
        }
        return dataTable;
    }

    @Override
    public String getCmd() {
        return CMD;
    }

    @Override
    public IServiceCmd<DefaultContext> newInstance() {
        return new LoadDesignerGridTreeOneLevelCmd();
    }
}
