package com.bokesoft.yes.design.cmd;

import com.bokesoft.erp.WebDesignerConfiguration;
import com.bokesoft.erp.register.ErpConfig;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.design.xml.node.XmlTree;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.datamap.MetaDataMapProfile;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigrationProfile;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectList;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectProfile;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelTemplateSubList;
import com.bokesoft.yigo.meta.factory.DefaultMetaFactory;
import com.bokesoft.yigo.meta.factory.DefaultMetaResolverFactory;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.IMetaResolverFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.report.MetaReportSubList;
import com.bokesoft.yigo.meta.solution.MetaSolution;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.apache.commons.io.FileUtils;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

/**
 *
 */
public class ImportSolutionCmd extends DesignerServiceCmd {

    public static final String CMD = "ImportSolution";

    String newSolutionPath = "";
    String deleteSolutionPath = "";
    boolean isNew;

    @Override
    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        newSolutionPath = FilePathHelper.toBackFilePath((String) arguments.get("newSolutionPath"));;
        deleteSolutionPath = (String) arguments.get("deleteSolutionPath");
        isNew = Boolean.parseBoolean((String) arguments.get("isNew"));
    }

    /**
     * 新增表单文件
     */
    @Override
    public Object innerDoCmd(DefaultContext context) throws Throwable {
        List<UICommand> result = new ArrayList<>();
        String workspacePath = FilePathHelper.getWorkspacePath();
        try {

            if (isNew) {
                IMetaResolverFactory metaResolverFactory = new DefaultMetaResolverFactory(newSolutionPath);
                DefaultMetaFactory factory = new DefaultMetaFactory(metaResolverFactory);
                String key = factory.getSolution().getKey();
                String caption = factory.getSolution().getCaption();
                boolean isWrite = NewSolutionCmd.writeImportSolution(key, caption, newSolutionPath);
                if (isWrite) {
                    LoadFileTree.loadImportSolution(MetaFactory.getGlobalInstance(), workspacePath, newSolutionPath, metaResolverFactory, factory);
                    ErpConfig.initExtendConfig();
                    String parent = new File(workspacePath).getParent()+File.separator+"solutionsImport";
                    result.add(UICommand.reloadFileTree(parent));
                    result.add(UICommand.reloadFileTree(newSolutionPath));
                    result.add(UICommand.showTip("解决方案导入成功"));
                } else {
                    result.add(UICommand.showError("操作失败：解决方案导入重复"));
                }
            } else {//删除
                DefaultMetaFactory factory = LoadFileTree.metaDesignerFactoryMap.get(deleteSolutionPath);
                MetaSolution solution = factory.getSolution();
                String key = solution.getKey();
                deleteImportSolution(key, result, workspacePath, factory);
                LoadFileTree.metaDesignerFactoryMap.remove(deleteSolutionPath);
                LoadFileTree.loadImportSolutions.remove(deleteSolutionPath);
                LoadFileTree.removeFilePath(deleteSolutionPath);
                Collection<MetaSolution> metaSolutions = MetaFactory.getGlobalInstance().getMetaSolutions();
                for (MetaSolution metaSolution : metaSolutions) {
                    if (metaSolution.getKey().equals(key)){
                        metaSolutions.remove(metaSolution);
                        break;
                    }
                }
                MetaFormList metaFormList = factory.getMetaFormList();
                MetaDataObjectList dataObjectList = MetaFactory.getGlobalInstance().getDataObjectList();
                for (MetaFormProfile metaFormProfile : metaFormList) {
                    MetaDataObjectProfile metaDataObjectProfile = dataObjectList.get(metaFormProfile.getKey());
                    if (!Objects.isNull(metaDataObjectProfile)){
                        dataObjectList.remove(metaFormProfile.getKey());
                    }
                }
//                String parent = new File(workspacePath).getParent()+File.separator+"solutionsImport";
//                result.add(UICommand.reloadFileTree(parent));
                LoadFileTree.clear();
            }
        } catch (Exception e) {
            if (e.getMessage() == null){
                result.add(UICommand.showError("导入的解决方案有误，请检查后再试！"));
            }else {
                result.add(UICommand.showError(e.getMessage()));
            }
        } finally {
            return UICommand.toJson(result);
        }


    }

    @Override
    public String getCmd() {
        return CMD;
    }

    @Override
    public IServiceCmd<DefaultContext> newInstance() {
        return new ImportSolutionCmd();
    }

    public static void deleteImportSolution(String key, List<UICommand> result, String solutionPath, DefaultMetaFactory factory) throws Throwable {
        String designerImportSolutionsPath = WebDesignerConfiguration.getDesignerImportSolutionsPath();
        XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(designerImportSolutionsPath);
        XmlTree xmlTree = xmlTreeWithPath.xmlTree;
        String tagNodeKey = "ImportSolution@" + key;
        boolean containKey = xmlTree.containKey(tagNodeKey);
        if (containKey) {
            TagNode root = xmlTree.getRoot();
            root.deleteChildByTagKey(key);
            String newXml = DesignIOMetaUtil.getXml(root);

            IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
            for (MetaFormProfile metaFormProfile : factory.getMetaFormList()) {
                globalInstance.getMetaFormList().remove(metaFormProfile.getKey());
            }
            for (MetaDataObjectProfile metaDataObjectProfile : factory.getDataObjectList()) {
                globalInstance.getDataObjectList().remove(metaDataObjectProfile.getKey());
            }
            for (KeyPairMetaObject keyPairMetaObject : factory.getCustomList()) {
                globalInstance.getCustomList().remove(keyPairMetaObject);
            }
            for (MetaDataMigrationProfile metaDataMigrationProfile : factory.getDataMigrationList()) {
                globalInstance.getDataMigrationList().remove(metaDataMigrationProfile.getKey());
            }
            for (MetaDataMapProfile metaDataMapProfile : factory.getDataMapList()) {
                globalInstance.getDataMapList().remove(metaDataMapProfile.getKey());
            }
            for (MetaReportSubList metaReportProfiles : factory.getMetaReportList()) {
                globalInstance.getMetaReportList().remove(metaReportProfiles.getKey());
            }
            for (MetaExcelTemplateSubList metaExcelTemplateProfiles : factory.getMetaExcelTemplateList()) {
                globalInstance.getMetaExcelTemplateList().remove(metaExcelTemplateProfiles.getKey());
            }
            for (MetaFormProfile metaFormProfile : factory.getExtFormList()) {
                globalInstance.getExtFormList().remove(metaFormProfile.getKey());
            }
            File file = new File(designerImportSolutionsPath);
            FileUtils.writeStringToFile(file, newXml, "UTF-8");
            result.add(UICommand.reloadFileTree(solutionPath));
            result.add(UICommand.showTip("解决方案删除成功"));
        }
    }
}
