package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.apache.commons.lang3.StringUtils;

import java.util.Stack;

/**
 * 取文件内容
 */
public class GetReMakeXmlFileCountCmd extends DesignerServiceCmd {

	public static final String CMD = "GetReMakeXmlFileCountCmd";

	private String Key;

	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		Key = (String) arguments.get("Key");
	}

	@Override
	public Object innerDoCmd(DefaultContext context) throws Throwable {
		String filePath = LoadFileTree.getPathByFormKey(Key);
		if (StringUtils.isEmpty(filePath)) {
			filePath = LoadFileTree.getDataMigrationPathByKey(Key);
			if (StringUtils.isEmpty(filePath)) {
				filePath = LoadFileTree.getBPMPathByKey(Key);
				if (StringUtils.isEmpty(filePath)) {
					filePath = LoadFileTree.getPathByDataObject(Key);
					if (StringUtils.isEmpty(filePath)) {
						filePath = LoadFileTree.getDataMapPathByKey(Key);
						if (StringUtils.isEmpty(filePath)) {
							return null;
						}
					}
				}
			}
		}
		Stack<String> stack = XmlFileProcessor.reFilePathToTmpFileMap.get(filePath);
		if (stack != null) {
			return stack.size();
		} else {
			return 0;
		}
	}

	@Override
	public String getCmd() {
		return CMD;
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new GetReMakeXmlFileCountCmd();
	}
}
